/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.gui.CSVDataSourceConnectionEditor;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRCSVDataSourceConnection
extends IReportConnection
implements WizardFieldsProvider {
    private String name;
    private String recordDelimiter = "\n";
    private String fieldDelimiter = ",";
    private boolean useFirstRowAsHeader = false;
    private String customDateFormat = "";
    private String filename;
    private Vector columnNames = new Vector();

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public boolean isJDBCConnection() {
        return false;
    }

    @Override
    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Filename", Misc.nvl(this.getFilename(), ""));
        map.put("recordDelimiter", Misc.nvl(Misc.addSlashesString(this.getRecordDelimiter()), "\n"));
        map.put("fieldDelimiter", Misc.nvl(Misc.addSlashesString(this.getFieldDelimiter()), ""));
        map.put("useFirstRowAsHeader", Misc.nvl("" + this.isUseFirstRowAsHeader(), ""));
        map.put("customDateFormat", Misc.nvl(this.getCustomDateFormat(), ""));
        for (int i = 0; i < this.getColumnNames().size(); ++i) {
            map.put("COLUMN_" + i, (String)this.getColumnNames().elementAt(i));
        }
        return map;
    }

    @Override
    public void loadProperties(HashMap map) {
        String recordDelimiterStr;
        this.setFilename((String)map.get("Filename"));
        String fieldDelimiterStr = (String)map.get("fieldDelimiter");
        if (fieldDelimiterStr != null) {
            this.setFieldDelimiter(Misc.removeSlashesString(fieldDelimiterStr));
        }
        if ((recordDelimiterStr = (String)map.get("recordDelimiter")) != null) {
            this.setRecordDelimiter(Misc.removeSlashesString(recordDelimiterStr));
        }
        this.setUseFirstRowAsHeader(((String)map.get("useFirstRowAsHeader")).equals("true"));
        this.setCustomDateFormat((String)map.get("customDateFormat"));
        int i = 0;
        while (map.containsKey("COLUMN_" + i)) {
            this.getColumnNames().add(map.get("COLUMN_" + i));
            ++i;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JRDataSource getJRDataSource() {
        try {
            JRCsvDataSource ds = new JRCsvDataSource(new File(this.getFilename()));
            if (this.getCustomDateFormat() != null && this.getCustomDateFormat().length() > 0) {
                ds.setDateFormat((DateFormat)new SimpleDateFormat(this.getCustomDateFormat()));
            }
            ds.setFieldDelimiter(this.getFieldDelimiter().charAt(0));
            ds.setRecordDelimiter(this.getRecordDelimiter());
            ds.setUseFirstRowAsHeader(this.isUseFirstRowAsHeader());
            if (!this.isUseFirstRowAsHeader()) {
                String[] names = new String[this.getColumnNames().size()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = "" + this.getColumnNames().elementAt(i);
                }
                ds.setColumnNames(names);
            }
            return ds;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.getJRDataSource();
        }
    }

    public boolean isUseFirstRowAsHeader() {
        return this.useFirstRowAsHeader;
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getCustomDateFormat() {
        return this.customDateFormat;
    }

    public void setCustomDateFormat(String customDateFormat) {
        this.customDateFormat = customDateFormat;
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(Vector columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public String getDescription() {
        return "File CSV datasource";
    }

    @Override
    public IReportConnectionEditor getIReportConnectionEditor() {
        return new CSVDataSourceConnectionEditor();
    }

    @Override
    public void test() throws Exception {
        String csv_file = this.getFilename();
        try {
            JRCSVDataSourceConnection con = new JRCSVDataSourceConnection();
            File f = new File(csv_file);
            if (!f.exists()) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("File {0} not found", new Object[]{csv_file}), "Error", 0);
                return;
            }
            con.setFilename(csv_file);
            if (con.getJRDataSource() != null) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            return;
        }
    }

    @Override
    public String getQueryLanguage() {
        return null;
    }

    @Override
    public List<JRDesignField> readFields(String query) throws Exception {
        ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
        Vector names = this.getColumnNames();
        for (int nd = 0; nd < names.size(); ++nd) {
            String fieldName = "" + names.elementAt(nd);
            JRDesignField field = new JRDesignField();
            field.setName(fieldName);
            field.setValueClassName("java.lang.String");
            fields.add(field);
        }
        return fields;
    }

    @Override
    public boolean supportsDesign() {
        return false;
    }

    @Override
    public String designQuery(String query) {
        return query;
    }
}

