/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.sheet.GenericProperty;
import com.jaspersoft.ireport.designer.tools.PropertyHint;
import com.jaspersoft.ireport.designer.tools.PropertyHintListCellRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.JRExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRPropertyDialog
extends JDialog {
    GenericProperty tmpField = null;
    ExpressionEditorArea expressionArea = null;
    private List<GenericProperty> properties = null;
    private String originalName = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanelExpression;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionArea.setExpressionContext(expressionContext);
    }

    public JRPropertyDialog(Frame parent, boolean modal) {
        this(parent, modal, false);
    }

    public JRPropertyDialog(Frame parent, boolean modal, boolean canUseExpression) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.jCheckBox1.setSelected(false);
        this.jCheckBox1.setVisible(canUseExpression);
        this.expressionArea = new ExpressionEditorArea();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new PropertyHintListCellRenderer());
        this.addHints();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void addHints() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.truncate.at.char", I18n.getString("JRPropertyDialog.List.Prop1")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.truncate.suffix", I18n.getString("JRPropertyDialog.List.Prop2")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.print.keep.full.text", I18n.getString("JRPropertyDialog.List.Prop3")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.text.measurer.factory", I18n.getString("JRPropertyDialog.List.Prop4")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.chart.theme", I18n.getString("JRPropertyDialog.List.Prop11") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.h1", I18n.getString("JRPropertyDialog.List.Prop14") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.h2", I18n.getString("JRPropertyDialog.List.Prop15") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.h3", I18n.getString("JRPropertyDialog.List.Prop16") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.table", I18n.getString("JRPropertyDialog.List.Prop17") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.tr", I18n.getString("JRPropertyDialog.List.Prop22") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.th", I18n.getString("JRPropertyDialog.List.Prop18") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.td", I18n.getString("JRPropertyDialog.List.Prop19") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.colspan", I18n.getString("JRPropertyDialog.List.Prop20") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.rowspan", I18n.getString("JRPropertyDialog.List.Prop21") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.id", I18n.getString("JRPropertyDialog.List.html.id") + I18n.getString("JRPropertyDialog.List.html.id.value")));
    }

    public void addExporterHints() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.character.encoding", "Default: UTF-8"));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.graphics2d.min.job.size", I18n.getString("JRPropertyDialog.List.Prop5") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.frames.as.nested.tables", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.remove.empty.space.between.rows", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.white.page.background", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.wrap.break.word", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.size.unit", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultPx")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.html.using.images.to.align", I18n.getString("JRPropertyDialog.List.Prop6") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.force.svg.shapes", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.force.linebreak.policy", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.compressed", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.encrypted", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.128.bit.key", I18n.getString("JRPropertyDialog.List.Prop7") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.create.custom.palette", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.one.page.per.sheet", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.white.page.background", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.detect.cell.type", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.size.fix.enabled", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.ignore.graphics", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.collapse.row.span", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.ignore.cell.border", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xls.max.rows.per.sheet", I18n.getString("JRPropertyDialog.List.Prop8") + I18n.getString("JRPropertyDialog.List.Default0")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.xml.validation", I18n.getString("JRPropertyDialog.List.Prop9") + I18n.getString("JRPropertyDialog.List.DefaultTrue")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.csv.field.delimiter", I18n.getString("JRPropertyDialog.List.Prop10") + I18n.getString("JRPropertyDialog.List.Default")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.csv.record.delimiter", I18n.getString("JRPropertyDialog.List.Prop10") + I18n.getString("JRPropertyDialog.List.Default1")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tagged", I18n.getString("JRPropertyDialog.List.Prop12") + I18n.getString("JRPropertyDialog.List.DefaultFalse")));
        dlm.addElement(new PropertyHint("net.sf.jasperreports.export.pdf.tag.language", I18n.getString("JRPropertyDialog.List.Prop13") + I18n.getString("JRPropertyDialog.List.DefaultNull")));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jPanelExpression = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle(I18n.getString("JRPropertyDialog.Title.AddModProperty"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRPropertyDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(I18n.getString("JRPropertyDialog.Label.PropName"));
        this.jLabel1.setMaximumSize(new Dimension(1000, 100));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jCheckBox1.setText(I18n.getString("JRPropertyDialog.CheckBox.UseExp"));
        this.jCheckBox1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JRPropertyDialog.this.jCheckBox1StateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jCheckBox1, gridBagConstraints);
        this.jLabel4.setText(I18n.getString("JRPropertyDialog.Label.PropVal"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jPanelExpression.setMinimumSize(new Dimension(10, 50));
        this.jPanelExpression.setLayout(new BorderLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(200, 40));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 40));
        this.jTextAreaDescription.setMinimumSize(new Dimension(0, 64));
        this.jTextAreaDescription.setPreferredSize(new Dimension(0, 64));
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jPanelExpression.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanelExpression, gridBagConstraints);
        this.jLabel5.setText(I18n.getString("JRPropertyDialog.Label.SpecialProp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JRPropertyDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(200, 35));
        this.jPanel1.setPreferredSize(new Dimension(250, 35));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(I18n.getString("Global.Button.Ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText(I18n.getString("Global.Button.Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 515) / 2, (screenSize.height - 358) / 2, 515, 358);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRPropertyDialog.Message.Warning"), I18n.getString("JRPropertyDialog.Message.Warning2"), 2);
            return;
        }
        if (this.getProperties() != null) {
            String name = this.jTextFieldName.getText().trim();
            for (GenericProperty prop : this.getProperties()) {
                if (!prop.getKey().equals(name) || this.originalName != null && this.originalName.equals(name)) continue;
                JOptionPane.showMessageDialog(this, I18n.getString("JRPropertyDialog.Message.warning3"), I18n.getString("JRPropertyDialog.Message.Warning4"), 2);
                return;
            }
        }
        this.tmpField = new GenericProperty();
        this.tmpField.setKey(this.jTextFieldName.getText().trim());
        this.tmpField.setUseExpression(this.jCheckBox1.isSelected());
        if (this.jCheckBox1.isSelected()) {
            this.tmpField.setValue(Misc.createExpression("java.lang.String", this.expressionArea.getText()));
        } else {
            this.tmpField.setValue(this.jTextAreaDescription.getText());
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jList1.getSelectedValue() != null && this.jList1.getSelectedValue() instanceof PropertyHint) {
            PropertyHint hint = (PropertyHint)this.jList1.getSelectedValue();
            this.jTextFieldName.setText(hint.getPropertyName());
        }
    }

    private void jCheckBox1StateChanged(ChangeEvent evt) {
        this.updateExpressionPanel();
    }

    public static void main(String[] args) {
        new JRPropertyDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public GenericProperty getProperty() {
        return this.tmpField;
    }

    public void setProperty(GenericProperty tmpField) {
        this.jTextFieldName.setText(tmpField.getKey());
        if (!tmpField.isUseExpression()) {
            this.jTextAreaDescription.setText("" + tmpField.getValue());
        }
        this.expressionArea.setText(Misc.getExpressionText((JRExpression)tmpField.getExpression()));
        this.jCheckBox1.setSelected(tmpField.isUseExpression());
        this.originalName = tmpField.getKey();
        this.updateExpressionPanel();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
    }

    private void updateExpressionPanel() {
        this.jPanelExpression.removeAll();
        if (this.jCheckBox1.isSelected()) {
            this.jPanelExpression.add((Component)this.expressionArea, "Center");
            if (this.jScrollPane1.getBorder() != null) {
                this.jPanelExpression.setBorder(this.jScrollPane1.getBorder());
            }
        } else {
            this.jPanelExpression.add((Component)this.jScrollPane1, "Center");
            this.jPanelExpression.setBorder(null);
        }
        this.jPanelExpression.updateUI();
    }

    public List<GenericProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GenericProperty> properties) {
        this.properties = properties;
    }
}

