/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.breadcrumb;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;

public class BreadCrumbRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        BreadCrumb breadCrumb = (BreadCrumb)component;
        this.encodeScript(facesContext, breadCrumb);
        this.encodeMarkup(facesContext, breadCrumb);
    }

    private void encodeScript(FacesContext facesContext, BreadCrumb breadCrumb) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = breadCrumb.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {");
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).jBreadCrumb({");
        writer.write("overlayClass:'pf-breadCrumb-chevron'");
        if (!breadCrumb.isPreview()) {
            int childCount = breadCrumb.getChildCount();
            writer.write(",endElementsToLeaveOpen:" + childCount);
            writer.write(",beginingElementsToLeaveOpen:" + childCount);
        } else {
            if (breadCrumb.getExpandedEndItems() != 1) {
                writer.write(",endElementsToLeaveOpen:" + breadCrumb.getExpandedEndItems());
            }
            if (breadCrumb.getExpandedBeginningItems() != 1) {
                writer.write(",beginingElementsToLeaveOpen:" + breadCrumb.getExpandedBeginningItems());
            }
        }
        if (breadCrumb.getPreviewWidth() != 5) {
            writer.write(",previewWidth:" + breadCrumb.getPreviewWidth());
        }
        if (breadCrumb.getExpandEffectDuration() != 800) {
            writer.write(",timeExpansionAnimation:" + breadCrumb.getExpandEffectDuration());
        }
        if (breadCrumb.getCollapseEffectDuration() != 500) {
            writer.write(",timeCompressionAnimation:" + breadCrumb.getCollapseEffectDuration());
        }
        if (breadCrumb.getInitialCollapseEffectDuration() != 600) {
            writer.write(",timeInitialCollapse:" + breadCrumb.getInitialCollapseEffectDuration());
        }
        writer.write("});");
        writer.write("});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, BreadCrumb breadCrumb) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = breadCrumb.getClientId(facesContext);
        String styleClass = breadCrumb.getStyleClass() == null ? "pf-breadCrumb pf-module" : "pf-breadCrumb pf-module " + breadCrumb.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (breadCrumb.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadCrumb.getStyle(), null);
        }
        writer.startElement("ul", null);
        for (UIComponent child : breadCrumb.getChildren()) {
            if (!child.isRendered() || !(child instanceof MenuItem)) continue;
            MenuItem menuItem = (MenuItem)child;
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)menuItem.getUrl(), null);
            if (menuItem.getTarget() != null) {
                writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
            }
            if (menuItem.getOnclick() != null) {
                writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
            }
            if (menuItem.getLabel() != null) {
                writer.write(menuItem.getLabel());
            }
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

