/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.component.captcha.Verification;
import org.primefaces.util.MessageFactory;

public class CaptchaValidator
implements Validator {
    public static final String INVALID_MESSAGE_ID = "org.primefaces.component.captcha.CaptchaValidator.INVALID";
    private static final String PRIVATE_KEY_PARAM = "org.primefaces.component.captcha.PRIVATE_KEY";

    public void validate(FacesContext facesContext, UIComponent component, Object value) throws ValidatorException {
        String result = null;
        Verification verification = (Verification)value;
        try {
            URL url = new URL("http://api-verify.recaptcha.net/verify");
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String postBody = this.createPostParameters(facesContext, verification);
            OutputStream out = conn.getOutputStream();
            out.write(postBody.getBytes());
            out.flush();
            out.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            result = rd.readLine();
            rd.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        boolean isValid = Boolean.valueOf(result);
        if (!isValid) {
            Object[] params = new Object[]{MessageFactory.getLabel(facesContext, component), verification.getAnswer()};
            throw new ValidatorException(MessageFactory.getMessage(INVALID_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params));
        }
    }

    private String createPostParameters(FacesContext facesContext, Verification verification) throws UnsupportedEncodingException {
        String challenge = verification.getChallenge();
        String answer = verification.getAnswer();
        String remoteAddress = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getRemoteAddr();
        String privateKey = facesContext.getExternalContext().getInitParameter(PRIVATE_KEY_PARAM);
        StringBuffer postParams = new StringBuffer();
        postParams.append("privatekey=" + URLEncoder.encode(privateKey, "UTF-8"));
        postParams.append("&remoteip=" + URLEncoder.encode(remoteAddress, "UTF-8"));
        postParams.append("&challenge=" + URLEncoder.encode(challenge, "UTF-8"));
        postParams.append("&response=" + URLEncoder.encode(answer, "UTF-8"));
        return postParams.toString();
    }
}

