/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.resource.ResourceUtils;

public class CoreRenderer
extends Renderer {
    private static final String WIDGET_VAR_SUFFIX = "_widget";

    protected void renderScriptDependency(FacesContext facesContext, String scriptPath) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)ResourceUtils.getResourceURL(facesContext, scriptPath), null);
        writer.endElement("script");
    }

    protected void renderCSSDependency(FacesContext facesContext, String cssPath) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("href", (Object)ResourceUtils.getResourceURL(facesContext, cssPath), null);
        writer.endElement("link");
    }

    protected void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected String getActionURL(FacesContext facesContext) {
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
        return facesContext.getExternalContext().encodeResourceURL(actionURL);
    }

    protected String getResourceURL(FacesContext facesContext, String url) {
        String resourceURL = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, url);
        return facesContext.getExternalContext().encodeResourceURL(resourceURL);
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected String createUniqueWidgetVar(FacesContext facesContext, UIComponent component) {
        String widgetVar = (String)component.getAttributes().get("widgetVar");
        if (widgetVar != null) {
            return widgetVar;
        }
        String formattedClientId = component.getClientId(facesContext).replaceAll(":", "_");
        String variableName = formattedClientId + WIDGET_VAR_SUFFIX;
        return facesContext.getExternalContext().encodeNamespace(variableName);
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public String getEscapedClientId(String clientId) {
        return clientId.replaceAll(":", "\\\\\\\\:");
    }
}

