/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils {
    private static String TRINIDAD_FORM_FAMILY = "org.apache.myfaces.trinidad.Form";

    public static UIComponent findComponentById(FacesContext context, UIComponent root, String id) {
        UIComponent component = null;
        for (int i = 0; i < root.getChildCount() && component == null; ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            component = ComponentUtils.findComponentById(context, child, id);
        }
        if (root.getId() != null && component == null && root.getId().equals(id)) {
            component = root;
        }
        return component;
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component) {
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(facesContext, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(facesContext.getELContext())) != null && (converterForType = facesContext.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        ValueHolder valueHolder = (ValueHolder)component;
        Converter converter = valueHolder.getConverter();
        if (converter != null) {
            return converter.getAsString(facesContext, component, value);
        }
        ValueExpression expr = component.getValueExpression("value");
        if (expr != null) {
            Class valueType = expr.getType(facesContext.getELContext());
            Converter converterForType = facesContext.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
        }
        return value.toString();
    }

    public static boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof UIForm) {
                return parent;
            }
            if (!parent.getFamily().equals(TRINIDAD_FORM_FAMILY)) continue;
            return parent;
        }
        return null;
    }

    public static void decorateAttribute(UIComponent component, String attribute, String value) {
        String attributeValue = (String)component.getAttributes().get(attribute);
        if (attributeValue != null) {
            if (attributeValue.indexOf(value) == -1) {
                String decoratedValue = attributeValue + ";" + value;
                component.getAttributes().put(attribute, decoratedValue);
            }
        } else {
            component.getAttributes().put(attribute, value);
        }
    }

    public static List<SelectItem> createSelectItems(UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem selectItem = (UISelectItem)child;
                items.add(new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object selectItems = ((UISelectItems)child).getValue();
            if (selectItems instanceof SelectItem[]) {
                SelectItem[] itemsArray;
                for (SelectItem item : itemsArray = (SelectItem[])selectItems) {
                    items.add(new SelectItem(item.getValue(), item.getLabel()));
                }
                continue;
            }
            if (!(selectItems instanceof Collection)) continue;
            Collection collection = (Collection)selectItems;
            for (SelectItem item : collection) {
                items.add(new SelectItem(item.getValue(), item.getLabel()));
            }
        }
        return items;
    }

    public static String escapeJQueryId(String id) {
        return "#" + id.replaceAll(":", "\\\\:");
    }
}

