/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.outline;

import jp.sf.propdev.PropDevPlugin;
import jp.sf.propdev.actions.FilterCommentAction;
import jp.sf.propdev.actions.ToggleLinkWithEditorAction;
import jp.sf.propdev.actions.ToggleSortOutlineAction;
import jp.sf.propdev.editors.PropertiesEditor;
import jp.sf.propdev.model.AbstractNode;
import jp.sf.propdev.model.CommentNode;
import jp.sf.propdev.model.KeyNode;
import jp.sf.propdev.model.PropertiesNode;
import jp.sf.propdev.utils.ImageCache;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PropertiesContentOutlinePage
extends ContentOutlinePage {
    private CommentFilter fCommentFilter;
    protected IDocumentProvider fDocumentProvider;
    private boolean fFilterComment;
    private boolean fSort = false;
    protected PropertiesEditor fTextEditor;
    ImageCache imageCache;
    private boolean linkingEnabled = false;
    private ViewerSorter vwSorter;
    private Object fInput;

    public PropertiesContentOutlinePage(IDocumentProvider provider, PropertiesEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        this.imageCache = new ImageCache(PropDevPlugin.getDefault().getBundle().getEntry("/"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setInput(this.fInput);
        IPageSite site = this.getSite();
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        tbm.add((IAction)new FilterCommentAction(this));
        tbm.add((IAction)new ToggleSortOutlineAction(this));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new ToggleLinkWithEditorAction(this));
    }

    public void dispose() {
        if (this.imageCache != null) {
            this.imageCache.dispose();
        }
        super.dispose();
    }

    private ViewerFilter getCommentFilter() {
        if (this.fCommentFilter == null) {
            this.fCommentFilter = new CommentFilter();
        }
        return this.fCommentFilter;
    }

    public boolean getFilterComment() {
        return this.fFilterComment;
    }

    public ImageCache getImageCache() {
        return this.imageCache;
    }

    private ViewerSorter getSorter() {
        if (this.vwSorter == null) {
            this.vwSorter = new ViewerSorter();
        }
        return this.vwSorter;
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public boolean isSort() {
        return this.fSort;
    }

    private void setFilter(boolean filter, ViewerFilter viewerFilter) {
        if (filter) {
            this.getTreeViewer().addFilter(viewerFilter);
        } else {
            this.getTreeViewer().removeFilter(viewerFilter);
        }
        this.getTreeViewer().refresh();
    }

    public void setFilterComment(boolean filter) {
        this.fFilterComment = filter;
        this.setFilter(filter, this.getCommentFilter());
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setLinkingEnabled(boolean linkingEnabled) {
        this.linkingEnabled = linkingEnabled;
    }

    public void setSort(boolean sort) {
        this.fSort = sort;
        if (this.fSort) {
            this.getTreeViewer().setSorter(this.getSorter());
        } else {
            this.getTreeViewer().setSorter(null);
        }
    }

    public void syncedWithEditor(AbstractNode curNode) {
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)curNode), true);
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)this.fTextEditor.getPropertiesModel());
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    private class CommentFilter
    extends ViewerFilter {
        CommentFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof CommentNode);
        }
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String SEGMENTS = "__java_segments";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__java_segments");

        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof PropertiesNode) {
                return ((PropertiesNode)element).getOutlineModel().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            if (element instanceof PropertiesNode) {
                return ((PropertiesNode)element).getOutlineModel().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractNode) {
                return ((AbstractNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PropertiesNode;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class PropertiesLabelProvider
    extends LabelProvider {
        protected PropertiesLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CommentNode) {
                return PropertiesContentOutlinePage.this.imageCache.get("icons/comment_obj.gif");
            }
            if (element instanceof KeyNode) {
                return PropertiesContentOutlinePage.this.imageCache.get("icons/key_obj.gif");
            }
            return super.getImage(element);
        }
    }
}

