<?php
class datasets_conf extends myQuicty {

// initialize

function init($datasets_id) {
	$this->init_field_define();
	$this->dsn = array();
	$this->data_sets = array();

	$datasets = $this->new_data_set('datasets');
	$dataset = $datasets->select_table('where id='.$datasets_id);
	$this->datasets_id = $dataset[0]['id'];
	
	foreach($dataset[0] as $key=>$value) {
		if($value) 
			switch($key) {
				case 'system':
					$this->dsn['system'] = $value;
					break;
				case 'dbname':
					$this->dsn['dbname'] = $value;
					break;
				case 'name':
					$this->dsn['dataname'] = $value;
					break;
				case 'title':
					$this->dsn['title'] = $value;
					break;
				case 'path':
					$this->dsn['path'] = $value;
					break;
				case 'host':
					$this->dsn['host'] = $value;
					break;
				case 'port':
					$this->dsn['port'] = $value;
					break;
				case 'user':
					$this->dsn['user'] = $value;
					break;
				case 'password':
					$this->dsn['password'] = $value;
					break;
				case 'persistent':
					$this->dsn['persistent'] = $value;
					break;
				case 'init_when_build':
					$this->dsn['init_when_build'] = $value;
					break;
		}
		if(!$dataset[0]['persistent']) {
			$this->dsn['persistent'] = 0;
		}
	}
	
	$applications = $this->new_data_set('application');
	$application = $applications->select_table('where id='.$dataset[0]['application_id']);
	$this->application = $application[0];
	$this->application_path = $this->application['application_root'];

	$fields = $this->new_data_set('fields');
	$this->fieldset = $fields->select_table('where datasets_id='.$datasets_id.' order by seq');
	foreach($this->fieldset as $field) {
		$properties = unserialize($field['properties']);
		if($field['virtual']) $properties['virtual'] = 'yes';
		
		if($field['search_flag']) {
			$properties['search_flag'] = 'yes';
			$this->search_columns[$field['name']] = array(
				'label'=>$field['label'],
				'type'=>$field['hqf_type'],
				'properties'=>$properties,
				);
		}

		if($field['sort_flag']) {
			$properties['sort_flag'] = 'yes';
			$this->sort_columns[$field['name']] = array(
				'label'=>$field['label'],
				'type'=>$field['hqf_type'],
				'properties'=>$properties,
				);
		}
		
		$this->data_sets[] = $properties;
	}

	$this->system = $this->dsn['system'];
	$this->db_name = $this->dsn['dbname'];
	if($this->dsn['path']) {
		$this->db_path = $this->application_path.'/'.$this->dsn['path'];
		if(!file_exists($this->db_path)) {
			umask(0);
			make_dir($this->db_path,0777);
		}
		$this->db_set = $this->db_path.'/'.$this->db_name;
	} else {
		$this->db_set = $this->db_name;
	}
	$this->data_name = $this->dsn['dataname'];

}

}
?>