<?php
class configure_options extends myQuicty {

//-----------------------------------------------------------------
// pre dispatch options

public function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	return true;
}


//-----------------------------------------------------------------
// list options

function assign_search_form() {
	$search_form = $this->new_search_obj('configure_search',array('action'=>$this->page['base_url'].'/configure/','method'=>'get'));
	$this->assign_form('search_form',$search_form);
}

function make_select_fields() {
	$select_system = array(
		'configure'=>'*', // specify all column
		//'configure'=>array('id','name','url'), // specify each column
		//'configure'=>array('id'=>'configure_id'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}

function make_where_condition() {
	$search_system = array(
		'keyword'=>array('title'=>'configure.name','url'=>'configure.url'), // keyword search target column
		'condition'=>array('id'=>'configure.id') // id search target column
		);
	return $this->list->make_condition($search_system);
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by id desc',
		'colums'=>array('id','name','url') // sort keys
		);
	return $this->list->make_order($sort_system);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	//$join_condition = "left join {table_name} on configure.id={table_name}.configure_id";
	return $join_condition;
}

//-----------------------------------------------------------------
// display options

function set_form_options() {
	$tmp_path = explode(DIRECTORY_SEPARATOR,realpath($this->home_dir));
	$dmy = array_pop($tmp_path);
	$qt_applictions_root = implode('/',$tmp_path);
	$quicty_root = $qt_applictions_root.'/Quicty';
	$mysql_host = 'localhost';
	$mysql_port = '3306';
	$pgsql_host = 'localhost';
	$pgsql_port = '5432';
	$this->form->setDefaults(
			array(
				'quicty_root'=>$quicty_root,'qt_applictions_root'=>$qt_applictions_root,
				'mysql_host'=>$mysql_host,'mysql_port'=>$mysql_port,
				'pgsql_host'=>$pgsql_host,'pgsql_port'=>$pgsql_port,
				)
			);
	$this->form->set_base_link_addr(quicty_base_url().'/configure/');
	$this->form->set_restart_link_addr(quicty_base_url().'/configure/');
	$this->form->set_button_status('use_confirm',false);
}

function set_form_filters() {
	$this->form->applyFilter('_ALL_','trim');
}

function post_form_process() {
	switch($this->QuictyStatus) {
		case 'INSERT':
		case 'UPDATE':
		case 'DELETE':
			redirect('/');
			break;
		case 'BROWSE':
			break;
		default:
	}
}



} // end of configure_options class
?>