<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotSupportedException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalStateException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalArgumentException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotConnectionException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criteria.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.9
 */
class DbUtil{
	var $connection		= false;
	var $resultset		= array();
	var $dbUtil			= null;

	function DbUtil($dbConnection,$new=true){
		$this->_setDatabase($dbConnection->type);

		if($this->database == "MYSQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilMySQL.php")){
				$this->dbUtil = new DbUtilMySQL();
			}
		}else if($this->database == "POSTGRESQL"){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilPostgreSQL.php")){
				$this->dbUtil = new DbUtilPostgreSQL();
			}
		}else if($this->database == "OCI8" && substr(phpversion(),0,1) >= 5){
			if(require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilOci8.php")){
				$this->dbUtil = new DbUtilOci8();
			}
		}
		if($this->dbUtil == null){
			ExceptionTrigger::raise(new NotSupportedException(Message::_("database controler [{1}]",$dbConnection->type)));
		}else{
			$this->_open($dbConnection,$new);
		}
	}
	function _open($dbConnection,$new){
		if(!$this->connection){
			$this->close();
		}
		$this->connection = $this->dbUtil->open($dbConnection,$new);

		if($this->connection){
			register_shutdown_function(array($this,'commit'));
			register_shutdown_function(array($this,'close'));
			return true;
		}
		ExceptionTrigger::raise(new NotConnectionException(Message::_("database")));			
		return false;
	}
	function close(){
		if($this->connection){
			$this->dbUtil->close();
			$this->connection = false;
		}
	}
	function commit(){
		if($this->connection){
			$this->dbUtil->commit();
		}
	}
	function rollback(){
		if($this->connection){
			$this->dbUtil->rollback();
		}
	}
	function query($sql){
		if($this->connection){
			return $this->dbUtil->query($sql);
		}
		return false;
	}
	function select($tableObjectList,$criteria=null){
		if($this->connection){
			if(!is_array($tableObjectList)){
				$tableObjectList = array($tableObjectList);
			}			
			foreach($tableObjectList as $tableObject){
				if(!Variable::isClassType(TableObjectBase,$tableObject)){
					ExceptionTrigger::raise(new ClassTypeException(Message::_("first argument")));
					return false;
				}
			}
			if(empty($criteria)){
				$criteria = new Criteria();
			}			
			$this->dbUtil->select($tableObjectList,$criteria);

			return $this->_getResultsetToObject($tableObjectList);
		}
		return array();
	}
	function count($tableObject,$criteria=null){
		if($this->connection){
			if(!Variable::isClassType(TableObjectBase,$tableObject)){
				ExceptionTrigger::raise(new ClassTypeException(Message::_("first argument")));
				return false;
			}
			if(!empty($criteria)){
				if(!Variable::isClassType(Criteria,$criteria)){
					ExceptionTrigger::raise(new ClassTypeException(Message::_("second argument")));
					return false;
				}
			}else{
				$criteria = new Criteria();
			}
			return $this->dbUtil->count(array($tableObject),$criteria);
		}
		return 0;
	}
	function get($tableObject,$criteria=null){
		if($this->connection){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if($criteria != null){
					if(!Variable::isClassType(Criteria,$criteria)){
						ExceptionTrigger::raise(new ClassTypeException(Message::_("second argument")));
						return false;
					}
				}else{
					$criteria		= new Criteria();
					$primaryList		= $tableObject->__primaryKey();
					
					if(sizeof($primaryList) > 0){
						foreach($primaryList as $column){
							$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
		
							if(empty($value)){
								ExceptionTrigger::raise(new IllegalArgumentException($column->variable));
							}
							$criteria->add($column,$value);
						}
					}else{
						foreach($tableObject->__columns() as $column){
							$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
							$criteria->add($column,$value);
						}
					}
				}
				$criteria->setOffset(0);
				$criteria->setLimit(1);
				$list = $this->select($tableObject,$criteria);

				if(sizeof($list) > 0){
					return $list[0];
				}
			}
		}
		return null;
	}
	function insert($tableObject,$criteria=null){
		if($this->connection){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if(!$tableObject->__verify()){
					return false;
				}
				if($criteria != null && $criteria->verifyFK){
					if(!$this->_verifyFk($tableObject)){
						return false;
					}
				}
				return $this->dbUtil->insert($tableObject,$criteria);
			}
		}
		return false;
	}
	function delete($tableObject,$criteria=null){
		if($this->connection){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if($criteria != null){
					if(!Variable::isClassType(Criteria,$criteria)){
						ExceptionTrigger::raise(new ClassTypeException(Message::_("second argument")));
						return false;
					}
				}else{
					$criteria = new Criteria();

					foreach($tableObject->__primaryKey() as $column){
						$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
						
						if(empty($value)){
							ExceptionTrigger::raise(new IllegalArgumentException($column->variable));
						}
						$criteria->add($column,$value);
					}
				}
				if($criteria != null && $criteria->verifyFK){
					if($this->_verifyDepend($tableObject)){
						if($this->dbUtil->delete($tableObject,$criteria)){
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	function alldelete($tableObject){
		if($this->connection){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if($this->dbUtil->delete($tableObject)){
					return true;
				}
			}
		}
		return false;
	}
	function update($tableObject,$criteria=null){
		if($this->connection){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				if($criteria != null){
					if(!Variable::isClassType(Criteria,$criteria)){
						ExceptionTrigger::raise(new ClassTypeException(Message::_("second argument")));
						return false;
					}
				}else{
					$criteria = new Criteria();
	
					foreach($tableObject->__primaryKey() as $column){
						$value = call_user_func_array(array(&$tableObject,sprintf("get%s",$column->variable)),array());
						
						if(empty($value)){
							ExceptionTrigger::raise(new IllegalArgumentException($column->variable));
						}
						$criteria->add($column,$value);
					}
				}
				if(!$tableObject->__verify()){
					return false;
				}
				if($criteria->verifyFK && !$this->_verifyFk($tableObject)){
					return false;
				}
				return $this->dbUtil->update($tableObject,$criteria);
			}
		}
		return false;
	}
	function analyze($tableObjectList){
		$this->dbUtil->analyze($tableObjectList);
	}
	function optimize($tableObjectList){
		$this->dbUtil->optimize($tableObjectList);
	}
	function next(){
		if($this->connection){
			$this->resultset = array();
			$resultset		= $this->dbUtil->resultset();
				
			if(!$resultset){
				$this->dbUtil->free();
				return false;
			}
			$this->resultset = $this->dbUtil->parseResultset($resultset);
			return true;
		}
		return false;
	}
	function getResultset(){
		return $this->resultset;
	}
	function _getResultsetToObject($tableObjectList){
		$objectList	= array();		
		$setterList	= array();
		$tableList	= array();
		$listOrder	= array();
		$counter		= 0;

		foreach($tableObjectList as $tableObject){
			$tableAlias = "";

			foreach($tableObject->__columns() as $column){
				$tableAlias = $column->table->alias;
				$setterList[$column->table->alias][$column->column] = sprintf("set%s",$column->variable);
			}
			$tableList[$tableAlias]	= $tableObject;	
			$listOrder[$tableAlias]	= $counter++;
		}
		while($this->next()){
			foreach($tableList as $tableAlias => $tableObject){
				$newobject = Variable::copy($tableObject);
		
				foreach($this->getResultset() as $key => $value){
					$value		= Variable::getMagicQuotesOffValue($value);
					$splitPos	= strpos($key,"__");
					$columnName	= substr($key,($splitPos + 2));

					if(substr($key,0,$splitPos) == $tableAlias && isset($setterList[$tableAlias][$columnName])){
						call_user_func_array(array(&$newobject,$setterList[$tableAlias][$columnName]),array($value));
					}
				}
				$objectList[$listOrder[$tableAlias]][] = $newobject;				
			}
		}		
		if(sizeof($objectList) == 1){
			foreach($objectList as $object){
				return $object;
			}
		}
		return $objectList;
	}
	function _setDatabase($database){
		if(preg_match("/(postgre)|(psql)/i",$database)){
			$this->database = "POSTGRESQL";
		}else if(preg_match("/my/i",$database)){
			$this->database = "MYSQL";
		}else if(preg_match("/(oracle)|(oci8)/i",$database)){
			$this->database = "OCI8";
		}
	}
	function _verifyFk($tableObject){
		foreach(get_class_methods($tableObject) as $methodName){
			if(preg_match("/^criteria(.+)$/i",$methodName)){
				if(0 >= $this->count($tableObject,call_user_func_array(array(&$tableObject, $methodName),array()))){
					ExceptionTrigger::raise(new IllegalArgumentException($methodName));
					return false;
				}
			}
		}
		return true;
	}
	function _verifyDepend($tableObject){	
		foreach(get_class_methods($tableObject) as $methodName){
			if(preg_match("/^depend(.+)$/i",$methodName)){
				$dependList = call_user_func_array(array(&$tableObject, $methodName),array());
				
				foreach($dependList as $depend){
					$verifyTableObject	= $depend[0];
					$verifyFkCriteria	= $depend[1];

					if(0 < $this->count($verifyTableObject,$verifyFkCriteria)){
						ExceptionTrigger::raise(new IllegalArgumentException($methodName));
						return false;
					}
				}
			}
		}
		return true;
	}
	function combineTableObject($tableObjectList,$column){
		if(!is_array($tableObjectList) || !Variable::isClassType(Column,$column)){
			return $tableObjectList;
		}
		$hash	= array();
		$getter	= strtolower(sprintf("get%s",$column->variable));	

		foreach($tableObjectList as $tableObject){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				foreach(get_class_methods($tableObject) as $methodName){			
					if(strtolower($methodName) == $getter){
						$hash[call_user_func_array(array(&$tableObject,$methodName),array())] = $tableObject;
						break;
					}
				}
			}
		}
		return $hash;
	}
	function extractionTableColumn($tableObjectList,$column){
		if(!is_array($tableObjectList) || !Variable::isClassType(Column,$column)){
			return $tableObjectList;
		}
		$hash	= array();
		$list	= array();
		$getter	= strtolower(sprintf("get%s",$column->variable));	

		foreach($tableObjectList as $tableObject){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				foreach(get_class_methods($tableObject) as $methodName){			
					if(strtolower($methodName) == $getter){
						$variable = call_user_func_array(array(&$tableObject,$methodName),array());
						$hash[$variable] = $variable;
						break;
					}
				}
			}
		}
		return $hash;
	}
}
?>