<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/DbUtilBase.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.9
 */
class DbUtilMySQL extends DbUtilBase{
	function open($dbConnection,$new=true){
		if(extension_loaded("mysql")){
			$host = sprintf("%s:3306",$dbConnection->host);

			if($dbConnection->port != ""){
				$host = sprintf("%s:%d",$dbConnection->host,$dbConnection->port);
			}
			$this->connection = @mysql_connect(
										$host,
										$dbConnection->user,
										$dbConnection->password,
										$new
								);
			if($this->connection != false){
				if(!mysql_select_db($dbConnection->name)){
					$this->connection = false;
					return false;
				}
				$this->query("SET AUTOCOMMIT=1");
				$this->_begin();
				$this->dbConnection = $dbConnection;				
				return true;
			}
		}
		return false;
	}
	function close(){
		$this->_commit();
		if($this->connection){
			mysql_close($this->connection);
		}
		$this->connection = false;
	}
	function query($sql){
		if($this->connection){
			Logger::debug(Message::_("[{1}] {2}",$this->connection,$sql));
	
			$this->resourceId	= mysql_query($sql,$this->connection);
			$errono				= mysql_errno($this->connection);
			$error				= mysql_error($this->connection);
	
			if(!empty($errono) || !empty($error)){
				Logger::error(Message::_("#{1} - {2}",$errono,$error));
				return false;	
			}
			return true;
		}
		return false;
	}
	function analyze($tableObjectList){
		$tables = "";
		
		foreach(Variable::toArray($tableObjectList) as $tableObject){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				foreach($tableObject->__columns() as $columnObject){
					$tables .= ",".$columnObject->table->name;
					break;
				}
			}
			if(!empty($tables)){
				$this->query("analyze table ".substr($tables,1));
			}
		}
	}
	function optimize($tableObjectList){
		$tables = "";
		
		foreach(Variable::toArray($tableObjectList) as $tableObject){
			if(Variable::isClassType(TableObjectBase,$tableObject)){
				foreach($tableObject->__columns() as $columnObject){
					$tables .= ",".$columnObject->table->name;
					break;
				}
			}
			if(!empty($tables)){
				$this->query("optimize table ".substr($tables,1));
			}
		} 
	}
	function resultset(){
		if($this->resourceId != false){
			return mysql_fetch_array($this->resourceId);
		}
		return array();
	}
	function free(){
		if($this->resourceId != false){
			mysql_free_result($this->resourceId);
		}
	}
	function _getSelectString($columnList){
		$columnString = "";
		
		foreach($columnList as $column){
			$columnAlias	= sprintf("%s",$column->column);
			$columnName	= sprintf("%s.%s",$column->table->alias,$column->column);

			if($column->type == "TIMESTAMP"){
				$columnName = sprintf("DATE_FORMAT(%s.%s,'%%Y/%%m/%%d %%H:%%i:%%S')",$column->table->alias,$column->column);
			}else if($column->type == "DATE"){
				$columnName = sprintf("DATE_FORMAT(%s.%s,'%%Y/%%m/%%d')",$column->table->alias,$column->column);
			}
			$columnString .= sprintf("%s as %s__%s,",$columnName,$column->table->alias,$columnAlias);
		}
		return substr($columnString,0,-1);
	}
	function _insertId($tableObject){
		unset($tableObject);
		return mysql_insert_id($this->connection);
	}
	function _escape($value){
		if(extension_loaded("mysql")){
			return mysql_escape_string($value);
		}
		return addslashes($value);
	}
}
?>