<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/database/DatabaseModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/database/TableModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/database/ColumnModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/database/ReferenceColumnModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/database/TableModelDefault.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.6
 */
class DatabaseColumnParser{
	function _dbforward($database,$dbUtil){	
		$sql = "";
	
		if(Variable::isClassType(DatabaseModel,$database) && Variable::isClassType(ExtDbUtil,$dbUtil)){
			if($dbUtil->connection){
				$sql	 .= $dbUtil->forward($database);
			}
		}
		return $sql;
	}

	function parseDatabsse($databaseTag,$databaseModelList){
		$dbClass	= $databaseTag->getParameter("class",$databaseTag->getParameter("name"));

		if(is_array($databaseModelList)){
			foreach($databaseModelList as $key => $databaseModel){
				if($key == $dbClass){
					$databaseModel->class		= $dbClass;
					$databaseModel->method	= $this->_getMethodName($dbClass);

					foreach($databaseTag->getIn("table") as $tableTag){
						$table = $this->_parseTable($tableTag,$databaseModel->prefix);
						$databaseModel->tableList[$table->class] = $table;
					}
					foreach($databaseModel->tableList as $class => $table){
						if(is_array($table->referenceList)){
							foreach($table->referenceList as $key => $reference){
								$databaseModel->tableList[$class]->referenceList[$key]->referenceTableReal = $this->_getReferenceTableReal($reference,$databaseModel->tableList);
								$databaseModel->tableList[$class]->importLibraryList[$reference->methodReferenceTable] = $reference->methodReferenceTable;
							}
							foreach($table->referenceList as $key => $reference){
								$databaseModel->tableList[$reference->referenceClass]->dependColumnList[$reference->methodReferenceColumn][] = $reference;
								$databaseModel->tableList[$reference->referenceClass]->importLibraryList[$reference->methodTable] = $reference->methodTable;
							}
						}
					}
					foreach($databaseTag->getIn("default") as $tableTag){
						$tableName	= strtoupper($tableTag->getParameter("class",$tableTag->getParameter("name")));
						$counter		= 0;
									
						if(!isset($databaseModel->tableList[$tableName])){
							ExceptionTrigger::raise(new NotFoundException($tableName));
						}else{
							foreach($tableTag->getIn("data") as $dataTag){
								$databaseModel->tableList[$tableName]->defaultList[$counter] = array();
			
								foreach($dataTag->getIn("column") as $columnTag){
									$columnName	= strtoupper($columnTag->getParameter("name"));
									$value		= $columnTag->getParameter("value");

									if(!isset($databaseModel->tableList[$tableName]->columnList[$columnName])){
										ExceptionTrigger::raise(new NotFoundException($columnName));							
									}else{
										if(empty($value)){
											$value = $columnTag->getValue();
										}
										$databaseModel->tableList[$tableName]->defaultList[$counter][] = new TableModelDefault($columnName,$value);
									}
								}
								$counter++;
							}
						}
					}
					return $databaseModel;					
				}
			}
		}
		ExceptionTrigger::raise(new NotFoundException($dbClass));
		return false;
	}
	function readDatabsse($databaseTag){
		$src						= $databaseTag->getPlain();
		$databaseModel			= new DatabaseModel();

		$databaseModel->class		= $databaseTag->getParameter("class",$databaseTag->getParameter("name"));	
		
		if(empty($databaseModel->class)){
			ExceptionTrigger::raise(new NotFoundException(Message::_("DB name")));
			return false;
		}
		$databaseModel->name		= Rhaco::define(sprintf("DATABASE_%s_NAME",$databaseModel->class),$databaseTag->getParameter("name"));		
		$databaseModel->user		= Rhaco::define(sprintf("DATABASE_%s_USER",$databaseModel->class),$databaseTag->getParameter("user"));
		$databaseModel->host		= Rhaco::define(sprintf("DATABASE_%s_HOST",$databaseModel->class),$databaseTag->getParameter("host"));		
		$databaseModel->password	= Rhaco::define(sprintf("DATABASE_%s_PASSWORD",$databaseModel->class),$databaseTag->getParameter("password"));
		$databaseModel->port		= Rhaco::define(sprintf("DATABASE_%s_PORT",$databaseModel->class),$databaseTag->getParameter("port"));
		$databaseModel->encode	= Rhaco::define(sprintf("DATABASE_%s_ENCODE",$databaseModel->class),$databaseTag->getParameter("encode"));
		$databaseModel->type		= Rhaco::define(sprintf("DATABASE_%s_TYPE",$databaseModel->class),$databaseTag->getParameter("type"));
		$databaseModel->prefix	= Rhaco::define(sprintf("DATABASE_%s_PREFIX",$databaseModel->class));

		if(empty($databaseModel->prefix)){
			$databaseModel->prefix = substr(strtoupper($databaseModel->class),0,3)."_";
		}
		foreach($databaseTag->getIn("table") as $intag){
			$src = str_replace($intag->getPlain(),"",$src);
		}
		foreach($databaseTag->getIn("default") as $intag){
			$src = str_replace($intag->getPlain(),"",$src);
		}
		$tag = new SimpleTag();
		$tag->set($src,"database");
		
		foreach($tag->getIn("description") as $intag){
			$databaseModel->description = Message::_(trim($intag->getValue()));
			break;
		}
		foreach($databaseTag->getIn("table") as $tableTag){
			$table = $this->_parseTable($tableTag,$databaseModel->prefix);
			$databaseModel->tableList[$table->class] = $table;
		}
		return $databaseModel;
	}
	
	function _getReferenceTableReal($reference,$tableList){
		foreach($tableList as $class => $table){
			if($reference->referenceClass == $class){
				if(is_array($table->columnList)){
					foreach($table->columnList as $column){
						if($reference->referenceColumn == $column->name){								
							return $table->getTableName();
						}
					}
					break;
				}
			}
		}
		ExceptionTrigger::raise(new NotFoundException($reference->referenceClass));
		return "";
	}

	function _parseTable($tableTag,$prefix=""){
		$table				= new TableModel();
		$name				= trim($tableTag->getParameter("name"));
		$table->name			= strtoupper($name);
		$table->prefix		= strtoupper($prefix);		
		$table->class		= strtoupper(trim($tableTag->getParameter("class",$name)));				
		$table->method		= $this->_getMethodName($table->class);
		$table->primaryList	= array();
		$table->columnList	= array();
		$table->referenceList	= array();
		
		foreach($tableTag->getIn("column") as $inTag){
			$column = $this->_parseColumn($inTag,$table->primaryList);
			$table->columnList[$column->name] = $column;
		}
		foreach($tableTag->getIn("reference") as $inTag){
			$reference				= $this->_parseReferenceColumn($inTag);
			$reference->table		= $table->getTableName();
			$reference->methodTable	= $table->method;
			$bool					= false;
						
			foreach($table->columnList as $column){
				if($column->name == $reference->column){
					$bool = true;
					break;
				}
			}
			if(!$bool){
				ExceptionTrigger::raise(new NotFoundException($reference->column));
			}else{
				$table->referenceList[$reference->column] = $reference;
			}
		}
		return $table;
	}
	function _parseColumn($columnTag,&$primaryList){
		$column				= new ColumnModel();
		$column->name		= strtoupper(trim($columnTag->getParameter("name")));
		$column->type		= $this->_getType($columnTag->getParameter("type"));
		$column->primary		= Variable::getBoolean($columnTag->getParameter("primary","false"));
		$column->default		= $columnTag->getParameter("default","null");
		$column->size		= $this->_getSize($columnTag->getParameter("size"));
		$column->require		= Variable::getBoolean($columnTag->getParameter("require","false"));
		$column->variable	= $this->_getVariableName($column->name);
		$column->method		= $this->_getMethodName($column->name);
		$column->formatset();
		
		if($column->primary){
			$column->require = true;
			$primaryList[$column->name] = $column;
		}
		return $column;
	}
	function _parseReferenceColumn($columnTag){
		$reference						= new ReferenceColumnModel();
		$reference->column				= trim($columnTag->getParameter("column"));
		$reference->referenceClass		= trim($columnTag->getParameter("referenceClass"));
		$reference->referenceColumn		= trim($columnTag->getParameter("referenceColumn"));
		$reference->methodReferenceTable	= $this->_getMethodName($reference->referenceClass);
		$reference->methodReferenceColumn	= $this->_getMethodName($reference->referenceColumn);
		$reference->methodColumn			= $this->_getMethodName($reference->column);
		$reference->referenceTableReal	= $reference->referenceClass;

		return $reference;
	}
	function _getMethodName($value){
		$method = "";
		
		foreach(split("_",$value) as $name){
			$method = $method.ucwords(strtolower($name));
		}
		return trim($method);
	}
	function _getVariableName($value){
		$value = $this->_getMethodName($value);
		return strtolower(substr($value,0,1)).substr($value,1);
	}
	function _getSize($value){
		$size = preg_replace("/[^0-9]/","",$value);
		return intval($size);
	}
	function _getType($value){
		if(preg_match("/str/i",$value)){
			return "STRING";
		}else if(preg_match("/text/i",$value)){
			return "TEXT";
		}else if(preg_match("/email/i",$value)){
			return "EMAIL";
		}else if(preg_match("/tel/i",$value)){
			return "TEL";
		}else if(preg_match("/zip/i",$value)){
			return "ZIP";
		}else if(preg_match("/int/i",$value)){
			return "INTEGER";
		}else if(preg_match("/float/i",$value)){
			return "FLOAT";
		}else if(preg_match("/date/i",$value)){
			return "DATE";
		}else if(preg_match("/timestamp/i",$value)){
			return "TIMESTAMP";
		}else if(preg_match("/time/i",$value)){
			return "TIME";
		}else if(preg_match("/serial/i",$value)){
			return "SERIAL";
		}else if(preg_match("/bool/i",$value)){
			return "BOOLEAN";
		}
		ExceptionTrigger::raise(new NotFoundException(Message::_("column type [{1}]",$value)));
		return false;
	}
}
?>