<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class UnitBench{
	var $method = null;
	var $startTime = 0;
	var $endTime = 0;
		
	function UnitBench(){
		$this->bench();
	}

	function setUp(){
		$this->startTime	= 0;
		$this->endTime		= 0;

		$time = gettimeofday();
		$this->startTime = $time["usec"];
	}
    function tearDown(){
		$time = gettimeofday();
		$this->endTime = $time["usec"];

		$benchTime = ($this->endTime - $this->startTime) / 1000;
		
		Logger::debug(sprintf("(%s) %s ms",$this->method,$benchTime));
	}
	function bench(){
		$className = strtolower(get_class($this));

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^bench(.+)$/",$methodName)){
				if($className != strtolower($methodName)){
					$this->method = $methodName;

					$this->setUp();
					ob_start();
					call_user_func(array($this,$methodName));
					ob_end_clean();					
					$this->tearDown();
				}
			}
		}
	}
}
?>