/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.util.Map;
import jp.sf.amateras.mirage.exception.OgnlRuntimeException;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlException;

public class OgnlUtil {
    protected OgnlUtil() {
    }

    public static Object getValue(Object exp, Object root) {
        return OgnlUtil.getValue(exp, root, null, 0);
    }

    public static Object getValue(Object exp, Object root, String path, int lineNumber) {
        return OgnlUtil.getValue(exp, null, root, path, lineNumber);
    }

    public static Object getValue(Object exp, Map ctx, Object root) {
        return OgnlUtil.getValue(exp, ctx, root, null, 0);
    }

    public static Object getValue(Object exp, Map ctx, Object root, String path, int lineNumber) throws RuntimeException {
        try {
            return Ognl.getValue((Object)exp, (Object)root);
        }
        catch (OgnlException ex) {
            throw new OgnlRuntimeException(ex.getReason() == null ? ex : ex.getReason(), path, lineNumber);
        }
        catch (Exception ex) {
            throw new OgnlRuntimeException(ex, path, lineNumber);
        }
    }

    public static Object parseExpression(String expression) {
        return OgnlUtil.parseExpression(expression, null, 0);
    }

    public static Object parseExpression(String expression, String path, int lineNumber) throws RuntimeException {
        try {
            return Ognl.parseExpression((String)expression);
        }
        catch (Exception ex) {
            throw new OgnlRuntimeException(ex, path, lineNumber);
        }
    }

    public static class ClassResolverImpl
    implements ClassResolver {
        private final ClassLoader classLoader;

        public ClassResolverImpl(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Class classForName(String className, Map ctx) throws ClassNotFoundException {
            try {
                return this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                int dot = className.indexOf(46);
                if (dot < 0) {
                    return this.classLoader.loadClass("java.lang." + className);
                }
                throw ex;
            }
        }
    }
}

