/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.liftweb.json.JsonParser;
import scala.ScalaObject;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JsonParser$Segments$
implements ScalaObject {
    public static final JsonParser$Segments$ MODULE$;
    private int segmentSize;
    private final int maxNumOfSegments;
    private AtomicInteger segmentCount;
    private final ArrayBlockingQueue<JsonParser.Segment> segments;

    static {
        new JsonParser$Segments$();
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public void segmentSize_$eq(int n) {
        this.segmentSize = n;
    }

    public void clear() {
        this.segments.clear();
    }

    public JsonParser.Segment apply() {
        JsonParser.Segment s = this.acquire();
        return s == null ? new JsonParser.DisposableSegment(new char[this.segmentSize]) : s;
    }

    private JsonParser.Segment acquire() {
        int curCount = this.segmentCount.get();
        boolean createNew = this.segments.size() == 0 && curCount < this.maxNumOfSegments ? this.segmentCount.compareAndSet(curCount, curCount + 1) : false;
        return createNew ? new JsonParser.RecycledSegment(new char[this.segmentSize]) : this.segments.poll();
    }

    public Object release(JsonParser.Segment s) {
        Object object;
        if (s instanceof JsonParser.RecycledSegment) {
            boolean bl = this.segments.offer(s);
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public JsonParser$Segments$() {
        MODULE$ = this;
        this.segmentSize = 1000;
        this.maxNumOfSegments = 10000;
        this.segmentCount = new AtomicInteger(0);
        this.segments = new ArrayBlockingQueue(this.maxNumOfSegments);
    }
}

