/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorBuilder;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.parser.m2.PomReader$PomDependencyData;
import org.apache.ivy.plugins.parser.m2.PomReader$PomPluginElement;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public final class PomModuleDescriptorParser
implements ModuleDescriptorParser {
    private static final PomModuleDescriptorParser INSTANCE = new PomModuleDescriptorParser();

    public static PomModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private PomModuleDescriptorParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void toIvyFile(InputStream inputStream, Resource resource, File file2, ModuleDescriptor moduleDescriptor) {
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, file2);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public final boolean accept(Resource resource) {
        return resource.getName().endsWith(".pom") || resource.getName().endsWith("pom.xml") || resource.getName().endsWith("project.xml");
    }

    public final String toString() {
        return "pom parser";
    }

    public final Artifact getMetadataArtifact(ModuleRevisionId moduleRevisionId, Resource resource) {
        return DefaultArtifact.newPomArtifact(moduleRevisionId, new Date(resource.getLastModified()));
    }

    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, boolean bl) {
        URLResource uRLResource = new URLResource(uRL);
        return this.parseDescriptor(parserSettings, uRL, uRLResource, bl);
    }

    public final ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) {
        PomModuleDescriptorBuilder pomModuleDescriptorBuilder;
        block34: {
            pomModuleDescriptorBuilder = new PomModuleDescriptorBuilder(this, resource, parserSettings);
            try {
                Object object;
                Object object2;
                Iterator iterator;
                Object object3;
                Object object4;
                Object object5;
                PomReader pomReader = new PomReader(uRL, resource);
                pomReader.setProperty("parent.version", pomReader.getParentVersion());
                pomReader.setProperty("parent.groupId", pomReader.getParentGroupId());
                pomReader.setProperty("project.parent.version", pomReader.getParentVersion());
                pomReader.setProperty("project.parent.groupId", pomReader.getParentGroupId());
                Object object6 = pomReader.getPomProperties().entrySet().iterator();
                while (object6.hasNext()) {
                    object5 = object6.next();
                    pomReader.setProperty((String)object5.getKey(), (String)object5.getValue());
                    pomModuleDescriptorBuilder.addProperty((String)object5.getKey(), (String)object5.getValue());
                }
                object6 = null;
                if (pomReader.hasParent()) {
                    object5 = ModuleRevisionId.newInstance(pomReader.getParentGroupId(), pomReader.getParentArtifactId(), pomReader.getParentVersion());
                    object4 = PomModuleDescriptorParser.parseOtherPom(parserSettings, (ModuleRevisionId)object5);
                    if (object4 == null) {
                        throw new IOException("Impossible to load parent for " + resource.getName() + "." + " Parent=" + object5);
                    }
                    object6 = ((ResolvedModuleRevision)object4).getDescriptor();
                    if (object6 != null) {
                        object3 = PomModuleDescriptorBuilder.extractPomProperties(object6.getExtraInfo()).entrySet().iterator();
                        while (object3.hasNext()) {
                            iterator = object3.next();
                            pomReader.setProperty((String)iterator.getKey(), (String)iterator.getValue());
                        }
                    }
                }
                object5 = pomReader.getGroupId();
                object4 = pomReader.getArtifactId();
                String string = pomReader.getVersion();
                pomModuleDescriptorBuilder.setModuleRevId((String)object5, (String)object4, string);
                pomModuleDescriptorBuilder.setHomePage(pomReader.getHomePage());
                pomModuleDescriptorBuilder.setDescription(pomReader.getDescription());
                pomModuleDescriptorBuilder.setLicenses(pomReader.getLicenses());
                object3 = pomReader.getRelocation();
                if (object3 != null) {
                    if (object5 != null && object4 != null && ((String)object4).equals(((ModuleRevisionId)object3).getName()) && ((String)object5).equals(((ModuleRevisionId)object3).getOrganisation())) {
                        Message.error("Relocation to an other version number not supported in ivy : " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " relocated to " + object3 + ". Please update your dependency to directly use the right version.");
                        Message.warn("Resolution will only pick dependencies of the relocated element.  Artefact and other metadata will be ignored.");
                        iterator = PomModuleDescriptorParser.parseOtherPom(parserSettings, (ModuleRevisionId)object3);
                        if (iterator == null) {
                            throw new ParseException("impossible to load module " + object3 + " to which " + pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " has been relocated", 0);
                        }
                        DependencyDescriptor[] dependencyDescriptorArray = ((ResolvedModuleRevision)((Object)iterator)).getDescriptor().getDependencies();
                        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                            pomModuleDescriptorBuilder.addDependency(dependencyDescriptorArray[i]);
                        }
                    } else {
                        Message.info(pomModuleDescriptorBuilder.getModuleDescriptor().getModuleRevisionId() + " is relocated to " + object3 + ". Please update your dependencies.");
                        Message.verbose("Relocated module will be considered as a dependency");
                        iterator = new DefaultDependencyDescriptor(pomModuleDescriptorBuilder.getModuleDescriptor(), (ModuleRevisionId)object3, true);
                        Configuration[] configurationArray = PomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
                        for (int i = 0; i < configurationArray.length; ++i) {
                            if (!Configuration$Visibility.PUBLIC.equals(configurationArray[i].getVisibility())) continue;
                            ((DefaultDependencyDescriptor)((Object)iterator)).addDependencyConfiguration(configurationArray[i].getName(), configurationArray[i].getName());
                        }
                        pomModuleDescriptorBuilder.addDependency((DependencyDescriptor)((Object)iterator));
                    }
                    break block34;
                }
                pomReader.setProperty("project.groupId", (String)object5);
                pomReader.setProperty("pom.groupId", (String)object5);
                pomReader.setProperty("groupId", (String)object5);
                pomReader.setProperty("project.artifactId", (String)object4);
                pomReader.setProperty("pom.artifactId", (String)object4);
                pomReader.setProperty("artifactId", (String)object4);
                pomReader.setProperty("project.version", string);
                pomReader.setProperty("pom.version", string);
                pomReader.setProperty("version", string);
                if (object6 != null) {
                    pomModuleDescriptorBuilder.addExtraInfos(object6.getExtraInfo());
                    object2 = PomModuleDescriptorBuilder.getDependencyManagements((ModuleDescriptor)object6).iterator();
                    while (object2.hasNext()) {
                        pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object2.next());
                    }
                    object = PomModuleDescriptorBuilder.getPlugins((ModuleDescriptor)object6).iterator();
                    while (object.hasNext()) {
                        pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object.next());
                    }
                }
                iterator = pomReader.getDependencyMgt().iterator();
                while (iterator.hasNext()) {
                    object2 = (PomDependencyMgt)iterator.next();
                    if ("import".equals(object2.getScope())) {
                        object = ModuleRevisionId.newInstance(object2.getGroupId(), object2.getArtifactId(), object2.getVersion());
                        ResolvedModuleRevision resolvedModuleRevision = PomModuleDescriptorParser.parseOtherPom(parserSettings, (ModuleRevisionId)object);
                        if (resolvedModuleRevision != null) {
                            Iterator iterator2 = PomModuleDescriptorBuilder.getDependencyManagements(resolvedModuleRevision.getDescriptor()).iterator();
                            while (iterator2.hasNext()) {
                                pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)iterator2.next());
                            }
                            continue;
                        }
                        throw new IOException("Impossible to import module for " + resource.getName() + "." + " Import=" + object);
                    }
                    pomModuleDescriptorBuilder.addDependencyMgt((PomDependencyMgt)object2);
                }
                iterator = pomReader.getDependencies().iterator();
                while (iterator.hasNext()) {
                    object2 = (PomReader$PomDependencyData)iterator.next();
                    pomModuleDescriptorBuilder.addDependency$16c309e6((PomReader$PomDependencyData)object2);
                }
                if (object6 != null) {
                    for (int i = 0; i < object6.getDependencies().length; ++i) {
                        pomModuleDescriptorBuilder.addDependency(object6.getDependencies()[i]);
                    }
                }
                Iterator iterator3 = pomReader.getPlugins().iterator();
                while (iterator3.hasNext()) {
                    object2 = (PomReader$PomPluginElement)iterator3.next();
                    pomModuleDescriptorBuilder.addPlugin((PomDependencyMgt)object2);
                }
                pomModuleDescriptorBuilder.addMainArtifact((String)object4, pomReader.getPackaging());
                ParserSettings parserSettings2 = parserSettings;
                PomModuleDescriptorBuilder pomModuleDescriptorBuilder2 = pomModuleDescriptorBuilder;
                if (pomModuleDescriptorBuilder2.getMainArtifact() != null) {
                    ModuleRevisionId moduleRevisionId = pomModuleDescriptorBuilder2.getModuleDescriptor().getModuleRevisionId();
                    DependencyResolver dependencyResolver = parserSettings2.getResolver(moduleRevisionId);
                    if (dependencyResolver == null) {
                        Message.debug("no resolver found for " + moduleRevisionId + ": no source or javadoc artifact lookup");
                    } else {
                        ArtifactOrigin artifactOrigin = dependencyResolver.locate(pomModuleDescriptorBuilder2.getMainArtifact());
                        if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
                            ArtifactOrigin artifactOrigin2;
                            String string2 = artifactOrigin.getLocation();
                            ArtifactOrigin artifactOrigin3 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getSourceArtifact());
                            if (!ArtifactOrigin.isUnknown(artifactOrigin3) && !artifactOrigin3.getLocation().equals(string2)) {
                                Message.debug("source artifact found for " + moduleRevisionId);
                                pomModuleDescriptorBuilder2.addSourceArtifact();
                            } else {
                                artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getSrcArtifact());
                                if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string2)) {
                                    Message.debug("source artifact found for " + moduleRevisionId);
                                    pomModuleDescriptorBuilder2.addSrcArtifact();
                                } else {
                                    Message.debug("no source artifact found for " + moduleRevisionId);
                                }
                            }
                            artifactOrigin2 = dependencyResolver.locate(pomModuleDescriptorBuilder2.getJavadocArtifact());
                            if (!ArtifactOrigin.isUnknown(artifactOrigin2) && !artifactOrigin2.getLocation().equals(string2)) {
                                Message.debug("javadoc artifact found for " + moduleRevisionId);
                                pomModuleDescriptorBuilder2.addJavadocArtifact();
                            } else {
                                Message.debug("no javadoc artifact found for " + moduleRevisionId);
                            }
                        }
                    }
                }
            }
            catch (SAXException sAXException) {
                SAXException sAXException2 = sAXException;
                Message.error(((Throwable)sAXException).getMessage());
                ParseException parseException = new ParseException(((Throwable)sAXException2).getMessage(), 0);
                parseException.initCause(sAXException2);
                throw parseException;
            }
        }
        return pomModuleDescriptorBuilder.getModuleDescriptor();
    }

    private static ResolvedModuleRevision parseOtherPom(ParserSettings parserSettings, ModuleRevisionId moduleRevisionId) {
        Object object;
        DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true, 0);
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        if (resolveData == null) {
            object = IvyContext.getContext().getIvy().getResolveEngine();
            ResolveOptions resolveOptions = new ResolveOptions();
            resolveOptions.setDownload$5370cc5a();
            resolveData = new ResolveData((ResolveEngine)object, resolveOptions);
        }
        if ((object = parserSettings.getResolver(moduleRevisionId)) == null) {
            return null;
        }
        Namespace namespace = parserSettings.getContextNamespace();
        dependencyDescriptor = DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespace);
        return object.getDependency(dependencyDescriptor, resolveData);
    }
}

