/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class IBiblioResolver
extends URLResolver {
    private String root = null;
    private String pattern = null;
    private boolean usepoms = true;
    private boolean useMavenMetadata = true;

    public IBiblioResolver() {
        this.setChangingMatcher("regexp");
        this.setChangingPattern(".*-SNAPSHOT");
    }

    public final ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        if (this.isM2compatible() && this.usepoms) {
            ModuleRevisionId moduleRevisionId = IBiblioResolver.convertM2IdForResourceSearch(dependencyDescriptor.getDependencyRevisionId());
            if (dependencyDescriptor.getDependencyRevisionId().getRevision().endsWith("SNAPSHOT")) {
                ResolvedResource resolvedResource;
                ResolvedResource resolvedResource2;
                ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
                ResolveData resolveData2 = resolveData;
                DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
                IBiblioResolver iBiblioResolver = this;
                String string = iBiblioResolver.findSnapshotVersion(moduleRevisionId2);
                if (string != null) {
                    Message.verbose("[" + string + "] " + moduleRevisionId2);
                    String string2 = iBiblioResolver.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
                    resolvedResource2 = iBiblioResolver.findResourceUsingPattern(moduleRevisionId2, string2, DefaultArtifact.newPomArtifact(moduleRevisionId2, resolveData2.getDate()), iBiblioResolver.getRMDParser(dependencyDescriptor2, resolveData2), resolveData2.getDate());
                } else {
                    resolvedResource2 = resolvedResource = null;
                }
                if (resolvedResource2 != null) {
                    return resolvedResource;
                }
            }
            return this.findResourceUsingPatterns(moduleRevisionId, this.getIvyPatterns(), DefaultArtifact.newPomArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
        }
        return null;
    }

    protected final ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        this.ensureConfigured(this.getSettings());
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = IBiblioResolver.convertM2IdForResourceSearch(moduleRevisionId);
        }
        if (artifact.getId().getRevision().endsWith("SNAPSHOT") && this.isM2compatible()) {
            ResolvedResource resolvedResource;
            ResolvedResource resolvedResource2;
            ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
            Date date2 = date;
            Artifact artifact2 = artifact;
            IBiblioResolver iBiblioResolver = this;
            String string = iBiblioResolver.findSnapshotVersion(moduleRevisionId2);
            if (string != null) {
                String string2 = iBiblioResolver.getWholePattern().replaceFirst("\\-\\[revision\\]", "-" + string);
                resolvedResource2 = iBiblioResolver.findResourceUsingPattern(moduleRevisionId2, string2, artifact2, iBiblioResolver.getDefaultRMDParser(artifact2.getModuleRevisionId().getModuleId()), date2);
            } else {
                resolvedResource2 = resolvedResource = null;
            }
            if (resolvedResource2 != null) {
                return resolvedResource;
            }
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.getArtifactPatterns(), artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    /*
     * Exception decompiling
     */
    private String findSnapshotVersion(ModuleRevisionId var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void setM2compatible(boolean bl) {
        super.setM2compatible(bl);
        if (bl) {
            if (this.root == null) {
                this.root = "http://repo1.maven.org/maven2/";
            }
            if (this.pattern == null) {
                this.pattern = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
            }
            this.updateWholePattern();
        }
    }

    private void ensureConfigured(ResolverSettings resolverSettings) {
        if (resolverSettings != null && (this.root == null || this.pattern == null)) {
            String string;
            if (this.root == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                if (string != null) {
                    this.root = string;
                } else {
                    resolverSettings.configureRepositories(true);
                    this.root = resolverSettings.getVariable("ivy.ibiblio.default.artifact.root");
                }
            }
            if (this.pattern == null) {
                string = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                if (string != null) {
                    this.pattern = string;
                } else {
                    resolverSettings.configureRepositories(false);
                    this.pattern = resolverSettings.getVariable("ivy.ibiblio.default.artifact.pattern");
                }
            }
            this.updateWholePattern();
        }
    }

    private String getWholePattern() {
        return this.root + this.pattern;
    }

    public final void setRoot(String string) {
        if (string == null) {
            throw new NullPointerException("root must not be null");
        }
        this.root = !string.endsWith("/") ? string + "/" : string;
        this.ensureConfigured(this.getSettings());
        this.updateWholePattern();
    }

    private void updateWholePattern() {
        if (this.isM2compatible() && this.usepoms) {
            this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        } else {
            this.setIvyPatterns(Collections.EMPTY_LIST);
        }
        this.setArtifactPatterns(Collections.singletonList(this.getWholePattern()));
    }

    protected final ResolvedResource[] listResources(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        if (this.shouldUseMavenMetadata(string)) {
            Map map2 = moduleRevisionId.getModuleId().getAttributes();
            IBiblioResolver iBiblioResolver = this;
            Repository repository2 = repository;
            String string2 = IvyPatternHelper.substituteTokens(iBiblioResolver.root + "[organisation]/[module]/maven-metadata.xml", map2);
            List list = iBiblioResolver.listRevisionsWithMavenMetadata(repository2, string2);
            if (list != null) {
                Message.debug("\tfound revs: " + list);
                ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    String string4 = IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, string3), artifact);
                    try {
                        Resource resource = repository.getResource(string4);
                        if (resource == null || !resource.exists()) continue;
                        arrayList.add(new ResolvedResource(resource, string3));
                    }
                    catch (IOException iOException) {
                        Message.warn("impossible to get resource from name listed by maven-metadata.xml:" + arrayList + ": " + iOException.getMessage());
                    }
                }
                return arrayList.toArray(new ResolvedResource[arrayList.size()]);
            }
            return super.listResources(repository, moduleRevisionId, string, artifact);
        }
        return super.listResources(repository, moduleRevisionId, string, artifact);
    }

    /*
     * Exception decompiling
     */
    private List listRevisionsWithMavenMetadata(Repository var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldUseMavenMetadata(String string) {
        return this.useMavenMetadata && this.isM2compatible() && string.endsWith("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
    }

    public final String getTypeName() {
        return "ibiblio";
    }

    public final ResolvedModuleRevision getDependency(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        this.ensureConfigured(resolveData.getSettings());
        return super.getDependency(dependencyDescriptor, resolveData);
    }

    public final DownloadReport download(Artifact[] artifactArray, DownloadOptions downloadOptions) {
        this.ensureConfigured(this.getSettings());
        return super.download(artifactArray, downloadOptions);
    }

    public final ArtifactOrigin locate(Artifact artifact) {
        this.ensureConfigured(this.getSettings());
        return super.locate(artifact);
    }

    public final List getArtifactPatterns() {
        this.ensureConfigured(this.getSettings());
        return super.getArtifactPatterns();
    }

    public final void dumpSettings() {
        this.ensureConfigured(this.getSettings());
        super.dumpSettings();
        Message.debug("\t\troot: " + this.root);
        Message.debug("\t\tpattern: " + this.pattern);
        Message.debug("\t\tusepoms: " + this.usepoms);
        Message.debug("\t\tuseMavenMetadata: " + this.useMavenMetadata);
    }
}

