/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher$ExactOrRegexpMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import scala.collection.mutable.GrowingBuilder;

public final class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\+[^\\(]+)?(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\+[^\\(]+)?(\\(.*\\))?");
    private final ModuleRevisionId revId;
    private ModuleRevisionId dynamicRevId;
    private Map confs = new LinkedHashMap();
    private Map dependencyArtifacts;
    private Map includeRules;
    private Map excludeRules;
    private boolean isForce;
    private boolean isChanging;
    private ModuleRevisionId parentId;
    private boolean isTransitive = true;
    private Namespace namespace = null;
    private final ModuleDescriptor md;
    private ModuleRevisionId sourceModule;

    public static DependencyDescriptor transformInstance(DependencyDescriptor dependencyDescriptor, Namespace namespace) {
        NamespaceTransformer namespaceTransformer = namespace.getToSystemTransformer();
        if (namespaceTransformer.isIdentity()) {
            return dependencyDescriptor;
        }
        DefaultDependencyDescriptor defaultDependencyDescriptor = DefaultDependencyDescriptor.transformInstance$7d2b9993(dependencyDescriptor, namespaceTransformer);
        DefaultDependencyDescriptor.transformInstance$7d2b9993(dependencyDescriptor, namespaceTransformer).namespace = namespace;
        return defaultDependencyDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance$7d2b9993(DependencyDescriptor dependencyDescriptor, NamespaceTransformer namespaceTransformer) {
        String[] stringArray;
        ModuleRevisionId moduleRevisionId = namespaceTransformer.transform(dependencyDescriptor.getParentRevisionId());
        ModuleRevisionId moduleRevisionId2 = namespaceTransformer.transform(dependencyDescriptor.getDependencyRevisionId());
        ModuleRevisionId moduleRevisionId3 = namespaceTransformer.transform(dependencyDescriptor.getDynamicConstraintDependencyRevisionId());
        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(null, moduleRevisionId2, moduleRevisionId3, dependencyDescriptor.isForce(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive());
        new DefaultDependencyDescriptor(null, moduleRevisionId2, moduleRevisionId3, dependencyDescriptor.isForce(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive()).parentId = moduleRevisionId;
        ModuleRevisionId moduleRevisionId4 = dependencyDescriptor.getSourceModule();
        if (moduleRevisionId4 != null) {
            defaultDependencyDescriptor.sourceModule = namespaceTransformer.transform(moduleRevisionId4);
        }
        if ((stringArray = dependencyDescriptor.getModuleConfigurations()).length == 1 && "*".equals(stringArray[0])) {
            LinkedHashMap linkedHashMap;
            if (!(dependencyDescriptor instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            DefaultDependencyDescriptor defaultDependencyDescriptor2 = (DefaultDependencyDescriptor)dependencyDescriptor;
            defaultDependencyDescriptor.confs = new LinkedHashMap(defaultDependencyDescriptor2.confs);
            defaultDependencyDescriptor.excludeRules = linkedHashMap = new LinkedHashMap(defaultDependencyDescriptor2.getExcludeRules());
            linkedHashMap = new LinkedHashMap(defaultDependencyDescriptor2.getIncludeRules());
            defaultDependencyDescriptor.includeRules = linkedHashMap;
            linkedHashMap = new LinkedHashMap(defaultDependencyDescriptor2.getDependencyArtifacts());
            defaultDependencyDescriptor.dependencyArtifacts = linkedHashMap;
            return defaultDependencyDescriptor;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultDependencyDescriptor.confs.put(stringArray[i], new ArrayList<String>(Arrays.asList(dependencyDescriptor.getDependencyConfigurations(stringArray[i]))));
                defaultDependencyDescriptor.getExcludeRules().put(stringArray[i], new ArrayList<ExcludeRule>(Arrays.asList(dependencyDescriptor.getExcludeRules(stringArray[i]))));
                defaultDependencyDescriptor.getIncludeRules().put(stringArray[i], new ArrayList<IncludeRule>(Arrays.asList(dependencyDescriptor.getIncludeRules(stringArray[i]))));
                defaultDependencyDescriptor.getDependencyArtifacts().put(stringArray[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dependencyDescriptor.getDependencyArtifacts(stringArray[i]))));
            }
        }
        return defaultDependencyDescriptor;
    }

    private DefaultDependencyDescriptor(DefaultDependencyDescriptor defaultDependencyDescriptor, ModuleRevisionId moduleRevisionId) {
        GrowingBuilder.checkNotNull(defaultDependencyDescriptor, "dd");
        GrowingBuilder.checkNotNull(moduleRevisionId, "revision");
        if (!moduleRevisionId.getModuleId().equals(defaultDependencyDescriptor.revId.getModuleId())) {
            throw new IllegalArgumentException("new ModuleRevisionId MUST have the same ModuleId as original one. original = " + defaultDependencyDescriptor.revId.getModuleId() + " new = " + moduleRevisionId.getModuleId());
        }
        this.md = defaultDependencyDescriptor.md;
        this.parentId = defaultDependencyDescriptor.parentId;
        this.revId = moduleRevisionId;
        this.dynamicRevId = defaultDependencyDescriptor.dynamicRevId;
        this.isForce = defaultDependencyDescriptor.isForce;
        this.isChanging = defaultDependencyDescriptor.isChanging;
        this.isTransitive = defaultDependencyDescriptor.isTransitive;
        this.namespace = defaultDependencyDescriptor.namespace;
        this.confs.putAll(defaultDependencyDescriptor.confs);
        this.excludeRules = defaultDependencyDescriptor.excludeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.excludeRules);
        this.includeRules = defaultDependencyDescriptor.includeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.includeRules);
        this.dependencyArtifacts = defaultDependencyDescriptor.dependencyArtifacts == null ? null : new LinkedHashMap(defaultDependencyDescriptor.dependencyArtifacts);
        this.sourceModule = defaultDependencyDescriptor.sourceModule;
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, boolean bl) {
        this(moduleDescriptor, moduleRevisionId, moduleRevisionId, bl, false, true);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl, byte by) {
        this(moduleRevisionId, bl);
    }

    private DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl) {
        this(null, moduleRevisionId, moduleRevisionId, bl, false, true);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, boolean bl, boolean bl2, boolean bl3) {
        GrowingBuilder.checkNotNull(moduleRevisionId, "mrid");
        GrowingBuilder.checkNotNull(moduleRevisionId2, "dynamicConstraint");
        this.md = moduleDescriptor;
        this.revId = moduleRevisionId;
        this.dynamicRevId = moduleRevisionId2;
        this.isForce = bl;
        this.isChanging = bl2;
        this.isTransitive = bl3;
        this.sourceModule = moduleDescriptor == null ? null : moduleDescriptor.getModuleRevisionId();
    }

    public final ModuleId getDependencyId() {
        return this.revId.getModuleId();
    }

    public final ModuleRevisionId getDependencyRevisionId() {
        return this.revId;
    }

    public final ModuleRevisionId getDynamicConstraintDependencyRevisionId() {
        return this.dynamicRevId;
    }

    public final String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    public final String[] getDependencyConfigurations(String string) {
        return this.getDependencyConfigurations(string, string);
    }

    public final String[] getDependencyConfigurations(String string, String string2) {
        String string3;
        Object object;
        Object object2;
        if (this.md != null) {
            object2 = this.md.getConfiguration(string);
            if (object2 instanceof ConfigurationIntersection) {
                Object object3;
                Object object4;
                Collection collection;
                ConfigurationIntersection configurationIntersection = (ConfigurationIntersection)object2;
                HashSet<String> hashSet = new HashSet<String>();
                String[] stringArray = configurationIntersection.getIntersectedConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    collection = this.getDependencyConfigurationsIncludingExtending(stringArray[i], string2);
                    if (hashSet.isEmpty()) {
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (hashSet.contains("*")) {
                        hashSet.remove("*");
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (collection.contains("*")) continue;
                    object4 = hashSet;
                    hashSet = new HashSet();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        String string4 = (String)object3.next();
                        if (!collection.contains(string4)) continue;
                        hashSet.add(string4);
                    }
                }
                List list = (List)this.confs.get(string);
                if (list != null) {
                    hashSet.addAll(list);
                }
                if (hashSet.isEmpty() && (collection = (List)this.confs.get("*")) != null) {
                    object4 = collection.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        if (object3 != null && ((String)object3).startsWith("@+")) {
                            return new String[]{string + ((String)object3).substring(1)};
                        }
                        if (object3 == null || !((String)object3).equals("@")) continue;
                        return new String[]{string};
                    }
                }
                return hashSet.toArray(new String[hashSet.size()]);
            }
            if (object2 instanceof ConfigurationGroup) {
                ConfigurationGroup configurationGroup = (ConfigurationGroup)object2;
                HashSet hashSet = new HashSet();
                String[] stringArray = configurationGroup.getMembersConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    Collection collection = this.getDependencyConfigurationsIncludingExtending(stringArray[i], string2);
                    hashSet.addAll(collection);
                }
                return hashSet.toArray(new String[hashSet.size()]);
            }
        }
        if ((object2 = (List)this.confs.get(string)) == null) {
            object2 = (List)this.confs.get("%");
        }
        List list = (List)this.confs.get("*");
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet();
        if (object2 != null) {
            linkedHashSet.addAll((Collection<Object>)object2);
        }
        if (list != null) {
            linkedHashSet.addAll(list);
        }
        LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>();
        Object object5 = linkedHashSet.iterator();
        while (object5.hasNext()) {
            String string5;
            object = (String)object5.next();
            Object object6 = object;
            string3 = DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, (String)object6, string5 = string);
            if (string3 == null) {
                string5 = string2;
                object6 = object;
                string3 = DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, (String)object6, string5);
            }
            if (string3 != null) {
                object = string3;
            }
            linkedHashSet2.add(object);
        }
        linkedHashSet = linkedHashSet2;
        if (linkedHashSet.remove("*")) {
            object5 = new StringBuffer("*");
            object = linkedHashSet.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (!string3.startsWith("!")) continue;
                ((StringBuffer)object5).append(string3);
            }
            return new String[]{((StringBuffer)object5).toString()};
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private Collection getDependencyConfigurationsIncludingExtending(String string, String string2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(string, string2)));
        Iterator iterator = Configuration.findConfigurationExtending(string, this.md.getConfigurations()).iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(configuration.getName(), string2)));
        }
        return linkedHashSet;
    }

    private static String replaceFallbackConfigurationPattern(Pattern pattern, String string, String string2) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string3 = string2;
            if (matcher.group(1) != null) {
                string3 = string3 + matcher.group(1);
            }
            if (matcher.group(2) != null) {
                string3 = string3 + matcher.group(2);
            }
            return string3;
        }
        return null;
    }

    public final DependencyArtifactDescriptor[] getDependencyArtifacts(String string) {
        Set set = DefaultDependencyDescriptor.getCollectionForConfiguration(string, this.dependencyArtifacts);
        return set.toArray(new DependencyArtifactDescriptor[set.size()]);
    }

    public final IncludeRule[] getIncludeRules(String string) {
        Set set = DefaultDependencyDescriptor.getCollectionForConfiguration(string, this.includeRules);
        return set.toArray(new IncludeRule[set.size()]);
    }

    public final ExcludeRule[] getExcludeRules(String string) {
        Set set = DefaultDependencyDescriptor.getCollectionForConfiguration(string, this.excludeRules);
        return set.toArray(new ExcludeRule[set.size()]);
    }

    private static Set getCollectionForConfiguration(String string, Map map2) {
        if (map2 == null || map2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Collection collection = (Collection)map2.get(string);
        Collection collection2 = (Collection)map2.get("*");
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (collection != null) {
            linkedHashSet.addAll(collection);
        }
        if (collection2 != null) {
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    public final DependencyArtifactDescriptor[] getAllDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            return new DependencyArtifactDescriptor[0];
        }
        Set set = DefaultDependencyDescriptor.mergeAll(this.dependencyArtifacts);
        return set.toArray(new DependencyArtifactDescriptor[set.size()]);
    }

    public final IncludeRule[] getAllIncludeRules() {
        if (this.includeRules == null) {
            return new IncludeRule[0];
        }
        Set set = DefaultDependencyDescriptor.mergeAll(this.includeRules);
        return set.toArray(new IncludeRule[set.size()]);
    }

    public final ExcludeRule[] getAllExcludeRules() {
        if (this.excludeRules == null) {
            return new ExcludeRule[0];
        }
        Set set = DefaultDependencyDescriptor.mergeAll(this.excludeRules);
        return set.toArray(new ExcludeRule[set.size()]);
    }

    private static Set mergeAll(Map map2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            linkedHashSet.addAll(collection);
        }
        return linkedHashSet;
    }

    public final void addDependencyConfiguration(String string, String string2) {
        Object object;
        if (this.md != null && !"*".equals(string) && !"%".equals(string)) {
            object = string.startsWith("!") ? this.md.getConfiguration(string.substring(1)) : this.md.getConfiguration(string);
            if (object == null) {
                throw new IllegalArgumentException("Cannot add dependency '" + this.revId + "' to configuration '" + string + "' of module " + this.md.getModuleRevisionId() + " because this configuration doesn't exist!");
            }
            if (object instanceof ConfigurationGroup) {
                String[] stringArray = ((ConfigurationGroup)object).getMembersConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addDependencyConfiguration(stringArray[i], string2);
                }
                return;
            }
        }
        if ((object = (ArrayList<String>)this.confs.get(string)) == null) {
            object = new ArrayList<String>();
            this.confs.put(string, object);
        }
        if (!object.contains(string2)) {
            object.add(string2);
        }
    }

    public final void addDependencyArtifact(String string, DependencyArtifactDescriptor dependencyArtifactDescriptor) {
        DefaultDependencyDescriptor.addObjectToConfiguration(string, dependencyArtifactDescriptor, this.getDependencyArtifacts());
    }

    public final void addIncludeRule(String string, IncludeRule includeRule) {
        DefaultDependencyDescriptor.addObjectToConfiguration(string, includeRule, this.getIncludeRules());
    }

    public final void addExcludeRule(String string, ExcludeRule excludeRule) {
        DefaultDependencyDescriptor.addObjectToConfiguration(string, excludeRule, this.getExcludeRules());
    }

    private static void addObjectToConfiguration(String string, Object object, Map map2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map2.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map2.put(string, arrayList);
        }
        arrayList.add(object);
    }

    public final boolean doesExclude(String[] stringArray, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = DefaultPomDependencyMgt.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        String[] stringArray2 = stringArray;
        DefaultDependencyDescriptor defaultDependencyDescriptor = this;
        LinkedHashSet<ExcludeRule> linkedHashSet = new LinkedHashSet<ExcludeRule>();
        for (int i = 0; i < stringArray2.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(defaultDependencyDescriptor.getExcludeRules(stringArray2[i])));
        }
        ExcludeRule[] excludeRuleArray = linkedHashSet.toArray(new ExcludeRule[linkedHashSet.size()]);
        for (int i = 0; i < excludeRuleArray.length; ++i) {
            if (!ExactOrRegexpPatternMatcher$ExactOrRegexpMatcher.matches(excludeRuleArray[i].getMatcher(), excludeRuleArray[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    public final boolean canExclude() {
        return this.excludeRules != null && !this.excludeRules.isEmpty();
    }

    public final String toString() {
        return "dependency: " + this.revId + " " + this.confs;
    }

    public final boolean isForce() {
        return this.isForce;
    }

    public final ModuleRevisionId getParentRevisionId() {
        if (this.md != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        return this.parentId;
    }

    public final boolean isChanging() {
        return this.isChanging;
    }

    public final boolean isTransitive() {
        return this.isTransitive;
    }

    public final String getAttribute(String string) {
        return this.revId.getAttribute(string);
    }

    public final Map getAttributes() {
        return this.revId.getAttributes();
    }

    public final String getExtraAttribute(String string) {
        return this.revId.getExtraAttribute(string);
    }

    public final Map getExtraAttributes() {
        return this.revId.getExtraAttributes();
    }

    public final Map getQualifiedExtraAttributes() {
        return this.revId.getQualifiedExtraAttributes();
    }

    private Map getDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = new LinkedHashMap();
        }
        return this.dependencyArtifacts;
    }

    private Map getIncludeRules() {
        if (this.includeRules == null) {
            this.includeRules = new LinkedHashMap();
        }
        return this.includeRules;
    }

    private Map getExcludeRules() {
        if (this.excludeRules == null) {
            this.excludeRules = new LinkedHashMap();
        }
        return this.excludeRules;
    }

    public final ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    public final DependencyDescriptor clone(ModuleRevisionId moduleRevisionId) {
        return new DefaultDependencyDescriptor(this, moduleRevisionId);
    }
}

