package jp.sf.amateras.functions.utils;

import junit.framework.TestCase;

public class StringUtilsTest extends TestCase {

	public void testEscapeHtml() {
		assertEquals(
				"&lt;a href=&#034;&#034;&gt;",
				StringUtils.escapeHtml("<a href=\"\">"));
	}

	public void testUrlEncodeString() {
		assertEquals(
				"%E3%81%82%E3%81%84%E3%81%86%E3%81%88%E3%81%8A",
				StringUtils.urlEncode("あいうえお"));
	}

	public void testUrlEncodeStringString() {
		assertEquals(
				"%82%A0%82%A2%82%A4%82%A6%82%A8",
				StringUtils.urlEncode("あいうえお", "Windows-31J"));
	}

	public void testConvertLineSeparator() {
		assertEquals(
				"あいうえお<br />かきくけこ",
				StringUtils.convertLineSeparator("あいうえお\nかきくけこ"));
	}

	public void testConvertWhitespace() {
		assertEquals(
				"あいうえお &nbsp;&nbsp;かきくけこ",
				StringUtils.convertWhitespace("あいうえお   かきくけこ"));
	}

	public void testMask() {
		assertEquals("********", StringUtils.mask("password", '*'));
	}

	public void testCut() {
		assertEquals("abc", StringUtils.cut("abcdef", 3));
		assertEquals("abcdef", StringUtils.cut("abcdef", 7));
	}
}
