package jp.sf.amateras.mirage.test;

import java.util.List;

import jp.sf.amateras.mirage.CallExecutor;

/**
 * The mock class of {@link CallExecutor}.
 * This class throws {@link UnsupportedOperationException} for stored procedure / function invocation.
 *
 * @author Naoki Takezoe
 * @see MockSqlManager
 * @see MirageTestContext
 */
public class MockCallExecuter extends CallExecutor {

	@Override
	public void call(String sql, Object parameter){
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> T call(Class<T> resultClass, String sql, Object parameter){
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> List<T> callForList(Class<T> resultClass, String sql, Object parameter){
		throw new UnsupportedOperationException();
	}


}
