package code.snippet

import _root_.scala.xml.{NodeSeq, Text }
import net.liftweb.http.{LiftResponse, RequestVar, S}
import net.liftweb.common.Box
import java.io.File
import code.util.FileDto
import code.util.Util._
import code.util.Util

/**
 * ブラウズ画面（browse.html）で使用するスニペットです。
 */
class BrowseSnippet {

  private object paramRoot extends RequestVar[String](S.param("root").open_!)
  private object paramPath extends RequestVar[String](S.param("path").openOr(""))

  def root(xhtml: NodeSeq) : NodeSeq = {
    Text(paramRoot)
  }

  def path(xhtml: NodeSeq) : NodeSeq = {
    Text(paramPath)
  }

  def parentLink(xhtml: NodeSeq) : NodeSeq = {
    val parentPath = if(isNullOrEmpty(paramPath)) "/"
      else "?root=" + u(paramRoot) + "&path=" + u(getParentPath(paramPath))

    <a href={parentPath}>
      <img src="images/folder.png"/> ..
    </a>
  }

  def list(xhtml: NodeSeq) : NodeSeq = {
    // パスのセキュリティチェック？
    checkRoot(paramRoot)
    checkPath(paramPath)

    val path = buildPath(paramRoot, paramPath)

    val files : Array[FileDto] = listFiles(new File(path))
      // rdiff-backupのメタデータ用ディレクトリは除く
      .filter(file => !(file != null && file.isDirectory && file.getName == "rdiff-backup-data"))
      .map(file => FileDto(file, paramPath))
      .sortWith((dto1, dto2) =>
        if(!dto1.isFile && dto2.isFile)
          true
        else if(dto1.isFile && !dto2.isFile)
          false
        else
          dto1.name.compareTo(dto2.name) < 0)

    <span>
      {files.map(dto => {
        <li class={if(files.indexOf(dto) % 2 == 0) "even" else "odd"}>
          <div class="operation">
            {dto.getFormattedDate}
            <a href="javascript:void(0);" onclick={"openHistoryDialog('%s','%s');".format(paramRoot, dto.path)}>History</a>
          </div>
          {if(dto.isFile)
            <a href={"browse/download?root=" + u(paramRoot) + "&path=" + u(dto.path)}>
              <img src={dto.icon} /> {dto.name}
            </a>
          else
            <a href={"?root=" + u(paramRoot) +"&path=" + u(dto.path)}>
              <img src={dto.icon} /> {dto.name}
            </a>
          }
        </li>
      })}
    </span>
  }
}

/**
 * ファイルブラウザで表示しているファイルのダウンロードを行うためのハンドラです。
 */
object FileDownloadHandler {
  def download(): Box[LiftResponse] = {
    val paramRoot = S.param("root").open_!
    val paramPath = S.param("path").open_!

    // パスのセキュリティチェック
    checkRoot(paramRoot)
    checkPath(paramPath)

    Util.fileDownload(new File(buildPath(paramRoot, paramPath)))
  }
}