package code.util

/**
 * 変更履歴の情報を格納するDTOです。
 *
 * @param operation 変更種別（new|changed|deleted）
 * @param path バックアップディレクトリ内のパス
 * @author Naoki Takezoe
 */
case class ChangeDto(val operation: String, val path: String) {

  /**
   * アイコンのパスを取得します。
   *
   * @return 変更種別に応じたアイコンのパス
   */
  def getIcon: String = {
    "/images/" + operation match {
      case "new" => "add.png"
      case "changed" => "pencil.png"
      case "deleted" => "cancel.png"
    }
  }

}