/*
 * Decompiled with CFR 0.152.
 */
package junitx.extensions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class SerializabilityTestCase
extends TestCase {
    private Serializable obj;

    public SerializabilityTestCase(String name) {
        super(name);
    }

    protected abstract Serializable createInstance() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = this.createInstance();
        try {
            Assert.assertNotNull((String)"createInstance() returned null", (Object)this.obj);
        }
        catch (AssertionFailedError ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public final void testSerializability() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.obj);
        oos.flush();
        oos.close();
        byte[] frozenChunk = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(frozenChunk);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Serializable thawed = (Serializable)ois.readObject();
        this.checkThawedObject(this.obj, thawed);
    }

    protected void checkThawedObject(Serializable expected, Serializable actual) throws Exception {
        Assert.assertEquals((String)"thawed object comparison", (Object)expected, (Object)actual);
    }
}

