/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class JdbcConnectionPoolManager {
    private ConnectionPoolDataSource dataSource;
    private int maxConnections;
    private int timeout;
    private PrintWriter logWriter;
    private Stack recycledConnections;
    private int activeConnections;
    private PoolConnectionEventListener poolConnectionEventListener;
    private boolean isDisposed;

    public JdbcConnectionPoolManager(ConnectionPoolDataSource dataSource, int maxConnections) {
        this(dataSource, maxConnections, 60);
    }

    public JdbcConnectionPoolManager(ConnectionPoolDataSource dataSource, int maxConnections, int timeout) {
        this.dataSource = dataSource;
        this.maxConnections = maxConnections;
        this.timeout = timeout;
        try {
            this.logWriter = dataSource.getLogWriter();
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (maxConnections < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value.");
        }
        this.recycledConnections = new Stack();
        this.poolConnectionEventListener = new PoolConnectionEventListener();
    }

    public synchronized void dispose() throws SQLException {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        SQLException e = null;
        while (!this.recycledConnections.isEmpty()) {
            PooledConnection pc = (PooledConnection)this.recycledConnections.pop();
            try {
                pc.close();
            }
            catch (SQLException e2) {
                if (e != null) continue;
                e = e2;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        int i = 0;
        while (true) {
            JdbcConnectionPoolManager jdbcConnectionPoolManager = this;
            synchronized (jdbcConnectionPoolManager) {
                if (this.activeConnections < this.maxConnections) {
                    return this.getConnectionNow();
                }
                if (i >= this.timeout) {
                    throw new TimeoutException();
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private Connection getConnectionNow() throws SQLException {
        if (this.isDisposed) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pc = !this.recycledConnections.empty() ? (PooledConnection)this.recycledConnections.pop() : this.dataSource.getPooledConnection();
        Connection conn = pc.getConnection();
        ++this.activeConnections;
        pc.addConnectionEventListener(this.poolConnectionEventListener);
        this.assertInnerState();
        return conn;
    }

    private synchronized void recycleConnection(PooledConnection pc) {
        if (this.isDisposed) {
            this.disposeConnection(pc);
            return;
        }
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        this.notifyAll();
        this.recycledConnections.push(pc);
        this.assertInnerState();
    }

    private synchronized void disposeConnection(PooledConnection pc) {
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        this.notifyAll();
        try {
            pc.close();
        }
        catch (SQLException e) {
            this.log("Error while closing database connection: " + e.toString());
        }
        this.assertInnerState();
    }

    private void log(String msg) {
        String s = "JdbcConnectionPoolManager: " + msg;
        try {
            if (this.logWriter == null) {
                System.err.println(s);
            } else {
                this.logWriter.println(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertInnerState() {
        if (this.activeConnections < 0) {
            throw new AssertionError();
        }
        if (this.activeConnections + this.recycledConnections.size() > this.maxConnections) {
            throw new AssertionError();
        }
    }

    public synchronized int getActiveConnections() {
        return this.activeConnections;
    }

    private class PoolConnectionEventListener
    implements ConnectionEventListener {
        private PoolConnectionEventListener() {
        }

        public void connectionClosed(ConnectionEvent event) {
            PooledConnection pc = (PooledConnection)event.getSource();
            pc.removeConnectionEventListener(this);
            JdbcConnectionPoolManager.this.recycleConnection(pc);
        }

        public void connectionErrorOccurred(ConnectionEvent event) {
            PooledConnection pc = (PooledConnection)event.getSource();
            pc.removeConnectionEventListener(this);
            JdbcConnectionPoolManager.this.disposeConnection(pc);
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TimeoutException() {
            super("Timeout while waiting for a free database connection.");
        }
    }
}

