/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.DOMTreeBuilder;
import nu.validator.htmlparser.io.Driver;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlDocumentBuilder
extends DocumentBuilder {
    private final Driver tokenizer;
    private final DOMTreeBuilder domTreeBuilder;
    private final DOMImplementation implementation;
    private EntityResolver entityResolver;

    private static DOMImplementation jaxpDOMImplementation() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.getDOMImplementation();
    }

    public HtmlDocumentBuilder(DOMImplementation implementation, XmlViolationPolicy xmlPolicy) {
        this.implementation = implementation;
        this.domTreeBuilder = new DOMTreeBuilder(implementation);
        this.tokenizer = new Driver(this.domTreeBuilder);
        this.tokenizer.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.setXmlPolicy(xmlPolicy);
    }

    public HtmlDocumentBuilder(DOMImplementation implementation) {
        this(implementation, XmlViolationPolicy.ALTER_INFOSET);
    }

    public HtmlDocumentBuilder() {
        this(XmlViolationPolicy.ALTER_INFOSET);
    }

    public HtmlDocumentBuilder(XmlViolationPolicy xmlPolicy) {
        this(HtmlDocumentBuilder.jaxpDOMImplementation(), xmlPolicy);
    }

    public DOMImplementation getDOMImplementation() {
        return this.implementation;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return false;
    }

    public Document newDocument() {
        return this.implementation.createDocument(null, null, null);
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        this.domTreeBuilder.setFragmentContext(null);
        this.tokenize(is);
        return this.domTreeBuilder.getDocument();
    }

    public DocumentFragment parseFragment(InputSource is, String context) throws IOException, SAXException {
        this.domTreeBuilder.setFragmentContext(context.intern());
        this.tokenize(is);
        return this.domTreeBuilder.getDocumentFragment();
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.domTreeBuilder.setErrorHandler(errorHandler);
        this.tokenizer.setErrorHandler(errorHandler);
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.domTreeBuilder.setIgnoringComments(ignoreComments);
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.domTreeBuilder.setScriptingEnabled(scriptingEnabled);
    }

    public void setCheckingNormalization(boolean enable) {
        this.tokenizer.setCheckingNormalization(enable);
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.tokenizer.setCommentPolicy(commentPolicy);
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.tokenizer.setContentNonXmlCharPolicy(contentNonXmlCharPolicy);
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.tokenizer.setContentSpacePolicy(contentSpacePolicy);
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.tokenizer.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.tokenizer.setMappingLangToXmlLang(mappingLangToXmlLang);
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.tokenizer.setNamePolicy(namePolicy);
        this.domTreeBuilder.setNamePolicy(namePolicy);
    }

    public void setXmlPolicy(XmlViolationPolicy xmlPolicy) {
        this.setNamePolicy(xmlPolicy);
        this.setContentSpacePolicy(xmlPolicy);
        this.setContentNonXmlCharPolicy(xmlPolicy);
        this.setCommentPolicy(xmlPolicy);
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.domTreeBuilder.setDoctypeExpectation(doctypeExpectation);
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.domTreeBuilder.setDocumentModeHandler(documentModeHandler);
    }

    public void setHeuristics(Heuristics heuristics) {
        this.tokenizer.setHeuristics(heuristics);
    }

    private void tokenize(InputSource is) throws SAXException, IOException, MalformedURLException {
        if (is == null) {
            throw new IllegalArgumentException("Null input.");
        }
        if (is.getByteStream() == null && is.getCharacterStream() == null) {
            String systemId = is.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException("No byte stream, no character stream nor URI.");
            }
            if (this.entityResolver != null) {
                is = this.entityResolver.resolveEntity(is.getPublicId(), systemId);
            }
            if (is.getByteStream() == null || is.getCharacterStream() == null) {
                is = new InputSource();
                is.setSystemId(systemId);
                is.setByteStream(new URL(systemId).openStream());
            }
        }
        this.tokenizer.tokenize(is);
    }
}

