/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private FileLocker locker;
    private long timeout = 120000L;
    private Map currentLockCounters = new HashMap();

    protected FileBasedLockStrategy() {
        this(new CreateFileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean debugLocking) {
        this(new CreateFileLocker(debugLocking), debugLocking);
    }

    protected FileBasedLockStrategy(FileLocker locker, boolean debugLocking) {
        super(debugLocking);
        this.locker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireLock(File file2) throws InterruptedException {
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file2);
        }
        long start = System.currentTimeMillis();
        do {
            FileBasedLockStrategy fileBasedLockStrategy = this;
            synchronized (fileBasedLockStrategy) {
                if (this.hasLock(file2)) {
                    int holdLocks = this.incrementLock(file2);
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file2 + " in " + (System.currentTimeMillis() - start) + "ms" + " - hold locks = " + holdLocks);
                    }
                    return true;
                }
                if (this.locker.tryLock(file2)) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("lock acquired on " + file2 + " in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    this.incrementLock(file2);
                    return true;
                }
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - start < this.timeout);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(File file2) {
        FileBasedLockStrategy fileBasedLockStrategy = this;
        synchronized (fileBasedLockStrategy) {
            int holdLocks = this.decrementLock(file2);
            if (holdLocks == 0) {
                this.locker.unlock(file2);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file2);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file2 + " - hold locks = " + holdLocks);
            }
        }
    }

    private static void debugLocking(String msg) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + msg);
    }

    private boolean hasLock(File file2) {
        Integer c = (Integer)this.currentLockCounters.get(file2);
        return c != null && c > 0;
    }

    private int incrementLock(File file2) {
        Integer c = (Integer)this.currentLockCounters.get(file2);
        int holdLocks = c == null ? 1 : c + 1;
        this.currentLockCounters.put(file2, new Integer(holdLocks));
        return holdLocks;
    }

    private int decrementLock(File file2) {
        Integer c = (Integer)this.currentLockCounters.get(file2);
        int dc = c == null ? 0 : c - 1;
        this.currentLockCounters.put(file2, new Integer(dc));
        return dc;
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        public boolean tryLock(File file2) {
            try {
                if (file2.getParentFile().exists() || file2.getParentFile().mkdirs()) {
                    if (file2.createNewFile()) {
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file2);
                    }
                }
            }
            catch (IOException e) {
                Message.verbose("file creation failed due to an exception: " + e.getMessage() + " (" + file2 + ")");
            }
            return false;
        }

        public void unlock(File file2) {
            file2.delete();
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

