/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableSet
extends SchemaCommand {
    public static final int REFERENTIAL_INTEGRITY_TRUE = 0;
    public static final int REFERENTIAL_INTEGRITY_FALSE = 1;
    private String tableName;
    private final int type;
    private boolean checkExisting;

    public AlterTableSet(Session session, Schema schema, int type) {
        super(session, schema);
        this.type = type;
    }

    public void setCheckExisting(boolean b) {
        this.checkExisting = b;
    }

    public boolean isTransactional() {
        return true;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int update() throws SQLException {
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 0: {
                table.setCheckForeignKeyConstraints(this.session, true, this.checkExisting);
                break;
            }
            case 1: {
                table.setCheckForeignKeyConstraints(this.session, false, false);
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return 0;
    }
}

