/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.Tool;

public class CreateCluster
extends Tool {
    private void showUsage() {
        this.out.println("Creates a cluster from a standalone database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -urlSource <url>    The database URL of the source database (jdbc:h2:...)\n" + " -urlTarget <url>    The database URL of the target database (jdbc:h2:...)\n" + " -user <user>        The user name\n" + " [-password <pwd>]   The password\n" + " -serverlist <list>  The comma separated list of host names or IP addresses");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new CreateCluster().run(args);
    }

    public void run(String[] args) throws SQLException {
        String urlSource = null;
        String urlTarget = null;
        String user = null;
        String password = "";
        String serverlist = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-urlSource")) {
                urlSource = args[++i];
                continue;
            }
            if (arg.equals("-urlTarget")) {
                urlTarget = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-serverlist")) {
                serverlist = args[++i];
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        if (urlSource == null || urlTarget == null || user == null || serverlist == null) {
            this.showUsage();
            return;
        }
        this.process(urlSource, urlTarget, user, password, serverlist);
    }

    public void execute(String urlSource, String urlTarget, String user, String password, String serverlist) throws SQLException {
        new CreateCluster().process(urlSource, urlTarget, user, password, serverlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String urlSource, String urlTarget, String user, String password, String serverlist) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            boolean exists;
            Driver.load();
            conn = DriverManager.getConnection(urlSource + ";CLUSTER=''", user, password);
            conn.close();
            try {
                conn = DriverManager.getConnection(urlTarget + ";IFEXISTS=TRUE", user, password);
                conn.close();
                exists = true;
            }
            catch (SQLException e) {
                exists = false;
            }
            if (exists) {
                throw new SQLException("Target database must not yet exist. Please delete it first");
            }
            String scriptFile = "backup.sql";
            Script sc = new Script();
            sc.setOut(this.out);
            sc.process(urlSource, user, password, scriptFile);
            RunScript runscript = new RunScript();
            runscript.setOut(this.out);
            runscript.process(urlTarget, user, password, scriptFile, null, false);
            FileUtils.delete(scriptFile);
            conn = DriverManager.getConnection(urlSource, user, password);
            stat = conn.createStatement();
            stat.executeUpdate("SET CLUSTER '" + serverlist + "'");
            conn.close();
            conn = DriverManager.getConnection(urlTarget, user, password);
            stat = conn.createStatement();
            stat.executeUpdate("SET CLUSTER '" + serverlist + "'");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(conn);
            JdbcUtils.closeSilently(stat);
            throw throwable;
        }
        JdbcUtils.closeSilently(conn);
        JdbcUtils.closeSilently(stat);
    }
}

