﻿/*
 * VibratoBPList.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    [Serializable]
    public class VibratoBPList : ICloneable {
        private List<VibratoBPPair> m_list;

        public VibratoBPList() {
            m_list = new List<VibratoBPPair>();
        }

        public VibratoBPList( float[] x, int[] y ){
            if ( x == null ){
                throw new ArgumentNullException( "x" );
            }
            if ( y == null ){
                throw new ArgumentNullException( "y" );
            }
            int len = Math.Min( x.Length, y.Length );
            m_list = new List<VibratoBPPair>( len );
            for ( int i = 0; i < len; i++ ) {
                m_list.Add( new VibratoBPPair( x[i], y[i] ) );
            }
            m_list.Sort();
        }

        public int getValue( float x, int default_value ) {
            if ( m_list.Count <= 0 ) {
                return default_value;
            }
            int index = -1;
            for ( int i = 0; i < m_list.Count; i++ ) {
                if ( x < m_list[i].X ) {
                    break;
                }
                index = i;
            }
            if ( index == -1 ) {
                return default_value;
            } else {
                return m_list[index].Y;
            }
        }

        public object Clone() {
            VibratoBPList ret = new VibratoBPList();
            for ( int i = 0; i < m_list.Count; i++ ) {
                ret.m_list.Add( new VibratoBPPair( m_list[i].X, m_list[i].Y ) );
            }
            return ret;
        }

        public int getCount() {
            return m_list.Count;
        }

        public VibratoBPPair getElement( int index ) {
            return m_list[index];
        }

        public void setElement( int index, VibratoBPPair value ) {
            m_list[index] = value;
        }

        /// <summary>
        /// XMLシリアライズ用
        /// </summary>
        public string Data {
            get {
                string ret = "";
                for ( int i = 0; i < m_list.Count; i++ ) {
                    ret += (i == 0 ? "" : ",") + m_list[i].X + "=" + m_list[i].Y;
                }
                return ret;
            }
            set {
                m_list.Clear();
                string[] spl = value.Split( ',' );
                for ( int i = 0; i < spl.Length; i++ ) {
                    string[] spl2 = spl[i].Split( '=' );
                    if ( spl2.Length < 2 ) {
                        continue;
                    }
                    m_list.Add( new VibratoBPPair( float.Parse( spl2[0] ), int.Parse( spl2[1] ) ) );
                }
            }
        }
    }

}