/*
 * FormMain.cs
 * Copyright © 2008-2011 kbinani
 *
 * This file is part of org.kbinani.cadencii.
 *
 * org.kbinani.cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the GPLv3 License.
 *
 * org.kbinani.cadencii is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#if JAVA
package org.kbinani.cadencii;

//INCLUDE-SECTION IMPORT ../BuildJavaUI/src/org/kbinani/cadencii/FormMain.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Transmitter;
import javax.sound.midi.Receiver;
import javax.sound.midi.MidiDevice;
import org.kbinani.*;
import org.kbinani.apputil.*;
import org.kbinani.componentmodel.*;
import org.kbinani.media.*;
import org.kbinani.vsq.*;
import org.kbinani.windows.forms.*;
import org.kbinani.xml.*;

#else

//#define USE_BGWORK_SCREEN
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Media;
using System.Text;
using System.Threading;
using org.kbinani.apputil;
using org.kbinani.componentmodel;
using org.kbinani.java.awt;
using org.kbinani.java.awt.event_;
using org.kbinani.java.io;
using org.kbinani.java.util;
using org.kbinani.javax.swing;
using org.kbinani.javax.sound.midi;
using org.kbinani.media;
using org.kbinani.vsq;
using org.kbinani.windows.forms;
using org.kbinani.xml;

namespace org.kbinani.cadencii
{
    using BCancelEventArgs = System.ComponentModel.CancelEventArgs;
    using BDoWorkEventArgs = System.ComponentModel.DoWorkEventArgs;
    using BFormClosedEventArgs = System.Windows.Forms.FormClosedEventArgs;
    using BFormClosingEventArgs = System.Windows.Forms.FormClosingEventArgs;
    using BKeyEventArgs = System.Windows.Forms.KeyEventArgs;
    using BKeyPressEventArgs = System.Windows.Forms.KeyPressEventArgs;
    using BMouseButtons = System.Windows.Forms.MouseButtons;
    using BMouseEventArgs = System.Windows.Forms.MouseEventArgs;
    using boolean = System.Boolean;
    using BPaintEventArgs = System.Windows.Forms.PaintEventArgs;
    using BPreviewKeyDownEventArgs = System.Windows.Forms.PreviewKeyDownEventArgs;
    using BEventArgs = System.EventArgs;

    using BEventHandler = System.EventHandler;
    using BMouseEventHandler = System.Windows.Forms.MouseEventHandler;
    using BKeyEventHandler = System.Windows.Forms.KeyEventHandler;
    using BPreviewKeyDownEventHandler = System.Windows.Forms.PreviewKeyDownEventHandler;
    using BDoWorkEventHandler = System.ComponentModel.DoWorkEventHandler;
    using BPaintEventHandler = System.Windows.Forms.PaintEventHandler;
    using BFormClosedEventHandler = System.Windows.Forms.FormClosedEventHandler;
    using BFormClosingEventHandler = System.Windows.Forms.FormClosingEventHandler;
    using BCancelEventHandler = System.ComponentModel.CancelEventHandler;
    
    using Integer = System.Int32;
    using Long = System.Int64;
#endif

    /// <summary>
    /// エディタのメイン画面クラス
    /// </summary>
#if JAVA
    public class FormMain extends BForm
#else
    public class FormMain : BForm
#endif
    {
        /// <summary>
        /// 特殊なキーの組み合わせのショートカットと、メニューアイテムとの紐付けを保持するクラスです。
        /// </summary>
        private class SpecialShortcutHolder
        {
            /// <summary>
            /// ショートカットキーを表すKeyStrokeクラスのインスタンス
            /// </summary>
            public KeyStroke shortcut;
            /// <summary>
            /// ショートカットキーとの紐付けを行う相手先のメニューアイテム
            /// </summary>
            public BMenuItem menu;

            /// <summary>
            /// ショートカットキーとメニューアイテムを指定したコンストラクタ
            /// </summary>
            /// <param name="shortcut">ショートカットキー</param>
            /// <param name="menu">ショートカットキーとの紐付けを行うメニューアイテム</param>
            public SpecialShortcutHolder( KeyStroke shortcut, BMenuItem menu )
            {
                this.shortcut = shortcut;
                this.menu = menu;
            }
        }

#if !JAVA
        /// <summary>
        /// refreshScreenを呼び出す時に使うデリゲート
        /// </summary>
        /// <param name="value"></param>
        delegate void DelegateRefreshScreen( boolean value );
#endif

        #region static readonly field
        /// <summary>
        /// ピアノロールでの，音符の塗りつぶし色
        /// </summary>
        public static readonly Color mColorNoteFill = new Color( 181, 220, 86 );
        private readonly Color mColorR105G105B105 = new Color( 105, 105, 105 );
        private readonly Color mColorR187G187B255 = new Color( 187, 187, 255 );
        private readonly Color mColorR007G007B151 = new Color( 7, 7, 151 );
        private readonly Color mColorR065G065B065 = new Color( 65, 65, 65 );
        private readonly Color mColorTextboxBackcolor = new Color( 128, 128, 128 );
        private readonly Color mColorR214G214B214 = new Color( 214, 214, 214 );
        private readonly AuthorListEntry[] _CREDIT = new AuthorListEntry[]{
            new AuthorListEntry( "is developped by:", 2 ),
            new AuthorListEntry( "kbinani", "@kbinani" ),
            new AuthorListEntry( "修羅場P", "@shurabaP" ),
            new AuthorListEntry( "もみじぱん", "@momijipan" ),
            new AuthorListEntry( "結晶", "@gondam" ),
            new AuthorListEntry( "" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Special Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "tool icons designer:", 2 ),
            new AuthorListEntry( "Yusuke KAMIYAMANE", "@ykamiyamane" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of WORLD:", 2 ),
            new AuthorListEntry( "Masanori MORISE", "@m_morise" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of v.Connect-STAND:", 2 ),
            new AuthorListEntry( "修羅場P", "@shurabaP" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of UTAU:", 2 ),
            new AuthorListEntry( "飴屋/菖蒲", "@ameyaP_" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of RebarDotNet:", 2 ),
            new AuthorListEntry( "Anthony Baraff" ),
            new AuthorListEntry(),
            new AuthorListEntry( "developper of ln:", 2 ),
            new AuthorListEntry( "M.Kimura" ),
            new AuthorListEntry(),
            new AuthorListEntry( "promoter:", 2 ),
            new AuthorListEntry( "zhuo", "@zhuop" ),
            new AuthorListEntry(),
            new AuthorListEntry( "library tester:", 2 ),
            new AuthorListEntry( "evm" ),
            new AuthorListEntry( "そろそろP" ),
            new AuthorListEntry( "めがね１１０" ),
            new AuthorListEntry( "上総" ),
            new AuthorListEntry( "NOIKE", "@knoike" ),
            new AuthorListEntry( "逃亡者" ),
            new AuthorListEntry(),
            new AuthorListEntry( "translator:", 2 ),
            new AuthorListEntry( "Eji (zh-TW translation)", "@ejiwarp" ),
            new AuthorListEntry( "kankan (zh-TW translation)" ),
            new AuthorListEntry( "yxmline (zh-CN translation)" ),
            new AuthorListEntry( "BubblyYoru (en translation)", "@BubblyYoru" ),
            new AuthorListEntry( "BeForU (kr translation)", "@BeForU" ),
            new AuthorListEntry(),
            new AuthorListEntry(),
            new AuthorListEntry( "Thanks to", 3 ),
            new AuthorListEntry(),
            new AuthorListEntry( "ないしょの人" ),
            new AuthorListEntry( "naquadah" ),
            new AuthorListEntry( "1zo" ),
            new AuthorListEntry( "Amby" ),
            new AuthorListEntry( "ケロッグ" ),
            new AuthorListEntry( "beginner" ),
            new AuthorListEntry( "b2ox", "@b2ox" ),
            new AuthorListEntry( "麻太郎" ),
            new AuthorListEntry( "PEX", "@pex_zeo" ),
            new AuthorListEntry( "やなぎがうら" ),
            new AuthorListEntry( "cocoonP", "@cocoonP" ),
            new AuthorListEntry( "かつ" ),
            new AuthorListEntry( "ちゃそ", "@marimarikerori" ),
            new AuthorListEntry( "ちょむ" ),
            new AuthorListEntry( "whimsoft" ),
            new AuthorListEntry( "kitiketao", "@okoktaokokta" ),
            new AuthorListEntry( "カプチ２" ),
            new AuthorListEntry( "あにぃ" ),
            new AuthorListEntry( "tomo" ),
            new AuthorListEntry( "ナウ□マP", "@now_romaP" ),
            new AuthorListEntry( "内藤　魅亜", "@mianaito" ),
            new AuthorListEntry( "空茶", "@maizeziam" ),
            new AuthorListEntry( "いぬくま" ),
            new AuthorListEntry( "shu-t", "@shu_sonicwave" ),
            new AuthorListEntry( "さささ", "@sasasa3396" ),
            new AuthorListEntry( "あろも～ら", "@aromora" ),
            new AuthorListEntry( "空耳P", "@soramiku" ),
            new AuthorListEntry( "kotoi" ),
            new AuthorListEntry( "げっぺータロー", "@geppeitaro" ),
            new AuthorListEntry( "みけCAT", "@mikecat_mixc" ),
            new AuthorListEntry( "ぎんじ" ),
            new AuthorListEntry( "BeForU", "@BeForU" ),
            new AuthorListEntry( "all members of Cadencii bbs", 2 ),
            new AuthorListEntry(),
            new AuthorListEntry( "     ... and you !", 3 ),
        };
        #endregion

        #region constants and internal enums
        /// <summary>
        /// カーブエディタ画面の編集モード
        /// </summary>
        enum CurveEditMode
        {
            /// <summary>
            /// 何もしていない
            /// </summary>
            NONE,
            /// <summary>
            /// 鉛筆ツールで編集するモード
            /// </summary>
            EDIT,
            /// <summary>
            /// ラインツールで編集するモード
            /// </summary>
            LINE,
            /// <summary>
            /// 鉛筆ツールでVELを編集するモード
            /// </summary>
            EDIT_VEL,
            /// <summary>
            /// ラインツールでVELを編集するモード
            /// </summary>
            LINE_VEL,
            /// <summary>
            /// 真ん中ボタンでドラッグ中
            /// </summary>
            MIDDLE_DRAG,
        }

        enum ExtDragXMode
        {
            RIGHT,
            LEFT,
            NONE,
        }

        enum ExtDragYMode
        {
            UP,
            DOWN,
            NONE,
        }

        enum GameControlMode
        {
            DISABLED,
            NORMAL,
            KEYBOARD,
            CURSOR,
        }

        enum PositionIndicatorMouseDownMode
        {
            NONE,
            MARK_START,
            MARK_END,
            TEMPO,
            TIMESIG,
        }

        /// <summary>
        /// スクロールバーの最小サイズ(ピクセル)
        /// </summary>
        public const int MIN_BAR_ACTUAL_LENGTH = 17;
        /// <summary>
        /// エントリの端を移動する時の、ハンドル許容範囲の幅
        /// </summary>
        public const int _EDIT_HANDLE_WIDTH = 7;
        public const int _TOOL_BAR_HEIGHT = 46;
        /// <summary>
        /// 単音プレビュー時に、wave生成完了を待つ最大の秒数
        /// </summary>
        public const double _WAIT_LIMIT = 5.0;
        public const String _APP_NAME = "Cadencii";
        /// <summary>
        /// 表情線の先頭部分のピクセル幅
        /// </summary>
        public const int _PX_ACCENT_HEADER = 21;
        public const String _VERSION_HISTORY_URL = "http://www.ne.jp/asahi/kbinani/home/cadencii/version_history.xml";
        /// <summary>
        /// splitContainer2.Panel2の最小サイズ
        /// </summary>
        public const int _SPL2_PANEL2_MIN_HEIGHT = 25;
        /// <summary>
        /// splitContainer*で使用するSplitterWidthプロパティの値
        /// </summary>
#if JAVA
        public const int _SPL_SPLITTER_WIDTH = 9;
#else
        public const int _SPL_SPLITTER_WIDTH = 4;
#endif
        const int _PICT_POSITION_INDICATOR_HEIGHT = 48;
        const int _SCROLL_WIDTH = 16;
        /// <summary>
        /// Overviewペインの高さ
        /// </summary>
        public const int _OVERVIEW_HEIGHT = 50;
        /// <summary>
        /// splitContainerPropertyの最小幅
        /// </summary>
        const int _PROPERTY_DOCK_MIN_WIDTH = 50;
        /// <summary>
        /// WAVE再生時のバッファーサイズの最大値
        /// </summary>
        const int MAX_WAVE_MSEC_RESOLUTION = 1000;
        /// <summary>
        /// WAVE再生時のバッファーサイズの最小値
        /// </summary>
        const int MIN_WAVE_MSEC_RESOLUTION = 100;
        /// <summary>
        /// Wave表示部等のボタンと他のコンポーネントの間のスペース
        /// </summary>
        const int SPACE = 4;
        #endregion

        #region static field
        /// <summary>
        /// refreshScreenが呼ばれている最中かどうか
        /// </summary>
        private static boolean mIsRefreshing = false;
        /// <summary>
        /// CTRLキー。MacOSXの場合はMenu
        /// </summary>
        public int s_modifier_key = InputEvent.CTRL_MASK;
        #endregion

        #region fields
        public VersionInfo mVersionInfo = null;
#if !JAVA
        public System.Windows.Forms.Cursor HAND;
#endif
        /// <summary>
        /// ボタンがDownされた位置。(座標はpictureBox基準)
        /// </summary>
        public Point mButtonInitial = new Point();
        /// <summary>
        /// 真ん中ボタンがダウンされたときのvscrollのvalue値
        /// </summary>
        public int mMiddleButtonVScroll;
        /// <summary>
        /// 真ん中ボタンがダウンされたときのhscrollのvalue値
        /// </summary>
        public int mMiddleButtonHScroll;
        public boolean mEdited = false;
        /// <summary>
        /// 最後にメイン画面が更新された時刻(秒単位)
        /// </summary>
        private double mLastScreenRefreshedSec;
        /// <summary>
        /// カーブエディタの編集モード
        /// </summary>
        private CurveEditMode mEditCurveMode = CurveEditMode.NONE;
        /// <summary>
        /// ピアノロールの右クリックが表示される直前のマウスの位置
        /// </summary>
        public Point mContextMenuOpenedPosition = new Point();
        /// <summary>
        /// ピアノロールの画面外へのドラッグ時、前回自動スクロール操作を行った時刻
        /// </summary>
        public double mTimerDragLastIgnitted;
        /// <summary>
        /// 画面外への自動スクロールモード
        /// </summary>
        private ExtDragXMode mExtDragX = ExtDragXMode.NONE;
        private ExtDragYMode mExtDragY = ExtDragYMode.NONE;
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの仮想スクリーン上の位置
        /// </summary>
        public Point mMouseMoveInit = new Point();
        /// <summary>
        /// EditMode=MoveEntryで，移動を開始する直前のマウスの位置と，音符の先頭との距離(ピクセル)
        /// </summary>
        public int mMouseMoveOffset;
        /// <summary>
        /// マウスが降りているかどうかを表すフラグ．AppManager.isPointerDownedとは別なので注意
        /// </summary>
        public boolean mMouseDowned = false;
        public int mTempoDraggingDeltaClock = 0;
        public int mTimesigDraggingDeltaClock = 0;
        public boolean mMouseDownedTrackSelector = false;
        private ExtDragXMode mExtDragXTrackSelector = ExtDragXMode.NONE;
        public boolean mMouseMoved = false;
#if ENABLE_MOUSEHOVER
        /// <summary>
        /// マウスホバーを発生させるスレッド
        /// </summary>
        public Thread mMouseHoverThread = null;
#endif
        public boolean mLastIsImeModeOn = true;
        public boolean mLastSymbolEditMode = false;
        /// <summary>
        /// 鉛筆のモード
        /// </summary>
        public PencilMode mPencilMode = new PencilMode();
        /// <summary>
        /// ビブラート範囲を編集中の音符のInternalID
        /// </summary>
        public int mVibratoEditingId = -1;
        /// <summary>
        /// このフォームがアクティブ化されているかどうか
        /// </summary>
        public boolean mFormActivated = true;
        private GameControlMode mGameMode = GameControlMode.DISABLED;
        public BTimer mTimer;
        public boolean mLastPovR = false;
        public boolean mLastPovL = false;
        public boolean mLastPovU = false;
        public boolean mLastPovD = false;
        public boolean mLastBtnX = false;
        public boolean mLastBtnO = false;
        public boolean mLastBtnRe = false;
        public boolean mLastBtnTr = false;
        public boolean mLastBtnSelect = false;
        /// <summary>
        /// 前回ゲームコントローラのイベントを処理した時刻
        /// </summary>
        public double mLastEventProcessed;
        public boolean mSpacekeyDowned = false;
#if ENABLE_MIDI
        public MidiInDevice mMidiIn = null;
#endif
#if ENABLE_MTC
        public MidiInDevice m_midi_in_mtc = null;
#endif
        public FormMidiImExport mDialogMidiImportAndExport = null;
        public TreeMap<EditTool, Cursor> mCursor = new TreeMap<EditTool, Cursor>();
        private Preference mDialogPreference;
#if ENABLE_PROPERTY
        public PropertyPanelContainer mPropertyPanelContainer;
#endif
#if ENABLE_SCRIPT
        public Vector<System.Windows.Forms.ToolBarButton> mPaletteTools = new Vector<System.Windows.Forms.ToolBarButton>();
#endif

        /// <summary>
        /// PositionIndicatorのマウスモード
        /// </summary>
        private PositionIndicatorMouseDownMode mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入ったかどうか
        /// </summary>
        public boolean mKeyLengthSplitterMouseDowned = false;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、マウスのスクリーン座標
        /// </summary>
        public Point mKeyLengthSplitterInitialMouse = new Point();
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、keyWidthの値
        /// </summary>
        public int mKeyLengthInitValue = 68;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、trackSelectorのgetRowsPerColumn()の値
        /// </summary>
        public int mKeyLengthTrackSelectorRowsPerColumn = 1;
        /// <summary>
        /// AppManager.keyWidthを調節するモードに入る直前での、splitContainer1のSplitterLocationの値
        /// </summary>
        public int mKeyLengthSplitterDistance = 0;
        public BFileChooser openXmlVsqDialog;
        public BFileChooser saveXmlVsqDialog;
        public BFileChooser openUstDialog;
        public BFileChooser openMidiDialog;
        public BFileChooser saveMidiDialog;
        public BFileChooser openWaveDialog;
        public BTimer timer;
        public BBackgroundWorker bgWorkScreen;
        /// <summary>
        /// アイコンパレットのドラッグ＆ドロップ処理中，一度でもpictPianoRoll内にマウスが入ったかどうか
        /// </summary>
        private boolean mIconPaletteOnceDragEntered = false;
        private byte mMtcFrameLsb;
        private byte mMtcFrameMsb;
        private byte mMtcSecLsb;
        private byte mMtcSecMsb;
        private byte mMtcMinLsb;
        private byte mMtcMinMsb;
        private byte mMtcHourLsb;
        private byte mMtcHourMsb;
        /// <summary>
        /// MTCを最後に受信した時刻
        /// </summary>
        private double mMtcLastReceived = 0.0;
        /// <summary>
        /// 特殊な取り扱いが必要なショートカットのキー列と、対応するメニューアイテムを保存しておくリスト。
        /// </summary>
        private Vector<SpecialShortcutHolder> mSpecialShortcutHolders = new Vector<SpecialShortcutHolder>();
        /// <summary>
        /// 歌詞流し込み用のダイアログ
        /// </summary>
        private FormImportLyric mDialogImportLyric = null;
        /// <summary>
        /// デフォルトのストローク
        /// </summary>
        private BasicStroke mStrokeDefault = null;
        /// <summary>
        /// 描画幅2pxのストローク
        /// </summary>
        private BasicStroke mStroke2px = null;
        /// <summary>
        /// 波形表示部分のズーム時に，マウスが下りた瞬間のY座標
        /// </summary>
        private int mWaveViewMouseDownedLocationY;
        /// <summary>
        /// 波形表示部の縦軸の拡大率を自動最大化するかどうか
        /// </summary>
        private boolean mWaveViewAutoMaximize = false;
        /// <summary>
        /// 波形表示部のAutoMaximizeボタン上でマウスが下りた状態かどうか
        /// </summary>
        private boolean mWaveViewButtonAutoMaximizeMouseDowned = false;
        /// <summary>
        /// 波形表示部の拡大ボタン上でマウスが下りた状態かどうか
        /// </summary>
        private boolean mWaveViewButtonZoomMouseDowned = false;
        /// <summary>
        /// 波形表示部の拡大ボタン上でマウスが下りた瞬間の，波形表示部の縦軸拡大率．
        /// </summary>
        private float mWaveViewInitScale;
        /// <summary>
        /// pictureBox2の描画ループで使うグラフィックス
        /// </summary>
        private Graphics2D mGraphicsPictureBox2 = null;
        /// <summary>
        /// panel2の描画ループで使うグラフィックス
        /// </summary>
        private Graphics2D mGraphicsPanel2 = null;
#if !JAVA
        /// <summary>
        /// ピアノロールの縦方向の拡大率を変更するパネル上でのマウスの状態。
        /// 0がデフォルト、&gt;0は+ボタンにマウスが降りた状態、&lt;0は-ボタンにマウスが降りた状態
        /// </summary>
        private int mPianoRollScaleYMouseStatus = 0;
#endif
        /// <summary>
        /// MIDIステップ入力モードがONかどうか
        /// </summary>
        private boolean mStepSequencerEnabled = false;
        /// <summary>
        /// 再生中にソングポジションが前進だけしてほしいので，逆行を防ぐために前回のソングポジションを覚えておく
        /// </summary>
        private int mLastClock = 0;
        /// <summary>
        /// PositionIndicatorに表示しているポップアップのクロック位置
        /// </summary>
        private int mPositionIndicatorPopupShownClock;
#if MONITOR_FPS
        /// <summary>
        /// パフォーマンスカウンタ
        /// </summary>
        private double[] mFpsDrawTime = new double[128];
        private int mFpsDrawTimeIndex = 0;
        /// <summary>
        /// パフォーマンスカウンタから算出される画面の更新速度
        /// </summary>
        private float mFps = 0f;
        private double[] mFpsDrawTime2 = new double[128];
        private float mFps2 = 0f;
#endif
        #endregion

        #region constructor
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="file">最初に開くxvsq，vsqファイルのパス</param>
        public FormMain( String file )
        {
#if JAVA
		    super();
#endif

            // 言語設定を反映させる
            Messaging.setLanguage( AppManager.editorConfig.Language );

#if ENABLE_PROPERTY
            AppManager.propertyPanel = new PropertyPanel();
            AppManager.propertyWindow = new FormNoteProperty();
            AppManager.propertyWindow.addComponent( AppManager.propertyPanel );
#endif

#if DEBUG
            AppManager.debugWriteLine( "FormMain..ctor()" );
#endif
            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 );
            AppManager.baseFont50Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE50 );

            s_modifier_key = 
#if JAVA_MAC
                InputEvent.META_MASK;
#else
                InputEvent.CTRL_MASK;
#endif
            VsqFileEx tvsq = 
                new VsqFileEx( 
                    AppManager.editorConfig.DefaultSingerName,
                    1,
                    4,
                    4,
                    500000 );
            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            tvsq.Track.get( 1 ).changeRenderer( renderer, singers );
            AppManager.setVsqFile( tvsq );

            trackSelector = new TrackSelector( this ); // initializeで引数なしのコンストラクタが呼ばれるのを予防
#if JAVA
            initialize();
            timer = new BTimer();
            getCMenuPiano();
            getCMenuTrackTab();
            getCMenuTrackSelector();
// MIDIステップ入力は使えないことにする
//            toolStripTool.remove( getStripBtnStepSequencer() );
#else
            InitializeComponent();
            timer = new BTimer( this.components );
            waveView = new WaveView();
#endif

            panelOverview.setMainForm( this );
            pictPianoRoll.setMainForm( this );
            bgWorkScreen = new BBackgroundWorker();
#if JAVA
#else
            this.panel2.Controls.Add( this.waveView );
            this.waveView.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.waveView.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(212)))), ((int)(((byte)(212)))), ((int)(((byte)(212)))) );
            this.waveView.Location = new System.Drawing.Point( 66, 0 );
            this.waveView.Margin = new System.Windows.Forms.Padding( 0 );
            this.waveView.Name = "waveView";
            this.waveView.Size = new System.Drawing.Size( 355, 59 );
            this.waveView.TabIndex = 17;
#endif
            openXmlVsqDialog = new BFileChooser();
            openXmlVsqDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
            openXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );

            saveXmlVsqDialog = new BFileChooser();
            saveXmlVsqDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
            saveXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );
            saveXmlVsqDialog.addFileFilter( "All files(*.*)|*.*" );

            openUstDialog = new BFileChooser();
            openUstDialog.addFileFilter( "UTAU Project File(*.ust)|*.ust" );
            openUstDialog.addFileFilter( "All Files(*.*)|*.*" );

            openMidiDialog = new BFileChooser();
            saveMidiDialog = new BFileChooser();
            openWaveDialog = new BFileChooser();

            /*mOverviewScaleCount = AppManager.editorConfig.OverviewScaleCount;
            mOverviewPixelPerClock = getOverviewScaleX( mOverviewScaleCount );*/

            menuVisualOverview.setSelected( AppManager.editorConfig.OverviewEnabled );
#if ENABLE_PROPERTY
            mPropertyPanelContainer = new PropertyPanelContainer();
#endif

            registerEventHandlers();
            setResources();

#if !ENABLE_SCRIPT
            menuSettingPaletteTool.setVisible( false );
            menuScript.setVisible( false );
#endif
            updateTrackSelectorVisibleCurve();
            trackSelector.setBackground( new Color( 108, 108, 108 ) );
            trackSelector.setCurveVisible( true );
            trackSelector.setSelectedCurve( CurveType.VEL );
#if !JAVA
            trackSelector.setLocation( new Point( 0, 242 ) );
            trackSelector.Margin = new System.Windows.Forms.Padding( 0 );
            trackSelector.Name = "trackSelector";
            trackSelector.setSize( 446, 250 );
            trackSelector.TabIndex = 0;
#endif
            trackSelector.MouseClick += new BMouseEventHandler( trackSelector_MouseClick );
            trackSelector.MouseUp += new BMouseEventHandler( trackSelector_MouseUp );
            trackSelector.MouseDown += new BMouseEventHandler( trackSelector_MouseDown );
            trackSelector.MouseMove += new BMouseEventHandler( trackSelector_MouseMove );
            trackSelector.KeyDown += new BKeyEventHandler( handleSpaceKeyDown );
            trackSelector.KeyUp += new BKeyEventHandler( handleSpaceKeyUp );
            trackSelector.PreviewKeyDown += new BPreviewKeyDownEventHandler( trackSelector_PreviewKeyDown );
            trackSelector.SelectedTrackChanged += new SelectedTrackChangedEventHandler( trackSelector_SelectedTrackChanged );
            trackSelector.SelectedCurveChanged += new SelectedCurveChangedEventHandler( trackSelector_SelectedCurveChanged );
            trackSelector.RenderRequired += new RenderRequiredEventHandler( trackSelector_RenderRequired );
            trackSelector.PreferredMinHeightChanged += new BEventHandler( trackSelector_PreferredMinHeightChanged );
            trackSelector.MouseDoubleClick += new BMouseEventHandler( trackSelector_MouseDoubleClick );

#if !JAVA
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            this.setMinimumSize( getWindowMinimumSize() );
#endif
#if JAVA
            stripBtnScroll.setSelected( AppManager.mAutoScroll );
#else
            stripBtnScroll.Pushed = AppManager.mAutoScroll;
#endif

            applySelectedTool();
            applyQuantizeMode();

            // Palette Toolの読み込み
#if ENABLE_SCRIPT
            updatePaletteTool();
#endif

#if !JAVA
            splitContainer1.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            splitContainer1.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.None;
            splitContainer1.BackColor = System.Drawing.Color.FromArgb( 212, 212, 212 );
            splitContainer2.Panel1.Controls.Add( panel1 );
            panel1.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer2.Panel2.Controls.Add( panel2 );
            //splitContainer2.Panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            splitContainer2.Panel2.BorderColor = System.Drawing.Color.FromArgb( 112, 112, 112 );
            splitContainer1.Panel1.Controls.Add( splitContainer2 );
            panel2.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer2.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Panel2.Controls.Add( trackSelector );
            trackSelector.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            splitContainer1.Panel2MinSize = trackSelector.getPreferredMinSize();
            splitContainerProperty.FixedPanel = System.Windows.Forms.FixedPanel.Panel1;
#endif

#if ENABLE_PROPERTY
#if JAVA
            splitContainerProperty.setLeftComponent( mPropertyPanelContainer );
            mPropertyPanelContainer.setMinimumSize( new Dimension( 0, 0 ) );
#else
            splitContainerProperty.Panel1.Controls.Add( mPropertyPanelContainer );
            mPropertyPanelContainer.Dock = System.Windows.Forms.DockStyle.Fill;
#endif
#else
            splitContainerProperty.setDividerLocation( 0 );
            splitContainerProperty.setEnabled( false );
            menuVisualProperty.setVisible( false );
#endif

#if !JAVA
            splitContainerProperty.Panel2.Controls.Add( splitContainer1 );
            splitContainerProperty.Dock = System.Windows.Forms.DockStyle.Fill;

            // コントロールの位置・サイズを調節
            splitContainer2.Panel1.SuspendLayout();
            panel1.SuspendLayout();
            pictPianoRoll.SuspendLayout();
            vScroll.SuspendLayout();
            // panel1の中身は
            // picturePositionIndicator
            picturePositionIndicator.Left = 0;
            picturePositionIndicator.Top = 0;
            picturePositionIndicator.Width = panel1.Width;
            // pictPianoRoll
            pictPianoRoll.setBounds( 0, picturePositionIndicator.Height, panel1.Width - vScroll.Width, panel1.Height - picturePositionIndicator.Height - hScroll.Height );
            // vScroll
            vScroll.Left = pictPianoRoll.getWidth();
            vScroll.Top = picturePositionIndicator.Height;
            vScroll.Height = pictPianoRoll.getHeight();
            // pictureBox3
            pictureBox3.Left = 0;
            pictureBox3.Top = panel1.Height - hScroll.getHeight();
            pictureBox3.Height = hScroll.Height;
            // hScroll
            hScroll.Left = pictureBox3.Width;
            hScroll.Top = panel1.Height - hScroll.Height;
            hScroll.Width = panel1.Width - pictureBox3.Width - trackBar.getWidth() - pictureBox2.Width;
            // trackBar
            trackBar.Left = pictureBox3.Width + hScroll.Width;
            trackBar.Top = panel1.Height - hScroll.Height;
            // pictureBox2
            pictureBox2.Left = panel1.Width - vScroll.Width;
            pictureBox2.Top = panel1.Height - hScroll.Height;

            vScroll.ResumeLayout();
            pictPianoRoll.ResumeLayout();
            panel1.ResumeLayout();
            splitContainer2.Panel1.ResumeLayout();
#endif

            updatePropertyPanelState( AppManager.editorConfig.PropertyWindowStatus.State );

            pictPianoRoll.MouseWheel += new BMouseEventHandler( pictPianoRoll_MouseWheel );
            trackSelector.MouseWheel += new BMouseEventHandler( trackSelector_MouseWheel );
            picturePositionIndicator.MouseWheel += new BMouseEventHandler( picturePositionIndicator_MouseWheel );

            menuVisualOverview.CheckedChanged += new BEventHandler( menuVisualOverview_CheckedChanged );

            hScroll.setMaximum( AppManager.getVsqFile().TotalClocks + 240 );
            hScroll.setVisibleAmount( 240 * 4 );

            vScroll.setMaximum( (int)(AppManager.getScaleY() * 100 * 128) );
            vScroll.setVisibleAmount( 24 * 4 );
#if !JAVA
            hScroll.SmallChange = 240;
            vScroll.SmallChange = 24;
#endif

            trackSelector.setCurveVisible( true );

            // inputTextBoxの初期化
#if JAVA
            AppManager.mInputTextBox = new LyricTextBox( this );
            AppManager.mInputTextBox.setVisible( false );
            AppManager.mInputTextBox.setSize( 80, 22 );
            AppManager.mInputTextBox.setBackground( Color.white );
            AppManager.mInputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, 9 ) );
            AppManager.mInputTextBox.setEnabled( false );
            AppManager.mInputTextBox.keyPressEvent.add( new BKeyPressEventHandler( this, "mInputTextBox_KeyPress" ) );
#else
            AppManager.mInputTextBox = new LyricTextBox();
            AppManager.mInputTextBox.setVisible( false );
            AppManager.mInputTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            AppManager.mInputTextBox.Width = 80;
            AppManager.mInputTextBox.AcceptsReturn = true;
            AppManager.mInputTextBox.setBackground( Color.white );
            AppManager.mInputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
            AppManager.mInputTextBox.setEnabled( false );
            AppManager.mInputTextBox.KeyPress += mInputTextBox_KeyPress;
            AppManager.mInputTextBox.Parent = pictPianoRoll;
            panel1.Controls.Add( AppManager.mInputTextBox );
#endif

            int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
            timer.setDelay( (fps <= 0) ? 1 : fps );

#if JAVA
#if !DEBUG
            menuHelp.remove( menuHelpDebug );
#endif // !DEBUG
#else // JAVA
#if DEBUG
            menuHelpDebug.setVisible( true );
#endif // DEBUG
#endif // else JAVA

#if !JAVA
            String _HAND = "AAACAAEAICAAABAAEADoAgAAFgAAACgAAAAgAAAAQAAAAAEABAAAAAAAgAIAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAgAAAAACAAACAgAAAAACAAIAAgAAAgIAAwMDAAICAgAD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wD///8AAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/wAAAAAAAAAAAAAAAAAAD" +
                "//wAAAAAAAAAAAAAAAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAA" +
                "A//AAAAAP/wAAAAAAAAAAAP/wAAAAD/8AAAAAAAAAAAAP8AAAAA/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAA//8AAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAP8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" +
                "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD////////////////////////////////////////////+f////" +
                "D////gf///4H////D///8/z//+H4f//B+D//wfg//+H4f//z/P///w////4H///+B////w////+f//////////////////////////" +
                "//////////////////w==";
            System.IO.MemoryStream ms = null;
            try {
                ms = new System.IO.MemoryStream( Base64.decode( _HAND ) );
                HAND = new System.Windows.Forms.Cursor( ms );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".ctor; ex=" + ex + "\n" );
            } finally {
                if ( ms != null ) {
                    try {
                        ms.Close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".ctor; ex=" + ex2 + "\n" );
                    }
                }
            }
#endif

            menuHelpLogSwitch.setSelected( Logger.isEnabled() );
            applyShortcut();

            AppManager.mMixerWindow = new FormMixer( this );
            AppManager.iconPalette = new FormIconPalette( this );

            // ファイルを開く
            if ( !str.compare( file, "" ) ) {
                if ( fsys.isFileExists( file ) ) {
                    String low_file = file.ToLower();
                    if ( low_file.EndsWith( ".xvsq" ) ) {
                        openVsqCor( low_file );
                        //AppManager.readVsq( file );
                    } else if ( low_file.EndsWith( ".vsq" ) ) {
                        VsqFileEx vsq = null;
                        try {
                            vsq = new VsqFileEx( file, "Shift_JIS" );
                            AppManager.setVsqFile( vsq );
                            updateBgmMenuState();
                        } catch ( Exception ex ) {
                            Logger.write( typeof( FormMain ) + ".ctor; ex=" + ex + "\n" );
                            serr.println( "FormMain#.ctor; ex=" + ex );
                        }
                    }
                }
            }

            trackBar.setValue( AppManager.editorConfig.DefaultXScale );
            AppManager.setCurrentClock( 0 );
            setEdited( false );

            AppManager.PreviewStarted += new BEventHandler( AppManager_PreviewStarted );
            AppManager.PreviewAborted += new BEventHandler( AppManager_PreviewAborted );
            AppManager.GridVisibleChanged += new BEventHandler( AppManager_GridVisibleChanged );
            AppManager.SelectedEventChanged += new SelectedEventChangedEventHandler( AppManager_SelectedEventChanged );
            AppManager.SelectedToolChanged += new BEventHandler( AppManager_SelectedToolChanged );
            AppManager.UpdateBgmStatusRequired += new BEventHandler( AppManager_UpdateBgmStatusRequired );
            AppManager.MainWindowFocusRequired += new BEventHandler( AppManager_MainWindowFocusRequired );
            AppManager.EditedStateChanged += new EditedStateChangedEventHandler( AppManager_EditedStateChanged );
            AppManager.WaveViewReloadRequired += new WaveViewRealoadRequiredEventHandler( AppManager_WaveViewRealoadRequired );
            EditorConfig.QuantizeModeChanged += new BEventHandler( handleEditorConfig_QuantizeModeChanged );

#if ENABLE_PROPERTY
            mPropertyPanelContainer.StateChangeRequired += new StateChangeRequiredEventHandler( mPropertyPanelContainer_StateChangeRequired );
#endif

            updateRecentFileMenu();

            // C3が画面中央に来るように調整
            int draft_start_to_draw_y = 68 * (int)(100 * AppManager.getScaleY()) - pictPianoRoll.getHeight() / 2;
            int draft_vscroll_value = (int)((draft_start_to_draw_y * (double)vScroll.getMaximum()) / (128 * (int)(100 * AppManager.getScaleY()) - vScroll.getHeight()));
            try {
                vScroll.setValue( draft_vscroll_value );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
            }

            // x=97がプリメジャークロックになるように調整
            int cp = AppManager.getVsqFile().getPreMeasureClocks();
            int draft_hscroll_value = (int)(cp - 24.0 * AppManager.getScaleXInv());
            try {
                hScroll.setValue( draft_hscroll_value );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
            }

            //s_pen_dashed_171_171_171.DashPattern = new float[] { 3, 3 };
            //s_pen_dashed_209_204_172.DashPattern = new float[] { 3, 3 };

            menuVisualNoteProperty.setSelected( AppManager.editorConfig.ShowExpLine );
            menuVisualLyrics.setSelected( AppManager.editorConfig.ShowLyric );
            menuVisualMixer.setSelected( AppManager.editorConfig.MixerVisible );
            menuVisualPitchLine.setSelected( AppManager.editorConfig.ViewAtcualPitch );

            updateMenuFonts();

            AppManager.mMixerWindow.FederChanged += new FederChangedEventHandler( mixerWindow_FederChanged );
            AppManager.mMixerWindow.PanpotChanged += new PanpotChangedEventHandler( mixerWindow_PanpotChanged );
            AppManager.mMixerWindow.MuteChanged += new MuteChangedEventHandler( mixerWindow_MuteChanged );
            AppManager.mMixerWindow.SoloChanged += new SoloChangedEventHandler( mixerWindow_SoloChanged );
            AppManager.mMixerWindow.updateStatus();
            if ( AppManager.editorConfig.MixerVisible ) {
                AppManager.mMixerWindow.setVisible( true );
            }
            AppManager.mMixerWindow.FormClosing += new BFormClosingEventHandler( mixerWindow_FormClosing );

            Point p1 = AppManager.editorConfig.FormIconPaletteLocation.toPoint();
            if ( !PortUtil.isPointInScreens( p1 ) ) {
                Rectangle workingArea = PortUtil.getWorkingArea( this );
                p1 = new Point( workingArea.x, workingArea.y );
            }
            AppManager.iconPalette.setLocation( p1 );
            if ( AppManager.editorConfig.IconPaletteVisible ) {
                AppManager.iconPalette.setVisible( true );
            }
            AppManager.iconPalette.FormClosing += new BFormClosingEventHandler( iconPalette_FormClosing );
            AppManager.iconPalette.LocationChanged += new BEventHandler( iconPalette_LocationChanged );

            trackSelector.CommandExecuted += new BEventHandler( trackSelector_CommandExecuted );

#if ENABLE_SCRIPT
            updateScriptShortcut();
            // RunOnceという名前のスクリプトがあれば，そいつを実行
            for ( Iterator<String> itr = ScriptServer.getScriptIdIterator(); itr.hasNext(); ) {
                String id = itr.next();
                if ( str.compare( PortUtil.getFileNameWithoutExtension( id ).ToLower(), "runonce" ) ) {
                    ScriptServer.invokeScript( id, AppManager.getVsqFile() );
                    break;
                }
            }
#endif

            clearTempWave();
            updateVibratoPresetMenu();
            mPencilMode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
            loadGameControler();
#if ENABLE_MIDI
            reloadMidiIn();
#endif
            menuVisualWaveform.setSelected( AppManager.editorConfig.ViewWaveform );

            updateRendererMenu();

            // ウィンドウの位置・サイズを再現
            if ( AppManager.editorConfig.WindowMaximized ) {
                setExtendedState( BForm.MAXIMIZED_BOTH );
            } else {
                setExtendedState( BForm.NORMAL );
            }
            Rectangle bounds = AppManager.editorConfig.WindowRect;
            this.setBounds( bounds );
            // ウィンドウ位置・サイズの設定値が、使えるディスプレイのどれにも被っていない場合
            Rectangle rc2 = PortUtil.getScreenBounds( this );
            if ( bounds.x < rc2.x ||
                 rc2.x + rc2.width < bounds.x + bounds.width ||
                 bounds.y < rc2.y ||
                 rc2.y + rc2.height < bounds.y + bounds.height ) {
                bounds.x = rc2.x;
                bounds.y = rc2.y;
                this.setBounds( bounds );
                AppManager.editorConfig.WindowRect = bounds;
            }
            this.WindowStateChanged += new BEventHandler( FormMain_WindowStateChanged );
            this.LocationChanged += new BEventHandler( FormMain_LocationChanged );

            updateScrollRangeHorizontal();
            updateScrollRangeVertical();

            // プロパティウィンドウの位置を復元
            Rectangle rc1 = PortUtil.getScreenBounds( this );
            Rectangle rcScreen = new Rectangle( rc1.x, rc1.y, rc1.width, rc1.height );
            Point p = this.getLocation();
            XmlRectangle xr = AppManager.editorConfig.PropertyWindowStatus.Bounds;
            Point p0 = new Point( xr.x, xr.y );
            Point a = new Point( p.x + p0.x, p.y + p0.y );
            Rectangle rc = new Rectangle( a.x,
                                          a.y,
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.getWidth(),
                                          AppManager.editorConfig.PropertyWindowStatus.Bounds.getHeight() );

            if ( a.y > rcScreen.y + rcScreen.height ) {
                a = new Point( a.x, rcScreen.y + rcScreen.height - rc.height );
            }
            if ( a.y < rcScreen.y ) {
                a = new Point( a.x, rcScreen.y );
            }
            if ( a.x > rcScreen.x + rcScreen.width ) {
                a = new Point( rcScreen.x + rcScreen.width - rc.width, a.y );
            }
            if ( a.x < rcScreen.x ) {
                a = new Point( rcScreen.x, a.y );
            }
#if DEBUG
            AppManager.debugWriteLine( "FormMain_Load; a=" + a );
#endif

#if ENABLE_PROPERTY
            AppManager.propertyWindow.setBounds( a.x, a.y, rc.width, rc.height );
            AppManager.propertyWindow.WindowStateChanged += new BEventHandler( propertyWindow_WindowStateChanged );
            AppManager.propertyWindow.LocationChanged += new BEventHandler( propertyWindow_LocationOrSizeChanged );
            AppManager.propertyWindow.SizeChanged += new BEventHandler( propertyWindow_LocationOrSizeChanged );
            AppManager.propertyWindow.FormClosing += new BFormClosingEventHandler( propertyWindow_FormClosing );
            AppManager.propertyPanel.CommandExecuteRequired += new CommandExecuteRequiredEventHandler( propertyPanel_CommandExecuteRequired );
#endif
            updateBgmMenuState();
            AppManager.mLastTrackSelectorHeight = trackSelector.getPreferredMinSize();
            flipControlCurveVisible( true );

            repaint();
            updateLayout();
#if DEBUG
            menuHidden.setVisible( true );
#else
            menuHidden.setVisible( false );
#endif

#if !ENABLE_VOCALOID
            menuTrackRenderer.remove( menuTrackRendererVOCALOID2 );
            menuTrackRenderer.remove( menuTrackRendererVOCALOID1 );
            cMenuTrackTabRenderer.remove( cMenuTrackTabRendererVOCALOID2 );
            cMenuTrackTabRenderer.remove( cMenuTrackTabRendererVOCALOID1 );
#endif

#if !ENABLE_AQUESTONE
            menuTrackRenderer.remove( menuTrackRendererAquesTone );
            cMenuTrackTabRenderer.remove( cMenuTrackTabRendererAquesTone );
#endif

#if JAVA
            menuVisual.remove( menuVisualPluginUi );
            menuSetting.remove( menuSettingGameControler );
#endif

#if JAVA_MAC
            // Macの一般的なメニュー編成にあわせる
            com.apple.eawt.Application app = com.apple.eawt.Application.getApplication();
#if JAVA_1_5
            // 「Cadenciiについて」
            app.setAboutHandler( new com.apple.eawt.AboutHandler(){
                public void handleAbout( com.apple.eawt.AppEvent.AboutEvent arg0 ) {
                    menuHelpAbout_Click( null, null );
                }
            } );

            // 「Cadenciiを終了」
            app.setQuitHandler( new com.apple.eawt.QuitHandler(){
                public void handleQuitRequestWith( com.apple.eawt.AppEvent.QuitEvent arg0, com.apple.eawt.QuitResponse arg1 ) {
                    if( handleFormClosing() ){
                        arg1.cancelQuit();
                    }else{
                        dispose();
                    }
                }
            } );

            // 「環境設定」
            app.setPreferencesHandler( new com.apple.eawt.PreferencesHandler(){
                public void handlePreferences( com.apple.eawt.AppEvent.PreferencesEvent arg0 ){
                    menuSettingPreference_Click( null, null );
                }
            });
#else // JAVA_1_5
	        app.setEnabledPreferencesMenu( true );
	        app.setEnabledAboutMenu( true );
	        app.addApplicationListener( new com.apple.eawt.ApplicationListener(){
				public void handleAbout(ApplicationEvent arg0) {
	                arg0.setHandled( true );
	                menuHelpAbout_Click( null, null );
				}
	
				public void handleOpenApplication(ApplicationEvent arg0) {
				}
	
				public void handleOpenFile(ApplicationEvent arg0) {
				}
	
				public void handlePreferences(ApplicationEvent arg0) {
					menuSettingPreference_Click( null, null );
				}
	
				public void handlePrintFile(ApplicationEvent arg0) {
				}
	
				public void handleQuit(ApplicationEvent arg0) {
					arg0.setHandled( !handleFormClosing() );
				}
	
				public void handleReOpenApplication(ApplicationEvent arg0) {
				}
	        });
#endif
	        menuHelp.remove( menuHelpAbout );
	        menuFile.remove( menuFileSeparator3 );
	        menuFile.remove( menuFileQuit );
	        menuSetting.remove( menuSettingPreference );
#endif // JAVA_MAC

#if !JAVA
#if DEBUG
            System.Collections.Generic.List<ValuePair<String, String>> list = new System.Collections.Generic.List<ValuePair<String, String>>();
            foreach ( System.Reflection.FieldInfo fi in typeof( EditorConfig ).GetFields() ) {
                if ( fi.IsPublic && !fi.IsStatic ) {
                    list.Add( new ValuePair<String, String>( fi.Name, fi.FieldType.ToString() ) );
                }
            }

            foreach ( System.Reflection.PropertyInfo pi in typeof( EditorConfig ).GetProperties() ) {
                if ( !pi.CanRead || !pi.CanWrite ) {
                    continue;
                }
                System.Reflection.MethodInfo getmethod = pi.GetGetMethod();
                System.Reflection.MethodInfo setmethod = pi.GetSetMethod();
                if ( !setmethod.IsPublic || setmethod.IsStatic ) {
                    continue;
                }
                if ( !getmethod.IsPublic || getmethod.IsStatic ) {
                    continue;
                }
                list.Add( new ValuePair<String, String>( pi.Name, pi.PropertyType.ToString() ) );
            }

            list.Sort();

            System.IO.StreamWriter sw = null;
            try {
                sw = new System.IO.StreamWriter( "EditorConfig.txt" );
                foreach ( ValuePair<String, String> s in list ) {
                    sw.WriteLine( s.Key );
                }
                sw.WriteLine( "--------------------------------------------" );
                foreach ( ValuePair<String, String> s in list ) {
                    sw.WriteLine( s.Value + "\t" + s.Key + ";" );
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".ctor; ex=" + ex + "\n" );
            } finally {
                if ( sw != null ) {
                    try {
                        sw.Close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".ctor; ex=" + ex2 + "\n" );
                    }
                }
            }
#endif
#endif
        }
        #endregion

        #region helper methods
        /// <summary>
        /// 指定した歌手とリサンプラーについて，設定値に登録されていないものだったら登録する．
        /// </summary>
        /// <param name="resampler_path"></param>
        /// <param name="singer_path"></param>
        private void checkUnknownResamplerAndSinger( ByRef<String> resampler_path, ByRef<String> singer_path )
        {
            String utau = Utility.getExecutingUtau();
            String utau_dir = "";
            if ( !str.compare( utau, "" ) ) {
                utau_dir = PortUtil.getDirectoryName( utau );
            }

            // 可能なら，VOICEの文字列を置換する
            String search = "%VOICE%";
            if ( str.startsWith( singer_path.value, search ) && str.length( singer_path.value ) > str.length( search ) ) {
                singer_path.value = str.sub( singer_path.value, str.length( search ) );
                singer_path.value = fsys.combine( fsys.combine( utau_dir, "voice" ), singer_path.value );
            }

            // 歌手はknownかunknownか？
            // 歌手指定が知らない歌手だった場合に，ダイアログを出すかどうか
            boolean check_unknown_singer = false;
            if ( fsys.isFileExists( fsys.combine( singer_path.value, "oto.ini" ) ) ) {
                // oto.iniが存在する場合
                // editorConfigに入っていない場合に，ダイアログを出す
                boolean found = false;
                for ( int i = 0; i < vec.size( AppManager.editorConfig.UtauSingers ); i++ ) {
                    SingerConfig sc = vec.get( AppManager.editorConfig.UtauSingers, i );
                    if ( sc == null ) {
                        continue;
                    }
                    if ( str.compare( sc.VOICEIDSTR, singer_path.value ) ) {
                        found = true;
                        break;
                    }
                }
                check_unknown_singer = !found;
            }

            // リサンプラーが知っているやつかどうか
            boolean check_unknwon_resampler = false;
#if DEBUG
            sout.println( "FormMain#checkUnknownResamplerAndSinger; resampler_path.value=" + resampler_path.value );
#endif
            String resampler_dir = PortUtil.getDirectoryName( resampler_path.value );
            if ( str.compare( resampler_dir, "" ) ) {
                // ディレクトリが空欄なので，UTAUのデフォルトのリサンプラー指定である
                resampler_path.value = fsys.combine( utau_dir, resampler_path.value );
                resampler_dir = PortUtil.getDirectoryName( resampler_path.value );
            }
            if ( !str.compare( resampler_dir, "" ) &&  fsys.isFileExists( resampler_path.value ) ) {
                boolean found = false;
                for ( int i = 0; i < AppManager.editorConfig.getResamplerCount(); i++ ) {
                    String resampler = AppManager.editorConfig.getResamplerAt( i );
                    if ( str.compare( resampler, resampler_path.value ) ) {
                        found = true;
                        break;
                    }
                }
                check_unknwon_resampler = !found;
            }

            // unknownな歌手やリサンプラーが発見された場合.
            // 登録するかどうか問い合わせるダイアログを出す
            FormCheckUnknownSingerAndResampler dialog = null;
            try {
                if ( check_unknown_singer || check_unknwon_resampler ) {
                    dialog = new FormCheckUnknownSingerAndResampler( singer_path.value, check_unknown_singer, resampler_path.value, check_unknwon_resampler );
                    dialog.setLocation( getFormPreferedLocation( dialog ) );
                    BDialogResult dr = AppManager.showModalDialog( dialog, this );
                    if ( dr != BDialogResult.OK ) {
                        return;
                    }

                    // 登録する
                    // リサンプラー
                    if ( dialog.isResamplerChecked() ) {
                        String path = dialog.getResamplerPath();
                        if ( fsys.isFileExists( path ) ) {
                            AppManager.editorConfig.addResampler( path, false );
                        }
                    }
                    // 歌手
                    if ( dialog.isSingerChecked() ) {
                        String path = dialog.getSingerPath();
                        if ( fsys.isDirectoryExists( path ) ) {
                            SingerConfig sc = new SingerConfig();
                            Utility.readUtauSingerConfig( path, sc );
                            vec.add( AppManager.editorConfig.UtauSingers, sc );
                        }
                        AppManager.reloadUtauVoiceDB();
                    }
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".checkUnknownResamplerAndSinger; ex=" + ex + "\n" );
            } finally {
                if ( dialog != null ) {
                    try {
                        dialog.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        /// <summary>
        /// ピアノロールの縦軸の拡大率をdelta段階上げます
        /// </summary>
        /// <param name="delta"></param>
        private void zoomY( int delta )
        {
            int scaley = AppManager.editorConfig.PianoRollScaleY;
            int draft = scaley + delta;
            if ( draft < EditorConfig.MIN_PIANOROLL_SCALEY ) {
                draft = EditorConfig.MIN_PIANOROLL_SCALEY;
            }
            if ( EditorConfig.MAX_PIANOROLL_SCALEY < draft ) {
                draft = EditorConfig.MAX_PIANOROLL_SCALEY;
            }
            if ( scaley != draft ) {
                AppManager.editorConfig.PianoRollScaleY = draft;
                updateScrollRangeVertical();
                AppManager.setStartToDrawY( calculateStartToDrawY( vScroll.getValue() ) );
                updateDrawObjectList();
            }
        }

        /// <summary>
        /// ズームスライダの現在の値から，横方向の拡大率を計算します
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        private float getScaleXFromTrackBarValue( int value )
        {
            return value / 480.0f;
        }

        /// <summary>
        /// ユーザー定義のビブラートのプリセット関係のメニューの表示状態を更新します
        /// </summary>
        private void updateVibratoPresetMenu()
        {
#if JAVA
            menuLyricCopyVibratoToPreset.removeAll();
            int size = AppManager.editorConfig.AutoVibratoCustom.size();
            for ( int i = 0; i < size; i++ ) {
                VibratoHandle handle = AppManager.editorConfig.AutoVibratoCustom.get( i );
                BMenuItem item = new BMenuItem();
                item.setText( handle.getCaption() );
                item.clickEvent.add( new BEventHandler( this, "handleVibratoPresetSubelementClick" ) );
                menuLyricCopyVibratoToPreset.add( item );
            }
#else
            // 現在の項目数に過不足があれば調節する
            int size = AppManager.editorConfig.AutoVibratoCustom.size();
            int delta = size - menuLyricCopyVibratoToPreset.DropDownItems.Count;
            if ( delta > 0 ) {
                // 項目を増やさないといけない
                for ( int i = 0; i < delta; i++ ) {
                    System.Windows.Forms.ToolStripMenuItem item =
                        new System.Windows.Forms.ToolStripMenuItem(
                            "", null, new BEventHandler( handleVibratoPresetSubelementClick ) );
                    menuLyricCopyVibratoToPreset.DropDownItems.Add( item );
                }
            } else if ( delta < 0 ) {
                // 項目を減らさないといけない
                for ( int i = 0; i < -delta; i++ ) {
                    System.Windows.Forms.ToolStripItem item = menuLyricCopyVibratoToPreset.DropDownItems[0];
                    menuLyricCopyVibratoToPreset.DropDownItems.RemoveAt( 0 );
                    item.Dispose();
                }
            }

            // 表示状態を更新
            for ( int i = 0; i < size; i++ ) {
                VibratoHandle handle = AppManager.editorConfig.AutoVibratoCustom.get( i );
                menuLyricCopyVibratoToPreset.DropDownItems[i].Text = handle.getCaption();
            }
#endif
        }

        /// <summary>
        /// MIDIステップ入力中に，ソングポジションが動いたときの処理を行います
        /// AppManager.mAddingEventが非nullの時，音符の先頭は決まっているので，
        /// ソングポジションと，音符の先頭との距離から音符の長さを算出し，更新する
        /// AppManager.mAddingEventがnullの時は何もしない
        /// </summary>
        private void updateNoteLengthStepSequencer()
        {
            if ( !isStepSequencerEnabled() ) {
                return;
            }

            VsqEvent item = AppManager.mAddingEvent;
            if ( item == null ) {
                return;
            }

            int song_position = AppManager.getCurrentClock();
            int start = item.Clock;
            int length = song_position - start;
            if ( length < 0 ) length = 0;
            Utility.editLengthOfVsqEvent(
                item,
                length,
                AppManager.vibratoLengthEditingRule );
        }

        /// <summary>
        /// 現在追加しようとしている音符の内容(AppManager.mAddingEvent)をfixします
        /// </summary>
        /// <returns></returns>
        private void fixAddingEvent()
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            LyricHandle lyric = new LyricHandle( "あ", "a" );
            VibratoHandle vibrato = null;
            int vibrato_delay = 0;
            if ( AppManager.editorConfig.EnableAutoVibrato ) {
                int note_length = AppManager.mAddingEvent.ID.getLength();
                // 音符位置での拍子を調べる
                Timesig timesig = vsq.getTimesigAt( AppManager.mAddingEvent.Clock );

                // ビブラートを自動追加するかどうかを決める閾値
                int threshold = AppManager.editorConfig.AutoVibratoThresholdLength;
                if ( note_length >= threshold ) {
                    int vibrato_clocks = 0;
                    if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L100 ) {
                        vibrato_clocks = note_length;
                    } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L50 ) {
                        vibrato_clocks = note_length / 2;
                    } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L66 ) {
                        vibrato_clocks = note_length * 2 / 3;
                    } else if ( AppManager.editorConfig.DefaultVibratoLength == DefaultVibratoLengthEnum.L75 ) {
                        vibrato_clocks = note_length * 3 / 4;
                    }
                    SynthesizerType type = SynthesizerType.VOCALOID2;
                    RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                    if ( kind == RendererKind.VOCALOID1 ) {
                        type = SynthesizerType.VOCALOID1;
                    }
                    vibrato = AppManager.editorConfig.createAutoVibrato( type, vibrato_clocks );
                    vibrato_delay = note_length - vibrato_clocks;
                }
            }

            // oto.iniの設定を反映
            VsqEvent item = vsq_track.getSingerEventAt( AppManager.mAddingEvent.Clock );
            SingerConfig singerConfig = null;
            if ( item != null && item.ID != null && item.ID.IconHandle != null ) {
                singerConfig = AppManager.getSingerInfoUtau( item.ID.IconHandle.Language, item.ID.IconHandle.Program );
            }

            if ( singerConfig != null && AppManager.mUtauVoiceDB.containsKey( singerConfig.VOICEIDSTR ) ) {
                UtauVoiceDB utauVoiceDb = AppManager.mUtauVoiceDB.get( singerConfig.VOICEIDSTR );
                OtoArgs otoArgs = utauVoiceDb.attachFileNameFromLyric( lyric.L0.Phrase );
                AppManager.mAddingEvent.UstEvent.setPreUtterance( otoArgs.msPreUtterance );
                AppManager.mAddingEvent.UstEvent.setVoiceOverlap( otoArgs.msOverlap );
            }

            // 自動ノーマライズのモードで、処理を分岐
            if ( AppManager.mAutoNormalize ) {
                VsqTrack work = (VsqTrack)vsq_track.clone();
                AppManager.mAddingEvent.ID.type = VsqIDType.Anote;
                AppManager.mAddingEvent.ID.Dynamics = 64;
                AppManager.mAddingEvent.ID.VibratoHandle = vibrato;
                AppManager.mAddingEvent.ID.LyricHandle = lyric;
                AppManager.mAddingEvent.ID.VibratoDelay = vibrato_delay;

                boolean changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < work.getEventCount(); i++ ) {
                        int start_clock = work.getEvent( i ).Clock;
                        int end_clock = work.getEvent( i ).ID.getLength() + start_clock;
                        if ( start_clock < AppManager.mAddingEvent.Clock && AppManager.mAddingEvent.Clock < end_clock ) {
                            work.getEvent( i ).ID.setLength( AppManager.mAddingEvent.Clock - start_clock );
                            changed = true;
                        } else if ( start_clock == AppManager.mAddingEvent.Clock ) {
                            work.removeEvent( i );
                            changed = true;
                            break;
                        } else if ( AppManager.mAddingEvent.Clock < start_clock && start_clock < AppManager.mAddingEvent.Clock + AppManager.mAddingEvent.ID.getLength() ) {
                            AppManager.mAddingEvent.ID.setLength( start_clock - AppManager.mAddingEvent.Clock );
                            changed = true;
                        }
                    }
                }
                VsqEvent add = (VsqEvent)AppManager.mAddingEvent.clone();
                work.addEvent( add );
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                             work,
                                                                             AppManager.getVsqFile().AttachedCurves.get( selected - 1 ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            } else {
                VsqEvent[] items = new VsqEvent[1];
                AppManager.mAddingEvent.ID.type = VsqIDType.Anote;
                AppManager.mAddingEvent.ID.Dynamics = 64;
                items[0] = (VsqEvent)AppManager.mAddingEvent.clone();// new VsqEvent( 0, AppManager.addingEvent.ID );
                items[0].Clock = AppManager.mAddingEvent.Clock;
                items[0].ID.LyricHandle = lyric;
                items[0].ID.VibratoDelay = vibrato_delay;
                items[0].ID.VibratoHandle = vibrato;

                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAddRange( AppManager.getSelected(), items ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            }
        }

        /// <summary>
        /// 現在のツールバーの場所を保存します
        /// </summary>
        private void saveToolbarLocation()
        {
#if JAVA
            // TODO:
#else
            if ( this.WindowState == System.Windows.Forms.FormWindowState.Minimized ) return;
            // どのツールバーが一番上かつ左にあるか？
            var list = new System.Collections.Generic.List<RebarBand>();
            list.AddRange( new RebarBand[]{
                bandFile,
                bandMeasure,
                bandPosition,
                bandTool } );
            // ソートする
            boolean changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < list.Count - 1; i++ ) {
                    // y座標が大きいか，y座標が同じでもx座標が大きい場合に入れ替える
                    boolean swap =
                        (list[i].Location.Y > list[i + 1].Location.Y) ||
                        (list[i].Location.Y == list[i + 1].Location.Y && list[i].Location.X > list[i + 1].Location.X);
                    if ( swap ) {
                        var a = list[i];
                        list[i] = list[i + 1];
                        list[i + 1] = a;
                        changed = true;
                    }
                }
            }
            // 各ツールバー毎に，ツールバーの状態を検出して保存
            saveToolbarLocationCore(
                list,
                bandFile,
                out AppManager.editorConfig.BandSizeFile,
                out AppManager.editorConfig.BandNewRowFile,
                out AppManager.editorConfig.BandOrderFile );
            saveToolbarLocationCore(
                list,
                bandMeasure,
                out AppManager.editorConfig.BandSizeMeasure,
                out AppManager.editorConfig.BandNewRowMeasure,
                out AppManager.editorConfig.BandOrderMeasure );
            saveToolbarLocationCore(
                list,
                bandPosition,
                out AppManager.editorConfig.BandSizePosition,
                out AppManager.editorConfig.BandNewRowPosition,
                out AppManager.editorConfig.BandOrderPosition );
            saveToolbarLocationCore(
                list,
                bandTool,
                out AppManager.editorConfig.BandSizeTool,
                out AppManager.editorConfig.BandNewRowTool,
                out AppManager.editorConfig.BandOrderTool );
#endif
        }

#if !JAVA
        /// <summary>
        /// ツールバーの位置の順に並べ替えたリストの中の一つのツールバーに対して，その状態を検出して保存
        /// </summary>
        /// <param name="list"></param>
        /// <param name="band"></param>
        /// <param name="band_size"></param>
        /// <param name="new_row"></param>
        private void saveToolbarLocationCore(
            System.Collections.Generic.List<RebarBand> list,
            RebarBand band,
            out int band_size,
            out bool new_row,
            out int band_order )
        {
            band_size = 0;
            new_row = true;
            band_order = 0;
            var indx = list.IndexOf( band );
            if ( indx < 0 ) return;
            new_row = (indx == 0) ? false : (list[indx - 1].Location.Y < list[indx].Location.Y);
            band_size = band.BandSize;
            band_order = indx;
        }
#endif

        private static int doQuantize( int clock, int unit )
        {
            int odd = clock % unit;
            int new_clock = clock - odd;
            if ( odd > unit / 2 ) {
                new_clock += unit;
            }
            return new_clock;
        }

        /// <summary>
        /// 波形表示部のズームボタンの形を取得します
        /// </summary>
        /// <returns></returns>
        private Rectangle getButtonBoundsWaveViewZoom()
        {
            int width = AppManager.keyWidth - 1;
            int height = panel2.getHeight() - 1;

            int y = SPACE + 16 + SPACE;
            return new Rectangle( SPACE, y, width - SPACE - SPACE, height - SPACE - y );
        }

        /// <summary>
        /// デフォルトのストロークを取得します
        /// </summary>
        /// <returns></returns>
        private BasicStroke getStrokeDefault()
        {
            if ( mStrokeDefault == null ) {
                mStrokeDefault = new BasicStroke();
            }
            return mStrokeDefault;
        }

        /// <summary>
        /// 描画幅が2pxのストロークを取得します
        /// </summary>
        /// <returns></returns>
        private BasicStroke getStroke2px()
        {
            if ( mStroke2px == null ) {
                mStroke2px = new BasicStroke( 2.0f );
            }
            return mStroke2px;
        }

        /// <summary>
        /// 選択された音符の長さを、指定したゲートタイム分長くします。
        /// </summary>
        /// <param name="delta_length"></param>
        private void lengthenSelectedEvent( int delta_length )
        {
            if ( delta_length == 0 ) {
                return;
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }

            int selected = AppManager.getSelected();

            Vector<VsqEvent> items = new Vector<VsqEvent>();
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.ID.type != VsqIDType.Anote &&
                     item.editing.ID.type != VsqIDType.Aicon ) {
                    continue;
                }

                // クレッシェンド、デクレッシェンドでないものを省く
                if ( item.editing.ID.type == VsqIDType.Aicon ) {
                    if ( item.editing.ID.IconDynamicsHandle == null ) {
                        continue;
                    }
                    if ( !item.editing.ID.IconDynamicsHandle.isCrescendType() &&
                         !item.editing.ID.IconDynamicsHandle.isDecrescendType() ) {
                        continue;
                    }
                }

                // 長さを変える。0未満になると0に直す
                int length = item.editing.ID.getLength();
                int draft = length + delta_length;
                if ( draft < 0 ) {
                    draft = 0;
                }
                if ( length == draft ) {
                    continue;
                }

                // ビブラートの長さを変更
                VsqEvent add = (VsqEvent)item.editing.clone();
                Utility.editLengthOfVsqEvent( add, draft, AppManager.vibratoLengthEditingRule );
                items.add( add );
            }

            if ( items.size() <= 0 ) {
                return;
            }

            // コマンドを発行
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventReplaceRange(
                    selected, items.toArray( new VsqEvent[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );

            // 編集されたものを再選択する
            for ( Iterator<VsqEvent> itr = items.iterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                AppManager.addSelectedEvent( item.InternalID );
            }

            // 編集が施された。
            setEdited( true );
            updateDrawObjectList();

            refreshScreen();
        }

        /// <summary>
        /// 選択された音符の音程とゲートタイムを、指定されたノートナンバーおよびゲートタイム分上下させます。
        /// </summary>
        /// <param name="delta_note"></param>
        /// <param name="delta_clock"></param>
        private void moveUpDownLeftRight( int delta_note, int delta_clock )
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }

            Vector<VsqEvent> items = new Vector<VsqEvent>();
            int selected = AppManager.getSelected();
            int note_max = -1;
            int note_min = 129;
            int clock_max = int.MinValue;
            int clock_min = int.MaxValue;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.ID.type != VsqIDType.Anote ) {
                    continue;
                }
                VsqEvent add = null;

                // 音程
                int note = item.editing.ID.Note;
                if ( delta_note != 0 && 0 <= note + delta_note && note + delta_note <= 127 ) {
                    add = (VsqEvent)item.editing.clone();
                    add.ID.Note += delta_note;
                    note_max = Math.Max( note_max, add.ID.Note );
                    note_min = Math.Min( note_min, add.ID.Note );
                }

                // ゲートタイム
                int clockstart = item.editing.Clock;
                int clockend = clockstart + item.editing.ID.getLength();
                if ( delta_clock != 0 ) {
                    if ( add == null ) {
                        add = (VsqEvent)item.editing.clone();
                    }
                    add.Clock += delta_clock;
                    clock_max = Math.Max( clock_max, clockend + delta_clock );
                    clock_min = Math.Min( clock_min, clockstart );
                }

                if ( add != null ) {
                    items.add( add );
                }
            }
            if ( items.size() <= 0 ) {
                return;
            }

            // コマンドを発行
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventReplaceRange(
                    selected, items.toArray( new VsqEvent[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );

            // 編集されたものを再選択する
            for ( Iterator<VsqEvent> itr = items.iterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                AppManager.addSelectedEvent( item.InternalID );
            }

            // 編集が施された。
            setEdited( true );
            updateDrawObjectList();

            // 音符が見えるようにする。音程方向
            if ( delta_note > 0 ) {
                note_max++;
                if ( 127 < note_max ) {
                    note_max = 127;
                }
                ensureVisibleY( note_max );
            } else if ( delta_note < 0 ) {
                note_min -= 2;
                if ( note_min < 0 ) {
                    note_min = 0;
                }
                ensureVisibleY( note_min );
            }

            // 音符が見えるようにする。時間方向
            if ( delta_clock > 0 ) {
                ensureVisible( clock_max );
            } else if ( delta_clock < 0 ) {
                ensureVisible( clock_min );
            }
            refreshScreen();
        }

        private VsqEvent getItemAtClickedPosition( Point mouse_position, ByRef<Rectangle> rect )
        {
            rect.value = new Rectangle();
            if ( mouse_position.x < AppManager.keyWidth || pictPianoRoll.getWidth() < mouse_position.x ) {
                return null;
            }
            if ( mouse_position.y < 0 || pictPianoRoll.getHeight() < mouse_position.y ) {
                return null;
            }
            int selected = AppManager.getSelected();
            if ( selected < 1 ) {
                return null;
            }
            lock ( AppManager.mDrawObjects ) {
                Vector<DrawObject> dobj_list = AppManager.mDrawObjects.get( selected - 1 );
                int count = dobj_list.size();
                int start_to_draw_x = AppManager.getStartToDrawX();
                int start_to_draw_y = AppManager.getStartToDrawY();
                int key_width = AppManager.keyWidth;
                int pianoroll_width = pictPianoRoll.getWidth();
                for ( int i = 0; i < count; i++ ) {
                    DrawObject dobj = dobj_list.get( i );
                    int x = dobj.mRectangleInPixel.x + key_width - start_to_draw_x;
                    int y = dobj.mRectangleInPixel.y - start_to_draw_y;
                    if ( mouse_position.x < x ) {
                        continue;
                    }
                    if ( x + dobj.mRectangleInPixel.width < mouse_position.x ) {
                        continue;
                    }
                    if ( pianoroll_width < x ) {
                        break;
                    }
                    if ( mouse_position.y < y ) {
                        continue;
                    }
                    if ( y + dobj.mRectangleInPixel.height < mouse_position.y ) {
                        continue;
                    }
                    int internal_id = dobj.mInternalID;
                    VsqTrack vsq_track = AppManager.getVsqFile().Track.get( selected );
                    for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                        VsqEvent item = itr.next();
                        if ( item.InternalID == internal_id ) {
                            rect.value = new Rectangle( x, y, dobj.mRectangleInPixel.width, dobj.mRectangleInPixel.height );
                            return item;
                        }
                    }
                }
            }
            return null;
        }

        /// <summary>
        /// マウス位置におけるIDを返します。該当するIDが無ければnullを返します
        /// rectには、該当するIDがあればその画面上での形状を、該当するIDがなければ、
        /// 画面上で最も近かったIDの画面上での形状を返します
        /// </summary>
        /// <param name="mouse_position"></param>
        /// <returns></returns>
        private VsqEvent getItemAtClickedPosition_old( Point mouse_position, ByRef<Rectangle> rect )
        {
            rect.value = new Rectangle();
            if ( AppManager.keyWidth <= mouse_position.x && mouse_position.x <= pictPianoRoll.getWidth() ) {
                if ( 0 <= mouse_position.y && mouse_position.y <= pictPianoRoll.getHeight() ) {
                    int selected = AppManager.getSelected();
                    if ( selected >= 1 ) {
                        VsqFileEx vsq = AppManager.getVsqFile();
                        VsqTrack vsq_track = vsq.Track.get( selected );
                        int track_height = (int)(AppManager.getScaleY() * 100);
                        int count = vsq_track.getEventCount();
                        for ( int j = 0; j < count; j++ ) {
                            VsqEvent itemj = vsq_track.getEvent( j );
                            int clock = itemj.Clock;
                            int internal_id = itemj.InternalID;
                            // イベントで指定されたIDがLyricであった場合
                            if ( itemj.ID.type == VsqIDType.Anote ) {
                                if ( itemj.ID.LyricHandle == null ) {
                                    continue;
                                }
                                // 発音長を取得
                                int length = itemj.ID.getLength();
                                int note = itemj.ID.Note;
                                int x = AppManager.xCoordFromClocks( clock );
                                int y = AppManager.yCoordFromNote( note );
                                int lyric_width = (int)(length * AppManager.getScaleX());
                                if ( x + lyric_width < 0 ) {
                                    continue;
                                } else if ( pictPianoRoll.getWidth() < x ) {
                                    break;
                                }
                                if ( x <= mouse_position.x && mouse_position.x <= x + lyric_width ) {
                                    if ( y + 1 <= mouse_position.y && mouse_position.y <= y + track_height ) {
                                        rect.value = new Rectangle( x, y + 1, lyric_width, track_height );
                                        return itemj;
                                    }
                                }
                            } else if ( itemj.ID.type == VsqIDType.Aicon ) {
                                if ( itemj.ID.IconDynamicsHandle == null ) {
                                    continue;
                                }
                                int length = itemj.ID.getLength();
                                int note = itemj.ID.Note;
                                int x = AppManager.xCoordFromClocks( clock );
                                int y = AppManager.yCoordFromNote( note );
                                //int lyric_width = 
                            }
                        }
                    }
                }
            }
            return null;
        }

        /// <summary>
        /// 真ん中ボタンで画面を移動させるときの、vScrollの値を計算します。
        /// 計算には、mButtonInitial, mMiddleButtonVScrollの値が使われます。
        /// </summary>
        /// <returns></returns>
        private int computeVScrollValueForMiddleDrag( int mouse_y )
        {
            int dy = mouse_y - mButtonInitial.y;
            int max = vScroll.getMaximum() - vScroll.getVisibleAmount();
            int min = vScroll.getMinimum();
            double new_vscroll_value = (double)mMiddleButtonVScroll - dy * max / (128.0 * (int)(100.0 * AppManager.getScaleY()) - (double)pictPianoRoll.getHeight());
            int value = (int)new_vscroll_value;
            if ( value < min ) {
                value = min;
            } else if ( max < value ) {
                value = max;
            }
            return value;
        }

        /// <summary>
        /// 真ん中ボタンで画面を移動させるときの、hScrollの値を計算します。
        /// 計算には、mButtonInitial, mMiddleButtonHScrollの値が使われます。
        /// </summary>
        /// <returns></returns>
        private int computeHScrollValueForMiddleDrag( int mouse_x )
        {
            int dx = mouse_x - mButtonInitial.x;
            int max = hScroll.getMaximum() - hScroll.getVisibleAmount();
            int min = hScroll.getMinimum();
            double new_hscroll_value = (double)mMiddleButtonHScroll - (double)dx * AppManager.getScaleXInv();
            int value = (int)new_hscroll_value;
            if ( value < min ) {
                value = min;
            } else if ( max < value ) {
                value = max;
            }
            return value;
        }

        /// <summary>
        /// 仮想スクリーン上でみた時の，現在のピアノロール画面の上端のy座標が指定した値とするための，vScrollの値を計算します
        /// calculateStartToDrawYの逆関数です
        /// </summary>
        private int calculateVScrollValueFromStartToDrawY( int start_to_draw_y )
        {
            return (int)(start_to_draw_y / AppManager.getScaleY());
        }

        /// <summary>
        /// 現在表示されているピアノロール画面の右上の、仮想スクリーン上座標で見たときのy座標(pixel)を取得します
        /// </summary>
        private int calculateStartToDrawY( int vscroll_value )
        {
            int min = vScroll.getMinimum();
            int max = vScroll.getMaximum() - vScroll.getVisibleAmount();
            int value = vscroll_value;
            if ( value < min ) {
                value = min;
            } else if ( max < value ) {
                value = max;
            }
            return (int)(value * AppManager.getScaleY());
        }
        #endregion

        #region public methods
        /// <summary>
        /// デフォルトのショートカットキーを格納したリストを取得します
        /// </summary>
        public Vector<ValuePairOfStringArrayOfKeys> getDefaultShortcutKeys()
        {
#if JAVA_MAC
            BKeys ctrl = BKeys.Menu;
#else
            BKeys ctrl = BKeys.Control;
#endif
            Vector<ValuePairOfStringArrayOfKeys> ret = new Vector<ValuePairOfStringArrayOfKeys>( Arrays.asList(
                new ValuePairOfStringArrayOfKeys[]{
                new ValuePairOfStringArrayOfKeys( menuFileNew.getName(), new BKeys[]{ ctrl, BKeys.N } ),
                new ValuePairOfStringArrayOfKeys( menuFileOpen.getName(), new BKeys[]{ ctrl, BKeys.O } ),
                new ValuePairOfStringArrayOfKeys( menuFileOpenVsq.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileSave.getName(), new BKeys[]{ ctrl, BKeys.S } ),
                new ValuePairOfStringArrayOfKeys( menuFileQuit.getName(), new BKeys[]{ ctrl, BKeys.Q } ),
                new ValuePairOfStringArrayOfKeys( menuFileSaveNamed.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileImportVsq.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileOpenUst.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileImportMidi.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileExportWave.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuFileExportMidi.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuEditUndo.getName(), new BKeys[]{ ctrl, BKeys.Z } ),
                new ValuePairOfStringArrayOfKeys( menuEditRedo.getName(), new BKeys[]{ ctrl, BKeys.Shift, BKeys.Z } ),
                new ValuePairOfStringArrayOfKeys( menuEditCut.getName(), new BKeys[]{ ctrl, BKeys.X } ),
                new ValuePairOfStringArrayOfKeys( menuEditCopy.getName(), new BKeys[]{ ctrl, BKeys.C } ),
                new ValuePairOfStringArrayOfKeys( menuEditPaste.getName(), new BKeys[]{ ctrl, BKeys.V } ),
                new ValuePairOfStringArrayOfKeys( menuEditSelectAll.getName(), new BKeys[]{ ctrl, BKeys.A } ),
                new ValuePairOfStringArrayOfKeys( menuEditSelectAllEvents.getName(), new BKeys[]{ ctrl, BKeys.Shift, BKeys.A } ),
                new ValuePairOfStringArrayOfKeys( menuEditDelete.getName(), new BKeys[]{ BKeys.Back } ),
                new ValuePairOfStringArrayOfKeys( menuVisualMixer.getName(), new BKeys[]{ BKeys.F3 } ),
                new ValuePairOfStringArrayOfKeys( menuVisualWaveform.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualProperty.getName(), new BKeys[]{ BKeys.F6 } ),
                new ValuePairOfStringArrayOfKeys( menuVisualGridline.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualStartMarker.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualEndMarker.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualLyrics.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualNoteProperty.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualPitchLine.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuVisualIconPalette.getName(), new BKeys[]{ BKeys.F4 } ),
                new ValuePairOfStringArrayOfKeys( menuJobNormalize.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuJobInsertBar.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuJobDeleteBar.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuJobRandomize.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuJobConnect.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuJobLyric.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackOn.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackAdd.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackCopy.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackChangeName.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackDelete.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackRenderCurrent.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackRenderAll.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackOverlay.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackRendererVOCALOID1.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackRendererVOCALOID2.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuTrackRendererUtau.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuLyricExpressionProperty.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuLyricVibratoProperty.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuLyricDictionary.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuScriptUpdate.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuSettingPreference.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuSettingGameControlerSetting.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuSettingGameControlerLoad.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuSettingPaletteTool.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuSettingShortcut.getName(), new BKeys[]{} ),
                //new ValuePairOfStringArrayOfKeys( menuSettingSingerProperty.getName(), new BKeys[]{} ),
#if JAVA
                new ValuePairOfStringArrayOfKeys( menuWindowMinimize.getName(), new BKeys[]{ ctrl, BKeys.M } ),
#endif
                new ValuePairOfStringArrayOfKeys( menuHelpAbout.getName(), new BKeys[]{} ),
                new ValuePairOfStringArrayOfKeys( menuHiddenEditLyric.getName(), new BKeys[]{ BKeys.F2 } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenEditFlipToolPointerPencil.getName(), new BKeys[]{ ctrl, BKeys.W } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenEditFlipToolPointerEraser.getName(), new BKeys[]{ ctrl, BKeys.E } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenVisualForwardParameter.getName(), new BKeys[]{ ctrl, BKeys.Alt, BKeys.PageDown } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenVisualBackwardParameter.getName(), new BKeys[]{ ctrl, BKeys.Alt, BKeys.PageUp } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenTrackNext.getName(), new BKeys[]{ ctrl, BKeys.PageDown } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenTrackBack.getName(), new BKeys[]{ ctrl, BKeys.PageUp } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenSelectBackward.getName(), new BKeys[]{ BKeys.Alt, BKeys.Left } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenSelectForward.getName(), new BKeys[]{ BKeys.Alt, BKeys.Right } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenMoveUp.getName(), new BKeys[]{ BKeys.Shift, BKeys.Up } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenMoveDown.getName(), new BKeys[]{ BKeys.Shift, BKeys.Down } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenMoveLeft.getName(), new BKeys[]{ BKeys.Shift, BKeys.Left } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenMoveRight.getName(), new BKeys[]{ BKeys.Shift, BKeys.Right } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenLengthen.getName(), new BKeys[]{ ctrl, BKeys.Right } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenShorten.getName(), new BKeys[]{ ctrl, BKeys.Left } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenGoToEndMarker.getName(), new BKeys[]{ ctrl, BKeys.End } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenGoToStartMarker.getName(), new BKeys[]{ ctrl, BKeys.Home } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenPlayFromStartMarker.getName(), new BKeys[]{ ctrl, BKeys.Enter } ),
                new ValuePairOfStringArrayOfKeys( menuHiddenFlipCurveOnPianorollMode.getName(), new BKeys[]{ BKeys.Tab } ),
            } ) );
            return ret;
        }

        /// <summary>
        /// MIDIステップ入力モードがONかどうかを取得します
        /// </summary>
        /// <returns></returns>
        public boolean isStepSequencerEnabled()
        {
            return mStepSequencerEnabled;
        }

        /// <summary>
        /// マウスの真ん中ボタンが押されたかどうかを調べます。
        /// スペースキー+左ボタンで真ん中ボタンとみなすかどうか、というオプションも考慮される。
        /// </summary>
        /// <param name="button"></param>
        /// <returns></returns>
        public boolean isMouseMiddleButtonDowned( BMouseButtons button )
        {
            boolean ret = false;
            if ( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier ) {
                if ( mSpacekeyDowned && button == BMouseButtons.Left ) {
                    ret = true;
                }
            } else {
                if ( button == BMouseButtons.Middle ) {
                    ret = true;
                }
            }
            return ret;
        }

        /// <summary>
#if USE_BGWORK_SCREEN
        /// 画面をメインスレッドとは別のワーカースレッドを用いて再描画します。
#else
        /// 画面を再描画します。
#endif
        /// 再描画間隔が設定値より短い場合再描画がスキップされます。
        /// </summary>
        public void refreshScreen( boolean force )
        {
#if JAVA
            //refreshScreenCore( this, null );
            this.repaint();
            //trackSelector.repaint();
#else
#if USE_BGWORK_SCREEN
            if ( !bgWorkScreen.IsBusy ) {
                double now = PortUtil.getCurrentTime();
                double dt = now - mLastScreenRefreshedSec;
                double mindt = 1.0 / AppManager.editorConfig.MaximumFrameRate;
                if ( dt > mindt ) {
                    mLastScreenRefreshedSec = now;
                    bgWorkScreen.RunWorkerAsync();
                }
            }
#else
            if ( mIsRefreshing ) {
                return;
            } else {
                double now = PortUtil.getCurrentTime();
                double dt = now - mLastScreenRefreshedSec;
                double mindt = 1.0 / AppManager.editorConfig.MaximumFrameRate;
                if ( force || (!force && dt > mindt) ) {
                    mIsRefreshing = true;

                    mLastScreenRefreshedSec = now;
                    refreshScreenCore( this, null );

                    mIsRefreshing = false;
                }
            }
#endif
#endif
        }

        public void refreshScreen()
        {
            refreshScreen( false );
        }

        public void refreshScreenCore( Object sender, EventArgs e )
        {
#if MONITOR_FPS
            double t0 = PortUtil.getCurrentTime();
#endif
            pictPianoRoll.repaint();
            picturePositionIndicator.repaint();
            trackSelector.repaint();
            pictureBox2.repaint();
            if ( menuVisualWaveform.isSelected() ) {
                waveView.repaint();
            }
            if ( AppManager.editorConfig.OverviewEnabled ) {
                panelOverview.repaint();
            }
#if MONITOR_FPS
            double t = PortUtil.getCurrentTime();
            mFpsDrawTime[mFpsDrawTimeIndex] = t;
            mFpsDrawTime2[mFpsDrawTimeIndex] = t - t0;

            mFpsDrawTimeIndex++;
            if ( mFpsDrawTimeIndex >= mFpsDrawTime.Length ) {
                mFpsDrawTimeIndex = 0;
            }
            mFps = (float)(mFpsDrawTime.Length / (t - mFpsDrawTime[mFpsDrawTimeIndex]));

            int cnt = 0;
            double sum = 0.0;
            for ( int i = 0; i < mFpsDrawTime2.Length; i++ ) {
                double v = mFpsDrawTime2[i];
                if ( v > 0.0f ) {
                    cnt++;
                }
                sum += v;
            }
            mFps2 = (float)(cnt / sum);
#endif
        }

        /// <summary>
        /// 現在のゲームコントローラのモードに応じてstripLblGameCtrlModeの表示状態を更新します。
        /// </summary>
        public void updateGameControlerStatus( Object sender, EventArgs e )
        {
#if !JAVA
            if ( mGameMode == GameControlMode.DISABLED ) {
                stripLblGameCtrlMode.setText( _( "Disabled" ) );
                stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else if ( mGameMode == GameControlMode.CURSOR ) {
                stripLblGameCtrlMode.setText( _( "Cursor" ) );
                stripLblGameCtrlMode.setIcon( null );
            } else if ( mGameMode == GameControlMode.KEYBOARD ) {
                stripLblGameCtrlMode.setText( _( "Keyboard" ) );
                stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_piano() ) );
            } else if ( mGameMode == GameControlMode.NORMAL ) {
                stripLblGameCtrlMode.setText( _( "Normal" ) );
                stripLblGameCtrlMode.setIcon( null );
            }
#endif
        }

        public int calculateStartToDrawX()
        {
            return (int)(hScroll.getValue() * AppManager.getScaleX());
        }

        /// <summary>
        /// 現在選択されている音符よりも1個前方の音符を選択しなおします。
        /// </summary>
        public void selectBackward()
        {
            int count = AppManager.getSelectedEventCount();
            if ( count <= 0 ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 選択されている音符のうち、最も前方にあるものがどれかを調べる
            int min_clock = int.MaxValue;
            int internal_id = -1;
            VsqIDType type = VsqIDType.Unknown;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( item.editing.Clock <= min_clock ) {
                    min_clock = item.editing.Clock;
                    internal_id = item.original.InternalID;
                    type = item.original.ID.type;
                }
            }
            if ( internal_id == -1 || type == VsqIDType.Unknown ) {
                return;
            }

            // 1個前のアイテムのIDを検索
            int last_id = -1;
            int clock = AppManager.getCurrentClock();
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                if ( item.ID.type != type ) {
                    continue;
                }
                if ( item.InternalID == internal_id ) {
                    break;
                }
                last_id = item.InternalID;
                clock = item.Clock;
            }
            if ( last_id == -1 ) {
                return;
            }

            // 選択しなおす
            AppManager.clearSelectedEvent();
            AppManager.addSelectedEvent( last_id );
            ensureVisible( clock );
        }

        /// <summary>
        /// 現在選択されている音符よりも1個後方の音符を選択しなおします。
        /// </summary>
        public void selectForward()
        {
            int count = AppManager.getSelectedEventCount();
            if ( count <= 0 ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 選択されている音符のうち、最も後方にあるものがどれかを調べる
            int max_clock = int.MinValue;
            int internal_id = -1;
            VsqIDType type = VsqIDType.Unknown;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                if ( max_clock <= item.editing.Clock ) {
                    max_clock = item.editing.Clock;
                    internal_id = item.original.InternalID;
                    type = item.original.ID.type;
                }
            }
            if ( internal_id == -1 || type == VsqIDType.Unknown ) {
                return;
            }

            // 1個後ろのアイテムのIDを検索
            int last_id = -1;
            int clock = AppManager.getCurrentClock();
            boolean break_next = false;
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                if ( item.ID.type != type ) {
                    continue;
                }
                if ( item.InternalID == internal_id ) {
                    break_next = true;
                    last_id = item.InternalID;
                    clock = item.Clock;
                    continue;
                }
                last_id = item.InternalID;
                clock = item.Clock;
                if ( break_next ) {
                    break;
                }
            }
            if ( last_id == -1 ) {
                return;
            }

            // 選択しなおす
            AppManager.clearSelectedEvent();
            AppManager.addSelectedEvent( last_id );
            ensureVisible( clock );
        }

        public void invalidatePictOverview( Object sender, EventArgs e )
        {
            panelOverview.invalidate();
        }

        public void updateBgmMenuState()
        {
            menuTrackBgm.removeAll();
            int count = AppManager.getBgmCount();
            if ( count > 0 ) {
                for ( int i = 0; i < count; i++ ) {
                    BgmFile item = AppManager.getBgm( i );
                    BMenu menu = new BMenu();
                    menu.setText( PortUtil.getFileName( item.file ) );
                    menu.setToolTipText( item.file );

                    BgmMenuItem menu_remove = new BgmMenuItem( i );
                    menu_remove.setText( _( "Remove" ) );
                    menu_remove.setToolTipText( item.file );
                    menu_remove.Click += new BEventHandler( handleBgmRemove_Click );
                    menu.add( menu_remove );

                    BgmMenuItem menu_start_after_premeasure = new BgmMenuItem( i );
                    menu_start_after_premeasure.setText( _( "Start After Premeasure" ) );
                    menu_start_after_premeasure.setName( "menu_start_after_premeasure" + i );
                    menu_start_after_premeasure.setCheckOnClick( true );
                    menu_start_after_premeasure.setSelected( item.startAfterPremeasure );
                    menu_start_after_premeasure.CheckedChanged += new BEventHandler( handleBgmStartAfterPremeasure_CheckedChanged );
                    menu.add( menu_start_after_premeasure );

                    BgmMenuItem menu_offset_second = new BgmMenuItem( i );
                    menu_offset_second.setText( _( "Set Offset Seconds" ) );
                    menu_offset_second.setToolTipText( item.readOffsetSeconds + " " + _( "seconds" ) );
                    menu_offset_second.Click += new BEventHandler( handleBgmOffsetSeconds_Click );
                    menu.add( menu_offset_second );

                    menuTrackBgm.add( menu );
                }
                menuTrackBgm.addSeparator();
            }
            BMenuItem menu_add = new BMenuItem();
            menu_add.setText( _( "Add" ) );
            menu_add.Click += new BEventHandler( handleBgmAdd_Click );
            menuTrackBgm.add( menu_add );
        }


#if ENABLE_PROPERTY
        public void updatePropertyPanelState( PanelState state )
        {
#if DEBUG
            sout.println( "FormMain#updatePropertyPanelState; state=" + state );
#endif
            if ( state == PanelState.Docked ) {
                mPropertyPanelContainer.addComponent( AppManager.propertyPanel );
                menuVisualProperty.setSelected( true );
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Docked;
                splitContainerProperty.setPanel1Hidden( false );
                splitContainerProperty.setSplitterFixed( false );
                splitContainerProperty.setDividerSize( _SPL_SPLITTER_WIDTH );
#if JAVA
                serr.println( "fixme: FormMain#updatePropertyPanelState; Panel1MinSize not set" );
#else
                splitContainerProperty.Panel1MinSize = _PROPERTY_DOCK_MIN_WIDTH;
#endif
                int w = AppManager.editorConfig.PropertyWindowStatus.DockWidth;
                if( w < _PROPERTY_DOCK_MIN_WIDTH ){
                    w = _PROPERTY_DOCK_MIN_WIDTH;
                }
                splitContainerProperty.setDividerLocation( w );
#if DEBUG
                sout.println( "FormMain#updatePropertyPanelState; state=Docked; w=" + w );
#endif
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Minimized;
#if JAVA
                int before = AppManager.propertyWindow.formClosingEvent.size();
                int after = before - 1;
                while( before != after ){
                    before = AppManager.propertyWindow.formClosingEvent.size();
                    AppManager.propertyWindow.formClosingEvent.remove( new BFormClosingEventHandler( this, "propertyWindow_FormClosing" ) );
                    after = AppManager.propertyWindow.formClosingEvent.size();
                }
                AppManager.propertyWindow.close();
                AppManager.propertyWindow.formClosingEvent.add( new BFormClosingEventHandler( this, "propertyWindow_FormClosing" ) );
#else
                AppManager.propertyWindow.setVisible( false );
#endif
            } else if ( state == PanelState.Hidden ) {
                AppManager.propertyWindow.setVisible( false );
                menuVisualProperty.setSelected( false );
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.getDividerLocation();
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Hidden;
#if JAVA
                serr.println( "fixme: FormMain#updatePropertyPanelState; Panel1MinSize not set" );
#else
                splitContainerProperty.Panel1MinSize = 0;
#endif
                splitContainerProperty.setPanel1Hidden( true );
                splitContainerProperty.setDividerLocation( 0 );
                splitContainerProperty.setDividerSize( 0 );
                splitContainerProperty.setSplitterFixed( true );
            } else if ( state == PanelState.Window ) {
#if JAVA
                AppManager.propertyWindow.addComponent( AppManager.propertyPanel );
#else
                AppManager.propertyWindow.Controls.Add( AppManager.propertyPanel );
#endif
                Point parent = this.getLocation();
                XmlRectangle rc = AppManager.editorConfig.PropertyWindowStatus.Bounds;
                Point property = new Point( rc.x, rc.y );
                AppManager.propertyWindow.setBounds( new Rectangle( parent.x + property.x, parent.y + property.y, rc.width, rc.height ) );
                normalizeFormLocation( AppManager.propertyWindow );
                // setVisible -> NORMALとすると，javaの場合見栄えが悪くなる
#if !JAVA
                AppManager.propertyWindow.setVisible( true );
#endif
                if ( AppManager.propertyWindow.getExtendedState() != BForm.NORMAL ) {
                    AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                }
#if JAVA
                AppManager.propertyWindow.setVisible( true );
#endif
                menuVisualProperty.setSelected( true );
                if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                    AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.getDividerLocation();
                }
                AppManager.editorConfig.PropertyWindowStatus.State = PanelState.Window;
#if JAVA
                serr.println( "fixme: FormMain#updatePropertyPanelState; splitContainerProperty.Panel1MinSize not set" );
#else
                splitContainerProperty.Panel1MinSize = 0;
#endif
                splitContainerProperty.setPanel1Hidden( true );
                splitContainerProperty.setDividerLocation( 0 );
                splitContainerProperty.setDividerSize( 0 );
                splitContainerProperty.setSplitterFixed( true );
                AppManager.editorConfig.PropertyWindowStatus.WindowState = BFormWindowState.Normal;
#if DEBUG
                sout.println( "FormMain#updatePropertyPanelState; propertyWindow.getExtendedState()=" + AppManager.propertyWindow.getExtendedState() );
                sout.println( "    NORMAL=" + BForm.NORMAL );
                sout.println( "    ICONIFIED=" + BForm.ICONIFIED );
                sout.println( "    MAXIMIZED_BOTH=" + BForm.MAXIMIZED_BOTH );
#endif
            }
        }
#endif


        /// <summary>
        /// メインメニュー項目の中から，Nameプロパティがnameであるものを検索します．見つからなければnullを返す．
        /// </summary>
        /// <param name="name"></param>
        /// <param name="parent"></param>
        /// <returns></returns>
        public Object searchMenuItemFromName( String name, ByRef<Object> parent )
        {
            int count = menuStripMain.getMenuCount();
            for ( int i = 0; i < count; i++ ) {
                Object tsi = menuStripMain.getMenu( i );
                Object ret = searchMenuItemRecurse( name, tsi, parent );
                if ( ret != null ) {
                    if ( parent.value == null ) {
                        parent.value = tsi;
                    }
                    return ret;
                }
            }
            return null;
        }

        /// <summary>
        /// 指定されたメニューアイテムから，Nameプロパティがnameであるものを再帰的に検索します．見つからなければnullを返す
        /// </summary>
        /// <param name="name"></param>
        /// <param name="tree"></param>
        /// <returns></returns>
        public Object searchMenuItemRecurse( String name, Object tree, ByRef<Object> parent )
        {
#if JAVA
            if( tree == null ){
                return null;
            }
            // 子メニューを持つ場合
            if( tree instanceof JMenu ){
                JMenu jm = (JMenu)tree;
                int size = jm.getMenuComponentCount();
                for( int i = 0; i < size; i++ ){
                    Component comp = jm.getMenuComponent( i );
                    if( comp != null && comp instanceof JMenuItem ){
                        JMenuItem jmi = (JMenuItem)comp;
                        Object obj = searchMenuItemRecurse( name, jmi, parent );
                        if ( obj != null ){
                            parent.value = tree;
                            return obj;
                        }
                    }
                }
            }
            // 自分自身が該当しないか？
            if( tree instanceof JMenuItem ){
                JMenuItem jmi = (JMenuItem)tree;
                if( str.compare( name, jmi.getName() ) ){
                    parent.value = null;
                    return tree;
                }
            }
            // 該当しなかった
            return null;
#else
            String tree_name = "";
            System.Windows.Forms.ToolStripMenuItem menu = null;
            if ( tree is System.Windows.Forms.ToolStripItem ) {
                if ( tree is System.Windows.Forms.ToolStripMenuItem ) {
                    menu = (System.Windows.Forms.ToolStripMenuItem)tree;
                }
                tree_name = ((System.Windows.Forms.ToolStripItem)tree).Name;
            } else {
                return null;
            }

            if ( str.compare( tree_name, name ) ) {
                parent.value = null;
                return tree;
            } else {
                if ( menu == null ) {
                    return null;
                }
                int count = menu.DropDownItems.Count;
                for ( int i = 0; i < count; i++ ) {
                    System.Windows.Forms.ToolStripItem tsi = menu.DropDownItems[i];
                    String tsi_name = "";
                    if ( tsi is System.Windows.Forms.ToolStripItem ) {
                        tsi_name = ((System.Windows.Forms.ToolStripItem)tsi).Name;
                    } else {
                        continue;
                    }

                    if ( str.compare( tsi_name, name ) ) {
                        return tsi;
                    }
                    Object ret = searchMenuItemRecurse( name, tsi, parent );
                    if ( ret != null ) {
                        parent.value = tsi;
                        return ret;
                    }
                }
                return null;
            }
#endif
        }

        /// <summary>
        /// フォームをマウス位置に出す場合に推奨されるフォーム位置を計算します
        /// </summary>
        /// <param name="dlg"></param>
        /// <returns></returns>
        public Point getFormPreferedLocation( BDialog dlg )
        {
            Point mouse = PortUtil.getMousePosition();
            Rectangle rcScreen = PortUtil.getWorkingArea( this );
            int top = mouse.y - dlg.getHeight() / 2;
            if ( top + dlg.getHeight() > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.getHeight();
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = mouse.x - dlg.getWidth() / 2;
            if ( left + dlg.getWidth() > rcScreen.x + rcScreen.width ) {
                // ダイアログの右端が隠れる場合，位置をずらす
                left = rcScreen.x + rcScreen.width - dlg.getWidth();
            }
            if ( left < rcScreen.x ) {
                // ダイアログの左端が隠れる場合，位置をずらす
                left = rcScreen.x;
            }
            return new Point( left, top );
        }

        public void updateLayout()
        {
#if JAVA
            int keywidth = AppManager.keyWidth;
            pictureBox3.setPreferredSize( new Dimension( keywidth, 4 ) );
            pictureBox3.setSize( new Dimension( keywidth, pictureBox3.getHeight() ) );
            panel2.setPreferredSize( new Dimension( keywidth, 4 ) );
            panel2.setSize( new Dimension( keywidth, panel2.getHeight() ) );
            
            Dimension overview_pref_size = panelOverview.getPreferredSize();
            if( AppManager.editorConfig.OverviewEnabled ){
                panel3.setPreferredSize( new Dimension( (int)overview_pref_size.getWidth(), _OVERVIEW_HEIGHT ) );
                //panel3.setHeight( _OVERVIEW_HEIGHT );
            }else{
                panel3.setPreferredSize( new Dimension( (int)overview_pref_size.getWidth(), 0 ) );
                //panel3.setHeight( 0 );
            }
            jPanel1.doLayout();
            panel1.doLayout();
            panel21.doLayout();
            int overview_width = this.getWidth();
            panelOverview.updateCachedImage( overview_width );
            refreshScreenCore( null, null );
#else
            int width = panel1.Width;
            int height = panel1.Height;

            if ( AppManager.editorConfig.OverviewEnabled ) {
                panelOverview.Height = _OVERVIEW_HEIGHT;
            } else {
                panelOverview.Height = 0;
            }
            panelOverview.Width = width;
            int key_width = AppManager.keyWidth;

            /*btnMooz.setBounds( 3, 12, 23, 23 );
            btnZoom.setBounds( 26, 12, 23, 23 );*/

            picturePositionIndicator.Width = width;
            picturePositionIndicator.Height = _PICT_POSITION_INDICATOR_HEIGHT;

            hScroll.Top = 0;
            hScroll.Left = key_width;
            hScroll.Width = width - key_width - _SCROLL_WIDTH - trackBar.Width;
            hScroll.Height = _SCROLL_WIDTH;

            vScroll.Width = _SCROLL_WIDTH;
            vScroll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH * 4 - panelOverview.Height;

            pictPianoRoll.Width = width - _SCROLL_WIDTH;
            pictPianoRoll.Height = height - _PICT_POSITION_INDICATOR_HEIGHT - _SCROLL_WIDTH - panelOverview.Height;

            pictureBox3.Width = key_width - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Width = _SCROLL_WIDTH;
            pictureBox3.Height = _SCROLL_WIDTH;
            pictureBox2.Height = _SCROLL_WIDTH * 4;
            trackBar.Height = _SCROLL_WIDTH;

            panelOverview.Top = 0;
            panelOverview.Left = 0;

            picturePositionIndicator.Top = panelOverview.Height;
            picturePositionIndicator.Left = 0;

            pictPianoRoll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            pictPianoRoll.Left = 0;

            vScroll.Top = _PICT_POSITION_INDICATOR_HEIGHT + panelOverview.Height;
            vScroll.Left = width - _SCROLL_WIDTH;

            pictureBox3.Top = height - _SCROLL_WIDTH;
            pictureBox3.Left = 0;
            pictKeyLengthSplitter.Top = height - _SCROLL_WIDTH;
            pictKeyLengthSplitter.Left = pictureBox3.Width;

            hScroll.Top = height - _SCROLL_WIDTH;
            hScroll.Left = pictureBox3.Width + pictKeyLengthSplitter.Width;

            trackBar.Top = height - _SCROLL_WIDTH;
            trackBar.Left = width - _SCROLL_WIDTH - trackBar.Width;

            pictureBox2.Top = height - _SCROLL_WIDTH * 4;
            pictureBox2.Left = width - _SCROLL_WIDTH;

            waveView.Top = 0;
            waveView.Left = key_width;
            waveView.Width = width - key_width;
#endif
        }

        public void updateRendererMenu()
        {
            String wine_prefix = AppManager.editorConfig.WinePrefix;
            String wine_top = AppManager.editorConfig.WineTop;
            if ( !VSTiDllManager.isRendererAvailable( RendererKind.VOCALOID1, wine_prefix, wine_top ) ) {
                cMenuTrackTabRendererVOCALOID1.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVOCALOID1.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererVOCALOID1.setIcon( null );
                menuTrackRendererVOCALOID1.setIcon( null );
            }

            if ( !VSTiDllManager.isRendererAvailable( RendererKind.VOCALOID2, wine_prefix, wine_top ) ) {
                cMenuTrackTabRendererVOCALOID2.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVOCALOID2.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererVOCALOID2.setIcon( null );
                menuTrackRendererVOCALOID2.setIcon( null );
            }

            if ( !VSTiDllManager.isRendererAvailable( RendererKind.UTAU, wine_prefix, wine_top ) ) {
                cMenuTrackTabRendererUtau.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererUtau.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererUtau.setIcon( null );
                menuTrackRendererUtau.setIcon( null );
            }

            if ( !VSTiDllManager.isRendererAvailable( RendererKind.VCNT, wine_prefix, wine_top ) ) {
                cMenuTrackTabRendererStraight.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererVCNT.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererStraight.setIcon( null );
                menuTrackRendererVCNT.setIcon( null );
            }

            if ( !VSTiDllManager.isRendererAvailable( RendererKind.AQUES_TONE, wine_prefix, wine_top ) ) {
                cMenuTrackTabRendererAquesTone.setIcon( new ImageIcon( Resources.get_slash() ) );
                menuTrackRendererAquesTone.setIcon( new ImageIcon( Resources.get_slash() ) );
            } else {
                cMenuTrackTabRendererAquesTone.setIcon( null );
                menuTrackRendererAquesTone.setIcon( null );
            }

            // UTAU用のサブアイテムを更新
            int count = AppManager.editorConfig.getResamplerCount();
            // サブアイテムの個数を整える
#if JAVA
            menuTrackRendererUtau.removeAll();
            cMenuTrackTabRendererUtau.removeAll();
            for( int i = 0; i < count; i++ ){
                String path = AppManager.editorConfig.getResamplerAt( i );
                String name = PortUtil.getFileNameWithoutExtension( path );

                BMenuItem item0 = new BMenuItem();
                item0.clickEvent.add( new BEventHandler( this, "handleChangeRenderer" ) );
                item0.setText( name );
                item0.setToolTipText( path );
                menuTrackRendererUtau.add( item0 );

                BMenuItem item1 = new BMenuItem();
                item1.clickEvent.add( new BEventHandler( this, "handleChangeRenderer" ) );
                item1.setText( name );
                item1.setToolTipText( path );
                cMenuTrackTabRendererUtau.add( item1 );
            }
#else
            int delta = count - menuTrackRendererUtau.DropDownItems.Count;
            if ( delta > 0 ) {
                // 増やす
                for ( int i = 0; i < delta; i++ ) {
                    cMenuTrackTabRendererUtau.DropDownItems.Add( "", null, new BEventHandler( handleChangeRenderer ) );
                    menuTrackRendererUtau.DropDownItems.Add( "", null, new BEventHandler( handleChangeRenderer ) );
                }
            } else if ( delta < 0 ) {
                // 減らす
                for ( int i = 0; i < -delta; i++ ) {
                    cMenuTrackTabRendererUtau.DropDownItems.RemoveAt( 0 );
                    menuTrackRendererUtau.DropDownItems.RemoveAt( 0 );
                }
            }

            for ( int i = 0; i < count; i++ ) {
                String path = AppManager.editorConfig.getResamplerAt( i );
                String name = PortUtil.getFileNameWithoutExtension( path );
                menuTrackRendererUtau.DropDownItems[i].Text = name;
                cMenuTrackTabRendererUtau.DropDownItems[i].Text = name;

                menuTrackRendererUtau.DropDownItems[i].ToolTipText = path;
                cMenuTrackTabRendererUtau.DropDownItems[i].ToolTipText = path;
            }
#endif
        }

        public void drawUtauVibrato( Graphics2D g, UstVibrato vibrato, int note, int clock_start, int clock_width )
        {
            //SmoothingMode old = g.SmoothingMode;
            //g.SmoothingMode = SmoothingMode.AntiAlias;
            // 魚雷を描いてみる
            int y0 = AppManager.yCoordFromNote( note - 0.5f );
            int x0 = AppManager.xCoordFromClocks( clock_start );
            int px_width = AppManager.xCoordFromClocks( clock_start + clock_width ) - x0;
            int boxheight = (int)(vibrato.Depth * 2 / 100.0 * (int)(100.0 * AppManager.getScaleY()));
            int px_shift = (int)(vibrato.Shift / 100.0 * vibrato.Depth / 100.0 * (int)(100.0 * AppManager.getScaleY()));

            // vibrato in
            int cl_vibin_end = clock_start + (int)(clock_width * vibrato.In / 100.0);
            int x_vibin_end = AppManager.xCoordFromClocks( cl_vibin_end );
            Point ul = new Point( x_vibin_end, y0 - boxheight / 2 - px_shift );
            Point dl = new Point( x_vibin_end, y0 + boxheight / 2 - px_shift );
            g.setColor( Color.black );
            g.drawPolyline( new int[] { x0, ul.x, dl.x },
                            new int[] { y0, ul.y, dl.y },
                            3 );

            // vibrato out
            int cl_vibout_start = clock_start + clock_width - (int)(clock_width * vibrato.Out / 100.0);
            int x_vibout_start = AppManager.xCoordFromClocks( cl_vibout_start );
            Point ur = new Point( x_vibout_start, y0 - boxheight / 2 - px_shift );
            Point dr = new Point( x_vibout_start, y0 + boxheight / 2 - px_shift );
            g.drawPolyline( new int[] { x0 + px_width, ur.x, dr.x },
                           new int[] { y0, ur.y, dr.y },
                           3 );

            // box
            int boxwidth = x_vibout_start - x_vibin_end;
            if ( boxwidth > 0 ) {
                g.drawPolyline( new int[] { ul.x, dl.x, dr.x, ur.x },
                               new int[] { ul.y, dl.y, dr.y, ur.y },
                               4 );
            }

            // buf1に、vibrato in/outによる増幅率を代入
            float[] buf1 = new float[clock_width + 1];
            for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                buf1[clock - clock_start] = 1.0f;
            }
            // vibin
            if ( cl_vibin_end - clock_start > 0 ) {
                for ( int clock = clock_start; clock <= cl_vibin_end; clock++ ) {
                    int i = clock - clock_start;
                    buf1[i] *= i / (float)(cl_vibin_end - clock_start);
                }
            }
            if ( clock_start + clock_width - cl_vibout_start > 0 ) {
                for ( int clock = clock_start + clock_width; clock >= cl_vibout_start; clock-- ) {
                    int i = clock - clock_start;
                    float v = (clock_start + clock_width - clock) / (float)(clock_start + clock_width - cl_vibout_start);
                    buf1[i] = buf1[i] * v;
                }
            }

            // buf2に、shiftによるy座標のシフト量を代入
            float[] buf2 = new float[clock_width + 1];
            for ( int i = 0; i < clock_width; i++ ) {
                buf2[i] = px_shift * buf1[i];
            }
            try {
                double phase = 2.0 * Math.PI * vibrato.Phase / 100.0;
                double omega = 2.0 * Math.PI / vibrato.Period;   //角速度(rad/msec)
                double msec = AppManager.getVsqFile().getSecFromClock( clock_start - 1 ) * 1000.0;
                float px_track_height = (int)(AppManager.getScaleY() * 100.0f);
                phase -= (AppManager.getVsqFile().getSecFromClock( clock_start ) * 1000.0 - msec) * omega;
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    double t_msec = AppManager.getVsqFile().getSecFromClock( clock ) * 1000.0;
                    phase += (t_msec - msec) * omega;
                    msec = t_msec;
                    buf2[i] += (float)(vibrato.Depth * 0.01f * px_track_height * buf1[i] * Math.Sin( phase ));
                }
                int[] listx = new int[clock_width + 1];
                int[] listy = new int[clock_width + 1];
                for ( int clock = clock_start; clock <= clock_start + clock_width; clock++ ) {
                    int i = clock - clock_start;
                    listx[i] = AppManager.xCoordFromClocks( clock );
                    listy[i] = (int)(y0 + buf2[i]);
                }
                if ( listx.Length >= 2 ) {
                    g.setColor( Color.red );
                    g.drawPolyline( listx, listy, listx.Length );
                }
                //g.SmoothingMode = old;
            } catch ( Exception oex ) {
                Logger.write( typeof( FormMain ) + ".drawUtauVibato; ex=" + oex + "\n" );
#if DEBUG
                AppManager.debugWriteLine( "DrawUtauVibrato; oex=" + oex );
#endif
            }
        }

#if ENABLE_SCRIPT
        /// <summary>
        /// Palette Toolの表示を更新します
        /// </summary>
        public void updatePaletteTool()
        {
            int count = 0;
            int num_has_dialog = 0;
            for ( Iterator<System.Windows.Forms.ToolBarButton> itr = mPaletteTools.iterator(); itr.hasNext(); ) {
                System.Windows.Forms.ToolBarButton item = itr.next();
                toolBarTool.Buttons.Add( item );
            }
            String lang = Messaging.getLanguage();
            boolean first = true;
            for ( Iterator<String> itr = PaletteToolServer.loadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = itr.next();
                count++;
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
#if !JAVA
                System.Drawing.Bitmap icon = ipt.getIcon();
#endif
                String name = ipt.getName( lang );
                String desc = ipt.getDescription( lang );

                // toolStripPaletteTools
                System.Windows.Forms.ToolBarButton tsb = new System.Windows.Forms.ToolBarButton();
                tsb.Style = System.Windows.Forms.ToolBarButtonStyle.ToggleButton;
#if !JAVA
                if ( icon != null ) {
                    imageListTool.Images.Add( icon );
                    tsb.ImageIndex = imageListTool.Images.Count - 1;
                }
#endif
                tsb.Text = name;
                tsb.ToolTipText = desc;
                tsb.Tag = id;
#if JAVA
                tsb.clickEvent.add( new BEventHandler( this, "handleStripPaletteTool_Click" ) );
#endif
                if ( first ) {
                    var sep = new System.Windows.Forms.ToolBarButton();
                    sep.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
                    toolBarTool.Buttons.Add( sep );
                    first = false;
                }
                mPaletteTools.add( tsb );
                toolBarTool.Buttons.Add( tsb );

                // cMenuTrackSelector
                PaletteToolMenuItem tsmi = new PaletteToolMenuItem( id );
                tsmi.setText( name );
                tsmi.setToolTipText( desc );
                tsmi.Click += new BEventHandler( handleStripPaletteTool_Click );
                cMenuTrackSelectorPaletteTool.add( tsmi );

                // cMenuPiano
                PaletteToolMenuItem tsmi2 = new PaletteToolMenuItem( id );
                tsmi2.setText( name );
                tsmi2.setToolTipText( desc );
                tsmi2.Click += new BEventHandler( handleStripPaletteTool_Click );
                cMenuPianoPaletteTool.add( tsmi2 );

                // menuSettingPaletteTool
                if ( ipt.hasDialog() ) {
                    PaletteToolMenuItem tsmi3 = new PaletteToolMenuItem( id );
                    tsmi3.setText( name );
                    tsmi3.Click += new BEventHandler( handleSettingPaletteTool );
                    menuSettingPaletteTool.add( tsmi3 );
                    num_has_dialog++;
                }
            }
            if ( count == 0 ) {
                cMenuTrackSelectorPaletteTool.setVisible( false );
                cMenuPianoPaletteTool.setVisible( false );
            }
            if ( num_has_dialog == 0 ) {
                menuSettingPaletteTool.setVisible( false );
            }
        }
#endif

        public void updateCopyAndPasteButtonStatus()
        {
            // copy cut deleteの表示状態更新
            boolean selected_is_null = (AppManager.getSelectedEventCount() == 0) &&
                                       (AppManager.getSelectedTempoCount() == 0) &&
                                       (AppManager.getSelectedTimesigCount() == 0) &&
                                       (AppManager.getSelectedPointIDCount() == 0);

            int selected_point_id_count = AppManager.getSelectedPointIDCount();
            cMenuTrackSelectorCopy.setEnabled( selected_point_id_count > 0 );
            cMenuTrackSelectorCut.setEnabled( selected_point_id_count > 0 );
            cMenuTrackSelectorDeleteBezier.setEnabled( (AppManager.isCurveMode() && AppManager.getLastSelectedBezier() != null) );
            if ( selected_point_id_count > 0 ) {
                cMenuTrackSelectorDelete.setEnabled( true );
            } else {
                SelectedEventEntry last = AppManager.getLastSelectedEvent();
                if ( last == null ) {
                    cMenuTrackSelectorDelete.setEnabled( false );
                } else {
                    cMenuTrackSelectorDelete.setEnabled( last.original.ID.type == VsqIDType.Singer );
                }
            }

            cMenuPianoCopy.setEnabled( !selected_is_null );
            cMenuPianoCut.setEnabled( !selected_is_null );
            cMenuPianoDelete.setEnabled( !selected_is_null );

            menuEditCopy.setEnabled( !selected_is_null );
            menuEditCut.setEnabled( !selected_is_null );
            menuEditDelete.setEnabled( !selected_is_null );

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
            boolean copied_is_null = (ce.events.size() == 0) &&
                                  (ce.tempo.size() == 0) &&
                                  (ce.timesig.size() == 0) &&
                                  (copied_curve.size() == 0) &&
                                  (copied_bezier.size() == 0);
            boolean enabled = !copied_is_null;
            if ( copied_curve.size() == 1 ) {
                // 1種類のカーブがコピーされている場合→コピーされているカーブの種類と、現在選択されているカーブの種類とで、最大値と最小値が一致している場合のみ、ペースト可能
                CurveType ct = CurveType.Empty;
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType c = itr.next();
                    ct = c;
                }
                CurveType selected = trackSelector.getSelectedCurve();
                if ( ct.getMaximum() == selected.getMaximum() &&
                     ct.getMinimum() == selected.getMinimum() &&
                     !selected.isScalar() && !selected.isAttachNote() ) {
                    enabled = true;
                } else {
                    enabled = false;
                }
            } else if ( copied_curve.size() >= 2 ) {
                // 複数種類のカーブがコピーされている場合→そのままペーストすればOK
                enabled = true;
            }
            cMenuTrackSelectorPaste.setEnabled( enabled );
            cMenuPianoPaste.setEnabled( enabled );
            menuEditPaste.setEnabled( enabled );

            /*int copy_started_clock;
            boolean copied_is_null = (AppManager.GetCopiedEvent().Count == 0) &&
                                  (AppManager.GetCopiedTempo( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedTimesig( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedCurve( out copy_started_clock ).Count == 0) &&
                                  (AppManager.GetCopiedBezier( out copy_started_clock ).Count == 0);
            menuEditCut.isEnabled() = !selected_is_null;
            menuEditCopy.isEnabled() = !selected_is_null;
            menuEditDelete.isEnabled() = !selected_is_null;
            //stripBtnCopy.isEnabled() = !selected_is_null;
            //stripBtnCut.isEnabled() = !selected_is_null;

            if ( AppManager.GetCopiedEvent().Count != 0 ) {
                menuEditPaste.isEnabled() = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
                //stripBtnPaste.isEnabled() = (AppManager.CurrentClock >= AppManager.VsqFile.getPreMeasureClocks());
            } else {
                menuEditPaste.isEnabled() = !copied_is_null;
                //stripBtnPaste.isEnabled() = !copied_is_null;
            }*/
        }

        /// <summary>
        /// 現在の編集データを全て破棄する。DirtyCheckは行われない。
        /// </summary>
        public void clearExistingData()
        {
            AppManager.clearCommandBuffer();
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false, this );
            }
            waveView.unloadAll();
        }

        /// <summary>
        /// 保存されていない編集内容があるかどうかチェックし、必要なら確認ダイアログを出す。
        /// </summary>
        /// <returns>保存されていない保存内容などない場合、または、保存する必要がある場合で（保存しなくてよいと指定された場合または保存が行われた場合）にtrueを返す</returns>
        public boolean dirtyCheck()
        {
            if ( mEdited ) {
                String file = AppManager.getFileName();
                if ( str.compare( file, "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult dr = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                              _( "Affirmation" ),
                                                              org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_CANCEL_OPTION,
                                                              org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE );
                if ( dr == BDialogResult.YES ) {
                    if ( str.compare( AppManager.getFileName(), "" ) ) {
                        int dr2 = AppManager.showModalDialog( saveXmlVsqDialog, false, this );
                        if ( dr2 == BFileChooser.APPROVE_OPTION ) {
                            String sf = saveXmlVsqDialog.getSelectedFile();
                            AppManager.saveTo( sf );
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                        return true;
                    }
                } else if ( dr == BDialogResult.NO ) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }

#if JAVA
        /// <summary>
        /// waveView用のwaveファイルを読込むスレッドで使用する
        /// </summary>
        /// <param name="arg"></param>
        public class LoadWaveProc extends Thread {
            public String file = "";
            public int track;

            public LoadWaveProc( int track, String file ){
                this.file = file;
                this.track = track;
            }

            public void run(){
                waveView.load( track, file );
            }
        }
#endif

        public void loadWave( Object arg )
        {
            Object[] argArr = (Object[])arg;
            String file = (String)argArr[0];
            int track = (Integer)argArr[1];
            waveView.load( track, file );
        }

        /// <summary>
        /// AppManager.editorConfig.ViewWaveformの値をもとに、splitterContainer2の表示状態を更新します
        /// </summary>
        public void updateSplitContainer2Size( boolean save_to_config )
        {
            if ( AppManager.editorConfig.ViewWaveform ) {
                splitContainer2.setPanel2MinSize( _SPL2_PANEL2_MIN_HEIGHT );
                splitContainer2.setSplitterFixed( false );
                splitContainer2.setPanel2Hidden( false );
                splitContainer2.setDividerSize( _SPL_SPLITTER_WIDTH );
                int lastloc = AppManager.editorConfig.SplitContainer2LastDividerLocation;
                if ( lastloc <= 0 || lastloc > splitContainer2.getHeight() ) {
                    int draft = splitContainer2.getHeight() -  100;
                    if( draft <= 0 ){
                        draft = splitContainer2.getHeight() / 2;
                    }
                    splitContainer2.setDividerLocation( draft );
                } else {
                    splitContainer2.setDividerLocation( lastloc );
                }
            } else {
                if( save_to_config ){
                    AppManager.editorConfig.SplitContainer2LastDividerLocation = splitContainer2.getDividerLocation();
                }
                splitContainer2.setPanel2MinSize( 0 );
                splitContainer2.setPanel2Hidden( true );
                splitContainer2.setDividerSize( 0 );
                splitContainer2.setDividerLocation( splitContainer2.getHeight() );
                splitContainer2.setSplitterFixed( true );
            }
        }

        /// <summary>
        /// trackSelectorに表示するコントロールのカーブの種類を、AppManager.EditorConfigの設定に応じて更新します
        /// </summary>
        public void updateTrackSelectorVisibleCurve()
        {
#if DEBUG
            sout.println( "FormMain#updateTrackSelectorVisibleCurve; before; AppManager.getViewingCurveCount()" + AppManager.getViewingCurveCount() );
#endif
            if ( AppManager.editorConfig.CurveVisibleVelocity ) {
                AppManager.addViewingCurve( CurveType.VEL );
            }
            if ( AppManager.editorConfig.CurveVisibleAccent ) {
                AppManager.addViewingCurve( CurveType.Accent );
            }
            if ( AppManager.editorConfig.CurveVisibleDecay ) {
                AppManager.addViewingCurve( CurveType.Decay );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoRate ) {
                AppManager.addViewingCurve( CurveType.VibratoRate );
            }
            if ( AppManager.editorConfig.CurveVisibleVibratoDepth ) {
                AppManager.addViewingCurve( CurveType.VibratoDepth );
            }
            if ( AppManager.editorConfig.CurveVisibleDynamics ) {
                AppManager.addViewingCurve( CurveType.DYN );
            }
            if ( AppManager.editorConfig.CurveVisibleBreathiness ) {
                AppManager.addViewingCurve( CurveType.BRE );
            }
            if ( AppManager.editorConfig.CurveVisibleBrightness ) {
                AppManager.addViewingCurve( CurveType.BRI );
            }
            if ( AppManager.editorConfig.CurveVisibleClearness ) {
                AppManager.addViewingCurve( CurveType.CLE );
            }
            if ( AppManager.editorConfig.CurveVisibleOpening ) {
                AppManager.addViewingCurve( CurveType.OPE );
            }
            if ( AppManager.editorConfig.CurveVisibleGendorfactor ) {
                AppManager.addViewingCurve( CurveType.GEN );
            }
            if ( AppManager.editorConfig.CurveVisiblePortamento ) {
                AppManager.addViewingCurve( CurveType.POR );
            }
            if ( AppManager.editorConfig.CurveVisiblePit ) {
                AppManager.addViewingCurve( CurveType.PIT );
            }
            if ( AppManager.editorConfig.CurveVisiblePbs ) {
                AppManager.addViewingCurve( CurveType.PBS );
            }
            if ( AppManager.editorConfig.CurveVisibleHarmonics ) {
                AppManager.addViewingCurve( CurveType.harmonics );
            }
            if ( AppManager.editorConfig.CurveVisibleFx2Depth ) {
                AppManager.addViewingCurve( CurveType.fx2depth );
            }
            if ( AppManager.editorConfig.CurveVisibleReso1 ) {
                AppManager.addViewingCurve( CurveType.reso1freq );
                AppManager.addViewingCurve( CurveType.reso1bw );
                AppManager.addViewingCurve( CurveType.reso1amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso2 ) {
                AppManager.addViewingCurve( CurveType.reso2freq );
                AppManager.addViewingCurve( CurveType.reso2bw );
                AppManager.addViewingCurve( CurveType.reso2amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso3 ) {
                AppManager.addViewingCurve( CurveType.reso3freq );
                AppManager.addViewingCurve( CurveType.reso3bw );
                AppManager.addViewingCurve( CurveType.reso3amp );
            }
            if ( AppManager.editorConfig.CurveVisibleReso4 ) {
                AppManager.addViewingCurve( CurveType.reso4freq );
                AppManager.addViewingCurve( CurveType.reso4bw );
                AppManager.addViewingCurve( CurveType.reso4amp );
            }
            if ( AppManager.editorConfig.CurveVisibleEnvelope ) {
                AppManager.addViewingCurve( CurveType.Env );
            }
        }

        /// <summary>
        /// ウィンドウの表示内容に応じて、ウィンドウサイズの最小値を計算します
        /// </summary>
        /// <returns></returns>
        public Dimension getWindowMinimumSize()
        {
            Dimension current_minsize = new Dimension( getMinimumSize().width, getMinimumSize().height );
#if JAVA
            Dimension client = getContentPane().getSize();
            Dimension current = getSize();
            return new Dimension( current_minsize.width,
                                  splitContainer1.getPanel2MinSize() +
                                  _SCROLL_WIDTH + _PICT_POSITION_INDICATOR_HEIGHT + pictPianoRoll.getMinimumSize().height +
                                  menuStripMain.getHeight() +
                                  (current.height - client.height) +
                                  20 );
#else
            Dimension client = new Dimension( this.ClientSize.Width, this.ClientSize.Height );
            Dimension current = new Dimension( this.Size.Width, this.Size.Height );
            return new Dimension( current_minsize.width,
                                  splitContainer1.getPanel2MinSize() +
                                  _SCROLL_WIDTH + _PICT_POSITION_INDICATOR_HEIGHT + pictPianoRoll.getMinimumSize().height +
                                  rebar.Height +
                                  menuStripMain.getHeight() + statusStrip.Height +
                                  (current.height - client.height) +
                                  20 );
#endif
        }

        /// <summary>
        /// 現在のAppManager.mInputTextBoxの状態を元に、歌詞の変更を反映させるコマンドを実行します
        /// </summary>
        public void executeLyricChangeCommand()
        {
#if JAVA
            if ( !AppManager.mInputTextBox.isVisible() ) {
#else
            if ( !AppManager.mInputTextBox.Enabled ) {
#endif
                return;
            }
#if !JAVA
            if ( AppManager.mInputTextBox.IsDisposed ) {
                return;
            }
#endif
            SelectedEventEntry last_selected_event = AppManager.getLastSelectedEvent();
            boolean phonetic_symbol_edit_mode = AppManager.mInputTextBox.isPhoneticSymbolEditMode();

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 後続に、連続している音符が何個あるか検査
            int maxcount = SymbolTable.getMaxDivisions(); // 音節の分割によって，高々maxcount個までにしか分割されない
            boolean check_started = false;
            int endclock = 0;  // 直前の音符の終了クロック
            int count = 0;     // 後続音符の連続個数
            int start_index = -1;
            int indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                indx = itr.next();
                VsqEvent itemi = vsq_track.getEvent( indx );
                if ( itemi.InternalID == last_selected_event.original.InternalID ) {
                    check_started = true;
                    endclock = itemi.Clock + itemi.ID.getLength();
                    count = 1;
                    start_index = indx;
                    continue;
                }
                if ( check_started ) {
                    if ( count + 1 > maxcount ) {
                        break;
                    }
                    if ( itemi.Clock <= endclock ) {
                        count++;
                        endclock = itemi.Clock + itemi.ID.getLength();
                    } else {
                        break;
                    }
                }
            }

            // 後続の音符をリストアップ
            VsqEvent[] items = new VsqEvent[count];
            String[] original_symbol = new String[count];
            String[] original_phrase = new String[count];
            boolean[] symbol_protected = new boolean[count];
            indx = -1;
            for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                int index = itr.next();
                if ( index < start_index ) {
                    continue;
                }
                indx++;
                if ( count <= indx ) {
                    break;
                }
                VsqEvent ve = vsq_track.getEvent( index );
                items[indx] = (VsqEvent)ve.clone();
                original_symbol[indx] = ve.ID.LyricHandle.L0.getPhoneticSymbol();
                original_phrase[indx] = ve.ID.LyricHandle.L0.Phrase;
                symbol_protected[indx] = ve.ID.LyricHandle.L0.PhoneticSymbolProtected;
            }

#if DEBUG
            AppManager.debugWriteLine( "    original_phase,symbol=" + original_phrase + "," + original_symbol[0] );
            AppManager.debugWriteLine( "    phonetic_symbol_edit_mode=" + phonetic_symbol_edit_mode );
            AppManager.debugWriteLine( "    AppManager.mInputTextBox.setText(=" + AppManager.mInputTextBox.getText() );
#endif
            String[] phrase = new String[count];
            String[] phonetic_symbol = new String[count];
            for ( int i = 0; i < count; i++ ) {
                phrase[i] = original_phrase[i];
                phonetic_symbol[i] = original_symbol[i];
            }
            String txt = AppManager.mInputTextBox.getText();
            int txtlen = PortUtil.getStringLength( txt );
            if ( txtlen > 0 ) {
                // 1文字目は，UTAUの連続音入力のハイフンの可能性があるので，無駄に置換されるのを回避
                phrase[0] = str.sub( txt, 0, 1 ) + ((txtlen > 1) ? str.sub( txt, 1 ).Replace( "-", "" ) : "");
            } else {
                phrase[0] = "";
            }
            if ( !phonetic_symbol_edit_mode ) {
                // 歌詞を編集するモードで、
                if ( AppManager.editorConfig.SelfDeRomanization ) {
                    // かつローマ字の入力を自動でひらがなに展開する設定だった場合。
                    // ローマ字をひらがなに展開
                    phrase[0] = KanaDeRomanization.Attach( phrase[0] );
                }
            }

            // 発音記号または歌詞が変更された場合の処理
            if ( (phonetic_symbol_edit_mode && !str.compare( AppManager.mInputTextBox.getText(), original_symbol[0] )) ||
                 (!phonetic_symbol_edit_mode && !str.compare( phrase[0], original_phrase[0] )) ) {
                if ( phonetic_symbol_edit_mode ) {
                    // 発音記号を編集するモード
                    phrase[0] = AppManager.mInputTextBox.getBufferText();
                    phonetic_symbol[0] = AppManager.mInputTextBox.getText();

                    // 入力された発音記号のうち、有効なものだけをピックアップ
                    String[] spl = PortUtil.splitString( phonetic_symbol[0], new char[] { ' ' }, true );
                    Vector<String> list = new Vector<String>();
                    for ( int i = 0; i < spl.Length; i++ ) {
                        String s = spl[i];
                        if ( VsqPhoneticSymbol.isValidSymbol( s ) ) {
                            list.add( s );
                        }
                    }

                    // ピックアップした発音記号をスペース区切りで結合
                    phonetic_symbol[0] = "";
                    boolean first = true;
                    for ( Iterator<String> itr = list.iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        if ( first ) {
                            phonetic_symbol[0] += s;
                            first = false;
                        } else {
                            phonetic_symbol[0] += " " + s;
                        }
                    }

                    // 発音記号を編集すると、自動で「発音記号をプロテクトする」モードになるよ
                    symbol_protected[0] = true;
                } else {
                    // 歌詞を編集するモード
                    if ( !symbol_protected[0] ) {
                        // 発音記号をプロテクトしない場合、歌詞から発音記号を引当てる
                        SymbolTableEntry entry = SymbolTable.attatch( phrase[0] );
                        if ( entry == null ) {
                            phonetic_symbol[0] = "a";
                        } else {
                            phonetic_symbol[0] = entry.getSymbol();
                            // 分節の分割記号'-'が入っている場合
#if DEBUG
                            sout.println( "FormMain#executeLyricChangeCommand; word=" + entry.Word + "; symbol=" + entry.getSymbol() + "; rawSymbol=" + entry.getRawSymbol() );
#endif
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                String[] spl_phrase = PortUtil.splitString( entry.Word, '\t' );
                                if ( spl_phrase.Length <= count ) {
                                    // 分節の分割数が，後続の音符数と同じか少ない場合
                                    String[] spl_symbol = PortUtil.splitString( entry.getRawSymbol(), '\t' );
                                    for ( int i = 0; i < spl_phrase.Length; i++ ) {
                                        phrase[i] = spl_phrase[i];
                                        phonetic_symbol[i] = spl_symbol[i];
                                    }
                                } else {
                                    // 後続の音符の個数が足りない
                                    phrase[0] = entry.Word.Replace( "\t", "" );
                                }
                            }
                        }
                    } else {
                        // 発音記号をプロテクトする場合、発音記号は最初のやつを使う
                        phonetic_symbol[0] = original_symbol[0];
                    }
                }
#if DEBUG
                AppManager.debugWriteLine( "    phrase,phonetic_symbol=" + phrase + "," + phonetic_symbol );
#endif

                for ( int j = 0; j < count; j++ ) {
                    if ( phonetic_symbol_edit_mode ) {
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                    } else {
                        items[j].ID.LyricHandle.L0.Phrase = phrase[j];
                        items[j].ID.LyricHandle.L0.setPhoneticSymbol( phonetic_symbol[j] );
                        AppManager.applyUtauParameter( vsq_track, items[j] );
                    }
                    if ( !str.compare( original_symbol[j], phonetic_symbol[j] ) ) {
#if JAVA
                        Vector<String> spl = items[j].ID.LyricHandle.L0.getPhoneticSymbolList();
#else
                        List<String> spl = items[j].ID.LyricHandle.L0.getPhoneticSymbolList();
#endif
                        Vector<Integer> adjustment = new Vector<Integer>();
                        for ( int i = 0; i < vec.size( spl ); i++ ) {
                            String s = vec.get( spl, i );
                            adjustment.add( VsqPhoneticSymbol.isConsonant( s ) ? 64 : 0 );
                        }
                        items[j].ID.LyricHandle.L0.setConsonantAdjustmentList( adjustment );
                    }
                }

                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventReplaceRange( selected, items ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
            }
        }

        /// <summary>
        /// 識別済みのゲームコントローラを取り外します
        /// </summary>
        public void removeGameControler()
        {
#if !JAVA
            if ( mTimer != null ) {
                mTimer.stop();
                mTimer.Dispose();
                mTimer = null;
            }
            mGameMode = GameControlMode.DISABLED;
            updateGameControlerStatus( null, null );
#endif
        }

        /// <summary>
        /// PCに接続されているゲームコントローラを識別・接続します
        /// </summary>
        public void loadGameControler()
        {
#if !JAVA
            try {
                boolean init_success = false;
                int num_joydev = winmmhelp.JoyInit();
                if ( num_joydev <= 0 ) {
                    init_success = false;
                } else {
                    init_success = true;
                }
                if ( init_success ) {
                    mGameMode = GameControlMode.NORMAL;
                    stripLblGameCtrlMode.setIcon( null );
                    stripLblGameCtrlMode.setText( mGameMode.ToString() );
                    mTimer = new BTimer();
                    mTimer.setDelay( 10 );
                    mTimer.Tick += new BEventHandler( mTimer_Tick );
                    mTimer.start();
                } else {
                    mGameMode = GameControlMode.DISABLED;
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".loadGameControler; ex=" + ex + "\n" );
                mGameMode = GameControlMode.DISABLED;
#if DEBUG
                AppManager.debugWriteLine( "FormMain+ReloadGameControler" );
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
            }
            updateGameControlerStatus( null, null );
#endif
        }

#if ENABLE_MIDI
        /// <summary>
        /// MIDI入力句デバイスを再読込みします
        /// </summary>
        public void reloadMidiIn()
        {
            if ( mMidiIn != null ) {
                mMidiIn.MidiReceived -= new MidiReceivedEventHandler( mMidiIn_MidiReceived );
                mMidiIn.close();
                mMidiIn = null;
            }
            int portNumber = AppManager.editorConfig.MidiInPort.PortNumber;
            int portNumberMtc = AppManager.editorConfig.MidiInPortMtc.PortNumber;
#if DEBUG
            sout.println( "FormMain#reloadMidiIn; portNumber=" + portNumber + "; portNumberMtc=" + portNumberMtc );
#endif
            try {
                mMidiIn = new MidiInDevice( portNumber );
                mMidiIn.MidiReceived += new MidiReceivedEventHandler( mMidiIn_MidiReceived );
#if ENABLE_MTC
                if ( portNumber == portNumberMtc ) {
                    m_midi_in.setReceiveSystemCommonMessage( true );
                    m_midi_in.setReceiveSystemRealtimeMessage( true );
                    m_midi_in.MidiReceived += handleMtcMidiReceived;
                    m_midi_in.Start();
                } else {
                    m_midi_in.setReceiveSystemCommonMessage( false );
                    m_midi_in.setReceiveSystemRealtimeMessage( false );
                }
#else
                mMidiIn.setReceiveSystemCommonMessage( false );
                mMidiIn.setReceiveSystemRealtimeMessage( false );
#endif
            } catch ( Exception ex ) {
#if JAVA
                ex.printStackTrace();
#endif
                Logger.write( typeof( FormMain ) + ".reloadMidiIn; ex=" + ex + "\n" );
                serr.println( "FormMain#reloadMidiIn; ex=" + ex );
            }

#if ENABLE_MTC
            if ( m_midi_in_mtc != null ) {
                m_midi_in_mtc.MidiReceived -= handleMtcMidiReceived;
                m_midi_in_mtc.Dispose();
                m_midi_in_mtc = null;
            }
            if ( portNumber != portNumberMtc ) {
                try {
                    m_midi_in_mtc = new MidiInDevice( AppManager.editorConfig.MidiInPortMtc.PortNumber );
                    m_midi_in_mtc.MidiReceived += handleMtcMidiReceived;
                    m_midi_in_mtc.setReceiveSystemCommonMessage( true );
                    m_midi_in_mtc.setReceiveSystemRealtimeMessage( true );
                    m_midi_in_mtc.Start();
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".reloadMidiIn; ex=" + ex + "\n" );
                    serr.println( "FormMain#reloadMidiIn; ex=" + ex );
                }
            }
#endif
            updateMidiInStatus();
        }
#endif

#if ENABLE_MIDI
        public void updateMidiInStatus()
        {
            int midiport = AppManager.editorConfig.MidiInPort.PortNumber;
            Vector<MidiDevice.Info> devices = new Vector<MidiDevice.Info>();
            foreach ( MidiDevice.Info info in MidiSystem.getMidiDeviceInfo() ){
                MidiDevice device = null;
                try{
                    device = MidiSystem.getMidiDevice( info );
                }catch( Exception ex ){
                    device = null;
                }
                if( device == null ) continue;
                int max = device.getMaxTransmitters();
                if( max > 0 || max == -1 ){
                    devices.add( info );
                }
            }
            if ( midiport < 0 || vec.size( devices ) <= 0 ) {
#if JAVA
                stripBtnStepSequencer.setEnabled( false );
#else
                stripLblMidiIn.setText( _( "Disabled" ) );
                stripLblMidiIn.setIcon( new ImageIcon( Resources.get_slash() ) );
#endif
            } else {
                if ( midiport >= vec.size( devices ) ) {
                    midiport = 0;
                    AppManager.editorConfig.MidiInPort.PortNumber = midiport;
                }
#if JAVA
                stripBtnStepSequencer.setEnabled( true );
#else
                stripLblMidiIn.setText( vec.get( devices, midiport ).getName() );
                stripLblMidiIn.setIcon( new ImageIcon( Resources.get_piano() ) );
#endif
            }
        }
#endif

#if ENABLE_SCRIPT
        /// <summary>
        /// スクリプトフォルダ中のスクリプトへのショートカットを作成する
        /// </summary>
        public void updateScriptShortcut()
        {
            // 既存のアイテムを削除
            menuScript.removeAll();
            // スクリプトをリロード
            ScriptServer.reload();

            // スクリプトごとのメニューを追加
            int count = 0;
            for ( Iterator<String> itr = ScriptServer.getScriptIdIterator(); itr.hasNext(); ) {
                String id = itr.next();
                if ( str.compare( PortUtil.getFileNameWithoutExtension( id ).ToLower(), "runonce" ) ) {
                    continue;
                }
                String display = ScriptServer.getDisplayName( id );
                // スクリプトのメニューに共通のヘッダー(menuScript)を付ける．
                // こうしておくと，menuSettingShortcut_Clickで，スクリプトのメニューが
                // menuScriptの子だと自動で認識される
                String name = "menuScript" + id.Replace( '.', '_' );
                PaletteToolMenuItem item = new PaletteToolMenuItem( id );
                item.setText( display );
                item.setName( name );
                item.Click += new BEventHandler( handleScriptMenuItem_Click );
                menuScript.add( item );
                count++;
            }

            // 「スクリプトのリストを更新」を追加
            if ( count > 0 ) {
                menuScript.addSeparator();
            }
            menuScript.add( menuScriptUpdate );
            Util.applyToolStripFontRecurse( menuScript, AppManager.editorConfig.getBaseFont() );
            applyShortcut();
        }
#endif
        /// <summary>
        /// 指定したノートナンバーが可視状態となるよう、縦スクロールバーを移動させます。
        /// </summary>
        /// <param name="note"></param>
        public void ensureVisibleY( int note )
        {
            if ( note <= 0 ) {
                vScroll.setValue( vScroll.getMaximum() - vScroll.getVisibleAmount() );
                return;
            } else if ( note >= 127 ) {
                vScroll.setValue( vScroll.getMinimum() );
                return;
            }
            int height = pictPianoRoll.getHeight();
            int noteTop = AppManager.noteFromYCoord( 0 ); //画面上端でのノートナンバー
            int noteBottom = AppManager.noteFromYCoord( height ); // 画面下端でのノートナンバー

            int maximum = vScroll.getMaximum();
            int track_height = (int)(100 * AppManager.getScaleY());
            // ノートナンバーnoteの現在のy座標がいくらか？
            int note_y = AppManager.yCoordFromNote( note );
            if ( note < noteBottom ) {
                // ノートナンバーnoteBottomの現在のy座標が新しいnoteのy座標と同一になるよう，startToDrawYを変える
                // startToDrawYを次の値にする必要がある
                int new_start_to_draw_y = AppManager.getStartToDrawY() + (note_y - height);
                int value = calculateVScrollValueFromStartToDrawY( new_start_to_draw_y );
                vScroll.setValue( value );
            } else if ( noteTop < note ) {
                // ノートナンバーnoteTopの現在のy座標が，ノートナンバーnoteの新しいy座標と同一になるよう，startToDrawYを変える
                int new_start_to_draw_y = AppManager.getStartToDrawY() + (note_y - 0);
                int value = calculateVScrollValueFromStartToDrawY( new_start_to_draw_y );
                vScroll.setValue( value );
            }
        }

        /// <summary>
        /// 指定したゲートタイムがピアノロール上で可視状態となるよう、横スクロールバーを移動させます。
        /// </summary>
        /// <param name="clock"></param>
        public void ensureVisible( int clock )
        {
            // カーソルが画面内にあるかどうか検査
            int clock_left = AppManager.clockFromXCoord( AppManager.keyWidth );
            int clock_right = AppManager.clockFromXCoord( pictPianoRoll.getWidth() );
            int uwidth = clock_right - clock_left;
            if ( clock < clock_left || clock_right < clock ) {
                int cl_new_center = (clock / uwidth) * uwidth + uwidth / 2;
                float f_draft = cl_new_center - (pictPianoRoll.getWidth() / 2 + 34 - 70) * AppManager.getScaleXInv();
                if ( f_draft < 0f ) {
                    f_draft = 0;
                }
                int draft = (int)(f_draft);
                if ( draft < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                } else if ( hScroll.getMaximum() < draft ) {
                    draft = hScroll.getMaximum();
                }
                if ( hScroll.getValue() != draft ) {
                    AppManager.mDrawStartIndex[AppManager.getSelected() - 1] = 0;
                    hScroll.setValue( draft );
                }
            }
        }

        /// <summary>
        /// プレイカーソルが見えるようスクロールする
        /// </summary>
        public void ensureCursorVisible()
        {
            ensureVisible( AppManager.getCurrentClock() );
        }

        /// <summary>
        /// 特殊なショートカットキーを処理します。
        /// </summary>
        /// <param name="e"></param>
        /// <param name="onPreviewKeyDown">PreviewKeyDownイベントから送信されてきた場合、true（送る側が設定する）</param>
        public void processSpecialShortcutKey( BKeyEventArgs e, boolean onPreviewKeyDown )
        {
#if DEBUG
            sout.println( "FormMain#processSpecialShortcutKey" );
#endif
            // 歌詞入力用のテキストボックスが表示されていたら，何もしない
#if JAVA
            if ( AppManager.mInputTextBox.isVisible() ) {
#else
            if ( AppManager.mInputTextBox.Enabled ) {
#endif
                AppManager.mInputTextBox.requestFocus();
                return;
            }

            boolean flipPlaying = false; // 再生/停止状態の切り替えが要求されたらtrue

            // 最初に、特殊な取り扱いが必要なショートカット、について、
            // 該当するショートカットがあればそいつらを発動する。
            int modifier = PortUtil.getCurrentModifierKey();
            KeyStroke stroke = KeyStroke.getKeyStroke( e.KeyValue, modifier );
            int keycode = e.KeyValue;
#if DEBUG
            sout.println( "FormMain#processSpecialShortcutKey; stroke=" + stroke );
#endif

            if ( onPreviewKeyDown && keycode != 0 ) {
                foreach ( SpecialShortcutHolder holder in mSpecialShortcutHolders ) {
                    if ( stroke.Equals( holder.shortcut ) ) {
                        try {
#if DEBUG
                            sout.println( "FormMain#processSpecialShortcutKey; perform click: name=" + holder.menu.getName() );
#endif
#if JAVA
                            holder.menu.clickEvent.raise( holder.menu, new BEventArgs() );
#else
                            holder.menu.PerformClick();
#endif
                        } catch ( Exception ex ) {
                            Logger.write( typeof( FormMain ) + ".processSpecialShortcutKey; ex=" + ex + "\n" );
                            serr.println( "FormMain#processSpecialShortcutKey; ex=" + ex );
                        }
#if JAVA
                        if ( e.KeyValue == KeyEvent.VK_TAB ) {
#else
                        if ( e.KeyCode == System.Windows.Forms.Keys.Tab ) {
#endif
                            pictPianoRoll.requestFocus();
                        }
                        return;
                    }
                }
            }

            if ( modifier != KeyEvent.VK_UNDEFINED ) {
#if DEBUG
                sout.println( "FormMain#processSpecialShortcutKey; bailout with (modifier != VK_UNDEFINED)" );
#endif
                return;
            }

            EditMode edit_mode = AppManager.getEditMode();

#if JAVA
            if ( e.KeyValue == KeyEvent.VK_ENTER ) {
#else
            if ( e.KeyCode == System.Windows.Forms.Keys.Return ) {
#endif
                // MIDIステップ入力のときの処理
                if ( isStepSequencerEnabled() ) {
                    if ( AppManager.mAddingEvent != null ) {
                        fixAddingEvent();
                        AppManager.mAddingEvent = null;
                        refreshScreen( true );
                    }
                }
#if JAVA
            } else if ( e.KeyValue == KeyEvent.VK_SPACE ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.Space ) {
#endif
                if ( !AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier ) {
                    flipPlaying = true;
                }
#if JAVA
            } else if ( e.KeyValue == KeyEvent.VK_PERIOD ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.OemPeriod ) {
#endif
                if ( !onPreviewKeyDown ) {

                    if ( AppManager.isPlaying() ) {
                        AppManager.setPlaying( false, this );
                    } else {
                        VsqFileEx vsq = AppManager.getVsqFile();
                        if ( !vsq.config.StartMarkerEnabled ) {
                            AppManager.setCurrentClock( 0 );
                        } else {
                            AppManager.setCurrentClock( vsq.config.StartMarker );
                        }
                        refreshScreen();
                    }
                }
#if JAVA
            } else if( e.KeyValue == KeyEvent.VK_ADD || e.KeyValue == KeyEvent.VK_PLUS || e.KeyValue == KeyEvent.VK_RIGHT ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.Add || e.KeyCode == System.Windows.Forms.Keys.Oemplus || e.KeyCode == System.Windows.Forms.Keys.Right ) {
#endif
                if ( onPreviewKeyDown ) {
                    forward();
                }
#if JAVA
            } else if ( e.KeyValue == KeyEvent.VK_MINUS || e.KeyValue == KeyEvent.VK_LEFT ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.Subtract || e.KeyCode == System.Windows.Forms.Keys.OemMinus || e.KeyCode == System.Windows.Forms.Keys.Left ) {
#endif
                if ( onPreviewKeyDown ) {
                    rewind();
                }
#if JAVA
            } else if ( e.KeyValue == KeyEvent.VK_ESCAPE ) {
#else
            } else if ( e.KeyCode == System.Windows.Forms.Keys.Escape ) {
#endif
                // ステップ入力中の場合，入力中の音符をクリアする
                VsqEvent item = AppManager.mAddingEvent;
                if ( isStepSequencerEnabled() && item != null ) {
                    // 入力中だった音符の長さを取得し，
                    int length = item.ID.getLength();
                    AppManager.mAddingEvent = null;
                    int clock = AppManager.getCurrentClock();
                    int clock_draft = clock - length;
                    if ( clock_draft < 0 ) {
                        clock_draft = 0;
                    }
                    // その分だけソングポジションを戻す．
                    AppManager.setCurrentClock( clock_draft );
                    refreshScreen( true );
                }
            } else {
                if ( !AppManager.isPlaying() ) {
                    // 最初に戻る、の機能を発動
                    BKeys[] specialGoToFirst = AppManager.editorConfig.SpecialShortcutGoToFirst;
                    if ( specialGoToFirst != null && specialGoToFirst.Length > 0 ) {
                        KeyStroke ks = BKeysUtility.getKeyStrokeFromBKeys( specialGoToFirst );
#if JAVA
                        if( e.KeyCode == ks.getKeyCode() )
#else
                        if ( e.KeyCode == ks.keys )
#endif
                        {
                            AppManager.setCurrentClock( 0 );
                            ensureCursorVisible();
                            refreshScreen();
                        }
                    }
                }
            }
            if ( !onPreviewKeyDown && flipPlaying ) {
                if ( AppManager.isPlaying() ) {
                    double elapsed = PlaySound.getPosition();
                    double threshold = AppManager.mForbidFlipPlayingThresholdSeconds;
                    if ( threshold < 0 ) {
                        threshold = 0.0;
                    }
                    if ( elapsed > threshold ) {
                        timer.stop();
                        AppManager.setPlaying( false, this );
                    }
                } else {
                    AppManager.setPlaying( true, this );
                }
            }
#if JAVA
            if ( e.KeyValue == KeyEvent.VK_TAB ) {
#else
            if ( e.KeyCode == System.Windows.Forms.Keys.Tab ) {
#endif
                pictPianoRoll.requestFocus();
            }
        }

        public void updateScrollRangeHorizontal()
        {
            // コンポーネントの高さが0の場合，スクロールの設定が出来ないので．
            int pwidth = pictPianoRoll.getWidth();
            int hwidth = hScroll.getWidth();
            if ( pwidth <= 0 || hwidth <= 0 ) {
                return;
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) return;
            int l = vsq.TotalClocks;
            float scalex = AppManager.getScaleX();
            int key_width = AppManager.keyWidth;
            int pict_piano_roll_width = pwidth - key_width;
            int large_change = (int)(pict_piano_roll_width / scalex);
            int maximum = (int)(l + large_change);

#if JAVA
            int thumb_width = 40;
#else
            int thumb_width = System.Windows.Forms.SystemInformation.HorizontalScrollBarThumbWidth;
#endif
            int box_width = (int)(large_change / (float)maximum * (hwidth - 2 * thumb_width));
            if ( box_width < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_width = AppManager.editorConfig.MinimumScrollHandleWidth;
                if ( hwidth - 2 * thumb_width > box_width ) {
                    maximum = l * (hwidth - 2 * thumb_width) / (hwidth - 2 * thumb_width - box_width);
                    large_change = l * box_width / (hwidth - 2 * thumb_width - box_width);
                }
            }

            if ( large_change <= 0 ) large_change = 1;
            if ( maximum <= 0 ) maximum = 1;
            hScroll.setVisibleAmount( large_change );
            hScroll.setMaximum( maximum );
#if JAVA
            int unit_increment = large_change / 10;
            if( unit_increment <= 0 ){
                unit_increment = 1;
            }
            hScroll.setUnitIncrement( unit_increment );
            hScroll.setBlockIncrement( large_change );
#endif

            int old_value = hScroll.getValue();
            if ( old_value > maximum - large_change ) {
                hScroll.setValue( maximum - large_change );
            }
        }

        public void updateScrollRangeVertical()
        {
            // コンポーネントの高さが0の場合，スクロールの設定が出来ないので．
            int pheight = pictPianoRoll.getHeight();
            int vheight = vScroll.getHeight();
            if ( pheight <= 0 || vheight <= 0 ) {
                return;
            }

            float scaley = AppManager.getScaleY();

            int maximum = (int)(128 * (int)(100 * scaley) / scaley);
            int large_change = (int)(pheight / scaley);

#if JAVA
            int thumb_height = 40;
#else
            int thumb_height = System.Windows.Forms.SystemInformation.VerticalScrollBarThumbHeight;
#endif
            int box_height = (int)(large_change / (float)maximum * (vheight - 2 * thumb_height));
            if ( box_height < AppManager.editorConfig.MinimumScrollHandleWidth ) {
                box_height = AppManager.editorConfig.MinimumScrollHandleWidth;
                maximum = (int)(((128.0 * (int)(100 * scaley) - pheight) / scaley) * (vheight - 2 * thumb_height) / (vheight - 2 * thumb_height - box_height));
                large_change = (int)(((128.0 * (int)(100 * scaley) - pheight) / scaley) * box_height / (vheight - 2 * thumb_height - box_height));
            }

            if ( large_change <= 0 ) large_change = 1;
            if ( maximum <= 0 ) maximum = 1;
            vScroll.setVisibleAmount( large_change );
            vScroll.setMaximum( maximum );
#if !JAVA
            vScroll.SmallChange = 100;
#endif

#if JAVA
            int unit_increment = large_change / 10;
            if( unit_increment <= 0 ){
                unit_increment = 1;
            }
            vScroll.setUnitIncrement( unit_increment );
            vScroll.setBlockIncrement( large_change );
#endif

            int old_value = vScroll.getValue();
            if ( old_value > maximum - large_change ) {
                vScroll.setValue( maximum - large_change );
            }
        }

        /// <summary>
        /// コントロールトラックの表示・非表示状態を更新します
        /// </summary>
        public void flipControlCurveVisible( boolean visible )
        {
            trackSelector.setCurveVisible( visible );
            if ( visible ) {
                splitContainer1.setSplitterFixed( false );
                splitContainer1.setDividerSize( _SPL_SPLITTER_WIDTH );
                splitContainer1.setDividerLocation( splitContainer1.getHeight() - AppManager.mLastTrackSelectorHeight - splitContainer1.getDividerSize() );
                splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
            } else {
                AppManager.mLastTrackSelectorHeight = splitContainer1.getHeight() - splitContainer1.getDividerLocation() - splitContainer1.getDividerSize();
                splitContainer1.setSplitterFixed( true );
                splitContainer1.setDividerSize( 0 );
                int panel2height = TrackSelector.OFFSET_TRACK_TAB * 2;
                splitContainer1.setDividerLocation( splitContainer1.getHeight() - panel2height - splitContainer1.getDividerSize() );
                splitContainer1.setPanel2MinSize( panel2height );
            }
            refreshScreen();
        }

        /// <summary>
        /// ミキサーダイアログの表示・非表示状態を更新します
        /// </summary>
        /// <param name="visible">表示状態にする場合true，そうでなければfalse</param>
        public void flipMixerDialogVisible( boolean visible )
        {
            AppManager.mMixerWindow.setVisible( visible );
            AppManager.editorConfig.MixerVisible = visible;
            if( visible != menuVisualMixer.isSelected() ){
                menuVisualMixer.setSelected( visible );
            }
        }

        /// <summary>
        /// アイコンパレットの表示・非表示状態を更新します
        /// </summary>
        public void flipIconPaletteVisible( boolean visible )
        {
            AppManager.iconPalette.setVisible( visible );
            AppManager.editorConfig.IconPaletteVisible = visible;
            if( visible != menuVisualIconPalette.isSelected() ){
                menuVisualIconPalette.setSelected( visible );
            }
        }

        /// <summary>
        /// メニューのショートカットキーを、AppManager.EditorConfig.ShorcutKeysの内容に応じて変更します
        /// </summary>
        public void applyShortcut()
        {
            mSpecialShortcutHolders.clear();

            TreeMap<String, BKeys[]> dict = AppManager.editorConfig.getShortcutKeysDictionary( this.getDefaultShortcutKeys() );
            #region menuStripMain
            ByRef<Object> parent = new ByRef<Object>( null );
            for ( Iterator<String> itr = dict.keySet().iterator(); itr.hasNext(); ) {
                String key = itr.next();
                if ( str.compare( key, "menuEditCopy" ) || str.compare( key, "menuEditCut" ) || str.compare( key, "menuEditPaste" ) || str.compare( key, "SpecialShortcutGoToFirst" ) ) {
                    continue;
                }
                Object menu = searchMenuItemFromName( key, parent );
                if ( menu != null ) {
                    String menu_name = "";
#if JAVA
                    if( menu instanceof Component ){
                        menu_name = ((Component)menu).getName();
                    }else{
                        continue;
                    }
#else
                    if ( menu is BMenuItem ) {
                        menu_name = ((BMenuItem)menu).Name;
                    } else {
                        continue;
                    }
#endif
                    applyMenuItemShortcut( dict, menu, menu_name );
                }
            }
            if ( dict.containsKey( "menuEditCopy" ) ) {
                applyMenuItemShortcut( dict, menuHiddenCopy, "menuEditCopy" );
            }
            if ( dict.containsKey( "menuEditCut" ) ) {
                applyMenuItemShortcut( dict, menuHiddenCut, "menuEditCut" );
            }
            if ( dict.containsKey( "menuEditCopy" ) ) {
                applyMenuItemShortcut( dict, menuHiddenPaste, "menuEditPaste" );
            }
            #endregion

            Vector<ValuePair<String, BMenuItem[]>> work = new Vector<ValuePair<String, BMenuItem[]>>();
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditUndo", new BMenuItem[] { cMenuPianoUndo, cMenuTrackSelectorUndo } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditRedo", new BMenuItem[] { cMenuPianoRedo, cMenuTrackSelectorRedo } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditCut", new BMenuItem[] { cMenuPianoCut, cMenuTrackSelectorCut, menuEditCut } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditCopy", new BMenuItem[] { cMenuPianoCopy, cMenuTrackSelectorCopy, menuEditCopy } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditPaste", new BMenuItem[] { cMenuPianoPaste, cMenuTrackSelectorPaste, menuEditPaste } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditSelectAll", new BMenuItem[] { cMenuPianoSelectAll, cMenuTrackSelectorSelectAll } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditSelectAllEvents", new BMenuItem[] { cMenuPianoSelectAllEvents } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuEditDelete", new BMenuItem[] { menuEditDelete } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuVisualGridline", new BMenuItem[] { cMenuPianoGrid } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuJobLyric", new BMenuItem[] { cMenuPianoImportLyric } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuLyricExpressionProperty", new BMenuItem[] { cMenuPianoExpressionProperty } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuLyricVibratoProperty", new BMenuItem[] { cMenuPianoVibratoProperty } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackOn", new BMenuItem[] { cMenuTrackTabTrackOn } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackAdd", new BMenuItem[] { cMenuTrackTabAdd } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackCopy", new BMenuItem[] { cMenuTrackTabCopy } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackDelete", new BMenuItem[] { cMenuTrackTabDelete } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRenderCurrent", new BMenuItem[] { cMenuTrackTabRenderCurrent } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRenderAll", new BMenuItem[] { cMenuTrackTabRenderAll } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackOverlay", new BMenuItem[] { cMenuTrackTabOverlay } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererVOCALOID1", new BMenuItem[] { cMenuTrackTabRendererVOCALOID1 } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererVOCALOID2", new BMenuItem[] { cMenuTrackTabRendererVOCALOID2 } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererAquesTone", new BMenuItem[] { menuTrackRendererAquesTone } ) );
            work.add( new ValuePair<String, BMenuItem[]>( "menuTrackRendererVCNT", new BMenuItem[] { menuTrackRendererVCNT } ) );
            int c = work.size();
            for ( int j = 0; j < c; j++ ) {
                ValuePair<String, BMenuItem[]> item = work.get( j );
                if ( dict.containsKey( item.getKey() ) ) {
                    BKeys[] k = dict.get( item.getKey() );
                    String s = Utility.getShortcutDisplayString( k );
#if !JAVA
                    if ( s != "" ) {
                        for ( int i = 0; i < item.getValue().Length; i++ ) {
                            item.getValue()[i].ShortcutKeyDisplayString = s;
                        }
                    }
#endif
                }
            }

            // ミキサーウィンドウ
            if ( AppManager.mMixerWindow != null ) {
                if ( dict.containsKey( "menuVisualMixer" ) ) {
                    KeyStroke shortcut = BKeysUtility.getKeyStrokeFromBKeys( dict.get( "menuVisualMixer" ) );
                    AppManager.mMixerWindow.applyShortcut( shortcut );
                }
            }

            // アイコンパレット
            if ( AppManager.iconPalette != null ) {
                if ( dict.containsKey( "menuVisualIconPalette" ) ) {
                    KeyStroke shortcut = BKeysUtility.getKeyStrokeFromBKeys( dict.get( "menuVisualIconPalette" ) );
                    AppManager.iconPalette.applyShortcut( shortcut );
                }
            }

#if ENABLE_PROPERTY
            // プロパティ
            if( AppManager.propertyWindow != null ){
                if( dict.containsKey( menuVisualProperty.getName() ) ){
                    KeyStroke shortcut = BKeysUtility.getKeyStrokeFromBKeys( dict.get( menuVisualProperty.getName() ) );
                    AppManager.propertyWindow.applyShortcut( shortcut );
                }
            }
#endif

            // スクリプトにショートカットを適用
#if JAVA
            MenuElement[] sub_menu_script = menuScript.getSubElements();
            for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                MenuElement tsi = sub_menu_script[i];
                MenuElement[] sub_tsi = tsi.getSubElements();
                if ( sub_tsi.Length == 1 ) {
                    MenuElement dd_run = sub_tsi[0];
#if DEBUG
                    AppManager.debugWriteLine( "    dd_run.name=" + PortUtil.getComponentName( dd_run ) );
#endif
                    if ( dict.containsKey( PortUtil.getComponentName( dd_run ) ) ) {
                        applyMenuItemShortcut( dict, tsi, PortUtil.getComponentName( tsi ) );
                    }
                }
            }
#else
            int count = menuScript.DropDownItems.Count;
            for ( int i = 0; i < count; i++ ) {
                System.Windows.Forms.ToolStripItem tsi = menuScript.DropDownItems[i];
                if ( tsi is System.Windows.Forms.ToolStripMenuItem ) {
                    System.Windows.Forms.ToolStripMenuItem tsmi = (System.Windows.Forms.ToolStripMenuItem)tsi;
                    if ( tsmi.DropDownItems.Count == 1 ) {
                        System.Windows.Forms.ToolStripItem subtsi_tsmi = tsmi.DropDownItems[0];
                        if ( subtsi_tsmi is System.Windows.Forms.ToolStripMenuItem ) {
                            System.Windows.Forms.ToolStripMenuItem dd_run = (System.Windows.Forms.ToolStripMenuItem)subtsi_tsmi;
                            if ( dict.containsKey( PortUtil.getComponentName( dd_run ) ) ) {
                                applyMenuItemShortcut( dict, tsmi, PortUtil.getComponentName( tsi ) );
                            }
                        }
                    }
                }
            }
#endif
        }

        /// <summary>
        /// dictの中から
        /// </summary>
        /// <param name="dict"></param>
        /// <param name="item"></param>
        /// <param name="item_name"></param>
        /// <param name="default_shortcut"></param>
        public void applyMenuItemShortcut( TreeMap<String, BKeys[]> dict, Object item, String item_name )
        {
#if JAVA
            if( item == null ){
                return;
            }
            if( item instanceof JMenu ){
                return;
            }
            if( !(item instanceof BMenuItem) ){
                return;
            }
            BMenuItem menu = (BMenuItem)item;
            menu.setAccelerator( null );
            if( !dict.containsKey( item_name ) ){
                return;
            }
            BKeys[] k = dict.get( item_name );
            if( k == null ){
                return;
            }
            if( k.length <= 0 ){
                return;
            }
            try {
                sout.println( "FormMain#applyMenuItemShortcut; item_name=" + item_name );
                KeyStroke ks = BKeysUtility.getKeyStrokeFromBKeys( k );
                if( str.startsWith( item_name, "menuHidden" ) ){
                    mSpecialShortcutHolders.add(
                        new SpecialShortcutHolder( BKeysUtility.getKeyStrokeFromBKeys( k ), menu ) );
                }else{
                    menu.setAccelerator( ks );
                }
            } catch ( Exception ex ) {
                Logger.write( FormMain.class  + ".applyMenuItemShortcut; ex=" + ex + "\n" );
                ex.printStackTrace();
            }
#else // JAVA
            try {
                if ( dict.containsKey( item_name ) ) {
#if DEBUG
                    if ( !(item is BMenuItem) ) {
                        throw new Exception( "FormMain#applyMenuItemShortcut; item is NOT BMenuItem" );
                    }
#endif // DEBUG
                    if ( item is BMenuItem ) {
                        BMenuItem menu = (BMenuItem)item;
                        BKeys[] keys = dict.get( item_name );
                        System.Windows.Forms.Keys shortcut = BKeysUtility.getKeyStrokeFromBKeys( keys ).keys;

                        if ( shortcut == System.Windows.Forms.Keys.Delete ) {
                            menu.ShortcutKeyDisplayString = "Delete";
                            menu.ShortcutKeys = System.Windows.Forms.Keys.None;
                            mSpecialShortcutHolders.add(
                                new SpecialShortcutHolder( BKeysUtility.getKeyStrokeFromBKeys( keys ), menu ) );
                        } else {
                            try {
                                menu.ShortcutKeyDisplayString = "";
                                menu.ShortcutKeys = shortcut;
                            } catch ( Exception ex ) {
                                // ショートカットの適用に失敗する→特殊な取り扱いが必要
                                menu.ShortcutKeyDisplayString = Utility.getShortcutDisplayString( keys );
                                menu.ShortcutKeys = System.Windows.Forms.Keys.None;
                                mSpecialShortcutHolders.add(
                                    new SpecialShortcutHolder( BKeysUtility.getKeyStrokeFromBKeys( keys ), menu ) );
                            }
                        }
                    }
                } else {
                    if ( item is BMenuItem ) {
                        ((BMenuItem)item).setAccelerator( BKeysUtility.getKeyStrokeFromBKeys( new BKeys[] { BKeys.None } ) );
                    }
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyMenuItemShortcut; ex=" + ex + "\n" );
            }
#endif // else JAVA
        }

        /// <summary>
        /// ソングポジションを1小節進めます
        /// </summary>
        public void forward()
        {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int cl_clock = AppManager.getCurrentClock();
            int unit = QuantizeModeUtil.getQuantizeClock(
                AppManager.editorConfig.getPositionQuantize(),
                AppManager.editorConfig.isPositionQuantizeTriplet() );
            int cl_new = doQuantize( cl_clock + unit, unit );

            if ( cl_new <= hScroll.getMaximum() + (pictPianoRoll.getWidth() - AppManager.keyWidth) * AppManager.getScaleXInv() ) {
                // 表示の更新など
                AppManager.setCurrentClock( cl_new );

                // ステップ入力時の処理
                updateNoteLengthStepSequencer();

                ensureCursorVisible();
                AppManager.setPlaying( playing, this );
                refreshScreen();
            }
        }

        /// <summary>
        /// ソングポジションを1小節戻します
        /// </summary>
        public void rewind()
        {
            boolean playing = AppManager.isPlaying();
            if ( playing ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int cl_clock = AppManager.getCurrentClock();
            int unit = QuantizeModeUtil.getQuantizeClock(
                AppManager.editorConfig.getPositionQuantize(),
                AppManager.editorConfig.isPositionQuantizeTriplet() );
            int cl_new = doQuantize( cl_clock - unit, unit );
            if ( cl_new < 0 ) {
                cl_new = 0;
            }

            AppManager.setCurrentClock( cl_new );

            // ステップ入力時の処理
            updateNoteLengthStepSequencer();

            ensureCursorVisible();
            AppManager.setPlaying( playing, this );
            refreshScreen();
        }

        /// <summary>
        /// cMenuPianoの固定長音符入力の各メニューのチェック状態をm_pencil_modeを元に更新します
        /// </summary>
        public void updateCMenuPianoFixed()
        {
            cMenuPianoFixed01.setSelected( false );
            cMenuPianoFixed02.setSelected( false );
            cMenuPianoFixed04.setSelected( false );
            cMenuPianoFixed08.setSelected( false );
            cMenuPianoFixed16.setSelected( false );
            cMenuPianoFixed32.setSelected( false );
            cMenuPianoFixed64.setSelected( false );
            cMenuPianoFixed128.setSelected( false );
            cMenuPianoFixedOff.setSelected( false );
            cMenuPianoFixedTriplet.setSelected( false );
            cMenuPianoFixedDotted.setSelected( false );
            PencilModeEnum mode = mPencilMode.getMode();
            if ( mode == PencilModeEnum.L1 ) {
                cMenuPianoFixed01.setSelected( true );
            } else if ( mode == PencilModeEnum.L2 ) {
                cMenuPianoFixed02.setSelected( true );
            } else if ( mode == PencilModeEnum.L4 ) {
                cMenuPianoFixed04.setSelected( true );
            } else if ( mode == PencilModeEnum.L8 ) {
                cMenuPianoFixed08.setSelected( true );
            } else if ( mode == PencilModeEnum.L16 ) {
                cMenuPianoFixed16.setSelected( true );
            } else if ( mode == PencilModeEnum.L32 ) {
                cMenuPianoFixed32.setSelected( true );
            } else if ( mode == PencilModeEnum.L64 ) {
                cMenuPianoFixed64.setSelected( true );
            } else if ( mode == PencilModeEnum.L128 ) {
                cMenuPianoFixed128.setSelected( true );
            } else if ( mode == PencilModeEnum.Off ) {
                cMenuPianoFixedOff.setSelected( true );
            }
            cMenuPianoFixedTriplet.setSelected( mPencilMode.isTriplet() );
            cMenuPianoFixedDotted.setSelected( mPencilMode.isDot() );
        }

        public void clearTempWave()
        {
            String tmppath = fsys.combine( AppManager.getCadenciiTempDir(), AppManager.getID() );
            if ( !fsys.isDirectoryExists( tmppath ) ) {
                return;
            }

            // 今回このPCが起動されるよりも以前に，Cadenciiが残したデータを削除する
            //TODO: システムカウンタは約49日でリセットされてしまい，厳密には実装できないようなので，保留．

            // このFormMainのインスタンスが使用したデータを消去する
            for ( int i = 1; i <= 16; i++ ) {
                String file = fsys.combine( tmppath, i + ".wav" );
                if ( fsys.isFileExists( file ) ) {
                    for ( int error = 0; error < 100; error++ ) {
                        try {
                            PortUtil.deleteFile( file );
                            break;
                        } catch ( Exception ex ) {
                            Logger.write( typeof( FormMain ) + ".clearTempWave; ex=" + ex + "\n" );
#if !JAVA
#if DEBUG
                            org.kbinani.debug.push_log( "FormMain+ClearTempWave()" );
                            org.kbinani.debug.push_log( "    ex=" + ex.ToString() );
                            org.kbinani.debug.push_log( "    error_count=" + error );
#endif
#endif

#if JAVA
                            try{
                                Thread.sleep( 100 );
                            }catch( Exception ex2 ){
                                Logger.write( typeof( FormMain ) + ".clearTempWave; ex=" + ex2 + "\n" );
                            }
#else
                            Thread.Sleep( 100 );
#endif
                        }
                    }
                }
            }
            String whd = fsys.combine( tmppath, UtauWaveGenerator.FILEBASE + ".whd" );
            if ( fsys.isFileExists( whd ) ) {
                try {
                    PortUtil.deleteFile( whd );
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".clearTempWave; ex=" + ex + "\n" );
                }
            }
            String dat = fsys.combine( tmppath, UtauWaveGenerator.FILEBASE + ".dat" );
            if ( fsys.isFileExists( dat ) ) {
                try {
                    PortUtil.deleteFile( dat );
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".clearTempWave; ex=" + ex + "\n" );
                }
            }
        }

        /// <summary>
        /// 鍵盤音キャッシュの中から指定したノートナンバーの音源を捜し、再生します。
        /// </summary>
        /// <param name="note">再生する音の高さを指定するノートナンバー</param>
        public void playPreviewSound( int note )
        {
            KeySoundPlayer.play( note );
        }

#if ENABLE_MOUSEHOVER
        public void MouseHoverEventGenerator( Object arg ) {
            int note = (int)arg;
            if ( AppManager.editorConfig.MouseHoverTime > 0 ) {
                Thread.Sleep( AppManager.editorConfig.MouseHoverTime );
            }
            KeySoundPlayer.play( note );
        }
#endif

        /// <summary>
        /// このコンポーネントの表示言語を、現在の言語設定に従って更新します。
        /// </summary>
        public void applyLanguage()
        {
            openXmlVsqDialog.clearChoosableFileFilter();
            try {
                openXmlVsqDialog.addFileFilter( _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) );
                openXmlVsqDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                openXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );
                openXmlVsqDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            saveXmlVsqDialog.clearChoosableFileFilter();
            try {
                saveXmlVsqDialog.addFileFilter( _( "XML-VSQ Format(*.xvsq)|*.xvsq" ) );
                saveXmlVsqDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                saveXmlVsqDialog.addFileFilter( "XML-VSQ Format(*.xvsq)|*.xvsq" );
                saveXmlVsqDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openUstDialog.clearChoosableFileFilter();
            try {
                openUstDialog.addFileFilter( _( "UTAU Script Format(*.ust)|*.ust" ) );
                openUstDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                openUstDialog.addFileFilter( "UTAU Script Format(*.ust)|*.ust" );
                openUstDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openMidiDialog.clearChoosableFileFilter();
            try {
                openMidiDialog.addFileFilter( _( "MIDI Format(*.mid)|*.mid" ) );
                openMidiDialog.addFileFilter( _( "VSQ Format(*.vsq)|*.vsq" ) );
                openMidiDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                openMidiDialog.addFileFilter( "MIDI Format(*.mid)|*.mid" );
                openMidiDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
                openMidiDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            saveMidiDialog.clearChoosableFileFilter();
            try {
                saveMidiDialog.addFileFilter( _( "MIDI Format(*.mid)|*.mid" ) );
                saveMidiDialog.addFileFilter( _( "VSQ Format(*.vsq)|*.vsq" ) );
                saveMidiDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                saveMidiDialog.addFileFilter( "MIDI Format(*.mid)|*.mid" );
                saveMidiDialog.addFileFilter( "VSQ Format(*.vsq)|*.vsq" );
                saveMidiDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

            openWaveDialog.clearChoosableFileFilter();
            try {
                openWaveDialog.addFileFilter( _( "Wave File(*.wav)|*.wav" ) );
                openWaveDialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".applyLanguage; ex=" + ex + "\n" );
                openWaveDialog.addFileFilter( "Wave File(*.wav)|*.wav" );
                openWaveDialog.addFileFilter( "All Files(*.*)|*.*" );
            }

#if !JAVA
            stripLblGameCtrlMode.setToolTipText( _( "Game controler" ) );
#endif

#if JAVA
            updateGameControlerStatus( this, new EventArgs() );
#else
            this.Invoke( new BEventHandler( updateGameControlerStatus ) );
#endif

#if JAVA
            stripBtnPointer.setText( _( "Pointer" ) );
            stripBtnPointer.setToolTipText( _( "Pointer" ) );
            stripBtnPencil.setText( _( "Pencil" ) );
            stripBtnPencil.setToolTipText( _( "Pencil" ) );
            stripBtnLine.setText( _( "Line" ) );
            stripBtnLine.setToolTipText( _( "Line" ) );
            stripBtnEraser.setText( _( "Eraser" ) );
            stripBtnEraser.setToolTipText( _( "Eraser" ) );
            //stripBtnCurve.setText( _( "Curve" ) );
            stripBtnCurve.setToolTipText( _( "Curve" ) );
            //stripBtnGrid.setText( _( "Grid" ) );
            stripBtnGrid.setToolTipText( _( "Grid" ) );
            if ( AppManager.isPlaying() ) {
                stripBtnPlay.setText( _( "Stop" ) );
            } else {
                stripBtnPlay.setText( _( "Play" ) );
            }
#else
            stripBtnPointer.Text = _( "Pointer" );
            stripBtnPointer.ToolTipText = _( "Pointer" );
            stripBtnPencil.Text = _( "Pencil" );
            stripBtnPencil.ToolTipText = _( "Pencil" );
            stripBtnLine.Text = _( "Line" );
            stripBtnLine.ToolTipText = _( "Line" );
            stripBtnEraser.Text = _( "Eraser" );
            stripBtnEraser.ToolTipText = _( "Eraser" );
            stripBtnCurve.Text = _( "Curve" );
            stripBtnCurve.ToolTipText = _( "Curve" );
            stripBtnGrid.Text = _( "Grid" );
            stripBtnGrid.ToolTipText = _( "Grid" );
            if ( AppManager.isPlaying() ) {
                stripBtnPlay.Text = _( "Stop" );
            } else {
                stripBtnPlay.Text = _( "Play" );
            }
#endif

#if !JAVA
            stripBtnMoveTop.ToolTipText = _( "Move to beginning measure" );
            stripBtnMoveEnd.ToolTipText = _( "Move to end measure" );
            stripBtnForward.ToolTipText = _( "Move forward" );
            stripBtnRewind.ToolTipText = _( "Move backwared" );
            stripBtnLoop.ToolTipText = _( "Repeat" );
            stripBtnScroll.ToolTipText = _( "Auto scroll" );
#endif

            #region main menu
            menuFile.setText( _( "File" ) );
            menuFile.setMnemonic( KeyEvent.VK_F );
            menuFileNew.setText( _( "New" ) );
            menuFileNew.setMnemonic( KeyEvent.VK_N );
            menuFileOpen.setText( _( "Open" ) );
            menuFileOpen.setMnemonic( KeyEvent.VK_O );
            menuFileOpenVsq.setText( _( "Open VSQ/Vocaloid MIDI" ) );
            menuFileOpenVsq.setMnemonic( KeyEvent.VK_V );
            menuFileOpenUst.setText( _( "Open UTAU project file" ) );
            menuFileOpenUst.setMnemonic( KeyEvent.VK_U );
            menuFileSave.setText( _( "Save" ) );
            menuFileSave.setMnemonic( KeyEvent.VK_S );
            menuFileSaveNamed.setText( _( "Save as" ) );
            menuFileSaveNamed.setMnemonic( KeyEvent.VK_A );
            menuFileImport.setText( _( "Import" ) );
            menuFileImport.setMnemonic( KeyEvent.VK_I );
            menuFileImportVsq.setText( _( "VSQ / Vocaloid Midi" ) );
            menuFileExport.setText( _( "Export" ) );
            menuFileExport.setMnemonic( KeyEvent.VK_E );
            menuFileExportWave.setText( _( "WAVE" ) );
            menuFileExportParaWave.setText( _( "Serial numbered WAVEs" ) );
            menuFileExportUst.setText( _( "UTAU project file" ) );
            menuFileExportVxt.setText( _( "Metatext for vConnect" ) );
            menuFileRecent.setText( _( "Open Recent" ) );
            menuFileRecent.setMnemonic( KeyEvent.VK_R );
            menuFileRecentClear.setText( _( "Clear Menu" ) );
            menuFileQuit.setText( _( "Quit" ) );
            menuFileQuit.setMnemonic( KeyEvent.VK_Q );

            menuEdit.setText( _( "Edit" ) );
            menuEdit.setMnemonic( KeyEvent.VK_E );
            menuEditUndo.setText( _( "Undo" ) );
            menuEditUndo.setMnemonic( KeyEvent.VK_U );
            menuEditRedo.setText( _( "Redo" ) );
            menuEditRedo.setMnemonic( KeyEvent.VK_R );
            menuEditCut.setText( _( "Cut" ) );
            menuEditCut.setMnemonic( KeyEvent.VK_T );
            menuEditCopy.setText( _( "Copy" ) );
            menuEditCopy.setMnemonic( KeyEvent.VK_C );
            menuEditPaste.setText( _( "Paste" ) );
            menuEditPaste.setMnemonic( KeyEvent.VK_P );
            menuEditDelete.setText( _( "Delete" ) );
            menuEditDelete.setMnemonic( KeyEvent.VK_D );
            menuEditAutoNormalizeMode.setText( _( "Auto normalize mode" ) );
            menuEditAutoNormalizeMode.setMnemonic( KeyEvent.VK_N );
            menuEditSelectAll.setText( _( "Select All" ) );
            menuEditSelectAll.setMnemonic( KeyEvent.VK_A );
            menuEditSelectAllEvents.setText( _( "Select all events" ) );
            menuEditSelectAllEvents.setMnemonic( KeyEvent.VK_E );

            menuVisual.setText( _( "View" ) );
            menuVisual.setMnemonic( KeyEvent.VK_V );
            menuVisualControlTrack.setText( _( "Control track" ) );
            menuVisualControlTrack.setMnemonic( KeyEvent.VK_C );
            menuVisualMixer.setText( _( "Mixer" ) );
            menuVisualMixer.setMnemonic( KeyEvent.VK_X );
            menuVisualWaveform.setText( _( "Waveform" ) );
            menuVisualWaveform.setMnemonic( KeyEvent.VK_W );
            menuVisualProperty.setText( _( "Property window" ) );
            menuVisualOverview.setText( _( "Navigation" ) );
            menuVisualOverview.setMnemonic( KeyEvent.VK_V );
            menuVisualGridline.setText( _( "Grid line" ) );
            menuVisualGridline.setMnemonic( KeyEvent.VK_G );
            menuVisualStartMarker.setText( _( "Start marker" ) );
            menuVisualStartMarker.setMnemonic( KeyEvent.VK_S );
            menuVisualEndMarker.setText( _( "End marker" ) );
            menuVisualEndMarker.setMnemonic( KeyEvent.VK_E );
            menuVisualLyrics.setText( _( "Lyrics/Phoneme" ) );
            menuVisualLyrics.setMnemonic( KeyEvent.VK_L );
            menuVisualNoteProperty.setText( _( "Note expression/vibrato" ) );
            menuVisualNoteProperty.setMnemonic( KeyEvent.VK_N );
            menuVisualPitchLine.setText( _( "Pitch line" ) );
            menuVisualPitchLine.setMnemonic( KeyEvent.VK_P );
            menuVisualPluginUi.setText( _( "VSTi plugin UI" ) );
            menuVisualPluginUi.setMnemonic( KeyEvent.VK_U );
            menuVisualIconPalette.setText( _( "Icon palette" ) );
            menuVisualIconPalette.setMnemonic( KeyEvent.VK_I );

            menuJob.setText( _( "Job" ) );
            menuJob.setMnemonic( KeyEvent.VK_J );
            menuJobNormalize.setText( _( "Normalize notes" ) );
            menuJobNormalize.setMnemonic( KeyEvent.VK_N );
            menuJobInsertBar.setText( _( "Insert bars" ) );
            menuJobInsertBar.setMnemonic( KeyEvent.VK_I );
            menuJobDeleteBar.setText( _( "Delete bars" ) );
            menuJobDeleteBar.setMnemonic( KeyEvent.VK_D );
            menuJobRandomize.setText( _( "Randomize" ) );
            menuJobRandomize.setMnemonic( KeyEvent.VK_R );
            menuJobConnect.setText( _( "Connect notes" ) );
            menuJobConnect.setMnemonic( KeyEvent.VK_C );
            menuJobLyric.setText( _( "Insert lyrics" ) );
            menuJobLyric.setMnemonic( KeyEvent.VK_L );

            menuTrack.setText( _( "Track" ) );
            menuTrack.setMnemonic( KeyEvent.VK_T );
            menuTrackOn.setText( _( "Track on" ) );
            menuTrackOn.setMnemonic( KeyEvent.VK_K );
            menuTrackAdd.setText( _( "Add track" ) );
            menuTrackAdd.setMnemonic( KeyEvent.VK_A );
            menuTrackCopy.setText( _( "Copy track" ) );
            menuTrackCopy.setMnemonic( KeyEvent.VK_C );
            menuTrackChangeName.setText( _( "Rename track" ) );
            menuTrackDelete.setText( _( "Delete track" ) );
            menuTrackDelete.setMnemonic( KeyEvent.VK_D );
            menuTrackRenderCurrent.setText( _( "Render current track" ) );
            menuTrackRenderCurrent.setMnemonic( KeyEvent.VK_T );
            menuTrackRenderAll.setText( _( "Render all tracks" ) );
            menuTrackRenderAll.setMnemonic( KeyEvent.VK_S );
            menuTrackOverlay.setText( _( "Overlay" ) );
            menuTrackOverlay.setMnemonic( KeyEvent.VK_O );
            menuTrackRenderer.setText( _( "Renderer" ) );
            menuTrackRenderer.setMnemonic( KeyEvent.VK_R );
            menuTrackRendererVOCALOID1.setMnemonic( KeyEvent.VK_1 );
            menuTrackRendererVOCALOID2.setMnemonic( KeyEvent.VK_3 );
            menuTrackRendererUtau.setMnemonic( KeyEvent.VK_4 );
            menuTrackRendererVCNT.setMnemonic( KeyEvent.VK_5 );
            menuTrackRendererAquesTone.setMnemonic( KeyEvent.VK_6 );

            menuLyric.setText( _( "Lyrics" ) );
            menuLyric.setMnemonic( KeyEvent.VK_L );
            menuLyricExpressionProperty.setText( _( "Note expression property" ) );
            menuLyricExpressionProperty.setMnemonic( KeyEvent.VK_E );
            menuLyricVibratoProperty.setText( _( "Note vibrato property" ) );
            menuLyricVibratoProperty.setMnemonic( KeyEvent.VK_V );
            menuLyricApplyUtauParameters.setText( _( "Apply UTAU Parameters" ) );
            menuLyricApplyUtauParameters.setMnemonic( KeyEvent.VK_A );
            menuLyricPhonemeTransformation.setText( _( "Phoneme transformation" ) );
            menuLyricPhonemeTransformation.setMnemonic( KeyEvent.VK_T );
            menuLyricDictionary.setText( _( "User word dictionary" ) );
            menuLyricDictionary.setMnemonic( KeyEvent.VK_C );
            menuLyricCopyVibratoToPreset.setText( _( "Copy vibrato config to preset" ) );
            menuLyricCopyVibratoToPreset.setMnemonic( KeyEvent.VK_P );

            menuScript.setText( _( "Script" ) );
            menuScript.setMnemonic( KeyEvent.VK_C );
            menuScriptUpdate.setText( _( "Update script list" ) );
            menuScriptUpdate.setMnemonic( KeyEvent.VK_U );

            menuSetting.setText( _( "Setting" ) );
            menuSetting.setMnemonic( KeyEvent.VK_S );
            menuSettingPreference.setText( _( "Preference" ) );
            menuSettingPreference.setMnemonic( KeyEvent.VK_P );
            menuSettingGameControler.setText( _( "Game controler" ) );
            menuSettingGameControler.setMnemonic( KeyEvent.VK_G );
            menuSettingGameControlerLoad.setText( _( "Load" ) );
            menuSettingGameControlerLoad.setMnemonic( KeyEvent.VK_L );
            menuSettingGameControlerRemove.setText( _( "Remove" ) );
            menuSettingGameControlerRemove.setMnemonic( KeyEvent.VK_R );
            menuSettingGameControlerSetting.setText( _( "Setting" ) );
            menuSettingGameControlerSetting.setMnemonic( KeyEvent.VK_S );
            menuSettingSequence.setText( _( "Sequence config" ) );
            menuSettingSequence.setMnemonic( KeyEvent.VK_S );
            menuSettingShortcut.setText( _( "Shortcut key" ) );
            menuSettingShortcut.setMnemonic( KeyEvent.VK_K );
            menuSettingDefaultSingerStyle.setText( _( "Singing style defaults" ) );
            menuSettingDefaultSingerStyle.setMnemonic( KeyEvent.VK_D );
            menuSettingPositionQuantize.setText( _( "Quantize" ) );
            menuSettingPositionQuantize.setMnemonic( KeyEvent.VK_Q );
            menuSettingPositionQuantizeOff.setText( _( "Off" ) );
            menuSettingPositionQuantizeTriplet.setText( _( "Triplet" ) );
            //menuSettingSingerProperty.setText( _( "Singer Properties" ) );
            //menuSettingSingerProperty.setMnemonic( KeyEvent.VK_S );
            menuSettingPaletteTool.setText( _( "Palette Tool" ) );
            menuSettingPaletteTool.setMnemonic( KeyEvent.VK_T );
            menuSettingVibratoPreset.setText( _( "Vibrato preset" ) );
            menuSettingVibratoPreset.setMnemonic( KeyEvent.VK_V );

#if JAVA
            menuWindow.setText( _( "Window" ) );
            menuWindowMinimize.setText( _( "Minimize" ) );
#endif

            menuHelp.setText( _( "Help" ) );
            menuHelp.setMnemonic( KeyEvent.VK_H );
            menuHelpLog.setText( _( "Log" ) );
            menuHelpLog.setMnemonic( KeyEvent.VK_L );
            menuHelpLogSwitch.setText( Logger.isEnabled() ? _( "Disable" ) : _( "Enable" ) );
            menuHelpLogSwitch.setMnemonic( KeyEvent.VK_L );
            menuHelpLogOpen.setText( _( "Open" ) );
            menuHelpLogOpen.setMnemonic( KeyEvent.VK_O );
            menuHelpAbout.setText( _( "About Cadencii" ) );
            menuHelpAbout.setMnemonic( KeyEvent.VK_A );
            menuHelpManual.setText( _( "Manual" ) + " (PDF)" );

            menuHiddenCopy.setText( _( "Copy" ) );
            menuHiddenCut.setText( _( "Cut" ) );
            menuHiddenEditFlipToolPointerEraser.setText( _( "Chagne tool pointer / eraser" ) );
            menuHiddenEditFlipToolPointerPencil.setText( _( "Change tool pointer / pencil" ) );
            menuHiddenEditLyric.setText( _( "Start lyric input" ) );
            menuHiddenGoToEndMarker.setText( _( "GoTo end marker" ) );
            menuHiddenGoToStartMarker.setText( _( "Goto start marker" ) );
            menuHiddenLengthen.setText( _( "Lengthen" ) );
            menuHiddenMoveDown.setText( _( "Move down" ) );
            menuHiddenMoveLeft.setText( _( "Move left" ) );
            menuHiddenMoveRight.setText( _( "Move right" ) );
            menuHiddenMoveUp.setText( _( "Move up" ) );
            menuHiddenPaste.setText( _( "Paste" ) );
            menuHiddenPlayFromStartMarker.setText( _( "Play from start marker" ) );
            menuHiddenSelectBackward.setText( _( "Select backward" ) );
            menuHiddenSelectForward.setText( _( "Select forward" ) );
            menuHiddenShorten.setText( _( "Shorten" ) );
            menuHiddenTrackBack.setText( _( "Previous track" ) );
            menuHiddenTrackNext.setText( _( "Next track" ) );
            menuHiddenVisualBackwardParameter.setText( _( "Previous control curve" ) );
            menuHiddenVisualForwardParameter.setText( _( "Next control curve" ) );
            menuHiddenFlipCurveOnPianorollMode.setText( _( "Change pitch drawing mode" ) );
            #endregion

            #region cMenuPiano
            cMenuPianoPointer.setText( _( "Arrow" ) );
            cMenuPianoPointer.setMnemonic( KeyEvent.VK_A );
            cMenuPianoPencil.setText( _( "Pencil" ) );
            cMenuPianoPencil.setMnemonic( KeyEvent.VK_W );
            cMenuPianoEraser.setText( _( "Eraser" ) );
            cMenuPianoEraser.setMnemonic( KeyEvent.VK_E );
            cMenuPianoPaletteTool.setText( _( "Palette Tool" ) );

            cMenuPianoCurve.setText( _( "Curve" ) );
            cMenuPianoCurve.setMnemonic( KeyEvent.VK_V );

            cMenuPianoFixed.setText( _( "Note Fixed Length" ) );
            cMenuPianoFixed.setMnemonic( KeyEvent.VK_N );
            cMenuPianoFixedTriplet.setText( _( "Triplet" ) );
            cMenuPianoFixedOff.setText( _( "Off" ) );
            cMenuPianoFixedDotted.setText( _( "Dot" ) );
            cMenuPianoQuantize.setText( _( "Quantize" ) );
            cMenuPianoQuantize.setMnemonic( KeyEvent.VK_Q );
            cMenuPianoQuantizeTriplet.setText( _( "Triplet" ) );
            cMenuPianoQuantizeOff.setText( _( "Off" ) );
            cMenuPianoGrid.setText( _( "Show/Hide Grid Line" ) );
            cMenuPianoGrid.setMnemonic( KeyEvent.VK_S );

            cMenuPianoUndo.setText( _( "Undo" ) );
            cMenuPianoUndo.setMnemonic( KeyEvent.VK_U );
            cMenuPianoRedo.setText( _( "Redo" ) );
            cMenuPianoRedo.setMnemonic( KeyEvent.VK_R );

            cMenuPianoCut.setText( _( "Cut" ) );
            cMenuPianoCut.setMnemonic( KeyEvent.VK_T );
            cMenuPianoPaste.setText( _( "Paste" ) );
            cMenuPianoPaste.setMnemonic( KeyEvent.VK_P );
            cMenuPianoCopy.setText( _( "Copy" ) );
            cMenuPianoCopy.setMnemonic( KeyEvent.VK_C );
            cMenuPianoDelete.setText( _( "Delete" ) );
            cMenuPianoDelete.setMnemonic( KeyEvent.VK_D );

            cMenuPianoSelectAll.setText( _( "Select All" ) );
            cMenuPianoSelectAll.setMnemonic( KeyEvent.VK_A );
            cMenuPianoSelectAllEvents.setText( _( "Select All Events" ) );
            cMenuPianoSelectAllEvents.setMnemonic( KeyEvent.VK_E );

            cMenuPianoExpressionProperty.setText( _( "Note Expression Property" ) );
            cMenuPianoExpressionProperty.setMnemonic( KeyEvent.VK_P );
            cMenuPianoVibratoProperty.setText( _( "Note Vibrato Property" ) );
            cMenuPianoImportLyric.setText( _( "Insert Lyrics" ) );
            cMenuPianoImportLyric.setMnemonic( KeyEvent.VK_P );
            #endregion

            #region cMenuTrackTab
            cMenuTrackTabTrackOn.setText( _( "Track On" ) );
            cMenuTrackTabTrackOn.setMnemonic( KeyEvent.VK_K );
            cMenuTrackTabAdd.setText( _( "Add Track" ) );
            cMenuTrackTabAdd.setMnemonic( KeyEvent.VK_A );
            cMenuTrackTabCopy.setText( _( "Copy Track" ) );
            cMenuTrackTabCopy.setMnemonic( KeyEvent.VK_C );
            cMenuTrackTabChangeName.setText( _( "Rename Track" ) );
            cMenuTrackTabDelete.setText( _( "Delete Track" ) );
            cMenuTrackTabDelete.setMnemonic( KeyEvent.VK_D );

            cMenuTrackTabRenderCurrent.setText( _( "Render Current Track" ) );
            cMenuTrackTabRenderCurrent.setMnemonic( KeyEvent.VK_T );
            cMenuTrackTabRenderAll.setText( _( "Render All Tracks" ) );
            cMenuTrackTabRenderAll.setMnemonic( KeyEvent.VK_S );
            cMenuTrackTabOverlay.setText( _( "Overlay" ) );
            cMenuTrackTabOverlay.setMnemonic( KeyEvent.VK_O );
            cMenuTrackTabRenderer.setText( _( "Renderer" ) );
            cMenuTrackTabRenderer.setMnemonic( KeyEvent.VK_R );
            #endregion

            #region cMenuTrackSelector
            cMenuTrackSelectorPointer.setText( _( "Arrow" ) );
            cMenuTrackSelectorPointer.setMnemonic( KeyEvent.VK_A );
            cMenuTrackSelectorPencil.setText( _( "Pencil" ) );
            cMenuTrackSelectorPencil.setMnemonic( KeyEvent.VK_W );
            cMenuTrackSelectorLine.setText( _( "Line" ) );
            cMenuTrackSelectorLine.setMnemonic( KeyEvent.VK_L );
            cMenuTrackSelectorEraser.setText( _( "Eraser" ) );
            cMenuTrackSelectorEraser.setMnemonic( KeyEvent.VK_E );
            cMenuTrackSelectorPaletteTool.setText( _( "Palette Tool" ) );

            cMenuTrackSelectorCurve.setText( _( "Curve" ) );
            cMenuTrackSelectorCurve.setMnemonic( KeyEvent.VK_V );

            cMenuTrackSelectorUndo.setText( _( "Undo" ) );
            cMenuTrackSelectorUndo.setMnemonic( KeyEvent.VK_U );
            cMenuTrackSelectorRedo.setText( _( "Redo" ) );
            cMenuTrackSelectorRedo.setMnemonic( KeyEvent.VK_R );

            cMenuTrackSelectorCut.setText( _( "Cut" ) );
            cMenuTrackSelectorCut.setMnemonic( KeyEvent.VK_T );
            cMenuTrackSelectorCopy.setText( _( "Copy" ) );
            cMenuTrackSelectorCopy.setMnemonic( KeyEvent.VK_C );
            cMenuTrackSelectorPaste.setText( _( "Paste" ) );
            cMenuTrackSelectorPaste.setMnemonic( KeyEvent.VK_P );
            cMenuTrackSelectorDelete.setText( _( "Delete" ) );
            cMenuTrackSelectorDelete.setMnemonic( KeyEvent.VK_D );
            cMenuTrackSelectorDeleteBezier.setText( _( "Delete Bezier Point" ) );
            cMenuTrackSelectorDeleteBezier.setMnemonic( KeyEvent.VK_B );

            cMenuTrackSelectorSelectAll.setText( _( "Select All Events" ) );
            cMenuTrackSelectorSelectAll.setMnemonic( KeyEvent.VK_E );
            #endregion

            #region cMenuPositionIndicator
            cMenuPositionIndicatorStartMarker.setText( _( "Set start marker" ) );
            cMenuPositionIndicatorEndMarker.setText( _( "Set end marker" ) );
            #endregion

#if !JAVA
            stripLblGameCtrlMode.setToolTipText( _( "Game Controler" ) );
#endif

            // Palette Tool
#if DEBUG
            AppManager.debugWriteLine( "FormMain#applyLanguage; Messaging.Language=" + Messaging.getLanguage() );
#endif
#if ENABLE_SCRIPT
            int count = toolBarTool.Buttons.Count;// toolStripTool.getComponentCount();
            for ( int i = 0; i < count; i++ ) {
                Object tsi = toolBarTool.Buttons[i];// toolStripTool.getComponentAtIndex( i );
                if ( tsi is System.Windows.Forms.ToolBarButton ) {
                    System.Windows.Forms.ToolBarButton tsb = (System.Windows.Forms.ToolBarButton)tsi;
                    if ( tsb.Style == System.Windows.Forms.ToolBarButtonStyle.ToggleButton && tsb.Tag != null && tsb.Tag is String ) {
                        String id = (String)tsb.Tag;
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsb.Text = ipt.getName( Messaging.getLanguage() );
                            tsb.ToolTipText = ipt.getDescription( Messaging.getLanguage() );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in cMenuPianoPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                            tsmi.setToolTipText( ipt.getDescription( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in cMenuTrackSelectorPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                            tsmi.setToolTipText( ipt.getDescription( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            foreach ( MenuElement tsi in menuSettingPaletteTool.getSubElements() ) {
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                        String id = (String)tsmi.getTag();
                        if ( PaletteToolServer.loadedTools.containsKey( id ) ) {
                            IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                            tsmi.setText( ipt.getName( Messaging.getLanguage() ) );
                        }
                    }
                }
            }

            for ( Iterator<String> itr = PaletteToolServer.loadedTools.keySet().iterator(); itr.hasNext(); ) {
                String id = (String)itr.next();
                IPaletteTool ipt = (IPaletteTool)PaletteToolServer.loadedTools.get( id );
                ipt.applyLanguage( Messaging.getLanguage() );
            }
#endif
        }

        /// <summary>
        /// 歌詞の流し込みダイアログを開き，選択された音符を起点に歌詞を流し込みます
        /// </summary>
        public void importLyric()
        {
            int start = 0;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int selectedid = AppManager.getLastSelectedEvent().original.InternalID;
            int numEvents = vsq_track.getEventCount();
            for ( int i = 0; i < numEvents; i++ ) {
                if ( selectedid == vsq_track.getEvent( i ).InternalID ) {
                    start = i;
                    break;
                }
            }
            int count = vsq_track.getEventCount() - 1 - start + 1;
            try {
                if ( mDialogImportLyric == null ) {
                    mDialogImportLyric = new FormImportLyric( count );
                } else {
                    mDialogImportLyric.setMaxNotes( count );
                }
                mDialogImportLyric.setLocation( getFormPreferedLocation( mDialogImportLyric ) );
                BDialogResult dr = AppManager.showModalDialog( mDialogImportLyric, this );
                if ( dr == BDialogResult.OK ) {
                    String[] phrases = mDialogImportLyric.getLetters();
#if DEBUG
                    foreach ( String s in phrases ) {
                        sout.println( "FormMain#importLyric; phrases; s=" + s );
                    }
#endif
                    int min = Math.Min( count, phrases.Length );
                    Vector<String> new_phrases = new Vector<String>();
                    Vector<String> new_symbols = new Vector<String>();
                    for ( int i = 0; i < phrases.Length; i++ ) {
                        SymbolTableEntry entry = SymbolTable.attatch( phrases[i] );
                        if ( new_phrases.size() + 1 > count ) {
                            break;
                        }
                        if ( entry == null ) {
                            new_phrases.add( phrases[i] );
                            new_symbols.add( "a" );
                        } else {
                            if ( entry.Word.IndexOf( '-' ) >= 0 ) {
                                // 分節に分割する必要がある
                                String[] spl = PortUtil.splitString( entry.Word, '\t' );
                                if ( new_phrases.size() + spl.Length > count ) {
                                    // 分節の全部を分割すると制限個数を超えてしまう
                                    // 分割せずにハイフンを付けたまま登録
                                    new_phrases.add( entry.Word.Replace( "\t", "" ) );
                                    new_symbols.add( entry.getSymbol() );
                                } else {
                                    String[] spl_symbol = PortUtil.splitString( entry.getRawSymbol(), '\t' );
                                    for ( int j = 0; j < spl.Length; j++ ) {
                                        new_phrases.add( spl[j] );
                                        new_symbols.add( spl_symbol[j] );
                                    }
                                }
                            } else {
                                // 分節に分割しない
                                new_phrases.add( phrases[i] );
                                new_symbols.add( entry.getSymbol() );
                            }
                        }
                    }
                    VsqEvent[] new_events = new VsqEvent[new_phrases.size()];
                    int indx = -1;
                    for ( Iterator<Integer> itr = vsq_track.indexIterator( IndexIteratorKind.NOTE ); itr.hasNext(); ) {
                        int index = itr.next();
                        if ( index < start ) {
                            continue;
                        }
                        indx++;
                        VsqEvent item = vsq_track.getEvent( index );
                        new_events[indx] = (VsqEvent)item.clone();
                        new_events[indx].ID.LyricHandle.L0.Phrase = new_phrases.get( indx );
                        new_events[indx].ID.LyricHandle.L0.setPhoneticSymbol( new_symbols.get( indx ) );
                        AppManager.applyUtauParameter( vsq_track, new_events[indx] );
                        if ( indx + 1 >= new_phrases.size() ) {
                            break;
                        }
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventReplaceRange( selected, new_events ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".importLyric; ex=" + ex + "\n" );
            } finally {
                mDialogImportLyric.setVisible( false );
            }
        }

        /// <summary>
        /// 選択されている音符のビブラートを編集するためのダイアログを起動し、編集を行います。
        /// </summary>
        public void editNoteVibratoProperty()
        {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            SynthesizerType type = SynthesizerType.VOCALOID2;
            if ( kind == RendererKind.VOCALOID1 ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormVibratoConfig dlg = null;
            try {
                dlg = new FormVibratoConfig(
                    ev.ID.VibratoHandle,
                    ev.ID.getLength(),
                    AppManager.editorConfig.DefaultVibratoLength,
                    type,
                    AppManager.editorConfig.UseUserDefinedAutoVibratoType );
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dlg.getDialogResult() == BDialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    if ( dlg.getVibratoHandle() != null ) {
                        edited.ID.VibratoHandle = (VibratoHandle)dlg.getVibratoHandle().clone();
                        //edited.ID.VibratoHandle.setStartDepth( AppManager.editorConfig.DefaultVibratoDepth );
                        //edited.ID.VibratoHandle.setStartRate( AppManager.editorConfig.DefaultVibratoRate );
                        edited.ID.VibratoDelay = ev.ID.getLength() - dlg.getVibratoHandle().getLength();
                    } else {
                        edited.ID.VibratoHandle = null;
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( selected, ev.InternalID, edited.ID ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".editNoteVibratoProperty; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".editNoteVibratoProperty; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        /// <summary>
        /// 選択されている音符の表情を編集するためのダイアログを起動し、編集を行います。
        /// </summary>
        public void editNoteExpressionProperty()
        {
            SelectedEventEntry item = AppManager.getLastSelectedEvent();
            if ( item == null ) {
                return;
            }

            VsqEvent ev = item.original;
            SynthesizerType type = SynthesizerType.VOCALOID2;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            if ( kind == RendererKind.VOCALOID1 ) {
                type = SynthesizerType.VOCALOID1;
            }
            FormNoteExpressionConfig dlg = null;
            try {
                dlg = new FormNoteExpressionConfig( type, ev.ID.NoteHeadHandle );
                dlg.setPMBendDepth( ev.ID.PMBendDepth );
                dlg.setPMBendLength( ev.ID.PMBendLength );
                dlg.setPMbPortamentoUse( ev.ID.PMbPortamentoUse );
                dlg.setDEMdecGainRate( ev.ID.DEMdecGainRate );
                dlg.setDEMaccent( ev.ID.DEMaccent );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    VsqEvent edited = (VsqEvent)ev.clone();
                    edited.ID.PMBendDepth = dlg.getPMBendDepth();
                    edited.ID.PMBendLength = dlg.getPMBendLength();
                    edited.ID.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                    edited.ID.DEMdecGainRate = dlg.getDEMdecGainRate();
                    edited.ID.DEMaccent = dlg.getDEMaccent();
                    edited.ID.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandEventChangeIDContaints( selected, ev.InternalID, edited.ID ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".editNoteExpressionProperty; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".editNoteExpressionProperty; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        /// <summary>
        /// マウスのスクロールによって受け取ったスクロール幅から、実際に縦スクロールバーに渡す値(候補値)を計算します。
        /// </summary>
        /// <param name="delta"></param>
        /// <returns></returns>
        public int computeScrollValueFromWheelDelta( int delta )
        {
            double new_val = (double)hScroll.getValue() - delta * AppManager.editorConfig.WheelOrder / (5.0 * AppManager.getScaleX());
            if ( new_val < 0.0 ) {
                new_val = 0;
            }
            int max = hScroll.getMaximum() - hScroll.getVisibleAmount();
            int draft = (int)new_val;
            if ( draft > max ) {
                draft = max;
            } else if ( draft < hScroll.getMinimum() ) {
                draft = hScroll.getMinimum();
            }
            return draft;
        }

        #region 音符の編集関連
        public void selectAll()
        {

            AppManager.clearSelectedEvent();
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            int min = int.MaxValue;
            int max = int.MinValue;
            int premeasure = AppManager.getVsqFile().getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventIterator(); itr.hasNext(); ) {
                VsqEvent ve = itr.next();
                if ( premeasure <= ve.Clock ) {
                    add_required.add( ve.InternalID );
                    min = Math.Min( min, ve.Clock );
                    max = Math.Max( max, ve.Clock + ve.ID.getLength() );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required );
            }
            foreach ( CurveType vct in Utility.CURVE_USAGE ) {
                if ( vct.isScalar() || vct.isAttachNote() ) {
                    continue;
                }
                VsqBPList target = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                if ( target == null ) {
                    continue;
                }
                int count = target.size();
                if ( count >= 1 ) {
                    //int[] keys = target.getKeys();
                    int max_key = target.getKeyClock( count - 1 );
                    max = Math.Max( max, target.getValue( max_key ) );
                    for ( int i = 0; i < count; i++ ) {
                        int key = target.getKeyClock( i );
                        if ( premeasure <= key ) {
                            min = Math.Min( min, key );
                            break;
                        }
                    }
                }
            }
            if ( min < premeasure ) {
                min = premeasure;
            }
            if ( min < max ) {
                //int stdx = AppManager.startToDrawX;
                //min = xCoordFromClocks( min ) + stdx;
                //max = xCoordFromClocks( max ) + stdx;
                AppManager.mWholeSelectedInterval = new SelectedRegion( min );
                AppManager.mWholeSelectedInterval.setEnd( max );
                AppManager.setWholeSelectedIntervalEnabled( true );
            }
        }

        public void selectAllEvent()
        {
            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int premeasureclock = vsq.getPreMeasureClocks();
            Vector<Integer> add_required = new Vector<Integer>();
            for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                VsqEvent ev = itr.next();
                if ( ev.ID.type == VsqIDType.Anote && ev.Clock >= premeasureclock ) {
                    add_required.add( ev.InternalID );
                }
            }
            if ( add_required.size() > 0 ) {
                AppManager.addSelectedEventAll( add_required );
            }
            refreshScreen();
        }

        public void deleteEvent()
        {
#if DEBUG
            AppManager.debugWriteLine(
                "FormMain#deleteEvent(); AppManager.mInputTextBox.isEnabled()=" +
                AppManager.mInputTextBox.isEnabled() );
#endif

            if ( AppManager.mInputTextBox.isVisible() ) {
                return;
            }
#if ENABLE_PROPERTY
            if ( AppManager.propertyPanel.isEditing() ) {
                return;
            }
#endif

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<Integer> ids = new Vector<Integer>();
                boolean contains_aicon = false;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry ev = itr.next();
                    ids.add( ev.original.InternalID );
                    if ( ev.original.ID.type == VsqIDType.Aicon ) {
                        contains_aicon = true;
                    }
                }
                VsqCommand run = VsqCommand.generateCommandEventDeleteRange( selected, ids );
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    VsqFileEx work = (VsqFileEx)vsq.clone();
                    work.executeCommand( run );
                    int stdx = AppManager.getStartToDrawX();
                    int start_clock = AppManager.mWholeSelectedInterval.getStart();
                    int end_clock = AppManager.mWholeSelectedInterval.getEnd();
                    Vector<Vector<BPPair>> curves = new Vector<Vector<BPPair>>();
                    Vector<CurveType> types = new Vector<CurveType>();
                    VsqTrack work_vsq_track = work.Track.get( selected );
                    foreach ( CurveType vct in Utility.CURVE_USAGE ) {
                        if ( vct.isScalar() || vct.isAttachNote() ) {
                            continue;
                        }
                        VsqBPList work_curve = work_vsq_track.getCurve( vct.getName() );
                        Vector<BPPair> t = new Vector<BPPair>();
                        t.add( new BPPair( start_clock, work_curve.getValue( start_clock ) ) );
                        t.add( new BPPair( end_clock, work_curve.getValue( end_clock ) ) );
                        curves.add( t );
                        types.add( vct );
                    }
                    Vector<String> strs = new Vector<String>();
                    for ( int i = 0; i < types.size(); i++ ) {
                        strs.add( types.get( i ).getName() );
                    }
                    CadenciiCommand delete_curve = new CadenciiCommand(
                        VsqCommand.generateCommandTrackCurveEditRange( selected, strs, curves ) );
                    work.executeCommand( delete_curve );
                    if ( contains_aicon ) {
                        work.Track.get( selected ).reflectDynamics();
                    }
                    CadenciiCommand run2 = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                    AppManager.register( vsq.executeCommand( run2 ) );
                    setEdited( true );
                } else {
                    CadenciiCommand run2 = null;
                    if ( contains_aicon ) {
                        VsqFileEx work = (VsqFileEx)vsq.clone();
                        work.executeCommand( run );
                        VsqTrack vsq_track_copied = work.Track.get( selected );
                        vsq_track_copied.reflectDynamics();
                        run2 = VsqFileEx.generateCommandTrackReplace( selected,
                                                                      vsq_track_copied,
                                                                      work.AttachedCurves.get( selected - 1 ) );
                    } else {
                        run2 = new CadenciiCommand( run );
                    }
                    AppManager.register( vsq.executeCommand( run2 ) );
                    setEdited( true );
                    AppManager.clearSelectedEvent();
                }
                repaint();
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                Vector<Integer> clocks = new Vector<Integer>();
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    if ( item.getKey() <= 0 ) {
                        String msg = _( "Cannot remove first symbol of track!" );
#if JAVA
                        statusLabel.setText( msg );
#else
                        statusLabel.Text = msg;
#endif
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                        return;
                    }
                    clocks.add( item.getKey() );
                }
                int[] dum = new int[clocks.size()];
                for ( int i = 0; i < dum.Length; i++ ) {
                    dum[i] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTempoRange( PortUtil.convertIntArray( clocks.toArray( new Integer[] { } ) ),
                                                                PortUtil.convertIntArray( clocks.toArray( new Integer[] { } ) ),
                                                                dum ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
                AppManager.clearSelectedTempo();
                repaint();
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
#if DEBUG
                AppManager.debugWriteLine( "    Timesig" );
#endif
                int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                int count = -1;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    count++;
                    barcounts[count] = key;
                    if ( key <= 0 ) {
                        String msg = "Cannot remove first symbol of track!";
#if JAVA
                        statusLabel.setText( _( msg ) );
#else
                        statusLabel.Text = _( msg );
#endif
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                        return;
                    }
                    numerators[count] = -1;
                    denominators[count] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( vsq.executeCommand( run ) );
                setEdited( true );
                AppManager.clearSelectedTimesig();
                repaint();
            }
            if ( AppManager.getSelectedPointIDCount() > 0 ) {
#if DEBUG
                AppManager.debugWriteLine( "    Curve" );
#endif
                String curve;
                if ( !trackSelector.getSelectedCurve().isAttachNote() ) {
                    curve = trackSelector.getSelectedCurve().getName();
                    VsqBPList src = vsq_track.getCurve( curve );
                    VsqBPList list = (VsqBPList)src.clone();
                    Vector<Integer> remove_clock_queue = new Vector<Integer>();
                    int count = list.size();
                    for ( int i = 0; i < count; i++ ) {
                        VsqBPPair item = list.getElementB( i );
                        if ( AppManager.isSelectedPointContains( item.id ) ) {
                            remove_clock_queue.add( list.getKeyClock( i ) );
                        }
                    }
                    count = remove_clock_queue.size();
                    for ( int i = 0; i < count; i++ ) {
                        list.remove( remove_clock_queue.get( i ) );
                    }
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandTrackCurveReplace( selected,
                                                                     trackSelector.getSelectedCurve().getName(),
                                                                     list ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                } else {
                    //todo: FormMain+DeleteEvent; VibratoDepth, VibratoRateの場合
                }
                AppManager.clearSelectedPoint();
                refreshScreen();
            }
        }

        public void pasteEvent()
        {
            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            clock = doQuantize( clock, unit );

            VsqCommand add_event = null; // VsqEventを追加するコマンド

            ClipboardEntry ce = AppManager.getCopiedItems();
            int copy_started_clock = ce.copyStartedClock;
            Vector<VsqEvent> copied_events = ce.events;
#if DEBUG
            sout.println( "FormMain#pasteEvent; copy_started_clock=" + copy_started_clock );
            sout.println( "FormMain#pasteEvent; copied_events.size()=" + copied_events.size() );
#endif
            if ( copied_events.size() != 0 ) {
                // VsqEventのペーストを行うコマンドを発行
                int dclock = clock - copy_started_clock;
                if ( clock >= AppManager.getVsqFile().getPreMeasureClocks() ) {
                    Vector<VsqEvent> paste = new Vector<VsqEvent>();
                    int count = copied_events.size();
                    for ( int i = 0; i < count; i++ ) {
                        VsqEvent item = (VsqEvent)copied_events.get( i ).clone();
                        item.Clock = copied_events.get( i ).Clock + dclock;
                        paste.add( item );
                    }
                    add_event = VsqCommand.generateCommandEventAddRange(
                        AppManager.getSelected(), paste.toArray( new VsqEvent[] { } ) );
                }
            }
            Vector<TempoTableEntry> copied_tempo = ce.tempo;
            if ( copied_tempo.size() != 0 ) {
                // テンポ変更の貼付けを実行
                int dclock = clock - copy_started_clock;
                int count = copied_tempo.size();
                int[] clocks = new int[count];
                int[] tempos = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TempoTableEntry item = copied_tempo.get( i );
                    clocks[i] = item.Clock + dclock;
                    tempos[i] = item.Tempo;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, tempos ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }
            Vector<TimeSigTableEntry> copied_timesig = ce.timesig;
            if ( copied_timesig.size() > 0 ) {
                // 拍子変更の貼付けを実行
                int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                int min_barcount = copied_timesig.get( 0 ).BarCount;
                for ( Iterator<TimeSigTableEntry> itr = copied_timesig.iterator(); itr.hasNext(); ) {
                    TimeSigTableEntry tste = itr.next();
                    min_barcount = Math.Min( min_barcount, tste.BarCount );
                }
                int dbarcount = bar_count - min_barcount;
                int count = copied_timesig.size();
                int[] barcounts = new int[count];
                int[] numerators = new int[count];
                int[] denominators = new int[count];
                for ( int i = 0; i < count; i++ ) {
                    TimeSigTableEntry item = copied_timesig.get( i );
                    barcounts[i] = item.BarCount + dbarcount;
                    numerators[i] = item.Numerator;
                    denominators[i] = item.Denominator;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange(
                        barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
                return;
            }

            // BPPairの貼付け
            VsqCommand edit_bpcurve = null; // BPListを変更するコマンド
            TreeMap<CurveType, VsqBPList> copied_curve = ce.points;
#if DEBUG
            sout.println( "FormMain#pasteEvent; copied_curve.size()=" + copied_curve.size() );
#endif
            if ( copied_curve.size() > 0 ) {
                int dclock = clock - copy_started_clock;

                TreeMap<String, VsqBPList> work = new TreeMap<String, VsqBPList>();
                for ( Iterator<CurveType> itr = copied_curve.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    VsqBPList list = copied_curve.get( curve );
#if DEBUG
                    AppManager.debugWriteLine( "FormMain#pasteEvent; curve=" + curve );
#endif
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    if ( list.size() <= 0 ) {
                        continue;
                    }
                    if ( curve.isAttachNote() ) {
                        //todo: FormMain+PasteEvent; VibratoRate, VibratoDepthカーブのペースト処理
                    } else {
                        VsqBPList target = (VsqBPList)AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() ).clone();
                        int count = list.size();
#if DEBUG
                        sout.println( "FormMain#pasteEvent; list.getCount()=" + count );
#endif
                        int min = list.getKeyClock( 0 ) + dclock;
                        int max = list.getKeyClock( count - 1 ) + dclock;
                        int valueAtEnd = target.getValue( max );
                        for ( int i = 0; i < target.size(); i++ ) {
                            int cl = target.getKeyClock( i );
                            if ( min <= cl && cl <= max ) {
                                target.removeElementAt( i );
                                i--;
                            }
                        }
                        int lastClock = min;
                        for ( int i = 0; i < count - 1; i++ ) {
                            lastClock = list.getKeyClock( i ) + dclock;
                            target.add( lastClock, list.getElementA( i ) );
                        }
                        // 最後のやつ
                        if ( lastClock < max - 1 ) {
                            target.add( max - 1, list.getElementA( count - 1 ) );
                        }
                        target.add( max, valueAtEnd );
                        if ( copied_curve.size() == 1 ) {
                            work.put( trackSelector.getSelectedCurve().getName(), target );
                        } else {
                            work.put( curve.getName(), target );
                        }
                    }
                }
#if DEBUG
                sout.println( "FormMain#pasteEvent; work.size()=" + work.size() );
#endif
                if ( work.size() > 0 ) {
                    String[] curves = new String[work.size()];
                    VsqBPList[] bplists = new VsqBPList[work.size()];
                    int count = -1;
                    for ( Iterator<String> itr = work.keySet().iterator(); itr.hasNext(); ) {
                        String s = itr.next();
                        count++;
                        curves[count] = s;
                        bplists[count] = work.get( s );
                    }
                    edit_bpcurve = VsqCommand.generateCommandTrackCurveReplaceRange( AppManager.getSelected(), curves, bplists );
                }
                AppManager.clearSelectedPoint();
            }

            // ベジエ曲線の貼付け
            CadenciiCommand edit_bezier = null;
            TreeMap<CurveType, Vector<BezierChain>> copied_bezier = ce.beziers;
#if DEBUG
            sout.println( "FormMain#pasteEvent; copied_bezier.size()=" + copied_bezier.size() );
#endif
            if ( copied_bezier.size() > 0 ) {
                int dclock = clock - copy_started_clock;
                BezierCurves attached_curve = (BezierCurves)AppManager.getVsqFile().AttachedCurves.get( AppManager.getSelected() - 1 ).clone();
                TreeMap<CurveType, Vector<BezierChain>> command_arg = new TreeMap<CurveType, Vector<BezierChain>>();
                for ( Iterator<CurveType> itr = copied_bezier.keySet().iterator(); itr.hasNext(); ) {
                    CurveType curve = itr.next();
                    if ( curve.isScalar() ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr2 = copied_bezier.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        BezierChain bc_copy = (BezierChain)bc.clone();
                        for ( Iterator<BezierPoint> itr3 = bc_copy.points.iterator(); itr3.hasNext(); ) {
                            BezierPoint bp = itr3.next();
                            bp.setBase( new PointD( bp.getBase().getX() + dclock, bp.getBase().getY() ) );
                        }
                        attached_curve.mergeBezierChain( curve, bc_copy );
                    }
                    Vector<BezierChain> arg = new Vector<BezierChain>();
                    for ( Iterator<BezierChain> itr2 = attached_curve.get( curve ).iterator(); itr2.hasNext(); ) {
                        BezierChain bc = itr2.next();
                        arg.add( bc );
                    }
                    command_arg.put( curve, arg );
                }
                edit_bezier = VsqFileEx.generateCommandReplaceAttachedCurveRange( AppManager.getSelected(), command_arg );
            }

            int commands = 0;
            commands += (add_event != null) ? 1 : 0;
            commands += (edit_bpcurve != null) ? 1 : 0;
            commands += (edit_bezier != null) ? 1 : 0;

#if DEBUG
            AppManager.debugWriteLine( "FormMain#pasteEvent; commands=" + commands );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (add_event != null)=" + (add_event != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bpcurve != null)=" + (edit_bpcurve != null) );
            AppManager.debugWriteLine( "FormMain#pasteEvent; (edit_bezier != null)=" + (edit_bezier != null) );
#endif
            if ( commands == 1 ) {
                if ( add_event != null ) {
                    CadenciiCommand run = new CadenciiCommand( add_event );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bpcurve != null ) {
                    CadenciiCommand run = new CadenciiCommand( edit_bpcurve );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                } else if ( edit_bezier != null ) {
                    AppManager.register( AppManager.getVsqFile().executeCommand( edit_bezier ) );
                }
                AppManager.getVsqFile().updateTotalClocks();
                setEdited( true );
                refreshScreen();
            } else if ( commands > 1 ) {
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone();
                if ( add_event != null ) {
                    work.executeCommand( add_event );
                }
                if ( edit_bezier != null ) {
                    work.executeCommand( edit_bezier );
                }
                if ( edit_bpcurve != null ) {
                    // edit_bpcurveのVsqCommandTypeはTrackEditCurveRangeしかありえない
                    work.executeCommand( edit_bpcurve );
                }
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.getVsqFile().updateTotalClocks();
                setEdited( true );
                refreshScreen();
            }
        }

        /// <summary>
        /// アイテムのコピーを行います
        /// </summary>
        public void copyEvent()
        {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#copyEvent" );
#endif
            int min = int.MaxValue; // コピーされたアイテムの中で、最小の開始クロック

            if ( AppManager.isWholeSelectedIntervalEnabled() ) {
#if DEBUG
                sout.println( "FormMain#copyEvent; selected with CTRL key" );
#endif
                int stdx = AppManager.getStartToDrawX();
                int start_clock = AppManager.mWholeSelectedInterval.getStart();
                int end_clock = AppManager.mWholeSelectedInterval.getEnd();
                ClipboardEntry ce = new ClipboardEntry();
                ce.copyStartedClock = start_clock;
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType vct = Utility.CURVE_USAGE[i];
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( vct.getName() );
                    if ( list == null ) {
                        continue;
                    }
                    Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                    copyCurveCor( AppManager.getSelected(),
                                  vct,
                                  start_clock,
                                  end_clock,
                                  tmp_bezier );
                    VsqBPList tmp_bplist = new VsqBPList( list.getName(), list.getDefault(), list.getMinimum(), list.getMaximum() );
                    int c = list.size();
                    for ( int j = 0; j < c; j++ ) {
                        int clock = list.getKeyClock( j );
                        if ( start_clock <= clock && clock <= end_clock ) {
                            tmp_bplist.add( clock, list.getElement( j ) );
                        } else if ( end_clock < clock ) {
                            break;
                        }
                    }
                    ce.beziers.put( vct, tmp_bezier );
                    ce.points.put( vct, tmp_bplist );
                }

                if ( AppManager.getSelectedEventCount() > 0 ) {
                    Vector<VsqEvent> list = new Vector<VsqEvent>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        if ( item.original.ID.type == VsqIDType.Anote ) {
                            min = Math.Min( item.original.Clock, min );
                            list.add( (VsqEvent)item.original.clone() );
                        }
                    }
                    ce.events = list;
                }
                AppManager.setClipboard( ce );
            } else if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<VsqEvent> list = new Vector<VsqEvent>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    min = Math.Min( item.original.Clock, min );
                    list.add( (VsqEvent)item.original.clone() );
                }
                AppManager.setCopiedEvent( list, min );
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                Vector<TempoTableEntry> list = new Vector<TempoTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTempoEntry value = item.getValue();
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TempoTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTempo( list, min );
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                Vector<TimeSigTableEntry> list = new Vector<TimeSigTableEntry>();
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    min = Math.Min( value.original.Clock, min );
                    list.add( (TimeSigTableEntry)value.original.clone() );
                }
                AppManager.setCopiedTimesig( list, min );
            } else if ( AppManager.getSelectedPointIDCount() > 0 ) {
                ClipboardEntry ce = new ClipboardEntry();
                ce.points = new TreeMap<CurveType, VsqBPList>();
                ce.beziers = new TreeMap<CurveType, Vector<BezierChain>>();

                ValuePair<Integer, Integer> t = trackSelector.getSelectedRegion();
                int start = t.getKey();
                int end = t.getValue();
                ce.copyStartedClock = start;
                Vector<BezierChain> tmp_bezier = new Vector<BezierChain>();
                copyCurveCor( AppManager.getSelected(),
                              trackSelector.getSelectedCurve(),
                              start,
                              end,
                              tmp_bezier );
                if ( tmp_bezier.size() > 0 ) {
                    // ベジエ曲線が1個以上コピーされた場合
                    // 範囲内のデータ点を追加する
                    ce.beziers.put( trackSelector.getSelectedCurve(), tmp_bezier );
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( list.getName(), list.getDefault(), list.getMinimum(), list.getMaximum() );
                        int c = list.size();
                        for ( int i = 0; i < c; i++ ) {
                            int clock = list.getKeyClock( i );
                            if ( start <= clock && clock <= end ) {
                                tmp_bplist.add( clock, list.getElement( i ) );
                            } else if ( end < clock ) {
                                break;
                            }
                        }
                        ce.points.put( curve, tmp_bplist );
                    }
                } else {
                    // ベジエ曲線がコピーされなかった場合
                    // AppManager.selectedPointIDIteratorの中身のみを選択
                    CurveType curve = trackSelector.getSelectedCurve();
                    VsqBPList list = AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getCurve( curve.getName() );
                    if ( list != null ) {
                        VsqBPList tmp_bplist = new VsqBPList( curve.getName(), curve.getDefault(), curve.getMinimum(), curve.getMaximum() );
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = itr.next();
                            VsqBPPairSearchContext cxt = list.findElement( id );
                            if ( cxt.index >= 0 ) {
                                tmp_bplist.add( cxt.clock, cxt.point.value );
                            }
                        }
                        if ( tmp_bplist.size() > 0 ) {
                            ce.copyStartedClock = tmp_bplist.getKeyClock( 0 );
                            ce.points.put( curve, tmp_bplist );
                        }
                    }
                }
                AppManager.setClipboard( ce );
            }
        }

        public void cutEvent()
        {
            // まずコピー
            copyEvent();

            int track = AppManager.getSelected();

            // 選択されたノートイベントがあれば、まず、削除を行うコマンドを発行
            VsqCommand delete_event = null;
            boolean other_command_executed = false;
            if ( AppManager.getSelectedEventCount() > 0 ) {
                Vector<Integer> ids = new Vector<Integer>();
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    ids.add( item.original.InternalID );
                }
                delete_event = VsqCommand.generateCommandEventDeleteRange( AppManager.getSelected(), ids );
            }

            // Ctrlキーを押しながらドラッグしたか、そうでないかで分岐
            if ( AppManager.isWholeSelectedIntervalEnabled() || AppManager.getSelectedPointIDCount() > 0 ) {
                int stdx = AppManager.getStartToDrawX();
                int start_clock, end_clock;
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    start_clock = AppManager.mWholeSelectedInterval.getStart();
                    end_clock = AppManager.mWholeSelectedInterval.getEnd();
                } else {
                    start_clock = trackSelector.getSelectedRegion().getKey();
                    end_clock = trackSelector.getSelectedRegion().getValue();
                }

                // クローンを作成
                VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone();
                if ( delete_event != null ) {
                    // 選択されたノートイベントがあれば、クローンに対して削除を実行
                    work.executeCommand( delete_event );
                }

                // BPListに削除処理を施す
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType curve = Utility.CURVE_USAGE[i];
                    VsqBPList list = work.Track.get( track ).getCurve( curve.getName() );
                    if ( list == null ) {
                        continue;
                    }
                    int c = list.size();
                    Vector<Long> delete = new Vector<Long>();
                    if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                        // 一括選択モード
                        for ( int j = 0; j < c; j++ ) {
                            int clock = list.getKeyClock( j );
                            if ( start_clock <= clock && clock <= end_clock ) {
                                delete.add( list.getElementB( j ).id );
                            } else if ( end_clock < clock ) {
                                break;
                            }
                        }
                    } else {
                        // 普通の範囲選択
                        for ( Iterator<Long> itr = AppManager.getSelectedPointIDIterator(); itr.hasNext(); ) {
                            long id = (Long)itr.next();
                            delete.add( id );
                        }
                    }
                    VsqCommand tmp = VsqCommand.generateCommandTrackCurveEdit2( track, curve.getName(), delete, new TreeMap<Integer, VsqBPPair>() );
                    work.executeCommand( tmp );
                }

                // ベジエ曲線に削除処理を施す
                Vector<CurveType> target_curve = new Vector<CurveType>();
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    // ctrlによる全選択モード
                    for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                        CurveType ct = Utility.CURVE_USAGE[i];
                        if ( ct.isScalar() || ct.isAttachNote() ) {
                            continue;
                        }
                        target_curve.add( ct );
                    }
                } else {
                    // 普通の選択モード
                    target_curve.add( trackSelector.getSelectedCurve() );
                }
                work.AttachedCurves.get( AppManager.getSelected() - 1 ).deleteBeziers( target_curve, start_clock, end_clock );

                // コマンドを発行し、実行
                CadenciiCommand run = VsqFileEx.generateCommandReplace( work );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                this.setEdited( true );

                other_command_executed = true;
            } else if ( AppManager.getSelectedTempoCount() > 0 ) {
                // テンポ変更のカット
                int count = -1;
                int[] dum = new int[AppManager.getSelectedTempoCount()];
                int[] clocks = new int[AppManager.getSelectedTempoCount()];
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTempoEntry value = item.getValue();
                    count++;
                    dum[count] = -1;
                    clocks[count] = value.original.Clock;
                }
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, clocks, dum ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            } else if ( AppManager.getSelectedTimesigCount() > 0 ) {
                // 拍子変更のカット
                int[] barcounts = new int[AppManager.getSelectedTimesigCount()];
                int[] numerators = new int[AppManager.getSelectedTimesigCount()];
                int[] denominators = new int[AppManager.getSelectedTimesigCount()];
                int count = -1;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int key = item.getKey();
                    SelectedTimesigEntry value = item.getValue();
                    count++;
                    barcounts[count] = value.original.BarCount;
                    numerators[count] = -1;
                    denominators[count] = -1;
                }
                CadenciiCommand run = new CadenciiCommand(
                    VsqCommand.generateCommandUpdateTimesigRange( barcounts, barcounts, numerators, denominators ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                other_command_executed = true;
            }

            // 冒頭で作成した音符イベント削除以外に、コマンドが実行されなかった場合
            if ( delete_event != null && !other_command_executed ) {
                CadenciiCommand run = new CadenciiCommand( delete_event );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            }

            refreshScreen();
        }

        public void copyCurveCor(
            int track,
            CurveType curve_type,
            int start,
            int end,
            Vector<BezierChain> copied_chain
        )
        {
            for ( Iterator<BezierChain> itr = AppManager.getVsqFile().AttachedCurves.get( track - 1 ).get( curve_type ).iterator(); itr.hasNext(); ) {
                BezierChain bc = itr.next();
                int len = bc.points.size();
                if ( len < 2 ) {
                    continue;
                }
                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                int chain_end = (int)bc.points.get( len - 1 ).getBase().getX();
                BezierChain add = null;
                if ( start < chain_start && chain_start < end && end < chain_end ) {
                    // (1) chain_start ~ end をコピー
                    try {
                        add = bc.extractPartialBezier( chain_start, end );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".copyCurveCor; ex=" + ex + "\n" );
                        add = null;
                    }
                } else if ( chain_start <= start && end <= chain_end ) {
                    // (2) start ~ endをコピー
                    try {
                        add = bc.extractPartialBezier( start, end );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".copyCurveCor; ex=" + ex + "\n" );
                        add = null;
                    }
                } else if ( chain_start < start && start < chain_end && chain_end <= end ) {
                    // (3) start ~ chain_endをコピー
                    try {
                        add = bc.extractPartialBezier( start, chain_end );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".copyCurveCor; ex=" + ex + "\n" );
                        add = null;
                    }
                } else if ( start <= chain_start && chain_end <= end ) {
                    // (4) 全部コピーでOK
                    add = (BezierChain)bc.clone();
                }
                if ( add != null ) {
                    copied_chain.add( add );
                }
            }
        }
        #endregion

        #region トラックの編集関連
        /// <summary>
        /// トラック全体のコピーを行います。
        /// </summary>
        public void copyTrackCore()
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack track = (VsqTrack)vsq.Track.get( selected ).clone();
            track.setName( track.getName() + " (1)" );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( track,
                                                                     vsq.Mixer.Slave.get( selected - 1 ),
                                                                     vsq.Track.size(),
                                                                     vsq.AttachedCurves.get( selected - 1 ) ); ;
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
            AppManager.mMixerWindow.updateStatus();
            refreshScreen();
        }

        /// <summary>
        /// トラックの名前変更を行います。
        /// </summary>
        public void changeTrackNameCore()
        {
            InputBox ib = null;
            try{
                int selected = AppManager.getSelected();
                VsqFileEx vsq = AppManager.getVsqFile();
                ib = new InputBox( _( "Input new name of track" ) );
                ib.setResult( vsq.Track.get( selected ).getName() );
                ib.setLocation( getFormPreferedLocation( ib ) );
                BDialogResult dr = AppManager.showModalDialog( ib, this );
                if( dr == BDialogResult.OK ){
                    String ret = ib.getResult();
                    CadenciiCommand run = new CadenciiCommand(
                        VsqCommand.generateCommandTrackChangeName( selected, ret ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                    refreshScreen();
                }
            }catch( Exception ex ){
            }finally{
                if( ib != null ){
                    ib.close();
                }
            }

/*            if ( mTextBoxTrackName != null ) {
#if !JAVA
                if ( !mTextBoxTrackName.IsDisposed ) {
                    mTextBoxTrackName.Dispose();
                }
#endif
                mTextBoxTrackName = null;
            }
#if JAVA
            mTextBoxTrackName = new LyricTextBox( this );
#else
            mTextBoxTrackName = new LyricTextBox();
#endif
            mTextBoxTrackName.setVisible( false );
            int selector_width = trackSelector.getSelectorWidth();
            int x = AppManager.keyWidth + (AppManager.getSelected() - 1) * selector_width;
            mTextBoxTrackName.setLocation( x, trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB + 1 );
            mTextBoxTrackName.setText( AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getName() );
#if JAVA
            mTextBoxTrackName.keyUpEvent.add( new BKeyEventHandler( this, "mTextBoxTrackName_KeyUp" ) );
#else
            mTextBoxTrackName.BorderStyle = System.Windows.Forms.BorderStyle.None;
            mTextBoxTrackName.KeyUp += new System.Windows.Forms.KeyEventHandler( mTextBoxTrackName_KeyUp );
            mTextBoxTrackName.Parent = trackSelector;
#endif
            mTextBoxTrackName.setSize( selector_width, TrackSelector.OFFSET_TRACK_TAB );
            mTextBoxTrackName.setVisible( true );
            mTextBoxTrackName.requestFocus();
            mTextBoxTrackName.selectAll();*/
        }

        /// <summary>
        /// トラックの削除を行います。
        /// </summary>
        public void deleteTrackCore()
        {
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( AppManager.showMessageBox(
                    PortUtil.formatMessage( _( "Do you wish to remove track? {0} : '{1}'" ), selected, vsq.Track.get( selected ).getName() ),
                    _APP_NAME,
                    org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE ) == BDialogResult.YES ) {
                CadenciiCommand run = VsqFileEx.generateCommandDeleteTrack( selected );
                if ( selected >= 2 ) {
                    AppManager.setSelected( selected - 1 );
                }
                AppManager.register( vsq.executeCommand( run ) );
                updateDrawObjectList();
                setEdited( true );
                AppManager.mMixerWindow.updateStatus();
                refreshScreen();
            }
        }

        /// <summary>
        /// トラックの追加を行います。
        /// </summary>
        public void addTrackCore()
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            int i = vsq.Track.size();
            String name = "Voice" + i;
            String singer = AppManager.editorConfig.DefaultSingerName;
            VsqTrack vsq_track = new VsqTrack( name, singer );

            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );

            vsq_track.changeRenderer( renderer, singers );
            CadenciiCommand run = VsqFileEx.generateCommandAddTrack( vsq_track,
                                                                     new VsqMixerEntry( 0, 0, 0, 0 ),
                                                                     i,
                                                                     new BezierCurves() );
            AppManager.register( vsq.executeCommand( run ) );
            updateDrawObjectList();
            setEdited( true );
            AppManager.setSelected( i );
            AppManager.mMixerWindow.updateStatus();
            refreshScreen();
        }
        #endregion

        /// <summary>
        /// length, positionの各Quantizeモードに応じて、
        /// 関連する全てのメニュー・コンテキストメニューの表示状態を更新します。
        /// </summary>
        public void applyQuantizeMode()
        {
            cMenuPianoQuantize04.setSelected( false );
            cMenuPianoQuantize08.setSelected( false );
            cMenuPianoQuantize16.setSelected( false );
            cMenuPianoQuantize32.setSelected( false );
            cMenuPianoQuantize64.setSelected( false );
            cMenuPianoQuantize128.setSelected( false );
            cMenuPianoQuantizeOff.setSelected( false );

#if ENABLE_STRIP_DROPDOWN
            stripDDBtnQuantize04.Checked = false;
            stripDDBtnQuantize08.Checked = false;
            stripDDBtnQuantize16.Checked = false;
            stripDDBtnQuantize32.Checked = false;
            stripDDBtnQuantize64.Checked = false;
            stripDDBtnQuantize128.Checked = false;
            stripDDBtnQuantizeOff.Checked = false;
#endif

            menuSettingPositionQuantize04.setSelected( false );
            menuSettingPositionQuantize08.setSelected( false );
            menuSettingPositionQuantize16.setSelected( false );
            menuSettingPositionQuantize32.setSelected( false );
            menuSettingPositionQuantize64.setSelected( false );
            menuSettingPositionQuantize128.setSelected( false );
            menuSettingPositionQuantizeOff.setSelected( false );

#if !JAVA
            QuantizeMode qm = AppManager.editorConfig.getPositionQuantize();
            boolean triplet = AppManager.editorConfig.isPositionQuantizeTriplet();
            stripDDBtnQuantizeParent.Text =
                "QUANTIZE " + QuantizeModeUtil.getString( qm ) +
                ((qm != QuantizeMode.off && triplet) ? " [3]" : "");
#endif
            if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p4 ) {
                cMenuPianoQuantize04.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize04.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note004.png";
#endif
                menuSettingPositionQuantize04.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p8 ) {
                cMenuPianoQuantize08.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize08.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note008.png";
#endif
                menuSettingPositionQuantize08.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p16 ) {
                cMenuPianoQuantize16.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize16.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note016.png";
#endif
                menuSettingPositionQuantize16.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p32 ) {
                cMenuPianoQuantize32.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize32.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note032.png";
#endif
                menuSettingPositionQuantize32.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p64 ) {
                cMenuPianoQuantize64.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize64.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note064.png";
#endif
                menuSettingPositionQuantize64.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.p128 ) {
                cMenuPianoQuantize128.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantize128.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "note128.png";
#endif
                menuSettingPositionQuantize128.setSelected( true );
            } else if ( AppManager.editorConfig.getPositionQuantize() == QuantizeMode.off ) {
                cMenuPianoQuantizeOff.setSelected( true );
#if ENABLE_STRIP_DROPDOWN
                stripDDBtnQuantizeOff.Checked = true;
#endif
#if !JAVA
                stripDDBtnQuantizeParent.ImageKey = "notenull.png";
#endif
                menuSettingPositionQuantizeOff.setSelected( true );
            }
            cMenuPianoQuantizeTriplet.setSelected( AppManager.editorConfig.isPositionQuantizeTriplet() );
#if ENABLE_STRIP_DROPDOWN
            stripDDBtnQuantizeTriplet.Checked = AppManager.editorConfig.isPositionQuantizeTriplet();
#endif
            menuSettingPositionQuantizeTriplet.setSelected( AppManager.editorConfig.isPositionQuantizeTriplet() );
        }

        /// <summary>
        /// 現在選択されている編集ツールに応じて、メニューのチェック状態を更新します
        /// </summary>
        public void applySelectedTool()
        {
            EditTool tool = AppManager.getSelectedTool();

#if JAVA
            int count = toolStripTool.getComponentCount();
#else
            int count = toolBarTool.Buttons.Count;
#endif
            for ( int i = 0; i < count; i++ ) {
#if JAVA
                Object tsi = toolStripTool.getComponentAtIndex( i );
#else
                Object tsi = toolBarTool.Buttons[i];
#endif
#if JAVA
                if( tsi instanceof PaletteToolButton ){
                    BToggleButton tsb = (PaletteToolButton)tsi;
                    boolean sel = false;
#if ENABLE_SCRIPT
                    String id = tsb.getPaletteToolID();
                    if( id != null ){
                        if( tool == EditTool.PALETTE_TOOL ){
                            sel = str.compare( AppManager.mSelectedPaletteTool, id );
                        }
                    }
#endif // ENABLE_SCRIPT
                    tsb.setSelected( sel );
                }
#else // JAVA
                if ( tsi is System.Windows.Forms.ToolBarButton ) {
                    System.Windows.Forms.ToolBarButton tsb = (System.Windows.Forms.ToolBarButton)tsi;
                    Object tag = tsb.Tag;
                    if ( tsb.Style == System.Windows.Forms.ToolBarButtonStyle.ToggleButton && tag != null && tag is String ) {
#if ENABLE_SCRIPT
                        if ( tool == EditTool.PALETTE_TOOL ) {
                            String id = (String)tag;
                            tsb.Pushed = str.compare( AppManager.mSelectedPaletteTool, id );
                        } else
#endif // ENABLE_SCRIPT
 {
                            tsb.Pushed = false;
                        }
                    }
                }
#endif // JAVA
            }
            MenuElement[] items = cMenuTrackSelectorPaletteTool.getSubElements();
            foreach ( MenuElement tsi in items ) {
                if ( tsi is PaletteToolMenuItem ) {
                    PaletteToolMenuItem tsmi = (PaletteToolMenuItem)tsi;
                    String id = tsmi.getPaletteToolID();
                    boolean sel = false;
#if ENABLE_SCRIPT
                    if ( tool == EditTool.PALETTE_TOOL ) {
                        sel = str.compare( AppManager.mSelectedPaletteTool, id );
                    }
#endif
                    tsmi.setSelected( sel );
                }
            }

            items = cMenuPianoPaletteTool.getSubElements();
            foreach ( MenuElement tsi in items ) {
                if ( tsi is PaletteToolMenuItem ) {
                    PaletteToolMenuItem tsmi = (PaletteToolMenuItem)tsi;
                    String id = tsmi.getPaletteToolID();
                    boolean sel = false;
#if ENABLE_SCRIPT
                    if ( tool == EditTool.PALETTE_TOOL ) {
                        sel = str.compare( AppManager.mSelectedPaletteTool, id );
                    }
#endif
                    tsmi.setSelected( sel );
                }
            }

            EditTool selected_tool = AppManager.getSelectedTool();
            cMenuPianoPointer.setSelected( (selected_tool == EditTool.ARROW) );
            cMenuPianoPencil.setSelected( (selected_tool == EditTool.PENCIL) );
            cMenuPianoEraser.setSelected( (selected_tool == EditTool.ERASER) );

            cMenuTrackSelectorPointer.setSelected( (selected_tool == EditTool.ARROW) );
            cMenuTrackSelectorPencil.setSelected( (selected_tool == EditTool.PENCIL) );
            cMenuTrackSelectorLine.setSelected( (selected_tool == EditTool.LINE) );
            cMenuTrackSelectorEraser.setSelected( (selected_tool == EditTool.ERASER) );

#if JAVA
            stripBtnPointer.setSelected( (selected_tool == EditTool.ARROW) );
            stripBtnPencil.setSelected( (selected_tool == EditTool.PENCIL) );
            stripBtnLine.setSelected( (selected_tool == EditTool.LINE) );
            stripBtnEraser.setSelected( (selected_tool == EditTool.ERASER) );
#else
            stripBtnPointer.Pushed = (selected_tool == EditTool.ARROW);
            stripBtnPencil.Pushed = (selected_tool == EditTool.PENCIL);
            stripBtnLine.Pushed = (selected_tool == EditTool.LINE);
            stripBtnEraser.Pushed = (selected_tool == EditTool.ERASER);
#endif


            cMenuPianoCurve.setSelected( AppManager.isCurveMode() );
            cMenuTrackSelectorCurve.setSelected( AppManager.isCurveMode() );
#if JAVA
            stripBtnCurve.setSelected( AppManager.isCurveMode() );
#else
            stripBtnCurve.Pushed = AppManager.isCurveMode();
#endif
        }

        /// <summary>
        /// 描画すべきオブジェクトのリスト，AppManager.drawObjectsを更新します
        /// </summary>
        public void updateDrawObjectList()
        {
            // AppManager.m_draw_objects
            if ( AppManager.mDrawObjects == null ) {
                AppManager.mDrawObjects = new Vector<Vector<DrawObject>>();
            }
            lock ( AppManager.mDrawObjects ) {
                if ( AppManager.getVsqFile() == null ) {
                    return;
                }
                for ( int i = 0; i < AppManager.mDrawStartIndex.Length; i++ ) {
                    AppManager.mDrawStartIndex[i] = 0;
                }
                if ( AppManager.mDrawObjects != null ) {
                    for ( Iterator<Vector<DrawObject>> itr = AppManager.mDrawObjects.iterator(); itr.hasNext(); ) {
                        Vector<DrawObject> list = itr.next();
                        list.clear();
                    }
                    AppManager.mDrawObjects.clear();
                }

                int xoffset = AppManager.keyOffset;// 6 + AppManager.keyWidth;
                int yoffset = (int)(127 * (int)(100 * AppManager.getScaleY()));
                float scalex = AppManager.getScaleX();
                Font SMALL_FONT = null;
                try {
                    SMALL_FONT = new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
                    int track_height = (int)(100 * AppManager.getScaleY());
                    VsqFileEx vsq = AppManager.getVsqFile();
                    int track_count = vsq.Track.size();
                    Polygon env = new Polygon( new int[7], new int[7], 7 );
                    ByRef<Integer> overlap_x = new ByRef<Integer>( 0 );
                    for ( int track = 1; track < track_count; track++ ) {
                        VsqTrack vsq_track = vsq.Track.get( track );
                        Vector<DrawObject> tmp = new Vector<DrawObject>();
                        RendererKind kind = VsqFileEx.getTrackRendererKind( vsq_track );
                        AppManager.mDrawIsUtau[track - 1] = kind == RendererKind.UTAU;

                        // 音符イベント
                        Iterator<VsqEvent> itr_note = vsq_track.getNoteEventIterator();
                        VsqEvent item_prev = null;
                        VsqEvent item = null;
                        VsqEvent item_next = itr_note.hasNext() ? itr_note.next() : null;
                        while ( item_prev != null || item != null || item_next != null ) {
                            item_prev = item;
                            item = item_next;
                            if ( itr_note.hasNext() ) {
                                item_next = itr_note.next();
                            } else {
                                item_next = null;
                            }
                            if ( item == null ) {
                                continue;
                            }
                            if ( item.ID.LyricHandle == null ) {
                                continue;
                            }
                            int timesig = item.Clock;
                            int length = item.ID.getLength();
                            int note = item.ID.Note;
                            int x = (int)(timesig * scalex + xoffset);
                            int y = -note * track_height + yoffset;
                            int lyric_width = (int)(length * scalex);
                            String lyric_jp = item.ID.LyricHandle.L0.Phrase;
                            String lyric_en = item.ID.LyricHandle.L0.getPhoneticSymbol();
                            String title = Utility.trimString( lyric_jp + " [" + lyric_en + "]", SMALL_FONT, lyric_width );
                            int accent = item.ID.DEMaccent;
                            int px_vibrato_start = x + lyric_width;
                            int px_vibrato_end = x;
                            int px_vibrato_delay = lyric_width * 2;
                            int vib_delay = length;
                            if ( item.ID.VibratoHandle != null ) {
                                vib_delay = item.ID.VibratoDelay;
                                double rate = (double)vib_delay / (double)length;
                                px_vibrato_delay = _PX_ACCENT_HEADER + (int)((lyric_width - _PX_ACCENT_HEADER) * rate);
                            }
                            VibratoBPList rate_bp = null;
                            VibratoBPList depth_bp = null;
                            int rate_start = 0;
                            int depth_start = 0;
                            if ( item.ID.VibratoHandle != null ) {
                                rate_bp = item.ID.VibratoHandle.getRateBP();
                                depth_bp = item.ID.VibratoHandle.getDepthBP();
                                rate_start = item.ID.VibratoHandle.getStartRate();
                                depth_start = item.ID.VibratoHandle.getStartDepth();
                            }

                            // analyzed/のSTFが引き当てられるかどうか
                            // UTAUのWAVが引き当てられるかどうか
                            boolean is_valid_for_utau = false;
                            VsqEvent singer_at_clock = vsq_track.getSingerEventAt( timesig );
                            int program = singer_at_clock.ID.IconHandle.Program;
                            if ( 0 <= program && program < AppManager.editorConfig.UtauSingers.size() ) {
                                SingerConfig sc = AppManager.editorConfig.UtauSingers.get( program );
                                // 通常のUTAU音源
                                if ( AppManager.mUtauVoiceDB.containsKey( sc.VOICEIDSTR ) ) {
                                    UtauVoiceDB db = AppManager.mUtauVoiceDB.get( sc.VOICEIDSTR );
                                    OtoArgs oa = db.attachFileNameFromLyric( lyric_jp );
                                    if ( oa.fileName == null ||
                                        (oa.fileName != null && str.compare( oa.fileName, "" )) ) {
                                        is_valid_for_utau = false;
                                    } else {
                                        is_valid_for_utau = fsys.isFileExists( fsys.combine( sc.VOICEIDSTR, oa.fileName ) );
                                    }
                                }
                            }
                            int intensity = item.UstEvent == null ? 100 : item.UstEvent.getIntensity();

                            //追加
                            tmp.add( new DrawObject( DrawObjectType.Note,
                                                     vsq,
                                                     new Rectangle( x, y, lyric_width, track_height ),
                                                     title,
                                                     accent,
                                                     item.ID.DEMdecGainRate,
                                                     item.ID.Dynamics,
                                                     item.InternalID,
                                                     px_vibrato_delay,
                                                     false,
                                                     item.ID.LyricHandle.L0.PhoneticSymbolProtected,
                                                     rate_bp,
                                                     depth_bp,
                                                     rate_start,
                                                     depth_start,
                                                     item.ID.Note,
                                                     item.UstEvent.getEnvelope(),
                                                     length,
                                                     timesig,
                                                     is_valid_for_utau,
                                                     is_valid_for_utau, // vConnect-STANDはstfファイルを必要としないので，
                                                     vib_delay,
                                                     intensity ) );
                        }

                        // Dynaff, Crescendイベント
                        for ( Iterator<VsqEvent> itr = vsq_track.getDynamicsEventIterator(); itr.hasNext(); ) {
                            VsqEvent item_itr = itr.next();
                            IconDynamicsHandle handle = item_itr.ID.IconDynamicsHandle;
                            if ( handle == null ) {
                                continue;
                            }
                            int clock = item_itr.Clock;
                            int length = item_itr.ID.getLength();
                            if ( length <= 0 ) {
                                length = 1;
                            }
                            int raw_width = (int)(length * scalex);
                            DrawObjectType type = DrawObjectType.Note;
                            int width = 0;
                            String str = "";
                            if ( handle.isDynaffType() ) {
                                // 強弱記号
                                type = DrawObjectType.Dynaff;
                                width = AppManager.DYNAFF_ITEM_WIDTH;
                                int startDyn = handle.getStartDyn();
                                if ( startDyn == 120 ) {
                                    str = "fff";
                                } else if ( startDyn == 104 ) {
                                    str = "ff";
                                } else if ( startDyn == 88 ) {
                                    str = "f";
                                } else if ( startDyn == 72 ) {
                                    str = "mf";
                                } else if ( startDyn == 56 ) {
                                    str = "mp";
                                } else if ( startDyn == 40 ) {
                                    str = "p";
                                } else if ( startDyn == 24 ) {
                                    str = "pp";
                                } else if ( startDyn == 8 ) {
                                    str = "ppp";
                                } else {
                                    str = "?";
                                }
                            } else if ( handle.isCrescendType() ) {
                                // クレッシェンド
                                type = DrawObjectType.Crescend;
                                width = raw_width;
                                str = handle.IDS;
                            } else if ( handle.isDecrescendType() ) {
                                // デクレッシェンド
                                type = DrawObjectType.Decrescend;
                                width = raw_width;
                                str = handle.IDS;
                            }
                            if ( type == DrawObjectType.Note ) {
                                continue;
                            }
                            int note = item_itr.ID.Note;
                            int x = (int)(clock * scalex + xoffset);
                            int y = -note * (int)(100 * AppManager.getScaleY()) + yoffset;
                            tmp.add( new DrawObject( type,
                                                     vsq,
                                                     new Rectangle( x, y, width, track_height ),
                                                     str,
                                                     0,
                                                     0,
                                                     0,
                                                     item_itr.InternalID,
                                                     0,
                                                     false,
                                                     false,
                                                     null,
                                                     null,
                                                     0,
                                                     0,
                                                     item_itr.ID.Note,
                                                     null,
                                                     length,
                                                     clock,
                                                     true,
                                                     true,
                                                     length,
                                                     0 ) );
                        }

                        // 重複部分があるかどうかを判定
                        int count = tmp.size();
                        for ( int i = 0; i < count - 1; i++ ) {
                            DrawObject itemi = tmp.get( i );
                            DrawObjectType parent_type = itemi.mType;
                            /*if ( itemi.type != DrawObjectType.Note ) {
                                continue;
                            }*/
                            boolean overwrapped = false;
                            int istart = itemi.mClock;
                            int iend = istart + itemi.mLength;
                            if ( itemi.mIsOverlapped ) {
                                continue;
                            }
                            for ( int j = i + 1; j < count; j++ ) {
                                DrawObject itemj = tmp.get( j );
                                if ( (itemj.mType == DrawObjectType.Note && parent_type != DrawObjectType.Note) ||
                                     (itemj.mType != DrawObjectType.Note && parent_type == DrawObjectType.Note) ) {
                                    continue;
                                }
                                int jstart = itemj.mClock;
                                int jend = jstart + itemj.mLength;
                                if ( jstart <= istart ) {
                                    if ( istart < jend ) {
                                        overwrapped = true;
                                        itemj.mIsOverlapped = true;
                                        // breakできない．2個以上の重複を検出する必要があるので．
                                    }
                                }
                                if ( istart <= jstart ) {
                                    if ( jstart < iend ) {
                                        overwrapped = true;
                                        itemj.mIsOverlapped = true;
                                    }
                                }
                            }
                            if ( overwrapped ) {
                                itemi.mIsOverlapped = true;
                            }
                        }
                        Collections.sort( tmp );
                        AppManager.mDrawObjects.add( tmp );
                    }
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".updateDrawObjectList; ex=" + ex + "\n" );
                    serr.println( "FormMain#updateDrawObjectList; ex=" + ex );
#if JAVA
                    ex.printStackTrace();
#endif
                } finally {
#if !JAVA
                    if ( SMALL_FONT != null ) {
                        SMALL_FONT.font.Dispose();
                    }
#endif
                }
            }
        }

        /// <summary>
        /// editorConfigのRecentFilesを元に，menuFileRecentのドロップダウンアイテムを更新します
        /// </summary>
        public void updateRecentFileMenu()
        {
            int added = 0;
            menuFileRecent.removeAll();
            if ( AppManager.editorConfig.RecentFiles != null ) {
                for ( int i = 0; i < AppManager.editorConfig.RecentFiles.size(); i++ ) {
                    String item = AppManager.editorConfig.RecentFiles.get( i );
                    if ( item == null ) {
                        continue;
                    }
                    if ( item != "" ) {
                        String short_name = PortUtil.getFileName( item );
                        boolean available = fsys.isFileExists( item );
                        RecentFileMenuItem itm = new RecentFileMenuItem( item );
                        itm.setText( short_name );
                        String tooltip = "";
                        if ( !available ) {
                            tooltip = _( "[file not found]" ) + " ";
                        }
                        tooltip += item;
                        itm.setToolTipText( tooltip );
                        itm.setEnabled( available );
                        itm.Click += new BEventHandler( handleRecentFileMenuItem_Click );
                        itm.MouseEnter += new BEventHandler( handleRecentFileMenuItem_MouseEnter );
                        menuFileRecent.add( itm );
                        added++;
                    }
                }
            } else {
                AppManager.editorConfig.pushRecentFiles( "" );
            }
            menuFileRecent.addSeparator();
            menuFileRecent.add( menuFileRecentClear );
            menuFileRecent.setEnabled( true );
        }

        /// <summary>
        /// 最後に保存したときから変更されているかどうかを取得または設定します
        /// </summary>
        public boolean isEdited()
        {
            return mEdited;
        }

        public void setEdited( boolean value )
        {
            mEdited = value;
            String file = AppManager.getFileName();
            if ( str.compare( file, "" ) ) {
                file = "Untitled";
            } else {
                file = PortUtil.getFileNameWithoutExtension( file );
            }
            if ( mEdited ) {
                file += " *";
            }
            String title = file + " - " + _APP_NAME;
            if ( !str.compare( getTitle(), title ) ) {
                setTitle( title );
            }
            boolean redo = AppManager.isRedoAvailable();
            boolean undo = AppManager.isUndoAvailable();
            menuEditRedo.setEnabled( redo );
            menuEditUndo.setEnabled( undo );
            cMenuPianoRedo.setEnabled( redo );
            cMenuPianoUndo.setEnabled( undo );
            cMenuTrackSelectorRedo.setEnabled( redo );
            cMenuTrackSelectorUndo.setEnabled( undo );
#if JAVA
            stripBtnUndo.setEnabled( undo );
            stripBtnRedo.setEnabled( redo );
#else
            stripBtnUndo.Enabled = undo;
            stripBtnRedo.Enabled = redo;
#endif
            //AppManager.setRenderRequired( AppManager.getSelected(), true );
            updateScrollRangeHorizontal();
            updateDrawObjectList();
            panelOverview.updateCachedImage();

#if ENABLE_PROPERTY
            AppManager.propertyPanel.updateValue( AppManager.getSelected() );
#endif
        }

        /// <summary>
        /// 入力用のテキストボックスを初期化します
        /// </summary>
        public void showInputTextBox( String phrase, String phonetic_symbol, Point position, boolean phonetic_symbol_edit_mode )
        {
#if DEBUG
            AppManager.debugWriteLine( "InitializeInputTextBox" );
#endif
            hideInputTextBox();

            AppManager.mInputTextBox.KeyUp += new BKeyEventHandler( mInputTextBox_KeyUp );
            AppManager.mInputTextBox.KeyDown += new BKeyEventHandler( mInputTextBox_KeyDown );
            //TODO: JAVA: AppManager.mInputTextBox.ImeModeChanged += mInputTextBox_ImeModeChanged;
#if !JAVA
            AppManager.mInputTextBox.ImeModeChanged += mInputTextBox_ImeModeChanged;
#endif

            AppManager.mInputTextBox.setImeModeOn( mLastIsImeModeOn );
            if ( phonetic_symbol_edit_mode ) {
                AppManager.mInputTextBox.setBufferText( phrase );
                AppManager.mInputTextBox.setPhoneticSymbolEditMode( true );
                AppManager.mInputTextBox.setText( phonetic_symbol );
                AppManager.mInputTextBox.setBackground( mColorTextboxBackcolor );
            } else {
                AppManager.mInputTextBox.setBufferText( phonetic_symbol );
                AppManager.mInputTextBox.setPhoneticSymbolEditMode( false );
                AppManager.mInputTextBox.setText( phrase );
                AppManager.mInputTextBox.setBackground( Color.white );
            }
            AppManager.mInputTextBox.setFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
            Point p = new Point( position.x + 4, position.y + 2 );
#if JAVA
            p = pictPianoRoll.pointToScreen( p );
#endif
            AppManager.mInputTextBox.setLocation( p );

#if !JAVA
            AppManager.mInputTextBox.Parent = pictPianoRoll;
#endif
            AppManager.mInputTextBox.setEnabled( true );
            AppManager.mInputTextBox.setVisible( true );
            AppManager.mInputTextBox.requestFocusInWindow();
            AppManager.mInputTextBox.selectAll();
        }

        public void hideInputTextBox()
        {
#if JAVA
            AppManager.mInputTextBox.keyUpEvent.remove( new BKeyEventHandler( this, "mInputTextBox_KeyUp" ) );
            AppManager.mInputTextBox.keyDownEvent.remove( new BKeyEventHandler( this, "mInputTextBox_KeyDown" ) );
            // TODO: JAVA: AppManager.mInputTextBox.ImeModeChanged -= mInputTextBox_ImeModeChanged;
#else
            AppManager.mInputTextBox.KeyUp -= new System.Windows.Forms.KeyEventHandler( mInputTextBox_KeyUp );
            AppManager.mInputTextBox.KeyDown -= new System.Windows.Forms.KeyEventHandler( mInputTextBox_KeyDown );
            AppManager.mInputTextBox.ImeModeChanged -= mInputTextBox_ImeModeChanged;
#endif
            mLastSymbolEditMode = AppManager.mInputTextBox.isPhoneticSymbolEditMode();
            AppManager.mInputTextBox.setVisible( false );
#if !JAVA
            AppManager.mInputTextBox.Parent = null;
#endif
            AppManager.mInputTextBox.setEnabled( false );
            pictPianoRoll.requestFocus();
        }

        /// <summary>
        /// 歌詞入力用テキストボックスのモード（歌詞/発音記号）を切り替えます
        /// </summary>
        public void flipInputTextBoxMode()
        {
            String new_value = AppManager.mInputTextBox.getText();
            if ( !AppManager.mInputTextBox.isPhoneticSymbolEditMode() ) {
                AppManager.mInputTextBox.setBackground( mColorTextboxBackcolor );
            } else {
                AppManager.mInputTextBox.setBackground( Color.white );
            }
            AppManager.mInputTextBox.setText( AppManager.mInputTextBox.getBufferText() );
            AppManager.mInputTextBox.setBufferText( new_value );
            AppManager.mInputTextBox.setPhoneticSymbolEditMode( !AppManager.mInputTextBox.isPhoneticSymbolEditMode() );
        }

        /// <summary>
        /// アンドゥ処理を行います
        /// </summary>
        public void undo()
        {
            if ( AppManager.isUndoAvailable() ) {
                AppManager.undo();
                menuEditRedo.setEnabled( AppManager.isRedoAvailable() );
                menuEditUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuPianoRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuPianoUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuTrackSelectorRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuTrackSelectorUndo.setEnabled( AppManager.isUndoAvailable() );
                AppManager.mMixerWindow.updateStatus();
                setEdited( true );
                updateDrawObjectList();

#if ENABLE_PROPERTY
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.updateValue( AppManager.getSelected() );
                }
#endif
            }
        }

        /// <summary>
        /// リドゥ処理を行います
        /// </summary>
        public void redo()
        {
            if ( AppManager.isRedoAvailable() ) {
                AppManager.redo();
                menuEditRedo.setEnabled( AppManager.isRedoAvailable() );
                menuEditUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuPianoRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuPianoUndo.setEnabled( AppManager.isUndoAvailable() );
                cMenuTrackSelectorRedo.setEnabled( AppManager.isRedoAvailable() );
                cMenuTrackSelectorUndo.setEnabled( AppManager.isUndoAvailable() );
                AppManager.mMixerWindow.updateStatus();
                setEdited( true );
                updateDrawObjectList();

#if ENABLE_PROPERTY
                if ( AppManager.propertyPanel != null ) {
                    AppManager.propertyPanel.updateValue( AppManager.getSelected() );
                }
#endif
            }
        }

        /// <summary>
        /// xvsqファイルを開きます
        /// </summary>
        /// <returns>ファイルを開くのに成功した場合trueを，それ以外はfalseを返します</returns>
        public boolean openVsqCor( String file )
        {
            if( AppManager.readVsq( file ) ){
                return true;
            }
            if ( AppManager.getVsqFile().Track.size() >= 2 ) {
                updateScrollRangeHorizontal();
            }
            AppManager.editorConfig.pushRecentFiles( file );
            updateRecentFileMenu();
            setEdited( false );
            AppManager.clearCommandBuffer();
            AppManager.mMixerWindow.updateStatus();

            // キャッシュwaveなどの処理
            if ( AppManager.editorConfig.UseProjectCache ) {
                #region キャッシュディレクトリの処理
                VsqFileEx vsq = AppManager.getVsqFile();
                String cacheDir = vsq.cacheDir; // xvsqに保存されていたキャッシュのディレクトリ
                String dir = PortUtil.getDirectoryName( file );
                String name = PortUtil.getFileNameWithoutExtension( file );
                String estimatedCacheDir = fsys.combine( dir, name + ".cadencii" ); // ファイル名から推測されるキャッシュディレクトリ
                if ( cacheDir == null ) {
                    cacheDir = "";
                }
                if ( !str.compare( cacheDir, "" ) && 
                     fsys.isDirectoryExists( cacheDir ) &&
                     !str.compare( estimatedCacheDir, "" ) &&
                     !str.compare( cacheDir, estimatedCacheDir ) ) {
                    // ファイル名から推測されるキャッシュディレクトリ名と
                    // xvsqに指定されているキャッシュディレクトリと異なる場合
                    // cacheDirの必要な部分をestimatedCacheDirに移す

                    // estimatedCacheDirが存在しない場合、新しく作る
#if DEBUG
                    sout.println( "FormMain#openVsqCor;fsys.isDirectoryExists( estimatedCacheDir )=" + fsys.isDirectoryExists( estimatedCacheDir ) ); 
#endif
                    if ( !fsys.isDirectoryExists( estimatedCacheDir ) ) {
                        try {
                            PortUtil.createDirectory( estimatedCacheDir );
                        } catch ( Exception ex ) {
                            Logger.write( typeof( FormMain ) + ".openVsqCor; ex=" + ex + "\n" );
                            serr.println( "FormMain#openVsqCor; ex=" + ex );
                            AppManager.showMessageBox( PortUtil.formatMessage( _( "cannot create cache directory: '{0}'" ), estimatedCacheDir ),
                                                       _( "Info." ),
                                                       PortUtil.OK_OPTION,
                                                       org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                            return true;
                        }
                    }

                    // ファイルを移す
                    for ( int i = 1; i < vsq.Track.size(); i++ ) {
                        String wavFrom = fsys.combine( cacheDir, i + ".wav" );
                        String xmlFrom = fsys.combine( cacheDir, i + ".xml" );

                        String wavTo = fsys.combine( estimatedCacheDir, i + ".wav" );
                        String xmlTo = fsys.combine( estimatedCacheDir, i + ".xml" );
                        if ( fsys.isFileExists( wavFrom ) ) {
                            try {
                                PortUtil.moveFile( wavFrom, wavTo );
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".openVsqCor; ex=" + ex + "\n" );
                                serr.println( "FormMain#openVsqCor; ex=" + ex );
                            }
                        }
                        if ( fsys.isFileExists( xmlFrom ) ) {
                            try {
                                PortUtil.moveFile( xmlFrom, xmlTo );
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".openVsqCor; ex=" + ex + "\n" );
                                serr.println( "FormMain#openVsqCor; ex=" + ex );
                            }
                        }
                    }
                }
                cacheDir = estimatedCacheDir;

                // キャッシュが無かったら作成
                if ( !fsys.isDirectoryExists( cacheDir ) ) {
                    try {
                        PortUtil.createDirectory( cacheDir );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".openVsqCor; ex=" + ex + "\n" );
                        serr.println( "FormMain#openVsqCor; ex=" + ex );
                        AppManager.showMessageBox( PortUtil.formatMessage( _( "cannot create cache directory: '{0}'" ), estimatedCacheDir ),
                                                   _( "Info." ),
                                                   PortUtil.OK_OPTION,
                                                   org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                        return true;
                    }
                }

                // RenderedStatusを読み込む
                for ( int i = 1; i < vsq.Track.size(); i++ ) {
                    AppManager.deserializeRenderingStatus( cacheDir, i );
                }

                // キャッシュ内のwavを、waveViewに読み込む
                waveView.unloadAll();
                for ( int i = 1; i < vsq.Track.size(); i++ ) {
                    String wav = fsys.combine( cacheDir, i + ".wav" );
#if DEBUG
                    sout.println( "FormMain#openVsqCor; wav=" + wav + "; isExists=" + fsys.isFileExists( wav ) );
#endif
                    if ( !fsys.isFileExists( wav ) ) {
                        continue;
                    }
                    waveView.load( i - 1, wav );
                }

                // 一時ディレクトリを、cachedirに変更
                AppManager.setTempWaveDir( cacheDir );
                #endregion
            }
            return false;
        }

        public void updateMenuFonts()
        {
            if ( str.compare( AppManager.editorConfig.BaseFontName, "" ) ) {
                return;
            }
            Font font = AppManager.editorConfig.getBaseFont();
            Util.applyFontRecurse( this, font );
#if !JAVA_MAC
            Util.applyContextMenuFontRecurse( cMenuPiano, font );
            Util.applyContextMenuFontRecurse( cMenuTrackSelector, font );
            if ( AppManager.mMixerWindow != null ) {
                Util.applyFontRecurse( AppManager.mMixerWindow, font );
            }
            Util.applyContextMenuFontRecurse( cMenuTrackTab, font );
            trackSelector.applyFont( font );
            Util.applyToolStripFontRecurse( menuFile, font );
            Util.applyToolStripFontRecurse( menuEdit, font );
            Util.applyToolStripFontRecurse( menuVisual, font );
            Util.applyToolStripFontRecurse( menuJob, font );
            Util.applyToolStripFontRecurse( menuTrack, font );
            Util.applyToolStripFontRecurse( menuLyric, font );
            Util.applyToolStripFontRecurse( menuScript, font );
            Util.applyToolStripFontRecurse( menuSetting, font );
            Util.applyToolStripFontRecurse( menuHelp, font );
#endif
#if !JAVA
            Util.applyFontRecurse( toolBarFile, font );
            Util.applyFontRecurse( toolBarMeasure, font );
            Util.applyFontRecurse( toolBarPosition, font );
            Util.applyFontRecurse( toolBarTool, font );
#endif
#if !JAVA_MAC
            if ( mDialogPreference != null ) {
                Util.applyFontRecurse( mDialogPreference, font );
            }
#endif

            AppManager.baseFont10Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE10 );
            AppManager.baseFont8 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 );
            AppManager.baseFont10 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE10 );
            AppManager.baseFont9 = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 );
            AppManager.baseFont50Bold = new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.BOLD, AppManager.FONT_SIZE50 );
            AppManager.baseFont10OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont10 );
            AppManager.baseFont8OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont8 );
            AppManager.baseFont9OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont9 );
            AppManager.baseFont50OffsetHeight = Util.getStringDrawOffset( AppManager.baseFont50Bold );
            AppManager.baseFont8Height = Util.measureString( Util.PANGRAM, AppManager.baseFont8 ).height;
            AppManager.baseFont9Height = Util.measureString( Util.PANGRAM, AppManager.baseFont9 ).height;
            AppManager.baseFont10Height = Util.measureString( Util.PANGRAM, AppManager.baseFont10 ).height;
            AppManager.baseFont50Height = Util.measureString( Util.PANGRAM, AppManager.baseFont50Bold ).height;
        }

        public void picturePositionIndicatorDrawTo( java.awt.Graphics g1 )
        {
            Graphics2D g = (Graphics2D)g1;
            Font SMALL_FONT = AppManager.baseFont8;
            int small_font_offset = AppManager.baseFont8OffsetHeight;
            try {
                int key_width = AppManager.keyWidth;
                int width = picturePositionIndicator.getWidth();
                int height = picturePositionIndicator.getHeight();
                VsqFileEx vsq = AppManager.getVsqFile();

                #region 小節ごとの線
                int dashed_line_step = AppManager.getPositionQuantizeClock();
                for ( Iterator<VsqBarLineType> itr = vsq.getBarLineIterator( AppManager.clockFromXCoord( width ) ); itr.hasNext(); ) {
                    VsqBarLineType blt = itr.next();
                    int local_clock_step = 480 * 4 / blt.getLocalDenominator();
                    int x = AppManager.xCoordFromClocks( blt.clock() );
                    if ( blt.isSeparator() ) {
                        int current = blt.getBarCount() - vsq.getPreMeasure() + 1;
                        g.setColor( mColorR105G105B105 );
                        g.drawLine( x, 0, x, 49 );
                        // 小節の数字
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                        g.setColor( Color.black );
                        g.setFont( SMALL_FONT );
                        g.drawString( current + "", x + 4, 8 - small_font_offset + 1 );
                        //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                    } else {
                        g.setColor( mColorR105G105B105 );
                        g.drawLine( x, 11, x, 16 );
                        g.drawLine( x, 26, x, 31 );
                        g.drawLine( x, 41, x, 46 );
                    }
                    if ( dashed_line_step > 1 && AppManager.isGridVisible() ) {
                        int numDashedLine = local_clock_step / dashed_line_step;
                        for ( int i = 1; i < numDashedLine; i++ ) {
                            int x2 = AppManager.xCoordFromClocks( blt.clock() + i * dashed_line_step );
                            g.setColor( mColorR065G065B065 );
                            g.drawLine( x2, 9 + 5, x2, 14 + 3 );
                            g.drawLine( x2, 24 + 5, x2, 29 + 3 );
                            g.drawLine( x2, 39 + 5, x2, 44 + 3 );
                        }
                    }
                }
                #endregion

                if ( vsq != null ) {
                    #region 拍子の変更
                    int c = vsq.TimesigTable.size();
                    for ( int i = 0; i < c; i++ ) {
                        TimeSigTableEntry itemi = vsq.TimesigTable.get( i );
                        int clock = itemi.Clock;
                        int barcount = itemi.BarCount;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = itemi.Numerator + "/" + itemi.Denominator;
                        g.setFont( SMALL_FONT );
                        if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 40 - small_font_offset + 1 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 40 - small_font_offset + 1 );
                        }

                        if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TIMESIG ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( vsq.getClockFromBarCount( AppManager.getSelectedTimesig( barcount ).editing.BarCount ) );
                                g.setColor( mColorR187G187B255 );
                                g.drawLine( edit_clock_x - 1, 32,
                                            edit_clock_x - 1, picturePositionIndicator.getHeight() - 1 );
                                g.setColor( mColorR007G007B151 );
                                g.drawLine( edit_clock_x, 32,
                                            edit_clock_x, picturePositionIndicator.getHeight() - 1 );
                            }
                        }
                    }
                    #endregion

                    #region テンポの変更
                    g.setFont( SMALL_FONT );
                    c = vsq.TempoTable.size();
                    for ( int i = 0; i < c; i++ ) {
                        TempoTableEntry itemi = vsq.TempoTable.get( i );
                        int clock = itemi.Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( width < x ) {
                            break;
                        }
                        String s = PortUtil.formatDecimal( "#.00", 60e6 / (float)itemi.Tempo );
                        if ( AppManager.isSelectedTempoContains( clock ) ) {
                            g.setColor( AppManager.getHilightColor() );
                            g.drawString( s, x + 4, 24 - small_font_offset + 1 );
                        } else {
                            g.setColor( Color.black );
                            g.drawString( s, x + 4, 24 - small_font_offset + 1 );
                        }

                        if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TEMPO ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                int edit_clock_x = AppManager.xCoordFromClocks( AppManager.getSelectedTempo( clock ).editing.Clock );
                                g.setColor( mColorR187G187B255 );
                                g.drawLine( edit_clock_x - 1, 18,
                                            edit_clock_x - 1, 32 );
                                g.setColor( mColorR007G007B151 );
                                g.drawLine( edit_clock_x, 18,
                                            edit_clock_x, 32 );
                            }
                        }
                    }
                    #endregion
                }

                #region 現在のマーカー
                // ソングポジション
                float xoffset = key_width + AppManager.keyOffset - AppManager.getStartToDrawX();
                int marker_x = (int)(AppManager.getCurrentClock() * AppManager.getScaleX() + xoffset);
                if ( key_width <= marker_x && marker_x <= width ) {
                    g.setStroke( new BasicStroke( 2.0f ) );
                    g.setColor( Color.white );
                    g.drawLine( marker_x, 0, marker_x, height );
                    g.setStroke( new BasicStroke() );
                }

                // スタートマーカーとエンドマーカー
                boolean right = false;
                boolean left = false;
                if ( vsq.config.StartMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( vsq.config.StartMarker );
                    if ( x < key_width ) {
                        left = true;
                    } else if ( width < x ) {
                        right = true;
                    } else {
                        g.drawImage(
                            Resources.get_start_marker(), x, 3, this );
                    }
                }
                if ( vsq.config.EndMarkerEnabled ) {
                    int x = AppManager.xCoordFromClocks( vsq.config.EndMarker ) - 6;
                    if ( x < key_width ) {
                        left = true;
                    } else if ( width < x ) {
                        right = true;
                    } else {
                        g.drawImage(
                            Resources.get_end_marker(), x, 3, this );
                    }
                }

                // 範囲外にスタートマーカーとエンドマーカーがある場合のマーク
                if ( right ) {
                    g.setColor( Color.white );
                    g.fillPolygon(
                        new int[] { width - 6, width, width - 6 },
                        new int[] { 3, 10, 16 },
                        3 );
                }
                if ( left ) {
                    g.setColor( Color.white );
                    g.fillPolygon(
                        new int[] { key_width + 7, key_width + 1, key_width + 7 },
                        new int[] { 3, 10, 16 },
                        3 );
                }
                #endregion

                #region TEMPO & BEAT
                // TEMPO BEATの文字の部分。小節数が被っている可能性があるので、塗り潰す
                g.setColor( picturePositionIndicator.getBackground() );
                g.fillRect( 0, 0, AppManager.keyWidth, 48 );
                // 横ライン上
                g.setColor( new Color( 104, 104, 104 ) );
                g.drawLine( 0, 17, width, 17 );
                // 横ライン中央
                g.drawLine( 0, 32, width, 32 );
                // 横ライン下
                g.drawLine( 0, 47, width, 47 );
                // 縦ライン
                g.drawLine( AppManager.keyWidth, 0, AppManager.keyWidth, 48 );
                /* TEMPO&BEATとピアノロールの境界 */
                g.drawLine( AppManager.keyWidth, 48, width - 18, 48 );
                g.setFont( SMALL_FONT );
                g.setColor( Color.black );
                g.drawString( "TEMPO", 11, 24 - small_font_offset + 1 );
                g.drawString( "BEAT", 11, 40 - small_font_offset + 1 );
                #endregion
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".picturePositionIndicatorDrawTo; ex=" + ex + "\n" );
                serr.println( "FormMain#picturePositionIndicatorDrawTo; ex=" + ex );
            }
        }

        /// <summary>
        /// イベントハンドラを登録します。
        /// </summary>
        public void registerEventHandlers()
        {
            this.Load += new BEventHandler( FormMain_Load );
            menuFileNew.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileNew.Click += new BEventHandler( handleFileNew_Click );
            menuFileOpen.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileOpen.Click += new BEventHandler( handleFileOpen_Click );
            menuFileSave.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileSave.Click += new BEventHandler( handleFileSave_Click );
            menuFileSaveNamed.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileSaveNamed.Click += new BEventHandler( menuFileSaveNamed_Click );
            menuFileOpenVsq.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileOpenVsq.Click += new BEventHandler( menuFileOpenVsq_Click );
            menuFileOpenUst.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileOpenUst.Click += new BEventHandler( menuFileOpenUst_Click );
            menuFileImport.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileImportMidi.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileImportMidi.Click += new BEventHandler( menuFileImportMidi_Click );
            menuFileImportUst.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileImportUst.Click += new BEventHandler( menuFileImportUst_Click );
            menuFileImportVsq.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileImportVsq.Click += new BEventHandler( menuFileImportVsq_Click );
            menuFileExport.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExport.DropDownOpening += new BEventHandler( menuFileExport_DropDownOpening );
            menuFileExportWave.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportWave.Click += new BEventHandler( menuFileExportWave_Click );
            menuFileExportParaWave.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportParaWave.Click += new BEventHandler( menuFileExportParaWave_Click );
            menuFileExportMidi.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportMidi.Click += new BEventHandler( menuFileExportMidi_Click );
            menuFileExportMusicXml.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportMusicXml.Click += new BEventHandler( menuFileExportMusicXml_Click );
            menuFileExportUst.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportUst.Click += new BEventHandler( menuFileExportUst_Click );
            menuFileExportVsq.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportVsq.Click += new BEventHandler( menuFileExportVsq_Click );
            menuFileExportVxt.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileExportVxt.Click += new BEventHandler( menuFileExportVxt_Click );
            menuFileRecent.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileRecentClear.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileRecentClear.Click += new BEventHandler( menuFileRecentClear_Click );
            menuFileQuit.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuFileQuit.Click += new BEventHandler( menuFileQuit_Click );
            menuEdit.DropDownOpening += new BEventHandler( menuEdit_DropDownOpening );
            menuEditUndo.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditUndo.Click += new BEventHandler( handleEditUndo_Click );
            menuEditRedo.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditRedo.Click += new BEventHandler( handleEditRedo_Click );
            menuEditCut.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditCut.Click += new BEventHandler( handleEditCut_Click );
            menuEditCopy.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditCopy.Click += new BEventHandler( handleEditCopy_Click );
            menuEditPaste.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditPaste.Click += new BEventHandler( handleEditPaste_Click );
            menuEditDelete.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditDelete.Click += new BEventHandler( menuEditDelete_Click );
            menuEditAutoNormalizeMode.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditAutoNormalizeMode.Click += new BEventHandler( menuEditAutoNormalizeMode_Click );
            menuEditSelectAll.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditSelectAll.Click += new BEventHandler( menuEditSelectAll_Click );
            menuEditSelectAllEvents.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuEditSelectAllEvents.Click += new BEventHandler( menuEditSelectAllEvents_Click );
            menuVisualOverview.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualControlTrack.CheckedChanged += new BEventHandler( menuVisualControlTrack_CheckedChanged );
            menuVisualControlTrack.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualMixer.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualMixer.Click += new BEventHandler( menuVisualMixer_Click );
            menuVisualWaveform.CheckedChanged += new BEventHandler( menuVisualWaveform_CheckedChanged );
            menuVisualWaveform.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualProperty.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualProperty.CheckedChanged += new BEventHandler( menuVisualProperty_CheckedChanged );
            menuVisualGridline.CheckedChanged += new BEventHandler( menuVisualGridline_CheckedChanged );
            menuVisualGridline.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualIconPalette.Click += new BEventHandler( menuVisualIconPalette_Click );
            menuVisualIconPalette.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualStartMarker.Click += new BEventHandler( handleStartMarker_Click );
            menuVisualStartMarker.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualEndMarker.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualEndMarker.Click += new BEventHandler( handleEndMarker_Click );
            menuVisualLyrics.CheckedChanged += new BEventHandler( menuVisualLyrics_CheckedChanged );
            menuVisualLyrics.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualNoteProperty.CheckedChanged += new BEventHandler( menuVisualNoteProperty_CheckedChanged );
            menuVisualNoteProperty.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualPitchLine.CheckedChanged += new BEventHandler( menuVisualPitchLine_CheckedChanged );
            menuVisualPitchLine.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualPluginUi.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuVisualPluginUi.DropDownOpening += new BEventHandler( menuVisualPluginUi_DropDownOpening );
            menuVisualPluginUiVocaloid1.Click += new BEventHandler( menuVisualPluginUiVocaloidCommon_Click );
            menuVisualPluginUiVocaloid2.Click += new BEventHandler( menuVisualPluginUiVocaloidCommon_Click );
            menuVisualPluginUiAquesTone.Click += new BEventHandler( menuVisualPluginUiAquesTone_Click );
            menuJob.DropDownOpening += new BEventHandler( menuJob_DropDownOpening );
            menuJobNormalize.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobNormalize.Click += new BEventHandler( menuJobNormalize_Click );
            menuJobInsertBar.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobInsertBar.Click += new BEventHandler( menuJobInsertBar_Click );
            menuJobDeleteBar.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobDeleteBar.Click += new BEventHandler( menuJobDeleteBar_Click );
            menuJobRandomize.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobRandomize.Click += new BEventHandler( menuJobRandomize_Click );
            menuJobConnect.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobConnect.Click += new BEventHandler( menuJobConnect_Click );
            menuJobLyric.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuJobLyric.Click += new BEventHandler( menuJobLyric_Click );
            menuTrack.DropDownOpening += new BEventHandler( menuTrack_DropDownOpening );
            menuTrackOn.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackBgm.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackOn.Click += new BEventHandler( handleTrackOn_Click );
            menuTrackAdd.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackAdd.Click += new BEventHandler( menuTrackAdd_Click );
            menuTrackCopy.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackCopy.Click += new BEventHandler( menuTrackCopy_Click );
            menuTrackChangeName.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackChangeName.Click += new BEventHandler( menuTrackChangeName_Click );
            menuTrackDelete.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackDelete.Click += new BEventHandler( menuTrackDelete_Click );
            menuTrackRenderCurrent.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRenderCurrent.Click += new BEventHandler( menuTrackRenderCurrent_Click );
            menuTrackRenderAll.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRenderAll.Click += new BEventHandler( handleTrackRenderAll_Click );
            menuTrackOverlay.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackOverlay.Click += new BEventHandler( menuTrackOverlay_Click );
            menuTrackRenderer.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRenderer.DropDownOpening += new BEventHandler( menuTrackRenderer_DropDownOpening );
            menuTrackRendererVOCALOID1.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRendererVOCALOID1.Click += new BEventHandler( handleChangeRenderer );
            menuTrackRendererVOCALOID2.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRendererVOCALOID2.Click += new BEventHandler( handleChangeRenderer );
            menuTrackRendererUtau.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            //UTAUはresamplerを識別するのでmenuTrackRendererUtauのサブアイテムのClickイベントを拾う
            //menuTrackRendererUtau.Click += new BEventHandler( handleChangeRenderer );
            menuTrackRendererVCNT.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRendererVCNT.Click += new BEventHandler( handleChangeRenderer );
            menuTrackRendererAquesTone.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuTrackRendererAquesTone.Click += new BEventHandler( handleChangeRenderer );
            menuLyric.DropDownOpening += new BEventHandler( menuLyric_DropDownOpening );
            menuLyricCopyVibratoToPreset.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuLyricExpressionProperty.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuLyricExpressionProperty.Click += new BEventHandler( menuLyricExpressionProperty_Click );
            menuLyricVibratoProperty.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuLyricVibratoProperty.Click += new BEventHandler( menuLyricVibratoProperty_Click );
            menuLyricPhonemeTransformation.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuLyricDictionary.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuLyricDictionary.Click += new BEventHandler( menuLyricDictionary_Click );
            menuLyricPhonemeTransformation.Click += new BEventHandler( menuLyricPhonemeTransformation_Click );
            menuLyricApplyUtauParameters.Click += new BEventHandler( menuLyricApplyUtauParameters_Click );
            menuScriptUpdate.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuScriptUpdate.Click += new BEventHandler( menuScriptUpdate_Click );
            menuSettingPreference.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingPreference.Click += new BEventHandler( menuSettingPreference_Click );
            menuSettingGameControler.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingGameControlerSetting.Click += new BEventHandler( menuSettingGameControlerSetting_Click );
            menuSettingGameControlerLoad.Click += new BEventHandler( menuSettingGameControlerLoad_Click );
            menuSettingGameControlerRemove.Click += new BEventHandler( menuSettingGameControlerRemove_Click );
            menuSettingSequence.Click += new BEventHandler( menuSettingSequence_Click );
            menuSettingSequence.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingShortcut.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingShortcut.Click += new BEventHandler( menuSettingShortcut_Click );
            menuSettingVibratoPreset.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingVibratoPreset.Click += new BEventHandler( menuSettingVibratoPreset_Click );
            menuSettingDefaultSingerStyle.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingDefaultSingerStyle.Click += new BEventHandler( menuSettingDefaultSingerStyle_Click );
            menuSettingPaletteTool.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingPositionQuantize.MouseEnter += new BEventHandler( handleMenuMouseEnter );
            menuSettingPositionQuantize04.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantize08.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantize16.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantize32.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantize64.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantize128.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantizeOff.Click += new BEventHandler( handlePositionQuantize );
            menuSettingPositionQuantizeTriplet.Click += new BEventHandler( handlePositionQuantizeTriplet_Click );
#if JAVA
            menuWindowMinimize.Click += new BEventHandler( menuWindowMinimize_Click );
#endif
            menuHelpAbout.Click += new BEventHandler( menuHelpAbout_Click );
            menuHelpManual.Click += new BEventHandler( menuHelpManual_Click );
            menuHelpLogSwitch.CheckedChanged += new BEventHandler( menuHelpLogSwitch_CheckedChanged );
            menuHelpLogOpen.Click += new BEventHandler( menuHelpLogOpen_Click );
            menuHelpDebug.Click += new BEventHandler( menuHelpDebug_Click );
            menuHiddenEditLyric.Click += new BEventHandler( menuHiddenEditLyric_Click );
            menuHiddenEditFlipToolPointerPencil.Click += new BEventHandler( menuHiddenEditFlipToolPointerPencil_Click );
            menuHiddenEditFlipToolPointerEraser.Click += new BEventHandler( menuHiddenEditFlipToolPointerEraser_Click );
            menuHiddenVisualForwardParameter.Click += new BEventHandler( menuHiddenVisualForwardParameter_Click );
            menuHiddenVisualBackwardParameter.Click += new BEventHandler( menuHiddenVisualBackwardParameter_Click );
            menuHiddenTrackNext.Click += new BEventHandler( menuHiddenTrackNext_Click );
            menuHiddenTrackBack.Click += new BEventHandler( menuHiddenTrackBack_Click );
            menuHiddenCopy.Click += new BEventHandler( handleEditCopy_Click );
            menuHiddenPaste.Click += new BEventHandler( handleEditPaste_Click );
            menuHiddenCut.Click += new BEventHandler( handleEditCut_Click );
            menuHiddenSelectBackward.Click += new BEventHandler( menuHiddenSelectBackward_Click );
            menuHiddenSelectForward.Click += new BEventHandler( menuHiddenSelectForward_Click );
            menuHiddenMoveUp.Click += new BEventHandler( menuHiddenMoveUp_Click );
            menuHiddenMoveDown.Click += new BEventHandler( menuHiddenMoveDown_Click );
            menuHiddenMoveLeft.Click += new BEventHandler( menuHiddenMoveLeft_Click );
            menuHiddenMoveRight.Click += new BEventHandler( menuHiddenMoveRight_Click );
            menuHiddenLengthen.Click += new BEventHandler( menuHiddenLengthen_Click );
            menuHiddenShorten.Click += new BEventHandler( menuHiddenShorten_Click );
            menuHiddenGoToEndMarker.Click += new BEventHandler( menuHiddenGoToEndMarker_Click );
            menuHiddenGoToStartMarker.Click += new BEventHandler( menuHiddenGoToStartMarker_Click );
            menuHiddenPlayFromStartMarker.Click += new BEventHandler( menuHiddenPlayFromStartMarker_Click );
            menuHiddenPrintPoToCSV.Click += new BEventHandler( menuHiddenPrintPoToCSV_Click );
            menuHiddenFlipCurveOnPianorollMode.Click += new BEventHandler( menuHiddenFlipCurveOnPianorollMode_Click );

            cMenuPiano.Opening += new BCancelEventHandler( cMenuPiano_Opening );
            cMenuPianoPointer.Click += new BEventHandler( cMenuPianoPointer_Click );
            cMenuPianoPencil.Click += new BEventHandler( cMenuPianoPencil_Click );
            cMenuPianoEraser.Click += new BEventHandler( cMenuPianoEraser_Click );
            cMenuPianoCurve.Click += new BEventHandler( cMenuPianoCurve_Click );
            cMenuPianoFixed01.Click += new BEventHandler( cMenuPianoFixed01_Click );
            cMenuPianoFixed02.Click += new BEventHandler( cMenuPianoFixed02_Click );
            cMenuPianoFixed04.Click += new BEventHandler( cMenuPianoFixed04_Click );
            cMenuPianoFixed08.Click += new BEventHandler( cMenuPianoFixed08_Click );
            cMenuPianoFixed16.Click += new BEventHandler( cMenuPianoFixed16_Click );
            cMenuPianoFixed32.Click += new BEventHandler( cMenuPianoFixed32_Click );
            cMenuPianoFixed64.Click += new BEventHandler( cMenuPianoFixed64_Click );
            cMenuPianoFixed128.Click += new BEventHandler( cMenuPianoFixed128_Click );
            cMenuPianoFixedOff.Click += new BEventHandler( cMenuPianoFixedOff_Click );
            cMenuPianoFixedTriplet.Click += new BEventHandler( cMenuPianoFixedTriplet_Click );
            cMenuPianoFixedDotted.Click += new BEventHandler( cMenuPianoFixedDotted_Click );
            cMenuPianoQuantize04.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantize08.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantize16.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantize32.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantize64.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantize128.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantizeOff.Click += new BEventHandler( handlePositionQuantize );
            cMenuPianoQuantizeTriplet.Click += new BEventHandler( handlePositionQuantizeTriplet_Click );
            cMenuPianoGrid.Click += new BEventHandler( cMenuPianoGrid_Click );
            cMenuPianoUndo.Click += new BEventHandler( cMenuPianoUndo_Click );
            cMenuPianoRedo.Click += new BEventHandler( cMenuPianoRedo_Click );
            cMenuPianoCut.Click += new BEventHandler( cMenuPianoCut_Click );
            cMenuPianoCopy.Click += new BEventHandler( cMenuPianoCopy_Click );
            cMenuPianoPaste.Click += new BEventHandler( cMenuPianoPaste_Click );
            cMenuPianoDelete.Click += new BEventHandler( cMenuPianoDelete_Click );
            cMenuPianoSelectAll.Click += new BEventHandler( cMenuPianoSelectAll_Click );
            cMenuPianoSelectAllEvents.Click += new BEventHandler( cMenuPianoSelectAllEvents_Click );
            cMenuPianoImportLyric.Click += new BEventHandler( cMenuPianoImportLyric_Click );
            cMenuPianoExpressionProperty.Click += new BEventHandler( cMenuPianoProperty_Click );
            cMenuPianoVibratoProperty.Click += new BEventHandler( cMenuPianoVibratoProperty_Click );
            cMenuTrackTab.Opening += new BCancelEventHandler( cMenuTrackTab_Opening );
            cMenuTrackTabTrackOn.Click += new BEventHandler( handleTrackOn_Click );
            cMenuTrackTabAdd.Click += new BEventHandler( cMenuTrackTabAdd_Click );
            cMenuTrackTabCopy.Click += new BEventHandler( cMenuTrackTabCopy_Click );
            cMenuTrackTabChangeName.Click += new BEventHandler( cMenuTrackTabChangeName_Click );
            cMenuTrackTabDelete.Click += new BEventHandler( cMenuTrackTabDelete_Click );
            cMenuTrackTabRenderCurrent.Click += new BEventHandler( cMenuTrackTabRenderCurrent_Click );
            cMenuTrackTabRenderAll.Click += new BEventHandler( handleTrackRenderAll_Click );
            cMenuTrackTabOverlay.Click += new BEventHandler( cMenuTrackTabOverlay_Click );
            cMenuTrackTabRenderer.DropDownOpening += new BEventHandler( cMenuTrackTabRenderer_DropDownOpening );
            cMenuTrackTabRendererVOCALOID1.Click += new BEventHandler( handleChangeRenderer );
            cMenuTrackTabRendererVOCALOID2.Click += new BEventHandler( handleChangeRenderer );
            cMenuTrackTabRendererStraight.Click += new BEventHandler( handleChangeRenderer );
            cMenuTrackTabRendererAquesTone.Click += new BEventHandler( handleChangeRenderer );
            cMenuTrackSelector.Opening += new BCancelEventHandler( cMenuTrackSelector_Opening );
            cMenuTrackSelectorPointer.Click += new BEventHandler( cMenuTrackSelectorPointer_Click );
            cMenuTrackSelectorPencil.Click += new BEventHandler( cMenuTrackSelectorPencil_Click );
            cMenuTrackSelectorLine.Click += new BEventHandler( cMenuTrackSelectorLine_Click );
            cMenuTrackSelectorEraser.Click += new BEventHandler( cMenuTrackSelectorEraser_Click );
            cMenuTrackSelectorCurve.Click += new BEventHandler( cMenuTrackSelectorCurve_Click );
            cMenuTrackSelectorUndo.Click += new BEventHandler( cMenuTrackSelectorUndo_Click );
            cMenuTrackSelectorRedo.Click += new BEventHandler( cMenuTrackSelectorRedo_Click );
            cMenuTrackSelectorCut.Click += new BEventHandler( cMenuTrackSelectorCut_Click );
            cMenuTrackSelectorCopy.Click += new BEventHandler( cMenuTrackSelectorCopy_Click );
            cMenuTrackSelectorPaste.Click += new BEventHandler( cMenuTrackSelectorPaste_Click );
            cMenuTrackSelectorDelete.Click += new BEventHandler( cMenuTrackSelectorDelete_Click );
            cMenuTrackSelectorDeleteBezier.Click += new BEventHandler( cMenuTrackSelectorDeleteBezier_Click );
            cMenuTrackSelectorSelectAll.Click += new BEventHandler( cMenuTrackSelectorSelectAll_Click );
            cMenuPositionIndicatorEndMarker.Click += new BEventHandler( cMenuPositionIndicatorEndMarker_Click );
            cMenuPositionIndicatorStartMarker.Click += new BEventHandler( cMenuPositionIndicatorStartMarker_Click );
            trackBar.ValueChanged += new BEventHandler( trackBar_ValueChanged );
            trackBar.Enter += new BEventHandler( trackBar_Enter );
            bgWorkScreen.DoWork += new BDoWorkEventHandler( bgWorkScreen_DoWork );
            timer.Tick += new BEventHandler( timer_Tick );
            pictKeyLengthSplitter.MouseMove += new BMouseEventHandler( pictKeyLengthSplitter_MouseMove );
            pictKeyLengthSplitter.MouseDown += new BMouseEventHandler( pictKeyLengthSplitter_MouseDown );
            pictKeyLengthSplitter.MouseUp += new BMouseEventHandler( pictKeyLengthSplitter_MouseUp );
            panelOverview.KeyUp += new BKeyEventHandler( handleSpaceKeyUp );
            panelOverview.KeyDown += new BKeyEventHandler( handleSpaceKeyDown );
            vScroll.ValueChanged += new BEventHandler( vScroll_ValueChanged );
            //this.Resize += new BEventHandler( handleVScrollResize );
            pictPianoRoll.Resize += new BEventHandler( handleVScrollResize );
            vScroll.Enter += new BEventHandler( vScroll_Enter );
            hScroll.ValueChanged += new BEventHandler( hScroll_ValueChanged );
            hScroll.Resize += new BEventHandler( hScroll_Resize );
            hScroll.Enter += new BEventHandler( hScroll_Enter );
            picturePositionIndicator.PreviewKeyDown += new BPreviewKeyDownEventHandler( picturePositionIndicator_PreviewKeyDown );
            picturePositionIndicator.MouseMove += new BMouseEventHandler( picturePositionIndicator_MouseMove );
            picturePositionIndicator.MouseClick += new BMouseEventHandler( picturePositionIndicator_MouseClick );
            picturePositionIndicator.MouseDoubleClick += new BMouseEventHandler( picturePositionIndicator_MouseDoubleClick );
            picturePositionIndicator.MouseDown += new BMouseEventHandler( picturePositionIndicator_MouseDown );
            picturePositionIndicator.MouseUp += new BMouseEventHandler( picturePositionIndicator_MouseUp );
            picturePositionIndicator.Paint += new BPaintEventHandler( picturePositionIndicator_Paint );
            pictPianoRoll.PreviewKeyDown += new BPreviewKeyDownEventHandler( pictPianoRoll_PreviewKeyDown );
            pictPianoRoll.KeyUp += new BKeyEventHandler( handleSpaceKeyUp );
            pictPianoRoll.KeyUp += new BKeyEventHandler( pictPianoRoll_KeyUp );
            pictPianoRoll.MouseMove += new BMouseEventHandler( pictPianoRoll_MouseMove );
            pictPianoRoll.MouseDoubleClick += new BMouseEventHandler( pictPianoRoll_MouseDoubleClick );
            pictPianoRoll.MouseClick += new BMouseEventHandler( pictPianoRoll_MouseClick );
            pictPianoRoll.MouseDown += new BMouseEventHandler( pictPianoRoll_MouseDown );
            pictPianoRoll.MouseUp += new BMouseEventHandler( pictPianoRoll_MouseUp );
            pictPianoRoll.KeyDown += new BKeyEventHandler( handleSpaceKeyDown );
            panel2.Paint += new BPaintEventHandler( panel2_Paint );
            panel2.MouseDown += new BMouseEventHandler( panel2_MouseDown );
            panel2.MouseMove += new BMouseEventHandler( panel2_MouseMove );
            panel2.MouseUp += new BMouseEventHandler( panel2_MouseUp );
            waveView.MouseDoubleClick += new BMouseEventHandler( waveView_MouseDoubleClick );
            waveView.MouseDown += new BMouseEventHandler( waveView_MouseDown );
            waveView.MouseUp += new BMouseEventHandler( waveView_MouseUp );
            waveView.MouseMove += new BMouseEventHandler( waveView_MouseMove );
#if !JAVA
            this.DragEnter += new System.Windows.Forms.DragEventHandler( FormMain_DragEnter );
            this.DragDrop += new System.Windows.Forms.DragEventHandler( FormMain_DragDrop );
            this.DragOver += new System.Windows.Forms.DragEventHandler( FormMain_DragOver );
            this.DragLeave += new BEventHandler( FormMain_DragLeave );
#endif

#if JAVA
            buttonVZoom.clickEvent.add( new BEventHandler( this, "buttonVZoom_Click" ) );
            buttonVMooz.clickEvent.add( new BEventHandler( this, "buttonVMooz_Click" ) );
#else
            pictureBox2.MouseDown += new BMouseEventHandler( pictureBox2_MouseDown );
            pictureBox2.MouseUp += new BMouseEventHandler( pictureBox2_MouseUp );
            pictureBox2.Paint += new BPaintEventHandler( pictureBox2_Paint );
#endif
#if JAVA
            stripBtnFileNew.clickEvent.add( new BEventHandler( this, "handleFileNew_Click" ) );
            stripBtnFileNew.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnFileOpen.clickEvent.add( new BEventHandler( this, "handleFileOpen_Click" ) );
            stripBtnFileOpen.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnFileSave.clickEvent.add( new BEventHandler( this, "handleFileSave_Click" ) );
            stripBtnFileSave.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnCut.clickEvent.add( new BEventHandler( this, "handleEditCut_Click" ) );
            stripBtnCut.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnCopy.clickEvent.add( new BEventHandler( this, "handleEditCopy_Click" ) );
            stripBtnCopy.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnPaste.clickEvent.add( new BEventHandler( this, "handleEditPaste_Click" ) );
            stripBtnPaste.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnUndo.clickEvent.add( new BEventHandler( this, "handleEditUndo_Click" ) );
            stripBtnUndo.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnRedo.clickEvent.add( new BEventHandler( this, "handleEditRedo_Click" ) );
            stripBtnRedo.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );

            stripBtnMoveTop.clickEvent.add( new BEventHandler( this, "stripBtnMoveTop_Click" ) );
            stripBtnMoveTop.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnRewind.clickEvent.add( new BEventHandler( this, "stripBtnRewind_Click" ) );
            stripBtnRewind.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnForward.clickEvent.add( new BEventHandler( this, "stripBtnForward_Click" ) );
            stripBtnForward.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnMoveEnd.clickEvent.add( new BEventHandler( this, "stripBtnMoveEnd_Click" ) );
            stripBtnMoveEnd.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnPlay.clickEvent.add( new BEventHandler( this, "stripBtnPlay_Click" ) );
            stripBtnPlay.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnScroll.checkedChangedEvent.add( new BEventHandler( this, "stripBtnScroll_CheckedChanged" ) );
            stripBtnScroll.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnLoop.checkedChangedEvent.add( new BEventHandler( this, "stripBtnLoop_CheckedChanged" ) );
            stripBtnLoop.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );

            stripBtnPointer.clickEvent.add( new BEventHandler( this, "stripBtnArrow_Click" ) );
            stripBtnPointer.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnPencil.clickEvent.add( new BEventHandler( this, "stripBtnPencil_Click" ) );
            stripBtnPencil.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnLine.clickEvent.add( new BEventHandler( this, "stripBtnLine_Click" ) );
            stripBtnLine.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnEraser.clickEvent.add( new BEventHandler( this, "stripBtnEraser_Click" ) );
            stripBtnEraser.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnGrid.clickEvent.add( new BEventHandler( this, "stripBtnGrid_Click" ) );
            stripBtnGrid.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnCurve.clickEvent.add( new BEventHandler( this, "stripBtnCurve_Click" ) );
            stripBtnCurve.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
            stripBtnStepSequencer.enterEvent.add( new BEventHandler( this, "handleStripButton_Enter" ) );
#else
            toolBarTool.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler( toolBarTool_ButtonClick );
            rebar.SizeChanged += new BEventHandler( toolStripContainer_TopToolStripPanel_SizeChanged );// toolStripContainer.TopToolStripPanel.SizeChanged += new BEventHandler( toolStripContainer_TopToolStripPanel_SizeChanged );
            stripDDBtnQuantize04.Click += handlePositionQuantize;
            stripDDBtnQuantize08.Click += handlePositionQuantize;
            stripDDBtnQuantize16.Click += handlePositionQuantize;
            stripDDBtnQuantize32.Click += handlePositionQuantize;
            stripDDBtnQuantize64.Click += handlePositionQuantize;
            stripDDBtnQuantize128.Click += handlePositionQuantize;
            stripDDBtnQuantizeOff.Click += handlePositionQuantize;
            stripDDBtnQuantizeTriplet.Click += handlePositionQuantizeTriplet_Click;
            toolBarFile.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler( toolBarFile_ButtonClick );
            toolBarPosition.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler( toolBarPosition_ButtonClick );
            toolBarMeasure.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler( toolBarMeasure_ButtonClick );
            toolBarMeasure.MouseDown += new BMouseEventHandler( toolBarMeasure_MouseDown );
#endif
            stripBtnStepSequencer.CheckedChanged += new BEventHandler( stripBtnStepSequencer_CheckedChanged );
            this.Deactivate += new BEventHandler( FormMain_Deactivate );
            this.Activated += new BEventHandler( FormMain_Activated );
            this.FormClosed += new BFormClosedEventHandler( FormMain_FormClosed );
            this.FormClosing += new BFormClosingEventHandler( FormMain_FormClosing );
            this.PreviewKeyDown += new BPreviewKeyDownEventHandler( FormMain_PreviewKeyDown );
            panelOverview.Enter += new BEventHandler( panelOverview_Enter );
        }

        public void setResources()
        {
            try {
#if !JAVA
                this.stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_slash() ) );
                this.stripLblMidiIn.setIcon( new ImageIcon( Resources.get_slash() ) );
#endif

#if JAVA
                stripBtnStepSequencer.setIcon( new ImageIcon( Resources.get_piano() ) );
#else
                this.stripBtnStepSequencer.Image = Resources.get_piano().image;
#endif
#if JAVA
                stripBtnFileNew.setIcon( new ImageIcon( Resources.get_disk__plus() ) );
                stripBtnFileOpen.setIcon( new ImageIcon( Resources.get_folder_horizontal_open() ) );
                stripBtnFileSave.setIcon( new ImageIcon( Resources.get_disk() ) );
                stripBtnCut.setIcon( new ImageIcon( Resources.get_scissors() ) );
                stripBtnCopy.setIcon( new ImageIcon( Resources.get_documents() ) );
                stripBtnPaste.setIcon( new ImageIcon( Resources.get_clipboard_paste() ) );
                stripBtnUndo.setIcon( new ImageIcon( Resources.get_arrow_skip_180() ) );
                stripBtnRedo.setIcon( new ImageIcon( Resources.get_arrow_skip() ) );

                stripBtnMoveTop.setIcon( new ImageIcon( Resources.get_control_stop_180() ) );
                stripBtnRewind.setIcon( new ImageIcon( Resources.get_control_double_180() ) );
                stripBtnForward.setIcon( new ImageIcon( Resources.get_control_double() ) );
                stripBtnMoveEnd.setIcon( new ImageIcon( Resources.get_control_stop() ) );
                stripBtnPlay.setIcon( new ImageIcon( Resources.get_control() ) );
                stripBtnScroll.setIcon( new ImageIcon( Resources.get_arrow_circle_double() ) );
                stripBtnLoop.setIcon( new ImageIcon( Resources.get_arrow_return() ) );

                stripBtnPointer.setIcon( new ImageIcon( Resources.get_arrow_135() ) );
                stripBtnPencil.setIcon( new ImageIcon( Resources.get_pencil() ) );
                stripBtnLine.setIcon( new ImageIcon( Resources.get_layer_shape_line() ) );
                stripBtnEraser.setIcon( new ImageIcon( Resources.get_eraser() ) );
                stripBtnGrid.setIcon( new ImageIcon( Resources.get_ruler_crop() ) );
                stripBtnCurve.setIcon( new ImageIcon( Resources.get_layer_shape_curve() ) );

                buttonVZoom.setIcon( new ImageIcon( Resources.get_plus8x8() ) );
                buttonVMooz.setIcon( new ImageIcon( Resources.get_minus8x8() ) );
#endif
                setIconImage( Resources.get_icon() );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".setResources; ex=" + ex + "\n" );
                serr.println( "FormMain#setResources; ex=" + ex );
            }
        }
        #endregion // public methods

        #region event handlers
        public void menuWindowMinimize_Click( Object sender, BEventArgs e )
        {
            int state = this.getExtendedState();
            if( state != BForm.ICONIFIED ){
                setExtendedState( BForm.ICONIFIED );
            }
        }
        
        //BOOKMARK: panelOverview
        #region panelOverview
        public void panelOverview_Enter( Object sender, EventArgs e )
        {
            pictPianoRoll.requestFocus();
        }
        #endregion

        //BOOKMARK: inputTextBox
        #region AppManager.mInputTextBox
        public void mInputTextBox_KeyDown( Object sender, BKeyEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#mInputTextBox_KeyDown" );
#endif
#if JAVA
            int keycode = e.getKeyCode();
            int modifiers = e.getModifiers();
            boolean shift = (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK;
            boolean tab = keycode == KeyEvent.VK_TAB;
            boolean enter = keycode == KeyEvent.VK_ENTER; 
#else
            boolean shift = (e.Modifiers & System.Windows.Forms.Keys.Shift) == System.Windows.Forms.Keys.Shift;
            boolean tab = e.KeyCode == System.Windows.Forms.Keys.Tab;
            boolean enter = e.KeyCode == System.Windows.Forms.Keys.Return;
#endif
            if ( tab || enter ) {
                executeLyricChangeCommand();
                int selected = AppManager.getSelected();
                int index = -1;
                int width = pictPianoRoll.getWidth();
                int height = pictPianoRoll.getHeight();
                int key_width = AppManager.keyWidth;
                VsqTrack track = AppManager.getVsqFile().Track.get( selected );
                track.sortEvent();
                if( tab ) {
                    int clock = 0;
                    int search_index = AppManager.getLastSelectedEvent().original.InternalID;
                    int c = track.getEventCount();
                    for ( int i = 0; i < c; i++ ) {
                        VsqEvent item = track.getEvent( i );
                        if ( item.InternalID == search_index ) {
                            index = i;
                            clock = item.Clock;
                            break;
                        }
                    }
                    if( shift ) {
                        // 1個前の音符イベントを検索
                        int tindex = -1;
                        for ( int i = track.getEventCount() - 1; i >= 0; i-- ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock <= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    } else {
                        // 1個後の音符イベントを検索
                        int tindex = -1;
                        int c2 = track.getEventCount();
                        for ( int i = 0; i < c2; i++ ) {
                            VsqEvent ve = track.getEvent( i );
                            if ( ve.ID.type == VsqIDType.Anote && i != index && ve.Clock >= clock ) {
                                tindex = i;
                                break;
                            }
                        }
                        index = tindex;
                    }
                }
                if ( 0 <= index && index < track.getEventCount() ) {
                    AppManager.clearSelectedEvent();
                    VsqEvent item = track.getEvent( index );
                    AppManager.addSelectedEvent( item.InternalID );
                    int x = AppManager.xCoordFromClocks( item.Clock );
                    int y = AppManager.yCoordFromNote( item.ID.Note );
                    boolean phonetic_symbol_edit_mode = AppManager.mInputTextBox.isPhoneticSymbolEditMode();
                    showInputTextBox(
                        item.ID.LyricHandle.L0.Phrase,
                        item.ID.LyricHandle.L0.getPhoneticSymbol(),
                        new Point( x, y ),
                        phonetic_symbol_edit_mode );
                    int clWidth = (int)(AppManager.mInputTextBox.getWidth() * AppManager.getScaleXInv());

                    // 画面上にAppManager.mInputTextBoxが見えるように，移動
                    int SPACE = 20;
                    // vScrollやhScrollをいじった場合はfalseにする．
                    boolean refresh_screen = true;
                    // X軸方向について，見えるように移動
                    if ( x < key_width || width < x + AppManager.mInputTextBox.getWidth() ) {
                        int clock, clock_x;
                        if ( x < key_width ) {
                            // 左に隠れてしまう場合
                            clock = item.Clock;
                        } else {
                            // 右に隠れてしまう場合
                            clock = item.Clock + clWidth;
                        }
                        if( shift ){
                            // 左方向に移動していた場合
                            // 右から３分の１の位置に移動させる
                            clock_x = width - (width - key_width) / 3;
                        }else{
                            // 右方向に移動していた場合
                            clock_x = key_width + (width - key_width) / 3;
                        }
                        double draft_d = (key_width + AppManager.keyOffset - clock_x) * AppManager.getScaleXInv() + clock;
                        if ( draft_d < 0.0 ) {
                            draft_d = 0.0;
                        }
                        int draft = (int)draft_d;
                        if ( draft < hScroll.getMinimum() ) {
                            draft = hScroll.getMinimum();
                        } else if ( hScroll.getMaximum() < draft ) {
                            draft = hScroll.getMaximum();
                        }
                        refresh_screen = false;
                        hScroll.setValue( draft );
                    }
                    // y軸方向について，見えるように移動
                    int track_height = (int)(100 * AppManager.getScaleY());
                    if( y <= 0 || height - track_height  <= y ){
                        int note = item.ID.Note;
                        if( y <= 0 ){
                            // 上にはみ出してしまう場合
                            note = item.ID.Note + 1;
                        }else{
                            // 下にはみ出してしまう場合
                            note = item.ID.Note - 2;
                        }
                        if( 127 < note ){
                            note = 127;
                        }
                        if( note < 0 ){
                            note = 0;
                        }
                        ensureVisibleY( note );
                    }
                    if ( refresh_screen ) {
                        refreshScreen();
                    }
                } else {
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( id );
                    hideInputTextBox();
                }
            }
        }

        public void mInputTextBox_KeyUp( Object sender, BKeyEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#mInputTextBox_KeyUp" );
#endif
#if JAVA
            boolean flip = (e.getKeyCode() == KeyEvent.VK_UP || e.getKeyCode() == KeyEvent.VK_DOWN) && ((e.getModifiers() & InputEvent.ALT_MASK) == InputEvent.ALT_MASK);
            boolean hide = (e.getKeyCode() == KeyEvent.VK_ESCAPE);
#else
            bool flip = (e.KeyCode == System.Windows.Forms.Keys.Up || e.KeyCode == System.Windows.Forms.Keys.Down) && (PortUtil.getCurrentModifierKey() == InputEvent.ALT_MASK);
            bool hide = e.KeyCode == System.Windows.Forms.Keys.Escape;
#endif

            if ( flip ) {
                if ( AppManager.mInputTextBox.isVisible() ) {
                    flipInputTextBoxMode();
                }
            } else if ( hide ) {
                hideInputTextBox();
            }
        }

        public void mInputTextBox_ImeModeChanged( Object sender, EventArgs e )
        {
            mLastIsImeModeOn = AppManager.mInputTextBox.isImeModeOn();
        }

        public void mInputTextBox_KeyPress( Object sender, BKeyPressEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#mInputTextBox_KeyPress" );
#endif
#if !JAVA
            //           Enter                                  Tab
            e.Handled = (e.KeyChar == Convert.ToChar( 13 )) || (e.KeyChar == Convert.ToChar( 09 ));
#endif
        }
        #endregion

        //BOOKMARK: AppManager
        #region AppManager
        public void AppManager_EditedStateChanged( Object sender, boolean edited )
        {
            setEdited( edited );
        }

        public void AppManager_GridVisibleChanged( Object sender, EventArgs e )
        {
            menuVisualGridline.setSelected( AppManager.isGridVisible() );
#if JAVA
            stripBtnGrid.setSelected( AppManager.isGridVisible() );
#else
            stripBtnGrid.Pushed = AppManager.isGridVisible();
#endif
            cMenuPianoGrid.setSelected( AppManager.isGridVisible() );
        }

        public void AppManager_MainWindowFocusRequired( Object sender, EventArgs e )
        {
            this.requestFocus();
        }

        public void AppManager_PreviewAborted( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#AppManager_PreviewAborted" );
#endif
#if JAVA
            stripBtnPlay.setIcon( new ImageIcon( Resources.get_control() ) );
            stripBtnPlay.setText( _( "Play" ) );
#else
            stripBtnPlay.ImageKey = "control.png";
            stripBtnPlay.Text = _( "Play" );
#endif
            timer.stop();

            for ( int i = 0; i < AppManager.mDrawStartIndex.Length; i++ ) {
                AppManager.mDrawStartIndex[i] = 0;
            }
#if ENABLE_MIDI
            //MidiPlayer.stop();
#endif // ENABLE_MIDI
        }

        public void AppManager_PreviewStarted( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#AppManager_PreviewStarted" );
#endif
            AppManager.mAddingEvent = null;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            RendererKind renderer = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
            int clock = AppManager.getCurrentClock();
            mLastClock = clock;
            double now = PortUtil.getCurrentTime();
            AppManager.mPreviewStartedTime = now;
            timer.start();
#if JAVA
            stripBtnPlay.setIcon( new ImageIcon( Resources.get_control_pause() ) );
            stripBtnPlay.setText( _( "Stop" ) );
#else
            stripBtnPlay.ImageKey = "control_pause.png";
            stripBtnPlay.Text = _( "Stop" );
#endif
        }

        public void AppManager_SelectedToolChanged( Object sender, EventArgs e )
        {
            applySelectedTool();
        }

        public void AppManager_SelectedEventChanged( Object sender, boolean selected_event_is_null )
        {
            menuEditCut.setEnabled( !selected_event_is_null );
            menuEditPaste.setEnabled( !selected_event_is_null );
            menuEditDelete.setEnabled( !selected_event_is_null );
            cMenuPianoCut.setEnabled( !selected_event_is_null );
            cMenuPianoCopy.setEnabled( !selected_event_is_null );
            cMenuPianoDelete.setEnabled( !selected_event_is_null );
            cMenuPianoExpressionProperty.setEnabled( !selected_event_is_null );
            menuLyricVibratoProperty.setEnabled( !selected_event_is_null );
            menuLyricExpressionProperty.setEnabled( !selected_event_is_null );
#if JAVA
            stripBtnCut.setEnabled( !selected_event_is_null );
            stripBtnCopy.setEnabled( !selected_event_is_null );
#else
            stripBtnCut.Enabled = !selected_event_is_null;
            stripBtnCopy.Enabled = !selected_event_is_null;
#endif
        }

        public void AppManager_UpdateBgmStatusRequired( Object sender, EventArgs e )
        {
            updateBgmMenuState();
        }

        public void AppManager_WaveViewRealoadRequired( Object sender, WaveViewRealoadRequiredEventArgs arg )
        {
            int track = arg.track;
            String file = arg.file;
            double sec_start = arg.secStart;
            double sec_end = arg.secEnd;
            if ( sec_start <= sec_end ) {
                waveView.reloadPartial( track - 1, file, sec_start, sec_end );
            } else {
                waveView.load( track - 1, file );
            }
        }
        #endregion

        //BOOKMARK: pictPianoRoll
        #region pictPianoRoll
        public void pictPianoRoll_KeyUp( Object sender, BKeyEventArgs e )
        {
            processSpecialShortcutKey( e, false );
        }

        public void pictPianoRoll_MouseClick( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseClick" );
#endif
            int modefiers = PortUtil.getCurrentModifierKey();
            EditMode edit_mode = AppManager.getEditMode();

            boolean is_button_left = e.Button == BMouseButtons.Left;
            int selected = AppManager.getSelected();

            if ( e.Button == BMouseButtons.Left ) {
#if ENABLE_MOUSEHOVER
                if ( mMouseHoverThread != null ) {
                    mMouseHoverThread.Abort();
                }
#endif

                // クリック位置にIDが無いかどうかを検査
                ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>( new Rectangle() );
                VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                Rectangle id_rect = out_id_rect.value;
#if DEBUG
                AppManager.debugWriteLine( "    (item==null)=" + (item == null) );
#endif
                if ( item != null &&
                     edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                     edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                     edit_mode != EditMode.EDIT_LEFT_EDGE &&
                     edit_mode != EditMode.EDIT_RIGHT_EDGE &&
                     edit_mode != EditMode.MIDDLE_DRAG &&
                     edit_mode != EditMode.CURVE_ON_PIANOROLL ) {
                    if ( (modefiers & InputEvent.SHIFT_MASK) != InputEvent.SHIFT_MASK && (modefiers & s_modifier_key) != s_modifier_key ) {
                        AppManager.clearSelectedEvent();
                    }
                    AppManager.addSelectedEvent( item.InternalID );
                    int internal_id = item.InternalID;
                    hideInputTextBox();
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventDelete( selected, internal_id ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        setEdited( true );
                        AppManager.clearSelectedEvent();
                        return;
#if ENABLE_SCRIPT
                    } else if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                        Vector<Integer> internal_ids = new Vector<Integer>();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry see = itr.next();
                            internal_ids.add( see.original.InternalID );
                        }
                        BMouseButtons btn = e.Button;
                        if ( isMouseMiddleButtonDowned( btn ) ) {
                            btn = BMouseButtons.Middle;
                        }
                        boolean result = PaletteToolServer.invokePaletteTool( AppManager.mSelectedPaletteTool,
                                                                              selected,
                                                                              internal_ids.toArray( new Integer[] { } ),
                                                                              btn );
                        if ( result ) {
                            setEdited( true );
                            AppManager.clearSelectedEvent();
                            return;
                        }
#endif
                    }
                } else {
                    if ( edit_mode != EditMode.MOVE_ENTRY_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE &&
                         edit_mode != EditMode.MOVE_ENTRY_WHOLE &&
                         edit_mode != EditMode.EDIT_LEFT_EDGE &&
                         edit_mode != EditMode.EDIT_RIGHT_EDGE &&
                         edit_mode != EditMode.EDIT_VIBRATO_DELAY ) {
                        if ( !AppManager.mIsPointerDowned ) {
                            AppManager.clearSelectedEvent();
                        }
                        hideInputTextBox();
                    }
                    if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                        // マウス位置にビブラートの波波があったら削除する
                        int stdx = AppManager.getStartToDrawX();
                        int stdy = AppManager.getStartToDrawY();
                        for ( int i = 0; i < AppManager.mDrawObjects.get( selected - 1 ).size(); i++ ) {
                            DrawObject dobj = AppManager.mDrawObjects.get( selected - 1 ).get( i );
                            if ( dobj.mRectangleInPixel.x + AppManager.getStartToDrawX() + dobj.mRectangleInPixel.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.getWidth() < dobj.mRectangleInPixel.x + AppManager.keyWidth - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.mRectangleInPixel.x + AppManager.keyWidth + dobj.mVibratoDelayInPixel - stdx,
                                                          dobj.mRectangleInPixel.y + (int)(100 * AppManager.getScaleY()) - stdy,
                                                          dobj.mRectangleInPixel.width - dobj.mVibratoDelayInPixel,
                                                          (int)(100 * AppManager.getScaleY()) );
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                //ビブラートの範囲なのでビブラートを消す
                                VsqEvent item3 = null;
                                VsqID item2 = null;
                                int internal_id = -1;
                                internal_id = dobj.mInternalID;
                                for ( Iterator<VsqEvent> itr = AppManager.getVsqFile().Track.get( selected ).getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    if ( ve.InternalID == dobj.mInternalID ) {
                                        item2 = (VsqID)ve.ID.clone();
                                        item3 = ve;
                                        break;
                                    }
                                }
                                if ( item2 != null ) {
                                    item2.VibratoHandle = null;
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandEventChangeIDContaints( selected,
                                                                                          internal_id,
                                                                                          item2 ) );
                                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                    setEdited( true );
                                }
                                break;
                            }
                        }
                    }
                }
            } else if ( e.Button == BMouseButtons.Right ) {
                boolean show_context_menu = (e.X > AppManager.keyWidth);
#if ENABLE_MOUSEHOVER
                if ( mMouseHoverThread != null ) {
                    if ( !mMouseHoverThread.IsAlive && AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                } else {
                    if ( AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                        show_context_menu = false;
                    }
                }
#endif
                show_context_menu = AppManager.showContextMenuWhenRightClickedOnPianoroll ? (show_context_menu && !mMouseMoved) : false;
                if ( show_context_menu ) {
#if ENABLE_MOUSEHOVER
                    if ( mMouseHoverThread != null ) {
                        mMouseHoverThread.Abort();
                    }
#endif
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        if ( !AppManager.isSelectedEventContains( AppManager.getSelected(), item.InternalID ) ) {
                            AppManager.clearSelectedEvent();
                        }
                        AppManager.addSelectedEvent( item.InternalID );
                    }
                    boolean item_is_null = (item == null);
                    cMenuPianoCopy.setEnabled( !item_is_null );
                    cMenuPianoCut.setEnabled( !item_is_null );
                    cMenuPianoDelete.setEnabled( !item_is_null );
                    cMenuPianoImportLyric.setEnabled( !item_is_null );
                    cMenuPianoExpressionProperty.setEnabled( !item_is_null );

                    int clock = AppManager.clockFromXCoord( e.X );
                    cMenuPianoPaste.setEnabled( ((AppManager.getCopiedItems().events.size() != 0) && (clock >= AppManager.getVsqFile().getPreMeasureClocks())) );
                    refreshScreen();

                    mContextMenuOpenedPosition = new Point( e.X, e.Y );
                    cMenuPiano.show( pictPianoRoll, e.X, e.Y );
                } else {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( mButtonInitial, out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
#if DEBUG
                    AppManager.debugWriteLine( "pitcPianoRoll_MouseClick; button is right; (item==null)=" + (item == null) );
#endif
                    if ( item != null ) {
                        int itemx = AppManager.xCoordFromClocks( item.Clock );
                        int itemy = AppManager.yCoordFromNote( item.ID.Note );
                    }
                }
            } else if ( e.Button == BMouseButtons.Middle ) {
#if ENABLE_SCRIPT
                if ( AppManager.getSelectedTool() == EditTool.PALETTE_TOOL ) {
                    ByRef<Rectangle> out_id_rect = new ByRef<Rectangle>();
                    VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_id_rect );
                    Rectangle id_rect = out_id_rect.value;
                    if ( item != null ) {
                        AppManager.clearSelectedEvent();
                        AppManager.addSelectedEvent( item.InternalID );
                        Vector<Integer> internal_ids = new Vector<Integer>();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry see = itr.next();
                            internal_ids.add( see.original.InternalID );
                        }
                        boolean result = PaletteToolServer.invokePaletteTool( AppManager.mSelectedPaletteTool,
                                                                           AppManager.getSelected(),
                                                                           internal_ids.toArray( new Integer[] { } ),
                                                                           e.Button );
                        if ( result ) {
                            setEdited( true );
                            AppManager.clearSelectedEvent();
                            return;
                        }
                    }
                }
#endif
            }
        }

        public void pictPianoRoll_MouseDoubleClick( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#pictPianoRoll_MouseDoubleClick" );
#endif
            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;
            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( item != null && item.ID.type == VsqIDType.Anote ) {
#if ENABLE_SCRIPT
                if ( AppManager.getSelectedTool() != EditTool.PALETTE_TOOL )
#endif

                {
                    AppManager.clearSelectedEvent();
                    AppManager.addSelectedEvent( item.InternalID );
#if ENABLE_MOUSEHOVER
                    mMouseHoverThread.Abort();
#endif
                    if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                        mLastSymbolEditMode = false;
                    }
                    showInputTextBox(
                        item.ID.LyricHandle.L0.Phrase,
                        item.ID.LyricHandle.L0.getPhoneticSymbol(),
                        new Point( rect.x, rect.y ),
                        mLastSymbolEditMode );
                    refreshScreen();
                    return;
                }
            } else {
                AppManager.clearSelectedEvent();
                hideInputTextBox();
                if ( AppManager.editorConfig.ShowExpLine && AppManager.keyWidth <= e.X ) {
                    int stdx = AppManager.getStartToDrawX();
                    int stdy = AppManager.getStartToDrawY();
                    for ( Iterator<DrawObject> itr = AppManager.mDrawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        // 表情コントロールプロパティを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.mRectangleInPixel.x + AppManager.keyWidth - stdx,
                            dobj.mRectangleInPixel.y - stdy + (int)(100 * AppManager.getScaleY()),
                            21,
                            (int)(100 * AppManager.getScaleY()) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selectedEvent = null;
                            for ( Iterator<VsqEvent> itr2 = vsq.Track.get( selected ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.mInternalID ) {
                                    selectedEvent = ev;
                                    break;
                                }
                            }
                            if ( selectedEvent != null ) {
#if ENABLE_MOUSEHOVER
                                if ( mMouseHoverThread != null ) {
                                    mMouseHoverThread.Abort();
                                }
#endif
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                                if ( kind == RendererKind.VOCALOID1 ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormNoteExpressionConfig dlg = null;
                                try {
                                    dlg = new FormNoteExpressionConfig( type, selectedEvent.ID.NoteHeadHandle );
                                    dlg.setPMBendDepth( selectedEvent.ID.PMBendDepth );
                                    dlg.setPMBendLength( selectedEvent.ID.PMBendLength );
                                    dlg.setPMbPortamentoUse( selectedEvent.ID.PMbPortamentoUse );
                                    dlg.setDEMdecGainRate( selectedEvent.ID.DEMdecGainRate );
                                    dlg.setDEMaccent( selectedEvent.ID.DEMaccent );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                    if ( dr == BDialogResult.OK ) {
                                        VsqID id = (VsqID)selectedEvent.ID.clone();
                                        id.PMBendDepth = dlg.getPMBendDepth();
                                        id.PMBendLength = dlg.getPMBendLength();
                                        id.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                                        id.DEMdecGainRate = dlg.getDEMdecGainRate();
                                        id.DEMaccent = dlg.getDEMaccent();
                                        id.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( selected, selectedEvent.InternalID, id ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    Logger.write( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick; ex=" + ex + "\n" );
                                    serr.println( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick" + ex );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                            Logger.write( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick; ex=" + ex2 + "\n" );
                                            serr.println( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick" );
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                        // ビブラートプロパティダイアログを表示するかどうかを決める
                        rect = new Rectangle(
                            dobj.mRectangleInPixel.x + AppManager.keyWidth - stdx + 21,
                            dobj.mRectangleInPixel.y - stdy + (int)(100 * AppManager.getScaleY()),
                            dobj.mRectangleInPixel.width - 21,
                            (int)(100 * AppManager.getScaleY()) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), rect ) ) {
                            VsqEvent selectedEvent = null;
                            for ( Iterator<VsqEvent> itr2 = vsq.Track.get( selected ).getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent ev = itr2.next();
                                if ( ev.InternalID == dobj.mInternalID ) {
                                    selectedEvent = ev;
                                    break;
                                }
                            }
                            if ( selectedEvent != null ) {
#if ENABLE_MOUSEHOVER
                                if ( mMouseHoverThread != null ) {
                                    mMouseHoverThread.Abort();
                                }
#endif
                                SynthesizerType type = SynthesizerType.VOCALOID2;
                                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
#if DEBUG
                                sout.println( "FormMain#pictPianoRoll_MouseDoubleClick; kind=" + kind );
#endif
                                if ( kind == RendererKind.VOCALOID1 ) {
                                    type = SynthesizerType.VOCALOID1;
                                }
                                FormVibratoConfig dlg = null;
                                try {
                                    dlg = new FormVibratoConfig(
                                        selectedEvent.ID.VibratoHandle,
                                        selectedEvent.ID.getLength(),
                                        AppManager.editorConfig.DefaultVibratoLength,
                                        type,
                                        AppManager.editorConfig.UseUserDefinedAutoVibratoType );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                    if ( dr == BDialogResult.OK ) {
                                        VsqID t = (VsqID)selectedEvent.ID.clone();
                                        VibratoHandle handle = dlg.getVibratoHandle();
#if DEBUG
                                        sout.println( "FormMain#pictPianoRoll_MouseDoubleClick; (handle==null)=" + (handle == null) );
#endif
                                        if ( handle != null ) {
                                            String iconid = handle.IconID;
                                            int vibrato_length = handle.getLength();
                                            int note_length = selectedEvent.ID.getLength();
                                            t.VibratoDelay = note_length - vibrato_length;
                                            t.VibratoHandle = handle;
                                        } else {
                                            t.VibratoHandle = null;
                                        }
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandEventChangeIDContaints( 
                                                selected,
                                                selectedEvent.InternalID,
                                                t ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    Logger.write( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick; ex=" + ex + "\n" );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                            Logger.write( typeof( FormMain ) + ".pictPianoRoll_MouseDoubleClick; ex=" + ex2 + "\n" );
                                        }
                                    }
                                }
                                return;
                            }
                            break;
                        }

                    }
                }
            }

            if ( e.Button == BMouseButtons.Left ) {
                // 必要な操作が何も無ければ，クリック位置にソングポジションを移動
                if ( AppManager.keyWidth < e.X ) {
                    int clock = doQuantize( AppManager.clockFromXCoord( e.X ), AppManager.getPositionQuantizeClock() );
                    AppManager.setCurrentClock( clock );
                }
            } else if ( e.Button == BMouseButtons.Middle ) {
                // ツールをポインター <--> 鉛筆に切り替える
                if ( AppManager.keyWidth < e.X ) {
                    if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                        AppManager.setSelectedTool( EditTool.PENCIL );
                    } else {
                        AppManager.setSelectedTool( EditTool.ARROW );
                    }
                }
            }
        }

        public void pictPianoRoll_MouseDown( Object sender, BMouseEventArgs e0 )
        {
#if DEBUG
            AppManager.debugWriteLine( "pictPianoRoll_MouseDown" );
#endif
            BMouseButtons btn0 = e0.Button;
            if ( isMouseMiddleButtonDowned( btn0 ) ) {
                btn0 = BMouseButtons.Middle;
            }
            BMouseEventArgs e = new BMouseEventArgs( btn0, e0.Clicks, e0.X, e0.Y, e0.Delta );

            mMouseMoved = false;
            if ( !AppManager.isPlaying() && 0 <= e.X && e.X <= AppManager.keyWidth ) {
                int note = AppManager.noteFromYCoord( e.Y );
                if ( 0 <= note && note <= 126 ) {
                    if ( e.Button == BMouseButtons.Left ) {
                        KeySoundPlayer.play( note );
                    }
                    return;
                }
            }

            AppManager.clearSelectedTempo();
            AppManager.clearSelectedTimesig();
            AppManager.clearSelectedPoint();
            /*if ( e.Button == BMouseButtons.Left ) {
                AppManager.selectedRegionEnabled = false;
            }*/

            mMouseDowned = true;
            mButtonInitial = new Point( e.X, e.Y );
            int modefier = PortUtil.getCurrentModifierKey();

            EditTool selected_tool = AppManager.getSelectedTool();
#if ENABLE_SCRIPT
            if ( selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Middle ) {
#else
            if ( e.Button == BMouseButtons.Middle ) {
#endif
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                mMiddleButtonVScroll = vScroll.getValue();
                mMiddleButtonHScroll = hScroll.getValue();
                return;
            }

            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            if ( e.Button == BMouseButtons.Left && AppManager.mCurveOnPianoroll && (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE) ) {
                pictPianoRoll.mMouseTracer.clear();
                pictPianoRoll.mMouseTracer.appendFirst( e.X + stdx, e.Y + stdy );
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                AppManager.setEditMode( EditMode.CURVE_ON_PIANOROLL );
                return;
            }

            ByRef<Rectangle> out_rect = new ByRef<Rectangle>();
            VsqEvent item = getItemAtClickedPosition( new Point( e.X, e.Y ), out_rect );
            Rectangle rect = out_rect.value;

#if ENABLE_SCRIPT
            if ( selected_tool == EditTool.PALETTE_TOOL && item == null && e.Button == BMouseButtons.Middle ) {
                AppManager.setEditMode( EditMode.MIDDLE_DRAG );
                mMiddleButtonVScroll = vScroll.getValue();
                mMiddleButtonHScroll = hScroll.getValue();
                return;
            }
#endif

            int selected = AppManager.getSelected();
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int key_width = AppManager.keyWidth;

            // マウス位置にある音符を検索
            if ( item == null ) {
                if ( e.Button == BMouseButtons.Left ) {
                    AppManager.setWholeSelectedIntervalEnabled( false );
                }
                #region 音符がなかった時
#if DEBUG
                AppManager.debugWriteLine( "    No Event" );
#endif
                if ( AppManager.getLastSelectedEvent() != null ) {
                    executeLyricChangeCommand();
                }
                boolean start_mouse_hover_generator = true;

                // CTRLキーを押しながら範囲選択
                if ( (modefier & s_modifier_key) == s_modifier_key ) {
                    AppManager.setWholeSelectedIntervalEnabled( true );
                    AppManager.setCurveSelectedIntervalEnabled( false );
                    AppManager.clearSelectedPoint();
                    int startClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        startClock = doQuantize( startClock, unit );
                    }
                    AppManager.mWholeSelectedInterval = new SelectedRegion( startClock );
                    AppManager.mWholeSelectedInterval.setEnd( startClock );
                    AppManager.mIsPointerDowned = true;
                } else {
                    DrawObject vibrato_dobj = null;
                    if ( selected_tool == EditTool.LINE || selected_tool == EditTool.PENCIL ) {
                        // ビブラート範囲の編集
                        int px_vibrato_length = 0;
                        mVibratoEditingId = -1;
                        Rectangle pxFound = new Rectangle();
                        Vector<DrawObject> target_list = AppManager.mDrawObjects.get( selected - 1 );
                        int count = target_list.size();
                        for ( int i = 0; i < count; i++ ) {
                            DrawObject dobj = target_list.get( i );
                            if ( dobj.mRectangleInPixel.width <= dobj.mVibratoDelayInPixel ) {
                                continue;
                            }
                            if ( dobj.mRectangleInPixel.x + key_width + dobj.mRectangleInPixel.width - stdx < 0 ) {
                                continue;
                            } else if ( pictPianoRoll.getWidth() < dobj.mRectangleInPixel.x + key_width - stdx ) {
                                break;
                            }
                            Rectangle rc = new Rectangle( dobj.mRectangleInPixel.x + key_width + dobj.mVibratoDelayInPixel - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                dobj.mRectangleInPixel.y + (int)(100 * AppManager.getScaleY()) - stdy,
                                                _EDIT_HANDLE_WIDTH,
                                                (int)(100 * AppManager.getScaleY()) );
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                vibrato_dobj = dobj;
                                //vibrato_found = true;
                                mVibratoEditingId = dobj.mInternalID;
                                pxFound.x = dobj.mRectangleInPixel.x;
                                pxFound.y = dobj.mRectangleInPixel.y;
                                pxFound.width = dobj.mRectangleInPixel.width;
                                pxFound.height = dobj.mRectangleInPixel.height;// = new Rectangle dobj.mRectangleInPixel;
                                pxFound.x += key_width;
                                px_vibrato_length = dobj.mRectangleInPixel.width - dobj.mVibratoDelayInPixel;
                                break;
                            }
                        }
                        if ( vibrato_dobj != null ) {
                            int clock = AppManager.clockFromXCoord( pxFound.x + pxFound.width - px_vibrato_length - stdx );
                            int note = vibrato_dobj.mNote - 1;// AppManager.noteFromYCoord( pxFound.y + (int)(100 * AppManager.getScaleY()) - stdy );
                            int length = vibrato_dobj.mClock + vibrato_dobj.mLength - clock;// (int)(pxFound.width * AppManager.getScaleXInv());
                            AppManager.mAddingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.mAddingEvent.ID.type = VsqIDType.Anote;
                            AppManager.mAddingEvent.ID.Note = note;
                            AppManager.mAddingEvent.ID.setLength( length );
                            AppManager.mAddingEventLength = vibrato_dobj.mLength;
                            AppManager.mAddingEvent.ID.VibratoDelay = length - (int)(px_vibrato_length * AppManager.getScaleXInv());
                            AppManager.setEditMode( EditMode.EDIT_VIBRATO_DELAY );
                            start_mouse_hover_generator = false;
                        }
                    }
                    if ( vibrato_dobj == null ) {
                        if ( (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE) &&
                            e.Button == BMouseButtons.Left &&
                            e.X >= key_width ) {
                            int clock = AppManager.clockFromXCoord( e.X );
                            if ( AppManager.getVsqFile().getPreMeasureClocks() - AppManager.editorConfig.PxTolerance * AppManager.getScaleXInv() <= clock ) {
                                //10ピクセルまでは許容範囲
                                if ( AppManager.getVsqFile().getPreMeasureClocks() > clock ) { //だけど矯正するよ。
                                    clock = AppManager.getVsqFile().getPreMeasureClocks();
                                }
                                int note = AppManager.noteFromYCoord( e.Y );
                                AppManager.clearSelectedEvent();
                                int unit = AppManager.getPositionQuantizeClock();
                                int new_clock = doQuantize( clock, unit );
                                AppManager.mAddingEvent = new VsqEvent( new_clock, new VsqID( 0 ) );
                                // デフォルトの歌唱スタイルを適用する
                                AppManager.editorConfig.applyDefaultSingerStyle( AppManager.mAddingEvent.ID );
                                if ( mPencilMode.getMode() == PencilModeEnum.Off ) {
                                    AppManager.setEditMode( EditMode.ADD_ENTRY );
                                    mButtonInitial = new Point( e.X, e.Y );
                                    AppManager.mAddingEvent.ID.setLength( 0 );
                                    AppManager.mAddingEvent.ID.Note = note;
                                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
#if DEBUG
                                    AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                                } else {
                                    AppManager.setEditMode( EditMode.ADD_FIXED_LENGTH_ENTRY );
                                    AppManager.mAddingEvent.ID.setLength( mPencilMode.getUnitLength() );
                                    AppManager.mAddingEvent.ID.Note = note;
                                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                                }
                            } else {
#if !JAVA
                                SystemSounds.Asterisk.Play();
#endif
                            }
#if ENABLE_SCRIPT
                        } else if ( (selected_tool == EditTool.ARROW || selected_tool == EditTool.PALETTE_TOOL) && e.Button == BMouseButtons.Left ) {
#else
                        } else if ( (selected_tool == EditTool.ARROW) && e.Button == BMouseButtons.Left ) {
#endif
                            AppManager.setWholeSelectedIntervalEnabled( false );
                            AppManager.clearSelectedEvent();
                            AppManager.mMouseDownLocation = new Point( e.X + stdx, e.Y + stdy );
                            AppManager.mIsPointerDowned = true;
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                        }
                    }
                }
                if ( e.Button == BMouseButtons.Right && !AppManager.editorConfig.PlayPreviewWhenRightClick ) {
                    start_mouse_hover_generator = false;
                }
#if ENABLE_MOUSEHOVER
                if ( start_mouse_hover_generator ) {
                    mMouseHoverThread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    mMouseHoverThread.Start( AppManager.noteFromYCoord( e.Y ) );
                }
#endif
                #endregion
            } else {
                #region 音符があった時
#if DEBUG
                AppManager.debugWriteLine( "    Event Found" );
#endif
                if ( AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                    executeLyricChangeCommand();
                }
                hideInputTextBox();
                if ( selected_tool != EditTool.ERASER ) {
#if ENABLE_MOUSEHOVER
                    mMouseHoverThread = new Thread( new ParameterizedThreadStart( MouseHoverEventGenerator ) );
                    mMouseHoverThread.Start( item.ID.Note );
#endif
                }

                // まず、両端の編集モードに移行可能かどうか調べる
                if ( item.ID.type != VsqIDType.Aicon ||
                     (item.ID.type == VsqIDType.Aicon && !item.ID.IconDynamicsHandle.isDynaffType()) ) {
#if ENABLE_SCRIPT
                    if ( selected_tool != EditTool.ERASER && selected_tool != EditTool.PALETTE_TOOL && e.Button == BMouseButtons.Left ) {
#else
                    if ( selected_tool != EditTool.ERASER && e.Button == BMouseButtons.Left ) {
#endif
                        int min_width = 4 * _EDIT_HANDLE_WIDTH;
                        for ( Iterator<DrawObject> itr = AppManager.mDrawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                            DrawObject dobj = itr.next();

                            int edit_handle_width = _EDIT_HANDLE_WIDTH;
                            if ( dobj.mRectangleInPixel.width < min_width ) {
                                edit_handle_width = dobj.mRectangleInPixel.width / 4;
                            }

                            // 左端の"のり代"にマウスがあるかどうか
                            Rectangle rc = new Rectangle( dobj.mRectangleInPixel.x - stdx + key_width,
                                                          dobj.mRectangleInPixel.y - stdy,
                                                          edit_handle_width,
                                                          dobj.mRectangleInPixel.height );
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.EDIT_LEFT_EDGE );
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
#if JAVA
                                setCursor( new Cursor( Cursor.W_RESIZE_CURSOR ) );
#else
                                this.Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                                refreshScreen();
#if DEBUG
                                AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
#endif
                                return;
                            }

                            // 右端の糊代にマウスがあるかどうか
                            rc = new Rectangle( dobj.mRectangleInPixel.x + key_width + dobj.mRectangleInPixel.width - stdx - edit_handle_width,
                                                dobj.mRectangleInPixel.y - stdy,
                                                edit_handle_width,
                                                dobj.mRectangleInPixel.height );
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.EDIT_RIGHT_EDGE );
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
#if JAVA
                                setCursor( new Cursor( Cursor.E_RESIZE_CURSOR ) );
#else
                                this.Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                                refreshScreen();
                                return;
                            }
                        }
                    }
                }

                if ( e.Button == BMouseButtons.Left || e.Button == BMouseButtons.Middle ) {
#if ENABLE_SCRIPT
                    if ( selected_tool == EditTool.PALETTE_TOOL ) {
                        AppManager.setWholeSelectedIntervalEnabled( false );
                        AppManager.setEditMode( EditMode.NONE );
                        AppManager.clearSelectedEvent();
                        AppManager.addSelectedEvent( item.InternalID );
                    } else
#endif
                        if ( selected_tool != EditTool.ERASER ) {
                            mMouseMoveInit = new Point( e.X + stdx, e.Y + stdy );
                            int head_x = AppManager.xCoordFromClocks( item.Clock );
                            mMouseMoveOffset = e.X - head_x;
                            if ( (modefier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                                // シフトキー同時押しによる範囲選択
                                Vector<Integer> add_required = new Vector<Integer>();
                                add_required.add( item.InternalID );

                                // 現在の選択アイテムがある場合，
                                // 直前に選択したアイテムと，現在選択しようとしているアイテムとの間にあるアイテムを
                                // 全部選択する
                                SelectedEventEntry sel = AppManager.getLastSelectedEvent();
                                if ( sel != null ) {
                                    int last_id = sel.original.InternalID;
                                    int last_clock = 0;
                                    int this_clock = 0;
                                    boolean this_found = false, last_found = false;
                                    for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                                        VsqEvent ev = itr.next();
                                        if ( ev.InternalID == last_id ) {
                                            last_clock = ev.Clock;
                                            last_found = true;
                                        } else if ( ev.InternalID == item.InternalID ) {
                                            this_clock = ev.Clock;
                                            this_found = true;
                                        }
                                        if ( last_found && this_found ) {
                                            break;
                                        }
                                    }
                                    int start = Math.Min( last_clock, this_clock );
                                    int end = Math.Max( last_clock, this_clock );
                                    for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                                        VsqEvent ev = itr.next();
                                        if ( start <= ev.Clock && ev.Clock <= end ) {
                                            if ( !add_required.contains( ev.InternalID ) ) {
                                                add_required.add( ev.InternalID );
                                            }
                                        }
                                    }
                                }
                                AppManager.addSelectedEventAll( add_required );
                            } else if ( (modefier & s_modifier_key) == s_modifier_key ) {
                                // CTRLキーを押しながら選択／選択解除
                                if ( AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    AppManager.removeSelectedEvent( item.InternalID );
                                } else {
                                    AppManager.addSelectedEvent( item.InternalID );
                                }
                            } else {
                                if ( !AppManager.isSelectedEventContains( selected, item.InternalID ) ) {
                                    // MouseDownしたアイテムが、まだ選択されていなかった場合。当該アイテム単独に選択しなおす
                                    AppManager.clearSelectedEvent();
                                }
                                AppManager.addSelectedEvent( item.InternalID );
                            }

                            // 範囲選択モードで、かつマウス位置の音符がその範囲に入っていた場合にのみ、MOVE_ENTRY_WHOLE_WAIT_MOVEに移行
                            if ( AppManager.isWholeSelectedIntervalEnabled() &&
                                 AppManager.mWholeSelectedInterval.getStart() <= item.Clock &&
                                 item.Clock <= AppManager.mWholeSelectedInterval.getEnd() ) {
                                AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE );
                                AppManager.mWholeSelectedIntervalStartForMoving = AppManager.mWholeSelectedInterval.getStart();
                            } else {
                                AppManager.setWholeSelectedIntervalEnabled( false );
                                AppManager.setEditMode( EditMode.MOVE_ENTRY_WAIT_MOVE );
                            }

                            setCursor( new Cursor( java.awt.Cursor.HAND_CURSOR ) );
#if DEBUG
                            AppManager.debugWriteLine( "    EditMode=" + AppManager.getEditMode() );
                            AppManager.debugWriteLine( "    m_config.SelectedEvent.Count=" + AppManager.getSelectedEventCount() );
#endif
                        }
                }
                #endregion
            }
            refreshScreen();
        }

        public void pictPianoRoll_MouseMove( Object sender, BMouseEventArgs e )
        {
            if ( mFormActivated ) {
#if ENABLE_PROPERTY
#if JAVA
                if ( AppManager.mInputTextBox != null && !AppManager.mInputTextBox.isVisible() && !AppManager.propertyPanel.isEditing() ) {
#else
                if ( AppManager.mInputTextBox != null && !AppManager.mInputTextBox.IsDisposed && !AppManager.mInputTextBox.isVisible() && !AppManager.propertyPanel.isEditing() ) {
#endif
#else
#if JAVA
                if ( AppManager.mInputTextBox != null && !AppManager.mInputTextBox.isVisible() ) {
#else
                if ( AppManager.mInputTextBox != null && !AppManager.mInputTextBox.IsDisposed && !AppManager.mInputTextBox.isVisible() ) {
#endif
#endif
                    pictPianoRoll.requestFocus();
                }
            }

            EditMode edit_mode = AppManager.getEditMode();
            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            int selected = AppManager.getSelected();
            EditTool selected_tool = AppManager.getSelectedTool();

            if ( edit_mode == EditMode.CURVE_ON_PIANOROLL && AppManager.mCurveOnPianoroll ) {
                pictPianoRoll.mMouseTracer.append( e.X + stdx, e.Y + stdy );
                if ( !timer.isRunning() ) {
                    refreshScreen();
                }
                return;
            }

            if ( !mMouseMoved && edit_mode == EditMode.MIDDLE_DRAG ) {
#if JAVA
                setCursor( new Cursor( java.awt.Cursor.MOVE_CURSOR ) );
#else
                this.Cursor = HAND;
#endif
            }

            if ( e.X != mButtonInitial.x || e.Y != mButtonInitial.y ) {
                mMouseMoved = true;
            }
            if ( !(edit_mode == EditMode.MIDDLE_DRAG) && AppManager.isPlaying() ) {
                return;
            }

            if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ||
                 edit_mode == EditMode.MOVE_ENTRY_WHOLE_WAIT_MOVE ) {
                int x = e.X + stdx;
                int y = e.Y + stdy;
                if ( mMouseMoveInit.x != x || mMouseMoveInit.y != y ) {
                    if ( edit_mode == EditMode.MOVE_ENTRY_WAIT_MOVE ) {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY );
                        edit_mode = EditMode.MOVE_ENTRY;
                    } else {
                        AppManager.setEditMode( EditMode.MOVE_ENTRY_WHOLE );
                        edit_mode = EditMode.MOVE_ENTRY_WHOLE;
                    }
                }
            }

#if ENABLE_MOUSEHOVER
            if ( mMouseMoved && mMouseHoverThread != null ) {
                mMouseHoverThread.Abort();
            }
#endif

            int clock = AppManager.clockFromXCoord( e.X );
            if ( mMouseDowned ) {
                if ( mExtDragX == ExtDragXMode.NONE ) {
                    if ( AppManager.keyWidth > e.X ) {
                        mExtDragX = ExtDragXMode.LEFT;
                    } else if ( pictPianoRoll.getWidth() < e.X ) {
                        mExtDragX = ExtDragXMode.RIGHT;
                    }
                } else {
                    if ( AppManager.keyWidth <= e.X && e.X <= pictPianoRoll.getWidth() ) {
                        mExtDragX = ExtDragXMode.NONE;
                    }
                }

                if ( mExtDragY == ExtDragYMode.NONE ) {
                    if ( 0 > e.Y ) {
                        mExtDragY = ExtDragYMode.UP;
                    } else if ( pictPianoRoll.getHeight() < e.Y ) {
                        mExtDragY = ExtDragYMode.DOWN;
                    }
                } else {
                    if ( 0 <= e.Y && e.Y <= pictPianoRoll.getHeight() ) {
                        mExtDragY = ExtDragYMode.NONE;
                    }
                }
            } else {
                mExtDragX = ExtDragXMode.NONE;
                mExtDragY = ExtDragYMode.NONE;
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                mExtDragX = ExtDragXMode.NONE;
                mExtDragY = ExtDragYMode.NONE;
            }

            double now = 0, dt = 0;
            if ( mExtDragX != ExtDragXMode.NONE || mExtDragY != ExtDragYMode.NONE ) {
                now = PortUtil.getCurrentTime();
                dt = now - mTimerDragLastIgnitted;
            }
            if ( mExtDragX == ExtDragXMode.RIGHT || mExtDragX == ExtDragXMode.LEFT ) {
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                double d_draft;
                if ( mExtDragX == ExtDragXMode.LEFT ) {
                    px_move *= -1;
                }
                int left_clock = AppManager.clockFromXCoord( AppManager.keyWidth );
                float inv_scale_x = AppManager.getScaleXInv();
                int dclock = (int)(px_move * inv_scale_x);
                d_draft = 5 * inv_scale_x + left_clock + dclock;
                if ( d_draft < 0.0 ) {
                    d_draft = 0.0;
                }
                int draft = (int)d_draft;
                if ( hScroll.getMaximum() < draft ) {
                    if ( edit_mode == EditMode.ADD_ENTRY ||
                         edit_mode == EditMode.MOVE_ENTRY ||
                         edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ||
                         edit_mode == EditMode.DRAG_DROP ) {
                        hScroll.setMaximum( draft );
                    } else {
                        draft = hScroll.getMaximum();
                    }
                }
                if ( draft < hScroll.getMinimum() ) {
                    draft = hScroll.getMinimum();
                }
                hScroll.setValue( draft );
            }
            if ( mExtDragY == ExtDragYMode.UP || mExtDragY == ExtDragYMode.DOWN ) {
                int min = vScroll.getMinimum();
                int max = vScroll.getMaximum() - vScroll.getVisibleAmount();
                int px_move = AppManager.editorConfig.MouseDragIncrement;
                if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                    px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                }
                px_move += 50;
                if ( mExtDragY == ExtDragYMode.UP ) {
                    px_move *= -1;
                }
                int draft = vScroll.getValue() + px_move;
                if ( draft < 0 ) {
                    draft = 0;
                }
                int df = (int)draft;
                if ( df < min ) {
                    df = min;
                } else if ( max < df ) {
                    df = max;
                }
                vScroll.setValue( df );
            }
            if ( mExtDragX != ExtDragXMode.NONE || mExtDragY != ExtDragYMode.NONE ) {
                mTimerDragLastIgnitted = now;
            }

            // 選択範囲にあるイベントを選択．
            if ( AppManager.mIsPointerDowned ) {
                if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                    int endClock = AppManager.clockFromXCoord( e.X );
                    if ( AppManager.editorConfig.CurveSelectingQuantized ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        endClock = doQuantize( endClock, unit );
                    }
                    AppManager.mWholeSelectedInterval.setEnd( endClock );
                } else {
                    Point mouse = new Point( e.X + stdx, e.Y + stdy );
                    int tx, ty, twidth, theight;
                    int lx = AppManager.mMouseDownLocation.x;
                    if ( lx < mouse.x ) {
                        tx = lx;
                        twidth = mouse.x - lx;
                    } else {
                        tx = mouse.x;
                        twidth = lx - mouse.x;
                    }
                    int ly = AppManager.mMouseDownLocation.y;
                    if ( ly < mouse.y ) {
                        ty = ly;
                        theight = mouse.y - ly;
                    } else {
                        ty = mouse.y;
                        theight = ly - mouse.y;
                    }

                    Rectangle rect = new Rectangle( tx, ty, twidth, theight );
                    Vector<Integer> add_required = new Vector<Integer>();
                    int internal_id = -1;
                    for ( Iterator<DrawObject> itr = AppManager.mDrawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                        DrawObject dobj = itr.next();
                        int x0 = dobj.mRectangleInPixel.x + AppManager.keyWidth;
                        int x1 = dobj.mRectangleInPixel.x + AppManager.keyWidth + dobj.mRectangleInPixel.width;
                        int y0 = dobj.mRectangleInPixel.y;
                        int y1 = dobj.mRectangleInPixel.y + dobj.mRectangleInPixel.height;
                        internal_id = dobj.mInternalID;
                        if ( x1 < tx ) {
                            continue;
                        }
                        if ( tx + twidth < x0 ) {
                            break;
                        }
                        boolean found = Utility.isInRect( new Point( x0, y0 ), rect ) |
                                        Utility.isInRect( new Point( x0, y1 ), rect ) |
                                        Utility.isInRect( new Point( x1, y0 ), rect ) |
                                        Utility.isInRect( new Point( x1, y1 ), rect );
                        if ( found ) {
                            add_required.add( internal_id );
                        } else {
                            if ( x0 <= tx && tx + twidth <= x1 ) {
                                if ( ty < y0 ) {
                                    if ( y0 <= ty + theight ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( y0 <= ty && ty < y1 ) {
                                    add_required.add( internal_id );
                                }
                            } else if ( y0 <= ty && ty + theight <= y1 ) {
                                if ( tx < x0 ) {
                                    if ( x0 <= tx + twidth ) {
                                        add_required.add( internal_id );
                                    }
                                } else if ( x0 <= tx && tx < x1 ) {
                                    add_required.add( internal_id );
                                }
                            }
                        }
                    }
                    Vector<Integer> remove_required = new Vector<Integer>();
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry selectedEvent = itr.next();
                        if ( !add_required.contains( selectedEvent.original.InternalID ) ) {
                            remove_required.add( selectedEvent.original.InternalID );
                        }
                    }
                    if ( remove_required.size() > 0 ) {
                        AppManager.removeSelectedEventRange( PortUtil.convertIntArray( remove_required.toArray( new Integer[] { } ) ) );
                    }
                    for ( Iterator<Integer> itr = add_required.iterator(); itr.hasNext(); ) {
                        int id = itr.next();
                        if ( AppManager.isSelectedEventContains( selected, id ) ) {
                            itr.remove();
                        }
                    }
                    AppManager.addSelectedEventAll( add_required );
                }
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                #region MiddleDrag
                int drafth = computeHScrollValueForMiddleDrag( e.X );
                int draftv = computeVScrollValueForMiddleDrag( e.Y );
                boolean moved = false;
                if ( drafth != hScroll.getValue() ) {
                    //moved = true;
                    //hScroll.beQuiet();
                    hScroll.setValue( drafth );
                }
                if ( draftv != vScroll.getValue() ) {
                    //moved = true;
                    //vScroll.beQuiet();
                    vScroll.setValue( draftv );
                }
                //if ( moved ) {
                //    vScroll.setQuiet( false );
                //    hScroll.setQuiet( false );
                //    refreshScreen( true );
                //}
                refreshScreen( true );
                if ( AppManager.isPlaying() ) {
                    return;
                }
                #endregion
                return;
            } else if ( edit_mode == EditMode.ADD_ENTRY ) {
                #region ADD_ENTRY
                int unit = AppManager.getLengthQuantizeClock();
                int length = clock - AppManager.mAddingEvent.Clock;
                int odd = length % unit;
                int new_length = length - odd;

                if ( unit * AppManager.getScaleX() > 10 ) { //これをしないと、グリッド2個分増えることがある
                    int next_clock = AppManager.clockFromXCoord( e.X + 10 );
                    int next_length = next_clock - AppManager.mAddingEvent.Clock;
                    int next_new_length = next_length - (next_length % unit);
                    if ( next_new_length == new_length + unit ) {
                        new_length = next_new_length;
                    }
                }

                if ( new_length <= 0 ) {
                    new_length = 0;
                }
                AppManager.mAddingEvent.ID.setLength( new_length );
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY || edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
                #region MOVE_ENTRY, MOVE_ENTRY_WHOLE
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    int note = AppManager.noteFromYCoord( e.Y );                           // 現在のマウス位置でのnote
                    int note_init = original.ID.Note;
                    int dnote = (edit_mode == EditMode.MOVE_ENTRY) ? note - note_init : 0;

                    int tclock = AppManager.clockFromXCoord( e.X - mMouseMoveOffset );
                    int clock_init = original.Clock;

                    int dclock = tclock - clock_init;

                    if ( AppManager.editorConfig.getPositionQuantize() != QuantizeMode.off ) {
                        int unit = AppManager.getPositionQuantizeClock();
                        int new_clock = doQuantize( original.Clock + dclock, unit );
                        dclock = new_clock - clock_init;
                    }

                    AppManager.mWholeSelectedIntervalStartForMoving = AppManager.mWholeSelectedInterval.getStart() + dclock;

                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int new_clock = item.original.Clock + dclock;
                        int new_note = item.original.ID.Note + dnote;
                        item.editing.Clock = new_clock;
                        item.editing.ID.Note = new_note;
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE ) {
                #region EditLeftEdge
                int unit = AppManager.getLengthQuantizeClock();
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock_init = original.Clock;
                int dclock = clock - clock_init;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int end_clock = item.original.Clock + item.original.ID.getLength();
                    int new_clock = item.original.Clock + dclock;
                    int new_length = doQuantize( end_clock - new_clock, unit );
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    item.editing.Clock = end_clock - new_length;
                    if ( AppManager.vibratoLengthEditingRule == VibratoLengthEditingRule.PERCENTAGE ) {
                        double percentage = item.original.ID.VibratoDelay / (double)item.original.ID.getLength() * 100.0;
                        int newdelay = (int)(new_length * percentage / 100.0);
                        item.editing.ID.VibratoDelay = newdelay;
                    }
                    item.editing.ID.setLength( new_length );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EditRightEdge
                int unit = AppManager.getLengthQuantizeClock();

                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int dlength = clock - (original.Clock + original.ID.getLength());
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int new_length = doQuantize( item.original.ID.getLength() + dlength, unit );
                    if ( new_length <= 0 ) {
                        new_length = unit;
                    }
                    if ( AppManager.vibratoLengthEditingRule == VibratoLengthEditingRule.PERCENTAGE ) {
                        double percentage = item.original.ID.VibratoDelay / (double)item.original.ID.getLength() * 100.0;
                        int newdelay = (int)(new_length * percentage / 100.0);
                        item.editing.ID.VibratoDelay = newdelay;
                    }
                    item.editing.ID.setLength( new_length );
#if DEBUG
                    sout.println( "FormMain#pictPianoRoll_MouseMove; length(before,after)=(" + item.original.ID.getLength() + "," + item.editing.ID.getLength() + ")" );
#endif
                }
                #endregion
            } else if ( edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddFixedLengthEntry
                int note = AppManager.noteFromYCoord( e.Y );
                int unit = AppManager.getPositionQuantizeClock();
                int new_clock = doQuantize( AppManager.clockFromXCoord( e.X ), unit );
                AppManager.mAddingEvent.ID.Note = note;
                AppManager.mAddingEvent.Clock = new_clock;
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                int new_vibrato_start = clock;
                int old_vibrato_end = AppManager.mAddingEvent.Clock + AppManager.mAddingEvent.ID.getLength();
                int new_vibrato_length = old_vibrato_end - new_vibrato_start;
                int max_length = (int)(AppManager.mAddingEventLength - _PX_ACCENT_HEADER * AppManager.getScaleXInv());
                if ( max_length < 0 ) {
                    max_length = 0;
                }
                if ( new_vibrato_length > max_length ) {
                    new_vibrato_start = old_vibrato_end - max_length;
                    new_vibrato_length = max_length;
                }
                if ( new_vibrato_length < 0 ) {
                    new_vibrato_start = old_vibrato_end;
                    new_vibrato_length = 0;
                }
                AppManager.mAddingEvent.Clock = new_vibrato_start;
                AppManager.mAddingEvent.ID.setLength( new_vibrato_length );
                if ( !timer.isRunning() ) {
                    refreshScreen();
                }
                #endregion
                return;
            } else if ( edit_mode == EditMode.DRAG_DROP ) {
                #region DRAG_DROP
                // クオンタイズの処理
                int unit = AppManager.getPositionQuantizeClock();
                int clock1 = doQuantize( clock, unit );
                int note = AppManager.noteFromYCoord( e.Y );
                AppManager.mAddingEvent.Clock = clock1;
                AppManager.mAddingEvent.ID.Note = note;
                #endregion
            }

            // カーソルの形を決める
            if ( !mMouseDowned &&
                 edit_mode != EditMode.CURVE_ON_PIANOROLL &&
                 !(AppManager.mCurveOnPianoroll && (selected_tool == EditTool.PENCIL || selected_tool == EditTool.LINE)) ) {
                boolean split_cursor = false;
                boolean hand_cursor = false;
                int min_width = 4 * _EDIT_HANDLE_WIDTH;
                for ( Iterator<DrawObject> itr = AppManager.mDrawObjects.get( selected - 1 ).iterator(); itr.hasNext(); ) {
                    DrawObject dobj = itr.next();
                    Rectangle rc;
                    if ( dobj.mType != DrawObjectType.Dynaff ) {
                        int edit_handle_width = _EDIT_HANDLE_WIDTH;
                        if ( dobj.mRectangleInPixel.width < min_width ) {
                            edit_handle_width = dobj.mRectangleInPixel.width / 4;
                        }

                        // 音符左側の編集領域
                        rc = new Rectangle(
                                            dobj.mRectangleInPixel.x + AppManager.keyWidth - stdx,
                                            dobj.mRectangleInPixel.y - stdy,
                                            edit_handle_width,
                                            (int)(100 * AppManager.getScaleY()) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                            split_cursor = true;
                            break;
                        }

                        // 音符右側の編集領域
                        rc = new Rectangle( dobj.mRectangleInPixel.x + AppManager.keyWidth + dobj.mRectangleInPixel.width - stdx - edit_handle_width,
                                            dobj.mRectangleInPixel.y - stdy,
                                            edit_handle_width,
                                            (int)(100 * AppManager.getScaleY()) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                            split_cursor = true;
                            break;
                        }
                    }

                    // 音符本体
                    rc = new Rectangle( dobj.mRectangleInPixel.x + AppManager.keyWidth - stdx,
                                        dobj.mRectangleInPixel.y - stdy,
                                        dobj.mRectangleInPixel.width,
                                        dobj.mRectangleInPixel.height );
                    if ( dobj.mType == DrawObjectType.Note ) {
                        if ( AppManager.editorConfig.ShowExpLine && !dobj.mIsOverlapped ) {
                            rc.height *= 2;
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                // ビブラートの開始位置
                                rc = new Rectangle( dobj.mRectangleInPixel.x + AppManager.keyWidth + dobj.mVibratoDelayInPixel - stdx - _EDIT_HANDLE_WIDTH / 2,
                                                    dobj.mRectangleInPixel.y + (int)(100 * AppManager.getScaleY()) - stdy,
                                                    _EDIT_HANDLE_WIDTH,
                                                    (int)(100 * AppManager.getScaleY()) );
                                if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                    split_cursor = true;
                                    break;
                                } else {
                                    hand_cursor = true;
                                    break;
                                }
                            }
                        } else {
                            if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                                hand_cursor = true;
                                break;
                            }
                        }
                    } else {
                        if ( Utility.isInRect( new Point( e.X, e.Y ), rc ) ) {
                            hand_cursor = true;
                            break;
                        }
                    }
                }

                if ( split_cursor ) {
#if JAVA
                    setCursor( new Cursor( java.awt.Cursor.E_RESIZE_CURSOR ) );
#else
                    Cursor = System.Windows.Forms.Cursors.VSplit;
#endif
                } else if ( hand_cursor ) {
                    setCursor( new Cursor( java.awt.Cursor.HAND_CURSOR ) );
                } else {
                    setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
                }
            }
            if ( !timer.isRunning() ) {
                refreshScreen( true );
            }
        }

        /// <summary>
        /// ピアノロールからマウスボタンが離れたときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void pictPianoRoll_MouseUp( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "pictureBox1_MouseUp" );
            AppManager.debugWriteLine( "    m_config.EditMode=" + AppManager.getEditMode() );
#endif
            AppManager.mIsPointerDowned = false;
            mMouseDowned = false;

            int modefiers = PortUtil.getCurrentModifierKey();

            EditMode edit_mode = AppManager.getEditMode();
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            CurveType selected_curve = trackSelector.getSelectedCurve();
            int stdx = AppManager.getStartToDrawX();
            int stdy = AppManager.getStartToDrawY();
            double d2_13 = 8192; // = 2^13
            int track_height = (int)(100 * AppManager.getScaleY());
            int half_track_height = track_height / 2;

            if ( edit_mode == EditMode.CURVE_ON_PIANOROLL ) {
                if ( pictPianoRoll.mMouseTracer.size() > 1 ) {
                    // マウスの軌跡の左右端(px)
                    int px_start = pictPianoRoll.mMouseTracer.firstKey();
                    int px_end = pictPianoRoll.mMouseTracer.lastKey();

                    // マウスの軌跡の左右端(クロック)
                    int cl_start = AppManager.clockFromXCoord( px_start - stdx );
                    int cl_end = AppManager.clockFromXCoord( px_end - stdx );

                    // 編集が行われたかどうか
                    boolean edited = false;
                    // 作業用のPITカーブのコピー
                    VsqBPList pit = (VsqBPList)vsq_track.getCurve( "pit" ).clone();
                    VsqBPList pbs = (VsqBPList)vsq_track.getCurve( "pbs" ); // こっちはクローンしないよ

                    // トラック内の全音符に対して、マウス軌跡と被っている部分のPITを編集する
                    for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent item = itr.next();
                        int cl_item_start = item.Clock;
                        if ( cl_end < cl_item_start ) {
                            break;
                        }
                        int cl_item_end = cl_item_start + item.ID.getLength();
                        if ( cl_item_end < cl_start ) {
                            continue;
                        }

                        // ここに到達するってことは、pitに編集が加えられるってこと。
                        edited = true;

                        // マウス軌跡と被っている部分のPITを削除
                        int cl_remove_start = Math.Max( cl_item_start, cl_start );
                        int cl_remove_end = Math.Min( cl_item_end, cl_end );
                        int value_at_remove_end = pit.getValue( cl_remove_end );
                        int value_at_remove_start = pit.getValue( cl_remove_start );
                        Vector<Integer> remove = new Vector<Integer>();
                        for ( Iterator<Integer> itr2 = pit.keyClockIterator(); itr2.hasNext(); ) {
                            int clock = itr2.next();
                            if ( cl_remove_start <= clock && clock <= cl_remove_end ) {
                                remove.add( clock );
                            }
                        }
                        for ( Iterator<Integer> itr2 = remove.iterator(); itr2.hasNext(); ) {
                            int clock = itr2.next();
                            pit.remove( clock );
                        }
                        remove = null;

                        int px_item_start = AppManager.xCoordFromClocks( cl_item_start ) + stdx;
                        int px_item_end = AppManager.xCoordFromClocks( cl_item_end ) + stdx;

                        int lastv = value_at_remove_start;
                        boolean cl_item_end_added = false;
                        boolean cl_item_start_added = false;
                        int last_px = 0, last_py = 0;
                        for ( Iterator<Point> itr2 = pictPianoRoll.mMouseTracer.iterator(); itr2.hasNext(); ) {
                            Point p = itr2.next();
                            if ( p.x < px_item_start ) {
                                last_px = p.x;
                                last_py = p.y;
                                continue;
                            }
                            if ( px_item_end < p.x ) {
                                break;
                            }

                            int clock = AppManager.clockFromXCoord( p.x - stdx );
                            if ( clock < cl_item_start ) {
                                last_px = p.x;
                                last_py = p.y;
                                continue;
                            } else if ( cl_item_end < clock ) {
                                break;
                            }
                            double note = AppManager.noteFromYCoordDoublePrecision( p.y - stdy - half_track_height );
                            int v_pit = (int)(d2_13 / (double)pbs.getValue( clock ) * (note - item.ID.Note));

                            // 正規化
                            if ( v_pit < pit.getMinimum() ) {
                                v_pit = pit.getMinimum();
                            } else if ( pit.getMaximum() < v_pit ) {
                                v_pit = pit.getMaximum();
                            }

                            if ( cl_item_start < clock && !cl_item_start_added &&
                                 cl_start <= cl_item_start && cl_item_start < cl_end ) {
                                // これから追加しようとしているデータ点の時刻が、音符の開始時刻よりも後なんだけれど、
                                // 音符の開始時刻におけるデータをまだ書き込んでない場合
                                double a = (p.y - last_py) / (double)(p.x - last_px);
                                double x_at_clock = AppManager.xCoordFromClocks( cl_item_start ) + stdx;
                                double ext_y = last_py + a * (x_at_clock - last_px);
                                double tnote = AppManager.noteFromYCoordDoublePrecision( (int)(ext_y - stdy - half_track_height) );
                                int t_vpit = (int)(d2_13 / (double)pbs.getValue( cl_item_start ) * (tnote - item.ID.Note));
                                pit.add( cl_item_start, t_vpit );
                                lastv = t_vpit;
                                cl_item_start_added = true;
                            }

                            // 直前の値と違っている場合にのみ追加
                            if ( v_pit != lastv ) {
                                pit.add( clock, v_pit );
                                lastv = v_pit;
                                if ( clock == cl_item_end ) {
                                    cl_item_end_added = true;
                                } else if ( clock == cl_item_start ) {
                                    cl_item_start_added = true;
                                }
                            }
                        }

                        if ( !cl_item_end_added &&
                             cl_start <= cl_item_end && cl_item_end <= cl_end ) {
                            pit.add( cl_item_end, lastv );
                        }

                        pit.add( cl_remove_end, value_at_remove_end );
                    }

                    // 編集操作が行われた場合のみ、コマンドを発行
                    if ( edited ) {
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandTrackCurveReplace( selected, "PIT", pit ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
                pictPianoRoll.mMouseTracer.clear();
                AppManager.setEditMode( EditMode.NONE );
                return;
            }

            if ( edit_mode == EditMode.MIDDLE_DRAG ) {
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
            } else if ( edit_mode == EditMode.ADD_ENTRY || edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY ) {
                #region AddEntry || AddFixedLengthEntry
                if ( AppManager.getSelected() >= 0 ) {
                    if ( (edit_mode == EditMode.ADD_FIXED_LENGTH_ENTRY) ||
                         (edit_mode == EditMode.ADD_ENTRY && (mButtonInitial.x != e.X || mButtonInitial.y != e.Y) && AppManager.mAddingEvent.ID.getLength() > 0) ) {
                        if ( AppManager.mAddingEvent.Clock < vsq.getPreMeasureClocks() ) {
#if !JAVA
                            SystemSounds.Asterisk.Play();
#endif
                        } else {
                            fixAddingEvent();
                        }
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY ) {
                #region MoveEntry
#if DEBUG
                sout.println( "FormMain#pictPianoRoll_MouseUp; edit_mode is MOVE_ENTRY" );
#endif
                if ( AppManager.getSelectedEventCount() > 0 ) {
                    SelectedEventEntry last_selected_event = AppManager.getLastSelectedEvent();
#if DEBUG
                    sout.println( "FormMain#pictPianoRoll_MouseUp; last_selected_event.original.InternalID=" + last_selected_event.original.InternalID );
#endif
                    VsqEvent original = last_selected_event.original;
                    if ( original.Clock != last_selected_event.editing.Clock ||
                         original.ID.Note != last_selected_event.editing.ID.Note ) {
                        boolean out_of_range = false; // プリメジャーにめり込んでないかどうか
                        boolean contains_dynamics = false; // Dynaff, Crescend, Desrecendが含まれているかどうか
                        VsqTrack copied = (VsqTrack)vsq_track.clone();
                        int clockAtPremeasure = vsq.getPreMeasureClocks();
                        for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                            SelectedEventEntry ev = itr.next();
                            int internal_id = ev.original.InternalID;
                            if ( ev.editing.Clock < clockAtPremeasure ) {
                                out_of_range = true;
                                break;
                            }
                            if ( ev.editing.ID.Note < 0 || 128 < ev.editing.ID.Note ) {
                                out_of_range = true;
                                break;
                            }
                            for ( Iterator<VsqEvent> itr2 = copied.getEventIterator(); itr2.hasNext(); ) {
                                VsqEvent item = itr2.next();
                                if ( item.InternalID == internal_id ) {
                                    item.Clock = ev.editing.Clock;
                                    item.ID = (VsqID)ev.editing.ID.clone();
                                    break;
                                }
                            }
                            if ( ev.original.ID.type == VsqIDType.Aicon ) {
                                contains_dynamics = true;
                            }
                        }
                        if ( out_of_range ) {
#if !JAVA
                            SystemSounds.Asterisk.Play();
#endif
                        } else {
                            if ( contains_dynamics ) {
                                copied.reflectDynamics();
                            }
                            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                                         copied,
                                                                                         vsq.AttachedCurves.get( selected - 1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            AppManager.updateSelectedEventInstance();
                            setEdited( true );
                        }
                    } else {
                        /*if ( (modefier & Keys.Shift) == Keys.Shift || (modefier & Keys.Control) == Keys.Control ) {
                            Rectangle rc;
                            VsqEvent select = IdOfClickedPosition( e.Location, out rc );
                            if ( select != null ) {
                                m_config.addSelectedEvent( item.InternalID );
                            }
                        }*/
                    }
                    lock ( AppManager.mDrawObjects ) {
                        Collections.sort( AppManager.mDrawObjects.get( selected - 1 ) );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_LEFT_EDGE || edit_mode == EditMode.EDIT_RIGHT_EDGE ) {
                #region EDIT_LEFT_EDGE | EDIT_RIGHT_EDGE
                if ( mMouseMoved ) {
                    VsqEvent original = AppManager.getLastSelectedEvent().original;
                    int count = AppManager.getSelectedEventCount();
                    int[] ids = new int[count];
                    int[] clocks = new int[count];
                    VsqID[] values = new VsqID[count];
                    int i = -1;
                    boolean contains_aicon = false; // dynaff, crescend, decrescendが含まれていればtrue
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry ev = itr.next();
                        if ( ev.original.ID.type == VsqIDType.Aicon ) {
                            contains_aicon = true;
                        }
                        i++;

                        Utility.editLengthOfVsqEvent( ev.editing, ev.editing.ID.getLength(), AppManager.vibratoLengthEditingRule );
                        ids[i] = ev.original.InternalID;
                        clocks[i] = ev.editing.Clock;
                        values[i] = ev.editing.ID;
                    }

                    CadenciiCommand run = null;
                    if ( contains_aicon ) {
                        VsqFileEx copied_vsq = (VsqFileEx)vsq.clone();
                        VsqCommand vsq_command =
                            VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( selected,
                                                                                           ids,
                                                                                           clocks,
                                                                                           values );
                        copied_vsq.executeCommand( vsq_command );
                        VsqTrack copied = (VsqTrack)copied_vsq.Track.get( selected ).clone();
                        copied.reflectDynamics();
                        run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                     copied,
                                                                     vsq.AttachedCurves.get( selected - 1 ) );
                    } else {
                        run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeClockAndIDContaintsRange( selected,
                                                                                 ids,
                                                                                 clocks,
                                                                                 values ) );
                    }
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                }
                #endregion
            } else if ( edit_mode == EditMode.EDIT_VIBRATO_DELAY ) {
                #region EditVibratoDelay
                if ( mMouseMoved ) {
                    double max_length = AppManager.mAddingEventLength - _PX_ACCENT_HEADER * AppManager.getScaleXInv();
                    double rate = AppManager.mAddingEvent.ID.getLength() / max_length;
                    if ( rate > 0.99 ) {
                        rate = 1.0;
                    }
                    int vibrato_length = (int)(AppManager.mAddingEventLength * rate);
                    VsqEvent item = null;
                    for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                        VsqEvent ve = itr.next();
                        if ( ve.InternalID == mVibratoEditingId ) {
                            item = (VsqEvent)ve.clone();
                            break;
                        }
                    }
                    if ( item != null ) {
                        if ( vibrato_length <= 0 ) {
                            item.ID.VibratoHandle = null;
                            item.ID.VibratoDelay = item.ID.getLength();
                        } else {
                            item.ID.VibratoHandle.setLength( vibrato_length );
                            item.ID.VibratoDelay = item.ID.getLength() - vibrato_length;
                        }
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( selected, mVibratoEditingId, item.ID ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
                #endregion
            } else if ( edit_mode == EditMode.MOVE_ENTRY_WHOLE ) {
#if DEBUG
                sout.println( "FormMain#pictPianoRoll_MouseUp; EditMode.MOVE_ENTRY_WHOLE" );
#endif
                #region MOVE_ENTRY_WHOLE
                int src_clock_start = AppManager.mWholeSelectedInterval.getStart();
                int src_clock_end = AppManager.mWholeSelectedInterval.getEnd();
                int dst_clock_start = AppManager.mWholeSelectedIntervalStartForMoving;
                int dst_clock_end = dst_clock_start + (src_clock_end - src_clock_start);
                int dclock = dst_clock_start - src_clock_start;

                int num = AppManager.getSelectedEventCount();
                int[] selected_ids = new int[num]; // 後段での再選択用のInternalIDのリスト
                int last_selected_id = AppManager.getLastSelectedEvent().original.InternalID;

                // 音符イベントを移動
                VsqTrack work = (VsqTrack)vsq_track.clone();
                int k = 0;
                for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                    SelectedEventEntry item = itr.next();
                    int internal_id = item.original.InternalID;
                    selected_ids[k] = internal_id;
                    k++;
#if DEBUG
                    sout.println( "FormMain#pictPianoRoll_MouseUp; internal_id=" + internal_id );
#endif
                    for ( Iterator<VsqEvent> itr2 = work.getNoteEventIterator(); itr2.hasNext(); ) {
                        VsqEvent vsq_event = itr2.next();
                        if ( internal_id == vsq_event.InternalID ) {
#if DEBUG
                            sout.println( "FormMain#pictPianoRoll_MouseUp; before: clock=" + vsq_event.Clock + "; after: clock=" + item.editing.Clock );
#endif
                            vsq_event.Clock = item.editing.Clock;
                            break;
                        }
                    }
                }

                // 全てのコントロールカーブのデータ点を移動
                for ( int i = 0; i < Utility.CURVE_USAGE.Length; i++ ) {
                    CurveType curve_type = Utility.CURVE_USAGE[i];
                    VsqBPList bplist = work.getCurve( curve_type.getName() );
                    if ( bplist == null ) {
                        continue;
                    }

                    // src_clock_startからsrc_clock_endの範囲にあるデータ点をコピー＆削除
                    VsqBPList copied = new VsqBPList( bplist.getName(), bplist.getDefault(), bplist.getMinimum(), bplist.getMaximum() );
                    int size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( src_clock_start <= clock && clock <= src_clock_end ) {
                            VsqBPPair bppair = bplist.getElementB( j );
                            copied.add( clock, bppair.value );
                            bplist.removeElementAt( j );
                        }
                    }

                    // dst_clock_startからdst_clock_endの範囲にあるコントロールカーブのデータ点をすべて削除
                    size = bplist.size();
                    for ( int j = size - 1; j >= 0; j-- ) {
                        int clock = bplist.getKeyClock( j );
                        if ( dst_clock_start <= clock && clock <= dst_clock_end ) {
                            bplist.removeElementAt( j );
                        }
                    }

                    // コピーしたデータを、クロックをずらしながら追加
                    size = copied.size();
                    for ( int j = 0; j < size; j++ ) {
                        int clock = copied.getKeyClock( j );
                        VsqBPPair bppair = copied.getElementB( j );
                        bplist.add( clock + dclock, bppair.value );
                    }
                }

                // コマンドを作成＆実行
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                             work,
                                                                             vsq.AttachedCurves.get( selected - 1 ) );
                AppManager.register( vsq.executeCommand( run ) );

                // 選択範囲を更新
                AppManager.mWholeSelectedInterval = new SelectedRegion( dst_clock_start );
                AppManager.mWholeSelectedInterval.setEnd( dst_clock_end );
                AppManager.mWholeSelectedIntervalStartForMoving = dst_clock_start;

                // 音符の再選択
                AppManager.clearSelectedEvent();
                Vector<Integer> list_selected_ids = new Vector<Integer>();
                for ( int i = 0; i < num; i++ ) {
                    list_selected_ids.add( selected_ids[i] );
                }
                AppManager.addSelectedEventAll( list_selected_ids );
                AppManager.addSelectedEvent( last_selected_id );

                setEdited( true );
                #endregion
            } else if ( AppManager.isWholeSelectedIntervalEnabled() ) {
                int start = AppManager.mWholeSelectedInterval.getStart();
                int end = AppManager.mWholeSelectedInterval.getEnd();
#if DEBUG
                sout.println( "FormMain#pictPianoRoll_MouseUp; WholeSelectedInterval; (start,end)=" + start + ", " + end );
#endif
                AppManager.clearSelectedEvent();

                // 音符の選択状態を更新
                Vector<Integer> add_required_event = new Vector<Integer>();
                for ( Iterator<VsqEvent> itr = vsq_track.getEventIterator(); itr.hasNext(); ) {
                    VsqEvent ve = itr.next();
                    if ( start <= ve.Clock && ve.Clock + ve.ID.getLength() <= end ) {
                        add_required_event.add( ve.InternalID );
                    }
                }
                AppManager.addSelectedEventAll( add_required_event );

                // コントロールカーブ点の選択状態を更新
                Vector<Long> add_required_point = new Vector<Long>();
                VsqBPList list = vsq_track.getCurve( selected_curve.getName() );
                if ( list != null ) {
                    int count = list.size();
                    for ( int i = 0; i < count; i++ ) {
                        int clock = list.getKeyClock( i );
                        if ( clock < start ) {
                            continue;
                        } else if ( end < clock ) {
                            break;
                        } else {
                            VsqBPPair v = list.getElementB( i );
                            add_required_point.add( v.id );
                        }
                    }
                }
                if ( add_required_point.size() > 0 ) {
                    AppManager.addSelectedPointAll( selected_curve,
                                                    PortUtil.convertLongArray( add_required_point.toArray( new Long[] { } ) ) );
                }
            }
        heaven:
            AppManager.setEditMode( EditMode.NONE );
            refreshScreen( true );
        }

        public void pictPianoRoll_MouseWheel( Object sender, BMouseEventArgs e )
        {
            int modifier = PortUtil.getCurrentModifierKey();
            boolean horizontal = (modifier & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK;
            if ( AppManager.editorConfig.ScrollHorizontalOnWheel ) {
                horizontal = !horizontal;
            }
            if ( (modifier & InputEvent.CTRL_MASK) == InputEvent.CTRL_MASK ) {
                // ピアノロール拡大率を変更
                if ( horizontal ) {
                    int max = trackBar.getMaximum();
                    int min = trackBar.getMinimum();
                    int width = max - min;
                    int delta = (width / 10) * (e.Delta > 0 ? 1 : -1);
                    int old_tbv = trackBar.getValue();
                    int draft = old_tbv + delta;
                    if ( draft < min ) {
                        draft = min;
                    }
                    if ( max < draft ) {
                        draft = max;
                    }
                    if ( old_tbv != draft ) {

                        // マウス位置を中心に拡大されるようにしたいので．
                        // マウスのスクリーン座標
                        Point screen_p_at_mouse = PortUtil.getMousePosition();
                        // ピアノロール上でのマウスのx座標
                        int x_at_mouse = pictPianoRoll.pointToClient( screen_p_at_mouse ).x;
                        // マウス位置でのクロック -> こいつが保存される
                        int clock_at_mouse = AppManager.clockFromXCoord( x_at_mouse );
                        // 古い拡大率
                        float scale0 = AppManager.getScaleX();
                        // 新しい拡大率
                        float scale1 = getScaleXFromTrackBarValue( draft );
                        // 古いstdx
                        int stdx0 = AppManager.getStartToDrawX();
                        int stdx1 = (int)(clock_at_mouse * (scale1 - scale0) + stdx0);
                        // 新しいhScroll.Value
                        int hscroll_value = (int)(stdx1 / scale1);
                        if ( hscroll_value < hScroll.getMinimum() ) {
                            hscroll_value = hScroll.getMinimum();
                        }
                        if ( hScroll.getMaximum() < hscroll_value ) {
                            hscroll_value = hScroll.getMaximum();
                        }

                        AppManager.setScaleX( scale1 );
                        AppManager.setStartToDrawX( stdx1 );
                        hScroll.setValue( hscroll_value );
                        trackBar.setValue( draft );
                    }
                } else {
                    zoomY( e.Delta > 0 ? 1 : -1 );
                }
            } else {
                // スクロール操作
                if ( e.X <= AppManager.keyWidth || pictPianoRoll.getWidth() < e.X ) {
                    horizontal = false;
                }
                if ( horizontal ) {
                    hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
                } else {
                    double new_val = (double)vScroll.getValue() - e.Delta * 10;
                    int min = vScroll.getMinimum();
                    int max = vScroll.getMaximum() - vScroll.getVisibleAmount();
                    if ( new_val > max ) {
                        vScroll.setValue( max );
                    } else if ( new_val < min ) {
                        vScroll.setValue( min );
                    } else {
                        vScroll.setValue( (int)new_val );
                    }
                }
            }
            refreshScreen();
        }

        public void pictPianoRoll_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e )
        {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        //BOOKMARK: iconPalette
        #region iconPalette
        public void iconPalette_LocationChanged( Object sender, EventArgs e )
        {
            AppManager.editorConfig.FormIconPaletteLocation = new XmlPoint( AppManager.iconPalette.getLocation() );
        }

        public void iconPalette_FormClosing( Object sender, BFormClosingEventArgs e )
        {
            flipIconPaletteVisible( AppManager.iconPalette.isVisible() );
        }
        #endregion

        //BOOKMARK: menuVisual
        #region menuVisual*
        public void menuVisualProperty_CheckedChanged( Object sender, EventArgs e )
        {
#if ENABLE_PROPERTY
            if ( menuVisualProperty.isSelected() ) {
                if ( AppManager.editorConfig.PropertyWindowStatus.WindowState == BFormWindowState.Minimized ) {
                    updatePropertyPanelState( PanelState.Docked );
                } else {
                    updatePropertyPanelState( PanelState.Window );
                }
            } else {
                updatePropertyPanelState( PanelState.Hidden );
            }
#endif
        }

        public void menuVisualOverview_CheckedChanged( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#menuVisualOverview_CheckedChanged; menuVisualOverview.isSelected()=" + menuVisualOverview.isSelected() );
#endif
            AppManager.editorConfig.OverviewEnabled = menuVisualOverview.isSelected();
            updateLayout();
        }

        public void menuVisualMixer_Click( Object sender, EventArgs e )
        {
            boolean v = !AppManager.editorConfig.MixerVisible;
            flipMixerDialogVisible( v );
            requestFocus();
        }

        public void menuVisualGridline_CheckedChanged( Object sender, EventArgs e )
        {
            AppManager.setGridVisible( menuVisualGridline.isSelected() );
            refreshScreen();
        }

        public void menuVisualIconPalette_Click( Object sender, EventArgs e )
        {
            boolean v = !AppManager.editorConfig.IconPaletteVisible;
            flipIconPaletteVisible( v );
        }

        public void menuVisualLyrics_CheckedChanged( Object sender, EventArgs e )
        {
            AppManager.editorConfig.ShowLyric = menuVisualLyrics.isSelected();
        }

        public void menuVisualNoteProperty_CheckedChanged( Object sender, EventArgs e )
        {
            AppManager.editorConfig.ShowExpLine = menuVisualNoteProperty.isSelected();
            refreshScreen();
        }

        public void menuVisualPitchLine_CheckedChanged( Object sender, EventArgs e )
        {
            AppManager.editorConfig.ViewAtcualPitch = menuVisualPitchLine.isSelected();
        }

        public void menuVisualControlTrack_CheckedChanged( Object sender, EventArgs e )
        {
            flipControlCurveVisible( menuVisualControlTrack.isSelected() );
        }

        public void menuVisualWaveform_CheckedChanged( Object sender, EventArgs e )
        {
            AppManager.editorConfig.ViewWaveform = menuVisualWaveform.isSelected();
            updateSplitContainer2Size( true );
        }

        public void menuVisualPluginUi_DropDownOpening( Object sender, EventArgs e )
        {
#if ENABLE_VOCALOID
#if !JAVA
            // VOCALOID1, 2
            int c = VSTiDllManager.vocaloidDriver.size();
            for ( int i = 0; i < c; i++ ) {
                VocaloidDriver vd = VSTiDllManager.vocaloidDriver.get( i );
                boolean chkv = true;
                if ( vd == null ) {
                    chkv = false;
                } else if ( !vd.loaded ) {
                    chkv = false;
                } else if ( vd.getUi( this ) == null ) {
                    chkv = false;
                } else if ( vd.getUi( this ).IsDisposed ) {
                    chkv = false;
                } else if ( !vd.getUi( this ).isVisible() ) {
                    chkv = false;
                }
                RendererKind kind = vd.kind;
                if ( kind == RendererKind.VOCALOID1 ) {
                    menuVisualPluginUiVocaloid1.setSelected( chkv );
                } else if ( kind == RendererKind.VOCALOID2 ) {
                    menuVisualPluginUiVocaloid2.setSelected( chkv );
                }
            }
#endif
#endif

#if ENABLE_AQUESTONE
            // AquesTone
            AquesToneDriver drv = AquesToneDriver.getInstance();
            boolean chk = true;
            if ( drv == null ) {
                chk = false;
            } else if ( !drv.loaded ) {
                chk = false;
            } else {
                FormPluginUi ui = drv.getUi( this );
                if ( ui == null ) {
                    chk = false;
                } else if ( ui.IsDisposed ) {
                    chk = false;
                } else if ( !ui.isVisible() ) {
                    chk = false;
                }
            }
            menuVisualPluginUiAquesTone.setSelected( chk );
#endif
        }

        public void menuVisualPluginUiVocaloidCommon_Click( Object sender, EventArgs e )
        {
            RendererKind search = RendererKind.NULL;
            //int vocaloid = 0;
            if ( sender == menuVisualPluginUiVocaloid1 ) {
                search = RendererKind.VOCALOID1;
                //vocaloid = 1;
            } else if ( sender == menuVisualPluginUiVocaloid2 ) {
                search = RendererKind.VOCALOID2;
                //vocaloid = 2;
            } else {
                return;
            }
#if DEBUG
            sout.println( "FormMain#menuVisualPluginVocaloidCommon_Click; search=" + search );
#endif

#if ENABLE_VOCALOID
#if !JAVA
            int c = VSTiDllManager.vocaloidDriver.size();
            for ( int i = 0; i < c; i++ ) {
                VocaloidDriver vd = VSTiDllManager.vocaloidDriver.get( i );
                boolean chk = true;
                if ( vd == null ) {
                    chk = false;
                } else if ( !vd.loaded ) {
                    chk = false;
                } else {
                    FormPluginUi ui = vd.getUi( this );
                    if ( ui == null ) {
                        chk = false;
                    } else if ( ui.IsDisposed ) {
                        chk = false;
                    }
                }
                if ( !chk ) {
                    continue;
                }
                RendererKind kind = vd.kind;
                boolean v = true;
                if ( kind == search ) {
                    if ( search == RendererKind.VOCALOID1 ) {
                        v = !menuVisualPluginUiVocaloid1.isSelected();
                        menuVisualPluginUiVocaloid1.setSelected( v );
                        vd.getUi( this ).setVisible( v );
                    } else if ( search == RendererKind.VOCALOID2 ) {
                        v = !menuVisualPluginUiVocaloid2.isSelected();
                        menuVisualPluginUiVocaloid2.setSelected( v );
                        vd.getUi( this ).setVisible( v );
                    }
                    break;
                }
            }
#endif
#endif
        }

        public void menuVisualPluginUiAquesTone_Click( Object sender, EventArgs e )
        {
            boolean visible = !menuVisualPluginUiAquesTone.isSelected();
            menuVisualPluginUiAquesTone.setSelected( visible );

#if ENABLE_AQUESTONE
            AquesToneDriver drv = AquesToneDriver.getInstance();
            boolean chk = true;
            FormPluginUi ui = null;
            if ( drv == null ) {
                chk = false;
            } else if ( !drv.loaded ) {
                chk = false;
            } else {
                ui = drv.getUi( this );
                if ( ui == null ) {
                    chk = false;
                } else if ( ui.IsDisposed ) {
                    chk = false;
                }
            }
            if ( !chk ) {
                menuVisualPluginUiAquesTone.setSelected( false );
                return;
            }
            if ( ui != null && !ui.IsDisposed ) {
                ui.setVisible( visible );
            }
#endif
        }
        #endregion

        //BOOKMARK: mixerWindow
        #region mixerWindow
        public void mixerWindow_FormClosing( Object sender, BFormClosingEventArgs e )
        {
            flipMixerDialogVisible( AppManager.mMixerWindow.isVisible() );
        }
        
        public void mixerWindow_SoloChanged( int track, boolean solo )
        {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#mixerWindow_SoloChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    solo=" + solo );
#endif
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            vsq.setSolo( track, solo );
            if ( AppManager.mMixerWindow != null ) {
                AppManager.mMixerWindow.updateStatus();
            }
        }

        public void mixerWindow_MuteChanged( int track, boolean mute )
        {
#if DEBUG
            AppManager.debugWriteLine( "FormMain#mixerWindow_MuteChanged" );
            AppManager.debugWriteLine( "    track=" + track );
            AppManager.debugWriteLine( "    mute=" + mute );
#endif
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            if ( track < 0 ) {
                AppManager.getBgm( -track - 1 ).mute = mute ? 1 : 0;
            } else {
                vsq.setMute( track, mute );
            }
            if ( AppManager.mMixerWindow != null ) {
                AppManager.mMixerWindow.updateStatus();
            }
        }

        public void mixerWindow_PanpotChanged( int track, int panpot )
        {
            if ( track == 0 ) {
                // master
                AppManager.getVsqFile().Mixer.MasterPanpot = panpot;
            } else if ( track > 0 ) {
                // slave
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Panpot = panpot;
            } else {
                AppManager.getBgm( -track - 1 ).panpot = panpot;
            }
        }

        public void mixerWindow_FederChanged( int track, int feder )
        {
#if DEBUG
            sout.println( "FormMain#mixerWindow_FederChanged; track=" + track + "; feder=" + feder );
#endif
            if ( track == 0 ) {
                AppManager.getVsqFile().Mixer.MasterFeder = feder;
            } else if ( track > 0 ) {
                AppManager.getVsqFile().Mixer.Slave.get( track - 1 ).Feder = feder;
            } else {
                AppManager.getBgm( -track - 1 ).feder = feder;
            }
        }
        #endregion

        #region mPropertyPanelContainer
#if ENABLE_PROPERTY
        public void mPropertyPanelContainer_StateChangeRequired( Object sender, PanelState arg )
        {
            updatePropertyPanelState( arg );
        }
#endif
        #endregion

        #region propertyPanel
#if ENABLE_PROPERTY
        public void propertyPanel_CommandExecuteRequired( Object sender, CadenciiCommand command )
        {
#if DEBUG
            AppManager.debugWriteLine( "m_note_property_dlg_CommandExecuteRequired" );
#endif
            AppManager.register( AppManager.getVsqFile().executeCommand( command ) );
            updateDrawObjectList();
            refreshScreen();
            setEdited( true );
        }
#endif
        #endregion

        //BOOKMARK: propertyWindow
        #region propertyWindow
#if ENABLE_PROPERTY
        public void propertyWindow_FormClosing( Object sender, BFormClosingEventArgs e )
        {
#if !JAVA        
            if ( e.CloseReason != System.Windows.Forms.CloseReason.UserClosing ) {
                return;
            }
            e.Cancel = true;
#endif
            updatePropertyPanelState( PanelState.Hidden );
        }
#endif

#if ENABLE_PROPERTY
        public void propertyWindow_WindowStateChanged( Object sender, BEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#propertyWindow_WindowStateChanged" );
#endif
            if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window ) {
                if ( AppManager.propertyWindow.getExtendedState() == BForm.ICONIFIED ) {
                    updatePropertyPanelState( PanelState.Docked );
                }
            }
        }

        public void propertyWindow_LocationOrSizeChanged( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#propertyWindow_LocationOrSizeChanged" );
#endif
            if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window ) {
                if ( AppManager.propertyWindow.getExtendedState() != BForm.ICONIFIED ) {
                    Point parent = this.getLocation();
                    Point proeprty = AppManager.propertyWindow.getLocation();
                    AppManager.editorConfig.PropertyWindowStatus.Bounds = 
                        new XmlRectangle( proeprty.x - parent.x,
                                          proeprty.y - parent.y,
                                          AppManager.propertyWindow.getWidth(),
                                          AppManager.propertyWindow.getHeight() );
                }
            }
        }
#endif
        #endregion

        //BOOKMARK: FormMain
        #region FormMain
        public void handleDragExit()
        {
            AppManager.setEditMode( EditMode.NONE );
            mIconPaletteOnceDragEntered = false;
        }

#if !JAVA
        private void FormMain_DragLeave( Object sender, EventArgs e )
        {
            handleDragExit();
        }
#endif

        /// <summary>
        /// アイテムがドラッグされている最中の処理を行います
        /// </summary>
        public void handleDragOver( int screen_x, int screen_y )
        {
            if ( AppManager.getEditMode() != EditMode.DRAG_DROP ) {
                return;
            }
            Point pt = pictPianoRoll.getLocationOnScreen();
            if ( !mIconPaletteOnceDragEntered ) {
                int keywidth = AppManager.keyWidth;
                Rectangle rc = new Rectangle( pt.x + keywidth, pt.y, pictPianoRoll.getWidth() - keywidth, pictPianoRoll.getHeight() );
                if ( Utility.isInRect( new Point( screen_x, screen_y ), rc ) ) {
                    mIconPaletteOnceDragEntered = true;
                } else {
                    return;
                }
            }
            BMouseEventArgs e0 = new BMouseEventArgs( BMouseButtons.Left,
                                                      1,
                                                      screen_x - pt.x,
                                                      screen_y - pt.y,
                                                      0 );
            pictPianoRoll_MouseMove( this, e0 );
        }

#if !JAVA
        private void FormMain_DragOver( Object sender, System.Windows.Forms.DragEventArgs e )
        {
            handleDragOver( e.X, e.Y );
        }
#endif

        /// <summary>
        /// ピアノロールにドロップされたIconDynamicsHandleの受け入れ処理を行います
        /// </summary>
        public void handleDragDrop( IconDynamicsHandle handle, int screen_x, int screen_y )
        {
            if( handle == null ){
                return;
            }
            Point locPianoroll = pictPianoRoll.getLocationOnScreen();
            // ドロップ位置を特定して，アイテムを追加する
            int x = screen_x - locPianoroll.x;
            int y = screen_y - locPianoroll.y;
            int clock1 = AppManager.clockFromXCoord( x );

            // クオンタイズの処理
            int unit = AppManager.getPositionQuantizeClock();
            int clock = doQuantize( clock1, unit );

            int note = AppManager.noteFromYCoord( y );
            VsqFileEx vsq = AppManager.getVsqFile();
            int clockAtPremeasure = vsq.getPreMeasureClocks();
            if ( clock < clockAtPremeasure ) {
                return;
            }
            if ( note < 0 || 128 < note ) {
                return;
            }

            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            VsqTrack work = (VsqTrack)vsq_track.clone();

            if ( AppManager.mAddingEvent == null ) {
                // ここは多分起こらない
                return;
            }
            VsqEvent item = (VsqEvent)AppManager.mAddingEvent.clone();
            item.Clock = clock;
            item.ID.Note = note;
            work.addEvent( item );
            work.reflectDynamics();
            CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected, work, vsq.AttachedCurves.get( selected - 1 ) );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
            AppManager.setEditMode( EditMode.NONE );
            refreshScreen();
        }

#if !JAVA
        private void FormMain_DragDrop( Object sender, System.Windows.Forms.DragEventArgs e )
        {
            AppManager.setEditMode( EditMode.NONE );
            mIconPaletteOnceDragEntered = false;
            mMouseDowned = false;
            if ( !e.Data.GetDataPresent( typeof( IconDynamicsHandle ) ) ) {
                return;
            }
            Point locPianoroll = pictPianoRoll.getLocationOnScreen();
            int keywidth = AppManager.keyWidth;
            Rectangle rcPianoroll = new Rectangle( locPianoroll.x + keywidth,
                                                   locPianoroll.y,
                                                   pictPianoRoll.getWidth() - keywidth,
                                                   pictPianoRoll.getHeight() );
            if ( !Utility.isInRect( new Point( e.X, e.Y ), rcPianoroll ) ) {
                return;
            }

            // dynaff, crescend, decrescend のどれがドロップされたのか検査
            IconDynamicsHandle this_is_it = (IconDynamicsHandle)e.Data.GetData( typeof( IconDynamicsHandle ) );
            if ( this_is_it == null ) {
                return;
            }

            handleDragDrop( this_is_it, e.X, e.Y );
        }
#endif

        /// <summary>
        /// ドラッグの開始処理を行います
        /// </summary>
        public void handleDragEnter()
        {
            AppManager.setEditMode( EditMode.DRAG_DROP );
            mMouseDowned = true;
        }

#if !JAVA
        private void FormMain_DragEnter( Object sender, System.Windows.Forms.DragEventArgs e )
        {
            if ( e.Data.GetDataPresent( typeof( IconDynamicsHandle ) ) ) {
                // ドロップ可能
                e.Effect = System.Windows.Forms.DragDropEffects.All;
                handleDragEnter();
            } else {
                e.Effect = System.Windows.Forms.DragDropEffects.None;
                AppManager.setEditMode( EditMode.NONE );
            }
        }
#endif
        public void FormMain_FormClosed( Object sender, BFormClosedEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#FormMain_FormClosed" );
#endif
            clearTempWave();
            String tempdir = fsys.combine( AppManager.getCadenciiTempDir(), AppManager.getID() );
            if ( !fsys.isDirectoryExists( tempdir ) ) {
                PortUtil.createDirectory( tempdir );
            }
            String log = fsys.combine( tempdir, "run.log" );
#if !JAVA
            org.kbinani.debug.close();
#endif
            try {
                if ( fsys.isFileExists( log ) ) {
                    PortUtil.deleteFile( log );
                }
                PortUtil.deleteDirectory( tempdir, true );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".FormMain_FormClosed; ex=" + ex + "\n" );
                serr.println( "FormMain#FormMain_FormClosed; ex=" + ex );
            }
            AppManager.stopGenerator();
            VSTiDllManager.terminate();
#if ENABLE_MIDI
            //MidiPlayer.stop();
            if ( mMidiIn != null ) {
                mMidiIn.close();
            }
#endif
#if ENABLE_MTC
            if ( m_midi_in_mtc != null ) {
                m_midi_in_mtc.Close();
            }
#endif
            PlaySound.kill();
            Utility.cleanupUnusedAssemblyCache();
#if JAVA
            System.exit( 0 );
#endif
        }

        public void FormMain_FormClosing( Object sender, BFormClosingEventArgs e )
        {
            // 設定値を格納
            if( AppManager.editorConfig.ViewWaveform ){
                AppManager.editorConfig.SplitContainer2LastDividerLocation = splitContainer2.getDividerLocation();
            }
            if ( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Docked ) {
                AppManager.editorConfig.PropertyWindowStatus.DockWidth = splitContainerProperty.getDividerLocation();
            }
#if !JAVA
            if ( e.CloseReason == System.Windows.Forms.CloseReason.WindowsShutDown ) {
                return;
            }
#endif
            boolean cancel = handleFormClosing();
            e.Cancel = cancel;
#if JAVA
            if( !cancel ){
                dispose();
            }
#endif
        }
        
        /// <summary>
        /// ウィンドウが閉じようとしているときの処理を行う
        /// 戻り値がtrueの場合，ウィンドウが閉じるのをキャンセルする処理が必要
        /// </summary>
        /// <returns></returns>
        public boolean handleFormClosing()
        {
            if ( isEdited() ) {
                String file = AppManager.getFileName();
                if ( file.Equals( "" ) ) {
                    file = "Untitled";
                } else {
                    file = PortUtil.getFileName( file );
                }
                BDialogResult ret = AppManager.showMessageBox( _( "Save this sequence?" ),
                                                               _( "Affirmation" ),
                                                               org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_CANCEL_OPTION,
                                                               org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE );
                if ( ret == BDialogResult.YES ) {
                    if ( AppManager.getFileName().Equals( "" ) ) {
                        int dr = AppManager.showModalDialog( saveXmlVsqDialog, false, this );
                        if ( dr == BFileChooser.APPROVE_OPTION ) {
                            AppManager.saveTo( saveXmlVsqDialog.getSelectedFile() );
                        } else {
                            return true;
                        }
                    } else {
                        AppManager.saveTo( AppManager.getFileName() );
                    }

                } else if ( ret == BDialogResult.CANCEL ) {
                    return true;
                }
            }
            AppManager.editorConfig.WindowMaximized = (getExtendedState() == BForm.MAXIMIZED_BOTH);
            AppManager.saveConfig();
            UtauWaveGenerator.clearCache();
            VConnectWaveGenerator.clearCache();

#if ENABLE_MIDI
            if ( mMidiIn != null ) {
                mMidiIn.close();
            }
#endif
#if !JAVA
            bgWorkScreen.Dispose();
#endif
            return false;
        }

        public void FormMain_LocationChanged( Object sender, EventArgs e )
        {
            if ( getExtendedState() == BForm.NORMAL ) {
                AppManager.editorConfig.WindowRect = this.getBounds();
            }
        }

        public void FormMain_Load( Object sender, EventArgs e )
        {
            applyLanguage();

#if !JAVA
            // ツールバーの位置を復帰させる
            // toolStipの位置を，前回終了時の位置に戻す
            int chevron_width = AppManager.editorConfig.ChevronWidth;
            this.bandFile = new RebarBand();
            this.bandPosition = new RebarBand();
            this.bandMeasure = new RebarBand();
            this.bandTool = new RebarBand();

            bool variant_height = false;
            this.bandFile.VariantHeight = variant_height;
            this.bandPosition.VariantHeight = variant_height;
            this.bandMeasure.VariantHeight = variant_height;
            this.bandTool.VariantHeight = variant_height;

            int MAX_BAND_HEIGHT = 26;// toolBarTool.Height;

            this.rebar.Controls.Add( this.toolBarFile );
            this.rebar.Controls.Add( this.toolBarTool );
            this.rebar.Controls.Add( this.toolBarPosition );
            this.rebar.Controls.Add( this.toolBarMeasure );
            // bandFile
            this.bandFile.AllowVertical = false;
            this.bandFile.Child = this.toolBarFile;
            this.bandFile.Header = -1;
            this.bandFile.Integral = 1;
            this.bandFile.MaxHeight = MAX_BAND_HEIGHT;
            this.bandFile.UseChevron = true;
            if ( toolBarFile.Buttons.Count > 0 ) {
                this.bandFile.IdealWidth =
                    toolBarFile.Buttons[toolBarFile.Buttons.Count - 1].Rectangle.Right + chevron_width;
            }
            this.bandFile.BandSize = AppManager.editorConfig.BandSizeFile;
            this.bandFile.NewRow = AppManager.editorConfig.BandNewRowFile;
            // bandPosition
            this.bandPosition.AllowVertical = false;
            this.bandPosition.Child = this.toolBarPosition;
            this.bandPosition.Header = -1;
            this.bandPosition.Integral = 1;
            this.bandPosition.MaxHeight = MAX_BAND_HEIGHT;
            this.bandPosition.UseChevron = true;
            if ( toolBarPosition.Buttons.Count > 0 ) {
                this.bandPosition.IdealWidth =
                    toolBarPosition.Buttons[toolBarPosition.Buttons.Count - 1].Rectangle.Right + chevron_width;
            }
            this.bandPosition.BandSize = AppManager.editorConfig.BandSizePosition;
            this.bandPosition.NewRow = AppManager.editorConfig.BandNewRowPosition;
            // bandMeasure
            this.bandMeasure.AllowVertical = false;
            this.bandMeasure.Child = this.toolBarMeasure;
            this.bandMeasure.Header = -1;
            this.bandMeasure.Integral = 1;
            this.bandMeasure.MaxHeight = MAX_BAND_HEIGHT;
            this.bandMeasure.UseChevron = true;
            if ( toolBarMeasure.Buttons.Count > 0 ) {
                this.bandMeasure.IdealWidth =
                    toolBarMeasure.Buttons[toolBarMeasure.Buttons.Count - 1].Rectangle.Right + chevron_width;
            }
            this.bandMeasure.BandSize = AppManager.editorConfig.BandSizeMeasure;
            this.bandMeasure.NewRow = AppManager.editorConfig.BandNewRowMeasure;
            // bandTool
            this.bandTool.AllowVertical = false;
            this.bandTool.Child = this.toolBarTool;
            this.bandTool.Header = -1;
            this.bandTool.Integral = 1;
            this.bandTool.MaxHeight = MAX_BAND_HEIGHT;
            this.bandTool.UseChevron = true;
            if ( toolBarTool.Buttons.Count > 0 ) {
                this.bandTool.IdealWidth =
                    toolBarTool.Buttons[toolBarTool.Buttons.Count - 1].Rectangle.Right + chevron_width;
            }
            this.bandTool.BandSize = AppManager.editorConfig.BandSizeTool;
            this.bandTool.NewRow = AppManager.editorConfig.BandNewRowTool;
            // 一度リストに入れてから追加する
            var bands = new RebarBand[] { null, null, null, null };
            // 番号がおかしくないかチェック
            if ( AppManager.editorConfig.BandOrderFile < 0 || bands.Length <= AppManager.editorConfig.BandOrderFile ) AppManager.editorConfig.BandOrderFile = 0;
            if ( AppManager.editorConfig.BandOrderMeasure < 0 || bands.Length <= AppManager.editorConfig.BandOrderMeasure ) AppManager.editorConfig.BandOrderMeasure = 0;
            if ( AppManager.editorConfig.BandOrderPosition < 0 || bands.Length <= AppManager.editorConfig.BandOrderPosition ) AppManager.editorConfig.BandOrderPosition = 0;
            if ( AppManager.editorConfig.BandOrderTool < 0 || bands.Length <= AppManager.editorConfig.BandOrderTool ) AppManager.editorConfig.BandOrderTool = 0;
            bands[AppManager.editorConfig.BandOrderFile] = bandFile;
            bands[AppManager.editorConfig.BandOrderMeasure] = bandMeasure;
            bands[AppManager.editorConfig.BandOrderPosition] = bandPosition;
            bands[AppManager.editorConfig.BandOrderTool] = bandTool;
            // nullチェック
            boolean null_exists = false;
            for ( var i = 0; i < bands.Length; i++ ) {
                if ( bands[i] == null ) {
                    null_exists = true;
                    break;
                }
            }
            if ( null_exists ) {
                // 番号に矛盾があれば，デフォルトの並び方で
                bands[0] = bandFile;
                bands[1] = bandMeasure;
                bands[2] = bandPosition;
                bands[3] = bandTool;
                bandFile.NewRow = true;
                bandMeasure.NewRow = true;
                bandPosition.NewRow = true;
                bandTool.NewRow = true;
            }

            // 追加
            for ( var i = 0; i < bands.Length; i++ ) {
                if ( i == 0 ) bands[i].NewRow = true;
                bands[i].MinHeight = 24;
                this.rebar.Bands.Add( bands[i] );
            }

#if DEBUG
            sout.println( "FormMain#.ctor; this.Width=" + this.Width );
#endif
            bandTool.Resize += this.toolStripEdit_Resize;
            bandMeasure.Resize += this.toolStripMeasure_Resize;
            bandPosition.Resize += this.toolStripPosition_Resize;
            bandFile.Resize += this.toolStripFile_Resize;
#endif // !JAVA

            updateSplitContainer2Size( false );

            ensureVisibleY( 60 );

#if !JAVA
            // 鍵盤用の音源の準備．Javaはこの機能は削除で．
            // 鍵盤用のキャッシュが古い位置に保存されている場合。
            String cache_new = Utility.getKeySoundPath();
            String cache_old = fsys.combine( PortUtil.getApplicationStartupPath(), "cache" );
            if ( fsys.isDirectoryExists( cache_old ) ) {
                boolean exists = false;
                for ( int i = 0; i < 127; i++ ) {
                    String s = fsys.combine( cache_new, i + ".wav" );
                    if ( fsys.isFileExists( s ) ) {
                        exists = true;
                        break;
                    }
                }

                // 新しいキャッシュが1つも無い場合に、古いディレクトリからコピーする
                if ( !exists ) {
                    for ( int i = 0; i < 127; i++ ) {
                        String wav_from = fsys.combine( cache_old, i + ".wav" );
                        String wav_to = fsys.combine( cache_new, i + ".wav" );
                        if ( fsys.isFileExists( wav_from ) ) {
                            try {
                                PortUtil.copyFile( wav_from, wav_to );
                                PortUtil.deleteFile( wav_from );
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
                                serr.println( "FormMain#FormMain_Load; ex=" + ex );
                            }
                        }
                    }
                }
            }

            // 足りてないキャッシュがひとつでもあればFormGenerateKeySound発動する
            boolean cache_is_incomplete = false;
            for ( int i = 0; i < 127; i++ ) {
                String wav = fsys.combine( cache_new, i + ".wav" );
                if ( !fsys.isFileExists( wav ) ) {
                    cache_is_incomplete = true;
                    break;
                }
            }
#endif

            boolean init_key_sound_player_immediately = true; //FormGenerateKeySoundの終了を待たずにKeySoundPlayer.initするかどうか。
#if !JAVA
            if ( !AppManager.editorConfig.DoNotAskKeySoundGeneration && cache_is_incomplete ) {
                FormAskKeySoundGeneration dialog = null;
                BDialogResult dialog_result = BDialogResult.NO;
                boolean always_check_this = !AppManager.editorConfig.DoNotAskKeySoundGeneration;
                try {
                    dialog = new FormAskKeySoundGeneration();
                    dialog.setupUi( new FormAskKeySoundGenerationUi( dialog ) );
                    dialog.getUi().setAlwaysPerformThisCheck( always_check_this );
                    dialog_result = AppManager.showModalDialog( dialog.getUi(), this );
                    always_check_this = dialog.getUi().isAlwaysPerformThisCheck();
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
                    serr.println( "FormMain#FormMain_Load; ex=" + ex );
                } finally {
                    if ( dialog != null ) {
                        try {
                            dialog.getUi().close();
                        } catch ( Exception ex2 ) {
                            Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex2 + "\n" );
                            serr.println( "FormMain#FormMain_Load; ex2=" + ex2 );
                        }
                    }
                }
                AppManager.editorConfig.DoNotAskKeySoundGeneration = !always_check_this;

                if ( dialog_result == BDialogResult.YES ) {
                    FormGenerateKeySound form = null;
                    try {
                        form = new FormGenerateKeySound( true );
                        form.FormClosed += new BFormClosedEventHandler( FormGenerateKeySound_FormClosed );
                        form.setVisible( true );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
                        serr.println( "FormMain#FormMain_Load; ex=" + ex );
                    }
                    init_key_sound_player_immediately = false;
                }
            }
#endif

            if ( init_key_sound_player_immediately ) {
                try {
                    KeySoundPlayer.init();
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".FormMain_Load; ex=" + ex + "\n" );
                    serr.println( "FormMain#FormMain_Load; ex=" + ex );
                }
            }
        }

        public void FormGenerateKeySound_FormClosed( Object sender, BFormClosedEventArgs e )
        {
            try {
                KeySoundPlayer.init();
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".FormGenerateKeySound_FormClosed; ex=" + ex + "\n" );
                serr.println( "FormMain#FormGenerateKeySound_FormClosed; ex=" + ex );
            }
        }

        public void FormMain_WindowStateChanged( Object sender, EventArgs e )
        {
            int state = getExtendedState();
            if ( state == BForm.NORMAL || state == BForm.MAXIMIZED_BOTH ) {
                if( state == BForm.NORMAL ){
                    AppManager.editorConfig.WindowRect = this.getBounds();
                }
#if ENABLE_PROPERTY
                // プロパティウィンドウの状態を更新
                if( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window ){
                    if( AppManager.propertyWindow.getExtendedState() != BForm.NORMAL ){
                        AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                    }
                    if( !AppManager.propertyWindow.isVisible() ){
                        AppManager.propertyWindow.setVisible( true );
                    }
                }
#endif
                // ミキサーウィンドウの状態を更新
                boolean vm = AppManager.editorConfig.MixerVisible;
                if( vm != AppManager.mMixerWindow.isVisible() ){
                    AppManager.mMixerWindow.setVisible( vm );
                }
                
                // アイコンパレットの状態を更新
                if ( AppManager.iconPalette != null && menuVisualIconPalette.isSelected() ) {
                    if( !AppManager.iconPalette.isVisible() ){
                        AppManager.iconPalette.setVisible( true );
                    }
                }
                updateLayout();
                this.requestFocus();
            } else if ( state == BForm.ICONIFIED ) {
#if ENABLE_PROPERTY
                AppManager.propertyWindow.setVisible( false );
#endif
                AppManager.mMixerWindow.setVisible( false );
                if ( AppManager.iconPalette != null ) {
                    AppManager.iconPalette.setVisible( false );
                }
            }/* else if ( state == BForm.MAXIMIZED_BOTH ) {
#if ENABLE_PROPERTY
                AppManager.propertyWindow.setExtendedState( BForm.NORMAL );
                AppManager.propertyWindow.setVisible( AppManager.editorConfig.PropertyWindowStatus.State == PanelState.Window );
#endif
                AppManager.mMixerWindow.setVisible( AppManager.editorConfig.MixerVisible );
                if ( AppManager.iconPalette != null && menuVisualIconPalette.isSelected() ) {
                    AppManager.iconPalette.setVisible( true );
                }
                this.requestFocus();
            }*/
        }

        public void FormMain_MouseWheel( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#FormMain_MouseWheel" );
#endif
            if ( (PortUtil.getCurrentModifierKey() & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
            } else {
                int max = vScroll.getMaximum() - vScroll.getVisibleAmount();
                int min = vScroll.getMinimum();
                double new_val = (double)vScroll.getValue() - e.Delta;
                if ( new_val > max ) {
                    vScroll.setValue( max );
                } else if ( new_val < min ) {
                    vScroll.setValue( min );
                } else {
                    vScroll.setValue( (int)new_val );
                }
            }
            refreshScreen();
        }

        public void FormMain_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#FormMain_PreviewKeyDown" );
#endif
#if JAVA
            BKeyEventArgs ex = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs ex = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( ex, true );
        }

        public void handleVScrollResize( Object sender, EventArgs e )
        {
            if ( getExtendedState() != BForm.ICONIFIED ) {
                updateScrollRangeVertical();
                AppManager.setStartToDrawY( calculateStartToDrawY( vScroll.getValue() ) );
            }
        }

        public void FormMain_Deactivate( Object sender, EventArgs e )
        {
            mFormActivated = false;
        }

        public void FormMain_Activated( Object sender, EventArgs e )
        {
            mFormActivated = true;
        }
        #endregion

        #region mTimer
#if !JAVA
        public void mTimer_Tick( Object sender, EventArgs e )
        {
            if ( !mFormActivated ) {
                return;
            }
            try {
                double now = PortUtil.getCurrentTime();
                byte[] buttons;
                int pov0;
#if !JAVA
                boolean ret = winmmhelp.JoyGetStatus( 0, out buttons, out pov0 );
#endif
                boolean event_processed = false;
                double dt_ms = (now - mLastEventProcessed) * 1000.0;

                EditorConfig m = AppManager.editorConfig;
                boolean btn_x = (0 <= m.GameControlerCross && m.GameControlerCross < buttons.Length && buttons[m.GameControlerCross] > 0x00);
                boolean btn_o = (0 <= m.GameControlerCircle && m.GameControlerCircle < buttons.Length && buttons[m.GameControlerCircle] > 0x00);
                boolean btn_tr = (0 <= m.GameControlerTriangle && m.GameControlerTriangle < buttons.Length && buttons[m.GameControlerTriangle] > 0x00);
                boolean btn_re = (0 <= m.GameControlerRectangle && m.GameControlerRectangle < buttons.Length && buttons[m.GameControlerRectangle] > 0x00);
                boolean pov_r = pov0 == m.GameControlPovRight;
                boolean pov_l = pov0 == m.GameControlPovLeft;
                boolean pov_u = pov0 == m.GameControlPovUp;
                boolean pov_d = pov0 == m.GameControlPovDown;
                boolean L1 = (0 <= m.GameControlL1 && m.GameControlL1 < buttons.Length && buttons[m.GameControlL1] > 0x00);
                boolean R1 = (0 <= m.GameControlL2 && m.GameControlL2 < buttons.Length && buttons[m.GameControlR1] > 0x00);
                boolean L2 = (0 <= m.GameControlR1 && m.GameControlR1 < buttons.Length && buttons[m.GameControlL2] > 0x00);
                boolean R2 = (0 <= m.GameControlR2 && m.GameControlR2 < buttons.Length && buttons[m.GameControlR2] > 0x00);
                boolean SELECT = (0 <= m.GameControlSelect && m.GameControlSelect <= buttons.Length && buttons[m.GameControlSelect] > 0x00);
                if ( mGameMode == GameControlMode.NORMAL ) {
                    mLastBtnX = btn_x;

                    if ( !event_processed && !btn_o && mLastBtnO ) {
                        if ( AppManager.isPlaying() ) {
                            timer.stop();
                        }
                        AppManager.setPlaying( !AppManager.isPlaying(), this );
                        mLastEventProcessed = now;
                        event_processed = true;
                    }
                    mLastBtnO = btn_o;

                    if ( !event_processed && pov_r && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        forward();
                        mLastEventProcessed = now;
                        event_processed = true;
                    }
                    mLastPovR = pov_r;

                    if ( !event_processed && pov_l && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        rewind();
                        mLastEventProcessed = now;
                        event_processed = true;
                    }
                    mLastPovL = pov_l;

                    if ( !event_processed && pov_u && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.getValue() - (int)(100 * AppManager.getScaleY()) * 3;
                        if ( draft_vscroll < vScroll.getMinimum() ) {
                            draft_vscroll = vScroll.getMinimum();
                        }
                        vScroll.setValue( draft_vscroll );
                        refreshScreen();
                        mLastEventProcessed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && pov_d && dt_ms > AppManager.editorConfig.GameControlerMinimumEventInterval ) {
                        int draft_vscroll = vScroll.getValue() + (int)(100 * AppManager.getScaleY()) * 3;
                        if ( draft_vscroll > vScroll.getMaximum() ) {
                            draft_vscroll = vScroll.getMaximum();
                        }
                        vScroll.setValue( draft_vscroll );
                        refreshScreen();
                        mLastEventProcessed = now;
                        event_processed = true;
                    }

                    if ( !event_processed && !SELECT && mLastBtnSelect ) {
                        event_processed = true;
                        mGameMode = GameControlMode.KEYBOARD;
#if !JAVA
                        stripLblGameCtrlMode.setText( mGameMode.ToString() );
                        stripLblGameCtrlMode.setIcon( new ImageIcon( Resources.get_piano() ) );
#endif
                    }
                    mLastBtnSelect = SELECT;
                } else if ( mGameMode == GameControlMode.KEYBOARD ) {
                    if ( !event_processed && !SELECT && mLastBtnSelect ) {
                        event_processed = true;
                        mGameMode = GameControlMode.NORMAL;
                        updateGameControlerStatus( null, null );
                        mLastBtnSelect = SELECT;
                        return;
                    }
                    mLastBtnSelect = SELECT;

                    int note = -1;
                    if ( pov_r && !mLastPovR ) {
                        note = 60;
                    } else if ( btn_re && !mLastBtnRe ) {
                        note = 62;
                    } else if ( btn_tr && !mLastBtnTr ) {
                        note = 64;
                    } else if ( btn_o && !mLastBtnO ) {
                        note = 65;
                    } else if ( btn_x && !mLastBtnX ) {
                        note = 67;
                    } else if ( pov_u && !mLastPovU ) {
                        note = 59;
                    } else if ( pov_l && !mLastPovL ) {
                        note = 57;
                    } else if ( pov_d && !mLastPovD ) {
                        note = 55;
                    }
                    if ( note >= 0 ) {
                        if ( L1 ) {
                            note += 12;
                        } else if ( L2 ) {
                            note -= 12;
                        }
                        if ( R1 ) {
                            note += 1;
                        } else if ( R2 ) {
                            note -= 1;
                        }
                    }
                    mLastBtnO = btn_o;
                    mLastBtnX = btn_x;
                    mLastBtnRe = btn_re;
                    mLastBtnTr = btn_tr;
                    mLastPovL = pov_l;
                    mLastPovD = pov_d;
                    mLastPovR = pov_r;
                    mLastPovU = pov_u;
                    if ( note >= 0 ) {
#if DEBUG
                        AppManager.debugWriteLine( "FormMain#mTimer_Tick" );
                        AppManager.debugWriteLine( "    note=" + note );
#endif
                        if ( AppManager.isPlaying() ) {
                            int clock = AppManager.getCurrentClock();
                            int selected = AppManager.getSelected();
                            if ( AppManager.mAddingEvent != null ) {
                                AppManager.mAddingEvent.ID.setLength( clock - AppManager.mAddingEvent.Clock );
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( selected,
                                                                                                               AppManager.mAddingEvent ) );
                                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                if ( !isEdited() ) {
                                    setEdited( true );
                                }
                                updateDrawObjectList();
                            }
                            AppManager.mAddingEvent = new VsqEvent( clock, new VsqID( 0 ) );
                            AppManager.mAddingEvent.ID.type = VsqIDType.Anote;
                            AppManager.mAddingEvent.ID.Dynamics = 64;
                            AppManager.mAddingEvent.ID.VibratoHandle = null;
                            AppManager.mAddingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                            AppManager.mAddingEvent.ID.Note = note;
                        }
                        KeySoundPlayer.play( note );
                    } else {
                        if ( AppManager.isPlaying() && AppManager.mAddingEvent != null ) {
                            AppManager.mAddingEvent.ID.setLength( AppManager.getCurrentClock() - AppManager.mAddingEvent.Clock );
                        }
                    }
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".mTimer_Tick; ex=" + ex + "\n" );
#if DEBUG
                AppManager.debugWriteLine( "    ex=" + ex );
#endif
                mGameMode = GameControlMode.DISABLED;
                updateGameControlerStatus( null, null );
                mTimer.stop();
            }
        }
#endif
        #endregion

        //BOOKMARK: menuFile
        #region menuFile*
        public void menuFileRecentClear_Click( Object sender, BEventArgs e )
        {
            if( AppManager.editorConfig.RecentFiles != null ){
                AppManager.editorConfig.RecentFiles.clear();
            }
            updateRecentFileMenu();
        }
        
        public void menuFileSaveNamed_Click( Object sender, EventArgs e )
        {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        PortUtil.formatMessage(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ), track, AppManager.getVsqFile().Track.get( track ).getName()
                        ),
                        _APP_NAME,
                        org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                        org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                    return;
                }
            }

            String dir = AppManager.editorConfig.getLastUsedPathOut( "xvsq" );
            saveXmlVsqDialog.setSelectedFile( dir );
            int dr = AppManager.showModalDialog( saveXmlVsqDialog, false, this );
            if ( dr == BFileChooser.APPROVE_OPTION ) {
                String file = saveXmlVsqDialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathOut( file, ".xvsq" );
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        public void menuFileQuit_Click( Object sender, EventArgs e )
        {
            close();
        }

        public void menuFileExport_DropDownOpening( Object sender, EventArgs e )
        {
            menuFileExportWave.setEnabled( (AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount() > 0) );
        }

        public void menuFileExportMidi_Click( Object sender, EventArgs e )
        {
            if ( mDialogMidiImportAndExport == null ) {
                mDialogMidiImportAndExport = new FormMidiImExport();
            }
            mDialogMidiImportAndExport.listTrack.clear();
            VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().clone();

            for ( int i = 0; i < vsq.Track.size(); i++ ) {
                VsqTrack track = vsq.Track.get( i );
                int notes = 0;
                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                    VsqEvent obj = itr.next();
                    notes++;
                }
                mDialogMidiImportAndExport.listTrack.addRow( new String[] { i + "", track.getName(), notes + "" }, true );
            }
            mDialogMidiImportAndExport.setMode( FormMidiImExport.FormMidiMode.EXPORT );
            mDialogMidiImportAndExport.setLocation( getFormPreferedLocation( mDialogMidiImportAndExport ) );
            BDialogResult dr = AppManager.showModalDialog( mDialogMidiImportAndExport, this );
            if ( dr == BDialogResult.OK ) {
                if ( !mDialogMidiImportAndExport.isPreMeasure() ) {
                    vsq.removePart( 0, vsq.getPreMeasureClocks() );
                }
                int track_count = 0;
                for ( int i = 0; i < mDialogMidiImportAndExport.listTrack.getItemCountRow(); i++ ) {
                    if ( mDialogMidiImportAndExport.listTrack.isRowChecked( i ) ) {
                        track_count++;
                    }
                }
                if ( track_count == 0 ) {
                    return;
                }

                String dir = AppManager.editorConfig.getLastUsedPathOut( "mid" );
                saveMidiDialog.setSelectedFile( dir );
                int dialog_result = AppManager.showModalDialog( saveMidiDialog, false, this );

                if ( dialog_result == BFileChooser.APPROVE_OPTION ) {
                    RandomAccessFile fs = null;
                    String filename = saveMidiDialog.getSelectedFile();
                    AppManager.editorConfig.setLastUsedPathOut( filename, ".mid" );
                    try {
                        fs = new RandomAccessFile( filename, "rw" );
                        // ヘッダー
                        fs.write( new byte[] { 0x4d, 0x54, 0x68, 0x64 }, 0, 4 );
                        //データ長
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x06 );
                        //フォーマット
                        fs.write( (byte)0x00 );
                        fs.write( (byte)0x01 );
                        //トラック数
                        VsqFile.writeUnsignedShort( fs, track_count );
                        //時間単位
                        fs.write( (byte)0x01 );
                        fs.write( (byte)0xe0 );
                        int count = -1;
                        for ( int i = 0; i < mDialogMidiImportAndExport.listTrack.getItemCountRow(); i++ ) {
                            if ( !mDialogMidiImportAndExport.listTrack.isRowChecked( i ) ) {
                                continue;
                            }
                            VsqTrack track = vsq.Track.get( i );
                            count++;
                            fs.write( new byte[] { 0x4d, 0x54, 0x72, 0x6b }, 0, 4 );
                            //データ長。とりあえず0を入れておく
                            fs.write( new byte[] { 0x00, 0x00, 0x00, 0x00 }, 0, 4 );
                            long first_position = fs.getFilePointer();
                            //トラック名
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );//デルタタイム
                            fs.write( (byte)0xff );//ステータスタイプ
                            fs.write( (byte)0x03 );//イベントタイプSequence/Track Name
                            byte[] track_name = PortUtil.getEncodedByte( "Shift_JIS", track.getName() );
                            fs.write( (byte)track_name.Length );
                            fs.write( track_name, 0, track_name.Length );

                            Vector<MidiEvent> events = new Vector<MidiEvent>();

                            // tempo
                            boolean print_tempo = mDialogMidiImportAndExport.isTempo();
                            if ( print_tempo && count == 0 ) {
                                Vector<MidiEvent> tempo_events = vsq.generateTempoChange();
                                for ( int j = 0; j < tempo_events.size(); j++ ) {
                                    events.add( tempo_events.get( j ) );
                                }
                            }

                            // timesig
                            if ( mDialogMidiImportAndExport.isTimesig() && count == 0 ) {
                                Vector<MidiEvent> timesig_events = vsq.generateTimeSig();
                                for ( int j = 0; j < timesig_events.size(); j++ ) {
                                    events.add( timesig_events.get( j ) );
                                }
                            }

                            // Notes
                            if ( mDialogMidiImportAndExport.isNotes() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    int clock_off = ve.Clock + ve.ID.getLength();
                                    if ( !print_tempo ) {
                                        // テンポを出力しない場合、テンポを500000（120）と見なしてクロックを再計算
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        double time_off = vsq.getSecFromClock( clock_off );
                                        clock_on = (int)(960.0 * time_on);
                                        clock_off = (int)(960.0 * time_off);
                                    }
                                    MidiEvent noteon = new MidiEvent();
                                    noteon.clock = clock_on;
                                    noteon.firstByte = 0x90;
                                    noteon.data = new int[2];
                                    noteon.data[0] = ve.ID.Note;
                                    noteon.data[1] = ve.ID.Dynamics;
                                    events.add( noteon );
                                    MidiEvent noteoff = new MidiEvent();
                                    noteoff.clock = clock_off;
                                    noteoff.firstByte = 0x80;
                                    noteoff.data = new int[2];
                                    noteoff.data[0] = ve.ID.Note;
                                    noteoff.data[1] = 0x7f;
                                    events.add( noteoff );
                                }
                            }

                            // lyric
                            if ( mDialogMidiImportAndExport.isLyric() ) {
                                for ( Iterator<VsqEvent> itr = track.getNoteEventIterator(); itr.hasNext(); ) {
                                    VsqEvent ve = itr.next();
                                    int clock_on = ve.Clock;
                                    if ( !print_tempo ) {
                                        double time_on = vsq.getSecFromClock( clock_on );
                                        clock_on = (int)(960.0 * time_on);
                                    }
                                    MidiEvent add = new MidiEvent();
                                    add.clock = clock_on;
                                    add.firstByte = 0xff;
                                    byte[] lyric = PortUtil.getEncodedByte( "Shift_JIS", ve.ID.LyricHandle.L0.Phrase );
                                    add.data = new int[lyric.Length + 1];
                                    add.data[0] = 0x05;
                                    for ( int j = 0; j < lyric.Length; j++ ) {
                                        add.data[j + 1] = lyric[j];
                                    }
                                    events.add( add );
                                }
                            }

                            // vocaloid metatext
                            Vector<MidiEvent> meta;
                            if ( mDialogMidiImportAndExport.isVocaloidMetatext() && i > 0 ) {
                                meta = vsq.generateMetaTextEvent( i, "Shift_JIS" );
                            } else {
                                meta = new Vector<MidiEvent>();
                            }

                            // vocaloid nrpn
                            Vector<MidiEvent> vocaloid_nrpn_midievent;
                            if ( mDialogMidiImportAndExport.isVocaloidNrpn() && i > 0 ) {
                                VsqNrpn[] vsqnrpn = VsqFileEx.generateNRPN( (VsqFile)vsq, i, AppManager.editorConfig.PreSendTime );
                                NrpnData[] nrpn = VsqNrpn.convert( vsqnrpn );

                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                                for ( int j = 0; j < nrpn.Length; j++ ) {
                                    MidiEvent me = new MidiEvent();
                                    me.clock = nrpn[j].getClock();
                                    me.firstByte = 0xb0;
                                    me.data = new int[2];
                                    me.data[0] = nrpn[j].getParameter();
                                    me.data[1] = nrpn[j].Value;
                                    vocaloid_nrpn_midievent.add( me );
                                }
                            } else {
                                vocaloid_nrpn_midievent = new Vector<MidiEvent>();
                            }
#if DEBUG
                            sout.println( "menuFileExportMidi_Click" );
                            sout.println( "    vocaloid_nrpn_midievent.size()=" + vocaloid_nrpn_midievent.size() );
#endif

                            // midi eventを出力
                            Collections.sort( events );
                            long last_clock = 0;
                            int events_count = events.size();
                            if ( events_count > 0 ) {
                                for ( int j = 0; j < events_count; j++ ) {
                                    if ( events.get( j ).clock > 0 && meta.size() > 0 ) {
                                        for ( int k = 0; k < meta.size(); k++ ) {
                                            VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                            meta.get( k ).writeData( fs );
                                        }
                                        meta.clear();
                                        last_clock = 0;
                                    }
                                    long clock = events.get( j ).clock;
                                    while ( vocaloid_nrpn_midievent.size() > 0 && vocaloid_nrpn_midievent.get( 0 ).clock < clock ) {
                                        VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(vocaloid_nrpn_midievent.get( 0 ).clock - last_clock) );
                                        last_clock = vocaloid_nrpn_midievent.get( 0 ).clock;
                                        vocaloid_nrpn_midievent.get( 0 ).writeData( fs );
                                        vocaloid_nrpn_midievent.removeElementAt( 0 );
                                    }
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(events.get( j ).clock - last_clock) );
                                    events.get( j ).writeData( fs );
                                    last_clock = events.get( j ).clock;
                                }
                            } else {
                                int c = vocaloid_nrpn_midievent.size();
                                for ( int k = 0; k < meta.size(); k++ ) {
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, 0 );
                                    meta.get( k ).writeData( fs );
                                }
                                meta.clear();
                                last_clock = 0;
                                for ( int j = 0; j < c; j++ ) {
                                    MidiEvent item = vocaloid_nrpn_midievent.get( j );
                                    long clock = item.clock;
                                    VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)(clock - last_clock) );
                                    item.writeData( fs );
                                    last_clock = clock;
                                }
                            }

                            // トラックエンドを記入し、
                            VsqFile.writeFlexibleLengthUnsignedLong( fs, (long)0 );
                            fs.write( (byte)0xff );
                            fs.write( (byte)0x2f );
                            fs.write( (byte)0x00 );
                            // チャンクの先頭に戻ってチャンクのサイズを記入
                            long pos = fs.getFilePointer();
                            fs.seek( first_position - 4 );
                            VsqFile.writeUnsignedInt( fs, pos - first_position );
                            // ファイルを元の位置にseek
                            fs.seek( pos );
                        }
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportMidi_Click; ex=" + ex + "\n" );
                    } finally {
                        if ( fs != null ) {
                            try {
                                fs.close();
                            } catch ( Exception ex2 ) {
                                Logger.write( typeof( FormMain ) + ".menuFileExportMidi_Click; ex=" + ex2 + "\n" );
                            }
                        }
                    }
                }
            }
        }

        public void menuFileExportMusicXml_Click( Object sender, EventArgs e )
        {
            BFileChooser dialog = null;
            try {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( vsq == null ) {
                    return;
                }
                String first = AppManager.editorConfig.getLastUsedPathOut( "xml" );
                dialog = new BFileChooser();
                dialog.setSelectedFile( first );
                dialog.addFileFilter( _( "MusicXML(*.xml)|*.xml" ) );
                dialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
                int result = AppManager.showModalDialog( dialog, false, this );
                if ( result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                String file = dialog.getSelectedFile();
                String software = "Cadencii version " + BAssemblyInfo.fileVersion;
                vsq.printAsMusicXml( file, "UTF-8", software );
                AppManager.editorConfig.setLastUsedPathOut( file, ".xml" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportMusicXml_Click; ex=" + ex + "\n" );
                serr.println( "FormMain#menuFileExportMusicXml_Click; ex=" + ex );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportMusicXml_Click; ex=" + ex2 + "\n" );
                        serr.println( "FormMain#menuFileExportMusicXml_Click; ex2=" + ex2 );
                    }
                }
            }
        }

        public void menuFileExportParaWave_Click( Object sender, EventArgs e )
        {
            // 出力するディレクトリを選択
            String dir = "";
            BFolderBrowser file_dialog = null;
            try {
                file_dialog = new BFolderBrowser();
                String initial_dir = AppManager.editorConfig.getLastUsedPathOut( "wav" );
                file_dialog.setDescription( _( "Choose destination directory" ) );
                file_dialog.setSelectedPath( initial_dir );
                BDialogResult ret = AppManager.showModalDialog( file_dialog, this );
                if ( ret != BDialogResult.OK ) {
                    return;
                }
                dir = file_dialog.getSelectedPath();
                // 1.wavはダミー
                initial_dir = fsys.combine( dir, "1.wav" );
                AppManager.editorConfig.setLastUsedPathOut( initial_dir, ".wav" );
            } catch ( Exception ex ) {
            } finally {
                if ( file_dialog != null ) {
                    try {
                        file_dialog.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }

            // 全部レンダリング済みの状態にするためのキュー
            VsqFileEx vsq = AppManager.getVsqFile();
            Vector<Integer> tracks = new Vector<Integer>();
            int size = vsq.Track.size();
            for ( int i = 1; i < size; i++ ) {
                tracks.add( i );
            }
            Vector<PatchWorkQueue> queue = AppManager.patchWorkCreateQueue( tracks );

            // 全トラックをファイルに出力するためのキュー
            int clockStart = vsq.config.StartMarkerEnabled ? vsq.config.StartMarker : 0;
            int clockEnd = vsq.config.EndMarkerEnabled ? vsq.config.EndMarker : vsq.TotalClocks + 240;
            if ( clockStart > clockEnd ) {
                AppManager.showMessageBox(
                    _( "invalid rendering region; start>=end" ),
                    _( "Error" ),
                    PortUtil.OK_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                return;
            }
            for ( int i = 1; i < size; i++ ) {
                PatchWorkQueue q = new PatchWorkQueue();
                q.track = i;
                q.clockStart = clockStart;
                q.clockEnd = clockEnd;
                q.file = fsys.combine( dir, i + ".wav" );
                q.renderAll = true;
                q.vsq = vsq;
                queue.add( q );
            }

            // 合成ダイアログを出す
            FormWorker fw = null;
            try {
                fw = new FormWorker();
                fw.setupUi( new FormWorkerUi( fw ) );
                fw.getUi().setTitle( _( "Synthesize" ) );
                fw.getUi().setText( _( "now synthesizing..." ) );

                SynthesizeWorker worker = new SynthesizeWorker( this );

                for( int i  = 0; i < queue.size(); i++ ){
                    PatchWorkQueue q = vec.get( queue, i );
                    fw.addJob( worker, "processQueue", q.getMessage(), q.getJobAmount(), q );
                }

                fw.startJob();
                AppManager.showModalDialog( fw.getUi(), this );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportParaWave; ex=" + ex + "\n" );
            } finally {
                if ( fw != null ) {
                    try {
                        fw.getUi().close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuFileExportUst_Click( Object sender, EventArgs e )
        {
            VsqFileEx vsq = (VsqFileEx)AppManager.getVsqFile().clone();

            // どのトラックを出力するか決める
            int selected = AppManager.getSelected();

            // 出力先のファイル名を選ぶ
            BFileChooser dialog = null;
            int dialog_result = BFileChooser.CANCEL_OPTION;
            String file_name = "";
            try {
                String last_path = AppManager.editorConfig.getLastUsedPathOut( "ust" );
                dialog = new BFileChooser();
                dialog.setSelectedFile( last_path );
                dialog.setDialogTitle( _( "Export UTAU (*.ust)" ) );
                dialog.addFileFilter( _( "UTAU Script Format(*.ust)|*.ust" ) );
                dialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog_result = AppManager.showModalDialog( dialog, false, this );
                if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                file_name = dialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathOut( file_name, ".ust" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportUst_Click; ex=" + ex + "\n" );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportUst_Click; ex=" + ex2 + "\n" );
                    }
                }
            }

            // 出力処理
            vsq.removePart( 0, vsq.getPreMeasureClocks() );
            UstFile ust = new UstFile( vsq, selected );
            // voice dirを設定
            VsqTrack vsq_track = vsq.Track.get( selected );
            VsqEvent singer = vsq_track.getSingerEventAt( 0 );
            String voice_dir = "";
            if ( singer != null ) {
                int program = singer.ID.IconHandle.Program;
                int size = AppManager.editorConfig.UtauSingers.size();
                if ( 0 <= program && program < size ) {
                    SingerConfig cfg = AppManager.editorConfig.UtauSingers.get( program );
                    voice_dir = cfg.VOICEIDSTR;
                }
            }
            ust.setVoiceDir( voice_dir );
            ust.setWavTool( AppManager.editorConfig.PathWavtool );
            int resampler_index = VsqFileEx.getTrackResamplerUsed( vsq_track );
            if ( 0 <= resampler_index && resampler_index < AppManager.editorConfig.getResamplerCount() ) {
                ust.setResampler(
                    AppManager.editorConfig.getResamplerAt( resampler_index ) );
            }
            ust.write( file_name );
        }

        public void menuFileExportVsq_Click( Object sender, EventArgs e )
        {
            VsqFileEx vsq = AppManager.getVsqFile();

            // 出力先のファイル名を選ぶ
            BFileChooser dialog = null;
            int dialog_result = BFileChooser.CANCEL_OPTION;
            String file_name = "";
            try {
                String last_path = AppManager.editorConfig.getLastUsedPathOut( "vsq" );
                dialog = new BFileChooser();
                dialog.setSelectedFile( last_path );
                dialog.setDialogTitle( _( "Export VSQ (*.vsq)" ) );
                dialog.addFileFilter( _( "VSQ Format(*.vsq)|*.vsq" ) );
                dialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog_result = AppManager.showModalDialog( dialog, false, this );
                if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                file_name = dialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathOut( file_name, ".vsq" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportVsq_Click; ex=" + ex + "\n" );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportVsq_Click; ex=" + ex2 + "\n" );
                    }
                }
            }

            // 出力処理
            VsqFile tvsq = (VsqFile)vsq;
            tvsq.write( file_name, AppManager.editorConfig.PreSendTime, "Shift_JIS" );
        }

        public void menuFileExportVxt_Click( Object sender, EventArgs e )
        {
            // UTAUの歌手が登録されていない場合は警告を表示
            if ( AppManager.editorConfig.UtauSingers.size() <= 0 ) {
                BDialogResult dr = AppManager.showMessageBox(
                    _( "UTAU singer not registered yet.\nContinue ?" ),
                    _( "Info" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                if ( dr != BDialogResult.YES ) {
                    return;
                }
            }

            VsqFileEx vsq = AppManager.getVsqFile();

            // 出力先のファイル名を選ぶ
            BFileChooser dialog = null;
            int dialog_result = BFileChooser.CANCEL_OPTION;
            String file_name = "";
            try {
                String last_path = AppManager.editorConfig.getLastUsedPathOut( "txt" );
                dialog = new BFileChooser();
                dialog.setSelectedFile( last_path );
                dialog.setDialogTitle( _( "Metatext for vConnect" ) );
                dialog.addFileFilter( _( "Text File(*.txt)|*.txt" ) );
                dialog.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog_result = AppManager.showModalDialog( dialog, false, this );
                if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                file_name = dialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathOut( file_name, ".txt" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportVxt_Click; ex=" + ex + "\n" );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportVxt_Click; ex=" + ex2 + "\n" );
                    }
                }
            }

            // 出力処理
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( file_name ), "UTF-8" ) );
                String oto_ini = AppManager.editorConfig.UtauSingers.get( 0 ).VOICEIDSTR;
                // 先頭に登録されている歌手変更を検出
                VsqEvent singer = null;
                int c = vsq_track.getEventCount();
                for ( int i = 0; i < c; i++ ) {
                    VsqEvent itemi = vsq_track.getEvent( i );
                    if ( itemi.ID.type == VsqIDType.Singer ) {
                        singer = itemi;
                        break;
                    }
                }
                // 歌手のプログラムチェンジから，歌手の原音設定へのパスを取得する
                if ( singer != null ) {
                    int indx = singer.ID.IconHandle.Program;
                    if ( 0 <= indx && indx < AppManager.editorConfig.UtauSingers.size() ) {
                        oto_ini = AppManager.editorConfig.UtauSingers.get( indx ).VOICEIDSTR;
                    }
                }

                // oto.iniで終わってる？
                if ( !oto_ini.EndsWith( "oto.ini" ) ) {
                    oto_ini = fsys.combine( oto_ini, "oto.ini" );
                }

                // 出力
                VConnectWaveGenerator.prepareMetaText(
                    bw, vsq_track, oto_ini, vsq.TotalClocks, false );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportVxt_Click; ex=" + ex + "\n" );
                serr.println( typeof( FormMain ) + ".menuFileExportVxt_Click; ex=" + ex );
            } finally {
                if ( bw != null ) {
                    try {
                        bw.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuFileExportWave_Click( Object sender, EventArgs e )
        {
            int dialog_result = BFileChooser.CANCEL_OPTION;
            String filename = "";
            BFileChooser sfd = null;
            try {
                String last_path = AppManager.editorConfig.getLastUsedPathOut( "wav" );
#if DEBUG
                sout.println( "FormMain#menuFileExportWave_Click; last_path=" + last_path );
#endif
                sfd = new BFileChooser();
                sfd.setSelectedFile( last_path );
                sfd.setDialogTitle( _( "Wave Export" ) );
                sfd.addFileFilter( _( "Wave File(*.wav)|*.wav" ) );
                sfd.addFileFilter( _( "All Files(*.*)|*.*" ) );
                dialog_result = AppManager.showModalDialog( sfd, false, this );
                if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                filename = sfd.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathOut( filename, ".wav" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportWave_Click; ex=" + ex + "\n" );
            } finally {
                if ( sfd != null ) {
                    try {
#if !JAVA
                        sfd.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportWave_Click; ex=" + ex2 + "\n" );
                    }
                }
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            int clockStart = vsq.config.StartMarkerEnabled ? vsq.config.StartMarker : 0;
            int clockEnd = vsq.config.EndMarkerEnabled ? vsq.config.EndMarker : vsq.TotalClocks + 240;
            if ( clockStart > clockEnd ) {
                AppManager.showMessageBox(
                    _( "invalid rendering region; start>=end" ),
                    _( "Error" ),
                    PortUtil.OK_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                return;
            }
            Vector<Integer> other_tracks = new Vector<Integer>();
            int selected = AppManager.getSelected();
            for ( int i = 1; i < vsq.Track.size(); i++ ) {
                if ( i != selected ) {
                    other_tracks.add( i );
                }
            }
            Vector<PatchWorkQueue> queue =
                AppManager.patchWorkCreateQueue( other_tracks );
            PatchWorkQueue q = new PatchWorkQueue();
            q.track = selected;
            q.clockStart = clockStart;
            q.clockEnd = clockEnd;
            q.file = filename;
            q.renderAll = true;
            q.vsq = vsq;
            // 末尾に追加
            queue.add( q );
            double started = PortUtil.getCurrentTime();

            FormWorker fs = null;
            try {
                fs = new FormWorker();
                fs.setupUi( new FormWorkerUi( fs ) );
                fs.getUi().setTitle( _( "Synthesize" ) );
                fs.getUi().setText( _( "now synthesizing..." ) );

                SynthesizeWorker worker = new SynthesizeWorker( this );

                foreach ( PatchWorkQueue qb in queue ) {
                    fs.addJob( worker, "processQueue", qb.getMessage(), qb.getJobAmount(), qb );
                }

                fs.startJob();
                AppManager.showModalDialog( fs.getUi(), this );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileExportWave_Click; ex=" + ex + "\n" );
            } finally {
                if ( fs != null ) {
                    try {
                        fs.getUi().close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuFileExportWave_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuFileImportMidi_Click( Object sender, EventArgs e )
        {
            if ( mDialogMidiImportAndExport == null ) {
                mDialogMidiImportAndExport = new FormMidiImExport();
            }
            mDialogMidiImportAndExport.listTrack.clear();
            mDialogMidiImportAndExport.setMode( FormMidiImExport.FormMidiMode.IMPORT );

            String dir = AppManager.editorConfig.getLastUsedPathIn( "mid" );
            openMidiDialog.setSelectedFile( dir );
            int dialog_result = AppManager.showModalDialog( openMidiDialog, true, this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            mDialogMidiImportAndExport.setLocation( getFormPreferedLocation( mDialogMidiImportAndExport ) );
            MidiFile mf = null;
            try {
                String filename = openMidiDialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathIn( filename, ".mid" );
                mf = new MidiFile( filename );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileImportMidi_Click; ex=" + ex + "\n" );
                AppManager.showMessageBox(
                    _( "Invalid MIDI file." ),
                    _( "Error" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            if ( mf == null ) {
                AppManager.showMessageBox(
                    _( "Invalid MIDI file." ),
                    _( "Error" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            int count = mf.getTrackCount();
            //Encoding def_enc = Encoding.GetEncoding( 0 );
            for ( int i = 0; i < count; i++ ) {
                String track_name = "";
                int notes = 0;
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                int events_count = events.size();

                // トラック名を取得
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( item.firstByte == 0xff && item.data.Length >= 2 && item.data[0] == 0x03 ) {
                        int[] d = new int[item.data.Length];
                        for ( int k = 0; k < item.data.Length; k++ ) {
                            d[k] = 0xff & item.data[k];
                        }
                        track_name = PortUtil.getDecodedString( "Shift_JIS", d, 1, item.data.Length - 1 );
                        break;
                    }
                }

                // イベント数を数える
                for ( int j = 0; j < events_count; j++ ) {
                    MidiEvent item = events.get( j );
                    if ( (item.firstByte & 0xf0) == 0x90 && item.data.Length > 1 && item.data[1] > 0x00 ) {
                        notes++;
                    }
                }
                mDialogMidiImportAndExport.listTrack.addRow(
                    new String[] { i + "", track_name, notes + "" }, true );
            }

            BDialogResult dr = AppManager.showModalDialog( mDialogMidiImportAndExport, this );
            if ( dr != BDialogResult.OK ) {
                return;
            }

            boolean secondBasis = mDialogMidiImportAndExport.isSecondBasis();
            int offsetClocks = mDialogMidiImportAndExport.getOffsetClocks();
            double offsetSeconds = mDialogMidiImportAndExport.getOffsetSeconds();
            boolean importFromPremeasure = mDialogMidiImportAndExport.isPreMeasure();

            // インポートするしないにかかわらずテンポと拍子を取得
            VsqFileEx tempo = new VsqFileEx( "Miku", 2, 4, 4, 500000 ); //テンポリスト用のVsqFile。テンポの部分のみ使用
            tempo.executeCommand( VsqCommand.generateCommandChangePreMeasure( 0 ) );
            boolean tempo_added = false;
            boolean timesig_added = false;
            tempo.TempoTable.clear();
            tempo.TimesigTable.clear();
            int mf_getTrackCount = mf.getTrackCount();
            for ( int i = 0; i < mf_getTrackCount; i++ ) {
                Vector<MidiEvent> events = mf.getMidiEventList( i );
                boolean t_tempo_added = false;   //第iトラックからテンポをインポートしたかどうか
                boolean t_timesig_added = false; //第iトラックから拍子をインポートしたかどうか
                int last_timesig_clock = 0; // 最後に拍子変更を検出したゲートタイム
                int last_num = 4; // 最後に検出した拍子変更の分子
                int last_den = 4; // 最後に検出した拍子変更の分母
                int last_barcount = 0;
                int events_Count = events.size();
                for ( int j = 0; j < events_Count; j++ ) {
                    MidiEvent itemj = events.get( j );
                    if ( !tempo_added && itemj.firstByte == 0xff && itemj.data.Length >= 4 && itemj.data[0] == 0x51 ) {
                        boolean contains_same_clock = false;
                        int size = tempo.TempoTable.size();
                        // 同時刻のテンポ変更は、最初以外無視する
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TempoTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            int vtempo = itemj.data[1] << 16 | itemj.data[2] << 8 | itemj.data[3];
                            tempo.TempoTable.add( new TempoTableEntry( (int)itemj.clock, vtempo, 0.0 ) );
                            t_tempo_added = true;
                        }
                    }
                    if ( !timesig_added && itemj.firstByte == 0xff && itemj.data.Length >= 5 && itemj.data[0] == 0x58 ) {
                        int num = itemj.data[1];
                        int den = 1;
                        for ( int k = 0; k < itemj.data[2]; k++ ) {
                            den = den * 2;
                        }
                        int clock_per_bar = last_num * 480 * 4 / last_den;
                        int barcount_at_itemj = last_barcount + ((int)itemj.clock - last_timesig_clock) / clock_per_bar;
                        // 同時刻の拍子変更は、最初以外無視する
                        int size = tempo.TimesigTable.size();
                        boolean contains_same_clock = false;
                        for ( int k = 0; k < size; k++ ) {
                            if ( tempo.TimesigTable.get( k ).Clock == itemj.clock ) {
                                contains_same_clock = true;
                                break;
                            }
                        }
                        if ( !contains_same_clock ) {
                            tempo.TimesigTable.add( new TimeSigTableEntry( (int)itemj.clock, num, den, barcount_at_itemj ) );
                            last_timesig_clock = (int)itemj.clock;
                            last_den = den;
                            last_num = num;
                            last_barcount = barcount_at_itemj;
                            t_timesig_added = true;
                        }
                    }
                }
                if ( t_tempo_added ) {
                    tempo_added = true;
                }
                if ( t_timesig_added ) {
                    timesig_added = true;
                }
                if ( timesig_added && tempo_added ) {
                    // 両方ともインポート済みならexit。2個以上のトラックから、重複してテンポや拍子をインポートするのはNG（たぶん）
                    break;
                }
            }
            boolean contains_zero = false;
            int c = tempo.TempoTable.size();
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TempoTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TempoTable.add( new TempoTableEntry( 0, 500000, 0.0 ) );
            }
            contains_zero = false;
            // =>
            // Thanks, げっぺータロー.
            // BEFORE:
            // c = tempo.TempoTable.size();
            // AFTER:
            c = tempo.TimesigTable.size();
            // <=
            for ( int i = 0; i < c; i++ ) {
                if ( tempo.TimesigTable.get( i ).Clock == 0 ) {
                    contains_zero = true;
                    break;
                }
            }
            if ( !contains_zero ) {
                tempo.TimesigTable.add( new TimeSigTableEntry( 0, 4, 4, 0 ) );
            }
            VsqFileEx work = (VsqFileEx)AppManager.getVsqFile().clone(); //後でReplaceコマンドを発行するための作業用
            int preMeasureClocks = work.getPreMeasureClocks();
            double sec_at_premeasure = work.getSecFromClock( preMeasureClocks );
            if ( !mDialogMidiImportAndExport.isPreMeasure() ) {
                sec_at_premeasure = 0.0;
            }
            VsqFileEx copy_src = (VsqFileEx)tempo.clone();
            if ( sec_at_premeasure != 0.0 ) {
                int t = work.TempoTable.get( 0 ).Tempo;
                VsqFileEx.shift( copy_src, sec_at_premeasure, t );
            }
            tempo.updateTempoInfo();
            tempo.updateTimesigInfo();

            // tempoをインポート
            boolean import_tempo = mDialogMidiImportAndExport.isTempo();
            if ( import_tempo ) {
#if DEBUG
                sout.println( "FormMain#menuFileImportMidi_Click; sec_at_premeasure=" + sec_at_premeasure );
#endif
                // 最初に、workにある全てのイベント・コントロールカーブ・ベジエ曲線をtempoのテンポテーブルに合うように、シフトする
                //ShiftClockToMatchWith( work, copy_src, work.getSecFromClock( work.getPreMeasureClocks() ) );
                //ShiftClockToMatchWith( work, copy_src, copy_src.getSecFromClock( copy_src.getPreMeasureClocks() ) );
                if ( secondBasis ) {
                    shiftClockToMatchWith( work, copy_src, sec_at_premeasure );
                }

                work.TempoTable.clear();
                Vector<TempoTableEntry> list = copy_src.TempoTable;
                int list_count = list.size();
                for ( int i = 0; i < list_count; i++ ) {
                    TempoTableEntry item = list.get( i );
                    work.TempoTable.add( new TempoTableEntry( item.Clock, item.Tempo, item.Time ) );
                }
                work.updateTempoInfo();
            }

            // timesig
            if ( mDialogMidiImportAndExport.isTimesig() ) {
                work.TimesigTable.clear();
                Vector<TimeSigTableEntry> list = tempo.TimesigTable;
                int list_count = vec.size( list );
                for ( int i = 0; i < list_count; i++ ) {
                    TimeSigTableEntry item = list.get( i );
                    work.TimesigTable.add( 
                        new TimeSigTableEntry(
                            item.Clock,
                            item.Numerator,
                            item.Denominator,
                            item.BarCount ) );
                }
                Collections.sort( work.TimesigTable );
                work.updateTimesigInfo();
            }

            for ( int i = 0; i < mDialogMidiImportAndExport.listTrack.getItemCountRow(); i++ ) {
                if ( !mDialogMidiImportAndExport.listTrack.isRowChecked( i ) ) {
                    continue;
                }
                if ( vec.size( work.Track ) + 1 > 16 ) {
                    break;
                }
                VsqTrack work_track = new VsqTrack( mDialogMidiImportAndExport.listTrack.getItemAt( i, 1 ), "Miku" );

                // デフォルトの音声合成システムに切り替え
                RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
                String renderer = AppManager.getVersionStringFromRendererKind( kind );
                Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
                work_track.changeRenderer( renderer, singers );

                Vector<MidiEvent> events = mf.getMidiEventList( i );
                Collections.sort( events );
                int events_count = vec.size( events );

                // note
                if ( mDialogMidiImportAndExport.isNotes() ) {
                    int[] onclock_each_note = new int[128];
                    int[] velocity_each_note = new int[128];
                    for ( int j = 0; j < 128; j++ ) {
                        onclock_each_note[j] = -1;
                        velocity_each_note[j] = 64;
                    }
                    int last_note = -1;
                    for ( int j = 0; j < events_count; j++ ) {
                        MidiEvent itemj = vec.get( events, j );
                        int not_closed_note = -1;
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            for ( int m = 0; m < 128; m++ ) {
                                if ( onclock_each_note[m] >= 0 ) {
                                    not_closed_note = m;
                                    break;
                                }
                            }
                        }
#if DEBUG
                        sout.println( "FormMain#menuFileImprotMidi_Click; not_closed_note=" + not_closed_note );
#endif
                        if ( ((itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] == 0) ||
                             ((itemj.firstByte & 0xf0) == 0x80 && itemj.data.Length >= 2) ||
                             not_closed_note >= 0 ) {
                            int clock_off = (int)itemj.clock;
                            int note = (int)itemj.data[0];
                            if ( not_closed_note >= 0 ) {
                                note = not_closed_note;
                            }
                            if ( onclock_each_note[note] >= 0 ) {
                                int add_clock_on = onclock_each_note[note];
                                int add_clock_off = clock_off;
                                if ( secondBasis ) {
                                    double time_clock_on = tempo.getSecFromClock( onclock_each_note[note] ) + sec_at_premeasure + offsetSeconds;
                                    double time_clock_off = tempo.getSecFromClock( clock_off ) + sec_at_premeasure + offsetSeconds;
                                    add_clock_on = (int)work.getClockFromSec( time_clock_on );
                                    add_clock_off = (int)work.getClockFromSec( time_clock_off );
                                } else {
                                    add_clock_on += (importFromPremeasure ? preMeasureClocks : 0) + offsetClocks;
                                    add_clock_off += (importFromPremeasure ? preMeasureClocks : 0) + offsetClocks;
                                }
                                if ( add_clock_on < 0 ) {
                                    add_clock_on = 0;
                                }
                                if ( add_clock_off < 0 ) {
                                    continue;
                                }
                                VsqID vid = new VsqID( 0 );
                                vid.type = VsqIDType.Anote;
                                vid.setLength( add_clock_off - add_clock_on );
#if DEBUG
                                sout.println( "FormMain#menuFileImportMidi_Click; vid.Length=" + vid.getLength() );
#endif
                                String phrase = "a";
                                if ( mDialogMidiImportAndExport.isLyric() ) {
                                    for ( int k = 0; k < events_count; k++ ) {
                                        MidiEvent itemk = vec.get( events, k );
                                        if ( onclock_each_note[note] <= (int)itemk.clock && (int)itemk.clock <= clock_off ) {
                                            if ( itemk.firstByte == 0xff && itemk.data.Length >= 2 && itemk.data[0] == 0x05 ) {
                                                int[] d = new int[itemk.data.Length - 1];
                                                for ( int m = 1; m < itemk.data.Length; m++ ) {
                                                    d[m - 1] = 0xff & itemk.data[m];
                                                }
                                                phrase = PortUtil.getDecodedString( "Shift_JIS", d, 0, itemk.data.Length );
                                                break;
                                            }
                                        }
                                    }
                                }
                                vid.LyricHandle = new LyricHandle( phrase, "a" );
                                vid.Note = note;
                                vid.Dynamics = velocity_each_note[note];
                                // デフォルとの歌唱スタイルを適用する
                                AppManager.editorConfig.applyDefaultSingerStyle( vid );

                                // ビブラート
                                if ( AppManager.editorConfig.EnableAutoVibrato ) {
                                    int note_length = vid.getLength();
                                    // 音符位置での拍子を調べる
                                    Timesig timesig = work.getTimesigAt( add_clock_on );

                                    // ビブラートを自動追加するかどうかを決める閾値
                                    int threshold = AppManager.editorConfig.AutoVibratoThresholdLength;
                                    if ( note_length >= threshold ) {
                                        int vibrato_clocks = 0;
                                        DefaultVibratoLengthEnum vib_length = AppManager.editorConfig.DefaultVibratoLength;
                                        if ( vib_length == DefaultVibratoLengthEnum.L100 ) {
                                            vibrato_clocks = note_length;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L50 ) {
                                            vibrato_clocks = note_length / 2;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L66 ) {
                                            vibrato_clocks = note_length * 2 / 3;
                                        } else if ( vib_length == DefaultVibratoLengthEnum.L75 ) {
                                            vibrato_clocks = note_length * 3 / 4;
                                        }
                                        // とりあえずVOCALOID2のデフォルトビブラートの設定を使用
                                        vid.VibratoHandle = AppManager.editorConfig.createAutoVibrato( SynthesizerType.VOCALOID2, vibrato_clocks );
                                        vid.VibratoDelay = note_length - vibrato_clocks;
                                    }
                                }

                                VsqEvent ve = new VsqEvent( add_clock_on, vid );
                                work_track.addEvent( ve );
                                onclock_each_note[note] = -1;
                            }
                        }
                        if ( (itemj.firstByte & 0xf0) == 0x90 && itemj.data.Length >= 2 && itemj.data[1] > 0 ) {
                            int note = itemj.data[0];
                            onclock_each_note[note] = (int)itemj.clock;
                            int vel = itemj.data[1];
                            velocity_each_note[note] = vel;
                            last_note = note;
                        }
                    }

                    int track = vec.size( work.Track );
                    CadenciiCommand run_add =
                        VsqFileEx.generateCommandAddTrack(
                            work_track,
                            new VsqMixerEntry( 0, 0, 0, 0 ),
                            track,
                            new BezierCurves() );
                    work.executeCommand( run_add );
                }
            }

            CadenciiCommand lastrun = VsqFileEx.generateCommandReplace( work );
            AppManager.register( AppManager.getVsqFile().executeCommand( lastrun ) );
            setEdited( true );
            refreshScreen();
        }

        public void menuFileImportUst_Click( Object sender, EventArgs e )
        {
            BFileChooser dialog = null;
            try {
                // 読み込むファイルを選ぶ
                String dir = AppManager.editorConfig.getLastUsedPathIn( "ust" );
                dialog = new BFileChooser();
                dialog.setSelectedFile( dir );
                int dialog_result = AppManager.showModalDialog( dialog, true, this );
                if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                    return;
                }
                String file = dialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathIn( file, ".ust" );

                // ustを読み込む
                UstFile ust = new UstFile( file );

                // vsqに変換
                VsqFile vsq = new VsqFile( ust );
                vsq.insertBlank( 0, vsq.getPreMeasureClocks() );

                // RendererKindをUTAUに指定
                for ( int i = 1; i < vec.size( vsq.Track ); i++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, i );
                    VsqFileEx.setTrackRendererKind( vsq_track, RendererKind.UTAU );
                }

                // unknownな歌手とresamplerを何とかする
                ByRef<String> ref_resampler = new ByRef<String>( ust.getResampler() );
                ByRef<String> ref_singer = new ByRef<String>( ust.getVoiceDir() );
                checkUnknownResamplerAndSinger( ref_resampler, ref_singer );

                // 歌手変更を何とかする
                int program = 0;
                for ( int i = 0; i < vec.size( AppManager.editorConfig.UtauSingers ); i++ ) {
                    SingerConfig sc = vec.get( AppManager.editorConfig.UtauSingers, i );
                    if ( sc == null ) {
                        continue;
                    }
                    if ( str.compare( sc.VOICEIDSTR, ref_singer.value ) ) {
                        program = i;
                        break;
                    }
                }
                // 歌手変更のテンプレートを作成
                VsqID singer_id = Utility.getSingerID( RendererKind.UTAU, program, 0 );
                if ( singer_id == null ) {
                    singer_id = new VsqID();
                    singer_id.type = VsqIDType.Singer;
                    singer_id.IconHandle = new IconHandle();
                    singer_id.IconHandle.Program = program;
                    singer_id.IconHandle.IconID = "$0401" + PortUtil.toHexString( 0, 4 );
                }
                // トラックの歌手変更イベントをすべて置き換える
                for ( int i = 1; i < vec.size( vsq.Track ); i++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, i );
                    int c = vsq_track.getEventCount();
                    for ( int j = 0; j < c; j++ ) {
                        VsqEvent itemj = vsq_track.getEvent( j );
                        if ( itemj.ID.type == VsqIDType.Singer ) {
                            itemj.ID = (VsqID)singer_id.clone();
                        }
                    }
                }

                // resamplerUsedを更新(可能なら)
                for ( int j = 1; j < vec.size( vsq.Track ); j++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, j );
                    for ( int i = 0; i < AppManager.editorConfig.getResamplerCount(); i++ ) {
                        String resampler = AppManager.editorConfig.getResamplerAt( i );
                        if ( str.compare( resampler, ref_resampler.value ) ) {
                            VsqFileEx.setTrackResamplerUsed( vsq_track, i );
                            break;
                        }
                    }
                }

                // 読込先のvsqと，インポートするvsqではテンポテーブルがずれているので，
                // 読み込んだ方のvsqの内容を，現在のvsqと合致するように編集する
                VsqFileEx dst = (VsqFileEx)AppManager.getVsqFile().clone();
                vsq.adjustClockToMatchWith( dst.TempoTable );

                // トラック数の上限になるまで挿入を実行
                int size = vsq.Track.size();
                for ( int i = 1; i < size; i++ ) {
                    if ( dst.Track.size() + 1 >= VsqFile.MAX_TRACKS + 1 ) {
                        // トラック数の上限
                        break;
                    }
                    dst.Track.add( vsq.Track.get( i ) );
                    dst.AttachedCurves.add( new BezierCurves() );
                    dst.Mixer.Slave.add( new VsqMixerEntry() );
                }

                // コマンドを発行して実行
                CadenciiCommand run = VsqFileEx.generateCommandReplace( dst );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                AppManager.mMixerWindow.updateStatus();
                setEdited( true );
                refreshScreen( true );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileImportUst_Click; ex=" + ex + "\t" );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex ) {
                    }
                }
            }
        }

        public void menuFileImportVsq_Click( Object sender, EventArgs e )
        {
            String dir = AppManager.editorConfig.getLastUsedPathIn( AppManager.editorConfig.LastUsedExtension );
            openMidiDialog.setSelectedFile( dir );
            int dialog_result = AppManager.showModalDialog( openMidiDialog, true, this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            VsqFileEx vsq = null;
            String filename = openMidiDialog.getSelectedFile();
            AppManager.editorConfig.setLastUsedPathIn( filename, ".vsq" );
            try {
                vsq = new VsqFileEx( filename, "Shift_JIS" );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileImportVsq_Click; ex=" + ex + "\n" );
                AppManager.showMessageBox( _( "Invalid VSQ/VOCALOID MIDI file" ), _( "Error" ), org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION, org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            if ( mDialogMidiImportAndExport == null ) {
                mDialogMidiImportAndExport = new FormMidiImExport();
            }
            mDialogMidiImportAndExport.listTrack.clear();
            for ( int track = 1; track < vsq.Track.size(); track++ ) {
                mDialogMidiImportAndExport.listTrack.addRow( new String[] { 
                    track + "", 
                    vsq.Track.get( track ).getName(),
                    vsq.Track.get( track ).getEventCount() + "" }, true );
            }
            mDialogMidiImportAndExport.setMode( FormMidiImExport.FormMidiMode.IMPORT_VSQ );
            mDialogMidiImportAndExport.setTempo( false );
            mDialogMidiImportAndExport.setTimesig( false );
            mDialogMidiImportAndExport.setLocation( getFormPreferedLocation( mDialogMidiImportAndExport ) );
            BDialogResult dr = AppManager.showModalDialog( mDialogMidiImportAndExport, this );
            if ( dr != BDialogResult.OK ) {
                return;
            }

            Vector<Integer> add_track = new Vector<Integer>();
            for ( int i = 0; i < mDialogMidiImportAndExport.listTrack.getItemCountRow(); i++ ) {
                if ( mDialogMidiImportAndExport.listTrack.isRowChecked( i ) ) {
                    add_track.add( i + 1 );
                }
            }
            if ( add_track.size() <= 0 ) {
                return;
            }

            VsqFileEx replace = (VsqFileEx)AppManager.getVsqFile().clone();
            double premeasure_sec_replace = replace.getSecFromClock( replace.getPreMeasureClocks() );
            double premeasure_sec_vsq = vsq.getSecFromClock( vsq.getPreMeasureClocks() );

            if ( mDialogMidiImportAndExport.isTempo() ) {
                shiftClockToMatchWith( replace, vsq, premeasure_sec_replace - premeasure_sec_vsq );
                // テンポテーブルを置き換え
                replace.TempoTable.clear();
                for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                    replace.TempoTable.add( (TempoTableEntry)vsq.TempoTable.get( i ).clone() );
                }
                replace.updateTempoInfo();
                replace.updateTotalClocks();
            }

            if ( mDialogMidiImportAndExport.isTimesig() ) {
                // 拍子をリプレースする場合
                replace.TimesigTable.clear();
                for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                    replace.TimesigTable.add( (TimeSigTableEntry)vsq.TimesigTable.get( i ).clone() );
                }
                replace.updateTimesigInfo();
            }

            for ( Iterator<Integer> itr = add_track.iterator(); itr.hasNext(); ) {
                int track = itr.next();
                if ( replace.Track.size() + 1 >= 16 ) {
                    break;
                }
                if ( !mDialogMidiImportAndExport.isTempo() ) {
                    // テンポをリプレースしない場合。インポートするトラックのクロックを調節する
                    for ( Iterator<VsqEvent> itr2 = vsq.Track.get( track ).getEventIterator(); itr2.hasNext(); ) {
                        VsqEvent item = itr2.next();
                        if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                            continue;
                        }
                        int clock = item.Clock;
                        double sec_start = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                        double sec_end = vsq.getSecFromClock( clock + item.ID.getLength() ) - premeasure_sec_vsq + premeasure_sec_replace;
                        int clock_start = (int)replace.getClockFromSec( sec_start );
                        int clock_end = (int)replace.getClockFromSec( sec_end );
                        item.Clock = clock_start;
                        item.ID.setLength( clock_end - clock_start );
                        if ( item.ID.VibratoHandle != null ) {
                            double sec_vib_start = vsq.getSecFromClock( clock + item.ID.VibratoDelay ) - premeasure_sec_vsq + premeasure_sec_replace;
                            int clock_vib_start = (int)replace.getClockFromSec( sec_vib_start );
                            item.ID.VibratoDelay = clock_vib_start - clock_start;
                            item.ID.VibratoHandle.setLength( clock_end - clock_vib_start );
                        }
                    }

                    // コントロールカーブをシフト
                    foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                        VsqBPList item = vsq.Track.get( track ).getCurve( ct.getName() );
                        if ( item == null ) {
                            continue;
                        }
                        VsqBPList repl = new VsqBPList( item.getName(), item.getDefault(), item.getMinimum(), item.getMaximum() );
                        for ( int i = 0; i < item.size(); i++ ) {
                            int clock = item.getKeyClock( i );
                            int value = item.getElement( i );
                            double sec = vsq.getSecFromClock( clock ) - premeasure_sec_vsq + premeasure_sec_replace;
                            if ( sec >= premeasure_sec_replace ) {
                                int clock_new = (int)replace.getClockFromSec( sec );
                                repl.add( clock_new, value );
                            }
                        }
                        vsq.Track.get( track ).setCurve( ct.getName(), repl );
                    }

                    // ベジエカーブをシフト
                    foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                        Vector<BezierChain> list = vsq.AttachedCurves.get( track - 1 ).get( ct );
                        if ( list == null ) {
                            continue;
                        }
                        for ( Iterator<BezierChain> itr2 = list.iterator(); itr2.hasNext(); ) {
                            BezierChain chain = itr2.next();
                            for ( Iterator<BezierPoint> itr3 = chain.points.iterator(); itr3.hasNext(); ) {
                                BezierPoint point = itr3.next();
                                PointD bse = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.getBase().getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                         point.getBase().getY() );
                                PointD ctrl_r = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlLeft.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlLeft.getY() );
                                PointD ctrl_l = new PointD( replace.getClockFromSec( vsq.getSecFromClock( point.controlRight.getX() ) - premeasure_sec_vsq + premeasure_sec_replace ),
                                                            point.controlRight.getY() );
                                point.setBase( bse );
                                point.controlLeft = ctrl_l;
                                point.controlRight = ctrl_r;
                            }
                        }
                    }
                }
                replace.Mixer.Slave.add( new VsqMixerEntry() );
                replace.Track.add( vsq.Track.get( track ) );
                replace.AttachedCurves.add( vsq.AttachedCurves.get( track - 1 ) );
            }

            // コマンドを発行し、実行
            CadenciiCommand run = VsqFileEx.generateCommandReplace( replace );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        public void menuFileOpenUst_Click( Object sender, EventArgs e )
        {
            if ( !dirtyCheck() ) {
                return;
            }

            String dir = AppManager.editorConfig.getLastUsedPathIn( "ust" );
            openUstDialog.setSelectedFile( dir );
            int dialog_result = AppManager.showModalDialog( openUstDialog, true, this );

            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }

            try {
                String filename = openUstDialog.getSelectedFile();
                AppManager.editorConfig.setLastUsedPathIn( filename, ".ust" );
                
                // ust読み込み
                UstFile ust = new UstFile( filename );
                
                // vsqに変換
                VsqFileEx vsq = new VsqFileEx( ust );
                vsq.insertBlank( 0, vsq.getPreMeasureClocks() );
                
                // すべてのトラックの合成器指定をUTAUにする
                for ( int i = 1; i < vec.size( vsq.Track ); i++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, i );
                    VsqFileEx.setTrackRendererKind( vsq_track, RendererKind.UTAU );
                }

                // unknownな歌手やresamplerを何とかする
                ByRef<String> ref_resampler = new ByRef<String>( ust.getResampler() );
                ByRef<String> ref_singer = new ByRef<String>( ust.getVoiceDir() );
                checkUnknownResamplerAndSinger( ref_resampler, ref_singer );

                // 歌手変更を何とかする
                int program = 0;
                for ( int i = 0; i < vec.size( AppManager.editorConfig.UtauSingers ); i++ ) {
                    SingerConfig sc = vec.get( AppManager.editorConfig.UtauSingers, i );
                    if ( sc == null ) {
                        continue;
                    }
                    if ( str.compare( sc.VOICEIDSTR, ref_singer.value ) ) {
                        program = i;
                        break;
                    }
                }
                // 歌手変更のテンプレートを作成
                VsqID singer_id = Utility.getSingerID( RendererKind.UTAU, program, 0 );
                if ( singer_id == null ) {
                    singer_id = new VsqID();
                    singer_id.type = VsqIDType.Singer;
                    singer_id.IconHandle = new IconHandle();
                    singer_id.IconHandle.Program = program;
                    singer_id.IconHandle.IconID = "$0401" + PortUtil.toHexString( 0, 4 );
                }
                // トラックの歌手変更イベントをすべて置き換える
                for ( int i = 1; i < vec.size( vsq.Track ); i++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, i );
                    int c = vsq_track.getEventCount();
                    for ( int j = 0; j < c; j++ ) {
                        VsqEvent itemj = vsq_track.getEvent( j );
                        if ( itemj.ID.type == VsqIDType.Singer ) {
                            itemj.ID = (VsqID)singer_id.clone();
                        }
                    }
                }

                // resamplerUsedを更新(可能なら)
                for ( int j = 1; j < vec.size( vsq.Track ); j++ ) {
                    VsqTrack vsq_track = vec.get( vsq.Track, j );
                    for ( int i = 0; i < AppManager.editorConfig.getResamplerCount(); i++ ) {
                        String resampler = AppManager.editorConfig.getResamplerAt( i );
                        if ( str.compare( resampler, ref_resampler.value ) ) {
                            VsqFileEx.setTrackResamplerUsed( vsq_track, i );
                            break;
                        }
                    }
                }
                
                clearExistingData();
                AppManager.setVsqFile( vsq );
                setEdited( true );
                AppManager.mMixerWindow.updateStatus();
                clearTempWave();
                updateDrawObjectList();
                refreshScreen();

            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileOpenUst_Click; ex=" + ex + "\n" );
#if DEBUG
                sout.println( "FormMain#menuFileOpenUst_Click; ex=" + ex );
#endif
            }
        }

        public void menuFileOpenVsq_Click( Object sender, EventArgs e )
        {
            if ( !dirtyCheck() ) {
                return;
            }

            String[] filters = openMidiDialog.getChoosableFileFilter();
            String filter = "";
            foreach ( String f in filters ) {
                if ( f.EndsWith( AppManager.editorConfig.LastUsedExtension ) ) {
                    filter = f;
                    break;
                }
            }

            openMidiDialog.setFileFilter( filter );
            String dir = AppManager.editorConfig.getLastUsedPathIn( filter );
            openMidiDialog.setSelectedFile( dir );
            int dialog_result = AppManager.showModalDialog( openMidiDialog, true, this );
            String ext = ".vsq";
            if ( dialog_result == BFileChooser.APPROVE_OPTION ) {
#if DEBUG
                AppManager.debugWriteLine( "openMidiDialog.getFileFilter()=" + openMidiDialog.getFileFilter() );
#endif
                if ( openMidiDialog.getFileFilter().EndsWith( ".mid" ) ) {
                    AppManager.editorConfig.LastUsedExtension = ".mid";
                    ext = ".mid";
                } else if ( openMidiDialog.getFileFilter().EndsWith( ".vsq" ) ) {
                    AppManager.editorConfig.LastUsedExtension = ".vsq";
                    ext = ".vsq";
                }
            } else {
                return;
            }
            try {
                String filename = openMidiDialog.getSelectedFile();
                VsqFileEx vsq = new VsqFileEx( filename, "Shift_JIS" );
                AppManager.editorConfig.setLastUsedPathIn( filename, ext );
                AppManager.setVsqFile( vsq );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuFileOpenVsq_Click; ex=" + ex + "\n" );
#if DEBUG
                sout.println( "FormMain#menuFileOpenVsq_Click; ex=" + ex );
#endif
                AppManager.showMessageBox(
                    _( "Invalid VSQ/VOCALOID MIDI file" ),
                    _( "Error" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            AppManager.setSelected( 1 );
            clearExistingData();
            setEdited( true );
            AppManager.mMixerWindow.updateStatus();
            clearTempWave();
            updateDrawObjectList();
            refreshScreen();
        }
        #endregion

        //BOOKMARK: menuSetting
        #region menuSetting*
        public void menuSettingDefaultSingerStyle_Click( Object sender, EventArgs e )
        {
            FormSingerStyleConfig dlg = null;
            try {
                dlg = new FormSingerStyleConfig();
                dlg.setPMBendDepth( AppManager.editorConfig.DefaultPMBendDepth );
                dlg.setPMBendLength( AppManager.editorConfig.DefaultPMBendLength );
                dlg.setPMbPortamentoUse( AppManager.editorConfig.DefaultPMbPortamentoUse );
                dlg.setDEMdecGainRate( AppManager.editorConfig.DefaultDEMdecGainRate );
                dlg.setDEMaccent( AppManager.editorConfig.DefaultDEMaccent );

                int selected = AppManager.getSelected();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    AppManager.editorConfig.DefaultPMBendDepth = dlg.getPMBendDepth();
                    AppManager.editorConfig.DefaultPMBendLength = dlg.getPMBendLength();
                    AppManager.editorConfig.DefaultPMbPortamentoUse = dlg.getPMbPortamentoUse();
                    AppManager.editorConfig.DefaultDEMdecGainRate = dlg.getDEMdecGainRate();
                    AppManager.editorConfig.DefaultDEMaccent = dlg.getDEMaccent();
                    if ( dlg.getApplyCurrentTrack() ) {
                        VsqFileEx vsq = AppManager.getVsqFile();
                        VsqTrack vsq_track = vsq.Track.get( selected );
                        VsqTrack copy = (VsqTrack)vsq_track.clone();
                        boolean changed = false;
                        for ( int i = 0; i < copy.getEventCount(); i++ ) {
                            if ( copy.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                AppManager.editorConfig.applyDefaultSingerStyle( copy.getEvent( i ).ID );
                                changed = true;
                            }
                        }
                        if ( changed ) {
                            CadenciiCommand run = 
                                VsqFileEx.generateCommandTrackReplace(
                                    selected,
                                    copy,
                                    vsq.AttachedCurves.get( selected - 1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            updateDrawObjectList();
                            refreshScreen();
                        }
                    }
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuSettingDefaultSingerStyle_Click; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuSettingDefaultSingerStyle_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuSettingGameControlerLoad_Click( Object sender, EventArgs e )
        {
            loadGameControler();
        }

        public void menuSettingGameControlerRemove_Click( Object sender, EventArgs e )
        {
            removeGameControler();
        }

        public void menuSettingGameControlerSetting_Click( Object sender, EventArgs e )
        {
            FormGameControlerConfig dlg = null;
            try {
                dlg = new FormGameControlerConfig();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    AppManager.editorConfig.GameControlerRectangle = dlg.getRectangle();
                    AppManager.editorConfig.GameControlerTriangle = dlg.getTriangle();
                    AppManager.editorConfig.GameControlerCircle = dlg.getCircle();
                    AppManager.editorConfig.GameControlerCross = dlg.getCross();
                    AppManager.editorConfig.GameControlL1 = dlg.getL1();
                    AppManager.editorConfig.GameControlL2 = dlg.getL2();
                    AppManager.editorConfig.GameControlR1 = dlg.getR1();
                    AppManager.editorConfig.GameControlR2 = dlg.getR2();
                    AppManager.editorConfig.GameControlSelect = dlg.getSelect();
                    AppManager.editorConfig.GameControlStart = dlg.getStart();
                    AppManager.editorConfig.GameControlPovDown = dlg.getPovDown();
                    AppManager.editorConfig.GameControlPovLeft = dlg.getPovLeft();
                    AppManager.editorConfig.GameControlPovUp = dlg.getPovUp();
                    AppManager.editorConfig.GameControlPovRight = dlg.getPovRight();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuSettingGrameControlerSetting_Click; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuSettingGameControlerSetting_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuSettingPreference_Click( Object sender, EventArgs e )
        {
            try {
                if ( mDialogPreference == null ) {
                    mDialogPreference = new Preference();
                }
                mDialogPreference.setBaseFont( new Font( AppManager.editorConfig.BaseFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
                mDialogPreference.setScreenFont( new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE9 ) );
                mDialogPreference.setWheelOrder( AppManager.editorConfig.WheelOrder );
                mDialogPreference.setCursorFixed( AppManager.editorConfig.CursorFixed );
                mDialogPreference.setDefaultVibratoLength( AppManager.editorConfig.DefaultVibratoLength );
                mDialogPreference.setAutoVibratoThresholdLength( AppManager.editorConfig.AutoVibratoThresholdLength );
                mDialogPreference.setAutoVibratoType1( AppManager.editorConfig.AutoVibratoType1 );
                mDialogPreference.setAutoVibratoType2( AppManager.editorConfig.AutoVibratoType2 );
                mDialogPreference.setAutoVibratoTypeCustom( AppManager.editorConfig.AutoVibratoTypeCustom );
                mDialogPreference.setEnableAutoVibrato( AppManager.editorConfig.EnableAutoVibrato );
                mDialogPreference.setPreSendTime( AppManager.editorConfig.PreSendTime );
                mDialogPreference.setControlCurveResolution( AppManager.editorConfig.ControlCurveResolution );
                mDialogPreference.setDefaultSingerName( AppManager.editorConfig.DefaultSingerName );
                mDialogPreference.setScrollHorizontalOnWheel( AppManager.editorConfig.ScrollHorizontalOnWheel );
                mDialogPreference.setMaximumFrameRate( AppManager.editorConfig.MaximumFrameRate );
                mDialogPreference.setKeepLyricInputMode( AppManager.editorConfig.KeepLyricInputMode );
                mDialogPreference.setPxTrackHeight( AppManager.editorConfig.PxTrackHeight );
                mDialogPreference.setMouseHoverTime( AppManager.editorConfig.getMouseHoverTime() );
                mDialogPreference.setPlayPreviewWhenRightClick( AppManager.editorConfig.PlayPreviewWhenRightClick );
                mDialogPreference.setCurveSelectingQuantized( AppManager.editorConfig.CurveSelectingQuantized );
                mDialogPreference.setCurveVisibleAccent( AppManager.editorConfig.CurveVisibleAccent );
                mDialogPreference.setCurveVisibleBre( AppManager.editorConfig.CurveVisibleBreathiness );
                mDialogPreference.setCurveVisibleBri( AppManager.editorConfig.CurveVisibleBrightness );
                mDialogPreference.setCurveVisibleCle( AppManager.editorConfig.CurveVisibleClearness );
                mDialogPreference.setCurveVisibleDecay( AppManager.editorConfig.CurveVisibleDecay );
                mDialogPreference.setCurveVisibleDyn( AppManager.editorConfig.CurveVisibleDynamics );
                mDialogPreference.setCurveVisibleGen( AppManager.editorConfig.CurveVisibleGendorfactor );
                mDialogPreference.setCurveVisibleOpe( AppManager.editorConfig.CurveVisibleOpening );
                mDialogPreference.setCurveVisiblePit( AppManager.editorConfig.CurveVisiblePit );
                mDialogPreference.setCurveVisiblePbs( AppManager.editorConfig.CurveVisiblePbs );
                mDialogPreference.setCurveVisiblePor( AppManager.editorConfig.CurveVisiblePortamento );
                mDialogPreference.setCurveVisibleVel( AppManager.editorConfig.CurveVisibleVelocity );
                mDialogPreference.setCurveVisibleVibratoDepth( AppManager.editorConfig.CurveVisibleVibratoDepth );
                mDialogPreference.setCurveVisibleVibratoRate( AppManager.editorConfig.CurveVisibleVibratoRate );
                mDialogPreference.setCurveVisibleFx2Depth( AppManager.editorConfig.CurveVisibleFx2Depth );
                mDialogPreference.setCurveVisibleHarmonics( AppManager.editorConfig.CurveVisibleHarmonics );
                mDialogPreference.setCurveVisibleReso1( AppManager.editorConfig.CurveVisibleReso1 );
                mDialogPreference.setCurveVisibleReso2( AppManager.editorConfig.CurveVisibleReso2 );
                mDialogPreference.setCurveVisibleReso3( AppManager.editorConfig.CurveVisibleReso3 );
                mDialogPreference.setCurveVisibleReso4( AppManager.editorConfig.CurveVisibleReso4 );
                mDialogPreference.setCurveVisibleEnvelope( AppManager.editorConfig.CurveVisibleEnvelope );
#if ENABLE_MIDI
                mDialogPreference.setMidiInPort( AppManager.editorConfig.MidiInPort.PortNumber );
#endif
#if ENABLE_MTC
            	m_preference_dlg.setMtcMidiInPort( AppManager.editorConfig.MidiInPortMtc.PortNumber );

#endif
                Vector<String> resamplers = new Vector<String>();
                Vector<Boolean> with_wine = new Vector<Boolean>();
                int size = AppManager.editorConfig.getResamplerCount();
                for ( int i = 0; i < size; i++ ) {
                    resamplers.add( AppManager.editorConfig.getResamplerAt( i ) );
                    with_wine.add( AppManager.editorConfig.isResamplerWithWineAt( i ) );
                }
                mDialogPreference.setResamplersConfig( resamplers, with_wine );
                mDialogPreference.setPathWavtool( AppManager.editorConfig.PathWavtool );
                mDialogPreference.setWavtoolWithWine( AppManager.editorConfig.WavtoolWithWine );
                mDialogPreference.setUtausingers( AppManager.editorConfig.UtauSingers );
                mDialogPreference.setSelfDeRomantization( AppManager.editorConfig.SelfDeRomanization );
                mDialogPreference.setAutoBackupIntervalMinutes( AppManager.editorConfig.AutoBackupIntervalMinutes );
                mDialogPreference.setUseSpaceKeyAsMiddleButtonModifier( AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier );
                mDialogPreference.setPathAquesTone( AppManager.editorConfig.PathAquesTone );
                mDialogPreference.setUseProjectCache( AppManager.editorConfig.UseProjectCache );
                mDialogPreference.setAquesToneRequired( !AppManager.editorConfig.DoNotUseAquesTone );
                mDialogPreference.setVocaloid1Required( !AppManager.editorConfig.DoNotUseVocaloid1 );
                mDialogPreference.setVocaloid2Required( !AppManager.editorConfig.DoNotUseVocaloid2 );
                mDialogPreference.setBufferSize( AppManager.editorConfig.BufferSizeMilliSeconds );
                mDialogPreference.setDefaultSynthesizer( AppManager.editorConfig.DefaultSynthesizer );
                mDialogPreference.setUseUserDefinedAutoVibratoType( AppManager.editorConfig.UseUserDefinedAutoVibratoType );
                mDialogPreference.setWinePrefix( AppManager.editorConfig.WinePrefix );
                mDialogPreference.setWineTop( AppManager.editorConfig.WineTop );
                mDialogPreference.setWineBuiltin( AppManager.editorConfig.WineTopBuiltin );
                mDialogPreference.setEnableWideCharacterWorkaround( AppManager.editorConfig.UseWideCharacterWorkaround );

                String old_wine_prefix = AppManager.editorConfig.WinePrefix;
                String old_wine_top = AppManager.editorConfig.getWineTop();

                mDialogPreference.setLocation( getFormPreferedLocation( mDialogPreference ) );

                BDialogResult dr = AppManager.showModalDialog( mDialogPreference, this );
                if ( dr == BDialogResult.OK ) {
                    String old_base_font_name = AppManager.editorConfig.BaseFontName;
                    float old_base_font_size = AppManager.editorConfig.BaseFontSize;
                    Font new_base_font = mDialogPreference.getBaseFont();
#if DEBUG
                    sout.println( "FormMain#menuSettingPreference; old_base_font_name=" + old_base_font_name + "; new_base_font.getName()=" + new_base_font.getName() );
                    sout.println( "FormMain#menuSettingPreference; old_base_font_size=" + old_base_font_size + "; new_base_font.getSize2D()=" + new_base_font.getSize2D() );
#endif
                    if ( !old_base_font_name.Equals( new_base_font.getName() ) ||
                         old_base_font_size != new_base_font.getSize2D() ) {
#if DEBUG
                        sout.println( "FormMain#menuSettingPreference; font changed" );
#endif
                        AppManager.editorConfig.BaseFontName = mDialogPreference.getBaseFont().getName();
                        AppManager.editorConfig.BaseFontSize = mDialogPreference.getBaseFont().getSize2D();
                        updateMenuFonts();
                    }

                    AppManager.editorConfig.ScreenFontName = mDialogPreference.getScreenFont().getName();
                    AppManager.editorConfig.WheelOrder = mDialogPreference.getWheelOrder();
                    AppManager.editorConfig.CursorFixed = mDialogPreference.isCursorFixed();

                    AppManager.editorConfig.DefaultVibratoLength = mDialogPreference.getDefaultVibratoLength();
                    AppManager.editorConfig.AutoVibratoThresholdLength = mDialogPreference.getAutoVibratoThresholdLength();
                    AppManager.editorConfig.AutoVibratoType1 = mDialogPreference.getAutoVibratoType1();
                    AppManager.editorConfig.AutoVibratoType2 = mDialogPreference.getAutoVibratoType2();
                    AppManager.editorConfig.AutoVibratoTypeCustom = mDialogPreference.getAutoVibratoTypeCustom();

                    AppManager.editorConfig.EnableAutoVibrato = mDialogPreference.isEnableAutoVibrato();
                    AppManager.editorConfig.PreSendTime = mDialogPreference.getPreSendTime();
                    AppManager.editorConfig.Language = mDialogPreference.getLanguage();
                    if ( !Messaging.getLanguage().Equals( AppManager.editorConfig.Language ) ) {
                        Messaging.setLanguage( AppManager.editorConfig.Language );
                        applyLanguage();
                        mDialogPreference.applyLanguage();
                        AppManager.mMixerWindow.applyLanguage();
#if JAVA
                        if ( mVersionInfo != null ) {
#else
                        if ( mVersionInfo != null && !mVersionInfo.IsDisposed ) {
#endif
                            mVersionInfo.applyLanguage();
                        }
#if ENABLE_PROPERTY
                        AppManager.propertyWindow.applyLanguage();
                        AppManager.propertyPanel.updateValue( AppManager.getSelected() );
#endif
                        if( mDialogMidiImportAndExport != null ){
                            mDialogMidiImportAndExport.applyLanguage();
                        }
                    }

                    AppManager.editorConfig.ControlCurveResolution = mDialogPreference.getControlCurveResolution();
                    AppManager.editorConfig.DefaultSingerName = mDialogPreference.getDefaultSingerName();
                    AppManager.editorConfig.ScrollHorizontalOnWheel = mDialogPreference.isScrollHorizontalOnWheel();
                    AppManager.editorConfig.MaximumFrameRate = mDialogPreference.getMaximumFrameRate();
                    int fps = 1000 / AppManager.editorConfig.MaximumFrameRate;
                    timer.setDelay( (fps <= 0) ? 1 : fps );
                    applyShortcut();
                    AppManager.editorConfig.KeepLyricInputMode = mDialogPreference.isKeepLyricInputMode();
                    if ( AppManager.editorConfig.PxTrackHeight != mDialogPreference.getPxTrackHeight() ) {
                        AppManager.editorConfig.PxTrackHeight = mDialogPreference.getPxTrackHeight();
                        updateDrawObjectList();
                    }
                    AppManager.editorConfig.setMouseHoverTime( mDialogPreference.getMouseHoverTime() );
                    AppManager.editorConfig.PlayPreviewWhenRightClick = mDialogPreference.isPlayPreviewWhenRightClick();
                    AppManager.editorConfig.CurveSelectingQuantized = mDialogPreference.isCurveSelectingQuantized();

                    AppManager.editorConfig.CurveVisibleAccent = mDialogPreference.isCurveVisibleAccent();
                    AppManager.editorConfig.CurveVisibleBreathiness = mDialogPreference.isCurveVisibleBre();
                    AppManager.editorConfig.CurveVisibleBrightness = mDialogPreference.isCurveVisibleBri();
                    AppManager.editorConfig.CurveVisibleClearness = mDialogPreference.isCurveVisibleCle();
                    AppManager.editorConfig.CurveVisibleDecay = mDialogPreference.isCurveVisibleDecay();
                    AppManager.editorConfig.CurveVisibleDynamics = mDialogPreference.isCurveVisibleDyn();
                    AppManager.editorConfig.CurveVisibleGendorfactor = mDialogPreference.isCurveVisibleGen();
                    AppManager.editorConfig.CurveVisibleOpening = mDialogPreference.isCurveVisibleOpe();
                    AppManager.editorConfig.CurveVisiblePit = mDialogPreference.isCurveVisiblePit();
                    AppManager.editorConfig.CurveVisiblePbs = mDialogPreference.isCurveVisiblePbs();
                    AppManager.editorConfig.CurveVisiblePortamento = mDialogPreference.isCurveVisiblePor();
                    AppManager.editorConfig.CurveVisibleVelocity = mDialogPreference.isCurveVisibleVel();
                    AppManager.editorConfig.CurveVisibleVibratoDepth = mDialogPreference.isCurveVisibleVibratoDepth();
                    AppManager.editorConfig.CurveVisibleVibratoRate = mDialogPreference.isCurveVisibleVibratoRate();
                    AppManager.editorConfig.CurveVisibleFx2Depth = mDialogPreference.isCurveVisibleFx2Depth();
                    AppManager.editorConfig.CurveVisibleHarmonics = mDialogPreference.isCurveVisibleHarmonics();
                    AppManager.editorConfig.CurveVisibleReso1 = mDialogPreference.isCurveVisibleReso1();
                    AppManager.editorConfig.CurveVisibleReso2 = mDialogPreference.isCurveVisibleReso2();
                    AppManager.editorConfig.CurveVisibleReso3 = mDialogPreference.isCurveVisibleReso3();
                    AppManager.editorConfig.CurveVisibleReso4 = mDialogPreference.isCurveVisibleReso4();
                    AppManager.editorConfig.CurveVisibleEnvelope = mDialogPreference.isCurveVisibleEnvelope();

#if ENABLE_MIDI
                    AppManager.editorConfig.MidiInPort.PortNumber = mDialogPreference.getMidiInPort();
#endif
#if ENABLE_MTC
                    AppManager.editorConfig.MidiInPortMtc.PortNumber = m_preference_dlg.getMtcMidiInPort();
#endif
#if ENABLE_MIDI || ENABLE_MTC
                    updateMidiInStatus();
                    reloadMidiIn();
#endif

                    Vector<String> new_resamplers = new Vector<String>();
                    Vector<Boolean> new_with_wine = new Vector<Boolean>();
                    mDialogPreference.copyResamplersConfig( new_resamplers, new_with_wine );
                    AppManager.editorConfig.clearResampler();
#if DEBUG
                    sout.println( "FormMain#menuSettingPreference_Click; before;" );
                    for ( int i = 0; i < new_resamplers.size(); i++ ) {
                        sout.println( "  " + new_resamplers.get( i ) );
                    }
#endif
                    for ( int i = 0; i < new_resamplers.size(); i++ ) {
                        AppManager.editorConfig.addResampler( new_resamplers.get( i ), new_with_wine.get( i ) );
                    }
#if DEBUG
                    sout.println( "FormMain#menuSettingPreference_Click; after;" );
                    for ( int i = 0; i < AppManager.editorConfig.getResamplerCount(); i++ ) {
                        sout.println( "  " + AppManager.editorConfig.getResamplerAt( i ) );
                    }
#endif
                    AppManager.editorConfig.PathWavtool = mDialogPreference.getPathWavtool();
                    AppManager.editorConfig.WavtoolWithWine = mDialogPreference.isWavtoolWithWine();

                    AppManager.editorConfig.UtauSingers.clear();
                    for ( Iterator<SingerConfig> itr = mDialogPreference.getUtausingers().iterator(); itr.hasNext(); ) {
                        SingerConfig sc = itr.next();
                        AppManager.editorConfig.UtauSingers.add( (SingerConfig)sc.clone() );
                    }
                    AppManager.reloadUtauVoiceDB();

                    AppManager.editorConfig.SelfDeRomanization = mDialogPreference.isSelfDeRomantization();
                    AppManager.editorConfig.AutoBackupIntervalMinutes = mDialogPreference.getAutoBackupIntervalMinutes();
                    AppManager.editorConfig.UseSpaceKeyAsMiddleButtonModifier = mDialogPreference.isUseSpaceKeyAsMiddleButtonModifier();
#if ENABLE_AQUESTONE
                    String old_aquestone_dll = AppManager.editorConfig.PathAquesTone;
                    String new_aquestone_dll = mDialogPreference.getPathAquesTone();
                    AppManager.editorConfig.PathAquesTone = mDialogPreference.getPathAquesTone();
                    if ( !old_aquestone_dll.Equals( new_aquestone_dll ) ) {
                        VSTiDllManager.reloadAquesTone();
                    }
#endif
                    //AppManager.editorConfig.__revoked__WaveFileOutputFromMasterTrack = mDialogPreference.isWaveFileOutputFromMasterTrack();
                    //AppManager.editorConfig.__revoked__WaveFileOutputChannel = mDialogPreference.getWaveFileOutputChannel();
                    if ( AppManager.editorConfig.UseProjectCache && !mDialogPreference.isUseProjectCache() ) {
                        // プロジェクト用キャッシュを使用していたが，使用しないように変更された場合.
                        // プロジェクト用キャッシュが存在するなら，共用のキャッシュに移動する．
                        String file = AppManager.getFileName();
                        if ( file != null && !file.Equals( "" ) ) {
                            String dir = PortUtil.getDirectoryName( file );
                            String name = PortUtil.getFileNameWithoutExtension( file );
                            String projectCacheDir = fsys.combine( dir, name + ".cadencii" );
                            String commonCacheDir = fsys.combine( AppManager.getCadenciiTempDir(), AppManager.getID() );
                            if ( fsys.isDirectoryExists( projectCacheDir ) ) {
                                VsqFileEx vsq = AppManager.getVsqFile();
                                for ( int i = 1; i < vsq.Track.size(); i++ ) {
                                    // wavを移動
                                    String wavFrom = fsys.combine( projectCacheDir, i + ".wav" );
                                    String wavTo = fsys.combine( commonCacheDir, i + ".wav" );
                                    if ( !fsys.isFileExists( wavFrom ) ) {
                                        continue;
                                    }
                                    if ( fsys.isFileExists( wavTo ) ) {
                                        try {
                                            PortUtil.deleteFile( wavTo );
                                        } catch ( Exception ex ) {
                                            Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                                            serr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                            continue;
                                        }
                                    }
                                    try {
                                        PortUtil.moveFile( wavFrom, wavTo );
                                    } catch ( Exception ex ) {
                                        Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                                        serr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }

                                    // xmlを移動
                                    String xmlFrom = fsys.combine( projectCacheDir, i + ".xml" );
                                    String xmlTo = fsys.combine( commonCacheDir, i + ".xml" );
                                    if ( !fsys.isFileExists( xmlFrom ) ) {
                                        continue;
                                    }
                                    if ( fsys.isFileExists( xmlTo ) ) {
                                        try {
                                            PortUtil.deleteFile( xmlTo );
                                        } catch ( Exception ex ) {
                                            Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                                            serr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                            continue;
                                        }
                                    }
                                    try {
                                        PortUtil.moveFile( xmlFrom, xmlTo );
                                    } catch ( Exception ex ) {
                                        Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                                        serr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }
                                }

                                // projectCacheDirが空なら，ディレクトリごと削除する
                                String[] files = PortUtil.listFiles( projectCacheDir, "*.*" );
                                if ( files.Length <= 0 ) {
                                    try {
                                        PortUtil.deleteDirectory( projectCacheDir );
                                    } catch ( Exception ex ) {
                                        Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                                        serr.println( "FormMain#menuSettingPreference_Click; ex=" + ex );
                                    }
                                }

                                // キャッシュのディレクトリを再指定
                                AppManager.setTempWaveDir( commonCacheDir );
                            }
                        }
                    }
                    AppManager.editorConfig.UseProjectCache = mDialogPreference.isUseProjectCache();
                    AppManager.editorConfig.DoNotUseAquesTone = !mDialogPreference.isAquesToneRequired();
                    AppManager.editorConfig.DoNotUseVocaloid1 = !mDialogPreference.isVocaloid1Required();
                    AppManager.editorConfig.DoNotUseVocaloid2 = !mDialogPreference.isVocaloid2Required();
                    AppManager.editorConfig.BufferSizeMilliSeconds = mDialogPreference.getBufferSize();
                    AppManager.editorConfig.DefaultSynthesizer = mDialogPreference.getDefaultSynthesizer();
                    AppManager.editorConfig.UseUserDefinedAutoVibratoType = mDialogPreference.isUseUserDefinedAutoVibratoType();
                    AppManager.editorConfig.WinePrefix = mDialogPreference.getWinePrefix();
                    AppManager.editorConfig.WineTop = mDialogPreference.getWineTop();
                    AppManager.editorConfig.WineTopBuiltin = mDialogPreference.isWineBuiltin();
                    AppManager.editorConfig.UseWideCharacterWorkaround = mDialogPreference.isEnableWideCharacterWorkaround();

#if JAVA
                    // WinePrefix, WineTopのどちらかが変わっていたら，ドライバー・デーモンを再起動する
                    if( !str.compare( old_wine_prefix, AppManager.editorConfig.WinePrefix ) ||
                        !str.compare( old_wine_top, AppManager.editorConfig.getWineTop() ) ){
                        VSTiDllManager.restartVocaloidrvDaemon();
                    }
#endif

                    AppManager.clearViewingCurve();
                    trackSelector.prepareSingerMenu( VsqFileEx.getTrackRendererKind( AppManager.getVsqFile().Track.get( AppManager.getSelected() ) ) );

                    updateTrackSelectorVisibleCurve();
                    updateRendererMenu();
                    AppManager.updateAutoBackupTimerStatus();

                    // editorConfig.PxTrackHeightが変更されている可能性があるので，更新が必要
                    AppManager.setStartToDrawY( calculateStartToDrawY( vScroll.getValue() ) );

                    if ( menuVisualControlTrack.isSelected() ) {
                        splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
                    }

                    AppManager.saveConfig();
                    applyLanguage();
#if ENABLE_SCRIPT
                    updateScriptShortcut();
#endif

                    updateDrawObjectList();
                    refreshScreen();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuSettingPreference_Click; ex=" + ex + "\n" );
                AppManager.debugWriteLine( "FormMain#menuSettingPreference_Click; ex=" + ex );
#if JAVA
                ex.printStackTrace();
#endif
            }
        }

        public void menuSettingShortcut_Click( Object sender, EventArgs e )
        {
            TreeMap<String, ValuePair<String, BKeys[]>> dict = new TreeMap<String, ValuePair<String, BKeys[]>>();
            TreeMap<String, BKeys[]> configured = AppManager.editorConfig.getShortcutKeysDictionary( this.getDefaultShortcutKeys() );
#if DEBUG
            sout.println( "FormMain#menuSettingShortcut_Click; configured=" );
            for( Iterator<String> itr = configured.keySet().iterator(); itr.hasNext(); ){
                String name = itr.next();
                BKeys[] keys = configured.get( name );
                String disp = Utility.getShortcutDisplayString( keys );
                sout.println( "    " + name + " -> " + disp );
            }
#endif

            // スクリプトのToolStripMenuITemを蒐集
            Vector<String> script_shortcut = new Vector<String>();
            MenuElement[] sub_menu_script = menuScript.getSubElements();
            for ( int i = 0; i < sub_menu_script.Length; i++ ) {
                MenuElement tsi = sub_menu_script[i];
                if ( tsi is BMenuItem ) {
                    BMenuItem tsmi = (BMenuItem)tsi;
                    String name = tsmi.getName();
                    script_shortcut.add( name );
                    if ( !configured.containsKey( name ) ) {
                        configured.put( name, new BKeys[] { } );
                    }
                }
            }

            for ( Iterator<String> itr = configured.keySet().iterator(); itr.hasNext(); ) {
                String name = itr.next();
                ByRef<Object> owner = new ByRef<Object>( null );
                Object menu = searchMenuItemFromName( name, owner );
#if DEBUG
                if ( menu == null || owner.value == null ) {
                    serr.println( "FormMain#enuSettingShrtcut_Click; name=" + name + "; menu is null" );
                    continue;
                }
#endif
#if JAVA
                JMenuItem casted_owner_item = null;
                if ( owner.value is JMenuItem ) {
                    casted_owner_item = (JMenuItem)owner.value;
                }
#else
                BMenuItem casted_owner_item = null;
                if ( owner.value is BMenuItem ) {
                    casted_owner_item = (BMenuItem)owner.value;
                }
#endif
                if ( casted_owner_item == null ) {
                    continue;
                }
                String parent = "";
                if ( !casted_owner_item.getName().Equals( menuHidden.getName() ) ) {
                    String s = casted_owner_item.getText();
                    int i = s.IndexOf( "(&" );
                    if ( i > 0 ) {
                        s = str.sub( s, 0, i );
                    }
                    parent = s + " -> ";
                }
#if JAVA
                JMenuItem casted_menu = null;
                if( menu instanceof JMenuItem ){
                    casted_menu = (JMenuItem)menu;
                }
#else
                BMenuItem casted_menu = null;
                if ( menu is BMenuItem ) {
                    casted_menu = (BMenuItem)menu;
                }
#endif
                if ( casted_menu == null ) {
                    continue;
                }
                String s1 = casted_menu.getText();
                int i1 = s1.IndexOf( "(&" );
                if ( i1 > 0 ) {
                    s1 = str.sub( s1, 0, i1 );
                }
                dict.put( parent + s1, new ValuePair<String, BKeys[]>( name, configured.get( name ) ) );
            }

            // 最初に戻る、のショートカットキー
            BKeys[] keysGoToFirst = AppManager.editorConfig.SpecialShortcutGoToFirst;
            if ( keysGoToFirst == null ) {
                keysGoToFirst = new BKeys[] { };
            }
            dict.put( _( "Go to the first" ), new ValuePair<String, BKeys[]>( "SpecialShortcutGoToFirst", keysGoToFirst ) );

            FormShortcutKeys form = null;
            try {
                form = new FormShortcutKeys( dict, this );
                form.setLocation( getFormPreferedLocation( form ) );
                BDialogResult dr = AppManager.showModalDialog( form, this );
                if ( dr == BDialogResult.OK ) {
                    TreeMap<String, ValuePair<String, BKeys[]>> res = form.getResult();
                    for ( Iterator<String> itr = res.keySet().iterator(); itr.hasNext(); ) {
                        String display = itr.next();
                        String name = res.get( display ).getKey();
                        BKeys[] keys = res.get( display ).getValue();
                        boolean found = false;
                        if ( name.Equals( "SpecialShortcutGoToFirst" ) ) {
                            AppManager.editorConfig.SpecialShortcutGoToFirst = keys;
                        } else {
                            for ( int i = 0; i < AppManager.editorConfig.ShortcutKeys.size(); i++ ) {
                                if ( AppManager.editorConfig.ShortcutKeys.get( i ).Key.Equals( name ) ) {
                                    AppManager.editorConfig.ShortcutKeys.get( i ).Value = keys;
                                    found = true;
                                    break;
                                }
                            }
                            if ( !found ) {
                                AppManager.editorConfig.ShortcutKeys.add( new ValuePairOfStringArrayOfKeys( name, keys ) );
                            }
                        }
                    }
                    applyShortcut();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuSettingShortcut_Click; ex=" + ex + "\n" );
            } finally {
                if ( form != null ) {
                    try {
                        form.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuSettingSHortcut_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuSettingVibratoPreset_Click( Object sender, EventArgs e )
        {
            FormVibratoPreset dialog = null;
            try {
                dialog = new FormVibratoPreset( AppManager.editorConfig.AutoVibratoCustom );
                dialog.setLocation( getFormPreferedLocation( dialog ) );
                BDialogResult ret = AppManager.showModalDialog( dialog, this );
                if ( ret != BDialogResult.OK ) {
                    return;
                }

                // ダイアログの結果を取得
                Vector<VibratoHandle> result = dialog.getResult();

                // ダイアログ結果を，設定値にコピー
                // ダイアログのコンストラクタであらかじめcloneされているので，
                // ここではcloneする必要はない．
                AppManager.editorConfig.AutoVibratoCustom.clear();
                for ( int i = 0; i < result.size(); i++ ) {
                    AppManager.editorConfig.AutoVibratoCustom.add( result.get( i ) );
                }

                // メニューの表示状態を更新
                updateVibratoPresetMenu();
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuSettingVibratoPreset_Click; ex=" + ex + "\n" );
            } finally {
                if ( dialog != null ) {
                    try {
#if !JAVA
                        dialog.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }
        #endregion

        //BOOKMARK: menuEdit
        #region menuEdit*
        public void menuEditDelete_Click( Object sender, EventArgs e )
        {
            deleteEvent();
        }

        public void menuEdit_DropDownOpening( Object sender, EventArgs e )
        {
            updateCopyAndPasteButtonStatus();
        }

        public void handleEditUndo_Click( Object sender, EventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "menuEditUndo_Click" );
#endif
            undo();
            refreshScreen();
        }


        public void handleEditRedo_Click( Object sender, EventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "menuEditRedo_Click" );
#endif
            redo();
            refreshScreen();
        }

        public void menuEditSelectAllEvents_Click( Object sender, EventArgs e )
        {
            selectAllEvent();
        }

        public void menuEditSelectAll_Click( Object sender, EventArgs e )
        {
            selectAll();
        }

        public void menuEditAutoNormalizeMode_Click( Object sender, EventArgs e )
        {
            AppManager.mAutoNormalize = !AppManager.mAutoNormalize;
            menuEditAutoNormalizeMode.setSelected( AppManager.mAutoNormalize );
        }
        #endregion

        //BOOKMARK: menuLyric
        #region menuLyric*
        public void menuLyric_DropDownOpening( Object sender, EventArgs e )
        {
            menuLyricCopyVibratoToPreset.setEnabled( false );

            int num = AppManager.getSelectedEventCount();
            if ( num <= 0 ) {
                return;
            }
            SelectedEventEntry item = AppManager.getSelectedEventIterator().next();
            if ( item.original.ID.type != VsqIDType.Anote ) {
                return;
            }
            if ( item.original.ID.VibratoHandle == null ) {
                return;
            }

            menuLyricCopyVibratoToPreset.setEnabled( true );
        }

        public void menuLyricExpressionProperty_Click( Object sender, EventArgs e )
        {
            editNoteExpressionProperty();
        }

        public void menuLyricPhonemeTransformation_Click( Object sender, EventArgs e )
        {
            Vector<Integer> internal_ids = new Vector<Integer>();
            Vector<VsqID> ids = new Vector<VsqID>();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq == null ) {
                return;
            }
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            for ( Iterator<VsqEvent> itr = vsq_track.getNoteEventIterator(); itr.hasNext(); ) {
                VsqEvent item = itr.next();
                VsqID id = item.ID;
                if ( id.LyricHandle.L0.PhoneticSymbolProtected ) {
                    continue;
                }
                String phrase = id.LyricHandle.L0.Phrase;
                String symbolOld = id.LyricHandle.L0.getPhoneticSymbol();
                String symbolResult = symbolOld;
                SymbolTableEntry entry = SymbolTable.attatch( phrase );
                if ( entry == null ) {
                    continue;
                }
                symbolResult = entry.getSymbol();
                if ( symbolResult.Equals( symbolOld ) ) {
                    continue;
                }
                VsqID idNew = (VsqID)id.clone();
                idNew.LyricHandle.L0.setPhoneticSymbol( symbolResult );
                ids.add( idNew );
                internal_ids.add( item.InternalID );
            }
            if ( ids.size() <= 0 ) {
                return;
            }
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventChangeIDContaintsRange(
                    selected,
                    PortUtil.convertIntArray( internal_ids.toArray( new Integer[] { } ) ),
                    ids.toArray( new VsqID[] { } ) ) );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
        }

        /// <summary>
        /// 現在表示しているトラックの，選択状態の音符イベントについて，それぞれのイベントの
        /// 時刻でのUTAU歌手に応じて，UTAUの各種パラメータを原音設定のものにリセットします
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void menuLyricApplyUtauParameters_Click( Object sender, BEventArgs e )
        {
            // 選択されているトラックの番号
            int selected = AppManager.getSelected();
            // シーケンス
            VsqFileEx vsq = AppManager.getVsqFile();
            VsqTrack vsq_track = vsq.Track.get( selected );

            // 選択状態にあるイベントを取り出す
            Vector<VsqEvent> replace = new Vector<VsqEvent>();
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry sel_item = itr.next();
                VsqEvent item = sel_item.original;
                if ( item.ID.type != VsqIDType.Anote ) {
                    continue;
                }
                VsqEvent edit = (VsqEvent)item.clone();
                // UTAUのパラメータを適用
                AppManager.applyUtauParameter( vsq_track, edit );
                // 合成したとき，意味のある変更が行われたか？
                if ( edit.UstEvent.equalsForSynth( item.UstEvent ) ) {
                    continue;
                }
                // 意味のある変更があったので，リストに登録
                replace.add( edit );
            }

            // コマンドを発行
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventReplaceRange( selected, replace.toArray( new VsqEvent[] { } ) ) );
            // コマンドを実行
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
        }

        public void menuLyricDictionary_Click( Object sender, EventArgs e )
        {
            FormWordDictionary dlg = null;
            try {
                dlg = new FormWordDictionary();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    Vector<ValuePair<String, Boolean>> result = dlg.getResult();
                    SymbolTable.changeOrder( result );
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuLyricDictionary_Click; ex=" + ex + "\n" );
                serr.println( "FormMain#menuLyricDictionary_Click; ex=" + ex );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuLyricDictionary_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuLyricVibratoProperty_Click( Object sender, EventArgs e )
        {
            editNoteVibratoProperty();
        }
        #endregion

        //BOOKMARK: menuJob
        #region menuJob
        public void menuJobReloadVsti_Click( Object sender, EventArgs e )
        {
            //VSTiProxy.ReloadPlugin(); //todo: FormMain+menuJobReloadVsti_Click
        }

        public void menuJob_DropDownOpening( Object sender, EventArgs e )
        {
            if ( AppManager.getSelectedEventCount() <= 1 ) {
                menuJobConnect.setEnabled( false );
            } else {
                // menuJobConnect(音符の結合)がEnableされるかどうかは、選択されている音符がピアノロール上で連続かどうかで決まる
                int[] list = new int[AppManager.getSelectedEventCount()];
                for ( int i = 0; i < AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEventCount(); i++ ) {
                    int count = -1;
                    for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                        SelectedEventEntry item = itr.next();
                        int key = item.original.InternalID;
                        count++;
                        if ( key == AppManager.getVsqFile().Track.get( AppManager.getSelected() ).getEvent( i ).InternalID ) {
                            list[count] = i;
                            break;
                        }
                    }
                }
                boolean changed = true;
                while ( changed ) {
                    changed = false;
                    for ( int i = 0; i < list.Length - 1; i++ ) {
                        if ( list[i] > list[i + 1] ) {
                            int b = list[i];
                            list[i] = list[i + 1];
                            list[i + 1] = b;
                            changed = true;
                        }
                    }
                }
                boolean continued = true;
                for ( int i = 0; i < list.Length - 1; i++ ) {
                    if ( list[i] + 1 != list[i + 1] ) {
                        continued = false;
                        break;
                    }
                }
                menuJobConnect.setEnabled( continued );
            }

            menuJobLyric.setEnabled( AppManager.getLastSelectedEvent() != null );
        }

        public void menuJobLyric_Click( Object sender, EventArgs e )
        {
            importLyric();
        }

        public void menuJobConnect_Click( Object sender, EventArgs e )
        {
            int count = AppManager.getSelectedEventCount();
            int[] clocks = new int[count];
            VsqID[] ids = new VsqID[count];
            int[] internalids = new int[count];
            int i = -1;
            for ( Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator(); itr.hasNext(); ) {
                SelectedEventEntry item = itr.next();
                i++;
                clocks[i] = item.original.Clock;
                ids[i] = (VsqID)item.original.ID.clone();
                internalids[i] = item.original.InternalID;
            }
            boolean changed = true;
            while ( changed ) {
                changed = false;
                for ( int j = 0; j < clocks.Length - 1; j++ ) {
                    if ( clocks[j] > clocks[j + 1] ) {
                        int b = clocks[j];
                        clocks[j] = clocks[j + 1];
                        clocks[j + 1] = b;
                        VsqID a = ids[j];
                        ids[j] = ids[j + 1];
                        ids[j + 1] = a;
                        changed = true;
                        b = internalids[j];
                        internalids[j] = internalids[j + 1];
                        internalids[j + 1] = b;
                    }
                }
            }

            for ( int j = 0; j < ids.Length - 1; j++ ) {
                ids[j].setLength( clocks[j + 1] - clocks[j] );
            }
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandEventChangeIDContaintsRange( AppManager.getSelected(), internalids, ids ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
            repaint();
        }

        public void menuJobInsertBar_Click( Object sender, EventArgs e )
        {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            FormInsertBar dlg = null;
            try {
                dlg = new FormInsertBar( total_barcount );
                int current_clock = AppManager.getCurrentClock();
                int barcount = AppManager.getVsqFile().getBarCountFromClock( current_clock );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setPosition( draft );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    int pos = dlg.getPosition() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int length = dlg.getLength();

                    int clock_start = AppManager.getVsqFile().getClockFromBarCount( pos );
                    int clock_end = AppManager.getVsqFile().getClockFromBarCount( pos + length );
                    int dclock = clock_end - clock_start;
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().clone();

                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        foreach ( CurveType ct in Utility.CURVE_USAGE ) {
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start <= chain_start ) {
                                    for ( int i = 0; i < bc.points.size(); i++ ) {
                                        PointD t = bc.points.get( i ).getBase();
                                        bc.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    list.add( bc );
                                } else if ( chain_start < clock_start && clock_start < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_start, chain_end );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        PointD t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() + dclock, t.getY() ) );
                                    }
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    for ( int i = 0; i < adding2.points.size(); i++ ) {
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    adding1.id = bc.id;
                                    list.add( adding1 );
                                } else {
                                    list.add( (BezierChain)bc.clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                        for ( int i = 0; i < temp.Track.get( track ).getEventCount(); i++ ) {
                            if ( temp.Track.get( track ).getEvent( i ).Clock >= clock_start ) {
                                temp.Track.get( track ).getEvent( i ).Clock += dclock;
                            }
                        }
                        foreach ( CurveType curve in Utility.CURVE_USAGE ) {
                            if ( curve.isScalar() || curve.isAttachNote() ) {
                                continue;
                            }
                            VsqBPList target = temp.Track.get( track ).getCurve( curve.getName() );
                            VsqBPList src = AppManager.getVsqFile().Track.get( track ).getCurve( curve.getName() );
                            target.clear();
                            for ( Iterator<Integer> itr = src.keyClockIterator(); itr.hasNext(); ) {
                                int key = itr.next();
                                if ( key >= clock_start ) {
                                    target.add( key + dclock, src.getValue( key ) );
                                } else {
                                    target.add( key, src.getValue( key ) );
                                }
                            }
                        }
                    }
                    for ( int i = 0; i < temp.TempoTable.size(); i++ ) {
                        if ( temp.TempoTable.get( i ).Clock >= clock_start ) {
                            temp.TempoTable.get( i ).Clock = temp.TempoTable.get( i ).Clock + dclock;
                        }
                    }
                    for ( int i = 0; i < temp.TimesigTable.size(); i++ ) {
                        if ( temp.TimesigTable.get( i ).Clock >= clock_start ) {
                            temp.TimesigTable.get( i ).Clock = temp.TimesigTable.get( i ).Clock + dclock;
                        }
                    }
                    temp.updateTempoInfo();
                    temp.updateTimesigInfo();

                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuJobInsertBar_Click; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuJobInsertBar_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuJobChangePreMeasure_Click( Object sender, EventArgs e )
        {
            InputBox dialog = null;
            try {
                dialog = new InputBox( _( "input pre-measure" ) );
                int old_pre_measure = AppManager.getVsqFile().getPreMeasure();
                dialog.setResult( old_pre_measure + "" );
                dialog.setLocation( getFormPreferedLocation( dialog ) );
                BDialogResult ret = AppManager.showModalDialog( dialog, this );
                if ( ret == BDialogResult.OK ) {
                    String str_result = dialog.getResult();
                    int result = old_pre_measure;
                    try {
                        result = str.toi( str_result );
                    } catch ( Exception ex ) {
                        result = old_pre_measure;
                    }
                    if ( result < AppManager.MIN_PRE_MEASURE ) {
                        result = AppManager.MIN_PRE_MEASURE;
                    }
                    if ( result > AppManager.MAX_PRE_MEASURE ) {
                        result = AppManager.MAX_PRE_MEASURE;
                    }
                    if ( old_pre_measure != result ) {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandChangePreMeasure( result ) );
                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                        AppManager.getVsqFile().updateTotalClocks();
                        refreshScreen( true );
                        setEdited( true );
                    }
                }
            } catch ( Exception ex ) {
                return;
            } finally {
                if ( dialog != null ) {
                    try {
                        dialog.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
        }

        public void menuSettingSequence_Click( Object sender, EventArgs e )
        {
            VsqFileEx vsq = AppManager.getVsqFile();

            FormSequenceConfig dialog = new FormSequenceConfig();
            int old_channels = vsq.config.WaveFileOutputChannel;
            boolean old_output_master = vsq.config.WaveFileOutputFromMasterTrack;
            int old_sample_rate = vsq.config.SamplingRate;
            int old_pre_measure = vsq.getPreMeasure();

            dialog.setWaveFileOutputChannel( old_channels );
            dialog.setWaveFileOutputFromMasterTrack( old_output_master );
            dialog.setSampleRate( old_sample_rate );
            dialog.setPreMeasure( old_pre_measure );

            dialog.setLocation( getFormPreferedLocation( dialog ) );
            if ( AppManager.showModalDialog( dialog, this ) != BDialogResult.OK ) {
                return;
            }

            int new_channels = dialog.getWaveFileOutputChannel();
            boolean new_output_master = dialog.isWaveFileOutputFromMasterTrack();
            int new_sample_rate = dialog.getSampleRate();
            int new_pre_measure = dialog.getPreMeasure();

            CadenciiCommand run =
                VsqFileEx.generateCommandChangeSequenceConfig(
                    new_sample_rate,
                    new_channels,
                    new_output_master,
                    new_pre_measure );
            AppManager.register( vsq.executeCommand( run ) );
            setEdited( true );
        }

        public void menuJobDeleteBar_Click( Object sender, EventArgs e )
        {
            int total_clock = AppManager.getVsqFile().TotalClocks;
            int total_barcount = AppManager.getVsqFile().getBarCountFromClock( total_clock ) + 1;
            int clock = AppManager.getCurrentClock();
            int barcount = AppManager.getVsqFile().getBarCountFromClock( clock );
            FormDeleteBar dlg = null;
            try {
                dlg = new FormDeleteBar( total_barcount );
                int draft = barcount - AppManager.getVsqFile().getPreMeasure() + 1;
                if ( draft <= 0 ) {
                    draft = 1;
                }
                dlg.setStart( draft );
                dlg.setEnd( draft + 1 );

                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    VsqFileEx temp = (VsqFileEx)AppManager.getVsqFile().clone();
                    int start = dlg.getStart() + AppManager.getVsqFile().getPreMeasure() - 1;
                    int end = dlg.getEnd() + AppManager.getVsqFile().getPreMeasure() - 1;
#if DEBUG
                    AppManager.debugWriteLine( "FormMain+menuJobDeleteBar_Click" );
                    AppManager.debugWriteLine( "    start,end=" + start + "," + end );
#endif
                    int clock_start = temp.getClockFromBarCount( start );
                    int clock_end = temp.getClockFromBarCount( end );
                    int dclock = clock_end - clock_start;
                    for ( int track = 1; track < temp.Track.size(); track++ ) {
                        BezierCurves newbc = new BezierCurves();
                        for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                            CurveType ct = Utility.CURVE_USAGE[j];
                            int index = ct.getIndex();
                            if ( index < 0 ) {
                                continue;
                            }

                            Vector<BezierChain> list = new Vector<BezierChain>();
                            for ( Iterator<BezierChain> itr = temp.AttachedCurves.get( track - 1 ).get( ct ).iterator(); itr.hasNext(); ) {
                                BezierChain bc = itr.next();
                                if ( bc.size() < 2 ) {
                                    continue;
                                }
                                int chain_start = (int)bc.points.get( 0 ).getBase().getX();
                                int chain_end = (int)bc.points.get( bc.points.size() - 1 ).getBase().getX();

                                if ( clock_start < chain_start && chain_start < clock_end && clock_end < chain_end ) {
                                    BezierChain adding = bc.extractPartialBezier( clock_end, chain_end );
                                    adding.id = bc.id;
                                    for ( int i = 0; i < adding.points.size(); i++ ) {
                                        PointD t = adding.points.get( i ).getBase();
                                        adding.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    }
                                    list.add( adding );
                                } else if ( chain_start < clock_start && clock_end < chain_end ) {
                                    BezierChain adding1 = bc.extractPartialBezier( chain_start, clock_start );
                                    adding1.id = bc.id;
                                    adding1.points.get( adding1.points.size() - 1 ).setControlRightType( BezierControlType.None );
                                    BezierChain adding2 = bc.extractPartialBezier( clock_end, chain_end );
                                    adding2.points.get( 0 ).setControlLeftType( BezierControlType.None );
                                    PointD t = adding2.points.get( 0 ).getBase();
                                    adding2.points.get( 0 ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                    adding1.points.add( adding2.points.get( 0 ) );
                                    for ( int i = 1; i < adding2.points.size(); i++ ) {
                                        t = adding2.points.get( i ).getBase();
                                        adding2.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        adding1.points.add( adding2.points.get( i ) );
                                    }
                                    list.add( adding1 );
                                } else if ( chain_start < clock_start && clock_start < chain_end && chain_end < clock_end ) {
                                    BezierChain adding = bc.extractPartialBezier( chain_start, clock_start );
                                    adding.id = bc.id;
                                    list.add( adding );
                                } else if ( clock_end <= chain_start || chain_end <= clock_start ) {
                                    if ( clock_end <= chain_start ) {
                                        for ( int i = 0; i < bc.points.size(); i++ ) {
                                            PointD t = bc.points.get( i ).getBase();
                                            bc.points.get( i ).setBase( new PointD( t.getX() - dclock, t.getY() ) );
                                        }
                                    }
                                    list.add( (BezierChain)bc.clone() );
                                }
                            }

                            newbc.set( ct, list );
                        }
                        temp.AttachedCurves.set( track - 1, newbc );
                    }

                    temp.removePart( clock_start, clock_end );
                    CadenciiCommand run = VsqFileEx.generateCommandReplace( temp );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    setEdited( true );
                    repaint();
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuJobDeleteBar_Click; ex=" + ex + "\n" );
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuJobDeleteBar_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void menuJobNormalize_Click( Object sender, EventArgs e )
        {
            VsqFile work = (VsqFile)AppManager.getVsqFile().clone();
            int track = AppManager.getSelected();
            boolean changed = true;
            boolean total_changed = false;

            // 最初、開始時刻が同じになっている奴を削除
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int clock = work.Track.get( track ).getEvent( i ).Clock;
                    int id = work.Track.get( track ).getEvent( i ).InternalID;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        if ( clock == work.Track.get( track ).getEvent( j ).Clock ) {
                            if ( id < work.Track.get( track ).getEvent( j ).InternalID ) { //内部IDが小さい＝より高年齢（音符追加時刻が古い）
                                work.Track.get( track ).removeEvent( i );
                            } else {
                                work.Track.get( track ).removeEvent( j );
                            }
                            changed = true;
                            total_changed = true;
                            break;
                        }
                    }
                    if ( changed ) {
                        break;
                    }
                }
            }

            changed = true;
            while ( changed ) {
                changed = false;
                for ( int i = 0; i < work.Track.get( track ).getEventCount() - 1; i++ ) {
                    int start_clock = work.Track.get( track ).getEvent( i ).Clock;
                    int end_clock = work.Track.get( track ).getEvent( i ).ID.getLength() + start_clock;
                    for ( int j = i + 1; j < work.Track.get( track ).getEventCount(); j++ ) {
                        int this_start_clock = work.Track.get( track ).getEvent( j ).Clock;
                        if ( this_start_clock < end_clock ) {
                            work.Track.get( track ).getEvent( i ).ID.setLength( this_start_clock - start_clock );
                            changed = true;
                            total_changed = true;
                        }
                    }
                }
            }

            if ( total_changed ) {
                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandReplace( work ) );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
                refreshScreen();
            }
        }

        public void menuJobRandomize_Click( Object sender, EventArgs e )
        {
            FormRandomize dlg = null;
            try {
                dlg = new FormRandomize();
                dlg.setLocation( getFormPreferedLocation( dlg ) );
                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                if ( dr == BDialogResult.OK ) {
                    VsqFileEx vsq = AppManager.getVsqFile();
                    int preMeasure = vsq.getPreMeasure();
                    int startBar = dlg.getStartBar() + (preMeasure - 1);
                    int startBeat = dlg.getStartBeat() - 1;
                    int endBar = dlg.getEndBar() + (preMeasure - 1);
                    int endBeat = dlg.getEndBeat();
                    int startBarClock = vsq.getClockFromBarCount( startBar );
                    int endBarClock = vsq.getClockFromBarCount( endBar );
                    Timesig startTimesig = vsq.getTimesigAt( startBarClock );
                    Timesig endTimesig = vsq.getTimesigAt( endBarClock );
                    int startClock = startBarClock + startBeat * 480 * 4 / startTimesig.denominator;
                    int endClock = endBarClock + endBeat * 480 * 4 / endTimesig.denominator;

                    int selected = AppManager.getSelected();
                    VsqTrack vsq_track = vsq.Track.get( selected );
                    VsqTrack work = (VsqTrack)vsq_track.clone();
                    Random r = new Random();

                    // 音符位置のシフト
                    #region 音符位置のシフト
                    if ( dlg.isPositionRandomizeEnabled() ) {
                        int[] sigmaPreset = new int[] { 10, 20, 30, 60, 120 };
                        int sigma = sigmaPreset[dlg.getPositionRandomizeValue() - 1]; // 標準偏差

                        int count = work.getEventCount(); // イベントの個数
                        int lastItemIndex = -1;  // 直前に処理した音符イベントのインデクス
                        int thisItemIndex = -1;  // 処理中の音符イベントのインデクス
                        int nextItemIndex = -1;  // 処理中の音符イベントの次の音符イベントのインデクス
                        double sqrt2 = Math.Sqrt( 2.0 );
                        int clockPreMeasure = vsq.getPreMeasureClocks(); // プリメジャーいちでのゲートタイム

                        while ( true ) {
                            // nextItemIndexを決定
                            if ( nextItemIndex != -2 ) {
                                int start = nextItemIndex + 1;
                                nextItemIndex = -2;  // -2は、トラックの最後まで走査し終わった、という意味
                                for ( int i = start; i < count; i++ ) {
                                    if ( work.getEvent( i ).ID.type == VsqIDType.Anote ) {
                                        nextItemIndex = i;
                                        break;
                                    }
                                }
                            }

                            if ( thisItemIndex >= 0 ) {
                                // ここにメインの処理
                                VsqEvent lastItem = lastItemIndex >= 0 ? work.getEvent( lastItemIndex ) : null;
                                VsqEvent thisItem = work.getEvent( thisItemIndex );
                                VsqEvent nextItem = nextItemIndex >= 0 ? work.getEvent( nextItemIndex ) : null;
                                int lastItemClock = lastItem == null ? 0 : lastItem.Clock;
                                int lastItemLength = lastItem == null ? 0 : lastItem.ID.getLength();

                                int clock = thisItem.Clock;
                                int length = thisItem.ID.getLength();
                                if ( startClock <= thisItem.Clock && thisItem.Clock + thisItem.ID.getLength() <= endClock ) {
                                    int draftClock = 0;
                                    int draftLength = 0;
                                    int draftLastItemLength = lastItemLength;
                                    // 音符のめり込み等のチェックをクリアするまで、draft(Clock|Length|LastItemLength)をトライ＆エラーで決定する
                                    while ( true ) {
                                        int x = 3 * sigma;
                                        while ( Math.Abs( x ) > 2 * sigma ) {
#if JAVA
                                            double d = r.nextDouble();
#else
                                            double d = r.NextDouble();
#endif
                                            double y = (d - 0.5) * 2.0;
                                            x = (int)(sigma * sqrt2 * math.erfinv( y ));
                                        }
                                        draftClock = clock + x;
                                        draftLength = clock + length - draftClock;
                                        if ( lastItem != null ) {
                                            if ( clock == lastItemClock + lastItemLength ) {
                                                // 音符が連続していた場合
                                                draftLastItemLength = lastItem.ID.getLength() + x;
                                            }
                                        }
                                        // 音符がめり込んだりしてないかどうかをチェック
                                        if ( draftClock < clockPreMeasure ) {
                                            continue;
                                        }
                                        if ( lastItem != null ) {
                                            if ( clock != lastItemClock + lastItemLength ) {
                                                // 音符が連続していなかった場合に、直前の音符にめり込んでいないかどうか
                                                if ( draftClock + draftLength < lastItem.Clock + lastItem.ID.getLength() ) {
                                                    continue;
                                                }
                                            }
                                        }
                                        // チェックにクリアしたのでループを抜ける
                                        break;
                                    }
                                    // draft*の値を適用
                                    thisItem.Clock = draftClock;
                                    thisItem.ID.setLength( draftLength );
                                    if ( lastItem != null ) {
                                        lastItem.ID.setLength( draftLastItemLength );
                                    }
                                } else if ( endClock < thisItem.Clock ) {
                                    break;
                                }
                            }

                            // インデクスを移す
                            lastItemIndex = thisItemIndex;
                            thisItemIndex = nextItemIndex;

                            if ( lastItemIndex == -2 && thisItemIndex == -2 && nextItemIndex == -2 ) {
                                // トラックの最後まで走査し終わったので抜ける
                                break;
                            }
                        }
                    }
                    #endregion

                    // ピッチベンドのランダマイズ
                    #region ピッチベンドのランダマイズ
                    if ( dlg.isPitRandomizeEnabled() ) {
                        int pattern = dlg.getPitRandomizePattern();
                        int value = dlg.getPitRandomizeValue();
                        double order = 1.0 / Math.Pow( 2.0, 5.0 - value );
                        int[] patternPreset = pattern == 1 ? Utility.getRandomizePitPattern1() : pattern == 2 ? Utility.getRandomizePitPattern2() : Utility.getRandomizePitPattern3();
                        int resolution = dlg.getResolution();
                        VsqBPList pit = work.getCurve( "pit" );
                        VsqBPList pbs = work.getCurve( "pbs" );
                        int pbsAtStart = pbs.getValue( startClock );
                        int pbsAtEnd = pbs.getValue( endClock );

                        // startClockからendClock - 1までのpit, pbsをクリアする
                        int count = pit.size();
                        for ( int i = count - 1; i >= 0; i-- ) {
                            int keyClock = pit.getKeyClock( i );
                            if ( startClock <= keyClock && keyClock < endClock ) {
                                pit.removeElementAt( i );
                            }
                        }
                        count = pbs.size();
                        for ( int i = count - 1; i >= 0; i-- ) {
                            int keyClock = pbs.getKeyClock( i );
                            if ( startClock <= keyClock && keyClock < endClock ) {
                                pbs.removeElementAt( i );
                            }
                        }

                        // pbsをデフォルト値にする
                        if ( pbsAtStart != 2 ) {
                            pbs.add( startClock, 2 );
                        }
                        if ( pbsAtEnd != 2 ) {
                            pbs.add( endClock, pbsAtEnd );
                        }

                        StringBuilder sb = new StringBuilder();
                        count = pit.size();
                        boolean first = true;
                        for ( int i = 0; i < count; i++ ) {
                            int clock = pit.getKeyClock( i );
                            if ( clock < startClock ) {
                                int v = pit.getElementA( i );
#if JAVA
                                sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                                sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                                first = false;
                            } else if ( clock <= endClock ) {
                                break;
                            }
                        }
#if JAVA
                        double d = r.nextDouble();
#else
                        double d = r.NextDouble();
#endif
                        int start = (int)(d * (patternPreset.Length - 1));
                        for ( int clock = startClock; clock < endClock; clock += resolution ) {
                            int copyIndex = start + (clock - startClock);
                            int odd = copyIndex / patternPreset.Length;
                            copyIndex = copyIndex - patternPreset.Length * odd;
                            int v = (int)(patternPreset[copyIndex] * order);
#if JAVA
                            sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                            sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                            first = false;
                            //pit.add( clock, v );
                        }
                        for ( int i = 0; i < count; i++ ) {
                            int clock = pit.getKeyClock( i );
                            if ( endClock <= clock ) {
                                int v = pit.getElementA( i );
#if JAVA
                                sb.append( (first ? "" : ",") + (clock + "=" + v) );
#else
                                sb.Append( (first ? "" : ",") + (clock + "=" + v) );
#endif
                                first = false;
                            }
                        }
                        pit.setData( sb.ToString() );
                    }
                    #endregion

                    CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected, work, vsq.AttachedCurves.get( selected - 1 ) );
                    AppManager.register( vsq.executeCommand( run ) );
                    setEdited( true );
                }
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuJobRandomize_Click; ex=" + ex + "\n" );
                serr.println( "FormMain#menuJobRandomize_Click; ex=" + ex );
#if JAVA
                ex.printStackTrace();
#endif
            } finally {
                if ( dlg != null ) {
                    try {
                        dlg.close();
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".menuJobRandomize_Click; ex=" + ex2 + "\n" );
                        serr.println( "FormMain#menuJobRandomize; ex2=" + ex2 );
                    }
                }
            }
        }

        #endregion

        //BOOKMARK: menuScript
        #region menuScript
        public void menuScriptUpdate_Click( Object sender, EventArgs e )
        {
#if ENABLE_SCRIPT
            updateScriptShortcut();
            applyShortcut();
#endif
        }
        #endregion

        //BOOKMARK: vScroll
        #region vScroll
        public void vScroll_Enter( Object sender, EventArgs e )
        {
            pictPianoRoll.requestFocus();
        }

        public void vScroll_ValueChanged( Object sender, EventArgs e )
        {
            AppManager.setStartToDrawY( calculateStartToDrawY( vScroll.getValue() ) );
            if ( AppManager.getEditMode() != EditMode.MIDDLE_DRAG ) {
                // MIDDLE_DRAGのときは，pictPianoRoll_MouseMoveでrefreshScreenされるので，それ以外のときだけ描画・
                refreshScreen( true );
            }
        }
        #endregion

        //BOOKMARK: waveView
        #region waveView
        public void waveView_MouseDoubleClick( Object sender, BMouseEventArgs e )
        {
            if ( e.Button == BMouseButtons.Middle ) {
                // ツールをポインター <--> 鉛筆に切り替える
                if ( e.Y < trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB * 2 ) {
                    if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                        AppManager.setSelectedTool( EditTool.PENCIL );
                    } else {
                        AppManager.setSelectedTool( EditTool.ARROW );
                    }
                }
            }
        }

        public void waveView_MouseDown( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            sout.println( "waveView_MouseDown; isMiddleButtonDowned=" + isMouseMiddleButtonDowned( e.Button ) );
#endif
            if ( isMouseMiddleButtonDowned( e.Button ) ) {
                mEditCurveMode = CurveEditMode.MIDDLE_DRAG;
                mButtonInitial = new Point( e.X, e.Y );
                mMiddleButtonHScroll = hScroll.getValue();
#if !JAVA
                this.Cursor = HAND;
#endif
            }
        }

        public void waveView_MouseUp( Object sender, BMouseEventArgs e )
        {
            if ( mEditCurveMode == CurveEditMode.MIDDLE_DRAG ) {
                mEditCurveMode = CurveEditMode.NONE;
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
            }
        }

        public void waveView_MouseMove( Object sender, BMouseEventArgs e )
        {
            if ( mEditCurveMode == CurveEditMode.MIDDLE_DRAG ) {
                int draft = computeHScrollValueForMiddleDrag( e.X );
                if ( hScroll.getValue() != draft ) {
                    hScroll.setValue( draft );
                }
            }
        }
        #endregion

        //BOOKMARK: hScroll
        #region hScroll
        public void hScroll_Enter( Object sender, EventArgs e )
        {
            pictPianoRoll.requestFocus();
        }

        public void hScroll_Resize( Object sender, EventArgs e )
        {
            if ( getExtendedState() != BForm.ICONIFIED ) {
                updateScrollRangeHorizontal();
            }
        }

        public void hScroll_ValueChanged( Object sender, EventArgs e )
        {
            int stdx = calculateStartToDrawX();
            AppManager.setStartToDrawX( stdx );
            if ( AppManager.getEditMode() != EditMode.MIDDLE_DRAG ) {
                // MIDDLE_DRAGのときは，pictPianoRoll_MouseMoveでrefreshScreenされるので，それ以外のときだけ描画・
                refreshScreen( true );
            }
        }
        #endregion

        //BOOKMARK: picturePositionIndicator
        #region picturePositionIndicator
        public void picturePositionIndicator_MouseWheel( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#picturePositionIndicator_MouseWheel" );
#endif
            hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
        }

        public void picturePositionIndicator_MouseClick( Object sender, BMouseEventArgs e )
        {
            if ( e.Button == BMouseButtons.Right && 0 < e.Y && e.Y <= 18 && AppManager.keyWidth < e.X ) {
                // クリックされた位置でのクロックを保存
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, unit );
                if ( clock < 0 ) {
                    clock = 0;
                }
                mPositionIndicatorPopupShownClock = clock;
                cMenuPositionIndicator.show( picturePositionIndicator, e.X, e.Y );
            }
        }

        public void picturePositionIndicator_MouseDoubleClick( Object sender, BMouseEventArgs e )
        {
            if ( e.X < AppManager.keyWidth || getWidth() - 3 < e.X ) {
                return;
            }
            if ( e.Button == BMouseButtons.Left ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポの変更
#if DEBUG
                    AppManager.debugWriteLine( "TempoChange" );
#endif
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTimesig();

                    if ( AppManager.getSelectedTempoCount() > 0 ) {
                        #region テンポ変更があった場合
                        int index = -1;
                        int clock = AppManager.getLastSelectedTempoClock();
                        for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                            if ( clock == vsq.TempoTable.get( i ).Clock ) {
                                index = i;
                                break;
                            }
                        }
                        if ( index >= 0 ) {
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TempoTable.get( index ).Clock == 0 ) {
                                    String msg = _( "Cannot remove first symbol of track!" );
#if JAVA
                                    statusLabel.setText( msg );
#else
                                    statusLabel.Text = msg;
#endif
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( vsq.TempoTable.get( index ).Clock,
                                                                           vsq.TempoTable.get( index ).Clock,
                                                                           -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            } else {
                                #region ツールがEraser以外
                                TempoTableEntry tte = vsq.TempoTable.get( index );
                                AppManager.clearSelectedTempo();
                                AppManager.addSelectedTempo( tte.Clock );
                                int bar_count = vsq.getBarCountFromClock( tte.Clock );
                                int bar_top_clock = vsq.getClockFromBarCount( bar_count );
                                //int local_denominator, local_numerator;
                                Timesig timesig = vsq.getTimesigAt( tte.Clock );
                                int clock_per_beat = 480 * 4 / timesig.denominator;
                                int clocks_in_bar = tte.Clock - bar_top_clock;
                                int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                                int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                                FormTempoConfig dlg = null;
                                try {
                                    dlg = new FormTempoConfig( bar_count, beat_in_bar, timesig.numerator, clocks_in_beat, clock_per_beat, (float)(6e7 / tte.Tempo), AppManager.getVsqFile().getPreMeasure() );
                                    dlg.setLocation( getFormPreferedLocation( dlg ) );
                                    BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                    if ( dr == BDialogResult.OK ) {
                                        int new_beat = dlg.getBeatCount();
                                        int new_clocks_in_beat = dlg.getClock();
                                        int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                        refreshScreen();
                                    }
                                } catch ( Exception ex ) {
                                    Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex + "\n" );
                                    serr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                                } finally {
                                    if ( dlg != null ) {
                                        try {
                                            dlg.close();
                                        } catch ( Exception ex2 ) {
                                            Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex2 + "\n" );
                                            serr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex2=" + ex2 );
                                        }
                                    }
                                }
                                #endregion
                            }
                        }
                        #endregion
                    } else {
                        #region テンポ変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int changing_clock = AppManager.clockFromXCoord( e.X );
                            int changing_tempo = vsq.getTempoAt( changing_clock );
                            int bar_count;
                            int bar_top_clock;
                            int local_denominator, local_numerator;
                            bar_count = vsq.getBarCountFromClock( changing_clock );
                            bar_top_clock = vsq.getClockFromBarCount( bar_count );
                            int index2 = -1;
                            for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                                if ( vsq.TimesigTable.get( i ).BarCount > bar_count ) {
                                    index2 = i;
                                    break;
                                }
                            }
                            if ( index2 >= 1 ) {
                                local_denominator = vsq.TimesigTable.get( index2 - 1 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( index2 - 1 ).Numerator;
                            } else {
                                local_denominator = vsq.TimesigTable.get( 0 ).Denominator;
                                local_numerator = vsq.TimesigTable.get( 0 ).Numerator;
                            }
                            int clock_per_beat = 480 * 4 / local_denominator;
                            int clocks_in_bar = changing_clock - bar_top_clock;
                            int beat_in_bar = clocks_in_bar / clock_per_beat + 1;
                            int clocks_in_beat = clocks_in_bar - (beat_in_bar - 1) * clock_per_beat;
                            FormTempoConfig dlg = null;
                            try {
                                dlg = new FormTempoConfig( bar_count - vsq.getPreMeasure() + 1,
                                                           beat_in_bar,
                                                           local_numerator,
                                                           clocks_in_beat,
                                                           clock_per_beat,
                                                           (float)(6e7 / changing_tempo),
                                                           vsq.getPreMeasure() );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                if ( dr == BDialogResult.OK ) {
                                    int new_beat = dlg.getBeatCount();
                                    int new_clocks_in_beat = dlg.getClock();
                                    int new_clock = bar_top_clock + (new_beat - 1) * clock_per_beat + new_clocks_in_beat;
#if DEBUG
                                    AppManager.debugWriteLine( "    new_beat=" + new_beat );
                                    AppManager.debugWriteLine( "    new_clocks_in_beat=" + new_clocks_in_beat );
                                    AppManager.debugWriteLine( "    changing_clock=" + changing_clock );
                                    AppManager.debugWriteLine( "    new_clock=" + new_clock );
#endif
                                    CadenciiCommand run = new CadenciiCommand(
                                        VsqCommand.generateCommandUpdateTempo( new_clock, new_clock, (int)(6e7 / (double)dlg.getTempo()) ) );
                                    AppManager.register( vsq.executeCommand( run ) );
                                    setEdited( true );
                                    refreshScreen();
                                }
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex + "\n" );
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                        Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex2 + "\n" );
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                    #region 拍子の変更
                    AppManager.clearSelectedEvent();
                    AppManager.clearSelectedTempo();
                    if ( AppManager.getSelectedTimesigCount() > 0 ) {
                        #region 拍子変更があった場合
                        int index = 0;
                        int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                        for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                            if ( vsq.TimesigTable.get( i ).BarCount == last_barcount ) {
                                index = i;
                                break;
                            }
                        }
                        if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                            #region ツールがEraser
                            if ( vsq.TimesigTable.get( index ).Clock == 0 ) {
                                String msg = _( "Cannot remove first symbol of track!" );
#if JAVA
                                statusLabel.setText( msg );
#else
                                statusLabel.Text = msg;
#endif
#if !JAVA
                                SystemSounds.Asterisk.Play();
#endif
                                return;
                            }
                            int barcount = vsq.TimesigTable.get( index ).BarCount;
                            CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                            AppManager.register( vsq.executeCommand( run ) );
                            setEdited( true );
                            #endregion
                        } else {
                            #region ツールがEraser以外
                            int pre_measure = vsq.getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = vsq.getBarCountFromClock( clock );
                            int total_clock = vsq.TotalClocks;
                            Timesig timesig = vsq.getTimesigAt( clock );
                            boolean num_enabled = !(bar_count == 0);
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, num_enabled, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                if ( dr == BDialogResult.OK ) {
                                    if ( dlg.isEndSpecified() ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        new_barcounts[1] = dlg.getEnd() + pre_measure - 1;
                                        numerators[0] = dlg.getNumerator();
                                        denominators[0] = dlg.getDenominator();
                                        numerators[1] = timesig.numerator;
                                        denominators[1] = timesig.denominator;
                                        barcounts[0] = bar_count;
                                        barcounts[1] = dlg.getEnd() + pre_measure - 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    } else {
#if DEBUG
                                        sout.println( "picturePositionIndicator_MouseDoubleClick" );
                                        sout.println( "    bar_count=" + bar_count );
                                        sout.println( "    dlg.Start+pre_measure-1=" + (dlg.getStart() + pre_measure - 1) );
#endif
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                                     dlg.getStart() + pre_measure - 1,
                                                                                     dlg.getNumerator(),
                                                                                     dlg.getDenominator() ) );
                                        AppManager.register( vsq.executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex + "\n" );
                                serr.println( "FormMain#picturePositionIndicator_MouseDoubleClick; ex=" + ex );
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                        Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex2 + "\n" );
                                        serr.println( "FormMain#picturePositionIndicator_MouseDoubleClic; ex2=" + ex2 );
                                    }
                                }
                            }
                            #endregion
                        }
                        #endregion
                    } else {
                        #region 拍子変更がなかった場合
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                        EditTool selected = AppManager.getSelectedTool();
                        if ( selected == EditTool.PENCIL ||
                            selected == EditTool.LINE ) {
                            int pre_measure = AppManager.getVsqFile().getPreMeasure();
                            int clock = AppManager.clockFromXCoord( e.X );
                            int bar_count = AppManager.getVsqFile().getBarCountFromClock( clock );
                            int numerator, denominator;
                            Timesig timesig = AppManager.getVsqFile().getTimesigAt( clock );
                            int total_clock = AppManager.getVsqFile().TotalClocks;
                            //int max_barcount = AppManager.VsqFile.getBarCountFromClock( total_clock ) - pre_measure + 1;
                            //int min_barcount = 1;
#if DEBUG
                            AppManager.debugWriteLine( "FormMain.picturePositionIndicator_MouseClick; bar_count=" + (bar_count - pre_measure + 1) );
#endif
                            FormBeatConfig dlg = null;
                            try {
                                dlg = new FormBeatConfig( bar_count - pre_measure + 1, timesig.numerator, timesig.denominator, true, pre_measure );
                                dlg.setLocation( getFormPreferedLocation( dlg ) );
                                BDialogResult dr = AppManager.showModalDialog( dlg, this );
                                if ( dr == BDialogResult.OK ) {
                                    if ( dlg.isEndSpecified() ) {
                                        int[] new_barcounts = new int[2];
                                        int[] numerators = new int[2];
                                        int[] denominators = new int[2];
                                        int[] barcounts = new int[2];
                                        new_barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        new_barcounts[1] = dlg.getEnd() + pre_measure - 1 + 1;
                                        numerators[0] = dlg.getNumerator();
                                        numerators[1] = timesig.numerator;

                                        denominators[0] = dlg.getDenominator();
                                        denominators[1] = timesig.denominator;

                                        barcounts[0] = dlg.getStart() + pre_measure - 1;
                                        barcounts[1] = dlg.getEnd() + pre_measure - 1 + 1;
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    } else {
                                        CadenciiCommand run = new CadenciiCommand(
                                            VsqCommand.generateCommandUpdateTimesig( bar_count,
                                                                           dlg.getStart() + pre_measure - 1,
                                                                           dlg.getNumerator(),
                                                                           dlg.getDenominator() ) );
                                        AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                                        setEdited( true );
                                    }
                                }
                            } catch ( Exception ex ) {
                                Logger.write( typeof( FormMain ) + ".picutrePositionIndicator_MouseDoubleClick; ex=" + ex + "\n" );
                            } finally {
                                if ( dlg != null ) {
                                    try {
                                        dlg.close();
                                    } catch ( Exception ex2 ) {
                                        Logger.write( typeof( FormMain ) + ".picturePositionIndicator_MouseDoubleClick; ex=" + ex2 + "\n" );
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                    mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
                    #endregion
                }
                picturePositionIndicator.repaint();
                pictPianoRoll.repaint();
            }
        }

        public void picturePositionIndicator_MouseDown( Object sender, BMouseEventArgs e )
        {
            if ( e.X < AppManager.keyWidth || getWidth() - 3 < e.X ) {
                return;
            }

            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
            int modifiers = PortUtil.getCurrentModifierKey();
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( e.Button == BMouseButtons.Left ) {
                if ( 0 <= e.Y && e.Y <= 18 ) {
                    #region スタート/エンドマーク
                    int tolerance = AppManager.editorConfig.PxTolerance;
                    int start_marker_width = Resources.get_start_marker().getWidth( this );
                    int end_marker_width = Resources.get_end_marker().getWidth( this );
                    int startx = AppManager.xCoordFromClocks( vsq.config.StartMarker );
                    int endx = AppManager.xCoordFromClocks( vsq.config.EndMarker );
                    
                    // マウスの当たり判定が重なるようなら，判定幅を最小にする
                    int start0 = startx - tolerance;
                    int start1 = startx + start_marker_width + tolerance;
                    int end0 = endx - end_marker_width - tolerance;
                    int end1 = endx + tolerance;
                    if ( vsq.config.StartMarkerEnabled && vsq.config.EndMarkerEnabled ) {
                        if ( start0 < end1 && end1 < start1 ||
                            start1 < end0 && end0 < start1 ) {
                            start0 = startx;
                            start1 = startx + start_marker_width;
                            end0 = endx - end_marker_width;
                            end1 = endx;
                        }
                    }

                    if ( vsq.config.StartMarkerEnabled ) {
                        if ( start0 <= e.X && e.X <= start1 ) {
                            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.MARK_START;
                        }
                    }
                    if ( vsq.config.EndMarkerEnabled && mPositionIndicatorMouseDownMode != PositionIndicatorMouseDownMode.MARK_START ) {
                        if ( end0 <= e.X && e.X <= end1 ) {
                            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.MARK_END;
                        }
                    }
                    #endregion
                } else if ( 18 < e.Y && e.Y <= 32 ) {
                    #region テンポ
                    int index = -1;
                    int count = AppManager.getVsqFile().TempoTable.size();
                    for ( int i = 0; i < count; i++ ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                        int x = AppManager.xCoordFromClocks( clock );
                        if ( x < 0 ) {
                            continue;
                        } else if ( getWidth() < x ) {
                            break;
                        }
                        String s = PortUtil.formatDecimal( "#.00", 60e6 / (float)AppManager.getVsqFile().TempoTable.get( i ).Tempo );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 ) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), new Rectangle( x, 14, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int clock = AppManager.getVsqFile().TempoTable.get( index ).Clock;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            mTempoDraggingDeltaClock = mouse_clock - clock;
                            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.TEMPO;
                        }
                        if ( (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTempoCount() > 0 ) {
                                int last_clock = AppManager.getLastSelectedTempoClock();
                                int start = Math.Min( last_clock, clock );
                                int end = Math.Max( last_clock, clock );
                                for ( int i = 0; i < AppManager.getVsqFile().TempoTable.size(); i++ ) {
                                    int tclock = AppManager.getVsqFile().TempoTable.get( i ).Clock;
                                    if ( tclock < start ) {
                                        continue;
                                    } else if ( end < tclock ) {
                                        break;
                                    }
                                    if ( start <= tclock && tclock <= end ) {
                                        AppManager.addSelectedTempo( tclock );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else if ( (modifiers & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.removeSelectedTempo( clock );
                            } else {
                                AppManager.addSelectedTempo( clock );
                            }
                        } else {
                            if ( !AppManager.isSelectedTempoContains( clock ) ) {
                                AppManager.clearSelectedTempo();
                            }
                            AppManager.addSelectedTempo( clock );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                    #region 拍子
                    // クリック位置に拍子が表示されているかどうか検査
                    int index = -1;
                    for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                        String s = AppManager.getVsqFile().TimesigTable.get( i ).Numerator + "/" + AppManager.getVsqFile().TimesigTable.get( i ).Denominator;
                        int x = AppManager.xCoordFromClocks( AppManager.getVsqFile().TimesigTable.get( i ).Clock );
                        Dimension size = Util.measureString( s, new Font( AppManager.editorConfig.ScreenFontName, java.awt.Font.PLAIN, AppManager.FONT_SIZE8 ) );
                        if ( Utility.isInRect( new Point( e.X, e.Y ), new Rectangle( x, 28, (int)size.width, 14 ) ) ) {
                            index = i;
                            break;
                        }
                    }

                    if ( index >= 0 ) {
                        int barcount = AppManager.getVsqFile().TimesigTable.get( index ).BarCount;
                        if ( AppManager.getSelectedTool() != EditTool.ERASER ) {
                            int barcount_clock = AppManager.getVsqFile().getClockFromBarCount( barcount );
                            int mouse_clock = AppManager.clockFromXCoord( e.X );
                            mTimesigDraggingDeltaClock = mouse_clock - barcount_clock;
                            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.TIMESIG;
                        }
                        if ( (modifiers & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                            if ( AppManager.getSelectedTimesigCount() > 0 ) {
                                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                                int start = Math.Min( last_barcount, barcount );
                                int end = Math.Max( last_barcount, barcount );
                                for ( int i = 0; i < AppManager.getVsqFile().TimesigTable.size(); i++ ) {
                                    int tbarcount = AppManager.getVsqFile().TimesigTable.get( i ).BarCount;
                                    if ( tbarcount < start ) {
                                        continue;
                                    } else if ( end < tbarcount ) {
                                        break;
                                    }
                                    if ( start <= tbarcount && tbarcount <= end ) {
                                        AppManager.addSelectedTimesig( AppManager.getVsqFile().TimesigTable.get( i ).BarCount );
                                    }
                                }
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else if ( (modifiers & s_modifier_key) == s_modifier_key ) {
                            if ( AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.removeSelectedTimesig( barcount );
                            } else {
                                AppManager.addSelectedTimesig( barcount );
                            }
                        } else {
                            if ( !AppManager.isSelectedTimesigContains( barcount ) ) {
                                AppManager.clearSelectedTimesig();
                            }
                            AppManager.addSelectedTimesig( barcount );
                        }
                    } else {
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        AppManager.clearSelectedTimesig();
                    }
                    #endregion
                }
            }
            refreshScreen();
        }

        public void picturePositionIndicator_MouseUp( Object sender, BMouseEventArgs e )
        {
            int modifiers = PortUtil.getCurrentModifierKey();
#if DEBUG
            AppManager.debugWriteLine( "picturePositionIndicator_MouseClick" );
#endif
            if ( e.Button == BMouseButtons.Left ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.NONE ) {
                    if ( 4 <= e.Y && e.Y <= 18 ) {
                        #region マーカー位置の変更
                        int clock = AppManager.clockFromXCoord( e.X );
                        if ( AppManager.editorConfig.getPositionQuantize() != QuantizeMode.off ) {
                            int unit = AppManager.getPositionQuantizeClock();
                            clock = doQuantize( clock, unit );
                        }
                        if ( AppManager.isPlaying() ) {
                            AppManager.setPlaying( false, this );
                            AppManager.setCurrentClock( clock );
                            AppManager.setPlaying( true, this );
                        } else {
                            AppManager.setCurrentClock( clock );
                        }
                        refreshScreen();
                        #endregion
                    } else if ( 18 < e.Y && e.Y <= 32 ) {
                        #region テンポの変更
#if DEBUG
                        AppManager.debugWriteLine( "TempoChange" );
#endif
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTimesig();
                        if ( AppManager.getSelectedTempoCount() > 0 ) {
                            #region テンポ変更があった場合
                            int index = -1;
                            int clock = AppManager.getLastSelectedTempoClock();
                            for ( int i = 0; i < vsq.TempoTable.size(); i++ ) {
                                if ( clock == vsq.TempoTable.get( i ).Clock ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( index >= 0 && AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TempoTable.get( index ).Clock == 0 ) {
                                    String msg = _( "Cannot remove first symbol of track!" );
#if JAVA
                                    statusLabel.setText( msg );
#else
                                    statusLabel.Text = msg;
#endif
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                CadenciiCommand run = new CadenciiCommand(
                                    VsqCommand.generateCommandUpdateTempo( vsq.TempoTable.get( index ).Clock,
                                                                           vsq.TempoTable.get( index ).Clock,
                                                                           -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        }
                        mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
                        #endregion
                    } else if ( 32 < e.Y && e.Y <= picturePositionIndicator.getHeight() - 1 ) {
                        #region 拍子の変更
                        AppManager.clearSelectedEvent();
                        AppManager.clearSelectedTempo();
                        if ( AppManager.getSelectedTimesigCount() > 0 ) {
                            #region 拍子変更があった場合
                            int index = 0;
                            int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                            for ( int i = 0; i < vsq.TimesigTable.size(); i++ ) {
                                if ( vsq.TimesigTable.get( i ).BarCount == last_barcount ) {
                                    index = i;
                                    break;
                                }
                            }
                            if ( AppManager.getSelectedTool() == EditTool.ERASER ) {
                                #region ツールがEraser
                                if ( vsq.TimesigTable.get( index ).Clock == 0 ) {
                                    String msg = _( "Cannot remove first symbol of track!" );
#if JAVA
                                    statusLabel.setText( msg );
#else
                                    statusLabel.Text = msg;
#endif
#if !JAVA
                                    SystemSounds.Asterisk.Play();
#endif
                                    return;
                                }
                                int barcount = vsq.TimesigTable.get( index ).BarCount;
                                CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTimesig( barcount, barcount, -1, -1 ) );
                                AppManager.register( vsq.executeCommand( run ) );
                                setEdited( true );
                                #endregion
                            }
                            #endregion
                        }
                        #endregion
                    }
                } else if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TEMPO ) {
                    int count = AppManager.getSelectedTempoCount();
                    int[] clocks = new int[count];
                    int[] new_clocks = new int[count];
                    int[] tempos = new int[count];
                    int i = -1;
                    boolean contains_first_tempo = false;
                    for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                        int clock = item.getKey();
                        i++;
                        clocks[i] = clock;
                        if ( clock == 0 ) {
                            contains_first_tempo = true;
                            break;
                        }
                        TempoTableEntry editing = AppManager.getSelectedTempo( clock ).editing;
                        new_clocks[i] = editing.Clock;
                        tempos[i] = editing.Tempo;
                    }
                    if ( contains_first_tempo ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandUpdateTempoRange( clocks, new_clocks, tempos ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                } else if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TIMESIG ) {
                    int count = AppManager.getSelectedTimesigCount();
                    int[] barcounts = new int[count];
                    int[] new_barcounts = new int[count];
                    int[] numerators = new int[count];
                    int[] denominators = new int[count];
                    int i = -1;
                    boolean contains_first_bar = false;
                    for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                        ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                        int bar = item.getKey();
                        i++;
                        barcounts[i] = bar;
                        if ( bar == 0 ) {
                            contains_first_bar = true;
                            break;
                        }
                        TimeSigTableEntry editing = AppManager.getSelectedTimesig( bar ).editing;
                        new_barcounts[i] = editing.BarCount;
                        numerators[i] = editing.Numerator;
                        denominators[i] = editing.Denominator;
                    }
                    if ( contains_first_bar ) {
#if !JAVA
                        SystemSounds.Asterisk.Play();
#endif
                    } else {
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandUpdateTimesigRange( barcounts, new_barcounts, numerators, denominators ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                }
            }
            mPositionIndicatorMouseDownMode = PositionIndicatorMouseDownMode.NONE;
            pictPianoRoll.repaint();
            picturePositionIndicator.repaint();
        }

        public void picturePositionIndicator_MouseMove( Object sender, BMouseEventArgs e )
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TEMPO ) {
                int clock = AppManager.clockFromXCoord( e.X ) - mTempoDraggingDeltaClock;
                int step = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, step );
                int last_clock = AppManager.getLastSelectedTempoClock();
                int dclock = clock - last_clock;
                for ( Iterator<ValuePair<Integer, SelectedTempoEntry>> itr = AppManager.getSelectedTempoIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTempoEntry> item = itr.next();
                    int key = item.getKey();
                    AppManager.getSelectedTempo( key ).editing.Clock = AppManager.getSelectedTempo( key ).original.Clock + dclock;
                }
                picturePositionIndicator.repaint();
            } else if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.TIMESIG ) {
                int clock = AppManager.clockFromXCoord( e.X ) - mTimesigDraggingDeltaClock;
                int barcount = vsq.getBarCountFromClock( clock );
                int last_barcount = AppManager.getLastSelectedTimesigBarcount();
                int dbarcount = barcount - last_barcount;
                for ( Iterator<ValuePair<Integer, SelectedTimesigEntry>> itr = AppManager.getSelectedTimesigIterator(); itr.hasNext(); ) {
                    ValuePair<Integer, SelectedTimesigEntry> item = itr.next();
                    int bar = item.getKey();
                    AppManager.getSelectedTimesig( bar ).editing.BarCount = AppManager.getSelectedTimesig( bar ).original.BarCount + dbarcount;
                }
                picturePositionIndicator.repaint();
            } else if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.MARK_START ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, unit );
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, vsq.config.EndMarker );
                int draft_end = Math.Max( clock, vsq.config.EndMarker );
                if ( draft_start != vsq.config.StartMarker ) {
                    vsq.config.StartMarker = draft_start;
                    setEdited( true );
                }
                if ( draft_end != vsq.config.EndMarker ) {
                    vsq.config.EndMarker = draft_end;
                    setEdited( true );
                }
                refreshScreen();
            } else if ( mPositionIndicatorMouseDownMode == PositionIndicatorMouseDownMode.MARK_END ) {
                int clock = AppManager.clockFromXCoord( e.X );
                int unit = AppManager.getPositionQuantizeClock();
                clock = doQuantize( clock, unit );
                if ( clock < 0 ) {
                    clock = 0;
                }
                int draft_start = Math.Min( clock, vsq.config.StartMarker );
                int draft_end = Math.Max( clock, vsq.config.StartMarker );
                if ( draft_start != vsq.config.StartMarker ) {
                    vsq.config.StartMarker = draft_start;
                    setEdited( true );
                }
                if ( draft_end != vsq.config.EndMarker ) {
                    vsq.config.EndMarker = draft_end;
                    setEdited( true );
                }
                refreshScreen();
            }
        }

        public void picturePositionIndicator_Paint( Object sender, BPaintEventArgs e )
        {
#if JAVA
            Graphics g = e.Graphics;
#else
            Graphics2D g = new Graphics2D( e.Graphics );
#endif
            picturePositionIndicatorDrawTo( g );
#if MONITOR_FPS
            g.setColor( Color.red );
            g.setFont( AppManager.baseFont10Bold );
            g.drawString( PortUtil.formatDecimal( "#.00", mFps ) + " / " + PortUtil.formatDecimal( "#.00", mFps2 ), 5, 5 );
#endif
        }

        public void picturePositionIndicator_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e )
        {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }
        #endregion

        //BOOKMARK: trackBar
        #region trackBar
        public void trackBar_Enter( Object sender, EventArgs e )
        {
            pictPianoRoll.requestFocus();
        }

        public void trackBar_ValueChanged( Object sender, EventArgs e )
        {
            AppManager.setScaleX( getScaleXFromTrackBarValue( trackBar.getValue() ) );
            AppManager.setStartToDrawX( calculateStartToDrawX() );
            updateDrawObjectList();
            repaint();
        }
        #endregion

        //BOOKMARK: menuHelp
        #region menuHelp
        public void menuHelpAbout_Click( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#menuHelpAbout_Click" );
#endif

#if JAVA
            String version_str = Utility.getVersion();
#else
            String version_str = Utility.getVersion() + "\n\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.apputil.Util ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.media.Wave ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.vsq.VsqFile ) ) + "\n" +
                                 Utility.getAssemblyNameAndFileVersion( typeof( org.kbinani.math ) );
#endif
            if ( mVersionInfo == null ) {
                mVersionInfo = new VersionInfo( _APP_NAME, version_str );
                mVersionInfo.setAuthorList( _CREDIT );
                mVersionInfo.setVisible( true );
            } else {
#if !JAVA
                if ( mVersionInfo.IsDisposed ) {
                    mVersionInfo = new VersionInfo( _APP_NAME, version_str );
                    mVersionInfo.setAuthorList( _CREDIT );
                }
#endif
                mVersionInfo.setVisible( true );
            }
        }

        public void menuHelpDebug_Click( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#menuHelpDebug_Click" );
#endif
        }

        public void menuHelpManual_Click( Object sender, BEventArgs e )
        {
            // 現在のUI言語と同じ版のマニュアルファイルがあるかどうか探す
            String lang = Messaging.getLanguage();
            String pdf = fsys.combine( PortUtil.getApplicationStartupPath(), "manual_" + lang + ".pdf" );
            if( !fsys.isFileExists( pdf ) ){
                // 無ければ英語版のマニュアルを表示することにする
                pdf = fsys.combine( PortUtil.getApplicationStartupPath(), "manual_en.pdf" );
            }
            if( !fsys.isFileExists( pdf ) ){
                AppManager.showMessageBox(
                    _( "file not found" ),
                    _APP_NAME,
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
#if JAVA
            try{
                // TODO: manual_*.pdfを開く．Linux版ではどうする？
                Runtime.getRuntime().exec( new String[]{ "open", pdf } );
            }catch( Exception ex ){
                ex.printStackTrace();
            }
#else
            System.Diagnostics.Process.Start( pdf );
#endif
        }

        public void menuHelpLogSwitch_CheckedChanged( Object sender, EventArgs e )
        {
            Logger.setEnabled( menuHelpLogSwitch.isSelected() );
            if ( menuHelpLogSwitch.isSelected() ) {
                menuHelpLogSwitch.setText( _( "Enabled" ) );
            } else {
                menuHelpLogSwitch.setText( _( "Disabled" ) );
            }
        }

        public void menuHelpLogOpen_Click( Object sender, EventArgs e )
        {
            String file = Logger.getPath();
            if ( file == null || (file != null && (!fsys.isFileExists( file ))) ) {
                // ログがまだできてないのでダイアログ出す
                AppManager.showMessageBox(
                    _( "Log file has not generated yet." ),
                    _( "Info" ),
                    PortUtil.OK_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_INFORMATION_MESSAGE );
                return;
            }

            // ログファイルを開く
#if JAVA
            try{
                Runtime.getRuntime().exec( new String[] { "open", file } );
            }catch( Exception ex ){
                ex.printStackTrace();
            }
#else
            try {
                System.Diagnostics.Process.Start( file );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".menuHelpLogOpen_Click; ex=" + ex + "\n" );
            }
#endif
        }
        #endregion

        //BOOKMARK: trackSelector
        #region trackSelector
        public void trackSelector_CommandExecuted( Object sender, EventArgs e )
        {
            setEdited( true );
            refreshScreen();
        }

        public void trackSelector_MouseClick( Object sender, BMouseEventArgs e )
        {
            if ( e.Button == BMouseButtons.Right ) {
                if ( AppManager.keyWidth < e.X && e.X < trackSelector.getWidth() ) {
                    if ( trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB <= e.Y && e.Y <= trackSelector.getHeight() ) {
                        cMenuTrackTab.show( trackSelector, e.X, e.Y );
                    } else {
                        cMenuTrackSelector.show( trackSelector, e.X, e.Y );
                    }
                }
            }
        }

        public void trackSelector_MouseDoubleClick( Object sender, BMouseEventArgs e )
        {
            if ( e.Button == BMouseButtons.Middle ) {
                // ツールをポインター <--> 鉛筆に切り替える
                if ( AppManager.keyWidth < e.X &&
                     e.Y < trackSelector.getHeight() - TrackSelector.OFFSET_TRACK_TAB * 2 ) {
                    if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                        AppManager.setSelectedTool( EditTool.PENCIL );
                    } else {
                        AppManager.setSelectedTool( EditTool.ARROW );
                    }
                }
            }
        }

        public void trackSelector_MouseDown( Object sender, BMouseEventArgs e )
        {
            if ( AppManager.keyWidth < e.X ) {
                mMouseDownedTrackSelector = true;
                if ( isMouseMiddleButtonDowned( e.Button ) ) {
                    mEditCurveMode = CurveEditMode.MIDDLE_DRAG;
                    mButtonInitial = new Point( e.X, e.Y );
                    mMiddleButtonHScroll = hScroll.getValue();
#if !JAVA
                    this.Cursor = HAND;
#endif
                }
            }
        }

        public void trackSelector_MouseMove( Object sender, BMouseEventArgs e )
        {
            if ( mFormActivated && AppManager.mInputTextBox != null ){
#if JAVA
                boolean input_visible = AppManager.mInputTextBox.isVisible();
#else
                boolean input_visible = !AppManager.mInputTextBox.IsDisposed && AppManager.mInputTextBox.isVisible();
#endif
#if ENABLE_PROPERTY
                boolean prop_editing = AppManager.propertyPanel.isEditing();
#else
                boolean prop_editing = false;
#endif
                if( !input_visible && !prop_editing ){
                    trackSelector.requestFocus();
                }
            }
            if ( e.Button == BMouseButtons.None ) {
                if ( !timer.isRunning() ) {
                    refreshScreen( true );
                }
                return;
            }
            int parent_width = ((TrackSelector)sender).getWidth();
            if ( mEditCurveMode == CurveEditMode.MIDDLE_DRAG ) {
                if ( AppManager.isPlaying() ) {
                    return;
                }

                int draft = computeHScrollValueForMiddleDrag( e.X );
                if ( hScroll.getValue() != draft ) {
                    hScroll.setValue( draft );
                }
            } else {
                if ( mMouseDownedTrackSelector ) {
                    if ( mExtDragXTrackSelector == ExtDragXMode.NONE ) {
                        if ( AppManager.keyWidth > e.X ) {
                            mExtDragXTrackSelector = ExtDragXMode.LEFT;
                        } else if ( parent_width < e.X ) {
                            mExtDragXTrackSelector = ExtDragXMode.RIGHT;
                        }
                    } else {
                        if ( AppManager.keyWidth <= e.X && e.X <= parent_width ) {
                            mExtDragXTrackSelector = ExtDragXMode.NONE;
                        }
                    }
                } else {
                    mExtDragXTrackSelector = ExtDragXMode.NONE;
                }

                if ( mExtDragXTrackSelector != ExtDragXMode.NONE ) {
                    double now = PortUtil.getCurrentTime();
                    double dt = now - mTimerDragLastIgnitted;
                    mTimerDragLastIgnitted = now;
                    int px_move = AppManager.editorConfig.MouseDragIncrement;
                    if ( px_move / dt > AppManager.editorConfig.MouseDragMaximumRate ) {
                        px_move = (int)(dt * AppManager.editorConfig.MouseDragMaximumRate);
                    }
                    px_move += 5;
                    if ( mExtDragXTrackSelector == ExtDragXMode.LEFT ) {
                        px_move *= -1;
                    }
                    double d_draft = hScroll.getValue() + px_move * AppManager.getScaleXInv();
                    if ( d_draft < 0.0 ) {
                        d_draft = 0.0;
                    }
                    int draft = (int)d_draft;
                    if ( hScroll.getMaximum() < draft ) {
                        hScroll.setMaximum( draft );
                    }
                    if ( draft < hScroll.getMinimum() ) {
                        draft = hScroll.getMinimum();
                    }
                    hScroll.setValue( draft );
                }
            }
            if ( !timer.isRunning() ) {
                refreshScreen( true );
            }
        }

        public void trackSelector_MouseUp( Object sender, BMouseEventArgs e )
        {
            mMouseDownedTrackSelector = false;
            if ( mEditCurveMode == CurveEditMode.MIDDLE_DRAG ) {
                mEditCurveMode = CurveEditMode.NONE;
                setCursor( new Cursor( java.awt.Cursor.DEFAULT_CURSOR ) );
            }
        }

        public void trackSelector_MouseWheel( Object sender, BMouseEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#trackSelector_MouseWheel" );
#endif
            if ( (PortUtil.getCurrentModifierKey() & InputEvent.SHIFT_MASK) == InputEvent.SHIFT_MASK ) {
                double new_val = (double)vScroll.getValue() - e.Delta;
                int max = vScroll.getMaximum() - vScroll.getMinimum();
                int min = vScroll.getMinimum();
                if ( new_val > max ) {
                    vScroll.setValue( max );
                } else if ( new_val < min ) {
                    vScroll.setValue( min );
                } else {
                    vScroll.setValue( (int)new_val );
                }
            } else {
                hScroll.setValue( computeScrollValueFromWheelDelta( e.Delta ) );
            }
            refreshScreen();
        }

        public void trackSelector_PreferredMinHeightChanged( Object sender, EventArgs e )
        {
            if ( menuVisualControlTrack.isSelected() ) {
                splitContainer1.setPanel2MinSize( trackSelector.getPreferredMinSize() );
#if DEBUG
                sout.println( "FormMain#trackSelector_PreferredMinHeightChanged; splitContainer1.Panel2MinSize changed" );
#endif
            }
        }

        public void trackSelector_PreviewKeyDown( Object sender, BPreviewKeyDownEventArgs e )
        {
#if JAVA
            BKeyEventArgs e0 = new BKeyEventArgs( e.getRawEvent() );
#else
            BKeyEventArgs e0 = new BKeyEventArgs( e.KeyData );
#endif
            processSpecialShortcutKey( e0, true );
        }

        public void trackSelector_RenderRequired( Object sender, int track )
        {
            Vector<Integer> list = new Vector<Integer>();
            list.add( track );
            AppManager.patchWorkToFreeze( this, list );
            /*int selected = AppManager.getSelected();
            Vector<Integer> t = new Vector<Integer>( Arrays.asList( PortUtil.convertIntArray( tracks ) ) );
            if ( t.contains( selected) ) {
                String file = fsys.combine( AppManager.getTempWaveDir(), selected + ".wav" );
                if ( PortUtil.isFileExists( file ) ) {
#if JAVA
                    Thread loadwave_thread = new Thread( new LoadWaveProc( file ) );
                    loadwave_thread.start();
#else
                    Thread loadwave_thread = new Thread( new ParameterizedThreadStart( this.loadWave ) );
                    loadwave_thread.IsBackground = true;
                    loadwave_thread.Start( new Object[]{ file, selected - 1 } );
#endif
                }
            }*/
        }

        public void trackSelector_SelectedCurveChanged( Object sender, CurveType type )
        {
            refreshScreen();
        }

        public void trackSelector_SelectedTrackChanged( Object sender, int selected )
        {
            AppManager.clearSelectedBezier();
            AppManager.clearSelectedEvent();
            AppManager.clearSelectedPoint();
            updateDrawObjectList();
            refreshScreen();
        }
        #endregion

        //BOOKMARK: cMenuPiano
        #region cMenuPiano*
        public void cMenuPianoDelete_Click( Object sender, EventArgs e )
        {
            deleteEvent();
        }

        public void cMenuPianoVibratoProperty_Click( Object sender, EventArgs e )
        {
            editNoteVibratoProperty();
        }

        public void cMenuPianoPaste_Click( Object sender, EventArgs e )
        {
            pasteEvent();
        }

        public void cMenuPianoCopy_Click( Object sender, EventArgs e )
        {
            copyEvent();
        }

        public void cMenuPianoCut_Click( Object sender, EventArgs e )
        {
            cutEvent();
        }

        public void cMenuPianoExpression_Click( Object sender, EventArgs e )
        {
            if ( AppManager.getSelectedEventCount() > 0 ) {
                VsqFileEx vsq = AppManager.getVsqFile();
                int selected = AppManager.getSelected();
                SynthesizerType type = SynthesizerType.VOCALOID2;
                RendererKind kind = VsqFileEx.getTrackRendererKind( vsq.Track.get( selected ) );
                if ( kind == RendererKind.VOCALOID1 ) {
                    type = SynthesizerType.VOCALOID1;
                }
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                FormNoteExpressionConfig dlg = null;
                try {
                    dlg = new FormNoteExpressionConfig( type, original.ID.NoteHeadHandle );
                    int id = AppManager.getLastSelectedEvent().original.InternalID;
                    dlg.setPMBendDepth( original.ID.PMBendDepth );
                    dlg.setPMBendLength( original.ID.PMBendLength );
                    dlg.setPMbPortamentoUse( original.ID.PMbPortamentoUse );
                    dlg.setDEMdecGainRate( original.ID.DEMdecGainRate );
                    dlg.setDEMaccent( original.ID.DEMaccent );
                    BDialogResult dr = AppManager.showModalDialog( dlg, this );
                    if ( dr == BDialogResult.OK ) {
                        VsqID copy = (VsqID)original.ID.clone();
                        copy.PMBendDepth = dlg.getPMBendDepth();
                        copy.PMBendLength = dlg.getPMBendLength();
                        copy.PMbPortamentoUse = dlg.getPMbPortamentoUse();
                        copy.DEMdecGainRate = dlg.getDEMdecGainRate();
                        copy.DEMaccent = dlg.getDEMaccent();
                        copy.NoteHeadHandle = dlg.getEditedNoteHeadHandle();
                        CadenciiCommand run = new CadenciiCommand(
                            VsqCommand.generateCommandEventChangeIDContaints( selected, id, copy ) );
                        AppManager.register( vsq.executeCommand( run ) );
                        setEdited( true );
                    }
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".cMenuPianoExpression_Click; ex=" + ex + "\n" );
                } finally {
                    if ( dlg != null ) {
                        try {
                            dlg.close();
                        } catch ( Exception ex2 ) {
                            Logger.write( typeof( FormMain ) + ".cMenuPianoExpression_Click; ex=" + ex2 + "\n" );
                        }
                    }
                }
            }
        }

        public void cMenuPianoPointer_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        public void cMenuPianoPencil_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        public void cMenuPianoEraser_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void cMenuPianoGrid_Click( Object sender, EventArgs e )
        {
            boolean new_v = !AppManager.isGridVisible();
            cMenuPianoGrid.setSelected( new_v );
            AppManager.setGridVisible( new_v );
        }

        public void cMenuPianoUndo_Click( Object sender, EventArgs e )
        {
            undo();
        }

        public void cMenuPianoRedo_Click( Object sender, EventArgs e )
        {
            redo();
        }

        public void cMenuPianoSelectAllEvents_Click( Object sender, EventArgs e )
        {
            selectAllEvent();
        }

        public void cMenuPianoProperty_Click( Object sender, EventArgs e )
        {
            editNoteExpressionProperty();
        }

        public void cMenuPianoImportLyric_Click( Object sender, EventArgs e )
        {
            importLyric();
        }

        public void cMenuPiano_Opening( Object sender, BCancelEventArgs e )
        {
            updateCopyAndPasteButtonStatus();
            cMenuPianoImportLyric.setEnabled( AppManager.getLastSelectedEvent() != null );
        }

        public void cMenuPianoSelectAll_Click( Object sender, EventArgs e )
        {
            selectAll();
        }

        public void cMenuPianoFixed01_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L1 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed02_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L2 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed04_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L4 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed08_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L8 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed16_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L16 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed32_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L32 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed64_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L64 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixed128_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.L128 );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedOff_Click( Object sender, EventArgs e )
        {
            mPencilMode.setMode( PencilModeEnum.Off );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedTriplet_Click( Object sender, EventArgs e )
        {
            mPencilMode.setTriplet( !mPencilMode.isTriplet() );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoFixedDotted_Click( Object sender, EventArgs e )
        {
            mPencilMode.setDot( !mPencilMode.isDot() );
            updateCMenuPianoFixed();
        }

        public void cMenuPianoCurve_Click( Object sender, EventArgs e )
        {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
            applySelectedTool();
        }
        #endregion

        //BOOKMARK: menuTrack
        #region menuTrack*
        public void menuTrack_DropDownOpening( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#menuTrack_DropDownOpening" );
#endif
            updateTrackMenuStatus();
        }

        public void menuTrackCopy_Click( Object sender, EventArgs e )
        {
            copyTrackCore();
        }

        public void menuTrackChangeName_Click( Object sender, EventArgs e )
        {
            changeTrackNameCore();
        }

        public void menuTrackDelete_Click( Object sender, EventArgs e )
        {
            deleteTrackCore();
        }

        public void menuTrackAdd_Click( Object sender, EventArgs e )
        {
            addTrackCore();
        }

        public void menuTrackOverlay_Click( Object sender, EventArgs e )
        {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        public void menuTrackRenderCurrent_Click( Object sender, EventArgs e )
        {
            Vector<Integer> tracks = new Vector<Integer>();
            tracks.add( AppManager.getSelected() );
            AppManager.patchWorkToFreeze( this, tracks );
        }

        public void menuTrackRenderer_DropDownOpening( Object sender, EventArgs e )
        {
            updateRendererMenu();
        }
        #endregion

        //BOOKMARK: menuHidden
        #region menuHidden*
        public void menuHiddenVisualForwardParameter_Click( Object sender, EventArgs e )
        {
            trackSelector.SelectNextCurve();
        }

        public void menuHiddenVisualBackwardParameter_Click( Object sender, EventArgs e )
        {
            trackSelector.SelectPreviousCurve();
        }

        public void menuHiddenTrackNext_Click( Object sender, EventArgs e )
        {
            if ( AppManager.getSelected() == AppManager.getVsqFile().Track.size() - 1 ) {
                AppManager.setSelected( 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() + 1 );
            }
            refreshScreen();
        }

        public void menuHiddenShorten_Click( Object sender, EventArgs e )
        {
            QuantizeMode qmode = AppManager.editorConfig.getLengthQuantize();
            boolean triplet = AppManager.editorConfig.isLengthQuantizeTriplet();
            int delta = -QuantizeModeUtil.getQuantizeClock( qmode, triplet );
            lengthenSelectedEvent( delta );
        }

        public void menuHiddenTrackBack_Click( Object sender, EventArgs e )
        {
            if ( AppManager.getSelected() == 1 ) {
                AppManager.setSelected( AppManager.getVsqFile().Track.size() - 1 );
            } else {
                AppManager.setSelected( AppManager.getSelected() - 1 );
            }
            refreshScreen();
        }

        public void menuHiddenEditPaste_Click( Object sender, EventArgs e )
        {
            pasteEvent();
        }

        public void menuHiddenFlipCurveOnPianorollMode_Click( Object sender, EventArgs e )
        {
            AppManager.mCurveOnPianoroll = !AppManager.mCurveOnPianoroll;
            refreshScreen();
        }

        public void menuHiddenGoToEndMarker_Click( Object sender, EventArgs e )
        {
            if ( AppManager.isPlaying() ) {
                return;
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq.config.EndMarkerEnabled ) {
                AppManager.setCurrentClock( vsq.config.EndMarker );
                ensureCursorVisible();
                refreshScreen();
            }
        }

        public void menuHiddenGoToStartMarker_Click( Object sender, EventArgs e )
        {
            if ( AppManager.isPlaying() ) {
                return;
            }

            VsqFileEx vsq = AppManager.getVsqFile();
            if ( vsq.config.StartMarkerEnabled ) {
                AppManager.setCurrentClock( vsq.config.StartMarker );
                ensureCursorVisible();
                refreshScreen();
            }
        }

        public void menuHiddenLengthen_Click( Object sender, EventArgs e )
        {
            QuantizeMode qmode = AppManager.editorConfig.getLengthQuantize();
            boolean triplet = AppManager.editorConfig.isLengthQuantizeTriplet();
            int delta = QuantizeModeUtil.getQuantizeClock( qmode, triplet );
            lengthenSelectedEvent( delta );
        }

        public void menuHiddenMoveDown_Click( Object sender, EventArgs e )
        {
            moveUpDownLeftRight( -1, 0 );
        }

        public void menuHiddenMoveUp_Click( Object sender, EventArgs e )
        {
            moveUpDownLeftRight( 1, 0 );
        }

        public void menuHiddenPlayFromStartMarker_Click( Object sender, EventArgs e )
        {
            if ( AppManager.isPlaying() ) {
                return;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            if ( !vsq.config.StartMarkerEnabled ) {
                return;
            }

            AppManager.setCurrentClock( vsq.config.StartMarker );
            AppManager.setPlaying( true, this );
        }

        void menuHiddenPrintPoToCSV_Click( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#menuHiddenPrintPoToCSV_Click" );
#endif

            Vector<String> keys = new Vector<String>();
            String[] langs = Messaging.getRegisteredLanguage();
            foreach ( String lang in langs ) {
                foreach ( String key in Messaging.getKeys( lang ) ) {
                    if ( !keys.contains( key ) ) {
                        keys.add( key );
                    }
                }
            }

            Collections.sort( keys );
            String dir = PortUtil.getApplicationStartupPath();
            String fname = fsys.combine( dir, "cadencii_trans.csv" );
#if DEBUG
            sout.println( "FormMain#menuHiddenPrintPoToCSV_Click; fname=" + fname );
#endif
            String old_lang = Messaging.getLanguage();
            BufferedWriter br = null;
            try {
                br = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( fname ), "UTF-8" ) );
                String line = "\"en\"";
                foreach ( String lang in langs ) {
                    line += ",\"" + lang + "\"";
                }
                br.write( line );
                br.newLine();
                foreach ( String key in keys ) {
                    line = "\"" + key + "\"";
                    foreach ( String lang in langs ) {
                        Messaging.setLanguage( lang );
                        line += ",\"" + Messaging.getMessage( key ) + "\"";
                    }
                    br.write( line );
                    br.newLine();
                }
            } catch ( Exception ex ) {
                serr.println( "FormMain#menuHiddenPrintPoToCSV_Click; ex=" + ex );
            } finally {
                if ( br != null ) {
                    try {
                        br.close();
                    } catch ( Exception ex2 ) {
                    }
                }
            }
            Messaging.setLanguage( old_lang );
        }

        public void menuHiddenMoveLeft_Click( Object sender, EventArgs e )
        {
            QuantizeMode mode = AppManager.editorConfig.getPositionQuantize();
            boolean triplet = AppManager.editorConfig.isPositionQuantizeTriplet();
            int delta = -QuantizeModeUtil.getQuantizeClock( mode, triplet );
#if DEBUG
            sout.println( "FormMain#menuHiddenMoveLeft_Click; delta=" + delta );
#endif
            moveUpDownLeftRight( 0, delta );
        }

        public void menuHiddenMoveRight_Click( Object sender, EventArgs e )
        {
            QuantizeMode mode = AppManager.editorConfig.getPositionQuantize();
            boolean triplet = AppManager.editorConfig.isPositionQuantizeTriplet();
            int delta = QuantizeModeUtil.getQuantizeClock( mode, triplet );
            moveUpDownLeftRight( 0, delta );
        }

        public void menuHiddenSelectBackward_Click( Object sender, EventArgs e )
        {
            selectBackward();
        }

        public void menuHiddenSelectForward_Click( Object sender, EventArgs e )
        {
            selectForward();
        }

        public void menuHiddenEditFlipToolPointerPencil_Click( Object sender, EventArgs e )
        {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.PENCIL );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        public void menuHiddenEditFlipToolPointerEraser_Click( Object sender, EventArgs e )
        {
            if ( AppManager.getSelectedTool() == EditTool.ARROW ) {
                AppManager.setSelectedTool( EditTool.ERASER );
            } else {
                AppManager.setSelectedTool( EditTool.ARROW );
            }
            refreshScreen();
        }

        public void menuHiddenEditLyric_Click( Object sender, EventArgs e )
        {
#if JAVA
            boolean input_enabled = AppManager.mInputTextBox.isVisible();
#else
            boolean input_enabled = AppManager.mInputTextBox.Enabled;
#endif
            if ( !input_enabled && AppManager.getSelectedEventCount() > 0 ) {
                VsqEvent original = AppManager.getLastSelectedEvent().original;
                int clock = original.Clock;
                int note = original.ID.Note;
                Point pos = new Point( AppManager.xCoordFromClocks( clock ), AppManager.yCoordFromNote( note ) );
                if ( !AppManager.editorConfig.KeepLyricInputMode ) {
                    mLastSymbolEditMode = false;
                }
                showInputTextBox( original.ID.LyricHandle.L0.Phrase,
                                  original.ID.LyricHandle.L0.getPhoneticSymbol(),
                                  pos, mLastSymbolEditMode );
                refreshScreen();
            } else if ( input_enabled ) {
                if ( AppManager.mInputTextBox.isPhoneticSymbolEditMode() ) {
                    flipInputTextBoxMode();
                }
            }
        }
        #endregion

        //BOOKMARK: cMenuTrackTab
        #region cMenuTrackTab
        public void cMenuTrackTabCopy_Click( Object sender, EventArgs e )
        {
            copyTrackCore();
        }

        public void cMenuTrackTabChangeName_Click( Object sender, EventArgs e )
        {
            changeTrackNameCore();
        }

        public void cMenuTrackTabDelete_Click( Object sender, EventArgs e )
        {
            deleteTrackCore();
        }

        public void cMenuTrackTabAdd_Click( Object sender, EventArgs e )
        {
            addTrackCore();
        }

        public void cMenuTrackTab_Opening( Object sender, BCancelEventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#cMenuTrackTab_Opening" );
#endif
            updateTrackMenuStatus();
        }

        public void updateTrackMenuStatus()
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            int tracks = vsq.Track.size();
            cMenuTrackTabDelete.setEnabled( tracks >= 3 );
            menuTrackDelete.setEnabled( tracks >= 3 );
            cMenuTrackTabAdd.setEnabled( tracks <= 16 );
            menuTrackAdd.setEnabled( tracks <= 16 );
            cMenuTrackTabCopy.setEnabled( tracks <= 16 );
            menuTrackCopy.setEnabled( tracks <= 16 );

            boolean on = vsq_track.isTrackOn();
            cMenuTrackTabTrackOn.setSelected( on );
            menuTrackOn.setSelected( on );

            if ( tracks > 2 ) {
                cMenuTrackTabOverlay.setEnabled( true );
                menuTrackOverlay.setEnabled( true );
                cMenuTrackTabOverlay.setSelected( AppManager.isOverlay() );
                menuTrackOverlay.setSelected( AppManager.isOverlay() );
            } else {
                cMenuTrackTabOverlay.setEnabled( false );
                menuTrackOverlay.setEnabled( false );
                cMenuTrackTabOverlay.setSelected( false );
                menuTrackOverlay.setSelected( false );
            }
            cMenuTrackTabRenderCurrent.setEnabled( !AppManager.isPlaying() );
            menuTrackRenderCurrent.setEnabled( !AppManager.isPlaying() );
            cMenuTrackTabRenderAll.setEnabled( !AppManager.isPlaying() );
            menuTrackRenderAll.setEnabled( !AppManager.isPlaying() );
            cMenuTrackTabRendererVOCALOID1.setSelected( false );
            menuTrackRendererVOCALOID1.setSelected( false );
            cMenuTrackTabRendererVOCALOID2.setSelected( false );
            menuTrackRendererVOCALOID2.setSelected( false );
            cMenuTrackTabRendererUtau.setSelected( false );
            menuTrackRendererUtau.setSelected( false );
            cMenuTrackTabRendererStraight.setSelected( false );
            menuTrackRendererVCNT.setSelected( false );
            cMenuTrackTabRendererAquesTone.setSelected( false );
            menuTrackRendererAquesTone.setSelected( false );

            RendererKind kind = VsqFileEx.getTrackRendererKind( vsq_track );
            if ( kind == RendererKind.VOCALOID1 ) {
                cMenuTrackTabRendererVOCALOID1.setSelected( true );
                menuTrackRendererVOCALOID1.setSelected( true );
            } else if ( kind == RendererKind.VOCALOID2 ) {
                cMenuTrackTabRendererVOCALOID2.setSelected( true );
                menuTrackRendererVOCALOID2.setSelected( true );
            } else if ( kind == RendererKind.UTAU ) {
                cMenuTrackTabRendererUtau.setSelected( true );
                menuTrackRendererUtau.setSelected( true );
            } else if ( kind == RendererKind.VCNT ) {
                cMenuTrackTabRendererStraight.setSelected( true );
                menuTrackRendererVCNT.setSelected( true );
            } else if ( kind == RendererKind.AQUES_TONE ) {
                cMenuTrackTabRendererAquesTone.setSelected( true );
                menuTrackRendererAquesTone.setSelected( true );
            }
        }

        public void cMenuTrackTabOverlay_Click( Object sender, EventArgs e )
        {
            AppManager.setOverlay( !AppManager.isOverlay() );
            refreshScreen();
        }

        public void cMenuTrackTabRenderCurrent_Click( Object sender, EventArgs e )
        {
            Vector<Integer> tracks = new Vector<Integer>();
            tracks.add( AppManager.getSelected() );
            AppManager.patchWorkToFreeze( this, tracks );
        }

        public void cMenuTrackTabRenderer_DropDownOpening( Object sender, EventArgs e )
        {
            updateRendererMenu();
        }
        #endregion

        #region cPotisionIndicator
        public void cMenuPositionIndicatorStartMarker_Click( Object sender, EventArgs e )
        {
            int clock = mPositionIndicatorPopupShownClock;
            VsqFileEx vsq = AppManager.getVsqFile();
            vsq.config.StartMarkerEnabled = true;
            vsq.config.StartMarker = clock;
            if ( vsq.config.EndMarker < clock ) {
                vsq.config.EndMarker = clock;
            }
            menuVisualStartMarker.setSelected( true );
            setEdited( true );
            picturePositionIndicator.repaint();
        }

        public void cMenuPositionIndicatorEndMarker_Click( Object sender, EventArgs e )
        {
            int clock = mPositionIndicatorPopupShownClock;
            VsqFileEx vsq = AppManager.getVsqFile();
            vsq.config.EndMarkerEnabled = true;
            vsq.config.EndMarker = clock;
            if ( vsq.config.StartMarker > clock ) {
                vsq.config.StartMarker = clock;
            }
            menuVisualEndMarker.setSelected( true );
            setEdited( true );
            picturePositionIndicator.repaint();
        }
        #endregion

        //BOOKMARK: cMenuTrackSelector
        #region cMenuTrackSelector
        public void cMenuTrackSelector_Opening( Object sender, BCancelEventArgs e )
        {
            updateCopyAndPasteButtonStatus();

            // 選択ツールの状態に合わせて表示を更新
            cMenuTrackSelectorPointer.setSelected( false );
            cMenuTrackSelectorPencil.setSelected( false );
            cMenuTrackSelectorLine.setSelected( false );
            cMenuTrackSelectorEraser.setSelected( false );
            EditTool tool = AppManager.getSelectedTool();
            if ( tool == EditTool.ARROW ) {
                cMenuTrackSelectorPointer.setSelected( true );
            } else if ( tool == EditTool.PENCIL ) {
                cMenuTrackSelectorPencil.setSelected( true );
            } else if ( tool == EditTool.LINE ) {
                cMenuTrackSelectorLine.setSelected( true );
            } else if ( tool == EditTool.ERASER ) {
                cMenuTrackSelectorEraser.setSelected( true );
            }
            cMenuTrackSelectorCurve.setSelected( AppManager.isCurveMode() );
        }

        public void cMenuTrackSelectorPointer_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ARROW );
            refreshScreen();
        }

        public void cMenuTrackSelectorPencil_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.PENCIL );
            refreshScreen();
        }

        public void cMenuTrackSelectorLine_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        public void cMenuTrackSelectorEraser_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void cMenuTrackSelectorCurve_Click( Object sender, EventArgs e )
        {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        public void cMenuTrackSelectorSelectAll_Click( Object sender, EventArgs e )
        {
            selectAllEvent();
        }

        public void cMenuTrackSelectorCut_Click( Object sender, EventArgs e )
        {
            cutEvent();
        }

        public void cMenuTrackSelectorCopy_Click( Object sender, EventArgs e )
        {
            copyEvent();
        }

        public void cMenuTrackSelectorDelete_Click( Object sender, EventArgs e )
        {
            deleteEvent();
        }

        public void cMenuTrackSelectorDeleteBezier_Click( Object sender, EventArgs e )
        {
            for ( Iterator<SelectedBezierPoint> itr = AppManager.getSelectedBezierIterator(); itr.hasNext(); ) {
                SelectedBezierPoint sbp = itr.next();
                int chain_id = sbp.chainID;
                int point_id = sbp.pointID;
                VsqFileEx vsq = AppManager.getVsqFile();
                int selected = AppManager.getSelected();
                BezierChain chain = (BezierChain)vsq.AttachedCurves.get( selected - 1 ).getBezierChain( trackSelector.getSelectedCurve(), chain_id ).clone();
                int index = -1;
                for ( int i = 0; i < chain.points.size(); i++ ) {
                    if ( chain.points.get( i ).getID() == point_id ) {
                        index = i;
                        break;
                    }
                }
                if ( index >= 0 ) {
                    chain.points.removeElementAt( index );
                    if ( chain.points.size() == 0 ) {
                        CadenciiCommand run = VsqFileEx.generateCommandDeleteBezierChain( selected,
                                                                                          trackSelector.getSelectedCurve(),
                                                                                          chain_id,
                                                                                          AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( vsq.executeCommand( run ) );
                    } else {
                        CadenciiCommand run = VsqFileEx.generateCommandReplaceBezierChain( selected,
                                                                                           trackSelector.getSelectedCurve(),
                                                                                           chain_id,
                                                                                           chain,
                                                                                           AppManager.editorConfig.getControlCurveResolutionValue() );
                        AppManager.register( vsq.executeCommand( run ) );
                    }
                    setEdited( true );
                    refreshScreen();
                    break;
                }
            }
        }

        public void cMenuTrackSelectorPaste_Click( Object sender, EventArgs e )
        {
            pasteEvent();
        }

        public void cMenuTrackSelectorUndo_Click( Object sender, EventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorUndo_Click" );
#endif
            undo();
            refreshScreen();
        }

        public void cMenuTrackSelectorRedo_Click( Object sender, EventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "cMenuTrackSelectorRedo_Click" );
#endif
            redo();
            refreshScreen();
        }
        #endregion

        //BOOKMARK: panel2
        #region panel2
        public void panel2_MouseDown( Object sender, BMouseEventArgs e )
        {
            Point p = new Point( e.X, e.Y );

            int width = AppManager.keyWidth - 1;
            int height = panel2.getHeight();

            // AutoMaximizeボタン
            Rectangle rc = new Rectangle( SPACE, SPACE, width - SPACE - SPACE, 16 );
            if ( Utility.isInRect( p, rc ) ) {
                mWaveViewButtonAutoMaximizeMouseDowned = true;
                mWaveViewButtonZoomMouseDowned = false;

                panel2.repaint();
                return;
            }

            if ( !mWaveViewAutoMaximize ) {
                // Zoomボタン
                rc = getButtonBoundsWaveViewZoom();
                if ( Utility.isInRect( p, rc ) ) {
                    mWaveViewMouseDownedLocationY = p.y;
                    mWaveViewButtonZoomMouseDowned = true;
                    mWaveViewButtonAutoMaximizeMouseDowned = false;
                    mWaveViewInitScale = waveView.getScale();

                    panel2.repaint();
                    return;
                }
            }

            mWaveViewButtonAutoMaximizeMouseDowned = false;
            mWaveViewButtonZoomMouseDowned = false;
            panel2.repaint();
            return;
        }

        public void panel2_MouseMove( Object sender, BMouseEventArgs e )
        {
            if ( !mWaveViewButtonZoomMouseDowned ) {
                return;
            }

            int height = panel2.getHeight();
            int delta = mWaveViewMouseDownedLocationY - e.Y;
            float scale = mWaveViewInitScale + delta * 3.0f / height * mWaveViewInitScale;
            waveView.setScale( scale );

            refreshScreen();
        }

        public void panel2_MouseUp( Object sender, BMouseEventArgs e )
        {
            int width = AppManager.keyWidth - 1;
            int height = panel2.getHeight();

            // AutoMaximizeボタン
            if ( Utility.isInRect( e.X, e.Y, SPACE, SPACE, width - SPACE - SPACE, 16 ) ) {
                if ( mWaveViewButtonAutoMaximizeMouseDowned ) {
                    mWaveViewAutoMaximize = !mWaveViewAutoMaximize;
                    waveView.setAutoMaximize( mWaveViewAutoMaximize );
                }
            }

            mWaveViewButtonAutoMaximizeMouseDowned = false;
            mWaveViewButtonZoomMouseDowned = false;
#if JAVA
            refreshScreen();
#else
            panel2.repaint();
#endif
        }

        public void panel2_Paint( Object sender, BPaintEventArgs e )
        {
#if JAVA
            Graphics g = e.Graphics;
#else
            if ( mGraphicsPanel2 == null ) {
                mGraphicsPanel2 = new Graphics2D( null );
            }
            mGraphicsPanel2.nativeGraphics = e.Graphics;
            Graphics g = mGraphicsPanel2;
#endif
            int key_width = AppManager.keyWidth;
            int width = key_width - 1;
            int height = panel2.getHeight() - 1;

            // 背景を塗る
            g.setColor( PortUtil.DarkGray );
            g.fillRect( 0, 0, width, height );

            // AutoMaximizeのチェックボックスを描く
            g.setColor( mWaveViewButtonAutoMaximizeMouseDowned ? PortUtil.Gray : PortUtil.LightGray );
            g.fillRect( SPACE, SPACE, 16, 16 );
            g.setColor( PortUtil.Gray );
            g.drawRect( SPACE, SPACE, 16, 16 );
            if ( mWaveViewAutoMaximize ) {
                g.setColor( PortUtil.Gray );
                g.fillRect( SPACE + 3, SPACE + 3, 11, 11 );
            }
            g.setColor( Color.black );
            g.setFont( AppManager.baseFont8 );
            g.drawString(
                "Auto Maximize",
                SPACE + 16 + SPACE,
                SPACE + AppManager.baseFont8Height / 2 - AppManager.baseFont8OffsetHeight + 1 );

            // ズーム用ボタンを描く
            int zoom_button_y = SPACE + 16 + SPACE;
            int zoom_button_height = height - SPACE - zoom_button_y;
            Rectangle rc = getButtonBoundsWaveViewZoom();
            if ( !mWaveViewAutoMaximize ) {
                g.setColor( mWaveViewButtonZoomMouseDowned ? PortUtil.Gray : PortUtil.LightGray );
                g.fillRect( rc.x, rc.y, rc.width, rc.height );
            }
            g.setColor( PortUtil.Gray );
            g.drawRect( rc.x, rc.y, rc.width, rc.height );
            g.setColor( mWaveViewAutoMaximize ? PortUtil.Gray : Color.black );
            rc.y = rc.y + 1;
            PortUtil.drawStringEx(
                g, (mWaveViewButtonZoomMouseDowned ? "↑Move Mouse↓" : "Zoom"), AppManager.baseFont9,
                rc, PortUtil.STRING_ALIGN_CENTER, PortUtil.STRING_ALIGN_CENTER );
        }
        #endregion

        #region buttonVZoom & buttonVMooz
        public void buttonVZoom_Click( Object sender, BEventArgs e )
        {
            zoomY( 1 );
        }

        public void buttonVMooz_Click( Object sender, BEventArgs e )
        {
            zoomY( -1 );
        }
        #endregion

        #region pictureBox2
#if !JAVA
        public void pictureBox2_Paint( Object sender, BPaintEventArgs e )
        {
            if ( mGraphicsPictureBox2 == null ) {
                mGraphicsPictureBox2 = new Graphics2D( null );
            }
            mGraphicsPictureBox2.nativeGraphics = e.Graphics;
            int width = pictureBox2.getWidth();
            int height = pictureBox2.getHeight();
            int unit_height = height / 4;
            mGraphicsPictureBox2.setColor( mColorR214G214B214 );
            mGraphicsPictureBox2.fillRect( 0, 0, width, height );
            if ( mPianoRollScaleYMouseStatus > 0 ) {
                mGraphicsPictureBox2.setColor( Color.gray );
                mGraphicsPictureBox2.fillRect( 0, 0, width, unit_height );
            } else if ( mPianoRollScaleYMouseStatus < 0 ) {
                mGraphicsPictureBox2.setColor( Color.gray );
                mGraphicsPictureBox2.fillRect( 0, unit_height * 2, width, unit_height );
            }
            mGraphicsPictureBox2.setStroke( getStrokeDefault() );
            mGraphicsPictureBox2.setColor( Color.gray );
            //mGraphicsPictureBox2.drawRect( 0, 0, width - 1, unit_height * 2 );
            mGraphicsPictureBox2.drawLine( 0, unit_height, width, unit_height );
            mGraphicsPictureBox2.drawLine( 0, unit_height * 2, width, unit_height * 2 );
            mGraphicsPictureBox2.setStroke( getStroke2px() );
            int cx = width / 2;
            int cy = unit_height / 2;
            mGraphicsPictureBox2.setColor( (mPianoRollScaleYMouseStatus > 0) ? Color.lightGray : Color.gray );
            mGraphicsPictureBox2.drawLine( cx - 4, cy, cx + 4, cy );
            mGraphicsPictureBox2.drawLine( cx, cy - 4, cx, cy + 4 );
            cy += unit_height * 2;
            mGraphicsPictureBox2.setColor( (mPianoRollScaleYMouseStatus < 0) ? Color.lightGray : Color.gray );
            mGraphicsPictureBox2.drawLine( cx - 4, cy, cx + 4, cy );
        }
#endif

#if !JAVA
        public void pictureBox2_MouseDown( Object sender, BMouseEventArgs e )
        {
            // 拡大・縮小ボタンが押されたかどうか判定
            int height = pictureBox2.getHeight();
            int width = pictureBox2.getWidth();
            int height4 = height / 4;
            if ( 0 <= e.X && e.X < width ) {
                int scaley = AppManager.editorConfig.PianoRollScaleY;
                if ( 0 <= e.Y && e.Y < height4 ) {
                    if ( scaley + 1 <= EditorConfig.MAX_PIANOROLL_SCALEY ) {
                        zoomY( 1 );
                        mPianoRollScaleYMouseStatus = 1;
                    } else {
                        mPianoRollScaleYMouseStatus = 0;
                    }
                } else if ( height4 * 2 <= e.Y && e.Y < height4 * 3 ) {
                    if ( scaley - 1 >= EditorConfig.MIN_PIANOROLL_SCALEY ) {
                        zoomY( -1 );
                        mPianoRollScaleYMouseStatus = -1;
                    } else {
                        mPianoRollScaleYMouseStatus = 0;
                    }
                } else {
                    mPianoRollScaleYMouseStatus = 0;
                }
            } else {
                mPianoRollScaleYMouseStatus = 0;
            }
            refreshScreen();
        }
#endif

#if !JAVA
        public void pictureBox2_MouseUp( Object sender, BMouseEventArgs e )
        {
            mPianoRollScaleYMouseStatus = 0;
            pictureBox2.invalidate();
        }
#endif
        #endregion

        //BOOKMARK: stripBtn
        #region stripBtn*
        public void stripBtnGrid_Click( Object sender, EventArgs e )
        {
            boolean new_v = !AppManager.isGridVisible();
#if JAVA
            stripBtnGrid.setSelected( new_v );
#else
            stripBtnGrid.Pushed = new_v;
#endif
            AppManager.setGridVisible( new_v );
        }

        public void stripBtnArrow_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ARROW );
        }

        public void stripBtnPencil_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.PENCIL );
        }

        public void stripBtnLine_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.LINE );
        }

        public void stripBtnEraser_Click( Object sender, EventArgs e )
        {
            AppManager.setSelectedTool( EditTool.ERASER );
        }

        public void stripBtnCurve_Click( Object sender, EventArgs e )
        {
            AppManager.setCurveMode( !AppManager.isCurveMode() );
        }

        public void stripBtnPlay_Click( Object sender, EventArgs e )
        {
            AppManager.setPlaying( !AppManager.isPlaying(), this );
            pictPianoRoll.requestFocus();
        }

        public void stripBtnScroll_CheckedChanged( Object sender, EventArgs e )
        {
#if JAVA
            boolean pushed = stripBtnScroll.isSelected();
#else
            bool pushed = stripBtnScroll.Pushed;
#endif
            AppManager.mAutoScroll = pushed;
#if DEBUG
            sout.println( "FormMain#stripBtnScroll_CheckedChanged; pushed=" + pushed );
#endif
            pictPianoRoll.requestFocus();
        }

        public void stripBtnLoop_CheckedChanged( Object sender, EventArgs e )
        {
#if JAVA
            boolean pushed = stripBtnLoop.isSelected();
#else
            boolean pushed = stripBtnLoop.Pushed;
#endif
            AppManager.setRepeatMode( pushed );
            pictPianoRoll.requestFocus();
        }

        public void stripBtnStepSequencer_CheckedChanged( Object sender, EventArgs e )
        {
            // AppManager.mAddingEventがnullかどうかで処理が変わるのでnullにする
            AppManager.mAddingEvent = null;
            // モードを切り替える
#if JAVA
            mStepSequencerEnabled = stripBtnStepSequencer.isSelected();
#else
            mStepSequencerEnabled = stripBtnStepSequencer.Checked;
#endif

            // MIDIの受信を開始
#if ENABLE_MIDI
            if ( mStepSequencerEnabled ) {
                mMidiIn.start();
            } else {
                mMidiIn.stop();
            }
#endif
        }

        public void stripBtnStop_Click( Object sender, EventArgs e )
        {
            AppManager.setPlaying( false, this );
            timer.stop();
            pictPianoRoll.requestFocus();
        }

        public void stripBtnMoveEnd_Click( Object sender, EventArgs e )
        {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false, this );
            }
            AppManager.setCurrentClock( AppManager.getVsqFile().TotalClocks );
            ensureCursorVisible();
            refreshScreen();
        }

        public void stripBtnMoveTop_Click( Object sender, EventArgs e )
        {
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false, this );
            }
            AppManager.setCurrentClock( 0 );
            ensureCursorVisible();
            refreshScreen();
        }

        public void stripBtnRewind_Click( Object sender, EventArgs e )
        {
            rewind();
        }

        public void stripBtnForward_Click( Object sender, EventArgs e )
        {
            forward();
        }
        #endregion

        //BOOKMARK: pictKeyLengthSplitter
        #region pictKeyLengthSplitter
        public void pictKeyLengthSplitter_MouseDown( Object sender, BMouseEventArgs e )
        {
            mKeyLengthSplitterMouseDowned = true;
            mKeyLengthSplitterInitialMouse = PortUtil.getMousePosition();
            mKeyLengthInitValue = AppManager.keyWidth;
            mKeyLengthTrackSelectorRowsPerColumn = trackSelector.getRowsPerColumn();
            mKeyLengthSplitterDistance = splitContainer1.getDividerLocation();
        }

        public void pictKeyLengthSplitter_MouseMove( Object sender, BMouseEventArgs e )
        {
            if ( !mKeyLengthSplitterMouseDowned ) {
                return;
            }
            int dx = PortUtil.getMousePosition().x - mKeyLengthSplitterInitialMouse.x;
            int draft = mKeyLengthInitValue + dx;
            if ( draft < AppManager.MIN_KEY_WIDTH ) {
                draft = AppManager.MIN_KEY_WIDTH;
            } else if ( AppManager.MAX_KEY_WIDTH < draft ) {
                draft = AppManager.MAX_KEY_WIDTH;
            }
            AppManager.keyWidth = draft;
            int current = trackSelector.getRowsPerColumn();
            if ( current >= mKeyLengthTrackSelectorRowsPerColumn ) {
                int max_divider_location = splitContainer1.getHeight() - splitContainer1.getDividerSize() - splitContainer1.getPanel2MinSize();
                if ( max_divider_location < mKeyLengthSplitterDistance ) {
                    splitContainer1.setDividerLocation( max_divider_location );
                } else {
                    splitContainer1.setDividerLocation( mKeyLengthSplitterDistance );
                }
            }
            updateLayout();
            refreshScreen();
        }

        public void pictKeyLengthSplitter_MouseUp( Object sender, BMouseEventArgs e )
        {
            mKeyLengthSplitterMouseDowned = false;
        }
        #endregion

        #region toolBarMeasure
#if !JAVA
        void toolBarMeasure_MouseDown( Object sender, System.Windows.Forms.MouseEventArgs e )
        {
            // マウス位置にあるボタンを捜す
            System.Windows.Forms.ToolBarButton c = null;
            foreach ( System.Windows.Forms.ToolBarButton btn in toolBarMeasure.Buttons ) {
                System.Drawing.Rectangle rc = btn.Rectangle;
                if ( Utility.isInRect( e.X, e.Y, rc.Left, rc.Top, rc.Width, rc.Height ) ) {
                    c = btn;
                    break;
                }
            }
            if ( c == null ) {
                return;
            }

            if ( c == stripDDBtnQuantizeParent ) {
                System.Drawing.Rectangle rc = stripDDBtnQuantizeParent.Rectangle;
                stripDDBtnQuantize.Show(
                    toolBarMeasure,
                    new System.Drawing.Point( rc.Left, rc.Bottom ) );
            }
        }
#endif

#if !JAVA
        void toolBarMeasure_ButtonClick( Object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e )
        {
            if ( e.Button == stripBtnStartMarker ) {
                handleStartMarker_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnEndMarker ) {
                handleEndMarker_Click( e.Button, new EventArgs() );
            }/* else if ( e.Button == stripDDBtnLengthParent ) {
                System.Drawing.Rectangle rc = stripDDBtnLengthParent.Rectangle;
                stripDDBtnLength.Show(
                    toolBarMeasure,
                    new System.Drawing.Point( rc.Left, rc.Bottom ) );
            } else if ( e.Button == stripDDBtnQuantizeParent ) {
                System.Drawing.Rectangle rc = stripDDBtnQuantizeParent.Rectangle;
                stripDDBtnQuantize.Show(
                    toolBarMeasure,
                    new System.Drawing.Point( rc.Left, rc.Bottom ) );
            }*/
        }
#endif
        #endregion

#if !JAVA
        void toolBarTool_ButtonClick( Object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e )
        {
            if ( e.Button == stripBtnPointer ) {
                stripBtnArrow_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnPencil ) {
                stripBtnPencil_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnLine ) {
                stripBtnLine_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnEraser ) {
                stripBtnEraser_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnGrid ) {
                stripBtnGrid_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnCurve ) {
                stripBtnCurve_Click( e.Button, new EventArgs() );
            } else {
                handleStripPaletteTool_Click( e.Button, new EventArgs() );
            }
        }
#endif

#if !JAVA
        void toolBarPosition_ButtonClick( Object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e )
        {
            if ( e.Button == stripBtnMoveTop ) {
                stripBtnMoveTop_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnRewind ) {
                stripBtnRewind_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnForward ) {
                stripBtnForward_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnMoveEnd ) {
                stripBtnMoveEnd_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnPlay ) {
                stripBtnPlay_Click( e.Button, new EventArgs() );
                //} else if ( e.Button == stripBtnStop ) {
                //stripBtnStop_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnScroll ) {
                stripBtnScroll.Pushed = !stripBtnScroll.Pushed;
                stripBtnScroll_CheckedChanged( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnLoop ) {
                stripBtnLoop.Pushed = !stripBtnLoop.Pushed;
                stripBtnLoop_CheckedChanged( e.Button, new EventArgs() );
            }
        }
#endif

#if !JAVA
        void toolBarFile_ButtonClick( Object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e )
        {
            if ( e.Button == stripBtnFileNew ) {
                handleFileNew_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnFileOpen ) {
                handleFileOpen_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnFileSave ) {
                handleFileSave_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnCut ) {
                handleEditCut_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnCopy ) {
                handleEditCopy_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnPaste ) {
                handleEditPaste_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnUndo ) {
                handleEditUndo_Click( e.Button, new EventArgs() );
            } else if ( e.Button == stripBtnRedo ) {
                handleEditRedo_Click( e.Button, new EventArgs() );
            }
        }
#endif

        public void handleVibratoPresetSubelementClick( Object sender, EventArgs e )
        {
            if ( sender == null ) {
                return;
            }
#if JAVA
            if ( !(sender instanceof BMenuItem) ) {
#else
            if ( !(sender is System.Windows.Forms.ToolStripMenuItem) ) {
#endif
                return;
            }

            // イベントの送信元を特定
#if JAVA
            BMenuItem item = (BMenuItem)sender;
            String text = item.getText();
#else
            System.Windows.Forms.ToolStripMenuItem item = (System.Windows.Forms.ToolStripMenuItem)sender;
            String text = item.Text;
#endif

            // メニューの表示文字列から，どの設定値についてのイベントかを探す
            VibratoHandle target = null;
            int size = AppManager.editorConfig.AutoVibratoCustom.size();
            for ( int i = 0; i < size; i++ ) {
                VibratoHandle handle = AppManager.editorConfig.AutoVibratoCustom.get( i );
                if ( text.Equals( handle.getCaption() ) ) {
                    target = handle;
                    break;
                }
            }

            // ターゲットが特定できなかったらbailout
            if ( target == null ) {
                return;
            }

            // 選択状態のアイテムを取得
            Iterator<SelectedEventEntry> itr = AppManager.getSelectedEventIterator();
            if ( !itr.hasNext() ) {
                // アイテムがないのでbailout
                return;
            }
            VsqEvent ev = itr.next().original;
            if ( ev.ID.VibratoHandle == null ) {
                return;
            }

            // 設定値にコピー
            VibratoHandle h = ev.ID.VibratoHandle;
            target.setStartRate( h.getStartRate() );
            target.setStartDepth( h.getStartDepth() );
            if ( h.getRateBP() == null ) {
                target.setRateBP( null );
            } else {
                target.setRateBP( (VibratoBPList)h.getRateBP().clone() );
            }
            if ( h.getDepthBP() == null ) {
                target.setDepthBP( null );
            } else {
                target.setDepthBP( (VibratoBPList)h.getDepthBP().clone() );
            }
        }

        public void timer_Tick( Object sender, EventArgs e )
        {
            if ( AppManager.isGeneratorRunning() ) {
#if JAVA
                // !JAVAのときもこれで行けなイカ？
                double play_time = PlaySound.getPosition();
#else
                MonitorWaveReceiver monitor = MonitorWaveReceiver.getInstance();
                double play_time = 0.0;
                if ( monitor != null ) {
                    play_time = monitor.getPlayTime();
                }
#endif
                double now = play_time + AppManager.mDirectPlayShift;
                int clock = (int)AppManager.getVsqFile().getClockFromSec( now );
                if ( mLastClock <= clock ) {
                    mLastClock = clock;
                    AppManager.setCurrentClock( clock );
                    if ( AppManager.mAutoScroll ) {
                        ensureCursorVisible();
                    }
                }
            } else {
                AppManager.setPlaying( false, this );
                int ending_clock = AppManager.getPreviewEndingClock();
                AppManager.setCurrentClock( ending_clock );
                if ( AppManager.mAutoScroll ) {
                    ensureCursorVisible();
                }
                refreshScreen( true );
                if ( AppManager.isRepeatMode() ) {
                    int dest_clock = 0;
                    VsqFileEx vsq = AppManager.getVsqFile();
                    if ( vsq.config.StartMarkerEnabled ) {
                        dest_clock = vsq.config.StartMarker;
                    }
                    AppManager.setCurrentClock( dest_clock );
                    AppManager.setPlaying( true, this );
                }
            }
            refreshScreen();
        }

        public void bgWorkScreen_DoWork( Object sender, BDoWorkEventArgs e )
        {
            try {
#if JAVA
                refreshScreenCore( this, new EventArgs() );
#else
                this.Invoke( new BEventHandler( this.refreshScreenCore ) );
#endif
            } catch ( Exception ex ) {
                serr.println( "FormMain#bgWorkScreen_DoWork; ex=" + ex );
                Logger.write( typeof( FormMain ) + ".bgWorkScreen_DoWork; ex=" + ex + "\n" );
            }
        }

#if !JAVA
        public void toolStripEdit_Resize( Object sender, EventArgs e )
        {
            saveToolbarLocation();
        }

        public void toolStripPosition_Resize( Object sender, EventArgs e )
        {
            saveToolbarLocation();
        }

        public void toolStripMeasure_Resize( Object sender, EventArgs e )
        {
            saveToolbarLocation();
        }

        void toolStripFile_Resize( Object sender, EventArgs e )
        {
            saveToolbarLocation();
        }
#endif

        public void toolStripContainer_TopToolStripPanel_SizeChanged( Object sender, EventArgs e )
        {
            if ( getExtendedState() == BForm.ICONIFIED ) {
                return;
            }
            Dimension minsize = getWindowMinimumSize();
            int wid = getWidth();
            int hei = getHeight();
            boolean change_size_required = false;
            if ( minsize.width > wid ) {
                wid = minsize.width;
                change_size_required = true;
            }
            if ( minsize.height > hei ) {
                hei = minsize.height;
                change_size_required = true;
            }
            setMinimumSize( getWindowMinimumSize() );
            if ( change_size_required ) {
                setSize( wid, hei );
            }
        }

        public void handleRecentFileMenuItem_Click( Object sender, EventArgs e )
        {
            if ( sender is RecentFileMenuItem ) {
                RecentFileMenuItem item = (RecentFileMenuItem)sender;
                String filename = item.getFilePath();
                if( !dirtyCheck() ){
                    return;
                }
                openVsqCor( filename );
                clearExistingData();
                AppManager.mMixerWindow.updateStatus();
                clearTempWave();
                updateDrawObjectList();
                refreshScreen();
            }
        }

        public void handleRecentFileMenuItem_MouseEnter( Object sender, EventArgs e )
        {
            if ( sender is RecentFileMenuItem ) {
                RecentFileMenuItem item = (RecentFileMenuItem)sender;
#if JAVA
                statusLabel.setText( item.getToolTipText() );
#else
                statusLabel.Text = item.ToolTipText;
#endif
            }
        }

        public void handleStripPaletteTool_Click( Object sender, EventArgs e )
        {
            String id = "";  //選択されたツールのID
#if ENABLE_SCRIPT
            if ( sender is System.Windows.Forms.ToolBarButton ) {
                System.Windows.Forms.ToolBarButton tsb = (System.Windows.Forms.ToolBarButton)sender;
                if ( tsb.Tag != null && tsb.Tag is String ) {
                    id = (String)tsb.Tag;
                    AppManager.mSelectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsb.Pushed = true;
                }
            } else if ( sender is BMenuItem ) {
                BMenuItem tsmi = (BMenuItem)sender;
                if ( tsmi.getTag() != null && tsmi.getTag() is String ) {
                    id = (String)tsmi.getTag();
                    AppManager.mSelectedPaletteTool = id;
                    AppManager.setSelectedTool( EditTool.PALETTE_TOOL );
                    tsmi.setSelected( true );
                }
            }
#endif

#if JAVA
            int count = toolStripTool.getComponentCount();
#else
            int count = toolBarTool.Buttons.Count;
#endif
            for ( int i = 0; i < count; i++ ) {
#if JAVA
                Object item = toolStripTool.getComponentAtIndex( i );
#else
                Object item = toolBarTool.Buttons[i];
#endif
#if JAVA
                if( item instanceof PaletteToolButton ){
                    PaletteToolButton button = (PaletteToolButton)item;
                    String tag = button.getPaletteToolID();
                    if( tag != null ){
                        button.setSelected( str.compare( id, tag ) );
                    }else{
                        button.setSelected( false );
                    }
                }
#else
                if ( item is System.Windows.Forms.ToolBarButton ) {
                    System.Windows.Forms.ToolBarButton button = (System.Windows.Forms.ToolBarButton)item;
                    if ( button.Style == System.Windows.Forms.ToolBarButtonStyle.ToggleButton && button.Tag != null && button.Tag is String ) {
                        if ( ((String)button.Tag).Equals( id ) ) {
                            button.Pushed = true;
                        } else {
                            button.Pushed = false;
                        }
                    }
                }
#endif
            }

            MenuElement[] sub_cmenu_piano_palette_tool = cMenuPianoPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_piano_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_piano_palette_tool[i];
                if ( item is PaletteToolMenuItem ) {
                    PaletteToolMenuItem menu = (PaletteToolMenuItem)item;
                    String tagged_id = menu.getPaletteToolID();
                    menu.setSelected( str.compare( id, tagged_id ) );
                }
            }

            MenuElement[] sub_cmenu_track_selectro_palette_tool = cMenuTrackSelectorPaletteTool.getSubElements();
            for ( int i = 0; i < sub_cmenu_track_selectro_palette_tool.Length; i++ ) {
                MenuElement item = sub_cmenu_track_selectro_palette_tool[i];
                if ( item is PaletteToolMenuItem ) {
                    PaletteToolMenuItem menu = (PaletteToolMenuItem)item;
                    String tagged_id = menu.getPaletteToolID();
                    menu.setSelected( str.compare( id, tagged_id ) );
                }
            }
        }

        public void handleTrackOn_Click( Object sender, EventArgs e )
        {
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = AppManager.getVsqFile().Track.get( selected );
            boolean old_status = vsq_track.isTrackOn();
            boolean new_status = !old_status;
            int last_play_mode = vsq_track.getCommon().LastPlayMode;
            CadenciiCommand run = new CadenciiCommand(
                VsqCommand.generateCommandTrackChangePlayMode(
                    selected,
                    new_status ? last_play_mode : PlayMode.Off,
                    last_play_mode ) );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            menuTrackOn.setSelected( new_status );
            cMenuTrackTabTrackOn.setSelected( new_status );
            setEdited( true );
            refreshScreen();
        }

        public void handleTrackRenderAll_Click( Object sender, EventArgs e )
        {
            Vector<Integer> list = new Vector<Integer>();
            int c = AppManager.getVsqFile().Track.size();
            for ( int i = 1; i < c; i++ ) {
                if ( AppManager.getRenderRequired( i ) ) {
                    list.add( i );
                }
            }
            if ( list.size() <= 0 ) {
                return;
            }
            AppManager.patchWorkToFreeze( this, list );
        }

        public void handleEditorConfig_QuantizeModeChanged( Object sender, EventArgs e )
        {
            applyQuantizeMode();
        }

        public void handleFileSave_Click( Object sender, EventArgs e )
        {
            for ( int track = 1; track < AppManager.getVsqFile().Track.size(); track++ ) {
                if ( AppManager.getVsqFile().Track.get( track ).getEventCount() == 0 ) {
                    AppManager.showMessageBox(
                        PortUtil.formatMessage(
                            _( "Invalid note data.\nTrack {0} : {1}\n\n-> Piano roll : Blank sequence." ),
                            track,
                            AppManager.getVsqFile().Track.get( track ).getName() ),
                        _APP_NAME,
                        org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                        org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                    return;
                }
            }
            String file = AppManager.getFileName();
            if ( file.Equals( "" ) ) {
                String last_file = AppManager.editorConfig.getLastUsedPathOut( "xvsq" );
                if ( !last_file.Equals( "" ) ) {
                    String dir = PortUtil.getDirectoryName( last_file );
                    saveXmlVsqDialog.setSelectedFile( dir );
                }
                int dr = AppManager.showModalDialog( saveXmlVsqDialog, false, this );
                if ( dr == BFileChooser.APPROVE_OPTION ) {
                    file = saveXmlVsqDialog.getSelectedFile();
                    AppManager.editorConfig.setLastUsedPathOut( file, ".xvsq" );
                }
            }
            if ( file != "" ) {
                AppManager.saveTo( file );
                updateRecentFileMenu();
                setEdited( false );
            }
        }

        public void handleFileOpen_Click( Object sender, EventArgs e )
        {
            if ( !dirtyCheck() ) {
                return;
            }
            String dir = AppManager.editorConfig.getLastUsedPathIn( "xvsq" );
            openXmlVsqDialog.setSelectedFile( dir );
            int dialog_result = AppManager.showModalDialog( openXmlVsqDialog, true, this );
            if ( dialog_result != BFileChooser.APPROVE_OPTION ) {
                return;
            }
            if ( AppManager.isPlaying() ) {
                AppManager.setPlaying( false, this );
            }
            String file = openXmlVsqDialog.getSelectedFile();
            AppManager.editorConfig.setLastUsedPathIn( file, ".xvsq" );
            if( openVsqCor( file ) ){
                AppManager.showMessageBox(
                    _( "Invalid XVSQ file" ),
                    _( "Error" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }
            clearExistingData();

            setEdited( false );
            AppManager.mMixerWindow.updateStatus();
            clearTempWave();
            updateDrawObjectList();
            refreshScreen();
        }

        public void handleStripButton_Enter( Object sender, EventArgs e )
        {
            pictPianoRoll.requestFocus();
        }

        public void handleFileNew_Click( Object sender, EventArgs e )
        {
            if ( !dirtyCheck() ) {
                return;
            }
            AppManager.setSelected( 1 );
            VsqFileEx vsq = new VsqFileEx( AppManager.editorConfig.DefaultSingerName, 1, 4, 4, 500000 );

            RendererKind kind = AppManager.editorConfig.DefaultSynthesizer;
            String renderer = AppManager.getVersionStringFromRendererKind( kind );
            Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
            vsq.Track.get( 1 ).changeRenderer( renderer, singers );

            AppManager.setVsqFile( vsq );
            clearExistingData();
            for ( int i = 0; i < AppManager.mLastRenderedStatus.Length; i++ ){
                AppManager.mLastRenderedStatus[i] = null;
            }
            setEdited( false );
            AppManager.mMixerWindow.updateStatus();
            clearTempWave();

            // キャッシュディレクトリのパスを、デフォルトに戻す
            AppManager.setTempWaveDir( fsys.combine( AppManager.getCadenciiTempDir(), AppManager.getID() ) );

            updateDrawObjectList();
            refreshScreen();
        }

        public void handleEditPaste_Click( Object sender, EventArgs e )
        {
            pasteEvent();
        }

        public void handleEditCopy_Click( Object sender, EventArgs e )
        {
#if DEBUG
            AppManager.debugWriteLine( "handleEditCopy_Click" );
#endif
            copyEvent();
        }

        public void handleEditCut_Click( Object sender, EventArgs e )
        {
            cutEvent();
        }

        public void handlePositionQuantize( Object sender, EventArgs e )
        {
            QuantizeMode qm = AppManager.editorConfig.getPositionQuantize();
            if ( sender == cMenuPianoQuantize04 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize04 ||
#endif
 sender == menuSettingPositionQuantize04 ) {
                qm = QuantizeMode.p4;
            } else if ( sender == cMenuPianoQuantize08 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize08 ||
#endif
 sender == menuSettingPositionQuantize08 ) {
                qm = QuantizeMode.p8;
            } else if ( sender == cMenuPianoQuantize16 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize16 ||
#endif
 sender == menuSettingPositionQuantize16 ) {
                qm = QuantizeMode.p16;
            } else if ( sender == cMenuPianoQuantize32 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize32 ||
#endif
 sender == menuSettingPositionQuantize32 ) {
                qm = QuantizeMode.p32;
            } else if ( sender == cMenuPianoQuantize64 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize64 ||
#endif
 sender == menuSettingPositionQuantize64 ) {
                qm = QuantizeMode.p64;
            } else if ( sender == cMenuPianoQuantize128 ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantize128 ||
#endif
 sender == menuSettingPositionQuantize128 ) {
                qm = QuantizeMode.p128;
            } else if ( sender == cMenuPianoQuantizeOff ||
#if ENABLE_STRIP_DROPDOWN
 sender == stripDDBtnQuantizeOff ||
#endif
 sender == menuSettingPositionQuantizeOff ) {
                qm = QuantizeMode.off;
            }
            AppManager.editorConfig.setPositionQuantize( qm );
            AppManager.editorConfig.setLengthQuantize( qm );
            refreshScreen();
        }

        public void handlePositionQuantizeTriplet_Click( Object sender, EventArgs e )
        {
            boolean triplet = !AppManager.editorConfig.isPositionQuantizeTriplet();
            AppManager.editorConfig.setPositionQuantizeTriplet( triplet );
            AppManager.editorConfig.setLengthQuantizeTriplet( triplet );
            refreshScreen();
        }

        public void handleStartMarker_Click( Object sender, EventArgs e )
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            vsq.config.StartMarkerEnabled = !vsq.config.StartMarkerEnabled;
            menuVisualStartMarker.setSelected( vsq.config.StartMarkerEnabled );
            setEdited( true );
            pictPianoRoll.requestFocus();
            refreshScreen();
        }

        public void handleEndMarker_Click( Object sender, EventArgs e )
        {
            VsqFileEx vsq = AppManager.getVsqFile();
            vsq.config.EndMarkerEnabled = !vsq.config.EndMarkerEnabled;
#if !JAVA
            stripBtnEndMarker.Pushed = vsq.config.EndMarkerEnabled;
#endif
            menuVisualEndMarker.setSelected( vsq.config.EndMarkerEnabled );
            setEdited( true );
            pictPianoRoll.requestFocus();
            refreshScreen();
        }

        /// <summary>
        /// メニューの説明をステータスバーに表示するための共通のイベントハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void handleMenuMouseEnter( Object sender, EventArgs e )
        {
            if ( sender == null ) {
                return;
            }

            boolean notfound = false;
            String text = "";
            if ( sender == menuEditUndo ) {
                text = _( "Undo." );
            } else if ( sender == menuEditRedo ) {
                text = _( "Redo." );
            } else if ( sender == menuEditCut ) {
                text = _( "Cut selected items." );
            } else if ( sender == menuEditCopy ) {
                text = _( "Copy selected items." );
            } else if ( sender == menuEditPaste ) {
                text = _( "Paste copied items to current song position." );
            } else if ( sender == menuEditDelete ) {
                text = _( "Delete selected items." );
            } else if ( sender == menuEditAutoNormalizeMode ) {
                text = _( "Avoid automaticaly polyphonic editing." );
            } else if ( sender == menuEditSelectAll ) {
                text = _( "Select all items and control curves of current track." );
            } else if ( sender == menuEditSelectAllEvents ) {
                text = _( "Select all items of current track." );
            } else if ( sender == menuVisualControlTrack ) {
                text = _( "Show/Hide control curves." );
            } else if ( sender == menuVisualEndMarker ) {
                text = _( "Enable/Disable end marker." );
            } else if ( sender == menuVisualGridline ) {
                text = _( "Show/Hide grid line." );
            } else if ( sender == menuVisualIconPalette ) {
                text = _( "Show/Hide icon palette" );
            } else if ( sender == menuVisualLyrics ) {
                text = _( "Show/Hide lyrics." );
            } else if ( sender == menuVisualMixer ) {
                text = _( "Show/Hide mixer window." );
            } else if ( sender == menuVisualNoteProperty ) {
                text = _( "Show/Hide expression lines." );
            } else if ( sender == menuVisualOverview ) {
                text = _( "Show/Hide navigation view" );
            } else if ( sender == menuVisualPitchLine ) {
                text = _( "Show/Hide pitch bend lines." );
            } else if ( sender == menuVisualPluginUi ) {
                text = _( "Open VSTi plugin window" );
            } else if ( sender == menuVisualProperty ) {
                text = _( "Show/Hide property window." );
            } else if ( sender == menuVisualStartMarker ) {
                text = _( "Enable/Disable start marker." );
            } else if ( sender == menuVisualWaveform ) {
                text = _( "Show/Hide waveform." );
            } else if ( sender == menuFileNew ) {
                text = _( "Create new project." );
            } else if ( sender == menuFileOpen ) {
                text = _( "Open Cadencii project." );
            } else if ( sender == menuFileSave ) {
                text = _( "Save current project." );
            } else if ( sender == menuFileSaveNamed ) {
                text = _( "Save current project with new name." );
            } else if ( sender == menuFileOpenVsq ) {
                text = _( "Open VSQ / VOCALOID MIDI and create new project." );
            } else if ( sender == menuFileOpenUst ) {
                text = _( "Open UTAU project and create new project." );
            } else if ( sender == menuFileImport ) {
                text = _( "Import." );
            } else if ( sender == menuFileImportMidi ) {
                text = _( "Import Standard MIDI." );
            } else if ( sender == menuFileImportUst ) {
                text = _( "Import UTAU project" );
            } else if ( sender == menuFileImportVsq ) {
                text = _( "Import VSQ / VOCALOID MIDI." );
            } else if ( sender == menuFileExport ) {
                text = _( "Export." );
            } else if ( sender == menuFileExportParaWave ) {
                text = _( "Export all tracks to serial numbered WAVEs" );
            } else if ( sender == menuFileExportWave ) {
                text = _( "Export to WAVE file." );
            } else if ( sender == menuFileExportMusicXml ) {
                text = _( "Export current track as Music XML" );
            } else if ( sender == menuFileExportMidi ) {
                text = _( "Export to Standard MIDI." );
            } else if ( sender == menuFileExportUst ) {
                text = _( "Export current track as UTAU project file" );
            } else if ( sender == menuFileExportVsq ) {
                text = _( "Export to VSQ" );
            } else if ( sender == menuFileExportVxt ) {
                text = _( "Export current track as Meta-text for vConnect" );
            } else if ( sender == menuFileRecent ) {
                text = _( "Recent projects." );
            } else if ( sender == menuFileQuit ) {
                text = _( "Close this window." );
            } else if ( sender == menuJobConnect ) {
                text = _( "Lengthen note end to neighboring note." );
            } else if ( sender == menuJobLyric ) {
                text = _( "Import lyric." );
#if !JAVA
            } else if ( sender == menuJobRewire ) {
                text = _( "Import tempo from ReWire host." ) + _( "(not implemented)" );
            } else if ( sender == menuJobReloadVsti ) {
                text = _( "Reload VSTi dll." ) + _( "(not implemented)" );
#endif
            } else if ( sender == menuJobNormalize ) {
                text = _( "Correct overlapped item." );
            } else if ( sender == menuJobInsertBar ) {
                text = _( "Insert bar." );
            } else if ( sender == menuJobDeleteBar ) {
                text = _( "Delete bar." );
            } else if ( sender == menuJobRandomize ) {
                text = _( "Randomize items." );
            } else if ( sender == menuLyricExpressionProperty ) {
                text = _( "Edit portamento/accent/decay of selected item" );
            } else if ( sender == menuLyricVibratoProperty ) {
                text = _( "Edit vibrato length and type of selected item" );
            } else if ( sender == menuLyricPhonemeTransformation ) {
                text = _( "Translate all phrase into phonetic symbol" );
            } else if ( sender == menuLyricDictionary ){
                text = _( "Open configuration dialog for phonetic symnol dictionaries" );
            } else if ( sender == menuLyricCopyVibratoToPreset ) {
                text = _( "Copy vibrato config of selected item into vibrato preset" );
            } else if ( sender == menuScriptUpdate ){
                text = _( "Read and compile all scripts and update the list of them" );
            } else if ( sender == menuSettingPreference ){
                text = _( "Open configuration dialog for editor configs" );
            } else if ( sender == menuSettingPositionQuantize ) {
                text = _( "Change quantize resolution" );
            } else if ( sender == menuSettingGameControler ){
                text = _( "Connect/Remove/Configure game controler" );
            } else if ( sender == menuSettingPaletteTool ) {
                text = _( "Configuration of palette tool" );
            } else if ( sender == menuSettingShortcut ) {
                text = _( "Open configuration dialog for shortcut key" );
            } else if ( sender == menuSettingVibratoPreset ) {
                text = _( "Open configuration dialog for vibrato preset" );
            } else if ( sender == menuSettingDefaultSingerStyle ) {
                text = _( "Edit default singer style" );
            } else if ( sender == menuSettingSequence ) {
                text = _( "Configuration of this sequence." );
            } else if ( sender == menuTrackAdd ) {
                text = _( "Add new track." );
            } else if ( sender == menuTrackBgm ) {
                text = _( "Add/Remove/Edit background music" );
            } else if ( sender == menuTrackOn ) {
                text = _( "Enable current track." );
            } else if ( sender == menuTrackCopy ) {
                text = _( "Copy current track." );
            } else if ( sender == menuTrackChangeName ) {
                text = _( "Change track name." );
            } else if ( sender == menuTrackDelete ) {
                text = _( "Delete current track." );
            } else if ( sender == menuTrackRenderCurrent ) {
                text = _( "Render current track." );
            } else if ( sender == menuTrackRenderAll ) {
                text = _( "Render all tracks." );
            } else if ( sender == menuTrackOverlay ) {
                text = _( "Show background items." );
            } else if ( sender == menuTrackRenderer ) {
                text = _( "Select voice synthesis engine." );
            } else if ( sender == menuTrackRendererAquesTone ) {
                text = _( "AquesTone" );
            } else if ( sender == menuTrackRendererUtau ) {
                text = _( "UTAU" );
            } else if ( sender == menuTrackRendererVCNT ) {
                text = _( "vConnect-STAND" );
            } else if ( sender == menuTrackRendererVOCALOID1 ) {
                text = _( "VOCALOID1" );
            } else if ( sender == menuTrackRendererVOCALOID2 ) {
                text = _( "VOCALOID2" );
            } else if ( sender == menuFileRecentClear ) {
                text = _( "Clear menu items" );
            } else {
                notfound = true;
            }

#if DEBUG
            if ( notfound && sender is BMenuItem ) {
                BMenuItem item = (BMenuItem)sender;
                Logger.write( typeof( FormMain ) + ".handleMenuMouseEnter; cannot find message for " + item.getName() + "\n" );
            }
#endif
#if JAVA
            statusLabel.setText( text );
#else
            statusLabel.Text = text;
#endif
        }

        public void handleSpaceKeyDown( Object sender, BKeyEventArgs e )
        {
#if JAVA
            if ( (e.KeyValue & KeyEvent.VK_SPACE) == KeyEvent.VK_SPACE ) {
#else
            if ( (e.KeyCode & System.Windows.Forms.Keys.Space) == System.Windows.Forms.Keys.Space ) {
#endif
                mSpacekeyDowned = true;
            }
        }

        public void handleSpaceKeyUp( Object sender, BKeyEventArgs e )
        {
#if JAVA
            if ( (e.KeyValue & KeyEvent.VK_SPACE) == KeyEvent.VK_SPACE ) {
#else
            if ( (e.KeyCode & System.Windows.Forms.Keys.Space) == System.Windows.Forms.Keys.Space ) {
#endif
                mSpacekeyDowned = false;
            }
        }

        public void handleChangeRenderer( Object sender, EventArgs e )
        {
            RendererKind kind = RendererKind.NULL;
            int resampler_index = -1;
            if ( sender == cMenuTrackTabRendererAquesTone || sender == menuTrackRendererAquesTone ) {
                kind = RendererKind.AQUES_TONE;
            } else if ( sender == cMenuTrackTabRendererStraight || sender == menuTrackRendererVCNT ) {
                kind = RendererKind.VCNT;
            } else if ( sender == cMenuTrackTabRendererVOCALOID1 || sender == menuTrackRendererVOCALOID1 ) {
                kind = RendererKind.VOCALOID1;
            } else if ( sender == cMenuTrackTabRendererVOCALOID2 || sender == menuTrackRendererVOCALOID2 ) {
                kind = RendererKind.VOCALOID2;
            } else {
                // イベント送信元のアイテムが，cMenuTrackTabRendererUtauまたは
                // menuTrackRendererUTAUのサブアイテムかどうかをチェック
#if JAVA
                if ( sender instanceof BMenuItem ) {
#else
                if ( sender is System.Windows.Forms.ToolStripMenuItem ) {
#endif
#if JAVA
                    BMenuItem item = (BMenuItem)sender;
                    MenuElement[] subc0 = cMenuTrackTabRendererUtau.getSubElements();
                    if( subc0.length > 0 ){
                        MenuElement[] subc1 = subc0[0].getSubElements();
                        for ( int i = 0; i < subc1.length; i++ ){
                            MenuElement c = subc1[i];
                            if( c instanceof BMenuItem ){
                                BMenuItem b = (BMenuItem)c;
                                if( b == item ){
                                    resampler_index = i;
                                    break;
                                }
                            }
                        }
                    }
                    if( resampler_index < 0 ){
                        MenuElement[] subm0 = menuTrackRendererUtau.getSubElements();
                        if( subm0.length > 0 ){
                            MenuElement[] subm1 = subm0[0].getSubElements();
                            for( int i = 0; i < subm1.length; i++ ){
                                MenuElement c = subm1[i];
                                if( c instanceof BMenuItem ){
                                    BMenuItem b = (BMenuItem)c;
                                    if( b == item ){
                                        resampler_index = i;
                                        break;
                                    }
                                }
                            }
                        }
                    }
#else
                    System.Windows.Forms.ToolStripMenuItem item = (System.Windows.Forms.ToolStripMenuItem)sender;
                    resampler_index = cMenuTrackTabRendererUtau.DropDownItems.IndexOf( item );
                    if ( resampler_index < 0 ) {
                        resampler_index = menuTrackRendererUtau.DropDownItems.IndexOf( item );
                    }
#endif
                }
                if ( resampler_index < 0 ) {
                    // 検出できないのでbailout
                    return;
                }

#if DEBUG
                sout.println( "FormMain#handleChangeRenderer; resampler_index=" + resampler_index );
#endif
                // 検出できた
                // このばあいは確実にUTAU
                kind = RendererKind.UTAU;
            }
            VsqFileEx vsq = AppManager.getVsqFile();
            int selected = AppManager.getSelected();
            VsqTrack vsq_track = vsq.Track.get( selected );
            RendererKind old = VsqFileEx.getTrackRendererKind( vsq_track );
            int old_resampler_index = VsqFileEx.getTrackResamplerUsed( vsq_track );
            boolean changed = (old != kind);
            if ( !changed && kind == RendererKind.UTAU ) {
                changed = (old_resampler_index != resampler_index);
            }
#if DEBUG
            sout.println( "FormMain#handleChangeRenderer; old=" + old + "; kind=" + kind );
            sout.println( "FormMain#handleChangeRenderer; old_resampler_index=" + old_resampler_index + "; resampler_index=" + resampler_index );
            sout.println( "FormMaiN#handleChangeRenderer; changed=" + changed );
#endif
            if ( changed ) {
                VsqTrack item = (VsqTrack)vsq_track.clone();
                Vector<VsqID> singers = AppManager.getSingerListFromRendererKind( kind );
                String renderer = AppManager.getVersionStringFromRendererKind( kind );
                if ( singers == null ) {
                    serr.println( "FormMain#changeRendererCor; singers is null" );
                    return;
                }

                item.changeRenderer( renderer, singers );
                VsqFileEx.setTrackRendererKind( item, kind );
                if ( kind == RendererKind.UTAU ) {
#if DEBUG
                    sout.println( "FormMain#handleChangeRenderer; before; item.Tag=" + item.Tag );
#endif
                    VsqFileEx.setTrackResamplerUsed( item, resampler_index );
#if DEBUG
                    sout.println( "FormMain#handleChangeRenderer; after; item.Tag=" + item.Tag );
#endif
                }
                CadenciiCommand run = VsqFileEx.generateCommandTrackReplace( selected,
                                                                             item,
                                                                             vsq.AttachedCurves.get( selected - 1 ) );
                AppManager.register( vsq.executeCommand( run ) );
#if DEBUG
                sout.println( "FormMain#handleChangeRenderer; after executing command; resamplerUsed=" + VsqFileEx.getTrackResamplerUsed( vsq.Track.get( selected ) ) );
#endif
                cMenuTrackTabRendererVOCALOID1.setSelected( kind == RendererKind.VOCALOID1 );
                cMenuTrackTabRendererVOCALOID2.setSelected( kind == RendererKind.VOCALOID2 );
                cMenuTrackTabRendererUtau.setSelected( kind == RendererKind.UTAU );
                cMenuTrackTabRendererStraight.setSelected( kind == RendererKind.VCNT );
                menuTrackRendererVOCALOID1.setSelected( kind == RendererKind.VOCALOID1 );
                menuTrackRendererVOCALOID2.setSelected( kind == RendererKind.VOCALOID2 );
                menuTrackRendererUtau.setSelected( kind == RendererKind.UTAU );
                menuTrackRendererVCNT.setSelected( kind == RendererKind.VCNT );
#if JAVA
                for( int i = 0; i < cMenuTrackTabRendererUtau.getComponentCount(); i++ ){
                    Component c = cMenuTrackTabRendererUtau.getComponent( i );
                    if( c instanceof BMenuItem ){
                        ((BMenuItem)c).setSelected( (i == resampler_index) );
                    }
                }
                for( int i = 0; i < menuTrackRendererUtau.getComponentCount(); i++ ){
                    Component c = menuTrackRendererUtau.getComponent( i );
                    if( c instanceof BMenuItem ){
                        ((BMenuItem)c).setSelected( (i == resampler_index) );
                    }
                }
#else
                for ( int i = 0; i < cMenuTrackTabRendererUtau.DropDownItems.Count; i++ ) {
                    ((System.Windows.Forms.ToolStripMenuItem)cMenuTrackTabRendererUtau.DropDownItems[i]).Checked = (i == resampler_index);
                }
                for ( int i = 0; i < menuTrackRendererUtau.DropDownItems.Count; i++ ) {
                    ((System.Windows.Forms.ToolStripMenuItem)menuTrackRendererUtau.DropDownItems[i]).Checked = (i == resampler_index);
                }
#endif
                setEdited( true );
                refreshScreen();
            }
        }

        public void handleBgmOffsetSeconds_Click( Object sender, EventArgs e )
        {
            if ( !(sender is BgmMenuItem) ) {
                return;
            }
            BgmMenuItem menu = (BgmMenuItem)sender;
            int index = menu.getBgmIndex();
            InputBox ib = null;
            try {
                ib = new InputBox( _( "Input Offset Seconds" ) );
                ib.setLocation( getFormPreferedLocation( ib ) );
                ib.setResult( AppManager.getBgm( index ).readOffsetSeconds + "" );
                BDialogResult dr = AppManager.showModalDialog( ib, this );
                if ( dr != BDialogResult.OK ) {
                    return;
                }
                Vector<BgmFile> list = new Vector<BgmFile>();
                int count = AppManager.getBgmCount();
                BgmFile item = null;
                for ( int i = 0; i < count; i++ ) {
                    if ( i == index ) {
                        item = (BgmFile)AppManager.getBgm( i ).clone();
                        list.add( item );
                    } else {
                        list.add( AppManager.getBgm( i ) );
                    }
                }
                double draft;
                try {
                    draft = str.tof( ib.getResult() );
                    item.readOffsetSeconds = draft;
                    menu.setToolTipText( draft + " " + _( "seconds" ) );
                } catch ( Exception ex3 ) {
                    Logger.write( typeof( FormMain ) + ".handleBgmOffsetSeconds_Click; ex=" + ex3 + "\n" );
                }
                CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
                AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                setEdited( true );
            } catch ( Exception ex ) {
                Logger.write( typeof( FormMain ) + ".handleBgmOffsetSeconds_Click; ex=" + ex + "\n" );
            } finally {
                if ( ib != null ) {
                    try {
#if !JAVA
                        ib.Dispose();
#endif
                    } catch ( Exception ex2 ) {
                        Logger.write( typeof( FormMain ) + ".handleBgmOffsetSeconds_Click; ex=" + ex2 + "\n" );
                    }
                }
            }
        }

        public void handleBgmStartAfterPremeasure_CheckedChanged( Object sender, EventArgs e )
        {
            if ( !(sender is BgmMenuItem) ) {
                return;
            }
            BgmMenuItem menu = (BgmMenuItem)sender;
            int index = menu.getBgmIndex();
            Vector<BgmFile> list = new Vector<BgmFile>();
            int count = AppManager.getBgmCount();
            for ( int i = 0; i < count; i++ ) {
                if ( i == index ) {
                    BgmFile item = (BgmFile)AppManager.getBgm( i ).clone();
                    item.startAfterPremeasure = menu.isSelected();
                    list.add( item );
                } else {
                    list.add( AppManager.getBgm( i ) );
                }
            }
            CadenciiCommand run = VsqFileEx.generateCommandBgmUpdate( list );
            AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
            setEdited( true );
        }

        public void handleBgmAdd_Click( Object sender, EventArgs e )
        {
            String dir = AppManager.editorConfig.getLastUsedPathIn( "wav" );
            openWaveDialog.setSelectedFile( dir );
            int ret = AppManager.showModalDialog( openWaveDialog, true, this );
            if ( ret != BFileChooser.APPROVE_OPTION ) {
                return;
            }

            String file = openWaveDialog.getSelectedFile();
            AppManager.editorConfig.setLastUsedPathIn( file, ".wav" );

            // 既に開かれていたらキャンセル
            int count = AppManager.getBgmCount();
            boolean found = false;
            for ( int i = 0; i < count; i++ ) {
                BgmFile item = AppManager.getBgm( i );
                if ( str.compare( file, item.file ) ) {
                    found = true;
                    break;
                }
            }
            if ( found ) {
                AppManager.showMessageBox(
                    PortUtil.formatMessage( _( "file '{0}' is already registered as BGM." ), file ),
                    _( "Error" ),
                    org.kbinani.windows.forms.Utility.MSGBOX_DEFAULT_OPTION,
                    org.kbinani.windows.forms.Utility.MSGBOX_WARNING_MESSAGE );
                return;
            }

            // 登録
            AppManager.addBgm( file );
            setEdited( true );
            updateBgmMenuState();
        }

        public void handleBgmRemove_Click( Object sender, EventArgs e )
        {
            if ( !(sender is BgmMenuItem) ) {
                return;
            }
            BgmMenuItem parent = (BgmMenuItem)sender;
            int index = parent.getBgmIndex();
            BgmFile bgm = AppManager.getBgm( index );
            if ( AppManager.showMessageBox( PortUtil.formatMessage( _( "remove '{0}'?" ), bgm.file ),
                                  "Cadencii",
                                  org.kbinani.windows.forms.Utility.MSGBOX_YES_NO_OPTION,
                                  org.kbinani.windows.forms.Utility.MSGBOX_QUESTION_MESSAGE ) != BDialogResult.YES ) {
                return;
            }
            AppManager.removeBgm( index );
            setEdited( true );
            updateBgmMenuState();
        }

        public void handleSettingPaletteTool( Object sender, EventArgs e )
        {
#if ENABLE_SCRIPT
            if ( !(sender is PaletteToolMenuItem) ) {
                return;
            }
            PaletteToolMenuItem tsmi = (PaletteToolMenuItem)sender;
            String id = tsmi.getPaletteToolID();
            if ( !PaletteToolServer.loadedTools.containsKey( id ) ) {
                return;
            }
            Object instance = PaletteToolServer.loadedTools.get( id );
            IPaletteTool ipt = (IPaletteTool)instance;
            if ( ipt.openDialog() == System.Windows.Forms.DialogResult.OK ) {
                XmlSerializer xsms = new XmlSerializer( instance.GetType(), true );
                String dir = fsys.combine( Utility.getApplicationDataPath(), "tool" );
                if ( !fsys.isDirectoryExists( dir ) ) {
                    PortUtil.createDirectory( dir );
                }
                String cfg = id + ".config";
                String config = fsys.combine( dir, cfg );
                FileOutputStream fs = null;
                try {
                    fs = new FileOutputStream( config );
                    xsms.serialize( fs, null );
                } catch ( Exception ex ) {
                    Logger.write( typeof( FormMain ) + ".handleSettingPaletteTool; ex=" + ex + "\n" );
                } finally {
                    if ( fs != null ) {
                        try {
                            fs.close();
                        } catch ( Exception ex2 ) {
                            Logger.write( typeof( FormMain ) + ".handleSettingPaletteTool; ex=" + ex2 + "\n" );
                        }
                    }
                }
            }
#endif
        }

#if ENABLE_SCRIPT
        public void handleScriptMenuItem_Click( Object sender, EventArgs e )
        {
#if DEBUG
            sout.println( "FormMain#handleScriptMenuItem_Click; sender.GetType()=" + sender.GetType() );
#endif
            try {
                String dir = Utility.getScriptPath();
                String id = "";
                if ( sender is PaletteToolMenuItem ) {
                    id = ((PaletteToolMenuItem)sender).getPaletteToolID();
                }
#if DEBUG
                sout.println( "FormMain#handleScriptMenuItem_Click; id=" + id );
#endif
                String script_file = fsys.combine( dir, id );
                if ( ScriptServer.getTimestamp( id ) != PortUtil.getFileLastModified( script_file ) ) {
                    ScriptServer.reload( id );
                }
                if ( ScriptServer.isAvailable( id ) ) {
                    if ( ScriptServer.invokeScript( id, AppManager.getVsqFile() ) ) {
                        setEdited( true );
                        updateDrawObjectList();
                        int selected = AppManager.getSelected();
#if DEBUG
                        sout.println( "FormMain#handleScriptMenuItem_Click; ScriptServer.invokeScript has returned TRUE" );
#endif
                        AppManager.updateSelectedEventInstance();
                        AppManager.propertyPanel.updateValue( selected );
                        refreshScreen();
                    }
                } else {
                    FormCompileResult dlg = null;
                    try {
                        dlg = new FormCompileResult( _( "Failed loading script." ), ScriptServer.getCompileMessage( id ) );
                        AppManager.showModalDialog( dlg, this );
                    } catch ( Exception ex ) {
                        Logger.write( typeof( FormMain ) + ".handleScriptMenuItem_Click; ex=" + ex + "\n" );
                    } finally {
                        if ( dlg != null ) {
                            try {
                                dlg.close();
                            } catch ( Exception ex2 ) {
                                Logger.write( typeof( FormMain ) + ".handleScriptMenuItem_Click; ex=" + ex2 + "\n" );
                            }
                        }
                    }
                }
            } catch ( Exception ex3 ) {
                Logger.write( typeof( FormMain ) + ".handleScriptMenuItem_Click; ex=" + ex3 + "\n" );
#if DEBUG
                sout.println( "AppManager#dd_run_Click; ex3=" + ex3 );
#endif
            }
        }
#endif

#if ENABLE_MTC
        /// <summary>
        /// MTC用のMIDI-INデバイスからMIDIを受信します。
        /// </summary>
        /// <param name="now"></param>
        /// <param name="dataArray"></param>
        private void handleMtcMidiReceived( double now, byte[] dataArray ) {
            byte data = (byte)(dataArray[1] & 0x0f);
            byte type = (byte)((dataArray[1] >> 4) & 0x0f);
            if ( type == 0 ) {
                mtcFrameLsb = data;
            } else if ( type == 1 ) {
                mtcFrameMsb = data;
            } else if ( type == 2 ) {
                mtcSecLsb = data;
            } else if ( type == 3 ) {
                mtcSecMsb = data;
            } else if ( type == 4 ) {
                mtcMinLsb = data;
            } else if ( type == 5 ) {
                mtcMinMsb = data;
            } else if ( type == 6 ) {
                mtcHourLsb = data;
            } else if ( type == 7 ) {
                mtcHourMsb = (byte)(data & 1);
                int fpsType = (data & 6) >> 1;
                double fps = 30.0;
                if ( fpsType == 0 ) {
                    fps = 24.0;
                } else if ( fpsType == 1 ) {
                    fps = 25;
                } else if ( fpsType == 2 ) {
                    fps = 30000.0 / 1001.0;
                } else if ( fpsType == 3 ) {
                    fps = 30.0;
                }
                int hour = (mtcHourMsb << 4 | mtcHourLsb);
                int min = (mtcMinMsb << 4 | mtcMinLsb);
                int sec = (mtcSecMsb << 4 | mtcSecLsb);
                int frame = (mtcFrameMsb << 4 | mtcFrameLsb) + 2;
                double time = (hour * 60.0 + min) * 60.0 + sec + frame / fps;
                mtcLastReceived = now;
#if DEBUG
                int clock = (int)AppManager.getVsqFile().getClockFromSec( time );
                AppManager.setCurrentClock( clock );
#endif
                /*if ( !AppManager.isPlaying() ) {
                    AppManager.setEditMode( EditMode.REALTIME_MTC );
                    AppManager.setPlaying( true );
                    BEventHandler handler = new BEventHandler( AppManager_PreviewStarted );
                    if ( handler != null ) {
                        this.Invoke( handler );
                        while ( VSTiProxy.getPlayTime() <= 0.0 ) {
                            System.Windows.Forms.Application.DoEvents();
                        }
                        AppManager.setPlaying( true );
                    }
                }*/
#if DEBUG
                sout.println( "FormMain#handleMtcMidiReceived; time=" + time );
#endif
            }
        }
#endif

#if ENABLE_MIDI
        public void mMidiIn_MidiReceived( Object sender, javax.sound.midi.MidiMessage message )
        {
            byte[] data = message.getMessage();
#if DEBUG
            sout.println( "FormMain#mMidiIn_MidiReceived; data.Length=" + data.Length );
#endif
            if ( data.Length <= 2 ) {
                return;
            }
#if DEBUG
            sout.println( "FormMain#mMidiIn_MidiReceived; AppManager.isPlaying()=" + AppManager.isPlaying() );
#endif
            if ( AppManager.isPlaying() ) {
                return;
            }
#if DEBUG
            sout.println( "FormMain#mMidiIn_MidiReceived; isStepSequencerEnabeld()=" + isStepSequencerEnabled() );
#endif
            if ( !isStepSequencerEnabled() ) {
                return;
            }
            int code = data[0] & 0xf0;
            if ( code != 0x80 && code != 0x90 ) {
                return;
            }
            if ( code == 0x90 && data[2] == 0x00 ) {
                code = 0x80;//ベロシティ0のNoteOnはNoteOff
            }

            int note = (0xff & data[1]);

            int clock = AppManager.getCurrentClock();
            int unit = AppManager.getPositionQuantizeClock();
            if ( unit > 1 ) {
                clock = doQuantize( clock, unit );
            }

#if DEBUG
            sout.println( "FormMain#mMidiIn_Received; clock=" + clock + "; note=" + note );
#endif
            if ( code == 0x80 ) {
                /*if ( AppManager.mAddingEvent != null ) {
                    int len = clock - AppManager.mAddingEvent.Clock;
                    if ( len <= 0 ) {
                        len = unit;
                    }
                    AppManager.mAddingEvent.ID.Length = len;
                    int selected = AppManager.getSelected();
                    CadenciiCommand run = new CadenciiCommand( VsqCommand.generateCommandEventAdd( selected,
                                                                                                   AppManager.mAddingEvent ) );
                    AppManager.register( AppManager.getVsqFile().executeCommand( run ) );
                    if ( !isEdited() ) {
                        setEdited( true );
                    }
                    updateDrawObjectList();
                }*/
            } else if ( code == 0x90 ) {
                if ( AppManager.mAddingEvent != null ) {
                    // mAddingEventがnullでない場合は打ち込みの試行中(未確定の音符がある)
                    // であるので，ノートだけが変わるようにする
                    clock = AppManager.mAddingEvent.Clock;
                } else {
                    AppManager.mAddingEvent = new VsqEvent();
                }
                AppManager.mAddingEvent.Clock = clock;
                if ( AppManager.mAddingEvent.ID == null ) {
                    AppManager.mAddingEvent.ID = new VsqID();
                }
                AppManager.mAddingEvent.ID.type = VsqIDType.Anote;
                AppManager.mAddingEvent.ID.Dynamics = 64;
                AppManager.mAddingEvent.ID.VibratoHandle = null;
                if ( AppManager.mAddingEvent.ID.LyricHandle == null ) {
                    AppManager.mAddingEvent.ID.LyricHandle = new LyricHandle( "a", "a" );
                }
                AppManager.mAddingEvent.ID.LyricHandle.L0.Phrase = "a";
                AppManager.mAddingEvent.ID.LyricHandle.L0.setPhoneticSymbol( "a" );
                AppManager.mAddingEvent.ID.Note = note;

                // 音符の長さを計算
                int length = QuantizeModeUtil.getQuantizeClock(
                        AppManager.editorConfig.getLengthQuantize(),
                        AppManager.editorConfig.isLengthQuantizeTriplet() );

                // 音符の長さを設定
                Utility.editLengthOfVsqEvent(
                    AppManager.mAddingEvent,
                    length,
                    AppManager.vibratoLengthEditingRule );

                // 現在位置は，音符の末尾になる
                AppManager.setCurrentClock( clock + length );

                // 画面を再描画
#if JAVA
                refreshScreen();
#else
                if ( this.InvokeRequired ) {
                    DelegateRefreshScreen deleg = null;
                    try {
                        deleg = new DelegateRefreshScreen( refreshScreen );
                    } catch ( Exception ex4 ) {
                        deleg = null;
                    }
                    if ( deleg != null ) {
                        this.Invoke( deleg, true );
                    }
                } else {
                    refreshScreen( true );
                }
#endif
                // 鍵盤音を鳴らす
                KeySoundPlayer.play( note );
            }
        }
#endif
        #endregion

        #region public static methods
        /// <summary>
        /// 文字列を、現在の言語設定に従って翻訳します。
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static String _( String id )
        {
            return Messaging.getMessage( id );
        }

        /// <summary>
        /// VsqEvent, VsqBPList, BezierCurvesの全てのクロックを、tempoに格納されているテンポテーブルに
        /// 合致するようにシフトします．ただし，このメソッド内ではtargetのテンポテーブルは変更せず，クロック値だけが変更される．
        /// </summary>
        /// <param name="work"></param>
        /// <param name="tempo"></param>
        public static void shiftClockToMatchWith( VsqFileEx target, VsqFile tempo, double shift_seconds )
        {
            // テンポをリプレースする場合。
            // まずクロック値を、リプレース後のモノに置き換え
            for ( int track = 1; track < target.Track.size(); track++ ) {
                // ノート・歌手イベントをシフト
                for ( Iterator<VsqEvent> itr = target.Track.get( track ).getEventIterator(); itr.hasNext(); ) {
                    VsqEvent item = itr.next();
                    if ( item.ID.type == VsqIDType.Singer && item.Clock == 0 ) {
                        continue;
                    }
                    int clock = item.Clock;
                    double sec_start = target.getSecFromClock( clock ) + shift_seconds;
                    double sec_end = target.getSecFromClock( clock + item.ID.getLength() ) + shift_seconds;
                    int clock_start = (int)tempo.getClockFromSec( sec_start );
                    int clock_end = (int)tempo.getClockFromSec( sec_end );
                    item.Clock = clock_start;
                    item.ID.setLength( clock_end - clock_start );
                    if ( item.ID.VibratoHandle != null ) {
                        double sec_vib_start = target.getSecFromClock( clock + item.ID.VibratoDelay ) + shift_seconds;
                        int clock_vib_start = (int)tempo.getClockFromSec( sec_vib_start );
                        item.ID.VibratoDelay = clock_vib_start - clock_start;
                        item.ID.VibratoHandle.setLength( clock_end - clock_vib_start );
                    }
                }

                // コントロールカーブをシフト
                for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = Utility.CURVE_USAGE[j];
                    VsqBPList item = target.Track.get( track ).getCurve( ct.getName() );
                    if ( item == null ) {
                        continue;
                    }
                    VsqBPList repl = new VsqBPList( item.getName(), item.getDefault(), item.getMinimum(), item.getMaximum() );
                    for ( int i = 0; i < item.size(); i++ ) {
                        int clock = item.getKeyClock( i );
                        int value = item.getElement( i );
                        double sec = target.getSecFromClock( clock ) + shift_seconds;
                        if ( sec >= 0 ) {
                            int clock_new = (int)tempo.getClockFromSec( sec );
                            repl.add( clock_new, value );
                        }
                    }
                    target.Track.get( track ).setCurve( ct.getName(), repl );
                }

                // ベジエカーブをシフト
                for ( int j = 0; j < Utility.CURVE_USAGE.Length; j++ ) {
                    CurveType ct = Utility.CURVE_USAGE[j];
                    Vector<BezierChain> list = target.AttachedCurves.get( track - 1 ).get( ct );
                    if ( list == null ) {
                        continue;
                    }
                    for ( Iterator<BezierChain> itr = list.iterator(); itr.hasNext(); ) {
                        BezierChain chain = itr.next();
                        for ( Iterator<BezierPoint> itr2 = chain.points.iterator(); itr2.hasNext(); ) {
                            BezierPoint point = itr2.next();
                            PointD bse = new PointD( tempo.getClockFromSec( target.getSecFromClock( point.getBase().getX() ) + shift_seconds ),
                                                     point.getBase().getY() );
                            double rx = point.getBase().getX() + point.controlRight.getX();
                            double new_rx = tempo.getClockFromSec( target.getSecFromClock( rx ) + shift_seconds );
                            PointD ctrl_r = new PointD( new_rx - bse.getX(), point.controlRight.getY() );

                            double lx = point.getBase().getX() + point.controlLeft.getX();
                            double new_lx = tempo.getClockFromSec( target.getSecFromClock( lx ) + shift_seconds );
                            PointD ctrl_l = new PointD( new_lx - bse.getX(), point.controlLeft.getY() );
                            point.setBase( bse );
                            point.controlLeft = ctrl_l;
                            point.controlRight = ctrl_r;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// フォームのタイトルバーが画面内に入るよう、Locationを正規化します
        /// </summary>
        /// <param name="form"></param>
        public static void normalizeFormLocation( BForm dlg )
        {
            Rectangle rcScreen = PortUtil.getWorkingArea( dlg );
            int top = dlg.getY();
            if ( top + dlg.getHeight() > rcScreen.y + rcScreen.height ) {
                // ダイアログの下端が隠れる場合、位置をずらす
                top = rcScreen.y + rcScreen.height - dlg.getHeight();
            }
            if ( top < rcScreen.y ) {
                // ダイアログの上端が隠れる場合、位置をずらす
                top = rcScreen.y;
            }
            int left = dlg.getX();
            if ( left + dlg.getWidth() > rcScreen.x + rcScreen.width ) {
                left = rcScreen.x + rcScreen.width - dlg.getWidth();
            }
            if ( left < rcScreen.x ) {
                left = rcScreen.x;
            }
            dlg.setLocation( left, top );
        }
        #endregion

        #region ui implementation
#if JAVA
        //INCLUDE-SECTION FIELD ../BuildJavaUI/src/org/kbinani/cadencii/FormMain.java
        BMenuItem stripDDBtnQuantize04 = null;
        BMenuItem stripDDBtnQuantize08 = null;
        BMenuItem stripDDBtnQuantize16 = null;
        BMenuItem stripDDBtnQuantize32 = null;
        BMenuItem stripDDBtnQuantize64 = null;
        BMenuItem stripDDBtnQuantize128 = null;
        BMenuItem stripDDBtnQuantizeOff = null;
        //INCLUDE-SECTION METHOD ../BuildJavaUI/src/org/kbinani/cadencii/FormMain.java
#else
        /// <summary>
        /// 使用中のリソースをすべてクリーンアップします。
        /// </summary>
        /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
        protected override void Dispose( boolean disposing )
        {
            if ( disposing && (components != null) ) {
                components.Dispose();
            }
            base.Dispose( disposing );
        }

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        public void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( FormMain ) );
            this.menuStripMain = new org.kbinani.windows.forms.BMenuBar();
            this.menuFile = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileNew = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileOpen = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileSave = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileSaveNamed = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem10 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileOpenVsq = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileOpenUst = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImport = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImportVsq = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImportMidi = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileImportUst = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExport = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportWave = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportParaWave = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportVsq = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportMidi = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportMusicXml = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportUst = new org.kbinani.windows.forms.BMenuItem();
            this.menuFileExportVxt = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem11 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileRecent = new org.kbinani.windows.forms.BMenu();
            this.menuFileRecentClear = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem12 = new System.Windows.Forms.ToolStripSeparator();
            this.menuFileQuit = new org.kbinani.windows.forms.BMenuItem();
            this.menuEdit = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditUndo = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem5 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditCut = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditPaste = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem19 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditAutoNormalizeMode = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem20 = new System.Windows.Forms.ToolStripSeparator();
            this.menuEditSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.menuEditSelectAllEvents = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisual = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualControlTrack = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualMixer = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualWaveform = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualIconPalette = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualOverview = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUi = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiVocaloid1 = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiVocaloid2 = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPluginUiAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualGridline = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem2 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualEndMarker = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem3 = new System.Windows.Forms.ToolStripSeparator();
            this.menuVisualLyrics = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualNoteProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuVisualPitchLine = new org.kbinani.windows.forms.BMenuItem();
            this.menuJob = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobNormalize = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobInsertBar = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobDeleteBar = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobRandomize = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobConnect = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobRewire = new org.kbinani.windows.forms.BMenuItem();
            this.menuJobReloadVsti = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrack = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackOn = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem21 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackAdd = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackChangeName = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem22 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackRenderCurrent = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRenderAll = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem23 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackOverlay = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRenderer = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID1 = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVOCALOID2 = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererUtau = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererVCNT = new org.kbinani.windows.forms.BMenuItem();
            this.menuTrackRendererAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem4 = new System.Windows.Forms.ToolStripSeparator();
            this.menuTrackBgm = new org.kbinani.windows.forms.BMenu();
            this.menuLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricExpressionProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricVibratoProperty = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricPhonemeTransformation = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricDictionary = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricCopyVibratoToPreset = new org.kbinani.windows.forms.BMenuItem();
            this.menuScript = new org.kbinani.windows.forms.BMenuItem();
            this.menuScriptUpdate = new org.kbinani.windows.forms.BMenuItem();
            this.menuSetting = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPreference = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingSequence = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPositionQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem9 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingPositionQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem8 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingGameControler = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerSetting = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerLoad = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingGameControlerRemove = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingShortcut = new org.kbinani.windows.forms.BMenuItem();
            this.menuSettingVibratoPreset = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem6 = new System.Windows.Forms.ToolStripSeparator();
            this.menuSettingDefaultSingerStyle = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelp = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpAbout = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpManual = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpLog = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpLogSwitch = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpLogOpen = new org.kbinani.windows.forms.BMenuItem();
            this.menuHelpDebug = new org.kbinani.windows.forms.BMenuItem();
            this.menuHidden = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditLyric = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerPencil = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenEditFlipToolPointerEraser = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenVisualForwardParameter = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenVisualBackwardParameter = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenTrackNext = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenTrackBack = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenCopy = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenPaste = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenCut = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenSelectForward = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenSelectBackward = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveUp = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveDown = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveLeft = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenMoveRight = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenLengthen = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenShorten = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenGoToStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenGoToEndMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenPlayFromStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenFlipCurveOnPianorollMode = new org.kbinani.windows.forms.BMenuItem();
            this.menuHiddenPrintPoToCSV = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPiano = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuPianoPointer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPencil = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoEraser = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCurve = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem13 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixed = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed01 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed02 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed04 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed08 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed16 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed32 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed64 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixed128 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixedOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem18 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoFixedTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoFixedDotted = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize04 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize08 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize16 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize32 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize64 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantize128 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoQuantizeOff = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem26 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoQuantizeTriplet = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoGrid = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoUndo = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem15 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoCut = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoPaste = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem16 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoSelectAllEvents = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem17 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuPianoImportLyric = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoExpressionProperty = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPianoVibratoProperty = new org.kbinani.windows.forms.BMenuItem();
            this.toolTip = new System.Windows.Forms.ToolTip( this.components );
            this.cMenuTrackTab = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuTrackTabTrackOn = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem24 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabAdd = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabChangeName = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabDelete = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem25 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabRenderCurrent = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderAll = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem27 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackTabOverlay = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRenderer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID1 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererVOCALOID2 = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererUtau = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererStraight = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackTabRendererAquesTone = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelector = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuTrackSelectorPointer = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPencil = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorLine = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorEraser = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaletteTool = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripSeparator14 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCurve = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem28 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorUndo = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorRedo = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem29 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorCut = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorCopy = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorPaste = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDelete = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuTrackSelectorDeleteBezier = new org.kbinani.windows.forms.BMenuItem();
            this.toolStripMenuItem31 = new System.Windows.Forms.ToolStripSeparator();
            this.cMenuTrackSelectorSelectAll = new org.kbinani.windows.forms.BMenuItem();
            this.trackBar = new org.kbinani.windows.forms.BSlider();
            this.pictureBox3 = new org.kbinani.windows.forms.BPictureBox();
            this.pictKeyLengthSplitter = new org.kbinani.windows.forms.BPictureBox();
            this.pictureBox2 = new org.kbinani.windows.forms.BPictureBox();
            this.vScroll = new org.kbinani.windows.forms.BVScrollBar();
            this.picturePositionIndicator = new org.kbinani.windows.forms.BPictureBox();
            this.toolStripBottom = new org.kbinani.windows.forms.BToolBar();
            this.toolStripStatusLabel1 = new org.kbinani.windows.forms.BStatusLabel();
            this.stripLblGameCtrlMode = new org.kbinani.windows.forms.BStatusLabel();
            this.toolStripSeparator10 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripStatusLabel2 = new org.kbinani.windows.forms.BStatusLabel();
            this.stripLblMidiIn = new org.kbinani.windows.forms.BStatusLabel();
            this.toolStripSeparator11 = new System.Windows.Forms.ToolStripSeparator();
            this.stripBtnStepSequencer = new System.Windows.Forms.ToolStripButton();
            this.splitContainerProperty = new org.kbinani.apputil.BSplitContainer();
            this.splitContainer2 = new org.kbinani.apputil.BSplitContainer();
            this.panel2 = new org.kbinani.windows.forms.BPanel();
            this.splitContainer1 = new org.kbinani.apputil.BSplitContainer();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this.stripDDBtnQuantize = new System.Windows.Forms.ContextMenu();
            this.stripDDBtnQuantize04 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantize08 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantize16 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantize32 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantize64 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantize128 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantizeOff = new System.Windows.Forms.MenuItem();
            this.menuItem2 = new System.Windows.Forms.MenuItem();
            this.stripDDBtnQuantizeTriplet = new System.Windows.Forms.MenuItem();
            this.toolStripSeparator3 = new System.Windows.Forms.ToolStripSeparator();
            this.imageListFile = new System.Windows.Forms.ImageList( this.components );
            this.imageListPosition = new System.Windows.Forms.ImageList( this.components );
            this.imageListMeasure = new System.Windows.Forms.ImageList( this.components );
            this.imageListTool = new System.Windows.Forms.ImageList( this.components );
            this.panel1 = new System.Windows.Forms.Panel();
            this.panelOverview = new org.kbinani.cadencii.PictOverview();
            this.pictPianoRoll = new org.kbinani.cadencii.PictPianoRoll();
            this.hScroll = new org.kbinani.windows.forms.BHScrollBar();
            this.rebar = new org.kbinani.windows.forms.Rebar();
            this.imageListMenu = new System.Windows.Forms.ImageList( this.components );
            this.toolBarFile = new System.Windows.Forms.ToolBar();
            this.stripBtnFileNew = new org.kbinani.windows.forms.BToolBarButton();
            this.stripBtnFileOpen = new org.kbinani.windows.forms.BToolBarButton();
            this.stripBtnFileSave = new org.kbinani.windows.forms.BToolBarButton();
            this.toolBarButton1 = new System.Windows.Forms.ToolBarButton();
            this.stripBtnCut = new org.kbinani.windows.forms.BToolBarButton();
            this.stripBtnCopy = new org.kbinani.windows.forms.BToolBarButton();
            this.stripBtnPaste = new org.kbinani.windows.forms.BToolBarButton();
            this.toolBarButton2 = new System.Windows.Forms.ToolBarButton();
            this.stripBtnUndo = new org.kbinani.windows.forms.BToolBarButton();
            this.stripBtnRedo = new org.kbinani.windows.forms.BToolBarButton();
            this.toolBarPosition = new System.Windows.Forms.ToolBar();
            this.stripBtnMoveTop = new System.Windows.Forms.ToolBarButton();
            this.stripBtnRewind = new System.Windows.Forms.ToolBarButton();
            this.stripBtnForward = new System.Windows.Forms.ToolBarButton();
            this.stripBtnMoveEnd = new System.Windows.Forms.ToolBarButton();
            this.stripBtnPlay = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
            this.stripBtnScroll = new System.Windows.Forms.ToolBarButton();
            this.stripBtnLoop = new System.Windows.Forms.ToolBarButton();
            this.toolBarMeasure = new System.Windows.Forms.ToolBar();
            this.stripDDBtnQuantizeParent = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton5 = new System.Windows.Forms.ToolBarButton();
            this.stripBtnStartMarker = new System.Windows.Forms.ToolBarButton();
            this.stripBtnEndMarker = new System.Windows.Forms.ToolBarButton();
            this.toolBarTool = new System.Windows.Forms.ToolBar();
            this.stripBtnPointer = new System.Windows.Forms.ToolBarButton();
            this.stripBtnPencil = new System.Windows.Forms.ToolBarButton();
            this.stripBtnLine = new System.Windows.Forms.ToolBarButton();
            this.stripBtnEraser = new System.Windows.Forms.ToolBarButton();
            this.toolBarButton3 = new System.Windows.Forms.ToolBarButton();
            this.stripBtnGrid = new System.Windows.Forms.ToolBarButton();
            this.stripBtnCurve = new System.Windows.Forms.ToolBarButton();
            this.toolStripContainer1 = new System.Windows.Forms.ToolStripContainer();
            this.statusStrip = new System.Windows.Forms.StatusStrip();
            this.statusLabel = new System.Windows.Forms.ToolStripStatusLabel();
            this.cMenuPositionIndicator = new org.kbinani.windows.forms.BPopupMenu( this.components );
            this.cMenuPositionIndicatorStartMarker = new org.kbinani.windows.forms.BMenuItem();
            this.cMenuPositionIndicatorEndMarker = new org.kbinani.windows.forms.BMenuItem();
            this.menuLyricApplyUtauParameters = new org.kbinani.windows.forms.BMenuItem();
            this.menuStripMain.SuspendLayout();
            this.cMenuPiano.SuspendLayout();
            this.cMenuTrackTab.SuspendLayout();
            this.cMenuTrackSelector.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox3)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictKeyLengthSplitter)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picturePositionIndicator)).BeginInit();
            this.toolStripBottom.SuspendLayout();
            this.splitContainerProperty.SuspendLayout();
            this.panel1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.panelOverview)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.pictPianoRoll)).BeginInit();
            this.toolStripContainer1.BottomToolStripPanel.SuspendLayout();
            this.toolStripContainer1.ContentPanel.SuspendLayout();
            this.toolStripContainer1.SuspendLayout();
            this.statusStrip.SuspendLayout();
            this.cMenuPositionIndicator.SuspendLayout();
            this.SuspendLayout();
            // 
            // menuStripMain
            // 
            this.menuStripMain.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFile,
            this.menuEdit,
            this.menuVisual,
            this.menuJob,
            this.menuTrack,
            this.menuLyric,
            this.menuScript,
            this.menuSetting,
            this.menuHelp,
            this.menuHidden} );
            this.menuStripMain.Location = new System.Drawing.Point( 0, 0 );
            this.menuStripMain.Name = "menuStripMain";
            this.menuStripMain.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            this.menuStripMain.Size = new System.Drawing.Size( 955, 24 );
            this.menuStripMain.TabIndex = 0;
            this.menuStripMain.Text = "menuStrip1";
            // 
            // menuFile
            // 
            this.menuFile.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFile.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileNew,
            this.menuFileOpen,
            this.menuFileSave,
            this.menuFileSaveNamed,
            this.toolStripMenuItem10,
            this.menuFileOpenVsq,
            this.menuFileOpenUst,
            this.menuFileImport,
            this.menuFileExport,
            this.toolStripMenuItem11,
            this.menuFileRecent,
            this.toolStripMenuItem12,
            this.menuFileQuit} );
            this.menuFile.ImageScaling = System.Windows.Forms.ToolStripItemImageScaling.None;
            this.menuFile.Name = "menuFile";
            this.menuFile.Size = new System.Drawing.Size( 51, 20 );
            this.menuFile.Text = "File(&F)";
            // 
            // menuFileNew
            // 
            this.menuFileNew.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileNew.Name = "menuFileNew";
            this.menuFileNew.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileNew.Text = "New(N)";
            this.menuFileNew.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileOpen
            // 
            this.menuFileOpen.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileOpen.Name = "menuFileOpen";
            this.menuFileOpen.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileOpen.Text = "Open(&O)";
            this.menuFileOpen.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileSave
            // 
            this.menuFileSave.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileSave.Name = "menuFileSave";
            this.menuFileSave.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileSave.Text = "Save(&S)";
            this.menuFileSave.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileSaveNamed
            // 
            this.menuFileSaveNamed.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileSaveNamed.Name = "menuFileSaveNamed";
            this.menuFileSaveNamed.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileSaveNamed.Text = "Save As(&A)";
            this.menuFileSaveNamed.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // toolStripMenuItem10
            // 
            this.toolStripMenuItem10.Name = "toolStripMenuItem10";
            this.toolStripMenuItem10.Size = new System.Drawing.Size( 211, 6 );
            // 
            // menuFileOpenVsq
            // 
            this.menuFileOpenVsq.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileOpenVsq.Name = "menuFileOpenVsq";
            this.menuFileOpenVsq.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileOpenVsq.Text = "Open VSQ/Vocaloid Midi(&V)";
            this.menuFileOpenVsq.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileOpenUst
            // 
            this.menuFileOpenUst.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileOpenUst.Name = "menuFileOpenUst";
            this.menuFileOpenUst.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileOpenUst.Text = "Open UTAU Project File(&U)";
            this.menuFileOpenUst.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileImport
            // 
            this.menuFileImport.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileImport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileImportVsq,
            this.menuFileImportMidi,
            this.menuFileImportUst} );
            this.menuFileImport.Name = "menuFileImport";
            this.menuFileImport.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileImport.Text = "Import(&I)";
            this.menuFileImport.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileImportVsq
            // 
            this.menuFileImportVsq.Name = "menuFileImportVsq";
            this.menuFileImportVsq.Size = new System.Drawing.Size( 160, 22 );
            this.menuFileImportVsq.Text = "VSQ File";
            // 
            // menuFileImportMidi
            // 
            this.menuFileImportMidi.Name = "menuFileImportMidi";
            this.menuFileImportMidi.Size = new System.Drawing.Size( 160, 22 );
            this.menuFileImportMidi.Text = "Standard MIDI";
            // 
            // menuFileImportUst
            // 
            this.menuFileImportUst.Name = "menuFileImportUst";
            this.menuFileImportUst.Size = new System.Drawing.Size( 160, 22 );
            this.menuFileImportUst.Text = "UTAU project file";
            // 
            // menuFileExport
            // 
            this.menuFileExport.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileExport.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileExportWave,
            this.menuFileExportParaWave,
            this.menuFileExportVsq,
            this.menuFileExportMidi,
            this.menuFileExportMusicXml,
            this.menuFileExportUst,
            this.menuFileExportVxt} );
            this.menuFileExport.Name = "menuFileExport";
            this.menuFileExport.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileExport.Text = "Export(&E)";
            this.menuFileExport.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileExportWave
            // 
            this.menuFileExportWave.Name = "menuFileExportWave";
            this.menuFileExportWave.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportWave.Text = "Wave";
            // 
            // menuFileExportParaWave
            // 
            this.menuFileExportParaWave.Name = "menuFileExportParaWave";
            this.menuFileExportParaWave.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportParaWave.Text = "Serial numbered Wave";
            // 
            // menuFileExportVsq
            // 
            this.menuFileExportVsq.Name = "menuFileExportVsq";
            this.menuFileExportVsq.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportVsq.Text = "VSQ File";
            // 
            // menuFileExportMidi
            // 
            this.menuFileExportMidi.Name = "menuFileExportMidi";
            this.menuFileExportMidi.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportMidi.Text = "MIDI";
            // 
            // menuFileExportMusicXml
            // 
            this.menuFileExportMusicXml.Name = "menuFileExportMusicXml";
            this.menuFileExportMusicXml.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportMusicXml.Text = "MusicXML";
            // 
            // menuFileExportUst
            // 
            this.menuFileExportUst.Name = "menuFileExportUst";
            this.menuFileExportUst.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportUst.Text = "UTAU Project File (current track)";
            // 
            // menuFileExportVxt
            // 
            this.menuFileExportVxt.Name = "menuFileExportVxt";
            this.menuFileExportVxt.Size = new System.Drawing.Size( 242, 22 );
            this.menuFileExportVxt.Text = "Metatext for vConnect";
            // 
            // toolStripMenuItem11
            // 
            this.toolStripMenuItem11.Name = "toolStripMenuItem11";
            this.toolStripMenuItem11.Size = new System.Drawing.Size( 211, 6 );
            // 
            // menuFileRecent
            // 
            this.menuFileRecent.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileRecent.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuFileRecentClear} );
            this.menuFileRecent.Name = "menuFileRecent";
            this.menuFileRecent.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileRecent.Text = "Recent Files(&R)";
            this.menuFileRecent.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuFileRecentClear
            // 
            this.menuFileRecentClear.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileRecentClear.Name = "menuFileRecentClear";
            this.menuFileRecentClear.Size = new System.Drawing.Size( 128, 22 );
            this.menuFileRecentClear.Text = "Clear Menu";
            this.menuFileRecentClear.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // toolStripMenuItem12
            // 
            this.toolStripMenuItem12.Name = "toolStripMenuItem12";
            this.toolStripMenuItem12.Size = new System.Drawing.Size( 211, 6 );
            // 
            // menuFileQuit
            // 
            this.menuFileQuit.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuFileQuit.Name = "menuFileQuit";
            this.menuFileQuit.Size = new System.Drawing.Size( 214, 22 );
            this.menuFileQuit.Text = "Quit(&Q)";
            this.menuFileQuit.TextImageRelation = System.Windows.Forms.TextImageRelation.Overlay;
            // 
            // menuEdit
            // 
            this.menuEdit.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuEditUndo,
            this.menuEditRedo,
            this.toolStripMenuItem5,
            this.menuEditCut,
            this.menuEditCopy,
            this.menuEditPaste,
            this.menuEditDelete,
            this.toolStripMenuItem19,
            this.menuEditAutoNormalizeMode,
            this.toolStripMenuItem20,
            this.menuEditSelectAll,
            this.menuEditSelectAllEvents} );
            this.menuEdit.Name = "menuEdit";
            this.menuEdit.Size = new System.Drawing.Size( 52, 20 );
            this.menuEdit.Text = "Edit(&E)";
            // 
            // menuEditUndo
            // 
            this.menuEditUndo.Name = "menuEditUndo";
            this.menuEditUndo.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditUndo.Text = "Undo(&U)";
            // 
            // menuEditRedo
            // 
            this.menuEditRedo.Name = "menuEditRedo";
            this.menuEditRedo.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem5
            // 
            this.toolStripMenuItem5.Name = "toolStripMenuItem5";
            this.toolStripMenuItem5.Size = new System.Drawing.Size( 192, 6 );
            // 
            // menuEditCut
            // 
            this.menuEditCut.Name = "menuEditCut";
            this.menuEditCut.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditCut.Text = "Cut(&T)";
            // 
            // menuEditCopy
            // 
            this.menuEditCopy.Name = "menuEditCopy";
            this.menuEditCopy.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditCopy.Text = "Copy(&C)";
            // 
            // menuEditPaste
            // 
            this.menuEditPaste.Name = "menuEditPaste";
            this.menuEditPaste.ShortcutKeyDisplayString = "";
            this.menuEditPaste.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditPaste.Text = "Paste(&P)";
            // 
            // menuEditDelete
            // 
            this.menuEditDelete.Name = "menuEditDelete";
            this.menuEditDelete.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditDelete.Text = "Delete(&D)";
            // 
            // toolStripMenuItem19
            // 
            this.toolStripMenuItem19.Name = "toolStripMenuItem19";
            this.toolStripMenuItem19.Size = new System.Drawing.Size( 192, 6 );
            // 
            // menuEditAutoNormalizeMode
            // 
            this.menuEditAutoNormalizeMode.Name = "menuEditAutoNormalizeMode";
            this.menuEditAutoNormalizeMode.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditAutoNormalizeMode.Text = "Auto Normalize Mode(&N)";
            // 
            // toolStripMenuItem20
            // 
            this.toolStripMenuItem20.Name = "toolStripMenuItem20";
            this.toolStripMenuItem20.Size = new System.Drawing.Size( 192, 6 );
            // 
            // menuEditSelectAll
            // 
            this.menuEditSelectAll.Name = "menuEditSelectAll";
            this.menuEditSelectAll.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditSelectAll.Text = "Select All(&A)";
            // 
            // menuEditSelectAllEvents
            // 
            this.menuEditSelectAllEvents.Name = "menuEditSelectAllEvents";
            this.menuEditSelectAllEvents.Size = new System.Drawing.Size( 195, 22 );
            this.menuEditSelectAllEvents.Text = "Select All Events(&E)";
            // 
            // menuVisual
            // 
            this.menuVisual.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisual.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuVisualControlTrack,
            this.menuVisualMixer,
            this.menuVisualWaveform,
            this.menuVisualIconPalette,
            this.menuVisualProperty,
            this.menuVisualOverview,
            this.menuVisualPluginUi,
            this.toolStripMenuItem1,
            this.menuVisualGridline,
            this.toolStripMenuItem2,
            this.menuVisualStartMarker,
            this.menuVisualEndMarker,
            this.toolStripMenuItem3,
            this.menuVisualLyrics,
            this.menuVisualNoteProperty,
            this.menuVisualPitchLine} );
            this.menuVisual.Name = "menuVisual";
            this.menuVisual.Size = new System.Drawing.Size( 58, 20 );
            this.menuVisual.Text = "View(&V)";
            // 
            // menuVisualControlTrack
            // 
            this.menuVisualControlTrack.Checked = true;
            this.menuVisualControlTrack.CheckOnClick = true;
            this.menuVisualControlTrack.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualControlTrack.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualControlTrack.Name = "menuVisualControlTrack";
            this.menuVisualControlTrack.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualControlTrack.Text = "Control Track(&C)";
            // 
            // menuVisualMixer
            // 
            this.menuVisualMixer.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualMixer.Name = "menuVisualMixer";
            this.menuVisualMixer.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualMixer.Text = "Mixer(&X)";
            // 
            // menuVisualWaveform
            // 
            this.menuVisualWaveform.CheckOnClick = true;
            this.menuVisualWaveform.Name = "menuVisualWaveform";
            this.menuVisualWaveform.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualWaveform.Text = "Waveform(&W)";
            // 
            // menuVisualIconPalette
            // 
            this.menuVisualIconPalette.CheckOnClick = true;
            this.menuVisualIconPalette.Name = "menuVisualIconPalette";
            this.menuVisualIconPalette.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualIconPalette.Text = "Icon Palette(&I)";
            // 
            // menuVisualProperty
            // 
            this.menuVisualProperty.CheckOnClick = true;
            this.menuVisualProperty.Name = "menuVisualProperty";
            this.menuVisualProperty.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualProperty.Text = "Property Window(&C)";
            // 
            // menuVisualOverview
            // 
            this.menuVisualOverview.CheckOnClick = true;
            this.menuVisualOverview.Name = "menuVisualOverview";
            this.menuVisualOverview.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualOverview.Text = "Overview(&O)";
            // 
            // menuVisualPluginUi
            // 
            this.menuVisualPluginUi.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuVisualPluginUiVocaloid1,
            this.menuVisualPluginUiVocaloid2,
            this.menuVisualPluginUiAquesTone} );
            this.menuVisualPluginUi.Name = "menuVisualPluginUi";
            this.menuVisualPluginUi.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualPluginUi.Text = "VSTi Plugin UI(&U)";
            // 
            // menuVisualPluginUiVocaloid1
            // 
            this.menuVisualPluginUiVocaloid1.Name = "menuVisualPluginUiVocaloid1";
            this.menuVisualPluginUiVocaloid1.Size = new System.Drawing.Size( 143, 22 );
            this.menuVisualPluginUiVocaloid1.Text = "VOCALOID1";
            // 
            // menuVisualPluginUiVocaloid2
            // 
            this.menuVisualPluginUiVocaloid2.Name = "menuVisualPluginUiVocaloid2";
            this.menuVisualPluginUiVocaloid2.Size = new System.Drawing.Size( 143, 22 );
            this.menuVisualPluginUiVocaloid2.Text = "VOCALOID2";
            // 
            // menuVisualPluginUiAquesTone
            // 
            this.menuVisualPluginUiAquesTone.Name = "menuVisualPluginUiAquesTone";
            this.menuVisualPluginUiAquesTone.Size = new System.Drawing.Size( 143, 22 );
            this.menuVisualPluginUiAquesTone.Text = "AquesTone(&A)";
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size( 210, 6 );
            // 
            // menuVisualGridline
            // 
            this.menuVisualGridline.CheckOnClick = true;
            this.menuVisualGridline.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualGridline.Name = "menuVisualGridline";
            this.menuVisualGridline.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualGridline.Text = "Grid Line(&G)";
            // 
            // toolStripMenuItem2
            // 
            this.toolStripMenuItem2.Name = "toolStripMenuItem2";
            this.toolStripMenuItem2.Size = new System.Drawing.Size( 210, 6 );
            // 
            // menuVisualStartMarker
            // 
            this.menuVisualStartMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualStartMarker.Name = "menuVisualStartMarker";
            this.menuVisualStartMarker.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualStartMarker.Text = "Start Marker(&S)";
            // 
            // menuVisualEndMarker
            // 
            this.menuVisualEndMarker.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualEndMarker.Name = "menuVisualEndMarker";
            this.menuVisualEndMarker.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualEndMarker.Text = "End Marker(&E)";
            // 
            // toolStripMenuItem3
            // 
            this.toolStripMenuItem3.Name = "toolStripMenuItem3";
            this.toolStripMenuItem3.Size = new System.Drawing.Size( 210, 6 );
            // 
            // menuVisualLyrics
            // 
            this.menuVisualLyrics.Checked = true;
            this.menuVisualLyrics.CheckOnClick = true;
            this.menuVisualLyrics.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualLyrics.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualLyrics.Name = "menuVisualLyrics";
            this.menuVisualLyrics.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualLyrics.Text = "Lyric/Phoneme(&L)";
            // 
            // menuVisualNoteProperty
            // 
            this.menuVisualNoteProperty.Checked = true;
            this.menuVisualNoteProperty.CheckOnClick = true;
            this.menuVisualNoteProperty.CheckState = System.Windows.Forms.CheckState.Checked;
            this.menuVisualNoteProperty.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Text;
            this.menuVisualNoteProperty.Name = "menuVisualNoteProperty";
            this.menuVisualNoteProperty.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualNoteProperty.Text = "Note Expression/Vibrato(&N)";
            // 
            // menuVisualPitchLine
            // 
            this.menuVisualPitchLine.CheckOnClick = true;
            this.menuVisualPitchLine.Name = "menuVisualPitchLine";
            this.menuVisualPitchLine.Size = new System.Drawing.Size( 213, 22 );
            this.menuVisualPitchLine.Text = "Pitch Line(&P)";
            // 
            // menuJob
            // 
            this.menuJob.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuJobNormalize,
            this.menuJobInsertBar,
            this.menuJobDeleteBar,
            this.menuJobRandomize,
            this.menuJobConnect,
            this.menuJobLyric,
            this.menuJobRewire,
            this.menuJobReloadVsti} );
            this.menuJob.Name = "menuJob";
            this.menuJob.Size = new System.Drawing.Size( 51, 20 );
            this.menuJob.Text = "Job(&J)";
            // 
            // menuJobNormalize
            // 
            this.menuJobNormalize.Name = "menuJobNormalize";
            this.menuJobNormalize.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobNormalize.Text = "Normalize Notes(&N)";
            // 
            // menuJobInsertBar
            // 
            this.menuJobInsertBar.Name = "menuJobInsertBar";
            this.menuJobInsertBar.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobInsertBar.Text = "Insert Bars(&I)";
            // 
            // menuJobDeleteBar
            // 
            this.menuJobDeleteBar.Name = "menuJobDeleteBar";
            this.menuJobDeleteBar.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobDeleteBar.Text = "Delete Bars(&D)";
            // 
            // menuJobRandomize
            // 
            this.menuJobRandomize.Name = "menuJobRandomize";
            this.menuJobRandomize.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobRandomize.Text = "Randomize(&R)";
            // 
            // menuJobConnect
            // 
            this.menuJobConnect.Name = "menuJobConnect";
            this.menuJobConnect.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobConnect.Text = "Connect Notes(&C)";
            // 
            // menuJobLyric
            // 
            this.menuJobLyric.Name = "menuJobLyric";
            this.menuJobLyric.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobLyric.Text = "Insert Lyrics(&L)";
            // 
            // menuJobRewire
            // 
            this.menuJobRewire.Enabled = false;
            this.menuJobRewire.Name = "menuJobRewire";
            this.menuJobRewire.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobRewire.Text = "Import ReWire Host Tempo(&T)";
            // 
            // menuJobReloadVsti
            // 
            this.menuJobReloadVsti.Name = "menuJobReloadVsti";
            this.menuJobReloadVsti.Size = new System.Drawing.Size( 223, 22 );
            this.menuJobReloadVsti.Text = "Reload VSTi(&R)";
            this.menuJobReloadVsti.Visible = false;
            // 
            // menuTrack
            // 
            this.menuTrack.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackOn,
            this.toolStripMenuItem21,
            this.menuTrackAdd,
            this.menuTrackCopy,
            this.menuTrackChangeName,
            this.menuTrackDelete,
            this.toolStripMenuItem22,
            this.menuTrackRenderCurrent,
            this.menuTrackRenderAll,
            this.toolStripMenuItem23,
            this.menuTrackOverlay,
            this.menuTrackRenderer,
            this.toolStripMenuItem4,
            this.menuTrackBgm} );
            this.menuTrack.Name = "menuTrack";
            this.menuTrack.Size = new System.Drawing.Size( 61, 20 );
            this.menuTrack.Text = "Track(&T)";
            // 
            // menuTrackOn
            // 
            this.menuTrackOn.Name = "menuTrackOn";
            this.menuTrackOn.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackOn.Text = "Track On(&K)";
            // 
            // toolStripMenuItem21
            // 
            this.toolStripMenuItem21.Name = "toolStripMenuItem21";
            this.toolStripMenuItem21.Size = new System.Drawing.Size( 193, 6 );
            // 
            // menuTrackAdd
            // 
            this.menuTrackAdd.Name = "menuTrackAdd";
            this.menuTrackAdd.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackAdd.Text = "Add Track(&A)";
            // 
            // menuTrackCopy
            // 
            this.menuTrackCopy.Name = "menuTrackCopy";
            this.menuTrackCopy.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackCopy.Text = "Copy Track(&C)";
            // 
            // menuTrackChangeName
            // 
            this.menuTrackChangeName.Name = "menuTrackChangeName";
            this.menuTrackChangeName.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackChangeName.Text = "Rename Track";
            // 
            // menuTrackDelete
            // 
            this.menuTrackDelete.Name = "menuTrackDelete";
            this.menuTrackDelete.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackDelete.Text = "Delete Track(&D)";
            // 
            // toolStripMenuItem22
            // 
            this.toolStripMenuItem22.Name = "toolStripMenuItem22";
            this.toolStripMenuItem22.Size = new System.Drawing.Size( 193, 6 );
            // 
            // menuTrackRenderCurrent
            // 
            this.menuTrackRenderCurrent.Name = "menuTrackRenderCurrent";
            this.menuTrackRenderCurrent.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackRenderCurrent.Text = "Render Current Track(&T)";
            // 
            // menuTrackRenderAll
            // 
            this.menuTrackRenderAll.Enabled = false;
            this.menuTrackRenderAll.Name = "menuTrackRenderAll";
            this.menuTrackRenderAll.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackRenderAll.Text = "Render All Tracks(&S)";
            // 
            // toolStripMenuItem23
            // 
            this.toolStripMenuItem23.Name = "toolStripMenuItem23";
            this.toolStripMenuItem23.Size = new System.Drawing.Size( 193, 6 );
            // 
            // menuTrackOverlay
            // 
            this.menuTrackOverlay.Name = "menuTrackOverlay";
            this.menuTrackOverlay.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackOverlay.Text = "Overlay(&O)";
            // 
            // menuTrackRenderer
            // 
            this.menuTrackRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuTrackRendererVOCALOID1,
            this.menuTrackRendererVOCALOID2,
            this.menuTrackRendererUtau,
            this.menuTrackRendererVCNT,
            this.menuTrackRendererAquesTone} );
            this.menuTrackRenderer.Name = "menuTrackRenderer";
            this.menuTrackRenderer.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackRenderer.Text = "Renderer(&R)";
            // 
            // menuTrackRendererVOCALOID1
            // 
            this.menuTrackRendererVOCALOID1.Name = "menuTrackRendererVOCALOID1";
            this.menuTrackRendererVOCALOID1.Size = new System.Drawing.Size( 176, 22 );
            this.menuTrackRendererVOCALOID1.Text = "VOCALOID1(&1)";
            // 
            // menuTrackRendererVOCALOID2
            // 
            this.menuTrackRendererVOCALOID2.Name = "menuTrackRendererVOCALOID2";
            this.menuTrackRendererVOCALOID2.Size = new System.Drawing.Size( 176, 22 );
            this.menuTrackRendererVOCALOID2.Text = "VOCALOID2(&2)";
            // 
            // menuTrackRendererUtau
            // 
            this.menuTrackRendererUtau.Name = "menuTrackRendererUtau";
            this.menuTrackRendererUtau.Size = new System.Drawing.Size( 176, 22 );
            this.menuTrackRendererUtau.Text = "UTAU(&3)";
            // 
            // menuTrackRendererVCNT
            // 
            this.menuTrackRendererVCNT.Name = "menuTrackRendererVCNT";
            this.menuTrackRendererVCNT.Size = new System.Drawing.Size( 176, 22 );
            this.menuTrackRendererVCNT.Text = "vConnect-STAND(&4)";
            // 
            // menuTrackRendererAquesTone
            // 
            this.menuTrackRendererAquesTone.Name = "menuTrackRendererAquesTone";
            this.menuTrackRendererAquesTone.Size = new System.Drawing.Size( 176, 22 );
            this.menuTrackRendererAquesTone.Text = "AquesTone(&5)";
            // 
            // toolStripMenuItem4
            // 
            this.toolStripMenuItem4.Name = "toolStripMenuItem4";
            this.toolStripMenuItem4.Size = new System.Drawing.Size( 193, 6 );
            // 
            // menuTrackBgm
            // 
            this.menuTrackBgm.Name = "menuTrackBgm";
            this.menuTrackBgm.Size = new System.Drawing.Size( 196, 22 );
            this.menuTrackBgm.Text = "BGM(&B)";
            // 
            // menuLyric
            // 
            this.menuLyric.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuLyricExpressionProperty,
            this.menuLyricVibratoProperty,
            this.menuLyricApplyUtauParameters,
            this.menuLyricPhonemeTransformation,
            this.menuLyricDictionary,
            this.menuLyricCopyVibratoToPreset} );
            this.menuLyric.Name = "menuLyric";
            this.menuLyric.Size = new System.Drawing.Size( 62, 20 );
            this.menuLyric.Text = "Lyrics(&L)";
            // 
            // menuLyricExpressionProperty
            // 
            this.menuLyricExpressionProperty.Name = "menuLyricExpressionProperty";
            this.menuLyricExpressionProperty.Size = new System.Drawing.Size( 235, 22 );
            this.menuLyricExpressionProperty.Text = "Note Expression Property(&E)";
            // 
            // menuLyricVibratoProperty
            // 
            this.menuLyricVibratoProperty.Name = "menuLyricVibratoProperty";
            this.menuLyricVibratoProperty.Size = new System.Drawing.Size( 235, 22 );
            this.menuLyricVibratoProperty.Text = "Note Vibrato Property(&V)";
            // 
            // menuLyricPhonemeTransformation
            // 
            this.menuLyricPhonemeTransformation.Name = "menuLyricPhonemeTransformation";
            this.menuLyricPhonemeTransformation.Size = new System.Drawing.Size( 235, 22 );
            this.menuLyricPhonemeTransformation.Text = "Phoneme Transformation(&T)";
            // 
            // menuLyricDictionary
            // 
            this.menuLyricDictionary.Name = "menuLyricDictionary";
            this.menuLyricDictionary.Size = new System.Drawing.Size( 235, 22 );
            this.menuLyricDictionary.Text = "User Word Dictionary(&C)";
            // 
            // menuLyricCopyVibratoToPreset
            // 
            this.menuLyricCopyVibratoToPreset.Name = "menuLyricCopyVibratoToPreset";
            this.menuLyricCopyVibratoToPreset.Size = new System.Drawing.Size( 235, 22 );
            this.menuLyricCopyVibratoToPreset.Text = "Copy vibrato config to preset(&P)";
            // 
            // menuScript
            // 
            this.menuScript.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuScriptUpdate} );
            this.menuScript.Name = "menuScript";
            this.menuScript.Size = new System.Drawing.Size( 63, 20 );
            this.menuScript.Text = "Script(&C)";
            // 
            // menuScriptUpdate
            // 
            this.menuScriptUpdate.Name = "menuScriptUpdate";
            this.menuScriptUpdate.Size = new System.Drawing.Size( 179, 22 );
            this.menuScriptUpdate.Text = "Update Script List(&U)";
            // 
            // menuSetting
            // 
            this.menuSetting.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPreference,
            this.menuSettingSequence,
            this.menuSettingPositionQuantize,
            this.toolStripMenuItem8,
            this.menuSettingGameControler,
            this.menuSettingPaletteTool,
            this.menuSettingShortcut,
            this.menuSettingVibratoPreset,
            this.toolStripMenuItem6,
            this.menuSettingDefaultSingerStyle} );
            this.menuSetting.Name = "menuSetting";
            this.menuSetting.Size = new System.Drawing.Size( 68, 20 );
            this.menuSetting.Text = "Setting(&S)";
            // 
            // menuSettingPreference
            // 
            this.menuSettingPreference.Name = "menuSettingPreference";
            this.menuSettingPreference.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingPreference.Text = "Preference(&P)";
            // 
            // menuSettingSequence
            // 
            this.menuSettingSequence.Name = "menuSettingSequence";
            this.menuSettingSequence.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingSequence.Text = "Sequence config(&S)";
            // 
            // menuSettingPositionQuantize
            // 
            this.menuSettingPositionQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingPositionQuantize04,
            this.menuSettingPositionQuantize08,
            this.menuSettingPositionQuantize16,
            this.menuSettingPositionQuantize32,
            this.menuSettingPositionQuantize64,
            this.menuSettingPositionQuantize128,
            this.menuSettingPositionQuantizeOff,
            this.toolStripMenuItem9,
            this.menuSettingPositionQuantizeTriplet} );
            this.menuSettingPositionQuantize.Name = "menuSettingPositionQuantize";
            this.menuSettingPositionQuantize.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingPositionQuantize.Text = "Quantize(&Q)";
            // 
            // menuSettingPositionQuantize04
            // 
            this.menuSettingPositionQuantize04.Name = "menuSettingPositionQuantize04";
            this.menuSettingPositionQuantize04.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize04.Text = "1/4";
            // 
            // menuSettingPositionQuantize08
            // 
            this.menuSettingPositionQuantize08.Name = "menuSettingPositionQuantize08";
            this.menuSettingPositionQuantize08.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize08.Text = "1/8";
            // 
            // menuSettingPositionQuantize16
            // 
            this.menuSettingPositionQuantize16.Name = "menuSettingPositionQuantize16";
            this.menuSettingPositionQuantize16.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize16.Text = "1/16";
            // 
            // menuSettingPositionQuantize32
            // 
            this.menuSettingPositionQuantize32.Name = "menuSettingPositionQuantize32";
            this.menuSettingPositionQuantize32.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize32.Text = "1/32";
            // 
            // menuSettingPositionQuantize64
            // 
            this.menuSettingPositionQuantize64.Name = "menuSettingPositionQuantize64";
            this.menuSettingPositionQuantize64.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize64.Text = "1/64";
            // 
            // menuSettingPositionQuantize128
            // 
            this.menuSettingPositionQuantize128.Name = "menuSettingPositionQuantize128";
            this.menuSettingPositionQuantize128.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantize128.Text = "1/128";
            // 
            // menuSettingPositionQuantizeOff
            // 
            this.menuSettingPositionQuantizeOff.Name = "menuSettingPositionQuantizeOff";
            this.menuSettingPositionQuantizeOff.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantizeOff.Text = "Off";
            // 
            // toolStripMenuItem9
            // 
            this.toolStripMenuItem9.Name = "toolStripMenuItem9";
            this.toolStripMenuItem9.Size = new System.Drawing.Size( 100, 6 );
            // 
            // menuSettingPositionQuantizeTriplet
            // 
            this.menuSettingPositionQuantizeTriplet.Name = "menuSettingPositionQuantizeTriplet";
            this.menuSettingPositionQuantizeTriplet.Size = new System.Drawing.Size( 103, 22 );
            this.menuSettingPositionQuantizeTriplet.Text = "Triplet";
            // 
            // toolStripMenuItem8
            // 
            this.toolStripMenuItem8.Name = "toolStripMenuItem8";
            this.toolStripMenuItem8.Size = new System.Drawing.Size( 197, 6 );
            // 
            // menuSettingGameControler
            // 
            this.menuSettingGameControler.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuSettingGameControlerSetting,
            this.menuSettingGameControlerLoad,
            this.menuSettingGameControlerRemove} );
            this.menuSettingGameControler.Name = "menuSettingGameControler";
            this.menuSettingGameControler.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingGameControler.Text = "Game Controler(&G)";
            // 
            // menuSettingGameControlerSetting
            // 
            this.menuSettingGameControlerSetting.Name = "menuSettingGameControlerSetting";
            this.menuSettingGameControlerSetting.Size = new System.Drawing.Size( 127, 22 );
            this.menuSettingGameControlerSetting.Text = "Setting(&S)";
            // 
            // menuSettingGameControlerLoad
            // 
            this.menuSettingGameControlerLoad.Name = "menuSettingGameControlerLoad";
            this.menuSettingGameControlerLoad.Size = new System.Drawing.Size( 127, 22 );
            this.menuSettingGameControlerLoad.Text = "Load(&L)";
            // 
            // menuSettingGameControlerRemove
            // 
            this.menuSettingGameControlerRemove.Name = "menuSettingGameControlerRemove";
            this.menuSettingGameControlerRemove.Size = new System.Drawing.Size( 127, 22 );
            this.menuSettingGameControlerRemove.Text = "Remove(&R)";
            // 
            // menuSettingPaletteTool
            // 
            this.menuSettingPaletteTool.Name = "menuSettingPaletteTool";
            this.menuSettingPaletteTool.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingPaletteTool.Text = "Palette Tool(&T)";
            // 
            // menuSettingShortcut
            // 
            this.menuSettingShortcut.Name = "menuSettingShortcut";
            this.menuSettingShortcut.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingShortcut.Text = "Shortcut Key(&K)";
            // 
            // menuSettingVibratoPreset
            // 
            this.menuSettingVibratoPreset.Name = "menuSettingVibratoPreset";
            this.menuSettingVibratoPreset.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingVibratoPreset.Text = "Vibrato preset(&V)";
            // 
            // toolStripMenuItem6
            // 
            this.toolStripMenuItem6.Name = "toolStripMenuItem6";
            this.toolStripMenuItem6.Size = new System.Drawing.Size( 197, 6 );
            // 
            // menuSettingDefaultSingerStyle
            // 
            this.menuSettingDefaultSingerStyle.Name = "menuSettingDefaultSingerStyle";
            this.menuSettingDefaultSingerStyle.Size = new System.Drawing.Size( 200, 22 );
            this.menuSettingDefaultSingerStyle.Text = "Singing Style Defaults(&D)";
            // 
            // menuHelp
            // 
            this.menuHelp.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHelpAbout,
            this.menuHelpManual,
            this.menuHelpLog,
            this.menuHelpDebug} );
            this.menuHelp.Name = "menuHelp";
            this.menuHelp.Size = new System.Drawing.Size( 56, 20 );
            this.menuHelp.Text = "Help(&H)";
            // 
            // menuHelpAbout
            // 
            this.menuHelpAbout.Name = "menuHelpAbout";
            this.menuHelpAbout.Size = new System.Drawing.Size( 164, 22 );
            this.menuHelpAbout.Text = "About Cadencii(&A)";
            // 
            // menuHelpManual
            // 
            this.menuHelpManual.Name = "menuHelpManual";
            this.menuHelpManual.Size = new System.Drawing.Size( 164, 22 );
            this.menuHelpManual.Text = "Manual (PDF)";
            // 
            // menuHelpLog
            // 
            this.menuHelpLog.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHelpLogSwitch,
            this.menuHelpLogOpen} );
            this.menuHelpLog.Name = "menuHelpLog";
            this.menuHelpLog.Size = new System.Drawing.Size( 164, 22 );
            this.menuHelpLog.Text = "Log(&L)";
            // 
            // menuHelpLogSwitch
            // 
            this.menuHelpLogSwitch.CheckOnClick = true;
            this.menuHelpLogSwitch.Name = "menuHelpLogSwitch";
            this.menuHelpLogSwitch.Size = new System.Drawing.Size( 140, 22 );
            this.menuHelpLogSwitch.Text = "Enable Log(&L)";
            // 
            // menuHelpLogOpen
            // 
            this.menuHelpLogOpen.Name = "menuHelpLogOpen";
            this.menuHelpLogOpen.Size = new System.Drawing.Size( 140, 22 );
            this.menuHelpLogOpen.Text = "Open(&O)";
            // 
            // menuHelpDebug
            // 
            this.menuHelpDebug.Name = "menuHelpDebug";
            this.menuHelpDebug.Size = new System.Drawing.Size( 164, 22 );
            this.menuHelpDebug.Text = "Debug";
            this.menuHelpDebug.Visible = false;
            // 
            // menuHidden
            // 
            this.menuHidden.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.menuHiddenEditLyric,
            this.menuHiddenEditFlipToolPointerPencil,
            this.menuHiddenEditFlipToolPointerEraser,
            this.menuHiddenVisualForwardParameter,
            this.menuHiddenVisualBackwardParameter,
            this.menuHiddenTrackNext,
            this.menuHiddenTrackBack,
            this.menuHiddenCopy,
            this.menuHiddenPaste,
            this.menuHiddenCut,
            this.menuHiddenSelectForward,
            this.menuHiddenSelectBackward,
            this.menuHiddenMoveUp,
            this.menuHiddenMoveDown,
            this.menuHiddenMoveLeft,
            this.menuHiddenMoveRight,
            this.menuHiddenLengthen,
            this.menuHiddenShorten,
            this.menuHiddenGoToStartMarker,
            this.menuHiddenGoToEndMarker,
            this.menuHiddenPlayFromStartMarker,
            this.menuHiddenFlipCurveOnPianorollMode,
            this.menuHiddenPrintPoToCSV} );
            this.menuHidden.Name = "menuHidden";
            this.menuHidden.Size = new System.Drawing.Size( 79, 20 );
            this.menuHidden.Text = "MenuHidden";
            this.menuHidden.Visible = false;
            // 
            // menuHiddenEditLyric
            // 
            this.menuHiddenEditLyric.Name = "menuHiddenEditLyric";
            this.menuHiddenEditLyric.ShortcutKeys = System.Windows.Forms.Keys.F2;
            this.menuHiddenEditLyric.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenEditLyric.Text = "Start Lyric Input";
            this.menuHiddenEditLyric.Visible = false;
            // 
            // menuHiddenEditFlipToolPointerPencil
            // 
            this.menuHiddenEditFlipToolPointerPencil.Name = "menuHiddenEditFlipToolPointerPencil";
            this.menuHiddenEditFlipToolPointerPencil.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            this.menuHiddenEditFlipToolPointerPencil.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenEditFlipToolPointerPencil.Text = "Change Tool Pointer / Pencil";
            this.menuHiddenEditFlipToolPointerPencil.Visible = false;
            // 
            // menuHiddenEditFlipToolPointerEraser
            // 
            this.menuHiddenEditFlipToolPointerEraser.Name = "menuHiddenEditFlipToolPointerEraser";
            this.menuHiddenEditFlipToolPointerEraser.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.menuHiddenEditFlipToolPointerEraser.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenEditFlipToolPointerEraser.Text = "Change Tool Pointer/ Eraser";
            this.menuHiddenEditFlipToolPointerEraser.Visible = false;
            // 
            // menuHiddenVisualForwardParameter
            // 
            this.menuHiddenVisualForwardParameter.Name = "menuHiddenVisualForwardParameter";
            this.menuHiddenVisualForwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.Next)));
            this.menuHiddenVisualForwardParameter.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenVisualForwardParameter.Text = "Next Control Curve";
            this.menuHiddenVisualForwardParameter.Visible = false;
            // 
            // menuHiddenVisualBackwardParameter
            // 
            this.menuHiddenVisualBackwardParameter.Name = "menuHiddenVisualBackwardParameter";
            this.menuHiddenVisualBackwardParameter.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt)
                        | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenVisualBackwardParameter.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenVisualBackwardParameter.Text = "Previous Control Curve";
            this.menuHiddenVisualBackwardParameter.Visible = false;
            // 
            // menuHiddenTrackNext
            // 
            this.menuHiddenTrackNext.Name = "menuHiddenTrackNext";
            this.menuHiddenTrackNext.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Next)));
            this.menuHiddenTrackNext.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenTrackNext.Text = "Next Track";
            this.menuHiddenTrackNext.Visible = false;
            // 
            // menuHiddenTrackBack
            // 
            this.menuHiddenTrackBack.Name = "menuHiddenTrackBack";
            this.menuHiddenTrackBack.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.PageUp)));
            this.menuHiddenTrackBack.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenTrackBack.Text = "Previous Track";
            this.menuHiddenTrackBack.Visible = false;
            // 
            // menuHiddenCopy
            // 
            this.menuHiddenCopy.Name = "menuHiddenCopy";
            this.menuHiddenCopy.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenCopy.Text = "Copy";
            // 
            // menuHiddenPaste
            // 
            this.menuHiddenPaste.Name = "menuHiddenPaste";
            this.menuHiddenPaste.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenPaste.Text = "Paste";
            // 
            // menuHiddenCut
            // 
            this.menuHiddenCut.Name = "menuHiddenCut";
            this.menuHiddenCut.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenCut.Text = "Cut";
            // 
            // menuHiddenSelectForward
            // 
            this.menuHiddenSelectForward.Name = "menuHiddenSelectForward";
            this.menuHiddenSelectForward.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.Right)));
            this.menuHiddenSelectForward.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenSelectForward.Text = "Select Forward";
            // 
            // menuHiddenSelectBackward
            // 
            this.menuHiddenSelectBackward.Name = "menuHiddenSelectBackward";
            this.menuHiddenSelectBackward.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.Left)));
            this.menuHiddenSelectBackward.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenSelectBackward.Text = "Select Backward";
            // 
            // menuHiddenMoveUp
            // 
            this.menuHiddenMoveUp.Name = "menuHiddenMoveUp";
            this.menuHiddenMoveUp.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenMoveUp.Text = "Move Up";
            // 
            // menuHiddenMoveDown
            // 
            this.menuHiddenMoveDown.Name = "menuHiddenMoveDown";
            this.menuHiddenMoveDown.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenMoveDown.Text = "Move Down";
            // 
            // menuHiddenMoveLeft
            // 
            this.menuHiddenMoveLeft.Name = "menuHiddenMoveLeft";
            this.menuHiddenMoveLeft.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenMoveLeft.Text = "Move Left";
            // 
            // menuHiddenMoveRight
            // 
            this.menuHiddenMoveRight.Name = "menuHiddenMoveRight";
            this.menuHiddenMoveRight.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenMoveRight.Text = "Move Right";
            // 
            // menuHiddenLengthen
            // 
            this.menuHiddenLengthen.Name = "menuHiddenLengthen";
            this.menuHiddenLengthen.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenLengthen.Text = "Lengthen";
            // 
            // menuHiddenShorten
            // 
            this.menuHiddenShorten.Name = "menuHiddenShorten";
            this.menuHiddenShorten.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenShorten.Text = "Shorten";
            // 
            // menuHiddenGoToStartMarker
            // 
            this.menuHiddenGoToStartMarker.Name = "menuHiddenGoToStartMarker";
            this.menuHiddenGoToStartMarker.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenGoToStartMarker.Text = "GoTo Start Marker";
            // 
            // menuHiddenGoToEndMarker
            // 
            this.menuHiddenGoToEndMarker.Name = "menuHiddenGoToEndMarker";
            this.menuHiddenGoToEndMarker.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenGoToEndMarker.Text = "GoTo End Marker";
            // 
            // menuHiddenPlayFromStartMarker
            // 
            this.menuHiddenPlayFromStartMarker.Name = "menuHiddenPlayFromStartMarker";
            this.menuHiddenPlayFromStartMarker.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenPlayFromStartMarker.Text = "Play From Start Marker";
            // 
            // menuHiddenFlipCurveOnPianorollMode
            // 
            this.menuHiddenFlipCurveOnPianorollMode.Name = "menuHiddenFlipCurveOnPianorollMode";
            this.menuHiddenFlipCurveOnPianorollMode.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenFlipCurveOnPianorollMode.Text = "Change pitch drawing mode";
            // 
            // menuHiddenPrintPoToCSV
            // 
            this.menuHiddenPrintPoToCSV.Name = "menuHiddenPrintPoToCSV";
            this.menuHiddenPrintPoToCSV.Size = new System.Drawing.Size( 267, 22 );
            this.menuHiddenPrintPoToCSV.Text = "Print language configs to CSV";
            // 
            // cMenuPiano
            // 
            this.cMenuPiano.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoPointer,
            this.cMenuPianoPencil,
            this.cMenuPianoEraser,
            this.cMenuPianoPaletteTool,
            this.toolStripSeparator15,
            this.cMenuPianoCurve,
            this.toolStripMenuItem13,
            this.cMenuPianoFixed,
            this.cMenuPianoQuantize,
            this.cMenuPianoGrid,
            this.toolStripMenuItem14,
            this.cMenuPianoUndo,
            this.cMenuPianoRedo,
            this.toolStripMenuItem15,
            this.cMenuPianoCut,
            this.cMenuPianoCopy,
            this.cMenuPianoPaste,
            this.cMenuPianoDelete,
            this.toolStripMenuItem16,
            this.cMenuPianoSelectAll,
            this.cMenuPianoSelectAllEvents,
            this.toolStripMenuItem17,
            this.cMenuPianoImportLyric,
            this.cMenuPianoExpressionProperty,
            this.cMenuPianoVibratoProperty} );
            this.cMenuPiano.Name = "cMenuPiano";
            this.cMenuPiano.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            this.cMenuPiano.ShowCheckMargin = true;
            this.cMenuPiano.ShowImageMargin = false;
            this.cMenuPiano.Size = new System.Drawing.Size( 217, 458 );
            // 
            // cMenuPianoPointer
            // 
            this.cMenuPianoPointer.Name = "cMenuPianoPointer";
            this.cMenuPianoPointer.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoPointer.Text = "Arrow(&A)";
            // 
            // cMenuPianoPencil
            // 
            this.cMenuPianoPencil.Name = "cMenuPianoPencil";
            this.cMenuPianoPencil.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoPencil.Text = "Pencil(&W)";
            // 
            // cMenuPianoEraser
            // 
            this.cMenuPianoEraser.Name = "cMenuPianoEraser";
            this.cMenuPianoEraser.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoEraser.Text = "Eraser(&E)";
            // 
            // cMenuPianoPaletteTool
            // 
            this.cMenuPianoPaletteTool.Name = "cMenuPianoPaletteTool";
            this.cMenuPianoPaletteTool.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoPaletteTool.Text = "Palette Tool";
            // 
            // toolStripSeparator15
            // 
            this.toolStripSeparator15.Name = "toolStripSeparator15";
            this.toolStripSeparator15.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoCurve
            // 
            this.cMenuPianoCurve.Name = "cMenuPianoCurve";
            this.cMenuPianoCurve.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoCurve.Text = "Curve(&V)";
            // 
            // toolStripMenuItem13
            // 
            this.toolStripMenuItem13.Name = "toolStripMenuItem13";
            this.toolStripMenuItem13.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoFixed
            // 
            this.cMenuPianoFixed.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoFixed01,
            this.cMenuPianoFixed02,
            this.cMenuPianoFixed04,
            this.cMenuPianoFixed08,
            this.cMenuPianoFixed16,
            this.cMenuPianoFixed32,
            this.cMenuPianoFixed64,
            this.cMenuPianoFixed128,
            this.cMenuPianoFixedOff,
            this.toolStripMenuItem18,
            this.cMenuPianoFixedTriplet,
            this.cMenuPianoFixedDotted} );
            this.cMenuPianoFixed.Name = "cMenuPianoFixed";
            this.cMenuPianoFixed.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoFixed.Text = "Note Fixed Length(&N)";
            // 
            // cMenuPianoFixed01
            // 
            this.cMenuPianoFixed01.Name = "cMenuPianoFixed01";
            this.cMenuPianoFixed01.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed01.Text = "1/ 1 [1920]";
            // 
            // cMenuPianoFixed02
            // 
            this.cMenuPianoFixed02.Name = "cMenuPianoFixed02";
            this.cMenuPianoFixed02.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed02.Text = "1/ 2 [960]";
            // 
            // cMenuPianoFixed04
            // 
            this.cMenuPianoFixed04.Name = "cMenuPianoFixed04";
            this.cMenuPianoFixed04.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed04.Text = "1/ 4 [480]";
            // 
            // cMenuPianoFixed08
            // 
            this.cMenuPianoFixed08.Name = "cMenuPianoFixed08";
            this.cMenuPianoFixed08.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed08.Text = "1/ 8 [240]";
            // 
            // cMenuPianoFixed16
            // 
            this.cMenuPianoFixed16.Name = "cMenuPianoFixed16";
            this.cMenuPianoFixed16.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed16.Text = "1/16 [120]";
            // 
            // cMenuPianoFixed32
            // 
            this.cMenuPianoFixed32.Name = "cMenuPianoFixed32";
            this.cMenuPianoFixed32.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed32.Text = "1/32 [60]";
            // 
            // cMenuPianoFixed64
            // 
            this.cMenuPianoFixed64.Name = "cMenuPianoFixed64";
            this.cMenuPianoFixed64.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed64.Text = "1/64 [30]";
            // 
            // cMenuPianoFixed128
            // 
            this.cMenuPianoFixed128.Name = "cMenuPianoFixed128";
            this.cMenuPianoFixed128.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixed128.Text = "1/128[15]";
            // 
            // cMenuPianoFixedOff
            // 
            this.cMenuPianoFixedOff.Name = "cMenuPianoFixedOff";
            this.cMenuPianoFixedOff.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixedOff.Text = "オフ";
            // 
            // toolStripMenuItem18
            // 
            this.toolStripMenuItem18.Name = "toolStripMenuItem18";
            this.toolStripMenuItem18.Size = new System.Drawing.Size( 125, 6 );
            // 
            // cMenuPianoFixedTriplet
            // 
            this.cMenuPianoFixedTriplet.Name = "cMenuPianoFixedTriplet";
            this.cMenuPianoFixedTriplet.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixedTriplet.Text = "3連符";
            // 
            // cMenuPianoFixedDotted
            // 
            this.cMenuPianoFixedDotted.Name = "cMenuPianoFixedDotted";
            this.cMenuPianoFixedDotted.Size = new System.Drawing.Size( 128, 22 );
            this.cMenuPianoFixedDotted.Text = "付点";
            // 
            // cMenuPianoQuantize
            // 
            this.cMenuPianoQuantize.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuPianoQuantize04,
            this.cMenuPianoQuantize08,
            this.cMenuPianoQuantize16,
            this.cMenuPianoQuantize32,
            this.cMenuPianoQuantize64,
            this.cMenuPianoQuantize128,
            this.cMenuPianoQuantizeOff,
            this.toolStripMenuItem26,
            this.cMenuPianoQuantizeTriplet} );
            this.cMenuPianoQuantize.Name = "cMenuPianoQuantize";
            this.cMenuPianoQuantize.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoQuantize.Text = "Quantize(&Q)";
            // 
            // cMenuPianoQuantize04
            // 
            this.cMenuPianoQuantize04.Name = "cMenuPianoQuantize04";
            this.cMenuPianoQuantize04.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize04.Text = "1/4";
            // 
            // cMenuPianoQuantize08
            // 
            this.cMenuPianoQuantize08.Name = "cMenuPianoQuantize08";
            this.cMenuPianoQuantize08.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize08.Text = "1/8";
            // 
            // cMenuPianoQuantize16
            // 
            this.cMenuPianoQuantize16.Name = "cMenuPianoQuantize16";
            this.cMenuPianoQuantize16.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize16.Text = "1/16";
            // 
            // cMenuPianoQuantize32
            // 
            this.cMenuPianoQuantize32.Name = "cMenuPianoQuantize32";
            this.cMenuPianoQuantize32.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize32.Text = "1/32";
            // 
            // cMenuPianoQuantize64
            // 
            this.cMenuPianoQuantize64.Name = "cMenuPianoQuantize64";
            this.cMenuPianoQuantize64.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize64.Text = "1/64";
            // 
            // cMenuPianoQuantize128
            // 
            this.cMenuPianoQuantize128.Name = "cMenuPianoQuantize128";
            this.cMenuPianoQuantize128.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantize128.Text = "1/128";
            // 
            // cMenuPianoQuantizeOff
            // 
            this.cMenuPianoQuantizeOff.Name = "cMenuPianoQuantizeOff";
            this.cMenuPianoQuantizeOff.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantizeOff.Text = "オフ";
            // 
            // toolStripMenuItem26
            // 
            this.toolStripMenuItem26.Name = "toolStripMenuItem26";
            this.toolStripMenuItem26.Size = new System.Drawing.Size( 97, 6 );
            // 
            // cMenuPianoQuantizeTriplet
            // 
            this.cMenuPianoQuantizeTriplet.Name = "cMenuPianoQuantizeTriplet";
            this.cMenuPianoQuantizeTriplet.Size = new System.Drawing.Size( 100, 22 );
            this.cMenuPianoQuantizeTriplet.Text = "3連符";
            // 
            // cMenuPianoGrid
            // 
            this.cMenuPianoGrid.Name = "cMenuPianoGrid";
            this.cMenuPianoGrid.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoGrid.Text = "Show/Hide Grid Line(&S)";
            // 
            // toolStripMenuItem14
            // 
            this.toolStripMenuItem14.Name = "toolStripMenuItem14";
            this.toolStripMenuItem14.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoUndo
            // 
            this.cMenuPianoUndo.Name = "cMenuPianoUndo";
            this.cMenuPianoUndo.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoUndo.Text = "Undo(&U)";
            // 
            // cMenuPianoRedo
            // 
            this.cMenuPianoRedo.Name = "cMenuPianoRedo";
            this.cMenuPianoRedo.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem15
            // 
            this.toolStripMenuItem15.Name = "toolStripMenuItem15";
            this.toolStripMenuItem15.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoCut
            // 
            this.cMenuPianoCut.Name = "cMenuPianoCut";
            this.cMenuPianoCut.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoCut.Text = "Cut(&T)";
            // 
            // cMenuPianoCopy
            // 
            this.cMenuPianoCopy.Name = "cMenuPianoCopy";
            this.cMenuPianoCopy.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoCopy.Text = "Copy(&C)";
            // 
            // cMenuPianoPaste
            // 
            this.cMenuPianoPaste.Name = "cMenuPianoPaste";
            this.cMenuPianoPaste.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoPaste.Text = "Paste(&P)";
            // 
            // cMenuPianoDelete
            // 
            this.cMenuPianoDelete.Name = "cMenuPianoDelete";
            this.cMenuPianoDelete.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoDelete.Text = "Delete(&D)";
            // 
            // toolStripMenuItem16
            // 
            this.toolStripMenuItem16.Name = "toolStripMenuItem16";
            this.toolStripMenuItem16.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoSelectAll
            // 
            this.cMenuPianoSelectAll.Name = "cMenuPianoSelectAll";
            this.cMenuPianoSelectAll.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoSelectAll.Text = "Select All(&A)";
            // 
            // cMenuPianoSelectAllEvents
            // 
            this.cMenuPianoSelectAllEvents.Name = "cMenuPianoSelectAllEvents";
            this.cMenuPianoSelectAllEvents.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoSelectAllEvents.Text = "Select All Events(&E)";
            // 
            // toolStripMenuItem17
            // 
            this.toolStripMenuItem17.Name = "toolStripMenuItem17";
            this.toolStripMenuItem17.Size = new System.Drawing.Size( 213, 6 );
            // 
            // cMenuPianoImportLyric
            // 
            this.cMenuPianoImportLyric.Name = "cMenuPianoImportLyric";
            this.cMenuPianoImportLyric.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoImportLyric.Text = "Insert Lyrics(&L)";
            // 
            // cMenuPianoExpressionProperty
            // 
            this.cMenuPianoExpressionProperty.Name = "cMenuPianoExpressionProperty";
            this.cMenuPianoExpressionProperty.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoExpressionProperty.Text = "Note Expression Property(&P)";
            // 
            // cMenuPianoVibratoProperty
            // 
            this.cMenuPianoVibratoProperty.Name = "cMenuPianoVibratoProperty";
            this.cMenuPianoVibratoProperty.Size = new System.Drawing.Size( 216, 22 );
            this.cMenuPianoVibratoProperty.Text = "Note Vibrato Property";
            // 
            // cMenuTrackTab
            // 
            this.cMenuTrackTab.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackTabTrackOn,
            this.toolStripMenuItem24,
            this.cMenuTrackTabAdd,
            this.cMenuTrackTabCopy,
            this.cMenuTrackTabChangeName,
            this.cMenuTrackTabDelete,
            this.toolStripMenuItem25,
            this.cMenuTrackTabRenderCurrent,
            this.cMenuTrackTabRenderAll,
            this.toolStripMenuItem27,
            this.cMenuTrackTabOverlay,
            this.cMenuTrackTabRenderer} );
            this.cMenuTrackTab.Name = "cMenuTrackTab";
            this.cMenuTrackTab.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            this.cMenuTrackTab.ShowCheckMargin = true;
            this.cMenuTrackTab.ShowImageMargin = false;
            this.cMenuTrackTab.Size = new System.Drawing.Size( 197, 220 );
            // 
            // cMenuTrackTabTrackOn
            // 
            this.cMenuTrackTabTrackOn.Name = "cMenuTrackTabTrackOn";
            this.cMenuTrackTabTrackOn.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabTrackOn.Text = "Track On(&K)";
            // 
            // toolStripMenuItem24
            // 
            this.toolStripMenuItem24.Name = "toolStripMenuItem24";
            this.toolStripMenuItem24.Size = new System.Drawing.Size( 193, 6 );
            // 
            // cMenuTrackTabAdd
            // 
            this.cMenuTrackTabAdd.Name = "cMenuTrackTabAdd";
            this.cMenuTrackTabAdd.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabAdd.Text = "Add Track(&A)";
            // 
            // cMenuTrackTabCopy
            // 
            this.cMenuTrackTabCopy.Name = "cMenuTrackTabCopy";
            this.cMenuTrackTabCopy.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabCopy.Text = "Copy Track(&C)";
            // 
            // cMenuTrackTabChangeName
            // 
            this.cMenuTrackTabChangeName.Name = "cMenuTrackTabChangeName";
            this.cMenuTrackTabChangeName.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabChangeName.Text = "Rename Track";
            // 
            // cMenuTrackTabDelete
            // 
            this.cMenuTrackTabDelete.Name = "cMenuTrackTabDelete";
            this.cMenuTrackTabDelete.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabDelete.Text = "Delete Track(&D)";
            // 
            // toolStripMenuItem25
            // 
            this.toolStripMenuItem25.Name = "toolStripMenuItem25";
            this.toolStripMenuItem25.Size = new System.Drawing.Size( 193, 6 );
            // 
            // cMenuTrackTabRenderCurrent
            // 
            this.cMenuTrackTabRenderCurrent.Name = "cMenuTrackTabRenderCurrent";
            this.cMenuTrackTabRenderCurrent.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabRenderCurrent.Text = "Render Current Track(&T)";
            // 
            // cMenuTrackTabRenderAll
            // 
            this.cMenuTrackTabRenderAll.Name = "cMenuTrackTabRenderAll";
            this.cMenuTrackTabRenderAll.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabRenderAll.Text = "Render All Tracks(&S)";
            // 
            // toolStripMenuItem27
            // 
            this.toolStripMenuItem27.Name = "toolStripMenuItem27";
            this.toolStripMenuItem27.Size = new System.Drawing.Size( 193, 6 );
            // 
            // cMenuTrackTabOverlay
            // 
            this.cMenuTrackTabOverlay.Name = "cMenuTrackTabOverlay";
            this.cMenuTrackTabOverlay.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabOverlay.Text = "Overlay(&O)";
            // 
            // cMenuTrackTabRenderer
            // 
            this.cMenuTrackTabRenderer.DropDownItems.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackTabRendererVOCALOID1,
            this.cMenuTrackTabRendererVOCALOID2,
            this.cMenuTrackTabRendererUtau,
            this.cMenuTrackTabRendererStraight,
            this.cMenuTrackTabRendererAquesTone} );
            this.cMenuTrackTabRenderer.Name = "cMenuTrackTabRenderer";
            this.cMenuTrackTabRenderer.Size = new System.Drawing.Size( 196, 22 );
            this.cMenuTrackTabRenderer.Text = "Renderer(&R)";
            // 
            // cMenuTrackTabRendererVOCALOID1
            // 
            this.cMenuTrackTabRendererVOCALOID1.Name = "cMenuTrackTabRendererVOCALOID1";
            this.cMenuTrackTabRendererVOCALOID1.Size = new System.Drawing.Size( 180, 22 );
            this.cMenuTrackTabRendererVOCALOID1.Text = "VOCALOID1(&1)";
            // 
            // cMenuTrackTabRendererVOCALOID2
            // 
            this.cMenuTrackTabRendererVOCALOID2.Name = "cMenuTrackTabRendererVOCALOID2";
            this.cMenuTrackTabRendererVOCALOID2.Size = new System.Drawing.Size( 180, 22 );
            this.cMenuTrackTabRendererVOCALOID2.Text = "VOCALOID2(&2)";
            // 
            // cMenuTrackTabRendererUtau
            // 
            this.cMenuTrackTabRendererUtau.Name = "cMenuTrackTabRendererUtau";
            this.cMenuTrackTabRendererUtau.Size = new System.Drawing.Size( 180, 22 );
            this.cMenuTrackTabRendererUtau.Text = "UTAU(&3)";
            // 
            // cMenuTrackTabRendererStraight
            // 
            this.cMenuTrackTabRendererStraight.Name = "cMenuTrackTabRendererStraight";
            this.cMenuTrackTabRendererStraight.Size = new System.Drawing.Size( 180, 22 );
            this.cMenuTrackTabRendererStraight.Text = "vConnect-STAND(&4) ";
            // 
            // cMenuTrackTabRendererAquesTone
            // 
            this.cMenuTrackTabRendererAquesTone.Name = "cMenuTrackTabRendererAquesTone";
            this.cMenuTrackTabRendererAquesTone.Size = new System.Drawing.Size( 180, 22 );
            this.cMenuTrackTabRendererAquesTone.Text = "AquesTone(&5)";
            // 
            // cMenuTrackSelector
            // 
            this.cMenuTrackSelector.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.cMenuTrackSelectorPointer,
            this.cMenuTrackSelectorPencil,
            this.cMenuTrackSelectorLine,
            this.cMenuTrackSelectorEraser,
            this.cMenuTrackSelectorPaletteTool,
            this.toolStripSeparator14,
            this.cMenuTrackSelectorCurve,
            this.toolStripMenuItem28,
            this.cMenuTrackSelectorUndo,
            this.cMenuTrackSelectorRedo,
            this.toolStripMenuItem29,
            this.cMenuTrackSelectorCut,
            this.cMenuTrackSelectorCopy,
            this.cMenuTrackSelectorPaste,
            this.cMenuTrackSelectorDelete,
            this.cMenuTrackSelectorDeleteBezier,
            this.toolStripMenuItem31,
            this.cMenuTrackSelectorSelectAll} );
            this.cMenuTrackSelector.Name = "cMenuTrackSelector";
            this.cMenuTrackSelector.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            this.cMenuTrackSelector.ShowCheckMargin = true;
            this.cMenuTrackSelector.ShowImageMargin = false;
            this.cMenuTrackSelector.Size = new System.Drawing.Size( 186, 336 );
            // 
            // cMenuTrackSelectorPointer
            // 
            this.cMenuTrackSelectorPointer.Name = "cMenuTrackSelectorPointer";
            this.cMenuTrackSelectorPointer.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorPointer.Text = "Arrow(&A)";
            // 
            // cMenuTrackSelectorPencil
            // 
            this.cMenuTrackSelectorPencil.Name = "cMenuTrackSelectorPencil";
            this.cMenuTrackSelectorPencil.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorPencil.Text = "Pencil(&W)";
            // 
            // cMenuTrackSelectorLine
            // 
            this.cMenuTrackSelectorLine.Name = "cMenuTrackSelectorLine";
            this.cMenuTrackSelectorLine.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorLine.Text = "Line(&L)";
            // 
            // cMenuTrackSelectorEraser
            // 
            this.cMenuTrackSelectorEraser.Name = "cMenuTrackSelectorEraser";
            this.cMenuTrackSelectorEraser.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorEraser.Text = "Eraser(&E)";
            // 
            // cMenuTrackSelectorPaletteTool
            // 
            this.cMenuTrackSelectorPaletteTool.Name = "cMenuTrackSelectorPaletteTool";
            this.cMenuTrackSelectorPaletteTool.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorPaletteTool.Text = "Palette Tool";
            // 
            // toolStripSeparator14
            // 
            this.toolStripSeparator14.Name = "toolStripSeparator14";
            this.toolStripSeparator14.Size = new System.Drawing.Size( 182, 6 );
            // 
            // cMenuTrackSelectorCurve
            // 
            this.cMenuTrackSelectorCurve.Name = "cMenuTrackSelectorCurve";
            this.cMenuTrackSelectorCurve.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorCurve.Text = "Curve(&V)";
            // 
            // toolStripMenuItem28
            // 
            this.toolStripMenuItem28.Name = "toolStripMenuItem28";
            this.toolStripMenuItem28.Size = new System.Drawing.Size( 182, 6 );
            // 
            // cMenuTrackSelectorUndo
            // 
            this.cMenuTrackSelectorUndo.Name = "cMenuTrackSelectorUndo";
            this.cMenuTrackSelectorUndo.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorUndo.Text = "Undo(&U)";
            // 
            // cMenuTrackSelectorRedo
            // 
            this.cMenuTrackSelectorRedo.Name = "cMenuTrackSelectorRedo";
            this.cMenuTrackSelectorRedo.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorRedo.Text = "Redo(&R)";
            // 
            // toolStripMenuItem29
            // 
            this.toolStripMenuItem29.Name = "toolStripMenuItem29";
            this.toolStripMenuItem29.Size = new System.Drawing.Size( 182, 6 );
            // 
            // cMenuTrackSelectorCut
            // 
            this.cMenuTrackSelectorCut.Name = "cMenuTrackSelectorCut";
            this.cMenuTrackSelectorCut.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorCut.Text = "Cut(&T)";
            // 
            // cMenuTrackSelectorCopy
            // 
            this.cMenuTrackSelectorCopy.Name = "cMenuTrackSelectorCopy";
            this.cMenuTrackSelectorCopy.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorCopy.Text = "Copy(&C)";
            // 
            // cMenuTrackSelectorPaste
            // 
            this.cMenuTrackSelectorPaste.Name = "cMenuTrackSelectorPaste";
            this.cMenuTrackSelectorPaste.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorPaste.Text = "Paste(&P)";
            // 
            // cMenuTrackSelectorDelete
            // 
            this.cMenuTrackSelectorDelete.Name = "cMenuTrackSelectorDelete";
            this.cMenuTrackSelectorDelete.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorDelete.Text = "Delete(&D)";
            // 
            // cMenuTrackSelectorDeleteBezier
            // 
            this.cMenuTrackSelectorDeleteBezier.Name = "cMenuTrackSelectorDeleteBezier";
            this.cMenuTrackSelectorDeleteBezier.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorDeleteBezier.Text = "Delete Bezier Point(&B)";
            // 
            // toolStripMenuItem31
            // 
            this.toolStripMenuItem31.Name = "toolStripMenuItem31";
            this.toolStripMenuItem31.Size = new System.Drawing.Size( 182, 6 );
            // 
            // cMenuTrackSelectorSelectAll
            // 
            this.cMenuTrackSelectorSelectAll.Name = "cMenuTrackSelectorSelectAll";
            this.cMenuTrackSelectorSelectAll.Size = new System.Drawing.Size( 185, 22 );
            this.cMenuTrackSelectorSelectAll.Text = "Select All Events(&E)";
            // 
            // trackBar
            // 
            this.trackBar.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.trackBar.AutoSize = false;
            this.trackBar.Location = new System.Drawing.Point( 322, 263 );
            this.trackBar.Margin = new System.Windows.Forms.Padding( 0 );
            this.trackBar.Maximum = 609;
            this.trackBar.Minimum = 17;
            this.trackBar.Name = "trackBar";
            this.trackBar.Size = new System.Drawing.Size( 83, 16 );
            this.trackBar.TabIndex = 15;
            this.trackBar.TabStop = false;
            this.trackBar.TickFrequency = 100;
            this.trackBar.TickStyle = System.Windows.Forms.TickStyle.None;
            this.trackBar.Value = 17;
            // 
            // pictureBox3
            // 
            this.pictureBox3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.pictureBox3.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(224)))), ((int)(((byte)(224)))), ((int)(((byte)(224)))) );
            this.pictureBox3.Location = new System.Drawing.Point( 0, 263 );
            this.pictureBox3.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictureBox3.Name = "pictureBox3";
            this.pictureBox3.Size = new System.Drawing.Size( 49, 16 );
            this.pictureBox3.TabIndex = 8;
            this.pictureBox3.TabStop = false;
            // 
            // pictKeyLengthSplitter
            // 
            this.pictKeyLengthSplitter.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.pictKeyLengthSplitter.BackColor = System.Drawing.SystemColors.Control;
            this.pictKeyLengthSplitter.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pictKeyLengthSplitter.Cursor = System.Windows.Forms.Cursors.NoMoveHoriz;
            this.pictKeyLengthSplitter.Location = new System.Drawing.Point( 49, 263 );
            this.pictKeyLengthSplitter.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictKeyLengthSplitter.Name = "pictKeyLengthSplitter";
            this.pictKeyLengthSplitter.Size = new System.Drawing.Size( 16, 16 );
            this.pictKeyLengthSplitter.TabIndex = 20;
            this.pictKeyLengthSplitter.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.pictureBox2.BackColor = System.Drawing.Color.FromArgb( ((int)(((byte)(224)))), ((int)(((byte)(224)))), ((int)(((byte)(224)))) );
            this.pictureBox2.Location = new System.Drawing.Point( 405, 231 );
            this.pictureBox2.Margin = new System.Windows.Forms.Padding( 0 );
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size( 16, 48 );
            this.pictureBox2.TabIndex = 5;
            this.pictureBox2.TabStop = false;
            // 
            // vScroll
            // 
            this.vScroll.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.vScroll.Location = new System.Drawing.Point( 405, 94 );
            this.vScroll.Name = "vScroll";
            this.vScroll.Size = new System.Drawing.Size( 16, 137 );
            this.vScroll.TabIndex = 17;
            // 
            // picturePositionIndicator
            // 
            this.picturePositionIndicator.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.picturePositionIndicator.BackColor = System.Drawing.Color.DarkGray;
            this.picturePositionIndicator.Location = new System.Drawing.Point( 0, 46 );
            this.picturePositionIndicator.Margin = new System.Windows.Forms.Padding( 0 );
            this.picturePositionIndicator.Name = "picturePositionIndicator";
            this.picturePositionIndicator.Size = new System.Drawing.Size( 700, 48 );
            this.picturePositionIndicator.TabIndex = 10;
            this.picturePositionIndicator.TabStop = false;
            // 
            // toolStripBottom
            // 
            this.toolStripBottom.Dock = System.Windows.Forms.DockStyle.None;
            this.toolStripBottom.Items.AddRange( new System.Windows.Forms.ToolStripItem[] {
            this.toolStripStatusLabel1,
            this.stripLblGameCtrlMode,
            this.toolStripSeparator10,
            this.toolStripStatusLabel2,
            this.stripLblMidiIn,
            this.toolStripSeparator11,
            this.stripBtnStepSequencer} );
            this.toolStripBottom.Location = new System.Drawing.Point( 15, 0 );
            this.toolStripBottom.Name = "toolStripBottom";
            this.toolStripBottom.RenderMode = System.Windows.Forms.ToolStripRenderMode.System;
            this.toolStripBottom.Size = new System.Drawing.Size( 294, 25 );
            this.toolStripBottom.TabIndex = 22;
            // 
            // toolStripStatusLabel1
            // 
            this.toolStripStatusLabel1.Name = "toolStripStatusLabel1";
            this.toolStripStatusLabel1.Size = new System.Drawing.Size( 85, 20 );
            this.toolStripStatusLabel1.Text = "Game Controler";
            // 
            // stripLblGameCtrlMode
            // 
            this.stripLblGameCtrlMode.Name = "stripLblGameCtrlMode";
            this.stripLblGameCtrlMode.Size = new System.Drawing.Size( 49, 20 );
            this.stripLblGameCtrlMode.Text = "Disabled";
            this.stripLblGameCtrlMode.ToolTipText = "Game Controler";
            // 
            // toolStripSeparator10
            // 
            this.toolStripSeparator10.Name = "toolStripSeparator10";
            this.toolStripSeparator10.Size = new System.Drawing.Size( 6, 25 );
            // 
            // toolStripStatusLabel2
            // 
            this.toolStripStatusLabel2.Name = "toolStripStatusLabel2";
            this.toolStripStatusLabel2.Size = new System.Drawing.Size( 41, 20 );
            this.toolStripStatusLabel2.Text = "MIDI In";
            // 
            // stripLblMidiIn
            // 
            this.stripLblMidiIn.Name = "stripLblMidiIn";
            this.stripLblMidiIn.Size = new System.Drawing.Size( 49, 20 );
            this.stripLblMidiIn.Text = "Disabled";
            this.stripLblMidiIn.ToolTipText = "Midi In Device";
            // 
            // toolStripSeparator11
            // 
            this.toolStripSeparator11.Name = "toolStripSeparator11";
            this.toolStripSeparator11.Size = new System.Drawing.Size( 6, 25 );
            // 
            // stripBtnStepSequencer
            // 
            this.stripBtnStepSequencer.CheckOnClick = true;
            this.stripBtnStepSequencer.Image = ((System.Drawing.Image)(resources.GetObject( "stripBtnStepSequencer.Image" )));
            this.stripBtnStepSequencer.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.stripBtnStepSequencer.Name = "stripBtnStepSequencer";
            this.stripBtnStepSequencer.Size = new System.Drawing.Size( 48, 22 );
            this.stripBtnStepSequencer.Text = "Step";
            // 
            // splitContainerProperty
            // 
            this.splitContainerProperty.Controls.Add( this.splitContainer2 );
            this.splitContainerProperty.FixedPanel = System.Windows.Forms.FixedPanel.None;
            this.splitContainerProperty.IsSplitterFixed = false;
            this.splitContainerProperty.Location = new System.Drawing.Point( 448, 14 );
            this.splitContainerProperty.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainerProperty.Name = "splitContainerProperty";
            this.splitContainerProperty.Orientation = System.Windows.Forms.Orientation.Horizontal;
            // 
            // 
            // 
            this.splitContainerProperty.Panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainerProperty.Panel1.BorderColor = System.Drawing.Color.Black;
            this.splitContainerProperty.Panel1.Location = new System.Drawing.Point( 0, 0 );
            this.splitContainerProperty.Panel1.Margin = new System.Windows.Forms.Padding( 0, 0, 0, 4 );
            this.splitContainerProperty.Panel1.Name = "m_panel1";
            this.splitContainerProperty.Panel1.Size = new System.Drawing.Size( 42, 348 );
            this.splitContainerProperty.Panel1.TabIndex = 0;
            this.splitContainerProperty.Panel1MinSize = 25;
            // 
            // 
            // 
            this.splitContainerProperty.Panel2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainerProperty.Panel2.BorderColor = System.Drawing.Color.Black;
            this.splitContainerProperty.Panel2.Location = new System.Drawing.Point( 46, 0 );
            this.splitContainerProperty.Panel2.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainerProperty.Panel2.Name = "m_panel2";
            this.splitContainerProperty.Panel2.Size = new System.Drawing.Size( 66, 348 );
            this.splitContainerProperty.Panel2.TabIndex = 1;
            this.splitContainerProperty.Panel2MinSize = 25;
            this.splitContainerProperty.Size = new System.Drawing.Size( 112, 348 );
            this.splitContainerProperty.SplitterDistance = 42;
            this.splitContainerProperty.SplitterWidth = 4;
            this.splitContainerProperty.TabIndex = 20;
            this.splitContainerProperty.TabStop = false;
            this.splitContainerProperty.Text = "bSplitContainer1";
            // 
            // splitContainer2
            // 
            this.splitContainer2.FixedPanel = System.Windows.Forms.FixedPanel.Panel2;
            this.splitContainer2.IsSplitterFixed = false;
            this.splitContainer2.Location = new System.Drawing.Point( 0, 345 );
            this.splitContainer2.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer2.Name = "splitContainer2";
            this.splitContainer2.Orientation = System.Windows.Forms.Orientation.Vertical;
            // 
            // 
            // 
            this.splitContainer2.Panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainer2.Panel1.BorderColor = System.Drawing.Color.Black;
            this.splitContainer2.Panel1.Location = new System.Drawing.Point( 0, 0 );
            this.splitContainer2.Panel1.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer2.Panel1.Name = "m_panel1";
            this.splitContainer2.Panel1.Size = new System.Drawing.Size( 115, 25 );
            this.splitContainer2.Panel1.TabIndex = 0;
            this.splitContainer2.Panel1MinSize = 25;
            // 
            // 
            // 
            this.splitContainer2.Panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainer2.Panel2.BorderColor = System.Drawing.Color.Black;
            this.splitContainer2.Panel2.Location = new System.Drawing.Point( 0, 29 );
            this.splitContainer2.Panel2.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer2.Panel2.Name = "m_panel2";
            this.splitContainer2.Panel2.Size = new System.Drawing.Size( 115, 105 );
            this.splitContainer2.Panel2.TabIndex = 1;
            this.splitContainer2.Panel2MinSize = 25;
            this.splitContainer2.Size = new System.Drawing.Size( 115, 134 );
            this.splitContainer2.SplitterDistance = 25;
            this.splitContainer2.SplitterWidth = 4;
            this.splitContainer2.TabIndex = 23;
            this.splitContainer2.TabStop = false;
            this.splitContainer2.Text = "bSplitContainer1";
            // 
            // panel2
            // 
            this.panel2.BackColor = System.Drawing.Color.DarkGray;
            this.panel2.Location = new System.Drawing.Point( 15, 295 );
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size( 421, 59 );
            this.panel2.TabIndex = 19;
            this.panel2.TabStop = false;
            // 
            // splitContainer1
            // 
            this.splitContainer1.FixedPanel = System.Windows.Forms.FixedPanel.Panel2;
            this.splitContainer1.IsSplitterFixed = false;
            this.splitContainer1.Location = new System.Drawing.Point( 2, 2 );
            this.splitContainer1.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer1.MinimumSize = new System.Drawing.Size( 0, 54 );
            this.splitContainer1.Name = "splitContainer1";
            this.splitContainer1.Orientation = System.Windows.Forms.Orientation.Vertical;
            // 
            // 
            // 
            this.splitContainer1.Panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainer1.Panel1.BorderColor = System.Drawing.Color.Black;
            this.splitContainer1.Panel1.Location = new System.Drawing.Point( 0, 0 );
            this.splitContainer1.Panel1.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer1.Panel1.Name = "m_panel1";
            this.splitContainer1.Panel1.Size = new System.Drawing.Size( 953, 50 );
            this.splitContainer1.Panel1.TabIndex = 0;
            this.splitContainer1.Panel1MinSize = 25;
            // 
            // 
            // 
            this.splitContainer1.Panel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.splitContainer1.Panel2.BorderColor = System.Drawing.Color.Black;
            this.splitContainer1.Panel2.Location = new System.Drawing.Point( 0, 54 );
            this.splitContainer1.Panel2.Margin = new System.Windows.Forms.Padding( 0 );
            this.splitContainer1.Panel2.Name = "m_panel2";
            this.splitContainer1.Panel2.Size = new System.Drawing.Size( 953, 25 );
            this.splitContainer1.Panel2.TabIndex = 1;
            this.splitContainer1.Panel2MinSize = 25;
            this.splitContainer1.Size = new System.Drawing.Size( 953, 54 );
            this.splitContainer1.SplitterDistance = 50;
            this.splitContainer1.SplitterWidth = 4;
            this.splitContainer1.TabIndex = 4;
            this.splitContainer1.TabStop = false;
            this.splitContainer1.Text = "splitContainerEx1";
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size( 57, 6 );
            // 
            // stripDDBtnQuantize
            // 
            this.stripDDBtnQuantize.MenuItems.AddRange( new System.Windows.Forms.MenuItem[] {
            this.stripDDBtnQuantize04,
            this.stripDDBtnQuantize08,
            this.stripDDBtnQuantize16,
            this.stripDDBtnQuantize32,
            this.stripDDBtnQuantize64,
            this.stripDDBtnQuantize128,
            this.stripDDBtnQuantizeOff,
            this.menuItem2,
            this.stripDDBtnQuantizeTriplet} );
            // 
            // stripDDBtnQuantize04
            // 
            this.stripDDBtnQuantize04.Index = 0;
            this.stripDDBtnQuantize04.Text = "1/4";
            // 
            // stripDDBtnQuantize08
            // 
            this.stripDDBtnQuantize08.Index = 1;
            this.stripDDBtnQuantize08.Text = "1/8";
            // 
            // stripDDBtnQuantize16
            // 
            this.stripDDBtnQuantize16.Index = 2;
            this.stripDDBtnQuantize16.Text = "1/16";
            // 
            // stripDDBtnQuantize32
            // 
            this.stripDDBtnQuantize32.Index = 3;
            this.stripDDBtnQuantize32.Text = "1/32";
            // 
            // stripDDBtnQuantize64
            // 
            this.stripDDBtnQuantize64.Index = 4;
            this.stripDDBtnQuantize64.Text = "1/64";
            // 
            // stripDDBtnQuantize128
            // 
            this.stripDDBtnQuantize128.Index = 5;
            this.stripDDBtnQuantize128.Text = "1/128";
            // 
            // stripDDBtnQuantizeOff
            // 
            this.stripDDBtnQuantizeOff.Index = 6;
            this.stripDDBtnQuantizeOff.Text = "Off";
            // 
            // menuItem2
            // 
            this.menuItem2.Index = 7;
            this.menuItem2.Text = "-";
            // 
            // stripDDBtnQuantizeTriplet
            // 
   