#ifndef INCLUDED_CELL_TASK_MANAGER_IMPL
#define INCLUDED_CELL_TASK_MANAGER_IMPL

#include "TaskManagerImpl.h"
#include "FifoTaskManagerImpl.h"
#include "SpeThreads.h"

class CellTaskManagerImpl : public TaskManagerImpl {
public:
    /* constructor */
    CellTaskManagerImpl(int num = 1) : TaskManagerImpl(num) {}
    ~CellTaskManagerImpl();

    /* variables */
    QueueInfo<TaskList> **taskListInfo;
    QueueInfo<TaskList> **speTaskList;  // running task

    SpeThreads *speThreads;
    FifoTaskManagerImpl *ppeManager;
    int spe_running;
    int spuIdle;

    /* functions */
    // system
    void init(int spuIdle);
    void run();
    void poll();
    void poll1(int spu_limit);
    void poll2(int spu_limit);
    void mail_check(int id);
    //void set_runTaskList(*QueueInfo<HTask>);
    void set_runTaskList(QueueInfo<HTask>* activeTaskQueue);
    void sendTaskList();
    void append_activeTask(HTaskPtr);
    void show_profile() ;
    void start_profile() ;
    void polling();
    void debug_check_spe_idle(QueueInfo<HTask> * activeTaskQueue, int spe_running_);
    void print_arch();
private:
    void send_taskList(int id);
    void show_dead_lock_info();

};

#endif
