//#include <stdio.h>
#include "CellScheduler.h"
#include "CellDmaManager.h"
#include "error.h"

// ユーザプログラムで定義
// なんだけど、それは微妙じゃね？
extern void task_init(Scheduler *scheduler);
extern unsigned long long alloc_flag;

void
CellScheduler::init_impl()
{
    connector = new CellDmaManager;

    mainMemNum = 0;

    task_init(this); // PPE側ではUser 側で既に呼んでいる...
    // SPE側はここで呼び出す必要がある
    // Fifo ではSPEは無いので呼び出されない
}

/**
 * メインメモリ領域を allocate する。
 * allocate した領域のアドレスは mainMem_get で取得するが、
 * mainMem_get を実行できるのは
 * Renew Task (タスク内で create した Task) から。
 * alloc してすぐ get しても、アドレス何も入ってないです。
 */
void
CellScheduler::mainMem_alloc(int id, int size)
{
    mainMemList[id] = (memaddr)NULL;
    
    // flag on. (unsigned long long)
    alloc_flag = 1;

    mainMemNum++;
    mail_write((memaddr)MY_SPE_COMMAND_MALLOC);
    mail_write((memaddr)id);
    mail_write((memaddr)size);
}

void
CellScheduler::mainMem_wait()
{
    unsigned long id;
    memaddr addr;

    while (mainMemNum > 0) {
	id = (unsigned long)mail_read();
	addr = mail_read();

	mainMemList[id] = (memaddr)addr;
	mainMemNum--;
    }    
}

/*
    dma channel を返す
    本来、SPU用に閉じているはず。ユーザが明示的に使うことはない。
    良くわからないが、ある分だけcounterで廻せば良い。しかし、
    そのためには、全部で、get_tag()する必要があるはず。

 */

// #define TEX_LOAD1      0
// #define TEX_LOAD2      1

uint32
CellScheduler::get_tag()
{
    static int count = 0;
    return (count++ % 8)+16;
}



/* end */
