#include <stdlib.h>
#include "MailManager.h"

void
MailManager::calc_mask(unsigned int qsize) 
{
    mask = 1;
    while(qsize>mask) {
	mask <<= 1;
    }
    size = mask;
    mask--;
}

MailManager::MailManager(unsigned int qsize) {
    read = write = 0;
    calc_mask(qsize);
    queue = Newq(memaddr,size);
}

MailManager::~MailManager() { free(queue); }

int 
MailManager::count()
{
    return (write+size-read)&mask;
}

void 
MailManager::extend()
{
    memaddr *newq = Newq(memaddr,size*2);
    unsigned int i = 0;
    while(i<size) {
	newq[i++] = queue[read++];
	read &= mask;
    }
    read = 0; write = i;
    calc_mask(size*2);
    free(queue);
    queue = newq;
}

void 
MailManager::send(memaddr data)
{
    queue[write++] = data;
    write &= mask;
    if (write==read) {
	extend();
    }
}

memaddr 
MailManager::recv()
{
    memaddr data;
    if (count()>0) {
	data = queue[read++];
	read &= mask;
    } else {
	data = 0;
    }
    return data;
}

/* end */
