#include <stdio.h>
#include <stdlib.h>
#include "TaskQueueInfo.h"

// Singleton TaskQueue Pool
TaskQueueInfo TaskQueueInfo::taskQueuePool;   

TaskQueueInfo::TaskQueueInfo() {
    // 最初の一つは自分
    first = last = this;
    next = prev = this;
    waiter = NULL;
}

void
TaskQueueInfo::freePool() { 
    for(TaskQueuePtr p = taskQueuePool.waiter; p; ) {
	TaskQueuePtr next = p->waiter;
	p->waiter = NULL;
	free(p);
	p = next;
    }
}

int
TaskQueueInfo::extend_pool(int num)
{
    TaskQueuePtr q = (TaskQueuePtr)malloc(sizeof(TaskQueue)*(num+1));

    // First Queue is previous pool
    q->waiter = waiter; waiter = q;
    q++;

    /* Connect all free queue in the pool */
    TaskQueuePtr p = q;
    for (; num-- > 0; p++) {
	p->task = NULL;
	p->waiter = NULL;
	taskQueuePool.addLast(p);
    }

    return 0;
}

TaskQueuePtr
TaskQueueInfo::create(HTask *task)
{
    TaskQueuePtr q =  taskQueuePool.poll();
    if (! q)  {
	taskQueuePool.extend_pool(64);
	q = taskQueuePool.poll();
    }
    q->next = q->prev = NULL;
    q->waiter = NULL;
    q->task = task;

    return q;
}


void
TaskQueueInfo::free_(TaskQueuePtr q)
{
    q->waiter = NULL;
    q->task = NULL;
    taskQueuePool.addLast(q);
}


/*!
  TaskQueueInfo は空にならない。最低1個は要素が入っていて
  1個目は特別扱いする。getFirst すると first->next を返す
 */

/*!
  最初の1個は特別扱いなので、それの後に追加していく
 */
void
TaskQueueInfo::addFirst(TaskQueue* e)
{
    e->prev = first;
    e->next = first->next;
    first->next->prev = e;
    first->next = e;
}

void
TaskQueueInfo::addLast(TaskQueue* e)
{
    e->next = first;
    e->prev = last;
    last->next = e;
    last = e;
}

TaskQueue*
TaskQueueInfo::getFirst()
{
    if (empty()) return NULL;
    return first->next;
}

TaskQueue*
TaskQueueInfo::getLast()
{
    if (empty()) return NULL;
    return last;
}

int
TaskQueueInfo::remove(TaskQueue* e)
{
    e->prev->next = e->next;
    e->next->prev = e->prev;

    if (first->next == e) {
	first->next = e->next;
    }
    if (last == e) {
	last = e->prev;
    }

    e->prev = NULL;
    e->next = NULL;

    return 1;
}

/*!
  リストの先頭を取得および削除する。リストが空の場合は NULL を返す。
 */

TaskQueue*
TaskQueueInfo::poll()
{
    TaskQueue* e = first->next;
    if (e == this) {
	return NULL;
    }
    remove(e);
    return e;
}

void
TaskQueueInfo::moveToFirst(TaskQueue* e)
{
    remove(e);
    addFirst(e);
}

/*!
  リスト内の指定された位置にある要素を返す。
  要素数を超えた位置を指定した場合 NULL を返す。
 */

TaskQueue*
TaskQueueInfo::get(int index)
{
    TaskQueue* e = first->next;
    for (int i = 0; i < index; i++) {
	if (e == this) return NULL;
	e = e->next;
    }
    return e;
}

TaskQueue*
TaskQueueInfo::find(HTask* task)
{
    TaskQueue* e = first->next;
    for(;;) {
	if (e == this) return NULL;
	if (e->task == task) return e;
	e = e->next;
    }
    return e;
}

int
TaskQueueInfo::empty()
{
    return next == this;
}

TaskQueue*
TaskQueueInfo::getNext(TaskQueue* q) 
{
    if (q->next==this) return NULL;
    return q->next;
}



/* end */
