#ifndef INCLUDED_SCHED_TASK_ARRAY
#define INCLUDED_SCHED_TASK_ARRAY

#include "base.h"
#include "Scheduler.h"
#include "SchedTask.h"


class SchedTaskArray : public SchedTask {
public:
    BASE_NEW_DELETE(SchedTaskArray);

    /* constructor */
    SchedTaskArray(Scheduler *s, SchedTaskBase *savedTask_, Task *task_, Task *array_, int tag);
    /* constructor for old style task */
    SchedTaskArray(Scheduler *s, SchedTaskBase *savedTask_);

    virtual ~SchedTaskArray();


private:
    /* variables */

    /* functions */
    Task *last();

    // override
    void read();
    void exec();
    void write();
    SchedTaskBase* next(Scheduler *, SchedTaskBase *);

    void setup_outputData();

    void* get_input(void*, int);
    memaddr get_inputAddr(int);
    int get_inputSize(int);
    void* get_output(void*, int);
    memaddr get_outputAddr(int);
    int get_outputSize(int);
    void set_outputSize(int index, int size);
    memaddr get_param(int);
    int read_size();

}  ;


#endif

