#include "SchedTaskArrayLoad.h"
#include "SchedTaskArray.h"
#include "Task.h"
#include "TaskManagerImpl.h"


SchedTaskArrayLoad::SchedTaskArrayLoad(Scheduler *s, SchedTaskBase *savedTask_, int dma_tag_switch)
{
    scheduler = s;
    savedTask = savedTask_;
    task = savedTask->task;
    cur_index = -2;

    this->tag = dma_tag_switch;

}

SchedTaskArrayLoad::~SchedTaskArrayLoad() {}

void
SchedTaskArrayLoad::read()
{
    // if (task->r_size == 0) return; cannot happen...
    // load Task Array Data
    readbuf = manager->allocate(task->r_size);
    scheduler->dma_load(readbuf, task->rbuf,task->r_size, DMA_READ);
    scheduler->dma_wait(DMA_READ);
}

void
SchedTaskArrayLoad::exec() {
    // もっと、はやめに DMA_READ して、最初のcodeをloadするべきか?
}  // to empty the pipeline

void
SchedTaskArrayLoad::write() {} // to empty the pipeline

SchedTaskBase*
SchedTaskArrayLoad::next(Scheduler *scheduler, SchedTaskBase *p)
{

    Task *nextTask = (Task *)readbuf;
    return new SchedTaskArray(scheduler, savedTask, nextTask, nextTask, this->tag);
}

/* end */
