/* ------------------------------------------------------------------------- */
/*  HOS ǥѥå                                               */
/*                                               Copyright (C) 1998 by Ryuz  */
/* ------------------------------------------------------------------------- */

-- C 
#include <ITRON.h>


-_wup_dsp.c
/* Ԥֲ */
void __wup_dsp(T_TCB *tcb, ER ercd)
{
	/* Ԥֲ */
	tcb->tskstat &= ~TTS_WAI;
	tcb->tskwait  = 0;
	*(tcb->sp)    = (UH)ercd;
	if ( tcb->que != NADR )
		__del_que(tcb);
	
	if ( !(tcb->tskstat & TTS_SUS) ) {
		/* ǥ塼³ */
		tcb->tskstat = TTS_RDY;
		__adt_que(&rdyque[tcb->tskpri - 1], tcb);
		
		/* ǥѥå */
		__tsk_dsp();
	}
}



-- ֥
				cseg

				extrn	sysstat_
				extrn	curtcb_
				extrn	dlydsp_
				extrn	rdqcnt_
				extrn	rdyque_

-tsk_dsp.asz
; ER __tsk_dsp(void)
				public	__tsk_dsp_
__tsk_dsp_:		
			; ƥ֥å
				ld		a,(sysstat_)
				or		a
				jr		z,ss_ok
				ld		a,1
				ld		(dlydsp_),a
				ld		hl,0
				ret
ss_ok:			
			; ٱե饰ꥢ
				ld		(dlydsp_),a		; aϣ
				
			; Υ򸡺
				ld		hl,rdqcnt_
				ld		b,(hl)
				ld		hl,rdyque_
				ld		de,03h			; rdyque Υ
				xor		a
search_task:	
				cp		(hl)
				jr		nz,found_task		; ȯ
				add		hl,de
				djnz	search_task
				jp		no_task			; ʤ

			; ڤؤ
found_task:		
				inc		hl
				ld		a,(hl)
				inc		hl
				ld		h,(hl)
				ld		l,a
				
			; curtcb == NADR å
				ld		bc,(curtcb_)
				inc		b
				jr		nz,curtcb_exs
				inc		c
				jr		z,curtcb_noexs

			; ڤؤ
curtcb_exs:		
				ld		iy,(curtcb_)
				ld		(iy+2),02h		; curtcb->tskstat = TTS_RDY
				push	hl
				pop		iy
				ld		(iy+2),01h		; tcb->tskstat = TTS_RUN
				call	__swc_dsp_##
				ret
				
			; 
curtcb_noexs:	
				push	hl
				pop		iy
				ld		(iy+2),01h		; tskstat = TTS_RUN
				ld		(curtcb_),hl
				jp		__sta_dsp_##

			; Υ̵
no_task:		
				ld		a,0ffh
				ld		iy, curtcb_
				cp		(iy)
				jr		nz,tsk_end
				cp		(iy+1)
				jp		z,__tsk_hlt_##
tsk_end:		
				call	__end_dsp_##
				ret


-_swc_dsp.asz
; -----------------------------------------------
;  ڤؤ
;  H   __swc_dsp(T_TCB *tcb);
;
;  ƤӽФ˳ߤػߤ뤳
;  LSIC-80θƤӽФ˽򤷤ixʳ¸ʤ
;  Ԥʤɤ֤ͤפϥå
;  ͤ񤭴Ƥ
; -----------------------------------------------
				public	__swc_dsp_
__swc_dsp_:		
				push	ix
				push	hl
				ld		hl,0
				add		hl,sp
				ld		ix,(curtcb_)
				ld		(ix+0),l			; sp ¸
				ld		(ix+1),h
				pop		hl
				ld		(curtcb_),hl		; tcbϿ
				ld		a,(hl)
				inc		hl
				ld		h,(hl)
				ld		l,a
				ld		sp,hl				; sp 
				pop		hl					; ꥿ѥ᡼
				pop		ix
				ret


-_sta_dsp.asz
; -----------------------------------------------
; 
; void __sta_dsp(T_TCB *tcb);
;
; ⥿ưƤʤ֤Υǥѥå
; ƤӽФˤʤ
; -----------------------------------------------
				public	__sta_dsp_
__sta_dsp_:		
				ld		a,(hl)
				inc		hl
				ld		h,(hl)
				ld		l,a
				ld		sp,hl				; sp 
				pop		hl					; ꥿ѥ᡼
				pop		ix
				ret


-_end_dsp.asz
; -----------------------------------------------
; 
; H    __end_dsp(void);
;
; ư̵Υǥѥå
; -----------------------------------------------
				public	__end_dsp_
__end_dsp_:		
				push	ix
				push	hl				; ꥿ѥ᡼
				ld		hl,0
				add		hl,sp
				ld		ix,(curtcb_)
				ld		(ix+0),l		; sp ¸
				ld		(ix+1),h
				jp		__tsk_hlt_##


-_tsk_hlt.asz
; -----------------------------------------------
;        HALT (ǥ塼˥̵)
; -----------------------------------------------
				public	__tsk_hlt_
__tsk_hlt_:		
				ld		hl,0ffffh		; NADR
				ld		(curtcb_),hl
				ld		sp,system_sp
				ei
				jr		$	; ʪHALTMPUˤäCTCߤޤ

				dseg
system_stack:	ds		32
system_sp		equ		$

