/* ------------------------------------------------------------------------- */
/*  HOS  ִ                                                            */
/*                                               Copyright (C) 1998 by Ryuz  */
/* ------------------------------------------------------------------------- */

-- 
#include <stdrom.h>
#include <ITRON.h>


/* ֥ */
void __add_systim(void);	/* ޲û */
void __add_tim(SYSTIME *pk_tim, DLYTIME *dlytim);	/* ֲû */
char __cmp_tim(SYSTIME *pk_tim1, SYSTIME *pk_tim2);	/*  */


-_ini_ctc.c
/* Хѿ */
SYSTIME  systim;	/* ƥ९å */
T_QUE    dlyque;	/* ٱԤ */
UH       timint;	/* ޥ롼󤬸ƤФֳ */


/* ޽ */
void __ini_tim(void)
{
	/* ѥХѿ */
	timint         = 1;		/* ǥեȤ1ms */
	dlyque.tskcnt  = 0;
	systim.utime   = 0;
	systim.mtime   = 0;
	systim.ltime   = 0;
}


-_timhndl.c
/* ޥϥɥ */
void __timer_handler(void)
{
	T_TCB *tcb;
	
	/* 󥿤βû */
	__add_systim();
	
	/* Ԥ */
	while ( dlyque.tskcnt > 0 ) {
		tcb = dlyque.head;
		if ( !__cmp_tim((SYSTIME *)tcb->data, &systim) )
			break;
		di();
		__wup_dsp(tcb, E_OK);
		ei();
	}
	
	ret_int();
}


-set_tim.c
/* ƥ९å */
ER   set_tim(SYSTIME *pk_tim)
{
	__set_imsk();
	
	systim = *pk_tim;
	
	__res_imsk();
	
	return E_OK;
}


-get_tim.c
/* ƥ९å */
ER   get_tim(SYSTIME *pk_tim)
{
	__set_imsk();

	*pk_tim = systim;

	__res_imsk();

	return E_OK;
}


-dly_tsk.c
/* ٱ */
ER   dly_tsk(DLYTIME dlytim)
{
	SYSTIME st;
	T_TCB *tcb;
	ER    ercd;
	
#if __ERR_CHECK_LEVEL >= 3
	/* Ωǥѥåػ߾֤ǤϸƤ٤ʤ */
	if ( sysstat != TSS_TSK )
		return E_CTX;
#endif
#if __ERR_CHECK_LEVEL >= 4
	if ( dlytim < 0 )
		return E_PAR;
#endif
	
	__set_imsk();
	
	/* Ԥ֤˰ܹ */
	__del_que(curtcb);
	curtcb->tskstat = TTS_WAI;
	curtcb->tskwait = TTW_DLY;
	
	/* Ԥλַ׻ */
	st = systim;
	__add_tim(&st, &dlytim);
	curtcb->data = (VP)&st;
	
	/* Ԥ塼˥å */
	if ( dlyque.tskcnt == 0 ) {
		curtcb->que  = &dlyque;
		curtcb->next = curtcb;
		curtcb->prev = curtcb;
		dlyque.head  = curtcb;
		dlyque.tskcnt++;
	}
	else {
		/* ֽ¤٤ */
		tcb = dlyque.head;
		for ( ; ; ) {
			tcb = tcb->prev;
			if ( __cmp_tim((SYSTIME *)(tcb->data), &st) ) {
				__ins_que(tcb, curtcb);
				break;
			}
			if ( tcb == dlyque.head ) {
				__adh_que(&dlyque, curtcb);
				break;
			}
		}
	}
	
	
	/* ǥѥå */
	ercd = __tsk_dsp();
	
	
	__res_imsk();
	
	return ercd;
}




-- ֥
				cseg
				extrn	systim_
				extrn	timint_

-_add_stm.asz
; -----------------------------------------------
;  ޲û (timint_ͤû)
;  void __add_systim(void);
; -----------------------------------------------
				public	__add_systim_
__add_systim_:	
				ld		bc,(timint_)		; ߼ (msec)
				ld		hl,(systim_)
				add		hl,bc
				di
				ld		(systim_),hl
				ret		nc
				ld		hl,(systim_ + 2)
				inc		hl
				ld		(systim_ + 2),hl
				ret		nz
				ld		hl,(systim_ + 4)
				inc		hl
				ld		(systim_ + 4),hl
				ei
				ret


-_add_tim.asz
; -----------------------------------------------------
;  ֲû
;  void __add_tim(SYSTIME *pk_tim, DLYTIME *dlytim);
; -----------------------------------------------------
				public	__add_tim_
__add_tim_:		
				push	ix
				push	hl
				pop		ix
				push	de
				pop		iy
				ld		c,(iy+0)
				ld		b,(iy+1)
				ld		l,(ix+0)
				ld		h,(ix+1)
				add		hl,bc
				ld		(ix+0),l
				ld		(ix+1),h
				ld		c,(iy+2)
				ld		b,(iy+3)
				ld		l,(ix+2)
				ld		h,(ix+3)
				adc		hl,bc
				ld		(ix+2),l
				ld		(ix+3),h
				ld		l,(ix+4)
				ld		h,(ix+5)
				ld		bc,0
				adc		hl,bc
				ld		(ix+4),l
				ld		(ix+5),h
				pop		ix
				ret


-_cmp_tim.asz
; -----------------------------------------------------
;  ֤
;  char __cmp_tim(SYSTIME *pk_tim1, SYSTIME *pk_tim2);
;
;  pk_tim1  pk_time2 ʲʤ鿿
; -----------------------------------------------------
				public	__cmp_tim_
__cmp_tim_:		
				ld		bc,5
				add		hl,bc
				ex		de,hl
				add		hl,bc
				ld		b,6
cmp_loop:		ld		a,(de)
				cp		(hl)
				jr		nz,cmp_end
				dec		hl
				dec		de
				djnz	cmp_loop
				jr		cmp_true
cmp_end:		
				jr		c,cmp_true
				xor		a
				ret
cmp_true:		
				ld		a,1
				ret
