/* ------------------------------------------------------------------------- */
/*  HOS ٥ȥե饰إåե                                         */
/*                                                                           */
/*                                   Copyright (C) 1998-2002 by Project HOS  */
/* ------------------------------------------------------------------------- */

#ifndef __HOS__EVENTFLG_H_
#define __HOS__EVENTFLG_H_



/* ------------------------------------ */
/*                              */
/* ------------------------------------ */

#define TWF_ANDW  0x00
#define TWF_ORW   0x02
#define TWF_CLR   0x01

/* ------------------------------------ */
/*                                */
/* ------------------------------------ */

/* FCBưŪʬ RAM֤ */
typedef struct t_fcb {
	T_QUE que;		/* ٥ȥե饰Ԥ */
	UH    flgptn;	/* ٥ȥե饰ξ */
} T_FCB;

/* FCBŪʬ ROM֤ */
typedef struct t_fcbs {
	VP   exinf;		/* ĥ */
	UH   iflgptn;	/* ٥ȥե饰ν */
} T_FCBS;

/* ٥ȥե饰ֻ */
typedef struct t_rflg {
	VP      exinf;
	BOOL_ID wtsk;
	UH      flgptn;
} T_RFLG;

/* ------------------------------------ */
/*          Хѿ              */
/* ------------------------------------ */

extern       T_FCB  fcbtbl[];	/* FCBRAM */
extern const T_FCBS fcbstbl[];	/* FCBROM */
extern const H      fcbcnt;		/* FCBο */


/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

void __ini_flg(void);		/* ٥ȥե饰 */
ER   set_flg(ID flgid, UB setptn);	/* ٥ȥե饰å */
ER   clr_flg(ID flgid, UB clrptn);	/* ٥ȥե饰Υꥢ */
ER   wai_flg(UB *p_flgptn, ID flgid, UB waiptn, UB wfmode);
									/* ٥ȥե饰Ԥ */
ER   pol_flg(UB *p_flgptn, ID flgid, UB waiptn, UB wfmode);
									/* ٥ȥե饰Ԥ(ݡ) */
ER   ref_flg(T_RFLG *pk_rflg, ID flgid);	/* ٥ȥե饰ֻ */

/* Ω */
#define iset_flg  set_flg
#define iclr_flg  clr_flg
#define ipol_flg  pol_flg
#define iref_flg  ref_flg


#endif /* __HOS__EVENTFLG_H_ */
