/* ------------------------------------------------------------------------- */
/*  HOS  إåե                                            */
/*                                   Copyright (C) 1998-2002 by Project HOS  */
/* ------------------------------------------------------------------------- */

#ifndef __HOS__TAKS_H_
#define __HOS__TAKS_H_


/* ------------------------------------ */
/*                              */
/* ------------------------------------ */

/* ° */
#define TA_ASM   0x0000		/* ֥ˤץ */
#define TA_HLNG  0x0001		/* ˤץ */
#define TA_COP0  0x8000
#define TA_COP1  0x4000
#define TA_COP2  0x2000
#define TA_COP3  0x1000
#define TA_COP4  0x0800
#define TA_COP5  0x0400
#define TA_COP6  0x0200
#define TA_COP7  0x0100

/* Ȥʤѥ᡼ */
#define TSK_SELF      0		/* ʬȤΥ */
#define TPRI_INI      0		/* ͥ٤ */
#define TPRI_RUN      0		/* ʬȤͥ */

/*  */
#define TTS_RUN  0x01		/* ¹Ծ */
#define TTS_RDY  0x02		/* ¹Բǽ */
#define TTS_WAI  0x04		/* Ԥ */
#define TTS_SUS  0x08		/* Ԥ */
#define TTS_WAS  0x0c		/* Ԥ */
#define TTS_DMT  0x10		/* ٻ߾ */

/* Ԥ */
#define TTW_SLP  0x0001		/* slp_tsk, tslp_tsk ˤԤ */
#define TTW_DLY  0x0002		/* dly_tsk ˤԤ */
#define TTW_NOD  0x0008		/* ³ǽԤ */
#define TTW_FLG  0x0010		/* wai_flg, twai_flg ˤԤ */
#define TTW_SEM  0x0020		/* wai_sem, twai_sem ˤԤ */
#define TTW_MBX  0x0040		/* rcv_msg, trcv_msg ˤԤ */
#define TTW_SMBF 0x0080		/* snd_mbf, tsnd_mbf ˤԤ */
#define TTW_MBF  0x0100		/* rcv_mbf, trcv_mbf ˤԤ */
#define TTW_CAL  0x0200		/* ǥָƽФԤ */
#define TTW_ACP  0x0400		/* ǥּդԤ */
#define TTW_RDV  0x0800		/* ǥֽλԤ */
#define TTW_MPL  0x1000		/* get_blk, tget_blk ˤԤ */
#define TTW_MPF  0x2000		/* get_blf, tget_blf ˤԤ */
#define TTW_SPL  0x8000		/* åסԤ֡HOSȼ */


/* TCBϢ */
#define MAX_SUSCNT  65535U		/* SUSPEND ͥȿ */
#define MAX_WUPCNT  65535U		/* ׵ 祭塼󥰿 */



/* ------------------------------------ */
/*                                */
/* ------------------------------------ */

/* ѥ塼 */
typedef struct t_que {
	struct t_tcb *head;		/* 塼Ƭ */
	INT    tskcnt;			/* 塼¤Ǥ륿ο */
} T_QUE;

/* TCB(ȥ֥å) ưŪʬ RAM֤ */
/* ʴǲΤᥢ֥ΤƬ֤ */
typedef struct t_tcb {
	VH   *sp;			/* ߤΥåݥ */
	UINT tskstat;		/* ξ */
	PRI  tskpri;		/* ߤͥ */
	UINT tskwait;		/* Ԥ */
	UH   wupcnt;		/* ׵ᥭ塼󥰿 */
	UH   suscnt;		/* SUSPEND׵ͥȿ */
	VP   data;			/* ¸ɬפʥǡлȤ */
	struct t_que *que;	/* °Ƥ륭塼  */
	struct t_tcb *next;	/* 塼ǤμTCB */
	struct t_tcb *prev;	/* 塼ǤTCB */
} T_TCB;

/* TCBŪʬ ROM֤ */
typedef struct t_tcbs {
	VP   exinf;			/* ĥ */
	FP   task;			/* ưɥ쥹 */
	PRI  itskpri;		/* ưͥ */
	VH   *isp;			/* ưΥåݥ󥿤*/
} T_TCBS;

/* ֻ */
typedef struct t_rtsk {
	VP   exinf;			/* ĥ */
	PRI  tskpri;		/* ߤͥ */
	UB   tskstat;		/*  */
} T_RTSK;


/* åס륳ȥ֥å RAMʬ */
typedef struct t_spcb {
	T_QUE que;		/* åԤ塼 */
	UH    freestk;	/* Ƥ륹åΰ */
} T_SPCB;

/* åס륳ȥ֥å ROMʬ */
typedef struct t_spcbs {
	VH    *stkhead;	/* סƬɥ쥹 */
	UH    stkcnt;	/* ֥å */
	UH    stksz;	/* ֥å */
} T_SPCBS;



/* ------------------------------------ */
/*          Хѿ              */
/* ------------------------------------ */

extern       T_TCB  tcbtbl[];	/* TCBơ֥ RAM */
extern const T_TCBS tcbstbl[];	/* TCBơ֥ ROMŪ) */
extern const H      tcbcnt;		/* TCBơ֥ο */

extern       T_QUE  rdyque[];	/* ǥ塼 */
extern const H      rdqcnt;		/* ǥ塼ο */

extern T_TCB  *curtcb;			/* ߤΥTCB */
extern BOOL   dlydsp;			/* ٱ䤵Ƥǥѥå뤫 */

extern       T_SPCB  spcbtbl[];		/* SPCBơ֥ RAM */
extern const T_SPCBS spcbstbl[];	/* SPCBơ֥ ROMŪ) */
extern const H       spcbcnt;		/* SPCBơ֥ο */


/* ------------------------------------ */
/*             ؿ                 */
/* ------------------------------------ */

/* 塼 */
void __adt_que(T_QUE *que, T_TCB *tcb);		/* 򥭥塼ɲ */
void __adh_que(T_QUE *que, T_TCB *tcb);		/* 򥭥塼Ƭɲ */
void __ins_que(T_TCB *tcbs, T_TCB *tcbd);	/* 塼˥ */
void __del_que(T_TCB *tcb);					/* 򥭥塼鳰 */
void __rot_que(T_QUE *que);					/* 塼βž */

/*  */
void __ini_tsk(void);						/* ν */
ER   sta_tsk(ID tskid, INT stacd);			/* ư */
void ext_tsk(void);							/* λ */
ER   ter_tsk(ID tskid);						/* ¾λ */
ER   dis_dsp(void);							/* ǥѥåػ */
ER   ena_dsp(void);							/* ǥѥå */
ER   chg_pri(ID tskid, PRI tskpri);			/* ͥѹ */
ER   rot_rdq(PRI tskpri);					/* Υǥ塼ž */
ER   rel_wai(ID tskid);						/* ¾Ԥֲ */
ER   get_tid(ID *p_tskid);					/* ID */
ER   ref_tsk(T_RTSK *pk_rtsk, ID tskid);	/* ֻ */

/* Ω */
#define ista_tsk  sta_tsk
#define iter_tsk  ter_tsk
#define ichg_pri  chg_pri
#define irot_rdq  rot_rdq
#define irel_wai  rel_wai
#define iget_tid  get_tid
#define iref_tsk  ref_tsk


/* °Ʊ */
ER   sus_tsk(ID tskid);
ER   rsm_tsk(ID tskid);
ER   frsm_tsk(ID tskid);
ER   slp_tsk(void);
ER   wup_tsk(ID tskid);
ER   can_wup(ID tskid);

/* Ω */
#define isus_tsk  sus_tsk
#define irsm_tsk  rsm_tsk
#define ifrsm_tsk frsm_tsk
#define iwup_tsk  wup_tsk
#define ican_wup  can_wup


/* ǥѥå */
ER   __tsk_dsp(void);					/* ǥѥå */
void __wup_dsp(T_TCB *tcb, ER ercd);	/* Ԥֲ */
H    __swc_dsp(T_TCB *tcb);				/* ڤؤ */
void __sta_dsp(T_TCB *tcb);				/* γϡʥ꥿󤷤ʤ) */
H    __end_dsp(void);					/* νλ */
void __tskst_entry(void);				/* ¹ԳϾ */
void __tsk_hlt(void);					/* ¹ԥʤ */


/*  */
void __di(void);	/* ߶ػ */
void __ei(void);	/* ߵ */
void __set_imsk(void);  	/* ߶ػ */
void __res_imsk(void);		/* loc_cpuƤʤг */

#endif /* __HOS__TAKS_H_ */
