/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ¸إå                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__mknl_h__
#define __HOS_V4__mknl_h__



#include "itron.h"
#include "hosdenv.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* ͥ٤ϰ */
#define TMIN_TPRI			1					/* ͥ٤κǾ */
#define TMAX_TPRI			(TMIN_TPRI + mknl_rdq_cnt - 1)
												/* ͥ٤κ */


/* ƥξ */
#define MKNL_TSS_TSK		0x00				/* ¹ */
#define MKNL_TSS_INDP		0x04				/* Ω¹ */
#define MKNL_TSS_DDSP		0x01				/* ǥѥåػ (dis_dsp ͭ) */
#define MKNL_TSS_DINT		0x02				/* ߶ػ(loc_cpu ͭ) */
#define MKNL_TSS_DDLY		0x80				/* ǥѥåٱ */

/* 㳰 */
#define MKNL_TTS_RDLY		0x01				/* 㳰α */
#define MKNL_TTS_DRAS		0x02				/* 㳰ػ߾ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* 塼֥å */
typedef struct t_mknl_que
{
	struct t_mknl_tcb *head;	/* 塼Ƭ */
} T_MKNL_QUE;


/* ̥ͥ ȥ֥å */
typedef struct t_mknl_tcb
{
	T_HOSPAC_CTXINF   ctxinf;		/* ƥȾ¸֥å */
	STAT              tskwait;		/* Ԥװ */
	UB                tskstat;		/* ξ */
	UB                texstat;		/* 㳰ξ */
	PRI               tskpri;		/* ߤͥ */
	ER_UINT           ercd;			/* Ԥװѥ顼 */
	VP_INT            data;			/* ѥǡΰ */
	struct t_mknl_que *que;			/* °Ƥ륭塼  */
	struct t_mknl_tcb *next;		/* 塼ǤμTCB */
	struct t_mknl_tcb *prev;		/* 塼ǤTCB */
	struct t_mknl_tcb *tm_next;		/* ॢȥ塼μTCB */
	struct t_mknl_tcb *tm_prev;		/* ॢȥ塼TCB */
	RELTIM            diftim;		/* ľTCBȤΥॢȤޤǤλֺ */
} T_MKNL_TCB;


/* ॢȴѹ¤ */
typedef struct t_mknl_timout
{
	T_MKNL_TCB *mtcb;		/* ॢԤΥ */
	RELTIM     diftim;		/* ľԤȤλֺ */
} T_MKNL_TIMOUT;



/* ------------------------------------------ */
/*              ѿ                  */
/* ------------------------------------------ */

/* ƥ */
extern STAT            mknl_ctx_stat;		/* ƥΥƥȾ */
extern T_MKNL_TCB      *mknl_run_mtcb;		/* ¹楿ȥ֥å */

/* ɥ롼״ */
extern T_HOSPAC_CTXINF mknl_idlctx;			/* ɥ롼פΥƥ */
extern const VP        mknl_idl_stk;		/* ɥ롼פΥå */
extern const SIZE      mknl_idl_stksz;		/* ɥ롼פΥå */

/*  */
extern T_MKNL_QUE      mknl_rdq_tbl[];		/* ǥ塼ơ֥ */
extern const INT       mknl_rdq_cnt;		/* ǥ塼Ŀ */

extern       INT       mknl_timout_tskcnt;	/* ॢԤΥĿ */

/* ॢȴ */
extern T_MKNL_TCB      *mknl_timout_head;	/* ॢȥ塼Ƭ */


/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ̥ͥΥӥϸ§ mknl_sys_loc()  */
/* å줿֤ǸƤӽФ뤳                 */

/* ƥ */
void    mknl_ini_sys(void);									/* ̥ͥ륷ƥν */
void    mknl_sta_startup(void);								/* ȥåץ롼γϽ */
void    mknl_ext_startup(void);								/* ȥåץ롼νλ */
void    mknl_exe_sys(FP exec, VP_INT exinf);				/* */
void    mknl_idl_loop(void);								/* ɥ롼 */

/*  */
#define mknl_ini_tsk(mtcb)	do { (mtcb)->tskstat = TTS_DMT; } while (0)
															/* ν(ޥؿ) */
void    mknl_sta_tsk(T_MKNL_TCB *mtcb, VP_INT exinf,
							FP task, PRI tskpri,
							SIZE stksz, VP stk);			/* γ */
void    mknl_ter_tsk(T_MKNL_TCB *mtcb);						/* νλ */
void    mknl_chg_pri(T_MKNL_TCB *mtcb, PRI tskpri);			/* ͥѹ */
void    mknl_wai_tsk(T_MKNL_TCB *mtcb, STAT tskwait);		/* Ԥ */
void    mknl_wup_tsk(T_MKNL_TCB *mtcb, ER_UINT ercd);		/* Ԥ */
void    mknl_sus_tsk(T_MKNL_TCB *mtcb);						/* ζԤ */
void    mknl_rsm_tsk(T_MKNL_TCB *mtcb);						/* ζԤ */
void    mknl_rot_rdq(PRI tskpri);							/* ̤ͥβž */
ER_UINT mknl_exe_dsp(void);									/* ǥѥåμ¹ */
void    mknl_dly_dsp(void);									/* ٱ䤷Ƥǥѥåμ¹ */
T_MKNL_TCB* mknl_srh_top(void);								/* ǥ塼ƬΥõ */
#define mknl_get_run_tsk()		(mknl_run_mtcb)				/* ¹楿μ(ޥؿ) */
#define mknl_get_pri(mtcb)		((PRI)(mtcb)->tskpri)		/* ͥټ(ޥؿ) */
#define mknl_get_tskstat(mtcb)	((STAT)(mtcb)->tskstat)		/* ּ(ޥؿ) */
#define mknl_get_tskwait(mtcb)	((STAT)(mtcb)->tskwait)		/* Ԥװ(ޥؿ) */

void    kernel_task_entry(VP_INT exinf);					/* Υȥ꡼ݥ(ͥ¦Ѱդ뤳) */


/* 㳰 */
void    mknl_ras_tex(T_MKNL_TCB *mtcb);						/* 㳰׵ */
void    mknl_exe_tex(void);									/* 㳰μ¹ */
#define mknl_dis_tex(mtcb)	\
	do { (mtcb)->texstat |= MKNL_TTS_DRAS; } while (0)		/* 㳰ζػ */
#define mknl_ena_tex(mtcb)	\
	do { (mtcb)->texstat &= ~MKNL_TTS_DRAS; } while (0)		/* 㳰ε */
#define mknl_sns_tex()	\
	((mknl_run_mtcb == NULL || (mknl_run_mtcb->texstat & MKNL_TTS_DRAS)) ? TRUE: FALSE)
															/* 㳰ػ߾֤λ */

void    kernel_tex_entry(void);								/* 㳰ȥ꡼ݥ(ͥ¦Ѱդ뤳) */


/* ƥ */
#define mknl_loc_sys()	\
	do { if ( !(mknl_ctx_stat & MKNL_TSS_DINT) ) { hospac_dis_int(); } } while (0)
															/* ƥΥå(ޥؿ) */
#define mknl_unl_sys()	\
	do { if ( !(mknl_ctx_stat & MKNL_TSS_DINT) ) { hospac_ena_int(); } } while (0)
															/* ƥΥå(ޥؿ) */
#define mknl_dis_int()	do { hospac_dis_int(); } while (0)	/* ߶ػ */
#define mknl_ena_int()	do { hospac_ena_int(); } while (0)	/* ߵ */
#define mknl_sta_ind()	do { mknl_ctx_stat |= MKNL_TSS_INDP; } while (0)
															/* 󥿥γ(ޥؿ) */
#define mknl_ext_ind()	do { mknl_ctx_stat &= ~MKNL_TSS_INDP; } while (0)
															/* 󥿥νλ(ޥؿ) */
#define mknl_loc_cpu()	do { mknl_ctx_stat |= MKNL_TSS_DINT; } while (0)
															/* CPUΥå(ޥؿ) */
#define mknl_unl_cpu()	do { mknl_ctx_stat &= ~MKNL_TSS_DINT; } while (0)
															/* CPUΥå(ޥؿ) */
#define mknl_dis_dsp()	do { mknl_ctx_stat |= MKNL_TSS_DDSP; } while (0)
															/* ǥѥåζػ(ޥؿ) */
#define mknl_ena_dsp()	do { mknl_ctx_stat &= ~MKNL_TSS_DDSP; } while (0)
															/* ǥѥåε(ޥؿ) */
#define mknl_sns_ctx()	((mknl_ctx_stat & MKNL_TSS_INDP) ? TRUE : FALSE)
															/* ƥȤλ(ޥؿ) */
#define mknl_sns_loc()	((mknl_ctx_stat & MKNL_TSS_DINT) ? TRUE : FALSE)
															/* CPUå֤λ(ޥؿ) */
#define mknl_sns_dsp()	((mknl_ctx_stat & MKNL_TSS_DDSP) ? TRUE : FALSE)
															/* ǥѥåػ߾֤λ(ޥؿ) */
#define mknl_sns_dpn()	((mknl_ctx_stat & MKNL_TSS_DDLY) ? TRUE : FALSE)
															/* ǥѥåα֤λ(ޥؿ) */
#define mknl_sns_wai()	((mknl_ctx_stat & (MKNL_TSS_INDP | MKNL_TSS_DDSP | MKNL_TSS_DINT)) ? TRUE : FALSE)
															/* ԤְܹԲǽ(ޥؿ) */


/* 塼 */
#define mknl_ini_que(que)	do { (que)->head = NULL; } while (0)
void    mknl_clr_que(T_MKNL_QUE *que);						/* 塼κ */
															/* 塼ν */
void    mknl_add_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb, ATR atr);
															/* 򥭥塼ɲ */
void    mknl_adf_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb);	/* FIFOǥ塼ɲ */
void    mknl_adp_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb);	/* ͥٽǥ塼ɲ */
void    mknl_rmv_que(T_MKNL_TCB *mtcb);						/* 򥭥塼 */
void    mknl_rot_que(T_MKNL_QUE *que);						/* ǥ塼βž */
#define mknl_ref_qhd(que)	((que)->head)					/* 塼Ƭλ(ޥؿ) */
#define mknl_ref_nxt(que, mtcb)		\
		((mtcb)->next != (que)->head ? (mtcb)->next : NULL)	/* Υ塼 */

/* ॢԤ */
void    mknl_tic_tmout(RELTIM tictim);						/* ॢȤ˥ƥå */
ER      mknl_add_tmout(T_MKNL_TCB *mtcb, RELTIM tmout);		/* ॢԤ˥ɲ */
void    mknl_rmv_tmout(T_MKNL_TCB *mtcb);					/* ॢԤ󤫤饿 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__mknl_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
