/********************************************************************************/
/*	Hyper Operating System V4  ץץ								*/
/*		OS 																*/
/*																				*/
/*										Copyright (C) 1998-2008 by Project HOS	*/
/*										http://sourceforge.jp/projects/hos/		*/
/********************************************************************************/
#pragma		ioreg

#include	"kernel.h"
#include	"kernel_id.h"
#include	"ostimer.h"
#include	<stdio.h>

#if 1	// 1 == WDTI OSޤˤ롣 0 == TMM OSޤˤ롣
/*
 *	OSѥ޽
 *		INTWTI, INTWT ѤƤޤ
 *		include/v850es/vect.h  vectasm.inc ˤƥ٥ֹƤޤ
 */
void	ostim_init(VP_INT exinf)
{
	WTM		= 0x00;					/* WT ȥå								*/
	PRSM0	= 0x00;					/* fBRG=fx(5MHz, 200nsec.)					*/
	PRSCM0	= 0x4D;					/* ץꥹ쥸 = 5MHz/32.768kHz/2	*/
	WTIC	= 0x47;					/* ߥ٥ 7							*/
	WTIIC	= 0x41;					/* ߥ٥ 1							*/
	WTM		|= 0x08;				/* ѥե饰Υå 2^5/fBRG			*/
	WTM		|= 0x90;				/* 󥿥Х륿ޥץꥹ 2^5/fBRG	*/
	BGCE0	= 1;					/* ץư						*/
	WTIF	= 0;					/* WTIF ꥢ								*/
	WTMK	= 1;					/* WT ߶ػ							*/
	WTIIF	= 0;					/* WTIIF ꥢ								*/
	WTIMK	= 0;					/* WTI ߵ							*/
	WTM		|= 0x03;
}
void	wdt_hdr(VP_INT exinf)
{
	WTIF	= 0;					/* WTIF ꥢ								*/
}
/*
 *	OSѥϥɥ
 */
void	ostim_hdr(VP_INT exinf)
{
	WTIIF	= 0;					/* WTIIF ꥢ								*/
	isig_tim();						/* ƥåζ						*/
#ifdef	DEBUG
	PCT.6 ^= 1;						/* LED1ȿž	(InterfaceϿ)			*/
#endif
}
#else
/*
 *	OSѥ޽
 *		INTTM0 󥿤ѤƤޤ
 *		include/v850es/vect.h  vectasm.inc ˤƥ٥ֹƤޤ
 */
void	ostim_init(VP_INT exinf)
{
	TM0CE		= 0;				/* TM0CTL0.7TMM0ưػ					*/
	TM0EQIC0	= 0x41;				/* INTTM0EQ0ͥ٥롧1				*/
	TM0CTL0		= 0x02;				/* ȡåꡧfxx/4		*/
	TM0CMP0		= (1000*20/4)-1;	/* 󥿡Х֡1msec					*/
	TM0EQMK0	= 0;				/* INTTM0 ߵ						*/
	TM0CE		= 1;				/* TMM0 󥿡Х륿ư			*/
}
/*
 *	OSѥϥɥ
 */
void	ostim_hdr(VP_INT exinf)
{
	isig_tim();						/* ƥåζ						*/
#ifdef	DEBUG
	PCT.6 ^= 1;						/* LED1ȿž	(InterfaceϿ)			*/
#endif
}
#endif
/*	---------------------------------------------------------------------------	*/
/*										Copyright (C) 1998-2008 by Project HOS	*/
/*										http://sourceforge.jp/projects/hos/		*/
/*	---------------------------------------------------------------------------	*/
