/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ϥɥ                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"



/* ϥɥΥޥϥɥ */
void kernel_cyc_hdr(
		T_KERNEL_TIM *timobj,	/* ޥ֥ */
		RELTIM       tic)		/* ƥå */
{
	const T_KERNEL_CYCCB_ROM *cyccb_rom;
	T_KERNEL_CYCCB_RAM *cyccb_ram;
	
	/* upper cast */
	cyccb_ram = (T_KERNEL_CYCCB_RAM *)timobj;
	
	/* μ¹ */
	if ( cyccb_ram->lefttim <= tic )
	{
		cyccb_rom = cyccb_ram->cyccb_rom;
				
		/* ͤ */
		cyccb_ram->lefttim += cyccb_rom->cyctim - tic;

		/* ϥɥƤӽФ */
		mknl_unl_sys();							/* ƥΥå */		
		cyccb_rom->cychdr(cyccb_rom->exinf);	/* ϥɥƤӽФ */
		mknl_loc_sys();							/* ƥΥå */
	}
	else
	{
		cyccb_ram->lefttim -= tic;
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
