/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Ĺ֥åγ(ॢȤ) */
ER tget_mpf(
		ID  mpfid,		/* ֥åоݤθĹסIDֹ */
		VP  *p_blk,		/* ֥åƬ */
		TMO tmout)		/* ॢȻ */
{
	const T_KERNEL_MPFCB_ROM *mpfcb_rom;
	T_KERNEL_MPFCB_RAM       *mpfcb_ram;
	T_MKNL_TCB *mtcb;
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( tmout != TMO_POL &&  mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	if ( mpfcb_ram->free != NULL )
	{
		/* ֥åгƤ */
		*p_blk          = mpfcb_ram->free;
		mpfcb_ram->free = *(VP *)mpfcb_ram->free;	/* ζꥢ */
		ercd = E_OK;
	}
	else
	{
		if ( tmout == TMO_POL )
		{
			/* ݡ󥰤ʤ¨ॢ */
			ercd = E_TMOUT;
		}
		else
		{
			/* ֥å̵Ԥ */
			mpfcb_rom = mpfcb_ram->mpfcb_rom;
			mtcb = mknl_get_run_tsk();
			mknl_wai_tsk(mtcb, TTW_MPF);
			mknl_add_que(&mpfcb_ram->que, mtcb, mpfcb_rom->mpfatr);	/* Ԥɲ */
			
			/* ̵ԤǤʤХॢ */
			if ( tmout != TMO_FEVR )
			{
				mknl_add_tmout(mtcb, (RELTIM)tmout);	/* ॢȥ塼ɲ */
			}
			
			ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
			
			if ( ercd == E_OK )
			{
				*p_blk = (VP)mtcb->data;	/* ֥åƬϳǼ */
			}
			
			mknl_exe_tex();		/* 㳰μ¹ */
		}
	}
	
	mknl_unl_sys();		/* ƥΥå */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
