/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpl.h"



/* Ĺ֥åγ(ݡ) */
ER pget_mpl(
		ID mplid,		/* ֥åоݤβĹסIDֹ */
		UINT blksz,		/* ֥åΥ(Хȿ) */
		VP *p_blk)		/* ֥åƬ */
{
	T_KERNEL_MPLCB_RAM *mplcb_ram;
	VP mem;
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mplid < KERNEL_TMIN_MPLID || mplid > KERNEL_TMAX_MPLID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mplcb_ram = KERNEL_MPLID_TO_MPLCB_RAM(mplid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mplcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ݤ˥ȥ饤 */
	mem = kernel_alc_hep(&mplcb_ram->hep, blksz);

	if ( mem != NULL )
	{
		/*  */
		*p_blk          = mem;
		ercd = E_OK;
	}
	else
	{
		/* ֥å̵Хॢ */
		ercd = E_TMOUT;
	}

	mknl_unl_sys();		/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
