/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ƥִ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sys.h"



/* ̤ͥβž */
ER rot_rdq(
		PRI tskpri)		/* ̤ͥžоݤͥ */
{
	T_MKNL_TCB* mtcb;

	/* ͥٻν */
	if ( tskpri == TPRI_SELF )
	{
#ifdef HOS_ERCHK_E_PAR
		if ( sns_ctx() )
		{
			return E_PAR;
		}
		mtcb   = mknl_get_run_tsk();	/* ¹楿μ */
		tskpri = mknl_get_pri(mtcb);	/* ͥ٤μ */
#endif
	}

	/* ѥ᡼ϰϥå */
#ifdef HOS_ERCHK_E_PAR
	if ( tskpri < TMIN_TPRI ||  tskpri > TMAX_TPRI )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();			/* ƥΥå */

	mknl_rot_rdq(tskpri);	/* ̤ͥβž */
	
	mknl_exe_dsp();			/* ǥѥåμ¹ */
	mknl_exe_tex();			/* 㳰μ¹ */
	
	mknl_unl_sys();			/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
