/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  shell_create.c
 * @brief %jp{}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "shell_local.h"



/* 󥿥饯ƥ֥⡼ */
int Shell_Interactive(C_SHELL *self)
{
	char				*pszHisBuf;
	int 				i;
	int					j;

	for ( ; ; )
	{
		/* ޥ */
		Shell_InputLine(self, self->pszCommanBuf, self->iCommandBufSize - 1);

		/* λ̵֤å */
		Shell_CheckBackGround(self);

		/* exit ʤȴ */
		if ( strcmp(self->pszCommanBuf, "exit") == 0 )
		{
			break;
		}

		/* ԤޤϥȤʤ̵ */
		if ( self->pszCommanBuf[0] == '\0' || self->pszCommanBuf[0] == '#' )
		{
			continue;
		}


		/* ҥȥ국 */
		if ( self->ppszHistory != NULL )
		{
			if ( (pszHisBuf = Memory_Alloc(strlen(self->pszCommanBuf) + 1)) != NULL )
			{
				strcpy(pszHisBuf, self->pszCommanBuf);

				/* ҥȥʣ */
				for ( i = 0; i < self->iHistoryMax; i++ )
				{
					if ( self->ppszHistory[i] != NULL && strcmp(self->ppszHistory[i], self->pszCommanBuf) == 0 )
					{
						Memory_Free(self->ppszHistory[i]);
						for ( j = i; j+1 < self->iHistoryMax; j++ )
						{
							self->ppszHistory[j] = 	self->ppszHistory[j+1];
						}
						self->ppszHistory[self->iHistoryMax-1] = NULL;
						break;
					}
				}
				
				/* ŤΤ */
				if ( self->ppszHistory[self->iHistoryMax-1] != NULL )
				{
					Memory_Free(self->ppszHistory[self->iHistoryMax-1]);
				}
				for ( i = self->iHistoryMax-1; i > 0; i-- )
				{
					self->ppszHistory[i] = self->ppszHistory[i-1];
				}
				
				/* ɲ */
				self->ppszHistory[0] = pszHisBuf;
			}
		}

		/* ޥɼ¹ */
		Shell_ExecuteCommand(self, self->pszCommanBuf);
	}
	
	return 0;
}


/* end of file */
