/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  shell.h
 * @brief %jp{}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__shell_local_h__
#define __HOS__shell_local_h__


#include "hosaplfw.h"


#define SHELL_MAX_COMMAND		256			/**< ǥեȤΥޥɥʸ */
#define SHELL_MAX_HISTORY		8			/**< ǥեȤΥҥȥ국 */



/** Хåɥִ¤ */
typedef struct t_shell_background
{
	struct t_shell_background	*pNext;
	HANDLE						hProcess;
} T_SHELL_BACKGROUND;


/** 륯饹 */
typedef struct c_shell
{
	int					iCurPos;			/**< ʸΰ */
	int					iCurScreenX;		/**< Υ꡼X */
	int					iScreenWidth;		/**< ꡼ */
	int					iCommandLen;		/**< ޥɤʸĹ */

	char				*pszCommanBuf;		/**< ޥɥ饤Хåե */
	char				**ppszHistory;		/**< ҥȥХåե */
	int					iCommandBufSize;	/**< ޥɥХåեΥ */
	int					iHistoryMax;		/**< ҥȥκĿ */

	char				ExecSimple;			/**< ñ¹ԥץ */
	char				ExecTime;			/**< ¹Իַ¬ץ */

	T_SHELL_BACKGROUND	*pBackGround;		/**< Хåɥץꥹ */
} C_SHELL;


#ifdef __cplusplus
extern "C" {
#endif

C_SHELL *Shell_Create(int iCommandBufSize, int iHistoryMax, int iExecSimple, int iExecTime);	/**<  */
void    Shell_Delete(C_SHELL *self);															/**<  */
int     Shell_Interactive(C_SHELL *self);														/**< 󥿥饯ƥ֥⡼ */
int     Shell_ExecuteScript(C_SHELL *self, const char *pszFileName);							/**< ץȼ¹ */
int     Shell_ExecuteCommand(C_SHELL *self, const char *pszCommand);							/**< ޥɼ¹ */
void	Shell_CheckBackGround(C_SHELL *self);													/**< ХåɤǽäΤ̵å */
int     Shell_InputLine(C_SHELL *self, char *pszBuf, int  iBufSize);							/**< 饤 */
void    Shell_PutChar(C_SHELL *self, int c);													/**< ʸ */
void    Shell_CurRight(C_SHELL *self);															/**< 뱦ư */
void    Shell_CurLeft(C_SHELL *self);															/**< 뺸ư */
void    Shell_ReplaceLine(C_SHELL *self, const char *pszNewLine);								/**< 饤֤ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__shell_local_h__ */


/* end of file */
