/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{LAN9000ѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"


/** %jp{} */
FILE_SIZE Lan9000Drv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_LAN9000DRV	*self;
	C_SYNCFILE		*pFile;
	FILE_SIZE		SendSize;
	unsigned short	uhStatus;
	FILE_ERR		ErrCode;
	
	/* upper cast */
	self  = (C_LAN9000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* ߽ */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_WRITE)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* ߥʥöꥢ */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
	
	for ( ; ; )
	{
		/*  */
		SysMtx_Lock(self->hMtx);		/* ƥ륻 */
		SendSize = Lan9000Hal_Send(&self->Lan9000Hal, pData, Size);
		SysMtx_Unlock(self->hMtx);		/* ƥ륻Ф */
		
		/* ʤȴ */
		if ( SendSize != 0 )
		{
			break;
		}

		/* ֥å󥰤ʤߵ */
		uhStatus = Lan9000Hal_GetInterruptStatus(&self->Lan9000Hal);
		Lan9000Hal_SetInterruptMask(&self->Lan9000Hal, (uhStatus | LAN9000HAL_IMASK_ALLOCINT));

		/* ֥å󥰥⡼ɤǤʤȴ */
		if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_WRITE) != FILE_SYNCMODE_BLOCKING )
		{
			SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, 0);
			return 0;
		}
			
		/* ߥʥԤ */
		SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_WRITE);
			
		/* ߥʥ򥯥ꥢƥȥ饤 */
		SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
	}

	/* ߽λ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)0);

	return SendSize;
}



/* end of file */
