/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ne2000hdl.c
 * @brief %jp{NE2000ߴEtherѥϡɥ}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "ne2000hal.h"


/* 쥸 */
#define NE2000HAL_WRITE_REG(self, addr, data)		do { (self)->pubRegBase[(addr)] = (data); } while(0)
#define NE2000HAL_READ_REG(self, addr)				((self)->pubRegBase[(addr)])


/* 쥸 */
#define NE2000HAL_REG_CR		0x00
#define NE2000HAL_REG_DMA		0x10
#define NE2000HAL_REG_RESET		0x18

#define NE2000HAL_REG_CLDA0		0x01
#define NE2000HAL_REG_CLDA1		0x02
#define NE2000HAL_REG_TSR		0x04
#define NE2000HAL_REG_NCR		0x05
#define NE2000HAL_REG_FIFO		0x06
#define NE2000HAL_REG_CRDA0		0x08
#define NE2000HAL_REG_CRDA1		0x09
#define NE2000HAL_REG_RSR		0x0c
#define NE2000HAL_REG_CNTR0		0x0d
#define NE2000HAL_REG_CNTR1		0x0e
#define NE2000HAL_REG_CNTR2		0x0f

#define NE2000HAL_REG_PSTART	0x01
#define NE2000HAL_REG_PSTOP		0x02
#define NE2000HAL_REG_BNRY		0x03
#define NE2000HAL_REG_TPSR		0x04
#define NE2000HAL_REG_TBCR0		0x05
#define NE2000HAL_REG_TBCR1		0x06
#define NE2000HAL_REG_ISR		0x07
#define NE2000HAL_REG_RSAR0		0x08
#define NE2000HAL_REG_RSAR1		0x09
#define NE2000HAL_REG_RBCR0		0x0a
#define NE2000HAL_REG_RBCR1		0x0b
#define NE2000HAL_REG_RCR		0x0c
#define NE2000HAL_REG_TCR		0x0d
#define NE2000HAL_REG_DCR		0x0e
#define NE2000HAL_REG_IMR		0x0f

#define NE2000HAL_REG_PAR0		0x01
#define NE2000HAL_REG_PAR1		0x02
#define NE2000HAL_REG_PAR2		0x03
#define NE2000HAL_REG_PAR3		0x04
#define NE2000HAL_REG_PAR4		0x05
#define NE2000HAL_REG_PAR5		0x06
#define NE2000HAL_REG_CURR		0x07
#define NE2000HAL_REG_MAR0		0x08
#define NE2000HAL_REG_MAR1		0x09
#define NE2000HAL_REG_MAR2		0x0a
#define NE2000HAL_REG_MAR3		0x0b
#define NE2000HAL_REG_MAR4		0x0c
#define NE2000HAL_REG_MAR5		0x0d
#define NE2000HAL_REG_MAR6		0x0e
#define NE2000HAL_REG_MAR7		0x0f


/* ؿ */
void Ne2000Hal_ReadPhysicalAddr(C_NE2000HAL *self, unsigned char ubPhysicalAddr[6]);					/* %jp{ʪɥ쥹ɤ߽Ф} */
void Ne2000Hal_ReadMem(C_NE2000HAL *self, void *pBuf, int iAddr, int iSize);							/* %jp{⡼DMAɤ߽Ф} */
void Ne2000Hal_WriteMem(C_NE2000HAL *self, const void *pData, int iAddr, int iDataSize, int iDmySize);	/* %jp{⡼DMA񤭹} */


/** 󥹥ȥ饯 */
void Ne2000Hal_Create(C_NE2000HAL *self, void *pRegAddr)
{
	self->pubRegBase = (volatile unsigned char *)pRegAddr;
	memset(self->ubPhysicalAddr, 0, sizeof(self->ubPhysicalAddr));
}

/** ǥȥ饯 */
void Ne2000Hal_Delete(C_NE2000HAL *self)
{
}


/** %jp{} */
void Ne2000Hal_Setup(C_NE2000HAL *self)
{
	/* %jp{եȥꥻå} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RESET, NE2000HAL_READ_REG(self, NE2000HAL_REG_RESET));
	
	/* %jp{CR} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x21);
	
	/* %jp{DCR} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_DCR, 0xc2);
	
	/* %jp{⡼DMAžꥢ} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR0, 0);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR1, 0);
	
	/* %jp{˥⡼ɤˤ} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RCR, 0x20);
	
	/* %jp{롼ץХå⡼ɤˤ} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_TCR, 0x02);
	
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_TPSR, 0x40);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PSTART, 0x46);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_BNRY, 0x46);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PSTOP, 0x60);
	
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_IMR, 0x00);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_ISR, 0xff);
	
	/* %jp{ʪɥ쥹ɤ߽Ф} */
	Ne2000Hal_ReadPhysicalAddr(self, self->ubPhysicalAddr);
	
	/* %jp{ʪɥ쥹} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x61);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR0, self->ubPhysicalAddr[0]);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR1, self->ubPhysicalAddr[1]);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR2, self->ubPhysicalAddr[2]);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR3, self->ubPhysicalAddr[3]);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR4, self->ubPhysicalAddr[4]);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_PAR5, self->ubPhysicalAddr[5]);
	
	/* %jp{ѥåȳǼɥ쥹} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CURR, 0x47);
	
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x21);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RCR, 0x04);
	
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_TCR, 0);
}


/*  */
void Ne2000Hal_Stop(C_NE2000HAL *self)
{
}


/** %jp{ʪɥ쥹ɤ߽Ф} */
void Ne2000Hal_ReadPhysicalAddr(C_NE2000HAL *self, unsigned char ubPhysicalAddr[6])
{
	unsigned char ubDmy;
	int i;
	
	/* %jp{žХȿ(12Х)} */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR0, 12);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR1, 0);
	
	/* DMAžɥ쥹 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR0, 0);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR1, 0);
	
	/* DMA */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x0a);
	
	/* ϤɤФ */
	for ( i = 0; i < 6; i++ )
	{
		ubPhysicalAddr[i] = NE2000HAL_READ_REG(self, NE2000HAL_REG_DMA);
		ubDmy             = NE2000HAL_READ_REG(self, NE2000HAL_REG_DMA);
	}
}


/* ⡼DMAɤ߽Ф */
void Ne2000Hal_ReadMem(C_NE2000HAL *self, void *pBuf, int iAddr, int iSize)
{
	unsigned char *pubBuf;
	int i;
	
	pubBuf = (unsigned char *)pBuf;
	
	/* ڡ0 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	
	/* DMA */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR0, (iSize >> 0) & 0xff);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR1, (iSize >> 8) & 0xff);
	
	/* DMAɥ쥹 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR0, (iAddr >> 0) & 0xff);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR1, (iAddr >> 8) & 0xff);
	
	/* DMA */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x0a);
	
	/* ǡФ */
	for ( i = 0; i < iSize; i++ )
	{
		*pubBuf++ = NE2000HAL_READ_REG(self, NE2000HAL_REG_DMA);
	}
}

/* ⡼DMA񤭹 */
void Ne2000Hal_WriteMem(C_NE2000HAL *self, const void *pData, int iAddr, int iDataSize, int iDmySize)
{
	const unsigned char *pubData;
	int iSize;
	int i;
	
	pubData = (unsigned char *)pData;
	
	/* ڡ0 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	
	/* ISRDMAӥåȥꥢ */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_ISR, 0x40);
	
	/* DMA */
	iSize = iDataSize + iDmySize;
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR0, (iSize >> 0) & 0xff);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RBCR1, (iSize >> 8) & 0xff);
	
	/* DMAɥ쥹 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR0, (iAddr >> 0) & 0xff);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_RSAR1, (iAddr >> 8) & 0xff);
	
	/* DMA */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x12);
	
	/* ǡ񤭹 */
	for ( i = 0; i < iDataSize; i++ )
	{
		NE2000HAL_WRITE_REG(self, NE2000HAL_REG_DMA, *pubData++);
	}
	
	/* ߡǡ񤭹 */
	for ( i = 0; i < iDmySize; i++ )
	{
		NE2000HAL_WRITE_REG(self, NE2000HAL_REG_DMA, 0);
	}
	
	/* DMAλԤ */
	while ( !(NE2000HAL_READ_REG(self, NE2000HAL_REG_ISR) & 0x40) )
		;
}



/* %jp{Υڡɥ쥹} */
unsigned char Ne2000Hal_GetNextPage(C_NE2000HAL *self, unsigned char ubPtr)
{
	if ( ubPtr >= 0x5f )
	{
		return 0x46;
	}
	return ubPtr + 1;
}


/* ѥåȼ */
int Ne2000Hal_Recv(C_NE2000HAL *self, void *pBuf, int iSize)
{
	unsigned char *pubBuf;
	unsigned char ubBnry;
	unsigned char ubCurr;
	unsigned char ubRead;
	unsigned char ubHeader[4];
	int           iReadAddr;
	int           iPacketSize;
	int           iPStopSize;
	
	pubBuf = (unsigned char *)pBuf;
	
	/* BNRYɤ߽Ф */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	ubBnry = NE2000HAL_READ_REG(self, NE2000HAL_REG_BNRY);
	
	/* CURRɤ߽Ф */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x42);
	ubCurr = NE2000HAL_READ_REG(self, NE2000HAL_REG_CURR);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	
	/* ɤ߽Ф */
	ubRead = Ne2000Hal_GetNextPage(self, ubBnry);
	
	/* ḁ̇̄å */
	if ( ubRead == ubCurr )
	{
		return 0;
	}
	
	iReadAddr = ubRead * 256;
	
	/* إåɤ߽Ф */
	Ne2000Hal_ReadMem(self, ubHeader, iReadAddr, 4);
	iReadAddr += 4;
	
	/* إå饵ɤ߽Ф */
	iPacketSize = ubHeader[2] + (ubHeader[3] << 8);
	
	/* ޤ֤֤ޤǤΥ */
	iPStopSize = 0x6000 - iReadAddr;
	
	if ( (ubHeader[0] & 1) && iPacketSize <= iSize )	/* ʤ */
	{
		if ( iPacketSize <= iPStopSize )
		{
			Ne2000Hal_ReadMem(self, pubBuf, iReadAddr, iPacketSize);
			iReadAddr += iPacketSize - 1;
		}
		else
		{
			Ne2000Hal_ReadMem(self, pubBuf, iReadAddr, iPStopSize);
			pubBuf    += iPStopSize;
			iReadAddr  = 0x4000;
			Ne2000Hal_ReadMem(self, pubBuf, iReadAddr, iPacketSize - iPStopSize);
			iReadAddr += (iPacketSize - iPStopSize) - 1;
		}
	}
	else	/* ۾ʤ */
	{
		/* ɤ߼ΤƤƥݥ󥿤Τ߿ʤ */
		if ( iPacketSize <= iPStopSize )
		{
			iReadAddr += iPacketSize - 1;
		}
		else
		{
			iReadAddr = 0x4000 + (iPacketSize - iPStopSize) - 1;
		}
		iPacketSize = 0;
	}
	
	/* ݥ󥿤򹹿 */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_BNRY, ((iReadAddr >> 8) & 0xff));
	
	return iPacketSize;
}



/* ѥå */
int Ne2000Hal_Send(C_NE2000HAL *self, const void *pData, int iSize)
{
	int iDmySize;
	int iSendSize;
	
	/* TXPӥåȥå */
	if ( NE2000HAL_READ_REG(self, NE2000HAL_REG_CR) & 0x04 )
	{
		return 0;
	}
	
	if ( iSize >= 60 )
	{
		iDmySize  = 0;				/* ߡʤ */
		iSendSize = iSize + 4;		/* FCSΥû */
	}
	else
	{
		iDmySize  = 60 - iSize;		/* ƥΰ٥ߤ褻60ХȤޤ0᤹ */
		iSendSize = 64;				/*  */
	}
	
	/* 񤭹 */
	Ne2000Hal_WriteMem(self, pData, 0x4000, iSize, iDmySize);
	
	/*  */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x22);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_TBCR0, (iSendSize >> 0) & 0xff);
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_TBCR1, (iSendSize >> 8) & 0xff);
	
	/*  */
	NE2000HAL_WRITE_REG(self, NE2000HAL_REG_CR, 0x26);

	return iSendSize;
}


/* end of file */
